#ifndef _SEG_LCD_H_
#define _SEG_LCD_H_

#include "PWM.h"
#include "BU98R10.H"
#include "System_Status_Monitor.h" 

/******************************************************************************

******************************************************************************/
#define   SEG_7A                             BU98R10_0_SEG33
#define   SEG_7B                             BU98R10_0_SEG32
#define   SEG_7C                             BU98R10_0_SEG106
#define   SEG_7D                             BU98R10_0_SEG105
#define   SEG_7E                             BU98R10_0_SEG104
#define   SEG_7F                             BU98R10_0_SEG34
#define   SEG_7G                             BU98R10_0_SEG31

#define   SEG_6A                             BU98R10_0_SEG37
#define   SEG_6B                             BU98R10_0_SEG36
#define   SEG_6C                             BU98R10_0_SEG102
#define   SEG_6D                             BU98R10_0_SEG101
#define   SEG_6E                             BU98R10_0_SEG100
#define   SEG_6F                             BU98R10_0_SEG38
#define   SEG_6G                             BU98R10_0_SEG35

#define   SEG_5A                             BU98R10_0_SEG41
#define   SEG_5B                             BU98R10_0_SEG40
#define   SEG_5C                             BU98R10_0_SEG99
#define   SEG_5D                             BU98R10_0_SEG98
#define   SEG_5E                             BU98R10_0_SEG97
#define   SEG_5F                             BU98R10_0_SEG42
#define   SEG_5G                             BU98R10_0_SEG39

#define   SEG_4A                             BU98R10_0_SEG45
#define   SEG_4B                             BU98R10_0_SEG44
#define   SEG_4C                             BU98R10_0_SEG96
#define   SEG_4D                             BU98R10_0_SEG73
#define   SEG_4E                             BU98R10_0_SEG72
#define   SEG_4F                             BU98R10_0_SEG46
#define   SEG_4G                             BU98R10_0_SEG43

#define   SEG_3A                             BU98R10_0_SEG49
#define   SEG_3B                             BU98R10_0_SEG48
#define   SEG_3C                             BU98R10_0_SEG71
#define   SEG_3D                             BU98R10_0_SEG70
#define   SEG_3E                             BU98R10_0_SEG69
#define   SEG_3F                             BU98R10_0_SEG50
#define   SEG_3G                             BU98R10_0_SEG47

#define   SEG_2A                             BU98R10_0_SEG53
#define   SEG_2B                             BU98R10_0_SEG52
#define   SEG_2C                             BU98R10_0_SEG68
#define   SEG_2D                             BU98R10_0_SEG67
#define   SEG_2E                             BU98R10_0_SEG66
#define   SEG_2F                             BU98R10_0_SEG54
#define   SEG_2G                             BU98R10_0_SEG51

#define   SEG_1A                             BU98R10_0_SEG57
#define   SEG_1B                             BU98R10_0_SEG56
#define   SEG_1C                             BU98R10_0_SEG65
#define   SEG_1D                             BU98R10_0_SEG64
#define   SEG_1E                             BU98R10_0_SEG63
#define   SEG_1F                             BU98R10_0_SEG58
#define   SEG_1G                             BU98R10_0_SEG55

#define   SEG_DP                             BU98R10_0_SEG103

#define   SEG_TRIP                           BU98R10_0_SEG60
#define   SEG_AA                             BU98R10_0_SEG59
#define   SEG_BB                             BU98R10_0_SEG61
#define   SEG_KM                             BU98R10_0_SEG107
#define   SEG_ODO                            BU98R10_0_SEG62

#define   SEG_YX1                            BU98R10_0_SEG75
#define   SEG_CX                             BU98R10_0_SEG74
#define   SEG_T1                             BU98R10_0_SEG76
#define   SEG_T2                             BU98R10_0_SEG77
#define   SEG_T3                             BU98R10_0_SEG78
#define   SEG_T4                             BU98R10_0_SEG79
#define   SEG_T5                             BU98R10_0_SEG80
#define   SEG_T6                             BU98R10_0_SEG81
#define   SEG_T7                             BU98R10_0_SEG82
#define   SEG_T8                             BU98R10_0_SEG83
#define   SEG_T9                             BU98R10_0_SEG84
#define   SEG_T10                            BU98R10_0_SEG85
#define   SEG_T11                            BU98R10_0_SEG86
#define   SEG_T12                            BU98R10_0_SEG87

#define   SEG_YX2                            BU98R10_0_SEG89
#define   SEG_CX2                            BU98R10_0_SEG88
#define   SEG_AE                             BU98R10_0_SEG90
#define   SEG_K1                             BU98R10_0_SEG91
#define   SEG_K2                             BU98R10_0_SEG92
#define   SEG_K3                             BU98R10_0_SEG93
#define   SEG_K4                             BU98R10_0_SEG94
#define   SEG_K5                             BU98R10_0_SEG95

/******************************************************************************
״̬
******************************************************************************/
#define   SEG_LCD_LIGHT                     7
#define   SEG_LCD_GRAY                      1
#define   SEG_LCD_GRAY_light                0
#define   SEG_LCD_OFF                       0
#define   SEG_LCD_ON                        255

/******************************************************************************
Һʾݱݽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Brightness;
  uint8_t   Window;
  uint8_t   VSpeedSeg;
  uint8_t   ESpeedSeg;
  uint16_t  VSpeed;
  uint16_t  ESpeed; 
  uint32_t  ODONum; 
  uint16_t  Power ;
  uint16_t  Voltage ;
  uint16_t  Current ;
  uint16_t  Mileage ;
  uint8_t  SOCSeg ;
  uint8_t  InitPowerSeg ;
  uint8_t  RePowerSeg ;
  uint8_t  TotalPowerSeg ;
  
}SEGLCDBackupStruct;

/******************************************************************************
ͼ״̬ĴSEGLCDIconxxxStatusλ
================================================================
 Bit 7 | SEG_LCD_ICON_FORCE      | ǿʾ־
-------+-------------------------+------------------------------
 Bit 6 | Rsvd.                   | 
-------+-------------------------+------------------------------
 Bit 5 | Rsvd.                   | 
-------+-------------------------+------------------------------
 Bit 4 | Rsvd.                   | 
-------+-------------------------+------------------------------
 Bit 3 | Rsvd.                   | 
-------+-------------------------+------------------------------
 Bit 2 | Rsvd.                   | 
-------+-------------------------+------------------------------
 Bit 1 | SEG_LCD_ICON_FORCE_STAT | ǿʾ״̬ 1-ǿƵ 0-ǿϨ
-------+-------------------------+------------------------------
 Bit 0 | SEG_LCD_ICON_STAT       | ʾ״̬ 1- 0-Ϩ
================================================================
******************************************************************************/
#define  SEG_LCD_ICON_FORCE                 ((uint8_t)0x80)
#define  SEG_LCD_ICON_FORCE_STAT            ((uint8_t)0x02)
#define  SEG_LCD_ICON_STAT                  ((uint8_t)0x01)

/******************************************************************************
Icon״̬
******************************************************************************/
typedef enum
{
  SEG_LCD_ICON_OFF = 0,    //Ϩͼ
  SEG_LCD_ICON_ON,         //ͼ
  SEG_LCD_ICON_FORCE_OFF,  //ǿϨͼ,ͨ SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON ״̬ܿͼϨ
  SEG_LCD_ICON_FORCE_ON,   //ǿƵͼ,ͨ SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON ״̬ܿͼϨ
  SEG_LCD_ICON_FREE,       //ȡͼǿϨ,ͼ꽻 SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON ״̬ 
}SEGLCDIconStatusEnum;

/******************************************************************************

******************************************************************************/
void SEG_LCD_Init(void);
void SEG_LCD_Shutdown(void);
void SEG_LCD_Set_Brightness(uint8_t Br);

void SEG_LCD_Window_Switch(uint8_t Sw);
void SEG_LCD_Window_Control_Service(void);


/******************************************************************************
SEG_LCD_ODO_Speed_Num_Display
  : ܼʾ                                 
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Display(uint8_t DOD_TRIP_FLAG, uint32_t ODONum);
/******************************************************************************
SEG_LCD_ODO_Speed_Num_Off
  : ֹܼر                                  
******************************************************************************/
void SEG_LCD_ODO_Speed_Num_Off(void);
/******************************************************************************
SEG_LCD_FUEL_Seg_Display
  : ȼʾ                                   
******************************************************************************/
void SEG_LCD_FUEL_Seg_Display(uint8_t SegNum);
/******************************************************************************
SEG_LCD_FUEL_Seg_Off
  : ȼȫر                                   
******************************************************************************/
void SEG_LCD_FUEL_Seg_Off(void);
/******************************************************************************
SEG_LCD_ADBLUE_Seg_Display
  : ADBLUEʾ                                   
******************************************************************************/
void SEG_LCD_ADBLUE_Seg_Display(uint8_t SegNum);
/******************************************************************************
SEG_LCD_ADBLUE_Seg_Off    
  : ADBLUEȫر                                
******************************************************************************/
void SEG_LCD_ADBLUE_Seg_Off(void);

#endif 

