#include "TimeCapture.h"
/******************************************************************************
Function Name  : Allow_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Configures TIM1 to capture inputs.
******************************************************************************/
void Allow_Input_Capture(void)
{
  PTTRR_PTTRR1     = 1;   /* Route IOC1_7 to PR3                                     */
  TIM1_TSCR1_TEN   = 0;   /* Disable timer module before adjusting registers.        */
  TIM1_TIOS_IOS7   = 0;   /* Set Channel 7 as input capture.                         */
  TIM1_TCTL3_EDG7A = 1;   /* Set channel 7 to capture any edge transition.           */
  TIM1_TCTL3_EDG7B = 1;   /* Set channel 7 to capture any edge transition.           */
  TIM1_TIE_C7I     = 1;   /* Enable channel 7 interrupt, handled by function TIM1ISR.*/
  TIM1_TSCR1_TSWAI = 1;   /* Disables the timer module while in wait mode.           */
  TIM1_TSCR1_TSFRZ = 1;   /* Disables the timer counter while in freeze mode.        */
  TIM1_TSCR2_PR    = 0x6; /* Set prescaler to divide by 64.                          */
  TIM1_TSCR1_TEN   = 1;   /* Timer Enable.                                           */
}