#ifndef API_485TR_H_
#define API_485TR_H_

#include "TYW_stdint.h"
#include "../UART/UART.h"
#include "Barcode_Scanner.h"
#include "RTE_GPIO.h"
#define RS485_RX_BUF_LEN 1024 * 4
#define RS485_RX_DATA_LEN 64

#define RS485_RECEIVE_ID_0X48 0X48
#define RS485_RECEIVE_ID_0X49 0X49
#define RS485_RECEIVE_ID_0X4A 0X4A
#define RS485_RECEIVE_ID_0X45 0X45

typedef enum
{                  
    Data_Mode_Dot,                // 打点模式
    Data_Mode_Write,              // 写入模式
    Data_Mode_Read,               // 读取模式
    Data_Mode_Max,
} DEV_Data_Mode_t;

typedef enum
{
    // RS485_Tx_ID04_Idx = 0,
    RS485_Tx_ID80_Idx = 0,
    RS485_Tx_IDA4_Idx,
    RS485_Tx_IDD0_Idx,
    RS485_Tx_IDD1_Idx,
    RS485_Tx_IDD2_Idx,
    RS485_Tx_IDD3_Idx,
    // RS485_Tx_ID74_Idx,
    RS485_Tx_ID_Idx_Max,
}RS485_Receive_ID_Idx_en_t;

typedef enum
{

    RS485_Rx_ID40_Idx = 0,
    RS485_Rx_ID41_Idx,
    RS485_Rx_ID42_Idx,
    RS485_Rx_ID_Idx_Max,
}RS485_Transmit_ID_Idx_en_t;

typedef struct
{
    uint8_t RS485Data[RS485_RX_BUF_LEN - 1];
    uint8_t length;
} RS485DataPacket;


typedef enum
{
    R485_Normal = 0,
    R485_Lost = 0x55,
}_en_485_Rx_Status_t;

// RS485发送控制结构体（包含发送延迟计数等参数）
typedef struct 
{
    uint8_t delayCounter;
    uint8_t sendIndex;
    uint8_t Openble[20];
} RS485_TxControl_en_t;

extern RS485_TxControl_en_t RS485_TxControl;
typedef struct
{
    uint8_t u8RecVal[RS485_RX_DATA_LEN];
    uint8_t u8Received;
    uint8_t u8Status;
    uint16_t u16LostTime;
    uint8_t u8ReceivedFlag;
} RS485ValidDataPacket_st_t;
extern uint32_t RS485_send_time;
extern uint8_t RS485_TX_finish;
extern uint8_t BlueTooth;
extern uint8_t dianliangflag;
extern uint8_t sendmsgAll[8];
extern uint32_t R485_Send(const uint16_t cmdID, const uint8_t* pData, uint8_t len);
extern uint16_t Yadi_CAL_Data_Sum(uint8_t* pu8LinData, uint8_t u8LinLen);
extern uint8_t RS485_User_Tx_Data(void);
void backsend(void);
extern void TX_RX_485_service(void);
extern void Bluetoothname(void);
extern void ProcessBluetoothDeviceNameWithLock(void);
extern void BTEnableDelayPowerReset(void);
extern void AutoClearCounterAfterAllLit(void);
#endif /* API_ADC_H_ */
