/***********************************************************************
 * \file     Init.c
 * \brief    Initializations during work state switching
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     18-Jan-2019
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "r_device.h"
#include "rh850_macros.h"
#include "init.h"
#include "clock.h"
#include "Sys_Tick.h"
#include "Task_Scheduler.h"
#include "RTE_GPIO.h"
#include "TYW_stdint.h"
#include "COM_CAN.h"
#include "RTE_ADC.h"
#include "RTE_CAN.h"
#include "RTE_PWM.h"
#include "Internal_EEPROM.h"
#include "TimerB.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "WDT.h"
#include "RTC.h"
#include "GenDelay.h"
#include "TFT_LCD.h"
#include "RTE_WDT.h"
#include "CAN_Communication_Matrix.h"
#include "Check_Ctrl.h"
#include "Key.h"
#include "Display_Info.h"
#include "FreIn_User.h"
#include "../UART/UART.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/***********************************************************************
 * \brief      Initializations during work state switching
 * \attention
 * \retval     None
 ******************************************************************************/

// volatile CANMsg0F6Union      CANMsg0F6;

uint8_t u8StartupMode;
void    Sys_Startup_Pre_Init(void)
{
    Clock_Run_Mode_Init( );
}
/***********************************************************************
 * \brief      Initializations during system power up
 * \attention
 * \retval     None
 ******************************************************************************/
void Sys_Startup_Init(void)
{
    RTC_Pre_Init( );    //首次上电
    WDT_Init( );
    Sys_Tick_Timer_Call_Back_Reg(Sys_Process_ISR);
    RTE_GPIO_Init( );  

    GPIO_SET_KEPP( );
    RTE_ADC_Init( );
    // COM_CAN_Init( );
    // Can_Init( );
    enable_interrupt( );
    Sys_Tick_Timer_Start( );
    TFT_LCD_Startup( );
    Diag_Info_Init( );
    Display_Title_Info( );
    Key_Init( );
    Buzzer_Init();
    Fre_In_KL30_Wakeup_Init();
    menuFeedbackinit();
    UART_Channel_Config_st_t loc_config;
    loc_config.enUARTLINMode          = MODE_UART;
    loc_config.u32UARTbps             = 115200;
    loc_config.enUARTOrder            = UART_LSB;
    loc_config.en2UARTParity          = UART_PARITY_DISABLE;
    loc_config.en2UARTPolarity        = UART_POLARITY_NORMAL;
    loc_config.pfnUARTConfirmCallBack = 0;
    loc_config.pfnUARTErrHandleCallBack = 0;
    loc_config.pfnUARTReadMsgCallBack = UART_Put;
    UART_Init(UART_RLIN30, &loc_config);
    loc_config.enUARTLINMode          = MODE_UART;
    loc_config.u32UARTbps             = 9600;
    loc_config.enUARTOrder            = UART_LSB;
    loc_config.en2UARTParity          = UART_PARITY_DISABLE;
    loc_config.en2UARTPolarity        = UART_POLARITY_NORMAL;
    loc_config.pfnUARTConfirmCallBack = 0;
    loc_config.pfnUARTErrHandleCallBack = 0;
    loc_config.pfnUARTReadMsgCallBack = UART_Put1;
    UART_Init(UART_RLIN31, &loc_config);
    loc_config.enUARTLINMode          = MODE_UART;
    loc_config.u32UARTbps             = 115200;
    loc_config.enUARTOrder            = UART_LSB;
    loc_config.en2UARTParity          = UART_PARITY_DISABLE;
    loc_config.en2UARTPolarity        = UART_POLARITY_NORMAL;
    loc_config.pfnUARTConfirmCallBack = 0;
    loc_config.pfnUARTErrHandleCallBack = 0;
    loc_config.pfnUARTReadMsgCallBack = UART_Put2;
    UART_Init(UART_RLIN32, &loc_config);
    LINE_OUT_NEG_01 = 1;
    LINE_OUT_NEG_02 = 1;
    LINE_OUT_NEG_03 = 1;
    LINE_OUT_NEG_04 = 1; 

    //关闭正控，电路不支持防止烧坏电路
    NEG_10_Ctrl = 0;             //左转向输出
    LINE_OUT_POS_10 = 0;         //右转向输出
    LINE_OUT_NEG_06 = 0;         //位置灯输出
    oldhighlight = 0;            //old远光输出
    oldlowlight = 0;             //old近光输出

    EN_5V_CUT_ENABLE = 1;
    
    // Display_TFT_Clear();
    // GUI_Display_Version_Code_Service(25, 20, "Please   Scan   The   Code ", Letter_Num_11, PCodeText_Space_size);

    /*上电扫码校验功能如果需要扫码校验注释掉firstpowerflag = 2，saomafinish = 3;打开上面两行的注释即可*/
    firstpowerflag = 2;
    saomafinish = 4;
}

/***********************************************************************
 * \brief      Initializations during work state switch to system sleep
 * \attention
 * \retval     None
 ******************************************************************************/
void Sys_Sleep_Init(void)
{
}

/***********************************************************************
 * \brief      Initializations during work state switch to system run
 * \attention
 * \retval     None
 ******************************************************************************/
void System_Wakeup_Init(void)
{
}
