#ifndef UART_H__
#define UART_H__
/*-----------------use for RH850_F1KM_S1 --------------------*/
//#include "dr7f701684.dvf.h"
#include "r_typedefs.h"

/***************************************************************/
/***************************************************************/

typedef enum
{
    UART_RLIN30 = 0U,
    UART_RLIN31,
    UART_RLIN32,
    UART_RLIN33,
    UART_RLIN_MAX,
} UART_Channel_en_t;

typedef void (*UART_Confirm)(void);
typedef void (*UART_Read_Msg)(uint16_t u16UARTData);

typedef struct
{
    uint32_t      u32UARTChEn; /*通道是否使能*/
    uint32_t      u32UARTbps;  /*通道实际波特率*/
    UART_Confirm  pfnUARTConfirmCallBack;
    UART_Read_Msg pfnUARTReadMsgCallBack;

} UART_Channel_Config_st_t;
typedef enum
{
    MFS_UART_OptSt_OK = 0, /*  操作完成  */
    MFS_UART_OptSt_BUSY,   /*  当前忙  */
} EMFS_UART_OptSt;

/****************************************************************/

void UART_CH0_TX_ISR(void);
void UART_CH1_TX_ISR(void);
void UART_CH2_TX_ISR(void);
void UART_CH3_TX_ISR(void);
void UART_CH0_RX_ISR(void);
void UART_CH1_RX_ISR(void);
void UART_CH2_RX_ISR(void);
void UART_CH3_RX_ISR(void);

uint8_t UART_Ch0_Get_TX_Busy_Flag(void);
uint8_t UART_Ch1_Get_TX_Busy_Flag(void);
uint8_t UART_Ch2_Get_TX_Busy_Flag(void);
uint8_t UART_Ch3_Get_TX_Busy_Flag(void);

void           UART_Ch0_Send_Multiple_Byte(uint8_t *Data, uint8_t Len);
uint8_t        UART_Ch1_Send_Multiple_Byte(uint8_t *Data, uint8_t Len);
void           UART_Ch2_Send_Multiple_Byte(uint8_t *Data, uint8_t Len);
void           UART_Ch3_Send_Multiple_Byte(uint8_t *Data, uint8_t Len);
extern uint8_t Get_Uart_BusyFlash(void);

/*首次上30和每次唤醒时调用*/
extern uint32_t UART_Init(UART_Channel_en_t enUARTCh, UART_Channel_Config_st_t *penUARTCfg);
/*休眠时调用*/
extern void UART_Sleep_Init(UART_Channel_en_t enUARTCh);

#endif
