/*===========================================================================*/
/* Project:  F1x StarterKit V3 Sample Software                               */
/* Module :  r_clkc.h                                                        */
/* Version:  V1.00                                                           */
/*===========================================================================*/
/*                                  COPYRIGHT                                */
/*===========================================================================*/
/* Copyright (c) 2016 by Renesas Electronics Europe GmbH,                    */
/*               a company of the Renesas Electronics Corporation            */
/*===========================================================================*/
/* In case of any question please do not hesitate to contact:                */
/*                                                                           */
/*        ABG Software Tool Support                                          */
/*                                                                           */
/*        Renesas Electronics Europe GmbH                                    */
/*        Arcadiastrasse 10                                                  */
/*        D-40472 Duesseldorf, Germany                                       */
/*                                                                           */
/*        e-mail: software_support-eu@lm.renesas.com                         */
/*        FAX:   +49 - (0)211 / 65 03 - 11 31                                */
/*                                                                           */
/*===========================================================================*/
/* Warranty Disclaimer                                                       */
/*                                                                           */
/* Because the Product(s) is licensed free of charge, there is no warranty   */
/* of any kind whatsoever and expressly disclaimed and excluded by Renesas,  */
/* either expressed or implied, including but not limited to those for       */
/* non-infringement of intellectual property, merchantability and/or         */
/* fitness for the particular purpose.                                       */
/* Renesas shall not have any obligation to maintain, service or provide bug */
/* fixes for the supplied Product(s) and/or the Application.                 */
/*                                                                           */
/* Each User is solely responsible for determining the appropriateness of    */
/* using the Product(s) and assumes all risks associated with its exercise   */
/* of rights under this Agreement, including, but not limited to the risks   */
/* and costs of program errors, compliance with applicable laws, damage to   */
/* or loss of data, programs or equipment, and unavailability or             */
/* interruption of operations.                                               */
/*                                                                           */
/* Limitation of Liability                                                   */
/*                                                                           */
/* In no event shall Renesas be liable to the User for any incidental,       */
/* consequential, indirect, or punitive damage (including but not limited    */
/* to lost profits) regardless of whether such liability is based on breach  */
/* of contract, tort, strict liability, breach of warranties, failure of     */
/* essential purpose or otherwise and even if advised of the possibility of  */
/* such damages. Renesas shall not be liable for any services or products    */
/* provided by third party vendors, developers or consultants identified or  */
/* referred to the User by Renesas in connection with the Product(s) and/or  */
/* the Application.                                                          */
/*                                                                           */
/*===========================================================================*/
/* History:                                                                  */
/*              V1.00: Initial version                                       */
/*                                                                           */
/*===========================================================================*/
#ifndef R_CLKC_H
#define R_CLKC_H

/*===========================================================================*/
/* Defines */
/*===========================================================================*/
#define R_CLKC_STOPMASK_SET         0x03
#define R_CLKC_STOPMASK_RESET       0x02

#define R_CLKC_TAUJ_DISABLE         0x00
#define R_CLKC_TAUJ_HSINTOSC        0x01
#define R_CLKC_TAUJ_MOSC            0x02
#define R_CLKC_TAUJ_LSINTOSC        0x03
#define R_CLKC_TAUJ_PPLLCLK2        0x04

#define R_CLKC_ADCA_DISABLE         0x00
#define R_CLKC_ADCA_HSINTOSC        0x01
#define R_CLKC_ADCA_MOSC            0x02
#define R_CLKC_ADCA_PPLLCLK2        0x03

#define R_CLKC_RSCAN_DISABLE        0x00
#define R_CLKC_RSCAN_MOSC           0x01
#define R_CLKC_RSCAN_PPLLCLK        0x03
#define R_CLKC_RSCAN_DIV_DISBABLE   0x00
#define R_CLKC_RSCAN_DIV_MOSC1      0x01
#define R_CLKC_RSCAN_DIV_MOSC2      0x02
#define _CGC_MAINOSC_STOP        (0x00000002UL) /* Stops MainOSC */
#define _CGC_MAINOSC_START       (0x00000001UL) /* Start MainOSC */
#define _CGC_MOSCC_DEFAULT_VALUE                  (0x00000004UL) /* MOSCC default value */
#define _CGC_MOSCSTPM_DEFAULT_VALUE               (0x00000002UL) /* MOSCSTPM default value */
#define _CGC_ROSCSTPM_DEFAULT_VALUE               (0x00000002UL) /* ROSCSTPM default value */
#define _CGC_PLL1C_DEFAULT_VALUE                  (0x00010300UL) /* PLL1C default value */
#define _CGC_CKSC_AWDTAD_STPM_DEFAULT_VALUE       (0x00000002UL) /* CKSC_AWDTAD_STPM default value */
#define _CGC_CKSC_ATAUJD_STPM_DEFAULT_VALUE       (0x00000002UL) /* CKSC_ATAUJD_STPM default value */
#define _CGC_CKSC_ARTCAD_STPM_DEFAULT_VALUE       (0x00000002UL) /* CKSC_ARTCAD_STPM default value */
#define _CGC_CKSC_AADCAD_STPM_DEFAULT_VALUE       (0x00000002UL) /* CKSC_AADCAD_STPM default value */
#define _CGC_CKSC_AFOUTS_STPM_DEFAULT_VALUE       (0x00000002UL) /* CKSC_AFOUTS_STPM default value */
#define _CGC_CKSC_ILIND_STPM_DEFAULT_VALUE        (0x00000002UL) /* CKSC_ILIND_STPM default value */
#define _CGC_CKSC_ICANS_STPM_DEFAULT_VALUE        (0x00000002UL) /* CKSC_ICANS_STPM default value */
#define _CGC_CKSC_ICANOSCD_STPM_DEFAULT_VALUE     (0x00000002UL) /* CKSC_ICANOSCD_STPM default value */
#define _CGC_MAINOSC_STABILIZE_TIME               (0x000044C0UL) /* the count value for the MainOSC stabilization counter */
#define _CGC_PLL1_DIVISION_RATIO                  (0x0000003BUL) /* Division ratio Mr is set */

/*
    MainOSC Status Register (MOSCS)
*/
/* MainOSC active status (MOSCCLKACT) */
#define _CGC_MAINOSC_ACTIVE      (0x00000004UL) /* MainOSC is active */
#define _CGC_MAINOSC_24MHZ       (0x00000000UL) /* 24MHz */
#define _CGC_MAINOSC_20MHZ       (0x00000001UL) /* 20MHz */
#define _CGC_MAINOSC_16MHZ       (0x00000002UL) /* 16MHz */
#define	_CGC_MAINOSC_8MHZ        (0x00000003UL) /* 8MHz */
/*
    MainOSC Stop Mask Register (MOSCSTPM)
*/
/* MainOSC stop request mask (MOSCSTPMSK) */
#define _CGC_MAINOSC_REQUEST_STOP            (0x00000000UL) /* MainOSC stops operation in standby mode */
#define _CGC_MAINOSC_REQUEST_CONTINUE        (0x00000001UL) /* MainOSC continues operation in standby mode */

/*
    MainOSC Mode Control Register (MOSCM)
*/
/* MainOSC mode control (MOSCM) */
#define _CGC_MAINOSC_OSC_MODE	 (0x00000000UL) /* OSC mode */
#define _CGC_MAINOSC_EXCLK_MODE  (0x00000001UL) /* EXCLK mode */

/*
    SubOSC Enable Register (SOSCE)
*/
/* SubOSC disable trigger (SOSCDISTRG) */
#define _CGC_SUBOSC_STOP 	     (0x00000002UL) /* Stops SubOSC */
/* SubOSC enable trigger (SOSCENTRG) */
#define _CGC_SUBOSC_START 	     (0x00000001UL) /* Starts SubOSC */

/*
    SubOSC Status Register (SOSCS)
*/
/* SubOSC activation status (SOSCCLKACT) */
#define _CGC_SUBOSC_ACTIVE       (0x00000004UL) /* SubOSC is active */

/*
    HS IntOSC Enable Register (ROSCE)
*/
/* HS IntOSC disable trigger (ROSCDISTRG) */
#define _CGC_HSOSC_STOP	         (0x00000002UL) /* Stops HS IntOSC */

/*
    HS IntOSC Status Register (ROSCS)
*/
/* HS IntOSC active status (ROSCCLKACT) */
#define _CGC_HSOSC_ACTIVE         (0x00000000UL) /* HS IntOSC is active */
#define _CGC_HSOSC_INACTIVE       (0x00000004UL) /* HS IntOSC is inactive */

/*
    HS IntOSC Stop Mask Register (ROSCSTPM)
*/
/* HS IntOSC Stop Request Mask (ROSCSTPMSK) */
#define _CGC_HSOSC_REQUEST_STOP	         (0x00000000UL) /* HS IntOSC stops operation in standby mode */
#define _CGC_HSOSC_REQUEST_CONTINUE 	 (0x00000001UL) /* HS IntOSC continues operation in standby mode */

/*
    PLL0 Enable Register (PLL0E)
*/
/* PLL0 disable trigger (PLL0DISTRG) */
#define _CGC_PLL0_STOP                   (0x00000002UL) /* Stops PLL0 */
/* PLL0 Enable Trigger (PLL0ENTRG) */
#define _CGC_PLL0_START                  (0x00000001UL) /* Starts PLL0 */
#define	_CGC_PLL0_VCO                    (0x00000000UL) /*VCO Output Frequency Range Setting*/

/*
    PLL0 Status Register (PLL0S)
*/
/* PLL0 active status (PLL0CLKACT) */
#define _CGC_PLL0_ACTIVE                 (0x00000004UL) /* PLL0 is active */

/*
   PLL0 Control Register (PLL0C)
*/
/* Frequency Modulation Cycle Setting */
#define _CGC_PLL0_MFD10	                 (0x00000000UL) /* Modulation Frequency Division Ratio MFD=10 */
#define _CGC_PLL0_MFD12	                 (0x01000000UL) /* Modulation Frequency Division Ratio MFD=12 */
#define _CGC_PLL0_MFD18	                 (0x02000000UL) /* Modulation Frequency Division Ratio MFD=18 */
#define _CGC_PLL0_MFD20	                 (0x03000000UL) /* Modulation Frequency Division Ratio MFD=20 */
#define _CGC_PLL0_MFD22	                 (0x04000000UL) /* Modulation Frequency Division Ratio MFD=22 */
#define _CGC_PLL0_MFD26                  (0x05000000UL) /* Modulation Frequency Division Ratio MFD=26 */
#define _CGC_PLL0_MFD28	                 (0x06000000UL) /* Modulation Frequency Division Ratio MFD=28 */
#define _CGC_PLL0_MFD30                  (0x07000000UL) /* Modulation Frequency Division Ratio MFD=30 */
#define _CGC_PLL0_MFD34	                 (0x08000000UL) /* Modulation Frequency Division Ratio MFD=34 */
#define _CGC_PLL0_MFD38	                 (0x09000000UL) /* Modulation Frequency Division Ratio MFD=38 */
#define _CGC_PLL0_MFD40	                 (0x0a000000UL) /* Modulation Frequency Division Ratio MFD=40 */
#define _CGC_PLL0_MFD44	                 (0x0b000000UL) /* Modulation Frequency Division Ratio MFD=44 */
#define _CGC_PLL0_MFD50	                 (0x0c000000UL) /* Modulation Frequency Division Ratio MFD=50 */
#define _CGC_PLL0_MFD56	                 (0x0d000000UL) /* Modulation Frequency Division Ratio MFD=56 */
#define _CGC_PLL0_MFD58	                 (0x0e000000UL) /* Modulation Frequency Division Ratio MFD=58 */
#define _CGC_PLL0_MFD60	                 (0x0f000000UL) /* Modulation Frequency Division Ratio MFD=60 */
#define _CGC_PLL0_MFD62	                 (0x10000000UL) /* Modulation Frequency Division Ratio MFD=62 */
#define _CGC_PLL0_MFD66	                 (0x11000000UL) /* Modulation Frequency Division Ratio MFD=66 */
#define _CGC_PLL0_MFD72	                 (0x12000000UL) /* Modulation Frequency Division Ratio MFD=72 */
#define _CGC_PLL0_MFD76	                 (0x13000000UL) /* Modulation Frequency Division Ratio MFD=76 */
#define _CGC_PLL0_MFD80	                 (0x14000000UL) /* Modulation Frequency Division Ratio MFD=80 */
#define _CGC_PLL0_MFD84	                 (0x15000000UL) /* Modulation Frequency Division Ratio MFD=84 */
#define _CGC_PLL0_MFD86	                 (0x16000000UL) /* Modulation Frequency Division Ratio MFD=86 */
#define _CGC_PLL0_MFD100                 (0x17000000UL) /* Modulation Frequency Division Ratio MFD=100 */
#define _CGC_PLL0_MFD120                 (0x18000000UL) /* Modulation Frequency Division Ratio MFD=120 */
#define _CGC_PLL0_MFD126                 (0x19000000UL) /* Modulation Frequency Division Ratio MFD=126 */
#define _CGC_PLL0_MFD134                 (0x1a000000UL) /* Modulation Frequency Division Ratio MFD=134 */
#define _CGC_PLL0_MFD150                 (0x1b000000UL) /* Modulation Frequency Division Ratio MFD=150 */
#define _CGC_PLL0_MFD166                 (0x1c000000UL) /* Modulation Frequency Division Ratio MFD=166 */
#define _CGC_PLL0_MFD200                 (0x1d000000UL) /* Modulation Frequency Division Ratio MFD=200 */
#define _CGC_PLL0_MFD250                 (0x1e000000UL) /* Modulation Frequency Division Ratio MFD=250 */
#define _CGC_PLL0_MFD300                 (0x1f000000UL) /* Modulation Frequency Division Ratio MFD=300 */
/* Frequency Modulation Range Setting */
#define _CGC_PLL0_FMR_1	                 (0x00000000UL) /* Frequency Modulation Range 1% */
#define _CGC_PLL0_FMR_2	                 (0x00100000UL) /* Frequency Modulation Range 2% */
#define _CGC_PLL0_FMR_3	                 (0x00200000UL) /* Frequency Modulation Range 3% */
#define _CGC_PLL0_FMR_4	                 (0x00300000UL) /* Frequency Modulation Range 4% */
#define _CGC_PLL0_FMR_5	                 (0x00400000UL) /* Frequency Modulation Range 5% */
#define _CGC_PLL0_FMR_6	                 (0x00500000UL) /* Frequency Modulation Range 6% */
#define _CGC_PLL0_FMR_8	                 (0x00600000UL) /* Frequency Modulation Range 8% */
#define _CGC_PLL0_FMR_10                 (0x00700000UL) /* Frequency Modulation Range 10% */
/* Operating Mode Setting */
#define _CGC_PLL0_SSCCG_MODE	         (0x00004000UL) /*SSCG mode (modulation frequency) */
#define _CGC_PLL0_MODULATION_MODE        (0x00000000UL)
/*
    PLL0 Input Clock Selection Register (CKSC_PLL0IS_CTL)
*/
/* Source clock setting for PLL0 input clock (PLL0ISCSID1,PLL0ISCSID0) */
#define _CGC_PLL0_SOURCE_MAINOSC         (0x00000001UL) /* Main OSC */
#define _CGC_PLL0_SOURCE_HSOSC           (0x00000002UL) /* HS IntOSC */

/*
    PLL1 Enable Register (PLL1E)
*/
/* PLL1 disable trigger (PLL1DISTRG) */
#define _CGC_PLL1_STOP                   (0x00000002UL) /* Stops PLL1 */
/* PLL1 Enable Trigger (PLL1ENTRG) */
#define _CGC_PLL1_START                  (0x00000001UL) /* Starts PLL1 */

/*
    PLL1 Status Register (PLL1S)
*/
/* PLL1 active status (PLL1CLKACT) */
#define _CGC_PLL1_ACTIVE                 (0x00000004UL) /* PLL1 is active */

/*
    PLL1 Input Clock Selection Register (CKSC_PLL1IS_CTL)
*/
/* Source clock setting for PLL1 input clock (PLL1ISCSID1,PLL1ISCSID0) */
#define	_CGC_PLL1_SOURCE_MAINOSC          (0x00000001UL) /* Main OSC */
#define _CGC_PLL1_SOURCE_HSOSC            (0x00000002UL) /* HS IntOSC */

/*
    PLL1 Input Clock Active Register (CKSC_PLL1IS_ACT)
*/
/* Source clock for currently active PLL1 input clock (PLL1ISACT1,PLL1ISACT0) */
#define _CGC_PLL1_SOURCE_ACTIVE           (0x00000003UL) /* Source clock for currently active PLL1 input clock */

/*
    PLL0 Input Clock Active Register (CKSC_PLL0IS_ACT)
*/
/* Source clock for currently active PLL0 input clock (PLL0ISACT1,PLL0ISACT0) */
#define _CGC_PLL0_SOURCE_ACTIVE           (0x00000003UL) /* Source clock for currently active PLL0 input clock */


/*
    PPLLCLK Source Clock Selection Register (CKSC_PPLLCLKS_CTL)
*/
/* Source clock setting for PPLLCLK (PPLLCLKSCSID1,PPLLCLKSCSID0) */
#define _CGC_PPLLCLK_SOURCE_EMCLK          (0x00000001UL) /* Emergency clock EMCLK */
#define _CGC_PPLLCLK_SOURCE_MAINOSC        (0x00000002UL) /* MainOSC */
#define _CGC_PPLLCLK_SOURCE_PPLLOUT        (0x00000003UL) /* PPLLOUT */

/*
    PPLLCLK Source Clock Active Register (CKSC_PPLLCLKS_ACT)
*/
/* Source clock for currently active PPLLCLK (PPLLCLKSCSID1,PPLLCLKSCSID0) */
#define _CGC_PPLLCLK_SOURCE_ACTIVE         (0x00000003UL) /* Source clock for currently active PPLLCLK */

/*
    C_AWO_WDTA Clock Divider Selection Register (CKSC_AWDTAD_CTL)
*/
/* Clock Divider Setting for C_AWO_WDTA (AWDTADCSID1,AWDTADCSID0) */
#define _CGC_WDTA_CLK_SOURCE_LSOSC_128     (0x00000001UL) /* LS IntOSC / 128 (default) */
#define _CGC_WDTA_CLK_SOURCE_LSOSC_1       (0x00000002UL) /* LS IntOSC / 1 */

/*
    C_AWO_WDTA Stop Mask Register (CKSC_AWDTAD_STPM)
*/
/* C_AWO_WDTA Stop Request Mask (AWDTADSTPMSK) */
#define _CGC_WDTA_CLK_REQUEST_STOP         (0x00000000UL) /* C_AWO_WDTA is stopped in standby mode */
#define _CGC_WDTA_CLK_REQUEST_CONTINUE 	   (0x00000001UL) /* C_AWO_WDTA is not stopped in standby mode */

/*
    C_AWO_TAUJ Source Clock Selection Register (CKSC_ATAUJS_CTL)
*/
/* Source clock setting for C_AWO_TAUJ (ATAUJSCSID2,ATAUJSCSID1,ATAUJSCSID0) */
#define _CGC_TAUJ_CLK_SOURCE_DISABLE       (0x00000000UL) /* Disabled */
#define _CGC_TAUJ_CLK_SOURCE_HSOSC         (0x00000001UL) /* HS IntOSC (default) */
#define _CGC_TAUJ_CLK_SOURCE_MAINOSC       (0x00000002UL) /* MainOSC */
#define _CGC_TAUJ_CLK_SOURCE_LSOSC         (0x00000003UL) /* LS IntOSC */
#define _CGC_TAUJ_CLK_SOURCE_PPLLCLK2      (0x00000004UL) /* PPLLCLK2 */

/*
    C_AWO_TAUJ Clock Divider Selection Register (CKSC_ATAUJD_CTL)
*/
/* Clock Divider Setting for C_AWO_TAUJ (ATAUJDCSID2,ATAUJDCSID1,ATAUJDCSID0) */
#define _CGC_TAUJ_CLK_DIVIDER_1            (0x00000001UL) /* CKSC_ATAUJS_CTL selection /1 (default) */
#define _CGC_TAUJ_CLK_DIVIDER_2            (0x00000002UL) /* CKSC_ATAUJS_CTL selection /2 */
#define _CGC_TAUJ_CLK_DIVIDER_4	           (0x00000003UL) /* CKSC_ATAUJS_CTL selection /4 */
#define _CGC_TAUJ_CLK_DIVIDER_8	           (0x00000004UL) /* CKSC_ATAUJS_CTL selection /8 */

/*
    C_AWO_WDTA Stop Mask Register (CKSC_ATAUJD_STPM)
*/
/* C_AWO_TAUJ Stop Request Mask (ATAUJDSTPMSK) */
#define  _CGC_TAUJ_CLK_REQUEST_STOP	        (0x00000000UL) /* C_AWO_TAUJ is stopped in standby mode */
#define	 _CGC_TAUJ_CLK_REQUEST_CONTINUE  	(0x00000001UL) /* C_AWO_TAUJ is not stopped in standby mode */

/*
    C_AWO_RTCA Source Clock Selection Register (CKSC_ARTCAS_CTL)
*/
/* Source clock setting for C_AWO_RTCA (ARTCASCSID1,ARTCASCSID0) */
#define _CGC_RTCA_CLK_SOURCE_DISABLE        (0x00000000UL) /* Disabled(default) */
#define _CGC_RTCA_CLK_SOURCE_SUBOSC         (0x00000001UL) /* SubOSC */
#define _CGC_RTCA_CLK_SOURCE_MAINOSC        (0x00000002UL) /* MainOSC */
#define _CGC_RTCA_CLK_SOURCE_LSOSC          (0x00000003UL) /* LS IntOSC */

/*
    C_AWO_RTCA Clock Divider Register (CKSC_ARTCAD_CTL)
*/
/* Clock divider setting for C_AWO_RTCA (ARTCADCSID2,ARTCADCSID1,ARTCADCSID0) */
#define _CGC_RTCA_CLK_DIVIDER_DISABLE	    (0x00000000UL) /* Disabled (default) */
#define _CGC_RTCA_CLK_DIVIDER_1             (0x00000001UL) /* CKSC_ARTCAS_CTL selection /1 */
#define _CGC_RTCA_CLK_DIVIDER_2             (0x00000002UL) /* CKSC_ARTCAS_CTL selection /2 */
#define _CGC_RTCA_CLK_DIVIDER_4             (0x00000003UL) /* CKSC_ARTCAS_CTL selection /4 */
#define _CGC_RTCA_CLK_DIVIDER_8	            (0x00000004UL) /* CKSC_ARTCAS_CTL selection /8 */

/*
    C_AWO_RTCA Stop Mask Register (CKSC_ARTCAD_STPM)
*/
/* C_AWO_RTCA stop request mask (ARTCADSTPMSK) */
#define _CGC_RTCA_CLK_REQUEST_STOP  	    (0x00000000UL) /* C_AWO_RTCA is stopped in standby mode */
#define _CGC_RTCA_CLK_REQUEST_CONTINUE	    (0x00000001UL) /* C_AWO_RTCA is not stopped in standby mode */

/*
    C_AWO_ADCA Source Clock Selection Register (CKSC_AADCAS_CTL)
*/
/* Source clock setting for C_AWO_ADCA (AADCASCSID1,AADCASCSID0) */
#define _CGC_ADCA0_CLK_SOURCE_DISABLE       (0x00000000UL) /* Disabled */
#define _CGC_ADCA0_CLK_SOURCE_HSOSC         (0x00000001UL) /* HS IntOSC (default) */
#define _CGC_ADCA0_CLK_SOURCE_MAINOSC       (0x00000002UL) /* MainOSC */
#define _CGC_ADCA0_CLK_SOURCE_PPLLCLK2      (0x00000003UL) /* PPLLCLK2 */

/*
    C_AWO_RTCA Clock Divider Register (CKSC_AADCAD_CTL)
*/
/* Clock divider setting for C_AWO_ADCA (AADCADCSID1,AADCADCSID0) */
#define _CGC_ADCA0_CLK_DIVIDER_1            (0x00000001UL) /* CKSC_AADCAS_CTL selection /1 (default) */
#define _CGC_ADCA0_CLK_DIVIDER_2            (0x00000002UL) /* CKSC_AADCAS_CTL selection /2 */

/*
    C_AWO_ADCA Stop Mask Register (CKSC_AADCAD_STPM)
*/
/* C_AWO_ADCA stop request mask (AADCADSTPMSK) */
#define _CGC_ADCA0_CLK_REQUEST_STOP         (0x00000000UL) /* C_AWO_RTCA is stopped in standby mode */
#define _CGC_ADCA0_CLK_REQUEST_CONTINUE     (0x00000001UL) /* C_AWO_RTCA is not stopped in standby mode */

/*
    C_AWO_FOUT Source Clock Selection Register (CKSC_AFOUTS_CTL)
*/
/* Source clock setting for C_AWO_FOUT (AFOUTSCSID2,AFOUTSCSID1,AFOUTSCSID0) */
#define _CGC_FOUT_CLK_SOURCE_DISABLE        (0x00000000UL) /* Disabled (default) */
#define _CGC_FOUT_CLK_SOURCE_MAINOSC        (0x00000001UL) /* MainOSC */
#define _CGC_FOUT_CLK_SOURCE_HSOSC          (0x00000002UL) /* HS IntOSC */
#define _CGC_FOUT_CLK_SOURCE_LSOSC          (0x00000003UL) /* LS IntOSC */
#define _CGC_FOUT_CLK_SOURCE_SUBOSC         (0x00000004UL) /* SubOSC */
#define _CGC_FOUT_CLK_SOURCE_PPLLCLK4       (0x00000005UL) /* PPLLCLK4 */

/*
    C_AWO_FOUT Stop Mask Register (CKSC_AFOUTS_STPM)
*/
/* C_AWO_FOUT stop request mask (AFOUTSSTPMSK) */
#define _CGC_FOUT_CLK_REQUEST_STOP           (0x00000000UL) /* C_AWO_FOUT is stopped in standby mode */
#define _CGC_FOUT_CLK_REQUEST_CONTINUE       (0x00000001UL) /* C_AWO_FOUT is not stopped in standby mode */

/*
    C_ISO_CPUCLK Source Clock Selection Register (CKSC_CPUCLKS_CTL)
*/
/* Source clock setting for C_ISO_CPUCLK (CPUCLKSCSID1,CPUCLKSCSID0) */
#define _CGC_CPU_CLK_SOURCE_CPLL0OUT         (0x00000000UL) /* CPLL0OUT */
#define _CGC_CPU_CLK_SOURCE_EMCLK            (0x00000001UL) /* EMCLK (default) */
#define _CGC_CPU_CLK_SOURCE_MAINOSC          (0x00000002UL) /* MainOSC */
#define _CGC_CPU_CLK_SOURCE_CPLL1OUT         (0x00000003UL) /* CPLL1OUT */

/*
    C_ISO_CPUCLK Clock Divider Selection Register (CKSC_CPUCLKD_CTL)
*/
/* Clock divider CPLL1/0DIV setting (CPUCLKDPLL1,CPUCLKDPLL0) */
#define _CGC_CPLLOUT_DIVIDER_6               (0x00000000UL) /* CPLL1/0OUT = VCOOUT * 1/6 (80 MHz) */
#define _CGC_CPLLOUT_DIVIDER_5               (0x00000008UL) /* CPLL1/0OUT = VCOOUT * 1/5 (96 MHz) */
#define	_CGC_CPLLOUT_DIVIDER_4               (0x00000010UL) /* CPLL1/0OUT = VCOOUT * 1/4 (120 MHz) */
#define	_CGC_CPLLOUT_DIVIDER_3	             (0x00000030UL) /* CPLL1/0OUT = VCOOUT * 1/3 (160 MHz) */
#define _CGC_CPLLOUT_DIVIDER_2	             (0x00000028UL) /* CPLL1/0OUT = VCOOUT * 1/2 (240 MHz) */
/* Clock divider setting for C_ISO_CPUCLK (CPUCLKDCSID2,CPUCLKDCSID1,CPUCLKDCSID0) */
#define _CGC_CPU_CLK_DIVIDER_1	             (0x00000001UL) /* CKSC_CPUCLKS_CTL selection /1 (Default) */
#define _CGC_CPU_CLK_DIVIDER_2 	             (0x00000002UL) /* CKSC_CPUCLKS_CTL selection /2 */
#define _CGC_CPU_CLK_DIVIDER_4	             (0x00000003UL) /* CKSC_CPUCLKS_CTL selection /4 */
#define _CGC_CPU_CLK_DIVIDER_8	             (0x00000004UL) /* CKSC_CPUCLKS_CTL selection /8 */

/*
    C_ISO_PERI1 Source Clock Selection Register (CKSC_IPERI1S_CTL)
*/
/* Source clock setting for C_ISO_PERI1 (IPERI1SCSID1,IPERI1SCSID0) */
#define _CGC_PERI1_CLK_SOURCE_DISABLE	     (0x00000000UL) /* Disabled */
#define _CGC_PERI1_CLK_SOURCE_PPLLCLK	     (0x00000001UL) /* PPLLCLK (default) */

/*
    C_ISO_PERI2 Source Clock Selection Register (CKSC_IPERI2S_CTL)
*/
/* Source clock setting for C_ISO_PERI2 (IPERI2SCSID1,IPERI2SCSID0) */
#define _CGC_PERI2_CLK_SOURCE_DISABLE	      (0x00000000UL) /* Disabled */
#define _CGC_PERI2_CLK_SOURCE_PPLLCLK2	      (0x00000001UL) /* PPLLCLK2 (default) */

/*===========================================================================*/
/* Function defines */
/*===========================================================================*/
void R_CLKC_PllInit(void);
void R_CLKC_SetRscanClockDomain(uint32_t RscanModuleClockDomain, uint32_t RscanComClockDomain);
void R_CLKC_SetAdca0ClockDomain(uint32_t Adca0ClockDomain);
void R_CLKC_SetTaujClockDomain(uint32_t TaujClockDomain);
void R_CLKC_SetAdca0StopMask(void);
void R_CLKC_ResetAdca0StopMask(void);
void R_CLKC_SetTaujStopMask(void);
void R_CLKC_ResetTaujStopMask(void);

#endif /* R_CLKC_H */

