

#ifdef GLOBALS_APP_TEST
#define EXTERN_APP_TEST

#else
#define EXTERN_APP_TEST extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola 0
#define Intel 1

#define Offset_Minus 0
#define Offset_Plus 1

#define Value_Minus 0
#define Value_Plus 1

typedef struct
{
    int val;
    unsigned char fval;
} s_CurValue;

typedef struct
{
    CAN_message *canMsg;
    unsigned char StartByte;
    unsigned char StartBit;
    unsigned char SignalLen;
    unsigned int Offset;
    unsigned char fOffset;
    unsigned int Factor_1; /*Denominator of Resolution*/ /*���ȵķ�ĸ*/
    unsigned int Factor_2; /*Numerator of Resolution*/   /*���ȵķ���*/
    s_CurValue *CurValue;
    unsigned char fFormat;
} s_CAN_List;

enum
{
    T06_VSpeed = 0,                     //
    T06_Battery_Power1,                 //ص1
    T06_Battery_Power2,                 //ص2
    T06_ABS,                            //ABS
    T06_Cruise,                         //Ѳ
    T06_The_Initial_Value_Abnormal,     //
    T06_P_File_Status_READY,            //READY(P)
    T06_BlueTooth,                      //
    T06_GPS_Status,                     //GPSź
    T06_IOT_TCS_Level_Setting_Feedback, //TCSָʾ
    T06_Telephone_Reminder,             //ʾ
    T06_Support_Switch_State,           //ָʾ
    T06_GSM_Status,                     //GSMź
    T06_Parallel_Connection_of_Batteries, //ź

    CAN_List_Num,
};

EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] =
{
    {&CanMsg_0A33FFE3, 0, 0, 16,0,Offset_Plus, 1, 1,  &CurValueStr[T06_VSpeed                    ], Intel},
    {&CanMsg_0A10FFE0, 2, 0, 16,0,Offset_Plus, 1, 1,  &CurValueStr[T06_Battery_Power1            ], Intel},
    {&CanMsg_0A10FFE1, 2, 0, 16,0, Offset_Plus, 1, 1, &CurValueStr[T06_Battery_Power2            ], Intel},
    {&CanMsg_0A30FFE8, 0, 6, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_ABS                       ], Intel},
    {&CanMsg_0A20FFE2, 1, 2, 2, 0, Offset_Plus, 1, 1, &CurValueStr[T06_Cruise                    ], Intel},
    {&CanMsg_0A40FFE2, 0, 4, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_The_Initial_Value_Abnormal], Intel},
    {&CanMsg_0A20FFE2, 0, 4, 2, 0, Offset_Plus, 1, 1, &CurValueStr[T06_P_File_Status_READY       ], Intel},
    {&CanMsg_0A30FFE3, 7, 7, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_BlueTooth                 ], Intel},
    {&CanMsg_0A32FFE4, 0, 1, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_GPS_Status                ], Intel},
    {&CanMsg_0A30DDE8, 6, 2, 3, 0, Offset_Plus, 1, 1, &CurValueStr[T06_IOT_TCS_Level_Setting_Feedback], Intel},
    {&CanMsg_0A37FFE3, 7, 0, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_Telephone_Reminder        ], Intel},
    {&CanMsg_0A20FFE2, 4, 2, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_Support_Switch_State      ], Intel},
    {&CanMsg_0A32FFE4, 0, 0, 1, 0, Offset_Plus, 1, 1, &CurValueStr[T06_GSM_Status                ], Intel},
    {&CanMsg_0A18FFE0, 0, 0, 3, 0, Offset_Plus, 1, 1, &CurValueStr[T06_Parallel_Connection_of_Batteries], Intel},
};
extern unsigned int Key_Dodging_flag;
extern unsigned int lost_flag;
extern unsigned int CAN_init_flag; 
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
EXTERN_APP_TEST void APP_Button_Proc(void);
EXTERN_APP_TEST void Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value); /*Do not span bytes*/

#endif /* API_CAN_H_ */
