#include "api_RS485.h"
#include "R485_Communication_Matrix.h"
#include "string.h"
#include "Display_Info.h"
#define R485_BUF_SIZE (1024 * 4 )
#define R485_UART_PORT (1)
#define R485_TX_OUT_MCU R485_TX
#define R485_RX_IN_MCU R485_RX
#define R485_DATA_PACKAGE_MIN_LEN 0x07 /* 帧头 2 ID 1 数据长度 1 校验和 1 帧尾 2*/
#define R485_DATA_LEN 0x40
static void RS485_Receive_Data_Analysis(void);
static void R485_TX_Init(void);
static void R485_RX_Init(void);
static RS485DataPacket stRS485DataRx;
static RS485ValidDataPacket_st_t stRS485RxVldData[RS485_Rx_ID_Idx_Max];
RS485_TxControl_en_t RS485_TxControl;
static uint32_t u32RS485RxDataBegin = 0;
static uint32_t u32RS485RxDataRe = 0;
static uint32_t u32RS485RxDataValidLenTem = 0;
static uint32_t u32RS485DataBufLen = 0;
static uint8_t RS485DataBuf[RS485_RX_BUF_LEN];
static uint32_t u32RS485RxDataValidLen = 0;
static uint8_t RS485ValidData[RS485_RX_DATA_LEN];
static uint8_t u8RS485RecVldID[RS485_Rx_ID_Idx_Max];
uint32_t RS485_send_time = 0;
// uint32_t RS485_send_num = 0;
uint8_t RS485_TX_finish = 0;
// static RS485_Tx_Data_Ctrl_st_t stRS485TxData[RS485_Tx_ID_Idx_Max];

#define HEAD_LEN 2
#define ID_LEN 1
#define DATALEN_LEN 2
#define CRC_LEN 2
#define END_LEN 2
#define DATA_FRAME_TX_PERIOD_COUNT  10

_ID0X40h_Data R485_ID40h;
_ID0X48h_Data R485_ID48h;
_ID0X41h_Data R485_ID41h;
_ID0X49h_Data R485_ID49h;
_ID0X42h_Data R485_ID42h;
_ID0X4Ah_Data R485_ID4Ah;
_ID0X4Dh_Data R485_ID4Dh;
LineSta       LineGetSta;
 _ID0XD0h_Data R485_IDD0h;
 _ID0XB1h_Data R485_IDB1h;
 _ID0XD1h_Data R485_IDD1h;
 _ID0XB2h_Data R485_IDB2h;
 _ID0XD2h_Data R485_IDD2h;
 _ID0XB3h_Data R485_IDB3h;
 _ID0XD3h_Data R485_IDD3h;
 _ID0XB6h_Data R485_IDB6h;
 _ID0XD6h_Data R485_IDD6h;
 _ID0XB4h_Data R485_IDB4h;
 _ID0XD4h_Data R485_IDD4h;
 _ID0XA4h_Data R485_IDA4h;
void R485_TX_Init(void)
{

}

void R485_RX_Init(void)
{
    // for (uint8_t i = 0; i < RS485_Rx_ID_Idx_Max; i++)
    // {
    //     stRS485RxVldData[i].u16LostTime = 0;
    //     stRS485RxVldData[i].u8Status = R485_Lost;
    //     stRS485RxVldData[i].u8Received = 0;
    //     stRS485RxVldData[i].u8ReceivedFlag = 0;
    //     memset(stRS485RxVldData[i].u8RecVal, 0, RS485_RX_DATA_LEN);
    // }
}
void bsp_R485_Init(void)
{

    // uart_config_t uart_config = {
    //     .baud_rate = 115200,
    //     .data_bits = UART_DATA_8_BITS,
    //     .parity = UART_PARITY_DISABLE,
    //     .stop_bits = UART_STOP_BITS_1,
    //     .flow_ctrl = UART_HW_FLOWCTRL_DISABLE,
    //     .source_clk = UART_SCLK_DEFAULT,
    // };
    // /* Install UART driver  */
    // uart_driver_install(R485_UART_PORT, R485_BUF_SIZE, R485_BUF_SIZE, 0, NULL, 0);   /* port rxbuff txbuff evetnqueue queuesize iarmflag */
    // uart_param_config(R485_UART_PORT, &uart_config);    /* port uartconfig */
    // ESP_ERROR_CHECK(uart_set_pin(R485_UART_PORT, R485_TX_OUT_MCU, R485_RX_IN_MCU, UART_PIN_NO_CHANGE, UART_PIN_NO_CHANGE)); /* port tx rx rts cts */
    // ESP_ERROR_CHECK(uart_set_mode(R485_UART_PORT, UART_MODE_RS485_HALF_DUPLEX));
    // R485_TX_Init();
    // R485_RX_Init();
    // ESP_LOGI("485", "Init");
}

void Uart_Uninstall(void)
{
    // uart_driver_delete(R485_UART_PORT);
}



uint8_t const auchCRCHi[] =
{   0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40
} ;

/* Table of CRC values for low-order byte */
uint8_t const auchCRCLo[] =
{
    0x00, 0xC0, 0xC1, 0x01, 0xC3, 0x03, 0x02, 0xC2, 0xC6, 0x06,
    0x07, 0xC7, 0x05, 0xC5, 0xC4, 0x04, 0xCC, 0x0C, 0x0D, 0xCD,
    0x0F, 0xCF, 0xCE, 0x0E, 0x0A, 0xCA, 0xCB, 0x0B, 0xC9, 0x09,
    0x08, 0xC8, 0xD8, 0x18, 0x19, 0xD9, 0x1B, 0xDB, 0xDA, 0x1A,
    0x1E, 0xDE, 0xDF, 0x1F, 0xDD, 0x1D, 0x1C, 0xDC, 0x14, 0xD4,
    0xD5, 0x15, 0xD7, 0x17, 0x16, 0xD6, 0xD2, 0x12, 0x13, 0xD3,
    0x11, 0xD1, 0xD0, 0x10, 0xF0, 0x30, 0x31, 0xF1, 0x33, 0xF3,
    0xF2, 0x32, 0x36, 0xF6, 0xF7, 0x37, 0xF5, 0x35, 0x34, 0xF4,
    0x3C, 0xFC, 0xFD, 0x3D, 0xFF, 0x3F, 0x3E, 0xFE, 0xFA, 0x3A,
    0x3B, 0xFB, 0x39, 0xF9, 0xF8, 0x38, 0x28, 0xE8, 0xE9, 0x29,
    0xEB, 0x2B, 0x2A, 0xEA, 0xEE, 0x2E, 0x2F, 0xEF, 0x2D, 0xED,
    0xEC, 0x2C, 0xE4, 0x24, 0x25, 0xE5, 0x27, 0xE7, 0xE6, 0x26,
    0x22, 0xE2, 0xE3, 0x23, 0xE1, 0x21, 0x20, 0xE0, 0xA0, 0x60,
    0x61, 0xA1, 0x63, 0xA3, 0xA2, 0x62, 0x66, 0xA6, 0xA7, 0x67,
    0xA5, 0x65, 0x64, 0xA4, 0x6C, 0xAC, 0xAD, 0x6D, 0xAF, 0x6F,
    0x6E, 0xAE, 0xAA, 0x6A, 0x6B, 0xAB, 0x69, 0xA9, 0xA8, 0x68,
    0x78, 0xB8, 0xB9, 0x79, 0xBB, 0x7B, 0x7A, 0xBA, 0xBE, 0x7E,
    0x7F, 0xBF, 0x7D, 0xBD, 0xBC, 0x7C, 0xB4, 0x74, 0x75, 0xB5,
    0x77, 0xB7, 0xB6, 0x76, 0x72, 0xB2, 0xB3, 0x73, 0xB1, 0x71,
    0x70, 0xB0, 0x50, 0x90, 0x91, 0x51, 0x93, 0x53, 0x52, 0x92,
    0x96, 0x56, 0x57, 0x97, 0x55, 0x95, 0x94, 0x54, 0x9C, 0x5C,
    0x5D, 0x9D, 0x5F, 0x9F, 0x9E, 0x5E, 0x5A, 0x9A, 0x9B, 0x5B,
    0x99, 0x59, 0x58, 0x98, 0x88, 0x48, 0x49, 0x89, 0x4B, 0x8B,
    0x8A, 0x4A, 0x4E, 0x8E, 0x8F, 0x4F, 0x8D, 0x4D, 0x4C, 0x8C,
    0x44, 0x84, 0x85, 0x45, 0x87, 0x47, 0x46, 0x86, 0x82, 0x42,
    0x43, 0x83, 0x41, 0x81, 0x80, 0x40
};

uint16_t crc16(uint8_t *puchMsg,uint8_t usDataLen)
{
    uint8_t uchCRCHi = 0xFF ;
    uint8_t uchCRCLo = 0xFF ;
    uint16_t uIndex ;
    while (usDataLen--)
    {
        uIndex = uchCRCHi ^ *puchMsg++ ;
        uchCRCHi = uchCRCLo ^ auchCRCHi[uIndex] ;
        uchCRCLo = auchCRCLo[uIndex] ;
    }
    return (((uint16_t)( uchCRCHi ) << 8) | uchCRCLo) ;
}

uint16_t Yadi_CAL_Data_Sum(uint8_t* pu8LinData, uint8_t u8LinLen)
{
    return crc16(pu8LinData, u8LinLen);
}

void R485_RX_task(void* pvParameters)
{
//    int rxBytes = uart_read_bytes(R485_UART_PORT, &RxDataBuf[0], 1, portMAX_DELAY);
//    if (rxBytes > 0)
//    {
//        size_t rxBytes1 = 0;
//        int rxBytes2 = 0;
//        uint32_t i = 0;
//        uint32_t j = 0;
//        uart_get_buffered_data_len(R485_UART_PORT, &rxBytes1);
//        rxBytes2 = 0;
//        if (rxBytes1 > 0)
//        {
//            rxBytes2 = uart_read_bytes(R485_UART_PORT, &RxDataBuf[rxBytes], rxBytes1, 0);
       
//        rxBytes2 += rxBytes;
//        uds_uart_rx_write(RxDataBuf, rxBytes2);
//        stRS485DataRx.length = rxBytes2;
//        memcpy(stRS485DataRx.RS485Data, RxDataBuf, rxBytes2);
//        RS485_Receive_Data_Analysis();
//         }
//    }
}



static void RS485_Receive_Data_Analysis(void)
{
    // if ((u32RS485DataBufLen + stRS485DataRx.length) >= RS485_RX_BUF_LEN)
    // {
    //     u32RS485DataBufLen = 0;
    //     RS485DataBuf[0] = 0;
    // }
    // else
    // {
    //     memcpy(&RS485DataBuf[u32RS485DataBufLen], stRS485DataRx.RS485Data, stRS485DataRx.length);
    //     u32RS485DataBufLen += stRS485DataRx.length;
    // }

    // if (u32RS485DataBufLen > 4)
    // {
    //     u32RS485RxDataBegin = 0;
    //     while (u32RS485RxDataBegin < (u32RS485DataBufLen - 4))
    //     {
    //         if ((RS485DataBuf[0 + u32RS485RxDataBegin] != 'Y') ||
    //             (RS485DataBuf[1 + u32RS485RxDataBegin] != 'D') ||
    //             ((RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X40) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X41) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X42) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X45) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != OTA_MODE_RX_ID)))
    //         {
    //             u32RS485RxDataBegin++;
    //             continue;
    //         }

    //         u32RS485RxDataValidLenTem = RS485DataBuf[3 + u32RS485RxDataBegin];
    //         if (u32RS485RxDataValidLenTem != RS485_RX_DATA_LEN)
    //         {
    //             if (RS485DataBuf[2 + u32RS485RxDataBegin] != OTA_MODE_RX_ID)
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //         }

    //         u32RS485RxDataRe = u32RS485DataBufLen - u32RS485RxDataBegin;
    //         if (u32RS485RxDataRe >= (u32RS485RxDataValidLenTem + 5))
    //         {
    //             uint8_t u8YadiDataSum = 0;
    //             u8YadiDataSum = Yadi_CAL_Data_Sum(&RS485DataBuf[2 + u32RS485RxDataBegin], (u32RS485RxDataValidLenTem + 2));
    //             if (u8YadiDataSum != RS485DataBuf[u32RS485RxDataValidLenTem + 4 + u32RS485RxDataBegin])
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //         }
    //         else
    //         {
    //             break;
    //         }
    //         u32RS485RxDataRe = u32RS485DataBufLen - u32RS485RxDataBegin;
    //         if (u32RS485RxDataRe >= (u32RS485RxDataValidLenTem + 7))
    //         {
    //             if ((RS485DataBuf[u32RS485RxDataValidLenTem + 5 + u32RS485RxDataBegin] != 0x4B) ||
    //                 (RS485DataBuf[u32RS485RxDataValidLenTem + 6 + u32RS485RxDataBegin] != 0x4A))
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //             else
    //             {
    //                 switch (RS485DataBuf[2 + u32RS485RxDataBegin])
    //                 {
    //                     case RS485_RECEIVE_ID_0X40:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID40_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID40_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID40_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID48_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID48_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X41:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID41_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID41_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID41_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID49_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID49_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X42:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID42_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID42_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID42_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID4A_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID4A_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X45:
    //                         {
    //                             {
    //                                 stRS485RxVldData[RS485_Rx_ID45_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID4D_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID4D_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }

    //                     case OTA_MODE_RX_ID:
    //                         ota_message_init(&stRS485DataRx.RS485Data[4], u32RS485RxDataValidLenTem);
    //                         break;

    //                     default:
    //                         {
    //                             break;
    //                         }
    //                 }

    //                 u32RS485RxDataValidLen = u32RS485RxDataValidLenTem;
    //                 u32RS485RxDataBegin += (u32RS485RxDataValidLenTem + 7);


    //                 continue;
    //             }
    //         }
    //         else
    //         {
    //             break;
    //         }
    //     }

    //     if (u32RS485RxDataBegin > 0)
    //     {
    //         memcpy(RS485DataBuf, &RS485DataBuf[u32RS485RxDataBegin], (u32RS485DataBufLen - u32RS485RxDataBegin));
    //         u32RS485DataBufLen -= u32RS485RxDataBegin;
    //     }
    // }
}


uint32_t R485_Send(const uint16_t cmdID, const uint8_t* pData, uint8_t len)
{
    uint8_t dataBuf[256];
    int i = 0;
    uint16_t checksum = 0;
    uint32_t frameLen;

    dataBuf[0] = 0x59;      /* 帧头 */
    dataBuf[1] = 0x44;
    dataBuf[2] = cmdID;     /* ID */
    dataBuf[3] = len & 0xFF;
    dataBuf[4] = ((len >> 8) & 0xFF);       /* 长度 */
    frameLen = HEAD_LEN + ID_LEN + DATALEN_LEN;
    // 数据 Data
    for (i = 0; i < len; ++i)
    {
        dataBuf[frameLen] = pData[i];
        frameLen++;
    }

    checksum = Yadi_CAL_Data_Sum(&dataBuf[HEAD_LEN], len + ID_LEN + DATALEN_LEN);
    dataBuf[frameLen] = checksum & 0xFF;
    frameLen++;
    dataBuf[frameLen] = ((checksum >> 8) & 0xFF);
    frameLen++;
    dataBuf[frameLen] = 0X4B;
    frameLen++;
    dataBuf[frameLen] = 0X4A;
    frameLen++;
    uint8_t sendresult = 0;
    sendresult = UART_Ch0_Send_Multiple_Byte(dataBuf, frameLen);

    return sendresult;
}

uint8_t sendmsgAll[8];
uint32_t sendnum = 1;
uint8_t getbanbenhaoflag = 0;
uint32_t send80time = 0;
uint8_t BlueTooth = 0;
uint8_t dianliangflag = 0;
uint8_t RS485_User_Tx_Data(void)
{
    uint32_t sendfinishflag = 0;
    switch (RS485_TxControl.sendIndex)
    {
        case RS485_Tx_ID04_Idx:
        if(MENU_CHECK_STEP != 16)
        {
            sendfinishflag = R485_Send_0x04();
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        
        break;

        case RS485_Tx_IDA4_Idx:
        if((MENU_CHECK_STEP == 0)&&(clearOdoFlag == 0))
        {
            sendfinishflag = R485_Send_0xA4(); 
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        break;

        case RS485_Tx_IDB3_Idx:
        if((clearOdoFlag == 0) && (BlueTooth == 1))
        {
            sendfinishflag = R485_Send_0xB3(); 
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        break;

        case RS485_Tx_IDD0_Idx:
        if((MENU_CHECK_STEP != 16)&&(clearOdoFlag == 0))
        {
            sendfinishflag = R485_Send_0xD0();
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        break;

        case RS485_Tx_IDD1_Idx:
        if((MENU_CHECK_STEP != 16)&&(clearOdoFlag == 0))
        {
            if(dianliangflag == 0)
            {
                sendfinishflag = R485_Send_0xD1();
                dianliangflag++;
            }
            else
            {
                RS485_send_time = 0;
                RS485_TxControl.sendIndex ++;
                RS485_TX_finish = 1;
                dianliangflag = 0;
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }

        break;

        case RS485_Tx_IDD2_Idx:
        if(MENU_CHECK_STEP != 16)
        {
            sendfinishflag = R485_Send_0xD2();
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        break;

        case RS485_Tx_IDD3_Idx:
        // if(MENU_CHECK_STEP != 20)
        // {
        if(clearOdoFlag == 0)
        {
            sendfinishflag = R485_Send_0xD3();
            RS485_TX_finish = 1;
            if(sendfinishflag == 0)
            {
                if(RS485_TX_finish == 1)
                {
                    RS485_send_time = 0;
                    RS485_TxControl.sendIndex ++;
                }
            }
        }
        // }
        else
        {
            RS485_TxControl.sendIndex ++;
        }
        break;

        case RS485_Tx_ID80_Idx:
        if(clearOdoFlag == 0)
        {
            if(MENU_CHECK_STEP == 16)
            {
                BlueTooth = 1;
            }
            RS485_TxControl.Openble[0] = 0x59;
            RS485_TxControl.Openble[1] = 0x44;
            RS485_TxControl.Openble[2] = 0xA;
            RS485_TxControl.Openble[3] = 0x8A;
            RS485_TxControl.Openble[4] = 0xA;
            RS485_TxControl.Openble[5] = 0xA;
            RS485_TxControl.Openble[6] = name2;
            RS485_TxControl.Openble[7] = name1;
            RS485_TxControl.Openble[8] = BlueTooth;

            RS485_TxControl.Openble[9] = btmac[0];
            RS485_TxControl.Openble[10] = btmac[1];
            RS485_TxControl.Openble[11] = btmac[2];
            RS485_TxControl.Openble[12] = btmac[3];
            RS485_TxControl.Openble[13] = btmac[4];
            RS485_TxControl.Openble[14] = btmac[5];
            RS485_TxControl.Openble[15] = 0x4B;
            RS485_TxControl.Openble[16] = 0x4A;
            UART_Ch2_Send_Multiple_Byte(RS485_TxControl.Openble,sizeof(RS485_TxControl.Openble));
            sendfinishflag = R485_Send_0x80();
            if(sendfinishflag == 0)
            {
                RS485_send_time = 0;
                RS485_TX_finish = 1;
                if(RS485_TX_finish == 1)
                {
                    RS485_TxControl.sendIndex++;
                }
            }
        }
        else
        {
            RS485_TxControl.sendIndex++;
        }
        
        break;

        default:
            RS485_send_time = 0;
            RS485_TxControl.sendIndex = 0;
            getbanbenhaoflag = 1;
            break;
     }
}

uint8_t backtime = 0;
void backsend(void)
{
    if(clearOdoFlag == 0)
    {
        backtime = 3;
    }
    else
    {
        backtime = 1;
    }

    if(zhenduanflag == 1)
    {
        backtime = 10;
    }
    if(RS485_send_time>=backtime)
    {
        RS485_send_time = 0;
        RS485_TX_finish = 0;
        sendnum--;
        // RS485_send_num--;
    }
}
/**
 * @brief R485状态计时函数
 */
void R485_Timer_Handel(void)
{
    // for (uint8_t i = 0; i < RS485_Rx_ID_Idx_Max; i++)
    // {
    //     if (stRS485RxVldData[i].u8Status != R485_Lost)
    //     {
    //         if (stRS485RxVldData[i].u16LostTime <= R485_LOST_TIEMR_VAL)
    //         {
    //             stRS485RxVldData[i].u16LostTime++;
    //         }
    //         else
    //         {
    //             stRS485RxVldData[i].u8Status = R485_Lost;
    //             memset(stRS485RxVldData[i].u8RecVal, 0, RS485_RX_DATA_LEN);
    //             switch (i)
    //             {
    //                 case RS485_Rx_ID40_Idx:
    //                     memset(R485_ID40h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 case RS485_Rx_ID41_Idx:
    //                     memset(R485_ID41h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 case RS485_Rx_ID42_Idx:
    //                     memset(R485_ID42h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 default:
    //                     break;
    //             }
    //         }
    //     }
    // }
}




