#ifndef _TASK_H_
#define _TASK_H_

#include "TYW_stdint.h"
#include "RSCAN.h"
#include "RTE_CAN.h"

extern uint8_t AutoFlag;
extern uint32_t devicename;
extern uint32_t send0x42time;
extern uint32_t bleOFFtoONtime;
extern uint8_t startONfalg;
extern uint32_t startIGONtime;
extern uint8_t Openble[11];
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void);
void Sys_Run_Mode_2ms_Tasks_Group(void);
void Sys_Run_Mode_5ms_Tasks_Group(void);
void Sys_Run_Mode_10ms_Tasks_Group(void);
void Sys_Run_Mode_20ms_Tasks_Group0(void);
void Sys_Run_Mode_50ms_Tasks_Group(void);
void Sys_Run_Mode_100ms_Tasks_Group(void);
void Sys_Exact_50us_Tasks(void);
void Sys_Exact_100ms_Tasks(void);
void Sys_Enter_Sleep_Mode(void);
uint16_t Sys_Get_ms_Rolling_Counter(void);

void get_key_value(void);

void init_CAN_Frame(CAN_Frame_st_t* msg, uint32_t can_id, uint8_t can_len, uint8_t can_frame_ide, const uint8_t* data);
void can_mid(CAN_Frame_st_t Msg);
void can_submit(void);

void Can_Send_0x714(void);
void Can_Send_0x714_CHECK(void);


#define UDS_F187_LEN 15U
#define UDS_F18A_LEN 5U
#define UDS_F18B_LEN 8U
#define UDS_F18C_LEN 6U

#define BT_ID_TX      0X0F4442FF   /*?? ID*/
#define BT_ID_RX      0X0F4254FF   /*BT MAC ID*/
#define BLE_ID_TX     0x0C75FFD3   /*BLE MAC ID*/
#define LY_CON_ID     0x0C21FFD3   /*???? ID*/

typedef enum
{
    FYReadState_ReqF187, 
    FYReadState_ReqF18A,
    FYReadState_ReqF18B,
    FYReadState_ReqF18C,
    FYReadState_ReadALL,
    FYReadState_Idel,
}_FYReadState_st;


typedef enum
{
    FYWriteState_Req1003, 
    FYWriteState_Req1002,
    FYWriteState_Req2701,
    FYWriteState_Req2702,
    FYWriteState_ReqF187,
    FYWriteState_ReqF18A,
    FYWriteState_ReqF18B,
    FYWriteState_ReqF18C,
    FYWriteState_WriteALL,
    FYWriteState_Idel,
}_FYWriteState_st;

extern uint8_t FYReadState;
extern uint8_t FYWriteState;
void UDS_FiveYardsRead(void );
void UDS_FiveYardsWrite(void );

void Get_Ble_Address(void);
#endif