/***********************************************************************
 * \file     Init.c
 * \brief    Initializations during work state switching
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     18-Jan-2019
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "r_device.h"
#include "rh850_macros.h"
#include "init.h"
#include "clock.h"
#include "Sys_Tick.h"
#include "Task_Scheduler.h"
#include "RTE_GPIO.h"
#include "TYW_stdint.h"
#include "COM_CAN.h"
#include "RTE_ADC.h"
#include "RTE_CAN.h"
#include "RTE_PWM.h"
#include "Internal_EEPROM.h"
#include "TimerB.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "WDT.h"
#include "RTC.h"
#include "GenDelay.h"
#include "TFT_LCD.h"
#include "RTE_WDT.h"
#include "CAN_Communication_Matrix.h"
#include "Check_Ctrl.h"
#include "Key.h"
#include "Display_Info.h"
#include "FreIn_User.h"
#include "../UART/UART.h"
#include "NVS_Test.h"
#include "Power_Controls.h"
#include "RS485_Protocol_CRC16.h"
#include "RS485_Protocol_Lib.h"
#include "RS485_Protocol_User.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/***********************************************************************
 * \brief      Initializations during work state switching
 * \attention
 * \retval     None
 ******************************************************************************/

// volatile CANMsg0F6Union      CANMsg0F6;

uint8_t u8StartupMode;
void    Sys_Startup_Pre_Init(void)
{
    Clock_Run_Mode_Init( );
}
/***********************************************************************
 * \brief      Initializations during system power up
 * \attention
 * \retval     None
 ******************************************************************************/
uint8_t firstIGON = 0xFF;
void Sys_Startup_Init(void)
{
    RTC_Pre_Init( );    //首次上电
    WDT_Init( );
    Sys_Tick_Timer_Call_Back_Reg(Sys_Process_ISR);
    RTE_GPIO_Init( );  
    Power_Controls_Init();
    NVS_Test_Init();
    GPIO_SET_KEPP( );
    RTE_ADC_Init( );
    COM_CAN_Init( );
    Can_Init( );
    RS485_Protocol_KL30_Wakeup_Init();
    enable_interrupt( );
    Sys_Tick_Timer_Start( );
    TFT_LCD_Startup( );
    Diag_Info_Init( );
    Display_Title_Info( );
    Key_Init( );
    Buzzer_Init();
    Fre_In_KL30_Wakeup_Init();
    UART_Channel_Config_st_t loc_config;
    loc_config.enUARTLINMode          = MODE_UART;
    loc_config.u32UARTbps             = 115200;
    loc_config.enUARTOrder            = UART_LSB;
    loc_config.en2UARTParity          = UART_PARITY_DISABLE;
    loc_config.en2UARTPolarity        = UART_POLARITY_NORMAL;
    loc_config.pfnUARTConfirmCallBack = 0;
    loc_config.pfnUARTErrHandleCallBack = 0;
    loc_config.pfnUARTReadMsgCallBack = RS485_UART_Put;
    firstIGON = 1;
    UART_Init(UART_RLIN30, &loc_config);

    loc_config.enUARTLINMode          = MODE_UART;
    loc_config.u32UARTbps             = 9600;
    loc_config.enUARTOrder            = UART_LSB;
    loc_config.en2UARTParity          = UART_PARITY_DISABLE;
    loc_config.en2UARTPolarity        = UART_POLARITY_NORMAL;
    loc_config.pfnUARTConfirmCallBack = 0;
    loc_config.pfnUARTErrHandleCallBack = 0;
    loc_config.pfnUARTReadMsgCallBack = UART_Put1;
    UART_Init(UART_RLIN31, &loc_config);
}

/***********************************************************************
 * \brief      Initializations during work state switch to system sleep
 * \attention
 * \retval     None
 ******************************************************************************/
void Sys_Sleep_Init(void)
{
}

/***********************************************************************
 * \brief      Initializations during work state switch to system run
 * \attention
 * \retval     None
 ******************************************************************************/
void System_Wakeup_Init(void)
{
}
