#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

typedef enum
{
    CAN_CH0_ID_Send10FF4117_Msg_Count,
    CAN_CH0_ID_Send18FEAE17_Msg_Count,
    CAN_CH0_ID_Send10FF1017_Msg_Count,
    CAN_CH0_ID_Send18FEC1EE_Msg_Count,
    CAN_CH0_ID_Send0CFE6CEE_Msg_Count,
    CAN_CH0_ID_Send18FEFC17_Msg_Count,
    CAN_CH0_ID_0x794_Msg_Count,
    CAN_CH0_ID_TOTAL_MAX,
} CAN_MSG_ID_t;

typedef enum
{
    ID_2E1_COUNT,

    ID_SEND_TOTAL,
} CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_MSG_CONST_ARRAY [ CAN_CH0_ID_TOTAL_MAX ];
extern const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] ;


#define  CAN_CH0_ID_Send10FF4117_Msg    0x10FF4117ul
#define  CAN_CH0_ID_Send18FEAE17_Msg    0x18FEAE17ul
#define  CAN_CH0_ID_Send10FF1017_Msg    0x10FF1017ul
#define  CAN_CH0_ID_Send18FEC1EE_Msg    0x18FEC1EEul
#define  CAN_CH0_ID_Send0CFE6CEE_Msg    0x0CFE6CEEul
#define  CAN_CH0_ID_Send18FEFC17_Msg    0x18FEFC17ul
#define  CAN_CH0_ID_Send0x794_Msg       0x794ul
 
extern uint32_t Get_ID_ODO(void);
extern uint32_t Get_ID_FUEL(void);
extern uint8_t Get_ID_HandBrakeSts(void);
extern uint32_t Get_ID_VSpeed(void);



extern uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HCSPS_LampFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_BackUPSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_Seatbeltsts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HandBrakeSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_2_Air_Pressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_1_Air_Pressure(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HeatedMirrorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RearFogLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_FrontFogLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LowBeamSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HighBeamSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LHParkTailLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RHParkTailLightSts(void);
extern uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_Total_Vehicle_Distance(void);
extern uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_Tachograph_vehicle_speed(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFC17_Sig_Fuel_level(void);
extern uint8_t Get_CAN_CH0_ID_794_byte0_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte1_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte2_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte3_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte4_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte5_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte6_Sig(void);
extern uint8_t Get_CAN_CH0_ID_794_byte7_Sig(void);







extern uint8_t Co_Can_ConvertSubID(uint32_t MsgID);

#endif
