#ifndef	_FUELCONFIG_H                            	
#define _FUELCONFIG_H	
#include "base_types.h"

extern uint8_t AfcValided[3];

extern uint8_t FuelSaveData[1024];
extern uint16_t FuelSaveLen;
extern uint8_t DrivingRangeSaveData[1024];
extern uint16_t DrivingRangeSaveLen;

#define DISPLAY_AFC_FUEL_ECONOMY 0
#define DISPLAY_AFC_ACCUMULATED_INFO 1
#define DISPLAY_AFC_DRIVE_INFO 2

#define FUEL_R_MIN_VAL	20	//10 X ohm
#define FUEL_R_MAX_VAL	3500    //10 X ohm

#define DISPLAY_BOUNDARY_FIRST 		3000
#define DISPLAY_BOUNDARY_SECOND		2550
#define DISPLAY_BOUNDARY_THIRD		1880
#define DISPLAY_BOUNDARY_FOURTH		1420
#define DISPLAY_BOUNDARY_FIFTH		1080
#define DISPLAY_BOUNDARY_SIXTH		820
#define DISPLAY_BOUNDARY_SEVENTH	620
#define DISPLAY_BOUNDARY_EIGHTH		450
#define DISPLAY_BOUNDARY_NINTH	        320
#define DISPLAY_BOUNDARY_TENTH		200
#define DISPLAY_BOUNDARY_ELEVENTH	150

#define BOUNDARY_FUEL_FIRST 		2700
#define BOUNDARY_FUEL_SECOND		4800
#define BOUNDARY_FUEL_THIRD		11200
#define BOUNDARY_FUEL_FOURTH		17600
#define BOUNDARY_FUEL_FIFTH		23900
#define BOUNDARY_FUEL_SIXTH	        30300
#define BOUNDARY_FUEL_SEVENTH		36700
#define BOUNDARY_FUEL_EIGHTH		43100
#define BOUNDARY_FUEL_NINTH	    	49400
#define BOUNDARY_FUEL_TENTH		55800
#define BOUNDARY_FUEL_ELEVENTH		58200



//Fuel Config
typedef struct _FuelStruct {
    uint16_t FuelShortCircuitR;
    uint16_t FuelOpenCircuitR;
    uint16_t LowFuelWarningResistance;
    uint16_t LowFuelWarningReleaseResistance;
    uint16_t LowFuelWarningFuelCapacity; 
    uint16_t FullFuelStopCapacity;      //S/F
    uint16_t EmptyFuelStopCapacity;     //S/E
    uint16_t DisplayZoneBoundary[11];
    uint16_t FuelCapacityBoundary[11];
}FuelStruct;

extern void InitFuelParamter(FuelStruct *para);
extern uint8_t *GetFuelSaveData(uint16_t *len);
extern void SetFuelSaveData(uint8_t *data, uint16_t len);

extern void SaveSampleVal(uint16_t FuelResistance); //unit:ohm,accuracy:0.1
extern void FuelFSM(uint16_t FuelResistance);

extern void SetFuelSensorRecoverGroupCnt(uint16_t n);       //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorOpenCircuitGroupCnt(uint16_t n);   //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600) 
extern void SetFuelSensorShortCircuitGroupCnt(uint16_t n);  //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)

extern uint16_t ResistanceToCapaticy(uint16_t Resistance);
extern uint16_t StepToCapacity(uint8_t Step);
extern void SetPowerSt(uint8_t n);
extern uint8_t GetFuelSeg(void); //????
extern uint8_t GetFuelStep(void); //????
extern uint8_t GetFuelStepPointer(void);
extern uint16_t GetFuelCapacityVal(void);
extern uint8_t GetFuelLFW(void);

extern void SetFuelInit(void);
extern void ExecFuel(void);


enum {
	FuelSensorNormal,
	FuelSensorShortCircuit,
	FuelSensorOpenCircuit,
	FuelSensorPreFault,
};
extern uint8_t GetFuelSensorState(void); 

enum {
	FUEL_ST_REFUEL,
	FUEL_ST_VEHICLE_RUN,
}; 
extern uint8_t GetFuelFSM_St(void);
extern uint16_t GetFuelResistance(void);
extern uint16_t GetPowerDownTimeCnt(void);  
extern uint8_t GetRefuelState(void);
extern void ClearRefuelState(void);

extern uint8_t FuelStep;

// AFC & DrivingRange
enum {
    AFC_AUTO_RESET_OFF = 1,
    AFC_AUTO_RESET_IGN_OFF_4HOUR,
    AFC_AUTO_RESET_ADD_FUEL, 
};

typedef struct _SAVE_AFC_INFO {
    uint32_t OdoData;
    uint32_t FuelConsumeData;
}SAVE_AFC_INFO;

typedef struct _AFC_INIT {
	uint32_t CurODO;		// unit:m,accuracy:1
        uint32_t DteFactoryAfc;             //unit:m,eg:13.5km/L:13500
}AFC_INIT;
extern void InitAFC(AFC_INIT *data);
extern uint8_t *GetDrivingRangeSaveData(uint16_t *len);
extern void SetDrivingRangeSaveData(uint8_t *data, uint16_t len);
extern void ResetAFC(uint8_t num, AFC_INIT *data);

typedef struct _AFC_PARA {
	uint32_t CurODO;		// unit:m,accuracy:1
	uint32_t FuleConsume;
	uint16_t RPM;
	uint16_t Speed;
    uint32_t AFC_AutoResetIgnOffSec;
    uint32_t AFC_Short_AutoResetIgnOffSec;
}AFC_PARA;
extern void SetAFCPara(AFC_PARA *data); //100ms time call

extern void AFCTimerCall(void); //must per 10ms interrupt
extern uint16_t GetDRMileage(void);  //unit:km,accuracy:1
extern void SetAFC_AutoReset(uint8_t num, uint8_t n); //0:auto reset off  1:auto reset after ign off 4 hours  2:auto reset on refuel
extern uint16_t GetAFC_KML(uint8_t n);  //10X xx.xkm/L
extern uint16_t GetAFC_100KM(uint8_t n);  //10X xx.xL/100KM
extern void ResetAFC(uint8_t num, AFC_INIT *data); 
extern void GetSaveInfo(uint8_t n, SAVE_AFC_INFO *data);
extern void SetInitAfcInfo(uint8_t n, SAVE_AFC_INFO *data);
extern uint8_t GetAfcValid(uint8_t n);
extern uint16_t GetDteFuel(void);

typedef struct {
    uint32_t DTE_Temp;                         //ʵʱDTEֵ
    uint32_t DTE_AFC;	                //unit:m/mL 
    uint32_t DTE_PresentAFC;	        //unit:m/mL         //ƽͺģʱ
    uint32_t DTE_TracePresentAFC;	        //unit:m/mL         //׷ٱƽͺģʱȼѧϰͺĺʹѧϰͺĸֵPresentAFC2mƽ
    int32_t DTE_Fuel; 
    uint16_t Gauge_Fuel;                       //ȼͱָʾȼ
    uint32_t FCO;                 
    uint32_t AFC_TempAFCSum[3];
}FUEL_TEST_DATA;
extern void GetFuelTestData(FUEL_TEST_DATA *data);
  
#endif






