#include "ResistorCalculate.h"

/*-------------------------------------------------------------------------
* Function Name  : FuelParameterInit
* Description    :
* Input          : None
* Output         : None
* Return         : unsigned int
* onther         :

                   Vcc
                  -----
                    |
                   ---
                   | |
                   | |  R5
                   ---
                    |    --------         --------
     --------------------|  R4   |-------|   R7   |----Vcpu
     |                   --------    |    --------
    ---                             ---
    | |                             | |
    | |                             | |  R6
    ---                             ---
     |                               |
    GND                             GND
--------------------------------------------------------------------------*/
void FuelParameterInit(void)
{
    g_AdcResult.R4 = 27000;
    g_AdcResult.R5 = 120;
    g_AdcResult.R6 = 18000;
    g_AdcResult.Resolution = 12;
    g_AdcResult.Threshold = 45;
    g_AdcResult.LowVoltageLimit = 690;
}

/*-------------------------------------------------------------------------
* Function Name  : FuelFormula
* Description    :
* Input          : None
* Output         : None
* Return         : unsigned short
* onther         :
--------------------------------------------------------------------------*/
unsigned int FuelFormula(void)
{
    unsigned int R_Value = 0;

    R_Value = ((g_AdcResult.fuelVcpu * (g_AdcResult.R4 + g_AdcResult.R6)) * g_AdcResult.R5) /\
               ((g_AdcResult.Vcc * g_AdcResult.R6 / 10) - (g_AdcResult.fuelVcpu * ((g_AdcResult.R4 + g_AdcResult.R5 + g_AdcResult.R6) / 10)));
    
    return R_Value;
}
