

#include <stdint.h>
#include "GPIO.h"
#include "Simulated_8080.h"
#include "TM035HFZGZx.h"
#include "RTE_WDT.h"
#include "WDT.h"
#include "GenDelay.h"


/******************************************************************************

******************************************************************************/
void LCD_Init(void)
{
    uint16_t i;
    Sim_8080_Init();
    LCD_nRST = 0;
    Gen_TimeDelay ( 5 *1000,50U);
    LCD_nRST = 1;
    Gen_TimeDelay ( 10 *1000,50U);
    Sim_8080_Command_Write ( 0x5E );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x91 );
    Sim_8080_Data_Write ( 0x01 );
    Sim_8080_Data_Write ( 0x3F );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xEF );
    Sim_8080_Command_Write ( 0x92 );
    Sim_8080_Data_Write ( 0x32 );
    Sim_8080_Data_Write ( 0x02 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x01 );
    Sim_8080_Command_Write ( 0x93 );
    Sim_8080_Data_Write ( 0x0A );
    Sim_8080_Data_Write ( 0x28 );
    Sim_8080_Data_Write ( 0x0C );
    Sim_8080_Data_Write ( 0x26 );
    Sim_8080_Command_Write ( 0x21 );
    Sim_8080_Data_Write ( 0x00 ); //翻转，正反面翻转  00  01  
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x24 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x25 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x26 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0xA2 );
    Sim_8080_Data_Write ( 0x10 );   //180度翻转；00  10
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0xA1 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x86 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x3F );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x3F );
    Sim_8080_Command_Write ( 0x71 );
    Sim_8080_Data_Write ( 0x0E );
    Sim_8080_Data_Write ( 0x0E );
    Sim_8080_Data_Write ( 0x18 );
    Sim_8080_Data_Write ( 0x18 );
    Sim_8080_Command_Write ( 0x72 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0x18 );
    Sim_8080_Data_Write ( 0x91 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x61 );
    Sim_8080_Data_Write ( 0x5F );
    Sim_8080_Data_Write ( 0x01 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Gen_TimeDelay ( 2 *1000,50U);
    Sim_8080_Command_Write ( 0x13 );
    Sim_8080_Data_Write ( 0xA5 );
    Gen_TimeDelay ( 5 *1000,50U);
    Sim_8080_Command_Write ( 0x12 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x22 );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( 0x27 );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x23 );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( 0xEF );
    Sim_8080_Command_Write ( 0x3A );
    Sim_8080_Data_Write ( 0xA5 );

    for ( i = 0; i < 9600; i++ )
        Sim_8080_Data_Write ( 0x00 );
}

void LCD_Shutdown(void)
{
    Sim_8080_Command_Write ( 0x11 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x14 );
    Sim_8080_Data_Write ( 0xA5 );
    Gen_TimeDelay ( 1 *1000,50U);
    LCD_nRST = 0;
    Gen_TimeDelay ( 5 *1000,50U);
    LCD_nRST = 1;
}

void LCD_Set_Window(uint8_t StartCol, uint8_t StartPage, uint8_t EndCol, uint8_t EndPage)
{
    Sim_8080_Command_Write ( 0x22 );
    Sim_8080_Data_Write ( StartPage );
    Sim_8080_Data_Write ( EndPage );
    Sim_8080_Data_Write ( 0x00 );
    Sim_8080_Data_Write ( 0xA5 );
    Sim_8080_Command_Write ( 0x23 );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( StartCol );
    Sim_8080_Data_Write ( 0 );
    Sim_8080_Data_Write ( EndCol );
}

void LCD_Start_Data_Writing(void)
{
    Sim_8080_Command_Write ( 0x3A );
    Sim_8080_Data_Write ( 0xA5 );
}


void LCD_Write_Data(uint8_t Data)
{
    Sim_8080_Data_Write ( Data );
}

void LCD_Start_Data_Reading(void)
{
    Sim_8080_Command_Write ( 0x39 );
    Sim_8080_Data_Write ( 0xA5 );
}

uint8_t LCD_Read_Data(void)
{
  return Sim_8080_Data_Read();
}

volatile uint32_t LCDRollingCounter;
