#ifndef API_IOCONFIG_H_
    #define API_IOCONFIG_H_

typedef enum {
    PRO_DN8C,
    PRO_DU2,
}PRO_SELECT;
extern PRO_SELECT ProSelect;

#define TEST_PRO_ODO 0
#define TEST_PRO_BACK_LIGHT 0
#define TEST_PRO_SOUND_VOLUM 0
#define TEST_PRO_LVDS 0

//按键 start
extern en_port_gpio_level_t BUTTON_S30_IN;
#define GET_BUTTON_S30_LEVEL  Port_GetPortPinLevel(0, 24, &BUTTON_S30_IN)

extern en_port_gpio_level_t BUTTON_S15_IN;
#define GET_BUTTON_S15_LEVEL    Port_GetPortPinLevel(1, 26, &BUTTON_S15_IN)

extern en_port_gpio_level_t BUTTON_AUTO_IN; 
#define GET_BUTTON_AUTO_LEVEL  Port_GetPortPinLevel(1, 27, &BUTTON_AUTO_IN)

extern en_port_gpio_level_t BUTTON_EOL_IN;
#define GET_BUTTON_EOL_LEVEL  Port_GetPortPinLevel(0, 5, &BUTTON_EOL_IN)

extern en_port_gpio_level_t BUTTON_SPEED_UP_IN;
#define GET_BUTTON_SPEED_UP_LEVEL    Port_GetPortPinLevel(1, 29, &BUTTON_SPEED_UP_IN)

extern en_port_gpio_level_t BUTTON_SPEED_DOWN_IN;
#define GET_BUTTON_SPEED_DOWN_LEVEL  Port_GetPortPinLevel(1, 30, &BUTTON_SPEED_DOWN_IN)

extern en_port_gpio_level_t BUTTON_LED_IN;
#define GET_BUTTON_LED_LEVEL  Port_GetPortPinLevel(1, 28, &BUTTON_LED_IN)

extern en_port_gpio_level_t BUTTON_IOL_UP_IN;
#define GET_BUTTON_IOL_UP_LEVEL  Port_GetPortPinLevel(1, 31, &BUTTON_IOL_UP_IN)

extern en_port_gpio_level_t BUTTON_IOL_DOWN_IN;
#define GET_BUTTON_IOL_DOWN_LEVEL  Port_GetPortPinLevel(0, 9, &BUTTON_IOL_DOWN_IN)

extern en_port_gpio_level_t BUTTON_TFT_UP_IN;
#define GET_BUTTON_TFT_UP_LEVEL  Port_GetPortPinLevel(0, 1, &BUTTON_TFT_UP_IN)

extern en_port_gpio_level_t BUTTON_TFT_DOWN_IN;
#define GET_BUTTON_TFT_DOWN_LEVEL  Port_GetPortPinLevel(0, 2, &BUTTON_TFT_DOWN_IN)

extern en_port_gpio_level_t BUTTON_ELSE_IN;
#define GET_BUTTON_ELSE_LEVEL  Port_GetPortPinLevel(0, 3, &BUTTON_ELSE_IN)

extern en_port_gpio_level_t BUTTON_END_IN;
#define GET_BUTTON_END_LEVEL  Port_GetPortPinLevel(0, 4, &BUTTON_END_IN)
//按键 end

//档位 start

//extern en_port_gpio_level_t BUTTON_S_IN;
//#define GET_BUTTON_S_LEVEL  Port_GetPortPinLevel(1, 19, &BUTTON_S_IN)

//extern en_port_gpio_level_t BUTTON_D_IN;
//#define GET_BUTTON_D_LEVEL  Port_GetPortPinLevel(1, 20, &BUTTON_D_IN)

//extern en_port_gpio_level_t BUTTON_N_IN;
//#define GET_BUTTON_N_LEVEL  Port_GetPortPinLevel(1, 21, &BUTTON_N_IN)

//extern en_port_gpio_level_t BUTTON_R_IN;
//#define GET_BUTTON_R_LEVEL  Port_GetPortPinLevel(1, 22, &BUTTON_R_IN)

//extern en_port_gpio_level_t BUTTON_P_IN;
//#define GET_BUTTON_P_LEVEL  Port_GetPortPinLevel(1, 23, &BUTTON_P_IN)

extern en_port_gpio_level_t BUTTON_N_IN;
#define GET_BUTTON_N_LEVEL  Port_GetPortPinLevel(2, 13, &BUTTON_N_IN)

extern en_port_gpio_level_t BUTTON_1_IN;
#define GET_BUTTON_1_LEVEL  Port_GetPortPinLevel(2, 14, &BUTTON_1_IN)

extern en_port_gpio_level_t BUTTON_2_IN;
#define GET_BUTTON_2_LEVEL  Port_GetPortPinLevel(2, 3, &BUTTON_2_IN)

extern en_port_gpio_level_t BUTTON_3_IN;
#define GET_BUTTON_3_LEVEL  Port_GetPortPinLevel(2, 20, &BUTTON_3_IN)

extern en_port_gpio_level_t BUTTON_4_IN;
#define GET_BUTTON_4_LEVEL  Port_GetPortPinLevel(2, 29, &BUTTON_4_IN)

extern en_port_gpio_level_t BUTTON_5_IN;
#define GET_BUTTON_5_LEVEL  Port_GetPortPinLevel(2, 27, &BUTTON_5_IN)

extern en_port_gpio_level_t BUTTON_6_IN;
#define GET_BUTTON_6_LEVEL  Port_GetPortPinLevel(2, 12, &BUTTON_6_IN)

//燃油
//extern en_port_gpio_level_t BUTTON_Oil_WATER_IN;
//#define GET_BUTTON_Oil_WATER_LEVEL  Port_GetPortPinLevel(1, 25, &BUTTON_Oil_WATER_IN) //燃油水温

//报警
extern en_port_gpio_level_t BUTTON_LED_IN;
#define GET_BUTTON_LED_LEVEL  Port_GetPortPinLevel(1, 28, &BUTTON_LED_IN) //报警


//档位 end

//extern en_port_gpio_level_t BUTTON_DEFOG_IN;
//#define GET_BUTTON_DEFOG_LEVEL  Port_GetPortPinLevel(1, 15, &BUTTON_DEFOG_IN)

//extern en_port_gpio_level_t BUTTON_SEATBELT_IN;
//#define GET_BUTTON_SEATBELT_LEVEL  Port_GetPortPinLevel(1, 13, &BUTTON_SEATBELT_IN) // 副驾驶安全带信息

extern en_port_gpio_level_t BUTTON_ALTL_IN;
#define GET_BUTTON_ALTL_LEVEL  Port_GetPortPinLevel(1, 11, &BUTTON_ALTL_IN) //电池

extern en_port_gpio_level_t BUTTON_BackLigth_IN;
#define GET_BUTTON_BackLight_LEVEL  Port_GetPortPinLevel(1, 4, &BUTTON_BackLigth_IN) //ILL

//extern en_port_gpio_level_t BUTTON_HOODOPEN_IN;
//#define GET_BUTTON_HOODOPEN_LEVEL  Port_GetPortPinLevel(2, 19, &BUTTON_HOODOPEN_IN)



//#define F_LCD_RESET(Level)     Port_SetPortPinLevel(1, 29, (Level))
#define F_LCD_STBYB(Level)     Port_SetPortPinLevel(0, 4, (Level))
//#define P_61194_EN(Level)      Port_SetPortPinLevel(2, 13, (Level))
#define P_3V3MCU_EN(Level)     Port_SetPortPinLevel(1, 4, (Level))

//#define P_RELAY_B_MCU(Level)   Port_SetPortPinLevel(1, 20, (Level))
#define P_RELAY_IG_MCU(Level)   Port_SetPortPinLevel(1, 19, (Level))

//#define P_APOWER_OUT(Level)    Port_SetPortPinLevel(1, 19, (Level))
#define P_78324_EN(Level)      Port_SetPortPinLevel(0, 30, (Level))
#define F_Sound_EN(Level)      Port_SetPortPinLevel(0, 31, (Level))
#define NEW_F_Sound_EN(Level)  Port_SetPortPinLevel(1, 24, (Level))
//#define P_VCC3V3_EN(Level)     Port_SetPortPinLevel(2, 0, (Level))
#define P_VCC4V2_EN(Level)     Port_SetPortPinLevel(0, 1, (Level))
#define P_BD12_EN(Level)       Port_SetPortPinLevel(0, 5, (Level))
//#define P_949ALL_EN(Level)     Port_SetPortPinLevel(0, 0, (Level))
#define P_1531_EN(Level)       Port_SetPortPinLevel(2, 03, (Level))
#define P_TPA6211_EN(Level)    Port_SetPortPinLevel(1, 24, (Level))

#define FUEL_IN_EN(Level)      Port_SetPortPinLevel( 2, 12, (Level));

//#define R_OUT(Level)     Port_SetPortPinLevel(2, 14, (Level))
//#define N_OUT(Level)     Port_SetPortPinLevel(2, 27, (Level))

//电源
#define P_RELAY_B_MCU(Level)   Port_SetPortPinLevel(1, 20, (Level))
#define P_RELAY_B1_MCU(Level)   Port_SetPortPinLevel(1, 15, (Level))
#define P_RELAY_IG_MCU(Level)   Port_SetPortPinLevel(1, 19, (Level))
#define P_RELAY_IG_MCU(Level)   Port_SetPortPinLevel(1, 19, (Level))
#define P_RELAY_IG_MCU(Level)   Port_SetPortPinLevel(1, 19, (Level))
//档位
#define GEAR_N_OUT(Level)      Port_SetPortPinLevel(2, 13, (Level))
#define GEAR_1_OUT(Level)      Port_SetPortPinLevel(2, 14, (Level))
#define GEAR_2_OUT(Level)      Port_SetPortPinLevel(2,  3, (Level))
#define GEAR_3_OUT(Level)      Port_SetPortPinLevel(2, 20, (Level))
#define GEAR_4_OUT(Level)      Port_SetPortPinLevel(2, 29, (Level))
#define GEAR_5_OUT(Level)      Port_SetPortPinLevel(2, 27, (Level))
#define GEAR_6_OUT(Level)      Port_SetPortPinLevel(2, 12, (Level))


//灯
#define LIG_left_OUT(Level)      Port_SetPortPinLevel(2, 0, (Level))//左转
#define LIG_right_OUT(Level)     Port_SetPortPinLevel(1, 24, (Level))//右转
#define LIG_HighBeam_OUT(Level)     Port_SetPortPinLevel(2, 1, (Level))//远光
#define LIG_ABS_OUT(Level)     Port_SetPortPinLevel(2, 21, (Level))//ABS
#define LIG_Oil_OUT(Level)     Port_SetPortPinLevel(0, 0, (Level))//机油压力

//速度
#define _speed_out(Level)     Port_SetPortPinLevel(1, 29, (Level))
//#define _speed_out(Level)     Port_SetPortPinLevel(1, 17, (Level))//速度
//#define _R_speed_out(Level)     Port_SetPortPinLevel(1, 16, (Level))//转速

//燃油
#define _OIL1_out(Level)     Port_SetPortPinLevel(1, 25, (Level))//1格
#define _OIL2_out(Level)     Port_SetPortPinLevel(1, 23, (Level))//2格 
#define _OIL3_out(Level)     Port_SetPortPinLevel(1, 22, (Level))//3格
#define _OIL4_out(Level)     Port_SetPortPinLevel(1, 21, (Level))//4格
#define _OIL5_out(Level)     Port_SetPortPinLevel(1, 13, (Level))//5格
#define _OIL6_out(Level)     Port_SetPortPinLevel(1, 11, (Level))//6格
#define _OIL7_out(Level)     Port_SetPortPinLevel(1, 10, (Level))//7格
#define _OIL8_out(Level)     Port_SetPortPinLevel(0, 27, (Level))//8格

//霍尔档位
#define _GEAR1_out(Level)     Port_SetPortPinLevel(2, 10, (Level))//1档
#define _GEAR2_out(Level)     Port_SetPortPinLevel(2, 8, (Level))//2档
#define _GEAR3_out(Level)     Port_SetPortPinLevel(2, 7, (Level))//3档
#define _GEAR4_out(Level)     Port_SetPortPinLevel(2, 6, (Level))//4档
#define _GEAR5_out(Level)     Port_SetPortPinLevel(2, 5, (Level))//5档
#define _GEAR6_out(Level)     Port_SetPortPinLevel(2, 4, (Level))//6档
#define _GEARN_out(Level)     Port_SetPortPinLevel(2, 9, (Level))//N档

#define CAN0_STB(Level) Port_SetPortPinLevel(0, 29, (Level))
//#define CAN1_STB(Level) Port_SetPortPinLevel(1, 22, PortGpioHigh)
//#define CAN1_EN(Level) Port_SetPortPinLevel(1, 21, PortGpioHigh)

//extern en_port_gpio_level_t Can1Rx_IN;
//#define GET_CAN1_RX_IN_LEVEL  Port_GetPortPinLevel(0, 27, &Can1Rx_IN)

extern void Api_GPIO_Init(void);
extern void ApiPowerSupply(void);

#endif /* API_IOCONFIG_H_ */
//