#include <stdint.h>
#include "common_include.h"

#define DISPLAY_MAX_TP_DATA_NUM 20

uint8_t MCanMiniTpData_Fm[MM_CAN_DATA_LEN_MAX]; //fm
uint8_t MCanMiniTpData_DMB[MM_CAN_DATA_LEN_MAX]; //DMB
uint8_t MCanMiniTpData_SXM[MM_CAN_DATA_LEN_MAX]; //SXM/XM
uint8_t MCanMiniTpData_DAB[MM_CAN_DATA_LEN_MAX]; //DAB
uint8_t MCanMiniTpData_CD[MM_CAN_DATA_LEN_MAX]; //CD
uint8_t MCanMiniTpData_DVD[MM_CAN_DATA_LEN_MAX]; //DVD
uint8_t MCanMiniTpData_iPod[MM_CAN_DATA_LEN_MAX]; //iPod
uint8_t MCanMiniTpData_USB[MM_CAN_DATA_LEN_MAX]; //USB
uint8_t MCanMiniTpData_Juke[MM_CAN_DATA_LEN_MAX]; //Juke Box/My Music
uint8_t MCanMiniTpData_BTSong[MM_CAN_DATA_LEN_MAX]; //BT Song
uint8_t MCanMiniTpData_AndroidAuto[MM_CAN_DATA_LEN_MAX]; //Android Auto
uint8_t MCanMiniTpData_CarPlay[MM_CAN_DATA_LEN_MAX]; //Car Play
uint8_t MCanMiniTpData_QQMusic[MM_CAN_DATA_LEN_MAX]; //QQ Music
uint8_t MCanMiniTpData_TingBan[MM_CAN_DATA_LEN_MAX]; //Ting Ban
uint8_t MCanMiniTpData_BaiduMusic[MM_CAN_DATA_LEN_MAX]; //Baidu Music
uint8_t MCanMiniTpData_CarLife[MM_CAN_DATA_LEN_MAX]; //Car life
uint8_t MCanMiniTpData_hfname[MM_CAN_DATA_LEN_MAX]; //hfname
uint8_t MCanMiniTpData_hfno[MM_CAN_DATA_LEN_MAX]; //hfno
uint8_t MCanMiniTpData_iBox[MM_CAN_DATA_LEN_MAX]; //iBox

uint32_t CurDisplayAvId;
uint32_t DestDisplayAvId;
uint32_t LastAvTpId = 0;
uint8_t MCanTpData[MM_CAN_DATA_LEN_MAX];
uint8_t MCanMiniTpData[MM_CAN_DATA_LEN_MAX];

uint8_t MCanTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_ON;
uint8_t MCanMiniTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_ON;
uint16_t NaviDisplayChars[NAVI_FONT_MAX_CHAR] = {0};
uint16_t NaviESTPointDisplayChars[4][NAVI_FONT_MAX_CHAR] = {0};
uint16_t MiniDisplayChars[NAVI_FONT_MAX_CHAR] = {0};
uint16_t LastMiniDisplayChars[NAVI_FONT_MAX_CHAR] = {0};


uint8_t abcf[8];
uint8_t TBT_GuideTPLen = 0;
uint8_t TBT_GuideTPBuff[100] = {0};

void AnalysisCanTp(void)
{
  //  uint16_t DisplayLen = 0;
    uint8_t i = 0;
    if (MCanTpDataNewValid == MM_CAN_TP_DATA_DISPLAY_OFF_RENDERING) {
        //ClearFontBuffer();
        for(i=0;i<8;i++)
        {
            abcf[i] = MCanTpData[i];
        }
        
    }
   
    
}

uint16_t GetFontDisplayMaxLen(uint16_t *DisplayChar, uint16_t MaxWidth)
{
    uint8_t i;
    uint8_t Num = 0;
    uint16_t len = 0;
    for (i = 0; i < NAVI_FONT_MAX_CHAR; i++) {
        if (DisplayChar[(NAVI_FONT_MAX_CHAR - 1) - i] != 0) {
            Num = NAVI_FONT_MAX_CHAR - i;
            break;
        }
    }
    
    for (i = 0; i < Num; i++) {
        if (len <= MaxWidth) {
            len += 1;
        } else {
            DisplayChar[i] = 0;
            break;
        }
    }
    
    if (i < Num) {
        if ((DisplayChar[i - 1] & 0xff00) == 0) {
            if (i - 2) {
                DisplayChar[i - 2] = 0x2026;
                i--;
            }
        } else {
            DisplayChar[i - 1] = 0x2026;
        }
        for (; i < Num; i++) {
            DisplayChar[i] = 0;
        }
    }
    return len;
}

uint32_t TpGetRespId(uint32_t ReqId)
{
    LastAvTpId = ReqId;
    if (ReqId == 0x7ce)
    {               //navi
        return 0x48c;
   
    }
    return 0;
}

static uint8_t *GetpTpData(uint32_t ReqId)
{
    if (ReqId == 0x7ce) {               //fm
        return MCanMiniTpData_Fm;
    } else {
        return NULL;
    }
}

void TpRecvNewDataNavi(uint8_t *data, uint16_t len)
{
    MCanTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_OFF_NEW_DATA;  
    if ((len == 0x2) && (data[0] == 0) && (data[1] == 0)) {

    }
}


void TpRecvNewDataAv(uint8_t *data, uint16_t len)
{
    uint8_t *pTpdata = NULL;
    if ((len == 0x2) && (data[0] == 0) && (data[1] == 0)) {

    }
}

static void SetTpDestDisplayId(uint8_t n)
{
    switch (n) {
        case TP_DEST_NONE:          DestDisplayAvId = NULL;     break;
        case TP_DEST_FM:            DestDisplayAvId = 0x4e8;     break;
        case TP_DEST_DMB:           DestDisplayAvId = 0x4b4;     break;
        case TP_DEST_SXM:           DestDisplayAvId = 0x4b6;     break;
        case TP_DEST_DAB:           DestDisplayAvId = 0x4b7;     break;
        case TP_DEST_CD:            DestDisplayAvId = 0x48d;     break;
        case TP_DEST_DVD:           DestDisplayAvId = 0x48e;     break;
        case TP_DEST_iPod:          DestDisplayAvId = 0x48f;     break;
        case TP_DEST_USB:           DestDisplayAvId = 0x490;     break;
        case TP_DEST_MyMusic:       DestDisplayAvId = 0x4e2;     break;
        case TP_DEST_BTSong:        DestDisplayAvId = 0x4f6;     break;
        case TP_DEST_AndroidAuto:   DestDisplayAvId = 0x4f4;     break;
        case TP_DEST_CarPlay:       DestDisplayAvId = 0x4f2;     break;
        case TP_DEST_QQMusic:       DestDisplayAvId = 0x4e4;     break;
        case TP_DEST_TingBan:       DestDisplayAvId = 0x4e6;     break;
        case TP_DEST_BaiduMusic:    DestDisplayAvId = 0x4ec;     break;
        case TP_DEST_Carlife:       DestDisplayAvId = 0x4f0;     break;
        case TP_DEST_hfname:        DestDisplayAvId = 0x4f8;     break;
        case TP_DEST_hfno:          DestDisplayAvId = 0x485;     break;
        case TP_DEST_iBox:          DestDisplayAvId = 0x4ee;     break;
        default:                    DestDisplayAvId = NULL;     break;
    }
}

void SetMiniPopupDisplayTp(uint8_t n)
{
    if ((n == 0x11) || (n == 0x12) || (n == 0x13) || (n == 0x18) || (n == 0x14) || (n == 0x19) || (n == 0x21) || (n == 0x22) || (n == 0x23) || (n == 0x24)) {
        SetTpDestDisplayId(TP_DEST_FM);
    } else if ((n == 0x31) || (n == 0x32) || (n == 0x33) || (n == 0x34)) {
        SetTpDestDisplayId(TP_DEST_SXM);
    } else if ((n == 0x36) || (n == 0x37) || (n == 0x38) || (n == 0x39)) {
        SetTpDestDisplayId(TP_DEST_DAB);
    } else if ((n == 0x41) || (n == 0x45) || (n == 0x46)) {
        SetTpDestDisplayId(TP_DEST_DMB);
    } else if (n == 0x52) {
        SetTpDestDisplayId(TP_DEST_CD);
    } else if ((n == 0x7) || (n == 0xf)) {
        SetTpDestDisplayId(TP_DEST_MyMusic);
    } else if ((n == 0x61) || (n == 0xd) || (n == 0x10)) {
        SetTpDestDisplayId(TP_DEST_iPod);
    } else if ((n == 0x62) || (n == 0x64) || (n == 0x65) || (n == 0xc) || (n == 0x6d)) {
        SetTpDestDisplayId(TP_DEST_USB);
    } else if (n == 0x8) {
        SetTpDestDisplayId(TP_DEST_BTSong);
    } else if (n == 0x6e) {
        SetTpDestDisplayId(TP_DEST_CarPlay);
    } else if (n == 0x6f) {
        SetTpDestDisplayId(TP_DEST_AndroidAuto);
    } else if (n == 0x54) {
        SetTpDestDisplayId(TP_DEST_DVD);
    } else if (n == 0x5b) {
        SetTpDestDisplayId(TP_DEST_Carlife);
    } else if (n == 0x7d) {
        SetTpDestDisplayId(TP_DEST_BaiduMusic);
    } else if (n == 0xe) {
        SetTpDestDisplayId(TP_DEST_TingBan);
    } else if (n == 0x7e) {
        SetTpDestDisplayId(TP_DEST_QQMusic);
    } else if (n == 0x1) {
        SetTpDestDisplayId(TP_DEST_iBox);
    }
}

void UpdateTpData(void)
{
    uint8_t *pTpdata = NULL;
    uint8_t EmptyTpData[MM_CAN_DATA_LEN_MAX] = {0};
    pTpdata = GetpTpData(DestDisplayAvId);
    if (pTpdata) {
        if (DestDisplayAvId == CurDisplayAvId) {
            if (memcmp(pTpdata, EmptyTpData, MM_CAN_DATA_LEN_MAX) == 0) {
                if (memcmp(MCanMiniTpData, EmptyTpData, MM_CAN_DATA_LEN_MAX) != 0) {
                    MCanMiniTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_OFF_NEW_DATA;
                    memset(MCanMiniTpData, 0, MM_CAN_DATA_LEN_MAX);
                   // AV_TPLen = 0;
                }
            } else if (memcmp(pTpdata, MCanMiniTpData, MM_CAN_DATA_LEN_MAX) != 0) {
                MCanMiniTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_OFF_NEW_DATA;
                memset(MCanMiniTpData, 0, sizeof (MCanTpData));
                memcpy(MCanMiniTpData, pTpdata, MM_CAN_DATA_LEN_MAX);
            }
        } else if (DestDisplayAvId != CurDisplayAvId) {
            CurDisplayAvId = DestDisplayAvId;
            if (memcmp(pTpdata, MCanMiniTpData, MM_CAN_DATA_LEN_MAX) != 0) {
                MCanMiniTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_OFF_NEW_DATA;
                memset(MCanMiniTpData, 0, sizeof (MCanTpData));
                memcpy(MCanMiniTpData, pTpdata, MM_CAN_DATA_LEN_MAX);
            }
        }
    } else {
        memset(MCanMiniTpData, 0, MM_CAN_DATA_LEN_MAX);
    }
}
