#include "common_include.h"
#include "bsp_trip_key.h"
#define NewTripKey
#ifdef NewTripKey

#define PressTripKeyMenu(dwnS,dwnE,upS,upE,ledIdx)\
  if (dwnS < TripKeyCurrent.Time && TripKeyCurrent.Time < dwnE) {\
     LampState_M.Lamps.TripSW2_4  = 1;\
     LampState_M.Lamps.TripSW2_3  = 0;\
     LampState_M.Lamps.TripSW2_2  = 0;\
     LampState_M.Lamps.TripSW2_1  = 0;\
 } \
 if (upS< TripKeyCurrent.Time && TripKeyCurrent.Time < upE) {\
     LampState_M.Lamps.TripSW2_4  = 0;\
     LampState_M.Lamps.TripSW2_3  = 0;\
     LampState_M.Lamps.TripSW2_2  = 0;\
     LampState_M.Lamps.TripSW2_1  = 0;\
     LightLedLampOnly(ledIdx);\
 }

#define PressTripKeyOk(dwnS,dwnE,upS,upE,ledIdx)\
 if (dwnS < TripKeyCurrent.Time && TripKeyCurrent.Time < dwnE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 0;\
    LampState_M.Lamps.TripSW2_2  = 0;\
    LampState_M.Lamps.TripSW2_1  = 1;\
} \
if (upS< TripKeyCurrent.Time && TripKeyCurrent.Time < upE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 0;\
    LampState_M.Lamps.TripSW2_2  = 0;\
    LampState_M.Lamps.TripSW2_1  = 0;\
    LightLedLampOnly(ledIdx);\
}

#define PressTripKeyDown(dwnS,dwnE,upS,upE,ledIdx)\
 if (dwnS < TripKeyCurrent.Time && TripKeyCurrent.Time < dwnE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 0;\
    LampState_M.Lamps.TripSW2_2  = 1;\
    LampState_M.Lamps.TripSW2_1  = 0;\
} \
if (upS< TripKeyCurrent.Time && TripKeyCurrent.Time < upE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 0;\
    LampState_M.Lamps.TripSW2_2  = 0;\
    LampState_M.Lamps.TripSW2_1  = 0;\
    LightLedLampOnly(ledIdx);\
}

#define PressTripKeyUp(dwnS,dwnE,upS,upE,ledIdx)\
 if (dwnS < TripKeyCurrent.Time && TripKeyCurrent.Time < dwnE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 1;\
    LampState_M.Lamps.TripSW2_2  = 0;\
    LampState_M.Lamps.TripSW2_1  = 0;\
} \
if (upS< TripKeyCurrent.Time && TripKeyCurrent.Time < upE) {\
    LampState_M.Lamps.TripSW2_4  = 0;\
    LampState_M.Lamps.TripSW2_3  = 0;\
    LampState_M.Lamps.TripSW2_2  = 0;\
    LampState_M.Lamps.TripSW2_1  = 0;\
    LightLedLampOnly(ledIdx);\
}


void LightLedLamp(uint8_t lightLampIndex){
    switch(lightLampIndex){
            case 0:
                LampState_M.Lamps.LED7 = 0;   //LED7
                LampState_M.Lamps.LED6 = 0;   //LED6
                LampState_M.Lamps.LED5 = 0;   //LED5
                LampState_M.Lamps.LED4 = 0;   //LED4
                LampState_M.Lamps.LED3 = 0;   //LED3
                LampState_M.Lamps.LED2 = 0;   //LED2
                LampState_M.Lamps.LED1 = 0;   //LED1
            break;
            case 1:
                LampState_M.Lamps.LED1 = 1;   //LED1
            break;
            case 2:
                LampState_M.Lamps.LED2 = 1;   //LED2
            break;
            case 3:
                LampState_M.Lamps.LED3 = 1;   //LED3
            break;
            case 4:
                LampState_M.Lamps.LED4 = 1;   //LED4
            break;
            case 5:
                LampState_M.Lamps.LED5 = 1;   //LED5
            break;
            case 6:
                LampState_M.Lamps.LED6 = 1;   //LED6
            break;
            case 7:
                LampState_M.Lamps.LED7 = 1;   //LED7
            break;
        }
}

void LightLedLampOnly(uint8_t lightLampIndex){
    LightLedLamp(OFF_ALL_LED);
    LightLedLamp(lightLampIndex);
}

void TripKeyMenu(uint8_t uiKeyPressOrder){
    switch(uiKeyPressOrder){
        case 1:
            PressTripKeyMenu(DOWN1_S,DOWN1_E,UP1_S,UP1_E,LIGHT_LED1);
            break;
        case 2:
            PressTripKeyMenu(DOWN2_S,DOWN2_E,UP2_S,UP2_E,LIGHT_LED2);
            break;
        case 3:
            PressTripKeyMenu(DOWN3_S,DOWN3_E,UP3_S,UP3_E,LIGHT_LED3);
            break;
        case 4:
            PressTripKeyMenu(DOWN4_S,DOWN4_E,UP4_S,UP4_E,LIGHT_LED4);
            break;
        case 5:
            PressTripKeyMenu(DOWN5_S,DOWN5_E,UP5_S,UP5_E,LIGHT_LED5);
            break;
        case 6:
            PressTripKeyMenu(DOWN6_S,DOWN6_E,UP6_S,UP6_E,LIGHT_LED6);
            break;
        case 7:
            PressTripKeyMenu(DOWN7_S,DOWN7_E,UP7_S,UP7_E,LIGHT_LED7);
            break;
        case 8:
            PressTripKeyMenu(DOWN8_S,DOWN8_E,UP8_S,UP8_E,OFF_ALL_LED);
            break;
    }
}

void TripKeyDown(uint8_t uiKeyPressOrder){
    switch(uiKeyPressOrder){
        case 1:
            PressTripKeyDown(DOWN1_S,DOWN1_E,UP1_S,UP1_E,LIGHT_LED1);
            break;
        case 2:
            PressTripKeyDown(DOWN2_S,DOWN2_E,UP2_S,UP2_E,LIGHT_LED2);
            break;
        case 3:
            PressTripKeyDown(DOWN3_S,DOWN3_E,UP3_S,UP3_E,LIGHT_LED3);
            break;
        case 4:
            PressTripKeyDown(DOWN4_S,DOWN4_E,UP4_S,UP4_E,LIGHT_LED4);
            break;
        case 5:
            PressTripKeyDown(DOWN5_S,DOWN5_E,UP5_S,UP5_E,LIGHT_LED5);
            break;
        case 6:
            PressTripKeyDown(DOWN6_S,DOWN6_E,UP6_S,UP6_E,LIGHT_LED6);
            break;
        case 7:
            PressTripKeyDown(DOWN7_S,DOWN7_E,UP7_S,UP7_E,LIGHT_LED7);
            break;
        case 8:
            PressTripKeyDown(DOWN8_S,DOWN8_E,UP8_S,UP8_E,OFF_ALL_LED);
            break;
    }
}

void TripKeyUp(uint8_t uiKeyPressOrder){
    switch(uiKeyPressOrder){
        case 1:
            PressTripKeyUp(DOWN1_S,DOWN1_E,UP1_S,UP1_E,LIGHT_LED1);
            break;
        case 2:
            PressTripKeyUp(DOWN2_S,DOWN2_E,UP2_S,UP2_E,LIGHT_LED2);
            break;
        case 3:
            PressTripKeyUp(DOWN3_S,DOWN3_E,UP3_S,UP3_E,LIGHT_LED3);
            break;
        case 4:
            PressTripKeyUp(DOWN4_S,DOWN4_E,UP4_S,UP4_E,LIGHT_LED4);
            break;
        case 5:
            PressTripKeyUp(DOWN5_S,DOWN5_E,UP5_S,UP5_E,LIGHT_LED5);
            break;
        case 6:
            PressTripKeyUp(DOWN6_S,DOWN6_E,UP6_S,UP6_E,LIGHT_LED6);
            break;
        case 7:
            PressTripKeyUp(DOWN7_S,DOWN7_E,UP7_S,UP7_E,LIGHT_LED7);
            break;
        case 8:
            PressTripKeyUp(DOWN8_S,DOWN8_E,UP8_S,UP8_E,OFF_ALL_LED);
            break;
    }
}

void TripKeyOk(uint8_t uiKeyPressOrder){
    switch(uiKeyPressOrder){
        case 1:
            PressTripKeyOk(DOWN1_S,DOWN1_E,UP1_S,UP1_E,LIGHT_LED1);
            break;
        case 2:
            PressTripKeyOk(DOWN2_S,DOWN2_E,UP2_S,UP2_E,LIGHT_LED2);
            break;
        case 3:
            PressTripKeyOk(DOWN3_S,DOWN3_E,UP3_S,UP3_E,LIGHT_LED3);
            break;
        case 4:
            PressTripKeyOk(DOWN4_S,DOWN4_E,UP4_S,UP4_E,LIGHT_LED4);
            break;
        case 5:
            PressTripKeyOk(DOWN5_S,DOWN5_E,UP5_S,UP5_E,LIGHT_LED5);
            break;
        case 6:
            PressTripKeyOk(DOWN6_S,DOWN6_E,UP6_S,UP6_E,LIGHT_LED6);
            break;
        case 7:
            PressTripKeyOk(DOWN7_S,DOWN7_E,UP7_S,UP7_E,LIGHT_LED7);
            break;
        case 8:
            PressTripKeyOk(DOWN8_S,DOWN8_E,UP8_S,UP8_E,OFF_ALL_LED);
            break;
    }
}
#endif
