/******************************************************************************
* $Revision: 423 $
* $Date:: 2017-04-07 16:03:30 +0900#$
*****************************************************************************/

/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/

/*****************************************************************************
** \file rtc.c
**
** A detailed description is available at
** @link RtcGroup Real time clock (RTC) description @endlink
**
** History:
**   - 2014-05-16  0.01  HS  Initial version for Traveo
*****************************************************************************/

#include "common_include.h"


uint32_t u32Count = 0;
uint8_t  m_u8Hours = 0;
uint8_t  m_u8Minutes = 0;
uint8_t  m_u8Seconds = 0;


static stc_rtc_intern_data_t m_stcRtcInternData;

void Rtc_Callback(void)
{
  
}

/*------------------------------------------------------------------
Function:       // bsp_RtcMode_Isr
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
__irq __arm void bsp_RtcMode_Isr(void)
{
    /* Clear interrupt flag */
    
    PDL_WRITE_REG_SYNC(RTC_WINC, RTC_WINS);

    if (m_stcRtcInternData.pfnCallback != NULL)
    {
        m_stcRtcInternData.pfnCallback();
    }

    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_98;
}

/*------------------------------------------------------------------
Function:       // BSP_RTC_Init
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
void BSP_RTC_Init(void)
{
    m_stcRtcInternData.pfnCallback = &Rtc_Callback;
    
    RTC_WTCR_ST =1;
    while (0 == RTC_WTSR_RUN);
    RTC_WTCR_ST =0;
    
    RTC_WTCR_CSM = 0;         
    
    RTC_WRT   = 0x00000000;
    
    RTC_WTBR = 0x1E847F;      
    
    RTC_WTCR_UPDT = 1;        
    
    RTC_WTCR_RCKSEL = 0;       /*Main clock*/

    RTC_WINC = 0x7F;
    while(RTC_WINS !=  0);
    
    RTC_PWUTRGCR = 0x00032000;
    while(RTC_PWUTRGSR ==  0x0001);
    
    /* Interrupt Controller*/
    IRC0_UNLOCK = 0x17ACC911;
    IRC0_IRQHC = 98;
    IRC0_IRQCES3_IRQCES98 = 0x1;
    IRC0_UNLOCK = 0x17B10C11;
      
    RTC_WINE_SECE    = 0;     
    RTC_WINE_MINE    = 0;     
    RTC_WINE_HOURE   = 0;     
    RTC_WINE_DAYE    = 0;     
    RTC_WINE_SUBSECE = 0;     
    RTC_WINE_CALDE   = 0;     
    RTC_WINE_CFDE    = 0;      /*Calibration failure detection interrupt*/
    
    RTC_WTCR_ST = 1;
}
/*------------------------------------------------------------------
Function:       // Rtc_Stop
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
void Rtc_Stop(void)
{
    /* Disable interrupt */
    RTC_WINE_SECE = 0;
    
    /* Stop RTC and clear time settings */
    RTC_WTCR_ST =1;
    while (0 == RTC_WTSR_RUN);
    RTC_WTCR_ST =0;
}


/*------------------------------------------------------------------
Function:       // bsp_RTC_GetTime
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
void bsp_RTC_GetTime(uint8_t* pu8Hours, uint8_t* pu8Minutes, uint8_t* pu8Seconds)
{
    //*pu16Days   = RTC_RTR1_WTDR;
    *pu8Hours   = RTC_WRT_WTHR;
    *pu8Minutes = RTC_WRT_WTMR;
    *pu8Seconds = RTC_WRT_WTSR; 
}

/*------------------------------------------------------------------
Function:       // bsp_RTC_Service_GetTime
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
void bsp_RTC_Service_GetTime(uint16_t* pu16Days,uint8_t* pu8Hours, uint8_t* pu8Minutes)
{
    *pu16Days   = RTC_RTR1_WTDR;
    *pu8Hours   = RTC_WRT_WTHR;
    *pu8Minutes = RTC_WRT_WTMR;
}

/*------------------------------------------------------------------
Function:       // bsp_RTC_CalTime
Description:    // 
Input:          // 
Output:         //
Return:         //
Others:         //
-------------------------------------------------------------------*/
void bsp_RTC_CalTime(void)
{
    
    bsp_RTC_GetTime(&m_u8Hours, &m_u8Minutes, &m_u8Seconds);
}

/*! @} */
//#endif /* PDL_PERIPHERAL_RTC_ACTIVE */

/*****************************************************************************/
/* EOF (not truncated)                                                       */
/*****************************************************************************/
