/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_BT_RT_H
#define __S6J3360_BT_RT_H

#include "s6j3360io_basetypes.h"

/* BT[00-31]_RT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT00_RT	stcBT_RT[0]
#define BT01_RT	stcBT_RT[1]
#define BT02_RT	stcBT_RT[2]
#define BT03_RT	stcBT_RT[3]
#define BT04_RT	stcBT_RT[4]
#define BT05_RT	stcBT_RT[5]
#define BT06_RT	stcBT_RT[6]
#define BT07_RT	stcBT_RT[7]
#define BT08_RT	stcBT_RT[8]
#define BT09_RT	stcBT_RT[9]
#define BT10_RT	stcBT_RT[10]
#define BT11_RT	stcBT_RT[11]
#define BT12_RT	stcBT_RT[12]
#define BT13_RT	stcBT_RT[13]
#define BT14_RT	stcBT_RT[14]
#define BT15_RT	stcBT_RT[15]
#define BT16_RT	stcBT_RT[16]
#define BT17_RT	stcBT_RT[17]
#define BT18_RT	stcBT_RT[18]
#define BT19_RT	stcBT_RT[19]
#define BT20_RT	stcBT_RT[20]
#define BT21_RT	stcBT_RT[21]
#define BT22_RT	stcBT_RT[22]
#define BT23_RT	stcBT_RT[23]
#define BT24_RT	stcBT_RT[24]
#define BT25_RT	stcBT_RT[25]
#define BT26_RT	stcBT_RT[26]
#define BT27_RT	stcBT_RT[27]
#define BT28_RT	stcBT_RT[28]
#define BT29_RT	stcBT_RT[29]
#define BT30_RT	stcBT_RT[30]
#define BT31_RT	stcBT_RT[31]
#else /* __IO_DEFINE */
#define BT00_RT	(*((volatile stc_btn_rt_t*)0xB4808000))
#define BT01_RT	(*((volatile stc_btn_rt_t*)0xB4808400))
#define BT02_RT	(*((volatile stc_btn_rt_t*)0xB4808800))
#define BT03_RT	(*((volatile stc_btn_rt_t*)0xB4808C00))
#define BT04_RT	(*((volatile stc_btn_rt_t*)0xB4809000))
#define BT05_RT	(*((volatile stc_btn_rt_t*)0xB4809400))
#define BT06_RT	(*((volatile stc_btn_rt_t*)0xB4809800))
#define BT07_RT	(*((volatile stc_btn_rt_t*)0xB4809C00))
#define BT08_RT	(*((volatile stc_btn_rt_t*)0xB480A000))
#define BT09_RT	(*((volatile stc_btn_rt_t*)0xB480A400))
#define BT10_RT	(*((volatile stc_btn_rt_t*)0xB480A800))
#define BT11_RT	(*((volatile stc_btn_rt_t*)0xB480AC00))
#define BT12_RT	(*((volatile stc_btn_rt_t*)0xB4888000))
#define BT13_RT	(*((volatile stc_btn_rt_t*)0xB4888400))
#define BT14_RT	(*((volatile stc_btn_rt_t*)0xB4888800))
#define BT15_RT	(*((volatile stc_btn_rt_t*)0xB4888C00))
#define BT16_RT	(*((volatile stc_btn_rt_t*)0xB4889000))
#define BT17_RT	(*((volatile stc_btn_rt_t*)0xB4889400))
#define BT18_RT	(*((volatile stc_btn_rt_t*)0xB4889800))
#define BT19_RT	(*((volatile stc_btn_rt_t*)0xB4889C00))
#define BT20_RT	(*((volatile stc_btn_rt_t*)0xB488A000))
#define BT21_RT	(*((volatile stc_btn_rt_t*)0xB488A400))
#define BT22_RT	(*((volatile stc_btn_rt_t*)0xB488A800))
#define BT23_RT	(*((volatile stc_btn_rt_t*)0xB488AC00))
#define BT24_RT	(*((volatile stc_btn_rt_t*)0xB4846000))
#define BT25_RT	(*((volatile stc_btn_rt_t*)0xB4846400))
#define BT26_RT	(*((volatile stc_btn_rt_t*)0xB4846800))
#define BT27_RT	(*((volatile stc_btn_rt_t*)0xB4846C00))
#define BT28_RT	(*((volatile stc_btn_rt_t*)0xB4847000))
#define BT29_RT	(*((volatile stc_btn_rt_t*)0xB4847400))
#define BT30_RT	(*((volatile stc_btn_rt_t*)0xB4847800))
#define BT31_RT	(*((volatile stc_btn_rt_t*)0xB4847C00))
#endif /* __IO_DEFINE */

/* PCSR */
#define BT00_RT_PCSR	(BT00_RT.unPCSR.u16Register)  /*@rg@*/
#define BT00_RT_PCSR_PCSR	BT00_RT_PCSR  /*@bfrg@*/

#define BT01_RT_PCSR	(BT01_RT.unPCSR.u16Register)  /*@rg@*/
#define BT01_RT_PCSR_PCSR	BT01_RT_PCSR  /*@bfrg@*/

#define BT02_RT_PCSR	(BT02_RT.unPCSR.u16Register)  /*@rg@*/
#define BT02_RT_PCSR_PCSR	BT02_RT_PCSR  /*@bfrg@*/

#define BT03_RT_PCSR	(BT03_RT.unPCSR.u16Register)  /*@rg@*/
#define BT03_RT_PCSR_PCSR	BT03_RT_PCSR  /*@bfrg@*/

#define BT04_RT_PCSR	(BT04_RT.unPCSR.u16Register)  /*@rg@*/
#define BT04_RT_PCSR_PCSR	BT04_RT_PCSR  /*@bfrg@*/

#define BT05_RT_PCSR	(BT05_RT.unPCSR.u16Register)  /*@rg@*/
#define BT05_RT_PCSR_PCSR	BT05_RT_PCSR  /*@bfrg@*/

#define BT06_RT_PCSR	(BT06_RT.unPCSR.u16Register)  /*@rg@*/
#define BT06_RT_PCSR_PCSR	BT06_RT_PCSR  /*@bfrg@*/

#define BT07_RT_PCSR	(BT07_RT.unPCSR.u16Register)  /*@rg@*/
#define BT07_RT_PCSR_PCSR	BT07_RT_PCSR  /*@bfrg@*/

#define BT08_RT_PCSR	(BT08_RT.unPCSR.u16Register)  /*@rg@*/
#define BT08_RT_PCSR_PCSR	BT08_RT_PCSR  /*@bfrg@*/

#define BT09_RT_PCSR	(BT09_RT.unPCSR.u16Register)  /*@rg@*/
#define BT09_RT_PCSR_PCSR	BT09_RT_PCSR  /*@bfrg@*/

#define BT10_RT_PCSR	(BT10_RT.unPCSR.u16Register)  /*@rg@*/
#define BT10_RT_PCSR_PCSR	BT10_RT_PCSR  /*@bfrg@*/

#define BT11_RT_PCSR	(BT11_RT.unPCSR.u16Register)  /*@rg@*/
#define BT11_RT_PCSR_PCSR	BT11_RT_PCSR  /*@bfrg@*/

#define BT12_RT_PCSR	(BT12_RT.unPCSR.u16Register)  /*@rg@*/
#define BT12_RT_PCSR_PCSR	BT12_RT_PCSR  /*@bfrg@*/

#define BT13_RT_PCSR	(BT13_RT.unPCSR.u16Register)  /*@rg@*/
#define BT13_RT_PCSR_PCSR	BT13_RT_PCSR  /*@bfrg@*/

#define BT14_RT_PCSR	(BT14_RT.unPCSR.u16Register)  /*@rg@*/
#define BT14_RT_PCSR_PCSR	BT14_RT_PCSR  /*@bfrg@*/

#define BT15_RT_PCSR	(BT15_RT.unPCSR.u16Register)  /*@rg@*/
#define BT15_RT_PCSR_PCSR	BT15_RT_PCSR  /*@bfrg@*/

#define BT16_RT_PCSR	(BT16_RT.unPCSR.u16Register)  /*@rg@*/
#define BT16_RT_PCSR_PCSR	BT16_RT_PCSR  /*@bfrg@*/

#define BT17_RT_PCSR	(BT17_RT.unPCSR.u16Register)  /*@rg@*/
#define BT17_RT_PCSR_PCSR	BT17_RT_PCSR  /*@bfrg@*/

#define BT18_RT_PCSR	(BT18_RT.unPCSR.u16Register)  /*@rg@*/
#define BT18_RT_PCSR_PCSR	BT18_RT_PCSR  /*@bfrg@*/

#define BT19_RT_PCSR	(BT19_RT.unPCSR.u16Register)  /*@rg@*/
#define BT19_RT_PCSR_PCSR	BT19_RT_PCSR  /*@bfrg@*/

#define BT20_RT_PCSR	(BT20_RT.unPCSR.u16Register)  /*@rg@*/
#define BT20_RT_PCSR_PCSR	BT20_RT_PCSR  /*@bfrg@*/

#define BT21_RT_PCSR	(BT21_RT.unPCSR.u16Register)  /*@rg@*/
#define BT21_RT_PCSR_PCSR	BT21_RT_PCSR  /*@bfrg@*/

#define BT22_RT_PCSR	(BT22_RT.unPCSR.u16Register)  /*@rg@*/
#define BT22_RT_PCSR_PCSR	BT22_RT_PCSR  /*@bfrg@*/

#define BT23_RT_PCSR	(BT23_RT.unPCSR.u16Register)  /*@rg@*/
#define BT23_RT_PCSR_PCSR	BT23_RT_PCSR  /*@bfrg@*/

#define BT24_RT_PCSR	(BT24_RT.unPCSR.u16Register)  /*@rg@*/
#define BT24_RT_PCSR_PCSR	BT24_RT_PCSR  /*@bfrg@*/

#define BT25_RT_PCSR	(BT25_RT.unPCSR.u16Register)  /*@rg@*/
#define BT25_RT_PCSR_PCSR	BT25_RT_PCSR  /*@bfrg@*/

#define BT26_RT_PCSR	(BT26_RT.unPCSR.u16Register)  /*@rg@*/
#define BT26_RT_PCSR_PCSR	BT26_RT_PCSR  /*@bfrg@*/

#define BT27_RT_PCSR	(BT27_RT.unPCSR.u16Register)  /*@rg@*/
#define BT27_RT_PCSR_PCSR	BT27_RT_PCSR  /*@bfrg@*/

#define BT28_RT_PCSR	(BT28_RT.unPCSR.u16Register)  /*@rg@*/
#define BT28_RT_PCSR_PCSR	BT28_RT_PCSR  /*@bfrg@*/

#define BT29_RT_PCSR	(BT29_RT.unPCSR.u16Register)  /*@rg@*/
#define BT29_RT_PCSR_PCSR	BT29_RT_PCSR  /*@bfrg@*/

#define BT30_RT_PCSR	(BT30_RT.unPCSR.u16Register)  /*@rg@*/
#define BT30_RT_PCSR_PCSR	BT30_RT_PCSR  /*@bfrg@*/

#define BT31_RT_PCSR	(BT31_RT.unPCSR.u16Register)  /*@rg@*/
#define BT31_RT_PCSR_PCSR	BT31_RT_PCSR  /*@bfrg@*/

typedef union un_btn_rt_pcsr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_rt_pcsr_t;

/* TMR */
#define BT00_RT_TMR	(BT00_RT.unTMR.u16Register)  /*@rg@*/
#define BT00_RT_TMR_TMR	BT00_RT_TMR  /*@bfrg@*/

#define BT01_RT_TMR	(BT01_RT.unTMR.u16Register)  /*@rg@*/
#define BT01_RT_TMR_TMR	BT01_RT_TMR  /*@bfrg@*/

#define BT02_RT_TMR	(BT02_RT.unTMR.u16Register)  /*@rg@*/
#define BT02_RT_TMR_TMR	BT02_RT_TMR  /*@bfrg@*/

#define BT03_RT_TMR	(BT03_RT.unTMR.u16Register)  /*@rg@*/
#define BT03_RT_TMR_TMR	BT03_RT_TMR  /*@bfrg@*/

#define BT04_RT_TMR	(BT04_RT.unTMR.u16Register)  /*@rg@*/
#define BT04_RT_TMR_TMR	BT04_RT_TMR  /*@bfrg@*/

#define BT05_RT_TMR	(BT05_RT.unTMR.u16Register)  /*@rg@*/
#define BT05_RT_TMR_TMR	BT05_RT_TMR  /*@bfrg@*/

#define BT06_RT_TMR	(BT06_RT.unTMR.u16Register)  /*@rg@*/
#define BT06_RT_TMR_TMR	BT06_RT_TMR  /*@bfrg@*/

#define BT07_RT_TMR	(BT07_RT.unTMR.u16Register)  /*@rg@*/
#define BT07_RT_TMR_TMR	BT07_RT_TMR  /*@bfrg@*/

#define BT08_RT_TMR	(BT08_RT.unTMR.u16Register)  /*@rg@*/
#define BT08_RT_TMR_TMR	BT08_RT_TMR  /*@bfrg@*/

#define BT09_RT_TMR	(BT09_RT.unTMR.u16Register)  /*@rg@*/
#define BT09_RT_TMR_TMR	BT09_RT_TMR  /*@bfrg@*/

#define BT10_RT_TMR	(BT10_RT.unTMR.u16Register)  /*@rg@*/
#define BT10_RT_TMR_TMR	BT10_RT_TMR  /*@bfrg@*/

#define BT11_RT_TMR	(BT11_RT.unTMR.u16Register)  /*@rg@*/
#define BT11_RT_TMR_TMR	BT11_RT_TMR  /*@bfrg@*/

#define BT12_RT_TMR	(BT12_RT.unTMR.u16Register)  /*@rg@*/
#define BT12_RT_TMR_TMR	BT12_RT_TMR  /*@bfrg@*/

#define BT13_RT_TMR	(BT13_RT.unTMR.u16Register)  /*@rg@*/
#define BT13_RT_TMR_TMR	BT13_RT_TMR  /*@bfrg@*/

#define BT14_RT_TMR	(BT14_RT.unTMR.u16Register)  /*@rg@*/
#define BT14_RT_TMR_TMR	BT14_RT_TMR  /*@bfrg@*/

#define BT15_RT_TMR	(BT15_RT.unTMR.u16Register)  /*@rg@*/
#define BT15_RT_TMR_TMR	BT15_RT_TMR  /*@bfrg@*/

#define BT16_RT_TMR	(BT16_RT.unTMR.u16Register)  /*@rg@*/
#define BT16_RT_TMR_TMR	BT16_RT_TMR  /*@bfrg@*/

#define BT17_RT_TMR	(BT17_RT.unTMR.u16Register)  /*@rg@*/
#define BT17_RT_TMR_TMR	BT17_RT_TMR  /*@bfrg@*/

#define BT18_RT_TMR	(BT18_RT.unTMR.u16Register)  /*@rg@*/
#define BT18_RT_TMR_TMR	BT18_RT_TMR  /*@bfrg@*/

#define BT19_RT_TMR	(BT19_RT.unTMR.u16Register)  /*@rg@*/
#define BT19_RT_TMR_TMR	BT19_RT_TMR  /*@bfrg@*/

#define BT20_RT_TMR	(BT20_RT.unTMR.u16Register)  /*@rg@*/
#define BT20_RT_TMR_TMR	BT20_RT_TMR  /*@bfrg@*/

#define BT21_RT_TMR	(BT21_RT.unTMR.u16Register)  /*@rg@*/
#define BT21_RT_TMR_TMR	BT21_RT_TMR  /*@bfrg@*/

#define BT22_RT_TMR	(BT22_RT.unTMR.u16Register)  /*@rg@*/
#define BT22_RT_TMR_TMR	BT22_RT_TMR  /*@bfrg@*/

#define BT23_RT_TMR	(BT23_RT.unTMR.u16Register)  /*@rg@*/
#define BT23_RT_TMR_TMR	BT23_RT_TMR  /*@bfrg@*/

#define BT24_RT_TMR	(BT24_RT.unTMR.u16Register)  /*@rg@*/
#define BT24_RT_TMR_TMR	BT24_RT_TMR  /*@bfrg@*/

#define BT25_RT_TMR	(BT25_RT.unTMR.u16Register)  /*@rg@*/
#define BT25_RT_TMR_TMR	BT25_RT_TMR  /*@bfrg@*/

#define BT26_RT_TMR	(BT26_RT.unTMR.u16Register)  /*@rg@*/
#define BT26_RT_TMR_TMR	BT26_RT_TMR  /*@bfrg@*/

#define BT27_RT_TMR	(BT27_RT.unTMR.u16Register)  /*@rg@*/
#define BT27_RT_TMR_TMR	BT27_RT_TMR  /*@bfrg@*/

#define BT28_RT_TMR	(BT28_RT.unTMR.u16Register)  /*@rg@*/
#define BT28_RT_TMR_TMR	BT28_RT_TMR  /*@bfrg@*/

#define BT29_RT_TMR	(BT29_RT.unTMR.u16Register)  /*@rg@*/
#define BT29_RT_TMR_TMR	BT29_RT_TMR  /*@bfrg@*/

#define BT30_RT_TMR	(BT30_RT.unTMR.u16Register)  /*@rg@*/
#define BT30_RT_TMR_TMR	BT30_RT_TMR  /*@bfrg@*/

#define BT31_RT_TMR	(BT31_RT.unTMR.u16Register)  /*@rg@*/
#define BT31_RT_TMR_TMR	BT31_RT_TMR  /*@bfrg@*/

typedef union un_btn_rt_tmr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_rt_tmr_t;

/* TMCR */
#define BT00_RT_TMCR	(BT00_RT.unTMCR.u16Register)  /*@rg@*/
#define BT00_RT_TMCR_STRG	(BT00_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT00_RT_TMCR_CTEN	(BT00_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT00_RT_TMCR_MDSE	(BT00_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT00_RT_TMCR_OSEL	(BT00_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT00_RT_TMCR_FMD	(BT00_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT00_RT_TMCR_T32	(BT00_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT00_RT_TMCR_EGS	(BT00_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT00_RT_TMCR_CKS2_0	(BT00_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT01_RT_TMCR	(BT01_RT.unTMCR.u16Register)  /*@rg@*/
#define BT01_RT_TMCR_STRG	(BT01_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT01_RT_TMCR_CTEN	(BT01_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT01_RT_TMCR_MDSE	(BT01_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT01_RT_TMCR_OSEL	(BT01_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT01_RT_TMCR_FMD	(BT01_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT01_RT_TMCR_T32	(BT01_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT01_RT_TMCR_EGS	(BT01_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT01_RT_TMCR_CKS2_0	(BT01_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT02_RT_TMCR	(BT02_RT.unTMCR.u16Register)  /*@rg@*/
#define BT02_RT_TMCR_STRG	(BT02_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT02_RT_TMCR_CTEN	(BT02_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT02_RT_TMCR_MDSE	(BT02_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT02_RT_TMCR_OSEL	(BT02_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT02_RT_TMCR_FMD	(BT02_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT02_RT_TMCR_T32	(BT02_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT02_RT_TMCR_EGS	(BT02_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT02_RT_TMCR_CKS2_0	(BT02_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT03_RT_TMCR	(BT03_RT.unTMCR.u16Register)  /*@rg@*/
#define BT03_RT_TMCR_STRG	(BT03_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT03_RT_TMCR_CTEN	(BT03_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT03_RT_TMCR_MDSE	(BT03_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT03_RT_TMCR_OSEL	(BT03_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT03_RT_TMCR_FMD	(BT03_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT03_RT_TMCR_T32	(BT03_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT03_RT_TMCR_EGS	(BT03_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT03_RT_TMCR_CKS2_0	(BT03_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT04_RT_TMCR	(BT04_RT.unTMCR.u16Register)  /*@rg@*/
#define BT04_RT_TMCR_STRG	(BT04_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT04_RT_TMCR_CTEN	(BT04_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT04_RT_TMCR_MDSE	(BT04_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT04_RT_TMCR_OSEL	(BT04_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT04_RT_TMCR_FMD	(BT04_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT04_RT_TMCR_T32	(BT04_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT04_RT_TMCR_EGS	(BT04_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT04_RT_TMCR_CKS2_0	(BT04_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT05_RT_TMCR	(BT05_RT.unTMCR.u16Register)  /*@rg@*/
#define BT05_RT_TMCR_STRG	(BT05_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT05_RT_TMCR_CTEN	(BT05_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT05_RT_TMCR_MDSE	(BT05_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT05_RT_TMCR_OSEL	(BT05_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT05_RT_TMCR_FMD	(BT05_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT05_RT_TMCR_T32	(BT05_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT05_RT_TMCR_EGS	(BT05_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT05_RT_TMCR_CKS2_0	(BT05_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT06_RT_TMCR	(BT06_RT.unTMCR.u16Register)  /*@rg@*/
#define BT06_RT_TMCR_STRG	(BT06_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT06_RT_TMCR_CTEN	(BT06_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT06_RT_TMCR_MDSE	(BT06_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT06_RT_TMCR_OSEL	(BT06_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT06_RT_TMCR_FMD	(BT06_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT06_RT_TMCR_T32	(BT06_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT06_RT_TMCR_EGS	(BT06_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT06_RT_TMCR_CKS2_0	(BT06_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT07_RT_TMCR	(BT07_RT.unTMCR.u16Register)  /*@rg@*/
#define BT07_RT_TMCR_STRG	(BT07_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT07_RT_TMCR_CTEN	(BT07_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT07_RT_TMCR_MDSE	(BT07_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT07_RT_TMCR_OSEL	(BT07_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT07_RT_TMCR_FMD	(BT07_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT07_RT_TMCR_T32	(BT07_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT07_RT_TMCR_EGS	(BT07_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT07_RT_TMCR_CKS2_0	(BT07_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT08_RT_TMCR	(BT08_RT.unTMCR.u16Register)  /*@rg@*/
#define BT08_RT_TMCR_STRG	(BT08_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT08_RT_TMCR_CTEN	(BT08_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT08_RT_TMCR_MDSE	(BT08_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT08_RT_TMCR_OSEL	(BT08_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT08_RT_TMCR_FMD	(BT08_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT08_RT_TMCR_T32	(BT08_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT08_RT_TMCR_EGS	(BT08_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT08_RT_TMCR_CKS2_0	(BT08_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT09_RT_TMCR	(BT09_RT.unTMCR.u16Register)  /*@rg@*/
#define BT09_RT_TMCR_STRG	(BT09_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT09_RT_TMCR_CTEN	(BT09_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT09_RT_TMCR_MDSE	(BT09_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT09_RT_TMCR_OSEL	(BT09_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT09_RT_TMCR_FMD	(BT09_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT09_RT_TMCR_T32	(BT09_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT09_RT_TMCR_EGS	(BT09_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT09_RT_TMCR_CKS2_0	(BT09_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT10_RT_TMCR	(BT10_RT.unTMCR.u16Register)  /*@rg@*/
#define BT10_RT_TMCR_STRG	(BT10_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT10_RT_TMCR_CTEN	(BT10_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT10_RT_TMCR_MDSE	(BT10_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT10_RT_TMCR_OSEL	(BT10_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT10_RT_TMCR_FMD	(BT10_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT10_RT_TMCR_T32	(BT10_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT10_RT_TMCR_EGS	(BT10_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT10_RT_TMCR_CKS2_0	(BT10_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT11_RT_TMCR	(BT11_RT.unTMCR.u16Register)  /*@rg@*/
#define BT11_RT_TMCR_STRG	(BT11_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT11_RT_TMCR_CTEN	(BT11_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT11_RT_TMCR_MDSE	(BT11_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT11_RT_TMCR_OSEL	(BT11_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT11_RT_TMCR_FMD	(BT11_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT11_RT_TMCR_T32	(BT11_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT11_RT_TMCR_EGS	(BT11_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT11_RT_TMCR_CKS2_0	(BT11_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT12_RT_TMCR	(BT12_RT.unTMCR.u16Register)  /*@rg@*/
#define BT12_RT_TMCR_STRG	(BT12_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT12_RT_TMCR_CTEN	(BT12_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT12_RT_TMCR_MDSE	(BT12_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT12_RT_TMCR_OSEL	(BT12_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT12_RT_TMCR_FMD	(BT12_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT12_RT_TMCR_T32	(BT12_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT12_RT_TMCR_EGS	(BT12_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT12_RT_TMCR_CKS2_0	(BT12_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT13_RT_TMCR	(BT13_RT.unTMCR.u16Register)  /*@rg@*/
#define BT13_RT_TMCR_STRG	(BT13_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT13_RT_TMCR_CTEN	(BT13_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT13_RT_TMCR_MDSE	(BT13_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT13_RT_TMCR_OSEL	(BT13_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT13_RT_TMCR_FMD	(BT13_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT13_RT_TMCR_T32	(BT13_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT13_RT_TMCR_EGS	(BT13_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT13_RT_TMCR_CKS2_0	(BT13_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT14_RT_TMCR	(BT14_RT.unTMCR.u16Register)  /*@rg@*/
#define BT14_RT_TMCR_STRG	(BT14_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT14_RT_TMCR_CTEN	(BT14_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT14_RT_TMCR_MDSE	(BT14_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT14_RT_TMCR_OSEL	(BT14_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT14_RT_TMCR_FMD	(BT14_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT14_RT_TMCR_T32	(BT14_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT14_RT_TMCR_EGS	(BT14_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT14_RT_TMCR_CKS2_0	(BT14_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT15_RT_TMCR	(BT15_RT.unTMCR.u16Register)  /*@rg@*/
#define BT15_RT_TMCR_STRG	(BT15_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT15_RT_TMCR_CTEN	(BT15_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT15_RT_TMCR_MDSE	(BT15_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT15_RT_TMCR_OSEL	(BT15_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT15_RT_TMCR_FMD	(BT15_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT15_RT_TMCR_T32	(BT15_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT15_RT_TMCR_EGS	(BT15_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT15_RT_TMCR_CKS2_0	(BT15_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT16_RT_TMCR	(BT16_RT.unTMCR.u16Register)  /*@rg@*/
#define BT16_RT_TMCR_STRG	(BT16_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT16_RT_TMCR_CTEN	(BT16_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT16_RT_TMCR_MDSE	(BT16_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT16_RT_TMCR_OSEL	(BT16_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT16_RT_TMCR_FMD	(BT16_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT16_RT_TMCR_T32	(BT16_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT16_RT_TMCR_EGS	(BT16_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT16_RT_TMCR_CKS2_0	(BT16_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT17_RT_TMCR	(BT17_RT.unTMCR.u16Register)  /*@rg@*/
#define BT17_RT_TMCR_STRG	(BT17_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT17_RT_TMCR_CTEN	(BT17_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT17_RT_TMCR_MDSE	(BT17_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT17_RT_TMCR_OSEL	(BT17_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT17_RT_TMCR_FMD	(BT17_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT17_RT_TMCR_T32	(BT17_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT17_RT_TMCR_EGS	(BT17_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT17_RT_TMCR_CKS2_0	(BT17_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT18_RT_TMCR	(BT18_RT.unTMCR.u16Register)  /*@rg@*/
#define BT18_RT_TMCR_STRG	(BT18_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT18_RT_TMCR_CTEN	(BT18_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT18_RT_TMCR_MDSE	(BT18_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT18_RT_TMCR_OSEL	(BT18_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT18_RT_TMCR_FMD	(BT18_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT18_RT_TMCR_T32	(BT18_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT18_RT_TMCR_EGS	(BT18_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT18_RT_TMCR_CKS2_0	(BT18_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT19_RT_TMCR	(BT19_RT.unTMCR.u16Register)  /*@rg@*/
#define BT19_RT_TMCR_STRG	(BT19_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT19_RT_TMCR_CTEN	(BT19_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT19_RT_TMCR_MDSE	(BT19_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT19_RT_TMCR_OSEL	(BT19_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT19_RT_TMCR_FMD	(BT19_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT19_RT_TMCR_T32	(BT19_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT19_RT_TMCR_EGS	(BT19_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT19_RT_TMCR_CKS2_0	(BT19_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT20_RT_TMCR	(BT20_RT.unTMCR.u16Register)  /*@rg@*/
#define BT20_RT_TMCR_STRG	(BT20_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT20_RT_TMCR_CTEN	(BT20_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT20_RT_TMCR_MDSE	(BT20_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT20_RT_TMCR_OSEL	(BT20_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT20_RT_TMCR_FMD	(BT20_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT20_RT_TMCR_T32	(BT20_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT20_RT_TMCR_EGS	(BT20_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT20_RT_TMCR_CKS2_0	(BT20_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT21_RT_TMCR	(BT21_RT.unTMCR.u16Register)  /*@rg@*/
#define BT21_RT_TMCR_STRG	(BT21_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT21_RT_TMCR_CTEN	(BT21_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT21_RT_TMCR_MDSE	(BT21_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT21_RT_TMCR_OSEL	(BT21_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT21_RT_TMCR_FMD	(BT21_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT21_RT_TMCR_T32	(BT21_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT21_RT_TMCR_EGS	(BT21_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT21_RT_TMCR_CKS2_0	(BT21_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT22_RT_TMCR	(BT22_RT.unTMCR.u16Register)  /*@rg@*/
#define BT22_RT_TMCR_STRG	(BT22_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT22_RT_TMCR_CTEN	(BT22_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT22_RT_TMCR_MDSE	(BT22_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT22_RT_TMCR_OSEL	(BT22_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT22_RT_TMCR_FMD	(BT22_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT22_RT_TMCR_T32	(BT22_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT22_RT_TMCR_EGS	(BT22_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT22_RT_TMCR_CKS2_0	(BT22_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT23_RT_TMCR	(BT23_RT.unTMCR.u16Register)  /*@rg@*/
#define BT23_RT_TMCR_STRG	(BT23_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT23_RT_TMCR_CTEN	(BT23_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT23_RT_TMCR_MDSE	(BT23_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT23_RT_TMCR_OSEL	(BT23_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT23_RT_TMCR_FMD	(BT23_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT23_RT_TMCR_T32	(BT23_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT23_RT_TMCR_EGS	(BT23_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT23_RT_TMCR_CKS2_0	(BT23_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT24_RT_TMCR	(BT24_RT.unTMCR.u16Register)  /*@rg@*/
#define BT24_RT_TMCR_STRG	(BT24_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT24_RT_TMCR_CTEN	(BT24_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT24_RT_TMCR_MDSE	(BT24_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT24_RT_TMCR_OSEL	(BT24_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT24_RT_TMCR_FMD	(BT24_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT24_RT_TMCR_T32	(BT24_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT24_RT_TMCR_EGS	(BT24_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT24_RT_TMCR_CKS2_0	(BT24_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT25_RT_TMCR	(BT25_RT.unTMCR.u16Register)  /*@rg@*/
#define BT25_RT_TMCR_STRG	(BT25_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT25_RT_TMCR_CTEN	(BT25_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT25_RT_TMCR_MDSE	(BT25_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT25_RT_TMCR_OSEL	(BT25_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT25_RT_TMCR_FMD	(BT25_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT25_RT_TMCR_T32	(BT25_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT25_RT_TMCR_EGS	(BT25_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT25_RT_TMCR_CKS2_0	(BT25_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT26_RT_TMCR	(BT26_RT.unTMCR.u16Register)  /*@rg@*/
#define BT26_RT_TMCR_STRG	(BT26_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT26_RT_TMCR_CTEN	(BT26_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT26_RT_TMCR_MDSE	(BT26_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT26_RT_TMCR_OSEL	(BT26_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT26_RT_TMCR_FMD	(BT26_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT26_RT_TMCR_T32	(BT26_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT26_RT_TMCR_EGS	(BT26_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT26_RT_TMCR_CKS2_0	(BT26_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT27_RT_TMCR	(BT27_RT.unTMCR.u16Register)  /*@rg@*/
#define BT27_RT_TMCR_STRG	(BT27_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT27_RT_TMCR_CTEN	(BT27_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT27_RT_TMCR_MDSE	(BT27_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT27_RT_TMCR_OSEL	(BT27_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT27_RT_TMCR_FMD	(BT27_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT27_RT_TMCR_T32	(BT27_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT27_RT_TMCR_EGS	(BT27_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT27_RT_TMCR_CKS2_0	(BT27_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT28_RT_TMCR	(BT28_RT.unTMCR.u16Register)  /*@rg@*/
#define BT28_RT_TMCR_STRG	(BT28_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT28_RT_TMCR_CTEN	(BT28_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT28_RT_TMCR_MDSE	(BT28_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT28_RT_TMCR_OSEL	(BT28_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT28_RT_TMCR_FMD	(BT28_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT28_RT_TMCR_T32	(BT28_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT28_RT_TMCR_EGS	(BT28_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT28_RT_TMCR_CKS2_0	(BT28_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT29_RT_TMCR	(BT29_RT.unTMCR.u16Register)  /*@rg@*/
#define BT29_RT_TMCR_STRG	(BT29_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT29_RT_TMCR_CTEN	(BT29_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT29_RT_TMCR_MDSE	(BT29_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT29_RT_TMCR_OSEL	(BT29_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT29_RT_TMCR_FMD	(BT29_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT29_RT_TMCR_T32	(BT29_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT29_RT_TMCR_EGS	(BT29_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT29_RT_TMCR_CKS2_0	(BT29_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT30_RT_TMCR	(BT30_RT.unTMCR.u16Register)  /*@rg@*/
#define BT30_RT_TMCR_STRG	(BT30_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT30_RT_TMCR_CTEN	(BT30_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT30_RT_TMCR_MDSE	(BT30_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT30_RT_TMCR_OSEL	(BT30_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT30_RT_TMCR_FMD	(BT30_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT30_RT_TMCR_T32	(BT30_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT30_RT_TMCR_EGS	(BT30_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT30_RT_TMCR_CKS2_0	(BT30_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT31_RT_TMCR	(BT31_RT.unTMCR.u16Register)  /*@rg@*/
#define BT31_RT_TMCR_STRG	(BT31_RT.unTMCR.stcField.u1STRG)  /*@bf@*/
#define BT31_RT_TMCR_CTEN	(BT31_RT.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT31_RT_TMCR_MDSE	(BT31_RT.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT31_RT_TMCR_OSEL	(BT31_RT.unTMCR.stcField.u1OSEL)  /*@bf@*/
#define BT31_RT_TMCR_FMD	(BT31_RT.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT31_RT_TMCR_T32	(BT31_RT.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT31_RT_TMCR_EGS	(BT31_RT.unTMCR.stcField.u2EGS)  /*@bf@*/
#define BT31_RT_TMCR_CKS2_0	(BT31_RT.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

typedef struct stc_btn_rt_tmcr_field{
    uint_io16_t		u1STRG:1;
    uint_io16_t		u1CTEN:1;
    uint_io16_t		u1MDSE:1;
    uint_io16_t		u1OSEL:1;
    uint_io16_t		u3FMD:3;
    uint_io16_t		u1T32:1;
    uint_io16_t		u2EGS:2;
    uint_io16_t		:2;
    uint_io16_t		u3CKS2_0:3;
    uint_io16_t		:1;
}stc_btn_rt_tmcr_field_t;

typedef union un_btn_rt_tmcr{
    uint_io16_t		u16Register;
    stc_btn_rt_tmcr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_rt_tmcr_t;

/* STC */
#define BT00_RT_STC	(BT00_RT.unSTC.u8Register)  /*@rg@*/
#define BT00_RT_STC_UDIR	(BT00_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT00_RT_STC_TGIR	(BT00_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT00_RT_STC_UDIE	(BT00_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT00_RT_STC_TGIE	(BT00_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT01_RT_STC	(BT01_RT.unSTC.u8Register)  /*@rg@*/
#define BT01_RT_STC_UDIR	(BT01_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT01_RT_STC_TGIR	(BT01_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT01_RT_STC_UDIE	(BT01_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT01_RT_STC_TGIE	(BT01_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT02_RT_STC	(BT02_RT.unSTC.u8Register)  /*@rg@*/
#define BT02_RT_STC_UDIR	(BT02_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT02_RT_STC_TGIR	(BT02_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT02_RT_STC_UDIE	(BT02_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT02_RT_STC_TGIE	(BT02_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT03_RT_STC	(BT03_RT.unSTC.u8Register)  /*@rg@*/
#define BT03_RT_STC_UDIR	(BT03_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT03_RT_STC_TGIR	(BT03_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT03_RT_STC_UDIE	(BT03_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT03_RT_STC_TGIE	(BT03_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT04_RT_STC	(BT04_RT.unSTC.u8Register)  /*@rg@*/
#define BT04_RT_STC_UDIR	(BT04_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT04_RT_STC_TGIR	(BT04_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT04_RT_STC_UDIE	(BT04_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT04_RT_STC_TGIE	(BT04_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT05_RT_STC	(BT05_RT.unSTC.u8Register)  /*@rg@*/
#define BT05_RT_STC_UDIR	(BT05_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT05_RT_STC_TGIR	(BT05_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT05_RT_STC_UDIE	(BT05_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT05_RT_STC_TGIE	(BT05_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT06_RT_STC	(BT06_RT.unSTC.u8Register)  /*@rg@*/
#define BT06_RT_STC_UDIR	(BT06_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT06_RT_STC_TGIR	(BT06_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT06_RT_STC_UDIE	(BT06_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT06_RT_STC_TGIE	(BT06_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT07_RT_STC	(BT07_RT.unSTC.u8Register)  /*@rg@*/
#define BT07_RT_STC_UDIR	(BT07_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT07_RT_STC_TGIR	(BT07_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT07_RT_STC_UDIE	(BT07_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT07_RT_STC_TGIE	(BT07_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT08_RT_STC	(BT08_RT.unSTC.u8Register)  /*@rg@*/
#define BT08_RT_STC_UDIR	(BT08_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT08_RT_STC_TGIR	(BT08_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT08_RT_STC_UDIE	(BT08_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT08_RT_STC_TGIE	(BT08_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT09_RT_STC	(BT09_RT.unSTC.u8Register)  /*@rg@*/
#define BT09_RT_STC_UDIR	(BT09_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT09_RT_STC_TGIR	(BT09_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT09_RT_STC_UDIE	(BT09_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT09_RT_STC_TGIE	(BT09_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT10_RT_STC	(BT10_RT.unSTC.u8Register)  /*@rg@*/
#define BT10_RT_STC_UDIR	(BT10_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT10_RT_STC_TGIR	(BT10_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT10_RT_STC_UDIE	(BT10_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT10_RT_STC_TGIE	(BT10_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT11_RT_STC	(BT11_RT.unSTC.u8Register)  /*@rg@*/
#define BT11_RT_STC_UDIR	(BT11_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT11_RT_STC_TGIR	(BT11_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT11_RT_STC_UDIE	(BT11_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT11_RT_STC_TGIE	(BT11_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT12_RT_STC	(BT12_RT.unSTC.u8Register)  /*@rg@*/
#define BT12_RT_STC_UDIR	(BT12_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT12_RT_STC_TGIR	(BT12_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT12_RT_STC_UDIE	(BT12_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT12_RT_STC_TGIE	(BT12_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT13_RT_STC	(BT13_RT.unSTC.u8Register)  /*@rg@*/
#define BT13_RT_STC_UDIR	(BT13_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT13_RT_STC_TGIR	(BT13_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT13_RT_STC_UDIE	(BT13_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT13_RT_STC_TGIE	(BT13_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT14_RT_STC	(BT14_RT.unSTC.u8Register)  /*@rg@*/
#define BT14_RT_STC_UDIR	(BT14_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT14_RT_STC_TGIR	(BT14_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT14_RT_STC_UDIE	(BT14_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT14_RT_STC_TGIE	(BT14_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT15_RT_STC	(BT15_RT.unSTC.u8Register)  /*@rg@*/
#define BT15_RT_STC_UDIR	(BT15_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT15_RT_STC_TGIR	(BT15_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT15_RT_STC_UDIE	(BT15_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT15_RT_STC_TGIE	(BT15_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT16_RT_STC	(BT16_RT.unSTC.u8Register)  /*@rg@*/
#define BT16_RT_STC_UDIR	(BT16_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT16_RT_STC_TGIR	(BT16_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT16_RT_STC_UDIE	(BT16_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT16_RT_STC_TGIE	(BT16_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT17_RT_STC	(BT17_RT.unSTC.u8Register)  /*@rg@*/
#define BT17_RT_STC_UDIR	(BT17_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT17_RT_STC_TGIR	(BT17_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT17_RT_STC_UDIE	(BT17_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT17_RT_STC_TGIE	(BT17_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT18_RT_STC	(BT18_RT.unSTC.u8Register)  /*@rg@*/
#define BT18_RT_STC_UDIR	(BT18_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT18_RT_STC_TGIR	(BT18_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT18_RT_STC_UDIE	(BT18_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT18_RT_STC_TGIE	(BT18_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT19_RT_STC	(BT19_RT.unSTC.u8Register)  /*@rg@*/
#define BT19_RT_STC_UDIR	(BT19_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT19_RT_STC_TGIR	(BT19_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT19_RT_STC_UDIE	(BT19_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT19_RT_STC_TGIE	(BT19_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT20_RT_STC	(BT20_RT.unSTC.u8Register)  /*@rg@*/
#define BT20_RT_STC_UDIR	(BT20_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT20_RT_STC_TGIR	(BT20_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT20_RT_STC_UDIE	(BT20_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT20_RT_STC_TGIE	(BT20_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT21_RT_STC	(BT21_RT.unSTC.u8Register)  /*@rg@*/
#define BT21_RT_STC_UDIR	(BT21_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT21_RT_STC_TGIR	(BT21_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT21_RT_STC_UDIE	(BT21_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT21_RT_STC_TGIE	(BT21_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT22_RT_STC	(BT22_RT.unSTC.u8Register)  /*@rg@*/
#define BT22_RT_STC_UDIR	(BT22_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT22_RT_STC_TGIR	(BT22_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT22_RT_STC_UDIE	(BT22_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT22_RT_STC_TGIE	(BT22_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT23_RT_STC	(BT23_RT.unSTC.u8Register)  /*@rg@*/
#define BT23_RT_STC_UDIR	(BT23_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT23_RT_STC_TGIR	(BT23_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT23_RT_STC_UDIE	(BT23_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT23_RT_STC_TGIE	(BT23_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT24_RT_STC	(BT24_RT.unSTC.u8Register)  /*@rg@*/
#define BT24_RT_STC_UDIR	(BT24_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT24_RT_STC_TGIR	(BT24_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT24_RT_STC_UDIE	(BT24_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT24_RT_STC_TGIE	(BT24_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT25_RT_STC	(BT25_RT.unSTC.u8Register)  /*@rg@*/
#define BT25_RT_STC_UDIR	(BT25_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT25_RT_STC_TGIR	(BT25_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT25_RT_STC_UDIE	(BT25_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT25_RT_STC_TGIE	(BT25_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT26_RT_STC	(BT26_RT.unSTC.u8Register)  /*@rg@*/
#define BT26_RT_STC_UDIR	(BT26_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT26_RT_STC_TGIR	(BT26_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT26_RT_STC_UDIE	(BT26_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT26_RT_STC_TGIE	(BT26_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT27_RT_STC	(BT27_RT.unSTC.u8Register)  /*@rg@*/
#define BT27_RT_STC_UDIR	(BT27_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT27_RT_STC_TGIR	(BT27_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT27_RT_STC_UDIE	(BT27_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT27_RT_STC_TGIE	(BT27_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT28_RT_STC	(BT28_RT.unSTC.u8Register)  /*@rg@*/
#define BT28_RT_STC_UDIR	(BT28_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT28_RT_STC_TGIR	(BT28_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT28_RT_STC_UDIE	(BT28_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT28_RT_STC_TGIE	(BT28_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT29_RT_STC	(BT29_RT.unSTC.u8Register)  /*@rg@*/
#define BT29_RT_STC_UDIR	(BT29_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT29_RT_STC_TGIR	(BT29_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT29_RT_STC_UDIE	(BT29_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT29_RT_STC_TGIE	(BT29_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT30_RT_STC	(BT30_RT.unSTC.u8Register)  /*@rg@*/
#define BT30_RT_STC_UDIR	(BT30_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT30_RT_STC_TGIR	(BT30_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT30_RT_STC_UDIE	(BT30_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT30_RT_STC_TGIE	(BT30_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

#define BT31_RT_STC	(BT31_RT.unSTC.u8Register)  /*@rg@*/
#define BT31_RT_STC_UDIR	(BT31_RT.unSTC.stcField.u1UDIR)  /*@bf@*/
#define BT31_RT_STC_TGIR	(BT31_RT.unSTC.stcField.u1TGIR)  /*@bf@*/
#define BT31_RT_STC_UDIE	(BT31_RT.unSTC.stcField.u1UDIE)  /*@bf@*/
#define BT31_RT_STC_TGIE	(BT31_RT.unSTC.stcField.u1TGIE)  /*@bf@*/

typedef struct stc_btn_rt_stc_field{
    uint_io8_t		u1UDIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1TGIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1UDIE:1;
    uint_io8_t		:1;
    uint_io8_t		u1TGIE:1;
    uint_io8_t		:1;
}stc_btn_rt_stc_field_t;

typedef union un_btn_rt_stc{
    uint_io8_t		u8Register;
    stc_btn_rt_stc_field_t		stcField;
}un_btn_rt_stc_t;

/* TMCR2 */
#define BT00_RT_TMCR2	(BT00_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT00_RT_TMCR2_CKS3	(BT00_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT00_RT_TMCR2_ETCEN	(BT00_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT00_RT_TMCR2_GATE	(BT00_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT01_RT_TMCR2	(BT01_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT01_RT_TMCR2_CKS3	(BT01_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT01_RT_TMCR2_ETCEN	(BT01_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT01_RT_TMCR2_GATE	(BT01_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT02_RT_TMCR2	(BT02_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT02_RT_TMCR2_CKS3	(BT02_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT02_RT_TMCR2_ETCEN	(BT02_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT02_RT_TMCR2_GATE	(BT02_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT03_RT_TMCR2	(BT03_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT03_RT_TMCR2_CKS3	(BT03_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT03_RT_TMCR2_ETCEN	(BT03_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT03_RT_TMCR2_GATE	(BT03_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT04_RT_TMCR2	(BT04_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT04_RT_TMCR2_CKS3	(BT04_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT04_RT_TMCR2_ETCEN	(BT04_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT04_RT_TMCR2_GATE	(BT04_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT05_RT_TMCR2	(BT05_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT05_RT_TMCR2_CKS3	(BT05_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT05_RT_TMCR2_ETCEN	(BT05_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT05_RT_TMCR2_GATE	(BT05_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT06_RT_TMCR2	(BT06_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT06_RT_TMCR2_CKS3	(BT06_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT06_RT_TMCR2_ETCEN	(BT06_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT06_RT_TMCR2_GATE	(BT06_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT07_RT_TMCR2	(BT07_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT07_RT_TMCR2_CKS3	(BT07_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT07_RT_TMCR2_ETCEN	(BT07_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT07_RT_TMCR2_GATE	(BT07_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT08_RT_TMCR2	(BT08_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT08_RT_TMCR2_CKS3	(BT08_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT08_RT_TMCR2_ETCEN	(BT08_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT08_RT_TMCR2_GATE	(BT08_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT09_RT_TMCR2	(BT09_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT09_RT_TMCR2_CKS3	(BT09_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT09_RT_TMCR2_ETCEN	(BT09_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT09_RT_TMCR2_GATE	(BT09_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT10_RT_TMCR2	(BT10_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT10_RT_TMCR2_CKS3	(BT10_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT10_RT_TMCR2_ETCEN	(BT10_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT10_RT_TMCR2_GATE	(BT10_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT11_RT_TMCR2	(BT11_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT11_RT_TMCR2_CKS3	(BT11_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT11_RT_TMCR2_ETCEN	(BT11_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT11_RT_TMCR2_GATE	(BT11_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT12_RT_TMCR2	(BT12_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT12_RT_TMCR2_CKS3	(BT12_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT12_RT_TMCR2_ETCEN	(BT12_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT12_RT_TMCR2_GATE	(BT12_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT13_RT_TMCR2	(BT13_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT13_RT_TMCR2_CKS3	(BT13_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT13_RT_TMCR2_ETCEN	(BT13_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT13_RT_TMCR2_GATE	(BT13_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT14_RT_TMCR2	(BT14_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT14_RT_TMCR2_CKS3	(BT14_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT14_RT_TMCR2_ETCEN	(BT14_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT14_RT_TMCR2_GATE	(BT14_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT15_RT_TMCR2	(BT15_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT15_RT_TMCR2_CKS3	(BT15_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT15_RT_TMCR2_ETCEN	(BT15_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT15_RT_TMCR2_GATE	(BT15_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT16_RT_TMCR2	(BT16_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT16_RT_TMCR2_CKS3	(BT16_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT16_RT_TMCR2_ETCEN	(BT16_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT16_RT_TMCR2_GATE	(BT16_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT17_RT_TMCR2	(BT17_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT17_RT_TMCR2_CKS3	(BT17_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT17_RT_TMCR2_ETCEN	(BT17_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT17_RT_TMCR2_GATE	(BT17_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT18_RT_TMCR2	(BT18_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT18_RT_TMCR2_CKS3	(BT18_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT18_RT_TMCR2_ETCEN	(BT18_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT18_RT_TMCR2_GATE	(BT18_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT19_RT_TMCR2	(BT19_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT19_RT_TMCR2_CKS3	(BT19_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT19_RT_TMCR2_ETCEN	(BT19_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT19_RT_TMCR2_GATE	(BT19_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT20_RT_TMCR2	(BT20_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT20_RT_TMCR2_CKS3	(BT20_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT20_RT_TMCR2_ETCEN	(BT20_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT20_RT_TMCR2_GATE	(BT20_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT21_RT_TMCR2	(BT21_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT21_RT_TMCR2_CKS3	(BT21_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT21_RT_TMCR2_ETCEN	(BT21_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT21_RT_TMCR2_GATE	(BT21_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT22_RT_TMCR2	(BT22_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT22_RT_TMCR2_CKS3	(BT22_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT22_RT_TMCR2_ETCEN	(BT22_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT22_RT_TMCR2_GATE	(BT22_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT23_RT_TMCR2	(BT23_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT23_RT_TMCR2_CKS3	(BT23_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT23_RT_TMCR2_ETCEN	(BT23_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT23_RT_TMCR2_GATE	(BT23_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT24_RT_TMCR2	(BT24_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT24_RT_TMCR2_CKS3	(BT24_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT24_RT_TMCR2_ETCEN	(BT24_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT24_RT_TMCR2_GATE	(BT24_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT25_RT_TMCR2	(BT25_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT25_RT_TMCR2_CKS3	(BT25_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT25_RT_TMCR2_ETCEN	(BT25_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT25_RT_TMCR2_GATE	(BT25_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT26_RT_TMCR2	(BT26_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT26_RT_TMCR2_CKS3	(BT26_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT26_RT_TMCR2_ETCEN	(BT26_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT26_RT_TMCR2_GATE	(BT26_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT27_RT_TMCR2	(BT27_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT27_RT_TMCR2_CKS3	(BT27_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT27_RT_TMCR2_ETCEN	(BT27_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT27_RT_TMCR2_GATE	(BT27_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT28_RT_TMCR2	(BT28_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT28_RT_TMCR2_CKS3	(BT28_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT28_RT_TMCR2_ETCEN	(BT28_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT28_RT_TMCR2_GATE	(BT28_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT29_RT_TMCR2	(BT29_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT29_RT_TMCR2_CKS3	(BT29_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT29_RT_TMCR2_ETCEN	(BT29_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT29_RT_TMCR2_GATE	(BT29_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT30_RT_TMCR2	(BT30_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT30_RT_TMCR2_CKS3	(BT30_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT30_RT_TMCR2_ETCEN	(BT30_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT30_RT_TMCR2_GATE	(BT30_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

#define BT31_RT_TMCR2	(BT31_RT.unTMCR2.u8Register)  /*@rg@*/
#define BT31_RT_TMCR2_CKS3	(BT31_RT.unTMCR2.stcField.u1CKS3)  /*@bf@*/
#define BT31_RT_TMCR2_ETCEN	(BT31_RT.unTMCR2.stcField.u1ETCEN)  /*@bf@*/
#define BT31_RT_TMCR2_GATE	(BT31_RT.unTMCR2.stcField.u1GATE)  /*@bf@*/

typedef struct stc_btn_rt_tmcr2_field{
    uint_io8_t		u1CKS3:1;
    uint_io8_t		u1ETCEN:1;
    uint_io8_t		:5;
    uint_io8_t		u1GATE:1;
}stc_btn_rt_tmcr2_field_t;

typedef union un_btn_rt_tmcr2{
    uint_io8_t		u8Register;
    stc_btn_rt_tmcr2_field_t		stcField;
}un_btn_rt_tmcr2_t;

/* STCC */
#define BT00_RT_STCC	(BT00_RT.unSTCC.u8Register)  /*@rg@*/
#define BT00_RT_STCC_UDIRC	(BT00_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT00_RT_STCC_TGIRC	(BT00_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT00_RT_STCC_UDIEC	(BT00_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT00_RT_STCC_TGIEC	(BT00_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT01_RT_STCC	(BT01_RT.unSTCC.u8Register)  /*@rg@*/
#define BT01_RT_STCC_UDIRC	(BT01_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT01_RT_STCC_TGIRC	(BT01_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT01_RT_STCC_UDIEC	(BT01_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT01_RT_STCC_TGIEC	(BT01_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT02_RT_STCC	(BT02_RT.unSTCC.u8Register)  /*@rg@*/
#define BT02_RT_STCC_UDIRC	(BT02_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT02_RT_STCC_TGIRC	(BT02_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT02_RT_STCC_UDIEC	(BT02_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT02_RT_STCC_TGIEC	(BT02_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT03_RT_STCC	(BT03_RT.unSTCC.u8Register)  /*@rg@*/
#define BT03_RT_STCC_UDIRC	(BT03_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT03_RT_STCC_TGIRC	(BT03_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT03_RT_STCC_UDIEC	(BT03_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT03_RT_STCC_TGIEC	(BT03_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT04_RT_STCC	(BT04_RT.unSTCC.u8Register)  /*@rg@*/
#define BT04_RT_STCC_UDIRC	(BT04_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT04_RT_STCC_TGIRC	(BT04_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT04_RT_STCC_UDIEC	(BT04_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT04_RT_STCC_TGIEC	(BT04_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT05_RT_STCC	(BT05_RT.unSTCC.u8Register)  /*@rg@*/
#define BT05_RT_STCC_UDIRC	(BT05_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT05_RT_STCC_TGIRC	(BT05_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT05_RT_STCC_UDIEC	(BT05_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT05_RT_STCC_TGIEC	(BT05_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT06_RT_STCC	(BT06_RT.unSTCC.u8Register)  /*@rg@*/
#define BT06_RT_STCC_UDIRC	(BT06_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT06_RT_STCC_TGIRC	(BT06_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT06_RT_STCC_UDIEC	(BT06_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT06_RT_STCC_TGIEC	(BT06_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT07_RT_STCC	(BT07_RT.unSTCC.u8Register)  /*@rg@*/
#define BT07_RT_STCC_UDIRC	(BT07_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT07_RT_STCC_TGIRC	(BT07_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT07_RT_STCC_UDIEC	(BT07_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT07_RT_STCC_TGIEC	(BT07_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT08_RT_STCC	(BT08_RT.unSTCC.u8Register)  /*@rg@*/
#define BT08_RT_STCC_UDIRC	(BT08_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT08_RT_STCC_TGIRC	(BT08_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT08_RT_STCC_UDIEC	(BT08_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT08_RT_STCC_TGIEC	(BT08_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT09_RT_STCC	(BT09_RT.unSTCC.u8Register)  /*@rg@*/
#define BT09_RT_STCC_UDIRC	(BT09_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT09_RT_STCC_TGIRC	(BT09_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT09_RT_STCC_UDIEC	(BT09_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT09_RT_STCC_TGIEC	(BT09_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT10_RT_STCC	(BT10_RT.unSTCC.u8Register)  /*@rg@*/
#define BT10_RT_STCC_UDIRC	(BT10_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT10_RT_STCC_TGIRC	(BT10_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT10_RT_STCC_UDIEC	(BT10_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT10_RT_STCC_TGIEC	(BT10_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT11_RT_STCC	(BT11_RT.unSTCC.u8Register)  /*@rg@*/
#define BT11_RT_STCC_UDIRC	(BT11_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT11_RT_STCC_TGIRC	(BT11_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT11_RT_STCC_UDIEC	(BT11_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT11_RT_STCC_TGIEC	(BT11_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT12_RT_STCC	(BT12_RT.unSTCC.u8Register)  /*@rg@*/
#define BT12_RT_STCC_UDIRC	(BT12_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT12_RT_STCC_TGIRC	(BT12_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT12_RT_STCC_UDIEC	(BT12_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT12_RT_STCC_TGIEC	(BT12_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT13_RT_STCC	(BT13_RT.unSTCC.u8Register)  /*@rg@*/
#define BT13_RT_STCC_UDIRC	(BT13_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT13_RT_STCC_TGIRC	(BT13_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT13_RT_STCC_UDIEC	(BT13_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT13_RT_STCC_TGIEC	(BT13_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT14_RT_STCC	(BT14_RT.unSTCC.u8Register)  /*@rg@*/
#define BT14_RT_STCC_UDIRC	(BT14_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT14_RT_STCC_TGIRC	(BT14_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT14_RT_STCC_UDIEC	(BT14_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT14_RT_STCC_TGIEC	(BT14_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT15_RT_STCC	(BT15_RT.unSTCC.u8Register)  /*@rg@*/
#define BT15_RT_STCC_UDIRC	(BT15_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT15_RT_STCC_TGIRC	(BT15_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT15_RT_STCC_UDIEC	(BT15_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT15_RT_STCC_TGIEC	(BT15_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT16_RT_STCC	(BT16_RT.unSTCC.u8Register)  /*@rg@*/
#define BT16_RT_STCC_UDIRC	(BT16_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT16_RT_STCC_TGIRC	(BT16_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT16_RT_STCC_UDIEC	(BT16_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT16_RT_STCC_TGIEC	(BT16_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT17_RT_STCC	(BT17_RT.unSTCC.u8Register)  /*@rg@*/
#define BT17_RT_STCC_UDIRC	(BT17_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT17_RT_STCC_TGIRC	(BT17_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT17_RT_STCC_UDIEC	(BT17_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT17_RT_STCC_TGIEC	(BT17_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT18_RT_STCC	(BT18_RT.unSTCC.u8Register)  /*@rg@*/
#define BT18_RT_STCC_UDIRC	(BT18_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT18_RT_STCC_TGIRC	(BT18_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT18_RT_STCC_UDIEC	(BT18_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT18_RT_STCC_TGIEC	(BT18_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT19_RT_STCC	(BT19_RT.unSTCC.u8Register)  /*@rg@*/
#define BT19_RT_STCC_UDIRC	(BT19_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT19_RT_STCC_TGIRC	(BT19_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT19_RT_STCC_UDIEC	(BT19_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT19_RT_STCC_TGIEC	(BT19_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT20_RT_STCC	(BT20_RT.unSTCC.u8Register)  /*@rg@*/
#define BT20_RT_STCC_UDIRC	(BT20_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT20_RT_STCC_TGIRC	(BT20_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT20_RT_STCC_UDIEC	(BT20_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT20_RT_STCC_TGIEC	(BT20_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT21_RT_STCC	(BT21_RT.unSTCC.u8Register)  /*@rg@*/
#define BT21_RT_STCC_UDIRC	(BT21_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT21_RT_STCC_TGIRC	(BT21_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT21_RT_STCC_UDIEC	(BT21_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT21_RT_STCC_TGIEC	(BT21_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT22_RT_STCC	(BT22_RT.unSTCC.u8Register)  /*@rg@*/
#define BT22_RT_STCC_UDIRC	(BT22_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT22_RT_STCC_TGIRC	(BT22_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT22_RT_STCC_UDIEC	(BT22_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT22_RT_STCC_TGIEC	(BT22_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT23_RT_STCC	(BT23_RT.unSTCC.u8Register)  /*@rg@*/
#define BT23_RT_STCC_UDIRC	(BT23_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT23_RT_STCC_TGIRC	(BT23_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT23_RT_STCC_UDIEC	(BT23_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT23_RT_STCC_TGIEC	(BT23_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT24_RT_STCC	(BT24_RT.unSTCC.u8Register)  /*@rg@*/
#define BT24_RT_STCC_UDIRC	(BT24_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT24_RT_STCC_TGIRC	(BT24_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT24_RT_STCC_UDIEC	(BT24_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT24_RT_STCC_TGIEC	(BT24_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT25_RT_STCC	(BT25_RT.unSTCC.u8Register)  /*@rg@*/
#define BT25_RT_STCC_UDIRC	(BT25_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT25_RT_STCC_TGIRC	(BT25_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT25_RT_STCC_UDIEC	(BT25_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT25_RT_STCC_TGIEC	(BT25_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT26_RT_STCC	(BT26_RT.unSTCC.u8Register)  /*@rg@*/
#define BT26_RT_STCC_UDIRC	(BT26_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT26_RT_STCC_TGIRC	(BT26_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT26_RT_STCC_UDIEC	(BT26_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT26_RT_STCC_TGIEC	(BT26_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT27_RT_STCC	(BT27_RT.unSTCC.u8Register)  /*@rg@*/
#define BT27_RT_STCC_UDIRC	(BT27_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT27_RT_STCC_TGIRC	(BT27_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT27_RT_STCC_UDIEC	(BT27_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT27_RT_STCC_TGIEC	(BT27_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT28_RT_STCC	(BT28_RT.unSTCC.u8Register)  /*@rg@*/
#define BT28_RT_STCC_UDIRC	(BT28_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT28_RT_STCC_TGIRC	(BT28_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT28_RT_STCC_UDIEC	(BT28_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT28_RT_STCC_TGIEC	(BT28_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT29_RT_STCC	(BT29_RT.unSTCC.u8Register)  /*@rg@*/
#define BT29_RT_STCC_UDIRC	(BT29_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT29_RT_STCC_TGIRC	(BT29_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT29_RT_STCC_UDIEC	(BT29_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT29_RT_STCC_TGIEC	(BT29_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT30_RT_STCC	(BT30_RT.unSTCC.u8Register)  /*@rg@*/
#define BT30_RT_STCC_UDIRC	(BT30_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT30_RT_STCC_TGIRC	(BT30_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT30_RT_STCC_UDIEC	(BT30_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT30_RT_STCC_TGIEC	(BT30_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

#define BT31_RT_STCC	(BT31_RT.unSTCC.u8Register)  /*@rg@*/
#define BT31_RT_STCC_UDIRC	(BT31_RT.unSTCC.stcField.u1UDIRC)  /*@bf@*/
#define BT31_RT_STCC_TGIRC	(BT31_RT.unSTCC.stcField.u1TGIRC)  /*@bf@*/
#define BT31_RT_STCC_UDIEC	(BT31_RT.unSTCC.stcField.u1UDIEC)  /*@bf@*/
#define BT31_RT_STCC_TGIEC	(BT31_RT.unSTCC.stcField.u1TGIEC)  /*@bf@*/

typedef struct stc_btn_rt_stcc_field{
    uint_io8_t		u1UDIRC:1;
    uint_io8_t		:1;
    uint_io8_t		u1TGIRC:1;
    uint_io8_t		:1;
    uint_io8_t		u1UDIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1TGIEC:1;
    uint_io8_t		:1;
}stc_btn_rt_stcc_field_t;

typedef union un_btn_rt_stcc{
    uint_io8_t		u8Register;
    stc_btn_rt_stcc_field_t		stcField;
}un_btn_rt_stcc_t;

/* STCS */
#define BT00_RT_STCS	(BT00_RT.unSTCS.u8Register)  /*@rg@*/
#define BT00_RT_STCS_UDIES	(BT00_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT00_RT_STCS_TGIES	(BT00_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT01_RT_STCS	(BT01_RT.unSTCS.u8Register)  /*@rg@*/
#define BT01_RT_STCS_UDIES	(BT01_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT01_RT_STCS_TGIES	(BT01_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT02_RT_STCS	(BT02_RT.unSTCS.u8Register)  /*@rg@*/
#define BT02_RT_STCS_UDIES	(BT02_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT02_RT_STCS_TGIES	(BT02_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT03_RT_STCS	(BT03_RT.unSTCS.u8Register)  /*@rg@*/
#define BT03_RT_STCS_UDIES	(BT03_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT03_RT_STCS_TGIES	(BT03_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT04_RT_STCS	(BT04_RT.unSTCS.u8Register)  /*@rg@*/
#define BT04_RT_STCS_UDIES	(BT04_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT04_RT_STCS_TGIES	(BT04_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT05_RT_STCS	(BT05_RT.unSTCS.u8Register)  /*@rg@*/
#define BT05_RT_STCS_UDIES	(BT05_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT05_RT_STCS_TGIES	(BT05_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT06_RT_STCS	(BT06_RT.unSTCS.u8Register)  /*@rg@*/
#define BT06_RT_STCS_UDIES	(BT06_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT06_RT_STCS_TGIES	(BT06_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT07_RT_STCS	(BT07_RT.unSTCS.u8Register)  /*@rg@*/
#define BT07_RT_STCS_UDIES	(BT07_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT07_RT_STCS_TGIES	(BT07_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT08_RT_STCS	(BT08_RT.unSTCS.u8Register)  /*@rg@*/
#define BT08_RT_STCS_UDIES	(BT08_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT08_RT_STCS_TGIES	(BT08_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT09_RT_STCS	(BT09_RT.unSTCS.u8Register)  /*@rg@*/
#define BT09_RT_STCS_UDIES	(BT09_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT09_RT_STCS_TGIES	(BT09_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT10_RT_STCS	(BT10_RT.unSTCS.u8Register)  /*@rg@*/
#define BT10_RT_STCS_UDIES	(BT10_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT10_RT_STCS_TGIES	(BT10_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT11_RT_STCS	(BT11_RT.unSTCS.u8Register)  /*@rg@*/
#define BT11_RT_STCS_UDIES	(BT11_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT11_RT_STCS_TGIES	(BT11_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT12_RT_STCS	(BT12_RT.unSTCS.u8Register)  /*@rg@*/
#define BT12_RT_STCS_UDIES	(BT12_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT12_RT_STCS_TGIES	(BT12_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT13_RT_STCS	(BT13_RT.unSTCS.u8Register)  /*@rg@*/
#define BT13_RT_STCS_UDIES	(BT13_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT13_RT_STCS_TGIES	(BT13_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT14_RT_STCS	(BT14_RT.unSTCS.u8Register)  /*@rg@*/
#define BT14_RT_STCS_UDIES	(BT14_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT14_RT_STCS_TGIES	(BT14_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT15_RT_STCS	(BT15_RT.unSTCS.u8Register)  /*@rg@*/
#define BT15_RT_STCS_UDIES	(BT15_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT15_RT_STCS_TGIES	(BT15_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT16_RT_STCS	(BT16_RT.unSTCS.u8Register)  /*@rg@*/
#define BT16_RT_STCS_UDIES	(BT16_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT16_RT_STCS_TGIES	(BT16_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT17_RT_STCS	(BT17_RT.unSTCS.u8Register)  /*@rg@*/
#define BT17_RT_STCS_UDIES	(BT17_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT17_RT_STCS_TGIES	(BT17_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT18_RT_STCS	(BT18_RT.unSTCS.u8Register)  /*@rg@*/
#define BT18_RT_STCS_UDIES	(BT18_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT18_RT_STCS_TGIES	(BT18_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT19_RT_STCS	(BT19_RT.unSTCS.u8Register)  /*@rg@*/
#define BT19_RT_STCS_UDIES	(BT19_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT19_RT_STCS_TGIES	(BT19_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT20_RT_STCS	(BT20_RT.unSTCS.u8Register)  /*@rg@*/
#define BT20_RT_STCS_UDIES	(BT20_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT20_RT_STCS_TGIES	(BT20_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT21_RT_STCS	(BT21_RT.unSTCS.u8Register)  /*@rg@*/
#define BT21_RT_STCS_UDIES	(BT21_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT21_RT_STCS_TGIES	(BT21_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT22_RT_STCS	(BT22_RT.unSTCS.u8Register)  /*@rg@*/
#define BT22_RT_STCS_UDIES	(BT22_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT22_RT_STCS_TGIES	(BT22_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT23_RT_STCS	(BT23_RT.unSTCS.u8Register)  /*@rg@*/
#define BT23_RT_STCS_UDIES	(BT23_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT23_RT_STCS_TGIES	(BT23_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT24_RT_STCS	(BT24_RT.unSTCS.u8Register)  /*@rg@*/
#define BT24_RT_STCS_UDIES	(BT24_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT24_RT_STCS_TGIES	(BT24_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT25_RT_STCS	(BT25_RT.unSTCS.u8Register)  /*@rg@*/
#define BT25_RT_STCS_UDIES	(BT25_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT25_RT_STCS_TGIES	(BT25_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT26_RT_STCS	(BT26_RT.unSTCS.u8Register)  /*@rg@*/
#define BT26_RT_STCS_UDIES	(BT26_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT26_RT_STCS_TGIES	(BT26_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT27_RT_STCS	(BT27_RT.unSTCS.u8Register)  /*@rg@*/
#define BT27_RT_STCS_UDIES	(BT27_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT27_RT_STCS_TGIES	(BT27_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT28_RT_STCS	(BT28_RT.unSTCS.u8Register)  /*@rg@*/
#define BT28_RT_STCS_UDIES	(BT28_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT28_RT_STCS_TGIES	(BT28_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT29_RT_STCS	(BT29_RT.unSTCS.u8Register)  /*@rg@*/
#define BT29_RT_STCS_UDIES	(BT29_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT29_RT_STCS_TGIES	(BT29_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT30_RT_STCS	(BT30_RT.unSTCS.u8Register)  /*@rg@*/
#define BT30_RT_STCS_UDIES	(BT30_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT30_RT_STCS_TGIES	(BT30_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

#define BT31_RT_STCS	(BT31_RT.unSTCS.u8Register)  /*@rg@*/
#define BT31_RT_STCS_UDIES	(BT31_RT.unSTCS.stcField.u1UDIES)  /*@bf@*/
#define BT31_RT_STCS_TGIES	(BT31_RT.unSTCS.stcField.u1TGIES)  /*@bf@*/

typedef struct stc_btn_rt_stcs_field{
    uint_io8_t		:4;
    uint_io8_t		u1UDIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1TGIES:1;
    uint_io8_t		:1;
}stc_btn_rt_stcs_field_t;

typedef union un_btn_rt_stcs{
    uint_io8_t		u8Register;
    stc_btn_rt_stcs_field_t		stcField;
}un_btn_rt_stcs_t;

/* BT_DEBUG */
#define BT00_RT_BT_DEBUG	(BT00_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT00_RT_BT_DEBUG_DBGEN	(BT00_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT01_RT_BT_DEBUG	(BT01_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT01_RT_BT_DEBUG_DBGEN	(BT01_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT02_RT_BT_DEBUG	(BT02_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT02_RT_BT_DEBUG_DBGEN	(BT02_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT03_RT_BT_DEBUG	(BT03_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT03_RT_BT_DEBUG_DBGEN	(BT03_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT04_RT_BT_DEBUG	(BT04_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT04_RT_BT_DEBUG_DBGEN	(BT04_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT05_RT_BT_DEBUG	(BT05_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT05_RT_BT_DEBUG_DBGEN	(BT05_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT06_RT_BT_DEBUG	(BT06_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT06_RT_BT_DEBUG_DBGEN	(BT06_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT07_RT_BT_DEBUG	(BT07_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT07_RT_BT_DEBUG_DBGEN	(BT07_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT08_RT_BT_DEBUG	(BT08_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT08_RT_BT_DEBUG_DBGEN	(BT08_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT09_RT_BT_DEBUG	(BT09_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT09_RT_BT_DEBUG_DBGEN	(BT09_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT10_RT_BT_DEBUG	(BT10_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT10_RT_BT_DEBUG_DBGEN	(BT10_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT11_RT_BT_DEBUG	(BT11_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT11_RT_BT_DEBUG_DBGEN	(BT11_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT12_RT_BT_DEBUG	(BT12_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT12_RT_BT_DEBUG_DBGEN	(BT12_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT13_RT_BT_DEBUG	(BT13_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT13_RT_BT_DEBUG_DBGEN	(BT13_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT14_RT_BT_DEBUG	(BT14_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT14_RT_BT_DEBUG_DBGEN	(BT14_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT15_RT_BT_DEBUG	(BT15_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT15_RT_BT_DEBUG_DBGEN	(BT15_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT16_RT_BT_DEBUG	(BT16_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT16_RT_BT_DEBUG_DBGEN	(BT16_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT17_RT_BT_DEBUG	(BT17_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT17_RT_BT_DEBUG_DBGEN	(BT17_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT18_RT_BT_DEBUG	(BT18_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT18_RT_BT_DEBUG_DBGEN	(BT18_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT19_RT_BT_DEBUG	(BT19_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT19_RT_BT_DEBUG_DBGEN	(BT19_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT20_RT_BT_DEBUG	(BT20_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT20_RT_BT_DEBUG_DBGEN	(BT20_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT21_RT_BT_DEBUG	(BT21_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT21_RT_BT_DEBUG_DBGEN	(BT21_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT22_RT_BT_DEBUG	(BT22_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT22_RT_BT_DEBUG_DBGEN	(BT22_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT23_RT_BT_DEBUG	(BT23_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT23_RT_BT_DEBUG_DBGEN	(BT23_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT24_RT_BT_DEBUG	(BT24_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT24_RT_BT_DEBUG_DBGEN	(BT24_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT25_RT_BT_DEBUG	(BT25_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT25_RT_BT_DEBUG_DBGEN	(BT25_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT26_RT_BT_DEBUG	(BT26_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT26_RT_BT_DEBUG_DBGEN	(BT26_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT27_RT_BT_DEBUG	(BT27_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT27_RT_BT_DEBUG_DBGEN	(BT27_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT28_RT_BT_DEBUG	(BT28_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT28_RT_BT_DEBUG_DBGEN	(BT28_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT29_RT_BT_DEBUG	(BT29_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT29_RT_BT_DEBUG_DBGEN	(BT29_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT30_RT_BT_DEBUG	(BT30_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT30_RT_BT_DEBUG_DBGEN	(BT30_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT31_RT_BT_DEBUG	(BT31_RT.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT31_RT_BT_DEBUG_DBGEN	(BT31_RT.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

typedef struct stc_btn_rt_bt_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_btn_rt_bt_debug_field_t;

typedef union un_btn_rt_bt_debug{
    uint_io16_t		u16Register;
    stc_btn_rt_bt_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_rt_bt_debug_t;

/* ETCDR */
#define BT00_RT_ETCDR	(BT00_RT.unETCDR.u16Register)  /*@rg@*/
#define BT00_RT_ETCDR_ETCDR	BT00_RT_ETCDR  /*@bfrg@*/

#define BT01_RT_ETCDR	(BT01_RT.unETCDR.u16Register)  /*@rg@*/
#define BT01_RT_ETCDR_ETCDR	BT01_RT_ETCDR  /*@bfrg@*/

#define BT02_RT_ETCDR	(BT02_RT.unETCDR.u16Register)  /*@rg@*/
#define BT02_RT_ETCDR_ETCDR	BT02_RT_ETCDR  /*@bfrg@*/

#define BT03_RT_ETCDR	(BT03_RT.unETCDR.u16Register)  /*@rg@*/
#define BT03_RT_ETCDR_ETCDR	BT03_RT_ETCDR  /*@bfrg@*/

#define BT04_RT_ETCDR	(BT04_RT.unETCDR.u16Register)  /*@rg@*/
#define BT04_RT_ETCDR_ETCDR	BT04_RT_ETCDR  /*@bfrg@*/

#define BT05_RT_ETCDR	(BT05_RT.unETCDR.u16Register)  /*@rg@*/
#define BT05_RT_ETCDR_ETCDR	BT05_RT_ETCDR  /*@bfrg@*/

#define BT06_RT_ETCDR	(BT06_RT.unETCDR.u16Register)  /*@rg@*/
#define BT06_RT_ETCDR_ETCDR	BT06_RT_ETCDR  /*@bfrg@*/

#define BT07_RT_ETCDR	(BT07_RT.unETCDR.u16Register)  /*@rg@*/
#define BT07_RT_ETCDR_ETCDR	BT07_RT_ETCDR  /*@bfrg@*/

#define BT08_RT_ETCDR	(BT08_RT.unETCDR.u16Register)  /*@rg@*/
#define BT08_RT_ETCDR_ETCDR	BT08_RT_ETCDR  /*@bfrg@*/

#define BT09_RT_ETCDR	(BT09_RT.unETCDR.u16Register)  /*@rg@*/
#define BT09_RT_ETCDR_ETCDR	BT09_RT_ETCDR  /*@bfrg@*/

#define BT10_RT_ETCDR	(BT10_RT.unETCDR.u16Register)  /*@rg@*/
#define BT10_RT_ETCDR_ETCDR	BT10_RT_ETCDR  /*@bfrg@*/

#define BT11_RT_ETCDR	(BT11_RT.unETCDR.u16Register)  /*@rg@*/
#define BT11_RT_ETCDR_ETCDR	BT11_RT_ETCDR  /*@bfrg@*/

#define BT12_RT_ETCDR	(BT12_RT.unETCDR.u16Register)  /*@rg@*/
#define BT12_RT_ETCDR_ETCDR	BT12_RT_ETCDR  /*@bfrg@*/

#define BT13_RT_ETCDR	(BT13_RT.unETCDR.u16Register)  /*@rg@*/
#define BT13_RT_ETCDR_ETCDR	BT13_RT_ETCDR  /*@bfrg@*/

#define BT14_RT_ETCDR	(BT14_RT.unETCDR.u16Register)  /*@rg@*/
#define BT14_RT_ETCDR_ETCDR	BT14_RT_ETCDR  /*@bfrg@*/

#define BT15_RT_ETCDR	(BT15_RT.unETCDR.u16Register)  /*@rg@*/
#define BT15_RT_ETCDR_ETCDR	BT15_RT_ETCDR  /*@bfrg@*/

#define BT16_RT_ETCDR	(BT16_RT.unETCDR.u16Register)  /*@rg@*/
#define BT16_RT_ETCDR_ETCDR	BT16_RT_ETCDR  /*@bfrg@*/

#define BT17_RT_ETCDR	(BT17_RT.unETCDR.u16Register)  /*@rg@*/
#define BT17_RT_ETCDR_ETCDR	BT17_RT_ETCDR  /*@bfrg@*/

#define BT18_RT_ETCDR	(BT18_RT.unETCDR.u16Register)  /*@rg@*/
#define BT18_RT_ETCDR_ETCDR	BT18_RT_ETCDR  /*@bfrg@*/

#define BT19_RT_ETCDR	(BT19_RT.unETCDR.u16Register)  /*@rg@*/
#define BT19_RT_ETCDR_ETCDR	BT19_RT_ETCDR  /*@bfrg@*/

#define BT20_RT_ETCDR	(BT20_RT.unETCDR.u16Register)  /*@rg@*/
#define BT20_RT_ETCDR_ETCDR	BT20_RT_ETCDR  /*@bfrg@*/

#define BT21_RT_ETCDR	(BT21_RT.unETCDR.u16Register)  /*@rg@*/
#define BT21_RT_ETCDR_ETCDR	BT21_RT_ETCDR  /*@bfrg@*/

#define BT22_RT_ETCDR	(BT22_RT.unETCDR.u16Register)  /*@rg@*/
#define BT22_RT_ETCDR_ETCDR	BT22_RT_ETCDR  /*@bfrg@*/

#define BT23_RT_ETCDR	(BT23_RT.unETCDR.u16Register)  /*@rg@*/
#define BT23_RT_ETCDR_ETCDR	BT23_RT_ETCDR  /*@bfrg@*/

#define BT24_RT_ETCDR	(BT24_RT.unETCDR.u16Register)  /*@rg@*/
#define BT24_RT_ETCDR_ETCDR	BT24_RT_ETCDR  /*@bfrg@*/

#define BT25_RT_ETCDR	(BT25_RT.unETCDR.u16Register)  /*@rg@*/
#define BT25_RT_ETCDR_ETCDR	BT25_RT_ETCDR  /*@bfrg@*/

#define BT26_RT_ETCDR	(BT26_RT.unETCDR.u16Register)  /*@rg@*/
#define BT26_RT_ETCDR_ETCDR	BT26_RT_ETCDR  /*@bfrg@*/

#define BT27_RT_ETCDR	(BT27_RT.unETCDR.u16Register)  /*@rg@*/
#define BT27_RT_ETCDR_ETCDR	BT27_RT_ETCDR  /*@bfrg@*/

#define BT28_RT_ETCDR	(BT28_RT.unETCDR.u16Register)  /*@rg@*/
#define BT28_RT_ETCDR_ETCDR	BT28_RT_ETCDR  /*@bfrg@*/

#define BT29_RT_ETCDR	(BT29_RT.unETCDR.u16Register)  /*@rg@*/
#define BT29_RT_ETCDR_ETCDR	BT29_RT_ETCDR  /*@bfrg@*/

#define BT30_RT_ETCDR	(BT30_RT.unETCDR.u16Register)  /*@rg@*/
#define BT30_RT_ETCDR_ETCDR	BT30_RT_ETCDR  /*@bfrg@*/

#define BT31_RT_ETCDR	(BT31_RT.unETCDR.u16Register)  /*@rg@*/
#define BT31_RT_ETCDR_ETCDR	BT31_RT_ETCDR  /*@bfrg@*/

typedef union un_btn_rt_etcdr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_rt_etcdr_t;


typedef struct stc_btn_rt{
    un_btn_rt_pcsr_t	unPCSR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[6];	/* 0x00000002 */
    un_btn_rt_tmr_t	unTMR;	/* 0x00000008 */
    uint_io8_t	au8Reserved1[2];	/* 0x0000000A */
    un_btn_rt_tmcr_t	unTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved2[2];	/* 0x0000000E */
    un_btn_rt_stc_t	unSTC;	/* 0x00000010 */
    un_btn_rt_tmcr2_t	unTMCR2;	/* 0x00000011 */
    uint_io8_t	au8Reserved3[2];	/* 0x00000012 */
    un_btn_rt_stcc_t	unSTCC;	/* 0x00000014 */
    uint_io8_t	au8Reserved4[3];	/* 0x00000015 */
    un_btn_rt_stcs_t	unSTCS;	/* 0x00000018 */
    uint_io8_t	au8Reserved5[11];	/* 0x00000019 */
    un_btn_rt_bt_debug_t	unBT_DEBUG;	/* 0x00000024 */
    uint_io8_t	au8Reserved6[6];	/* 0x00000026 */
    un_btn_rt_etcdr_t	unETCDR;	/* 0x0000002C */
    uint_io8_t	au8Reserved7[2];	/* 0x0000002E */
}stc_btn_rt_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_btn_rt_t	stcBT_RT[32];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 48(0x30) bytes */


#endif /* __S6J3360_BT_RT_H */
