/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_RLT_H
#define __S6J3360_RLT_H

#include "s6j3360io_basetypes.h"

/* RLT[0-3/16-17] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define RLT0	stcRLT[0]
#define RLT1	stcRLT[1]
#define RLT2	stcRLT[2]
#define RLT3	stcRLT[3]
#define RLT16	stcRLT[4]
#define RLT17	stcRLT[5]
#else /* __IO_DEFINE */
#define RLT0	(*((volatile stc_rltn_t*)0xB4810000))
#define RLT1	(*((volatile stc_rltn_t*)0xB4810400))
#define RLT2	(*((volatile stc_rltn_t*)0xB4810800))
#define RLT3	(*((volatile stc_rltn_t*)0xB4810C00))
#define RLT16	(*((volatile stc_rltn_t*)0xB4890000))
#define RLT17	(*((volatile stc_rltn_t*)0xB4890400))
#endif /* __IO_DEFINE */

/* DMACFG */
#define RLT0_DMACFG	(RLT0.unDMACFG.u32Register)  /*@rg@*/
#define RLT0_DMACFG_ENDMAUF	(RLT0.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

#define RLT1_DMACFG	(RLT1.unDMACFG.u32Register)  /*@rg@*/
#define RLT1_DMACFG_ENDMAUF	(RLT1.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

#define RLT2_DMACFG	(RLT2.unDMACFG.u32Register)  /*@rg@*/
#define RLT2_DMACFG_ENDMAUF	(RLT2.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

#define RLT3_DMACFG	(RLT3.unDMACFG.u32Register)  /*@rg@*/
#define RLT3_DMACFG_ENDMAUF	(RLT3.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

#define RLT16_DMACFG	(RLT16.unDMACFG.u32Register)  /*@rg@*/
#define RLT16_DMACFG_ENDMAUF	(RLT16.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

#define RLT17_DMACFG	(RLT17.unDMACFG.u32Register)  /*@rg@*/
#define RLT17_DMACFG_ENDMAUF	(RLT17.unDMACFG.stcField.u1ENDMAUF)  /*@bf@*/

typedef struct stc_rltn_dmacfg_field{
    uint_io32_t		u1ENDMAUF:1;
    uint_io32_t		:31;
}stc_rltn_dmacfg_field_t;

typedef union un_rltn_dmacfg{
    uint_io32_t		u32Register;
    stc_rltn_dmacfg_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_dmacfg_t;

/* TMCSR */
#define RLT0_TMCSR	(RLT0.unTMCSR.u32Register)  /*@rg@*/
#define RLT0_TMCSR_INTE	(RLT0.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT0_TMCSR_RELD	(RLT0.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT0_TMCSR_OUTL	(RLT0.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT0_TMCSR_DBGE	(RLT0.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT0_TMCSR_NFE	(RLT0.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT0_TMCSR_CSL	(RLT0.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT0_TMCSR_MOD	(RLT0.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT0_TMCSR_UF	(RLT0.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT0_TMCSR_UFCLR	(RLT0.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT0_TMCSR_TRG	(RLT0.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT0_TMCSR_CNTE	(RLT0.unTMCSR.stcField.u1CNTE)  /*@bf@*/

#define RLT1_TMCSR	(RLT1.unTMCSR.u32Register)  /*@rg@*/
#define RLT1_TMCSR_INTE	(RLT1.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT1_TMCSR_RELD	(RLT1.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT1_TMCSR_OUTL	(RLT1.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT1_TMCSR_DBGE	(RLT1.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT1_TMCSR_NFE	(RLT1.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT1_TMCSR_CSL	(RLT1.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT1_TMCSR_MOD	(RLT1.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT1_TMCSR_UF	(RLT1.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT1_TMCSR_UFCLR	(RLT1.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT1_TMCSR_TRG	(RLT1.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT1_TMCSR_CNTE	(RLT1.unTMCSR.stcField.u1CNTE)  /*@bf@*/

#define RLT2_TMCSR	(RLT2.unTMCSR.u32Register)  /*@rg@*/
#define RLT2_TMCSR_INTE	(RLT2.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT2_TMCSR_RELD	(RLT2.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT2_TMCSR_OUTL	(RLT2.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT2_TMCSR_DBGE	(RLT2.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT2_TMCSR_NFE	(RLT2.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT2_TMCSR_CSL	(RLT2.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT2_TMCSR_MOD	(RLT2.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT2_TMCSR_UF	(RLT2.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT2_TMCSR_UFCLR	(RLT2.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT2_TMCSR_TRG	(RLT2.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT2_TMCSR_CNTE	(RLT2.unTMCSR.stcField.u1CNTE)  /*@bf@*/

#define RLT3_TMCSR	(RLT3.unTMCSR.u32Register)  /*@rg@*/
#define RLT3_TMCSR_INTE	(RLT3.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT3_TMCSR_RELD	(RLT3.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT3_TMCSR_OUTL	(RLT3.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT3_TMCSR_DBGE	(RLT3.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT3_TMCSR_NFE	(RLT3.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT3_TMCSR_CSL	(RLT3.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT3_TMCSR_MOD	(RLT3.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT3_TMCSR_UF	(RLT3.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT3_TMCSR_UFCLR	(RLT3.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT3_TMCSR_TRG	(RLT3.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT3_TMCSR_CNTE	(RLT3.unTMCSR.stcField.u1CNTE)  /*@bf@*/

#define RLT16_TMCSR	(RLT16.unTMCSR.u32Register)  /*@rg@*/
#define RLT16_TMCSR_INTE	(RLT16.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT16_TMCSR_RELD	(RLT16.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT16_TMCSR_OUTL	(RLT16.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT16_TMCSR_DBGE	(RLT16.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT16_TMCSR_NFE	(RLT16.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT16_TMCSR_CSL	(RLT16.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT16_TMCSR_MOD	(RLT16.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT16_TMCSR_UF	(RLT16.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT16_TMCSR_UFCLR	(RLT16.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT16_TMCSR_TRG	(RLT16.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT16_TMCSR_CNTE	(RLT16.unTMCSR.stcField.u1CNTE)  /*@bf@*/

#define RLT17_TMCSR	(RLT17.unTMCSR.u32Register)  /*@rg@*/
#define RLT17_TMCSR_INTE	(RLT17.unTMCSR.stcField.u1INTE)  /*@bf@*/
#define RLT17_TMCSR_RELD	(RLT17.unTMCSR.stcField.u1RELD)  /*@bf@*/
#define RLT17_TMCSR_OUTL	(RLT17.unTMCSR.stcField.u1OUTL)  /*@bf@*/
#define RLT17_TMCSR_DBGE	(RLT17.unTMCSR.stcField.u1DBGE)  /*@bf@*/
#define RLT17_TMCSR_NFE	(RLT17.unTMCSR.stcField.u1NFE)  /*@bf@*/
#define RLT17_TMCSR_CSL	(RLT17.unTMCSR.stcField.u3CSL)  /*@bf@*/
#define RLT17_TMCSR_MOD	(RLT17.unTMCSR.stcField.u3MOD)  /*@bf@*/
#define RLT17_TMCSR_UF	(RLT17.unTMCSR.stcField.u1UF)  /*@bf@*/
#define RLT17_TMCSR_UFCLR	(RLT17.unTMCSR.stcField.u1UFCLR)  /*@bf@*/
#define RLT17_TMCSR_TRG	(RLT17.unTMCSR.stcField.u1TRG)  /*@bf@*/
#define RLT17_TMCSR_CNTE	(RLT17.unTMCSR.stcField.u1CNTE)  /*@bf@*/

typedef struct stc_rltn_tmcsr_field{
    uint_io32_t		:3;
    uint_io32_t		u1INTE:1;
    uint_io32_t		u1RELD:1;
    uint_io32_t		u1OUTL:1;
    uint_io32_t		:1;
    uint_io32_t		u1DBGE:1;
    uint_io32_t		u1NFE:1;
    uint_io32_t		:1;
    uint_io32_t		u3CSL:3;
    uint_io32_t		u3MOD:3;
    uint_io32_t		u1UF:1;
    uint_io32_t		u1UFCLR:1;
    uint_io32_t		u1TRG:1;
    uint_io32_t		:5;
    uint_io32_t		u1CNTE:1;
    uint_io32_t		:7;
}stc_rltn_tmcsr_field_t;

typedef union un_rltn_tmcsr{
    uint_io32_t		u32Register;
    stc_rltn_tmcsr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_tmcsr_t;

/* TMRLR */
#define RLT0_TMRLR	(RLT0.unTMRLR.u32Register)  /*@rg@*/
#define RLT0_TMRLR_TMRLR	RLT0_TMRLR  /*@bfrg@*/

#define RLT1_TMRLR	(RLT1.unTMRLR.u32Register)  /*@rg@*/
#define RLT1_TMRLR_TMRLR	RLT1_TMRLR  /*@bfrg@*/

#define RLT2_TMRLR	(RLT2.unTMRLR.u32Register)  /*@rg@*/
#define RLT2_TMRLR_TMRLR	RLT2_TMRLR  /*@bfrg@*/

#define RLT3_TMRLR	(RLT3.unTMRLR.u32Register)  /*@rg@*/
#define RLT3_TMRLR_TMRLR	RLT3_TMRLR  /*@bfrg@*/

#define RLT16_TMRLR	(RLT16.unTMRLR.u32Register)  /*@rg@*/
#define RLT16_TMRLR_TMRLR	RLT16_TMRLR  /*@bfrg@*/

#define RLT17_TMRLR	(RLT17.unTMRLR.u32Register)  /*@rg@*/
#define RLT17_TMRLR_TMRLR	RLT17_TMRLR  /*@bfrg@*/

typedef union un_rltn_tmrlr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_tmrlr_t;

/* TMR */
#define RLT0_TMR	(RLT0.unTMR.u32Register)  /*@rg@*/
#define RLT0_TMR_TMR	RLT0_TMR  /*@bfrg@*/

#define RLT1_TMR	(RLT1.unTMR.u32Register)  /*@rg@*/
#define RLT1_TMR_TMR	RLT1_TMR  /*@bfrg@*/

#define RLT2_TMR	(RLT2.unTMR.u32Register)  /*@rg@*/
#define RLT2_TMR_TMR	RLT2_TMR  /*@bfrg@*/

#define RLT3_TMR	(RLT3.unTMR.u32Register)  /*@rg@*/
#define RLT3_TMR_TMR	RLT3_TMR  /*@bfrg@*/

#define RLT16_TMR	(RLT16.unTMR.u32Register)  /*@rg@*/
#define RLT16_TMR_TMR	RLT16_TMR  /*@bfrg@*/

#define RLT17_TMR	(RLT17.unTMR.u32Register)  /*@rg@*/
#define RLT17_TMR_TMR	RLT17_TMR  /*@bfrg@*/

typedef union un_rltn_tmr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_tmr_t;


typedef struct stc_rltn{
    un_rltn_dmacfg_t	unDMACFG;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000004 */
    un_rltn_tmcsr_t	unTMCSR;	/* 0x00000008 */
    uint_io8_t	au8Reserved1[4];	/* 0x0000000C */
    un_rltn_tmrlr_t	unTMRLR;	/* 0x00000010 */
    un_rltn_tmr_t	unTMR;	/* 0x00000014 */
    uint_io8_t	au8Reserved2[1000];	/* 0x00000018 */
}stc_rltn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_rltn_t	stcRLT[6];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


/* RLT[0-1] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define RLT0_1	stcRLT_1[0]
#define RLT1_1	stcRLT_1[1]
#else /* __IO_DEFINE */
#define RLT0_1	(*((volatile stc_rltn_1_t*)0xB483FC00))
#define RLT1_1	(*((volatile stc_rltn_1_t*)0xB48BFC00))
#endif /* __IO_DEFINE */

/* TSEL */
#define RLT0_TSEL	(RLT0_1.unTSEL.u32Register)  /*@rg@*/
#define RLT0_TSEL_TSEL0	(RLT0_1.unTSEL.stcField.u1TSEL0)  /*@bf@*/
#define RLT0_TSEL_TSEL1	(RLT0_1.unTSEL.stcField.u1TSEL1)  /*@bf@*/
#define RLT0_TSEL_TSEL2	(RLT0_1.unTSEL.stcField.u1TSEL2)  /*@bf@*/
#define RLT0_TSEL_TSEL3	(RLT0_1.unTSEL.stcField.u1TSEL3)  /*@bf@*/
#define RLT0_TSEL_TSEL4	(RLT0_1.unTSEL.stcField.u1TSEL4)  /*@bf@*/
#define RLT0_TSEL_TSEL5	(RLT0_1.unTSEL.stcField.u1TSEL5)  /*@bf@*/
#define RLT0_TSEL_TSEL6	(RLT0_1.unTSEL.stcField.u1TSEL6)  /*@bf@*/
#define RLT0_TSEL_TSEL7	(RLT0_1.unTSEL.stcField.u1TSEL7)  /*@bf@*/
#define RLT0_TSEL_TSEL8	(RLT0_1.unTSEL.stcField.u1TSEL8)  /*@bf@*/
#define RLT0_TSEL_TSEL9	(RLT0_1.unTSEL.stcField.u1TSEL9)  /*@bf@*/
#define RLT0_TSEL_TSEL10	(RLT0_1.unTSEL.stcField.u1TSEL10)  /*@bf@*/
#define RLT0_TSEL_TSEL11	(RLT0_1.unTSEL.stcField.u1TSEL11)  /*@bf@*/
#define RLT0_TSEL_TSEL12	(RLT0_1.unTSEL.stcField.u1TSEL12)  /*@bf@*/
#define RLT0_TSEL_TSEL13	(RLT0_1.unTSEL.stcField.u1TSEL13)  /*@bf@*/
#define RLT0_TSEL_TSEL14	(RLT0_1.unTSEL.stcField.u1TSEL14)  /*@bf@*/
#define RLT0_TSEL_TSEL15	(RLT0_1.unTSEL.stcField.u1TSEL15)  /*@bf@*/

#define RLT1_TSEL	(RLT1_1.unTSEL.u32Register)  /*@rg@*/
#define RLT1_TSEL_TSEL0	(RLT1_1.unTSEL.stcField.u1TSEL0)  /*@bf@*/
#define RLT1_TSEL_TSEL1	(RLT1_1.unTSEL.stcField.u1TSEL1)  /*@bf@*/
#define RLT1_TSEL_TSEL2	(RLT1_1.unTSEL.stcField.u1TSEL2)  /*@bf@*/
#define RLT1_TSEL_TSEL3	(RLT1_1.unTSEL.stcField.u1TSEL3)  /*@bf@*/
#define RLT1_TSEL_TSEL4	(RLT1_1.unTSEL.stcField.u1TSEL4)  /*@bf@*/
#define RLT1_TSEL_TSEL5	(RLT1_1.unTSEL.stcField.u1TSEL5)  /*@bf@*/
#define RLT1_TSEL_TSEL6	(RLT1_1.unTSEL.stcField.u1TSEL6)  /*@bf@*/
#define RLT1_TSEL_TSEL7	(RLT1_1.unTSEL.stcField.u1TSEL7)  /*@bf@*/
#define RLT1_TSEL_TSEL8	(RLT1_1.unTSEL.stcField.u1TSEL8)  /*@bf@*/
#define RLT1_TSEL_TSEL9	(RLT1_1.unTSEL.stcField.u1TSEL9)  /*@bf@*/
#define RLT1_TSEL_TSEL10	(RLT1_1.unTSEL.stcField.u1TSEL10)  /*@bf@*/
#define RLT1_TSEL_TSEL11	(RLT1_1.unTSEL.stcField.u1TSEL11)  /*@bf@*/
#define RLT1_TSEL_TSEL12	(RLT1_1.unTSEL.stcField.u1TSEL12)  /*@bf@*/
#define RLT1_TSEL_TSEL13	(RLT1_1.unTSEL.stcField.u1TSEL13)  /*@bf@*/
#define RLT1_TSEL_TSEL14	(RLT1_1.unTSEL.stcField.u1TSEL14)  /*@bf@*/
#define RLT1_TSEL_TSEL15	(RLT1_1.unTSEL.stcField.u1TSEL15)  /*@bf@*/

typedef struct stc_rltn_1_tsel_field{
    uint_io32_t		u1TSEL0:1;
    uint_io32_t		u1TSEL1:1;
    uint_io32_t		u1TSEL2:1;
    uint_io32_t		u1TSEL3:1;
    uint_io32_t		u1TSEL4:1;
    uint_io32_t		u1TSEL5:1;
    uint_io32_t		u1TSEL6:1;
    uint_io32_t		u1TSEL7:1;
    uint_io32_t		u1TSEL8:1;
    uint_io32_t		u1TSEL9:1;
    uint_io32_t		u1TSEL10:1;
    uint_io32_t		u1TSEL11:1;
    uint_io32_t		u1TSEL12:1;
    uint_io32_t		u1TSEL13:1;
    uint_io32_t		u1TSEL14:1;
    uint_io32_t		u1TSEL15:1;
    uint_io32_t		:16;
}stc_rltn_1_tsel_field_t;

typedef union un_rltn_1_tsel{
    uint_io32_t		u32Register;
    stc_rltn_1_tsel_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_1_tsel_t;

/* SSSR */
#define RLT0_SSSR	(RLT0_1.unSSSR.u32Register)  /*@rg@*/
#define RLT0_SSSR_SSSR	(RLT0_1.unSSSR.au16Halfword[0])  /*@bfhword@*/

#define RLT1_SSSR	(RLT1_1.unSSSR.u32Register)  /*@rg@*/
#define RLT1_SSSR_SSSR	(RLT1_1.unSSSR.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_rltn_1_sssr_field{
    uint_io32_t		u16SSSR:16;
    uint_io32_t		:16;
}stc_rltn_1_sssr_field_t;

typedef union un_rltn_1_sssr{
    uint_io32_t		u32Register;
    stc_rltn_1_sssr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_rltn_1_sssr_t;


typedef struct stc_rltn_1{
    un_rltn_1_tsel_t	unTSEL;	/* 0x00000000 */
    un_rltn_1_sssr_t	unSSSR;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[1016];	/* 0x00000008 */
}stc_rltn_1_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_rltn_1_t	stcRLT_1[2];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_RLT_H */
