/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_CM_H
#define __S6J3360_CM_H

#include "s6j3360io_basetypes.h"

/* CM base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CM	stcCM
#else /* __IO_DEFINE */
#define CM	(*((volatile stc_cm_t*)0xB0643000))
#endif /* __IO_DEFINE */

/* CKOTCNTR */
#define CM_CKOTCNTR	(CM.unCKOTCNTR.u32Register)  /*@rg@*/
#define CM_CKOTCNTR_CKSEL	(CM.unCKOTCNTR.stcField.u4CKSEL)  /*@bf@*/
#define CM_CKOTCNTR_CKOUTDIV	(CM.unCKOTCNTR.stcField.u3CKOUTDIV)  /*@bf@*/
#define CM_CKOTCNTR_ENCLKO	(*(volatile uint_io8_t*)0xB0A18018)  /*@bfbba@*/

typedef struct stc_cm_ckotcntr_field{
    uint_io32_t		u4CKSEL:4;
    uint_io32_t		:4;
    uint_io32_t		u3CKOUTDIV:3;
    uint_io32_t		:13;
    uint_io32_t		u1ENCLKO:1;
    uint_io32_t		:7;
}stc_cm_ckotcntr_field_t;

typedef union un_cm_ckotcntr{
    uint_io32_t		u32Register;
    stc_cm_ckotcntr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cm_ckotcntr_t;


typedef struct stc_cm{
    un_cm_ckotcntr_t	unCKOTCNTR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[4092];	/* 0x00000004 */
}stc_cm_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cm_t	stcCM;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 4096(0x1000) bytes */


#endif /* __S6J3360_CM_H */
