#ifndef _UDS_SERVICE_H_
#define _UDS_SERVICE_H_

#define SOFTWARE_VERSION "A01(1.14)"
#define HARDWARE_VERSION "A01(1.00)"
#define PART_NUMBER "94013L4010"

//he bin  
#define PART_NUMBER0    '9'
#define PART_NUMBER1    '4'
#define PART_NUMBER2    '0'
#define PART_NUMBER3    '0'
#define PART_NUMBER4    '3'
#define PART_NUMBER5    'Q'
#define PART_NUMBER6    '3'
#define PART_NUMBER7    '0'
#define PART_NUMBER8    '0'
#define PART_NUMBER9    '0'
                
//chu chang ri qi
#define Manufacture_Date        0x20191227

typedef enum {
    COMM_TYPE_EnRxEnTx_NormalAndNetworkMsg,
    COMM_TYPE_EnRxEnTx_NormalMsg,
    COMM_TYPE_EnRxEnTx_NetworkMsg,
    COMM_TYPE_DisRxDisTx_NormalAndNetworkMsg,
    COMM_TYPE_DisRxDisTx_NormalMsg,
    COMM_TYPE_DisRxDisTx_NetworkMsg,
} Uds_CommType;

typedef enum {
    DTC_SETTING_TYPE_ON,
    DTC_SETTING_TYPE_OFF,
} Uds_DtcSettingType;

typedef struct {
    Uds_CommType      CommType;
    uint8_t     CommNormalMessageDisableTx;
    uint8_t     CommNormalMessageDisableRx;
    uint8_t     CommNMMessageDisableTx;
    uint8_t     CommNMMessageDisableRx;
    Uds_DtcSettingType DtcSettingType;
    uint32_t    Seed;
    uint32_t    Key;
    uint8_t Service27ErrorCnts;
    uint16_t Service27LimitTimer;
    uint8_t IOControlByIdentAllOn;
    uint8_t IOControlByIdentAllOff;
}UDS_PARAMETER;

extern UDS_PARAMETER UdsParameter;

typedef struct
{
    uint8_t    Checkflag;
    uint8_t    AppExist;
    uint8_t    SessionType;
    uint8_t    Reserved1;
    uint8_t    Reserved2;
    uint8_t    Reserved3;
    uint8_t    Reserved4;
    uint8_t    Reserved5;
    uint8_t    Reserved6;
    uint8_t    Reserved7;
    uint8_t    Reserved8;
    uint8_t    Reserved9;
    uint8_t    Reserved10;
    uint8_t    Reserved11;
    uint8_t    Reserved12;
    uint8_t    bCheckSun;
}_BootJumpToAppReg;


extern uint8_t UdsEolStart;
extern _BootJumpToAppReg   JumpToAppReg;

extern void InitDiagnostic(void);
extern void UDS_Service27LimitTimerDecrease(uint8_t n);
extern uint16_t UDS_SetResp_0x10(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x20(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x11(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x29(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x27(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x28(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x85(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x14(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x19(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x34(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x36(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UDS_SetResp_0x37(uint8_t *ReqData, uint16_t ReqLen, uint8_t *RespData, uint16_t RespLen);

extern uint16_t UdsRDID_F180(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F181(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F182(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F183(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F184(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F185(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F186(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F187(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F188(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F189(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F18A(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F18B(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F18C(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F18D(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F18E(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F190(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F191(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F192(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F193(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F194(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F195(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F196(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F197(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F198(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F199(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19A(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19B(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19C(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19D(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19E(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F19F(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F1A0(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_F100(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_B001(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_B002(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_B003(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_0060(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_0070(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_0072(uint8_t *Data, uint16_t length);
extern uint16_t UdsRDID_0073(uint8_t *Data, uint16_t length);
                                                                            
extern uint16_t UdsWDID_F190(uint8_t *Data, uint16_t length);             
extern uint16_t UdsWDID_0060(uint8_t *Data, uint16_t length);
extern uint16_t UdsWDID_0070(uint8_t *Data, uint16_t length);
extern uint16_t UdsWDID_0071(uint8_t *Data, uint16_t length);
extern uint16_t UdsWDID_0072(uint8_t *Data, uint16_t length);
extern uint16_t UdsWDID_0073(uint8_t *Data, uint16_t length);
extern uint16_t UdsStartRC_FF00(uint8_t *param, uint16_t length, uint8_t *status);
extern uint16_t UdsStopRC_FF00(uint8_t *param, uint16_t length, uint8_t *status);
extern uint16_t UdsRequestResultRC_FF00(uint8_t *param, uint16_t length, uint8_t *result);
extern uint16_t UdsStartRC_FF01(uint8_t *param, uint16_t length, uint8_t *status);
extern uint16_t UdsStopRC_FF01(uint8_t *param, uint16_t length, uint8_t *status);
extern uint16_t UdsRequestResultRC_FF01(uint8_t *param, uint16_t length, uint8_t *result);
extern uint16_t UdsIOCtlDID_B000(uint8_t *RequestData, uint16_t length, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UdsIOCtlDID_B001(uint8_t *RequestData, uint16_t length, uint8_t *RespData, uint16_t RespLen);
extern uint16_t UdsIOCtlDID_B002(uint8_t *RequestData, uint16_t length, uint8_t *RespData, uint16_t RespLen);

extern uint8_t ClearDtc(uint32_t DtcNum);
extern uint16_t ReadDTC(uint8_t *ReqData, uint8_t ReqLen, uint8_t *RespData, uint16_t RespLen);

#endif
