#include "common_include.h"
#include "app_USM.h"

#pragma location="BACKUP_RAM_CONTENT"
USM_SELF_PARA UsmSelfPara;

const int16_t ServiceImageCoordinate[][2] = {{49, 126}, {73, 126}, {97, 126}, {73, 176}, {97, 176}};
const int16_t ServiceNumberCoordinate[][2] = {{50, 140}, {74, 140}, {98, 140}, {74, 190}, {98, 190}};
const int16_t CurSelectCoordinate[][2] = {{14, 114}, {14, 146}, {14, 178}, {14, 210}, {14, 242}};
const int16_t RightItemCoordinate[][2] = {{193, 116}, {193, 148}, {193, 180}, {193, 212}, {193, 244}};
const int16_t ItemCoordinate[][2] = {{14, 116}, {14, 148}, {14, 180}, {14, 212}, {14, 244}};
const int16_t TitleCoordinate[2] = {14, 82};

uint8_t CurUSM = 0;
uint8_t LastUSM = 0;
uint8_t USMOp = 0;
uint32_t LastUSMTransitionTime = 0;
USM_DATA_WINDOW USMDataWindow[4];
extern uint8_t LastDisplayType;
int8_t USMSelectMovePoint = 0;
int8_t USMTextMovePoint = 0;
uint8_t Flag_USM_Help = 0;
uint8_t Flag_USM_InvalidJump = 0;
uint8_t ResetSetNum = 0;
uint8_t Flag_Reset = 0;
uint8_t Flag_Reset_OK = 0;
uint8_t Flag_Reset_Cancel = 0;
uint8_t Flag_USM_Park = 0;
uint8_t Flag_USM_Popup = 0;
uint8_t USM_Park_Step = 0;
uint8_t Flag_USMBackToTop = 0;
uint8_t Flag_ServiceReset = 0;
uint8_t ServiceResetSetNum = 0;
USM_HELP_PARA USMHelpPara;

USM_ITEM USMDepth1Para[USM_DEPTH1_TOTAL] = {0};

USM_ITEM USMDepth2DriveAssist[USM_DRIVE_ASSIST_TOTAL] = {0};
USM_ITEM USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_TOTAL] = {0};
USM_ITEM USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TOTAL] = {0};
USM_ITEM USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_TOTAL] = {0};
USM_ITEM USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_TOTAL] = {0};

USM_ITEM USMDepth2Door[USM_DOOR_TOTAL] = {0};
USM_ITEM USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_TOTAL] = {0};
USM_ITEM USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_TOTAL] = {0};

USM_ITEM USMDepth2Light[USM_LIGHT_TOTAL] = {0};
USM_ITEM USMDepth3LightOTTS[USM_LIGHT_OTTS_TOTAL] = {0};

USM_ITEM USMDepth2Sound[USM_SOUND_TOTAL] = {0};
USM_ITEM USMDepth3SoundVPV[USM_SOUND_VPV_TOTAL] = {0};
USM_ITEM USMDepth3SoundPDWV[USM_SOUND_PDWV_TOTAL] = {0};

USM_ITEM USMDepth2Convenience[USM_CONVENIENCE_TOTAL] = {0};
USM_ITEM USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TOTAL] = {0};

USM_ITEM USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TOTAL] = {0};

USM_ITEM USMDepth2Other[USM_OTHER_TOTAL] = {0};
USM_ITEM USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TOTAL] = {0};
USM_ITEM USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TOTAL] = {0};
USM_ITEM USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_TOTAL] = {0};
USM_ITEM USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_TOTAL] = {0};
USM_ITEM USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_TOTAL] = {0};
USM_ITEM USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_TOTAL] = {0};
USM_ITEM USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_TOTAL] = {0};
USM_ITEM USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_TOTAL] = {0};

USM_ITEM USMDepth2Language[USM_LANGUAGE_TOTAL] = {0};


CUR_USM_PARA CurUSMPara[] = {
    //usm id 0x00(dest depth) 00(depth0 select) 00(depth1 select) 00(depth2 select)
    {0x00000000, USMDepth1Para, USM_DEPTH1_TOTAL},
    
    {0x01000000, USMDepth2DriveAssist, USM_DRIVE_ASSIST_TOTAL},
    //{0x02000100, USMDepth3DriveAssistSccReaction, USM_DRIVER_ASSIST_SCC_REACTION_TOTAL},
    {0x02000100, USMDepth3DriveAssistDAW, USM_DRIVER_ASSIST_DAW_TOTAL},
    {0x02000200, USMDepth3DriveAssistLaneSafety, USM_DRIVER_ASSIST_LANE_SAFETY_TOTAL},
    {0x02000300, USMDepth3DriveAssistForwardSafety, USM_DRIVER_ASSIST_FORWARD_SAFETY_TOTAL},
    
    {0x01010000, USMDepth2Door, USM_DOOR_TOTAL},
    {0x02010100, USMDepth3DoorAutoLock, USM_DOOR_AUTO_LOCK_TOTAL},
    {0x02010200, USMDepth3DoorAutoUnlock, USM_DOOR_AUTO_UNLOCK_TOTAL},
    
    {0x01020000, USMDepth2Light, USM_LIGHT_TOTAL},
    {0x02020100, USMDepth3LightOTTS, USM_LIGHT_OTTS_TOTAL},
    
    //{0x01030000, USMDepth2Sound, USM_SOUND_TOTAL},
    //{0x02030100, USMDepth3SoundVPV, USM_SOUND_VPV_TOTAL},
    //{0x02030200, USMDepth3SoundPDWV, USM_SOUND_PDWV_TOTAL},
    
    {0x01030000, USMDepth2Convenience, USM_CONVENIENCE_TOTAL},
    //{0x02030100, USMDepth3ConvenienceWelcomeMirrorLight, USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TOTAL},
    
    {0x01040000, USMDepth2ServiceInterval, USM_SERVICE_INTERVAL_TOTAL},
    
    {0x01050000, USMDepth2Other, USM_OTHER_TOTAL},
    //{0x02050100, USMDepth3OtherInstrumentClusterLayout, USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TOTAL},
    {0x02050100, USMDepth3OtherFuelEconomyReset, USM_OTHER_FUEL_ECONOMY_RESET_TOTAL},
    //{0x02050300, USMDepth3OtherFontSize, USM_OTHER_FONT_SIZE_TOTAL},
    //{0x02050400, USMDepth3OtherSpeedSize, USM_OTHER_SPEED_SIZE_TOTAL},
    //{0x02050500, USMDepth3OtherSpeedUnit, USM_OTHER_SPEED_UNIT_TOTAL},
    //{0x02050600, USMDepth3OtherFuelEconomyUnit, USM_OTHER_FUEL_ECONOMY_UNIT_TOTAL},
    {0x02050200, USMDepth3OtherTemperatureUnit, USM_OTHER_TEMPERATURE_UNIT_TOTAL},
    //{0x02050800, USMDepth3OtherTirePresssureUnit, USM_OTHER_TIRE_PRESSSURE_UNIT_TOTAL},
    
    {0x01060000, USMDepth2Language, USM_LANGUAGE_TOTAL},
};


void USMResetFunc(uint8_t Key)
{
    if(Flag_Reset_OK == 1 || Flag_Reset_Cancel == 1)
    {
        Flag_Reset = 0;
    }
    switch(Key)
    {
    case TRIP_SW1_CUR_DOWN:
        if(ResetSetNum == 0)
        {
            ResetSetNum = 1;
            USMSelectMovePoint = -32;
        }
        else
        {
            ResetSetNum = 0;
        }
        break;
    case TRIP_SW1_CUR_UP:
        if(ResetSetNum == 1)
        {
            ResetSetNum = 0;
            USMSelectMovePoint = 32;
        }
        else
        {
            ResetSetNum = 1;
        }
        break;
    case TRIP_SW1_CUR_OK:
        break;
    }
}

void RunUSMHandler(CUR_USM_PARA *CurUSM, uint8_t DataWindow)
{
    uint8_t i = 0;
    uint8_t n = 0;
    uint8_t ValidNum = 0;
    for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    {
        if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) 
        {
            ValidNum++;
            n = ValidNum - 1;
            if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Disabled != 1)
            {
                if(CurUSM->pCurUSM[i + 1].CurUSMFunc != NULL)
                    CurUSM->pCurUSM[i + 1].CurUSMFunc();
            }
        }
    }
}

uint8_t FindUSMID(uint8_t op)
{
    //uint8_t i;
    // if (op == USM_OP_FORWARD) {
    //     if (GroupTabPara.GroupTabUSM.CurDepth < 2) {
    //         for (uint8_t i = 0; i < (sizeof (CurUSMPara) / sizeof (CurUSMPara[0])); i++) {
    //             if (((CurUSMPara[i].USMID >> 24) & 0xff) == GroupTabPara.GroupTabUSM.CurDepth + 1) {
    //                 if (((CurUSMPara[i].USMID >> 16) & 0xff) == (GroupTabPara.GroupTabUSM.CurDepthSelect[0] & 0xf)) {
    //                     if (((CurUSMPara[i].USMID >> 8) & 0xff) == (GroupTabPara.GroupTabUSM.CurDepthSelect[1] & 0xf)) {
    //                         if (((CurUSMPara[i].USMID >> 0) & 0xff) == (GroupTabPara.GroupTabUSM.CurDepthSelect[2] & 0xf)) {
    //                             return i;
    //                         }
    //                     }
    //                 }
    //             }
    //         }
    //     }
    // } else if (op == USM_OP_BACKWARD) {
    //     if (GroupTabPara.GroupTabUSM.CurDepth > 1) {
    //         for (i = 0; i < (sizeof (CurUSMPara) / sizeof (CurUSMPara[0])); i++) {
    //             if (((CurUSMPara[i].USMID >> 24) & 0xff) == GroupTabPara.GroupTabUSM.CurDepth - 1) {
    //                 if (((CurUSMPara[i].USMID >> 16) & 0xff) == (GroupTabPara.GroupTabUSM.CurDepthSelect[0] & 0xf)) {
    //                     return i;
    //                 }
    //             }
    //         }
    //     } else if (GroupTabPara.GroupTabUSM.CurDepth > 0) {
    //         for (i = 0; i < (sizeof (CurUSMPara) / sizeof (CurUSMPara[0])); i++) {
    //             if (((CurUSMPara[i].USMID >> 24) & 0xff) == GroupTabPara.GroupTabUSM.CurDepth - 1) {
    //                 return i;
    //             }
    //         }
    //     }
    // }
    // return 0xff;    
}

void CalcUSMDataWindow(uint8_t CurUSMDataWindow, CUR_USM_PARA *CurUSM, uint8_t op, uint8_t start, uint8_t cur)   //0:init   1:+   2:-
{
    // uint8_t i;
    // uint8_t ValidNum = 0;
    // uint8_t ItemNum = 0;
    // for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) {
    //     if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) {
    //         ValidNum++;
    //     }
    // }
    // if (ValidNum)
    //     ValidNum--;
    
    // if (op == 0) {
    //     if (ValidNum > 3) {
    //         if ((start < ValidNum) && ((start + 3) < ValidNum))
    //             USMDataWindow[CurUSMDataWindow].StartNum = start;
    //         else
    //             USMDataWindow[CurUSMDataWindow].StartNum = ValidNum - 3;
    //         if ((cur < ValidNum) && ((cur + 3) <= ValidNum))
    //             USMDataWindow[CurUSMDataWindow].CurNum = cur;
    //         else
    //             USMDataWindow[CurUSMDataWindow].CurNum = ValidNum;
    //         USMDataWindow[CurUSMDataWindow].EndNum = USMDataWindow[CurUSMDataWindow].StartNum + 3;
    //     } else {
    //         USMDataWindow[CurUSMDataWindow].StartNum = 0;
    //         if (cur < ValidNum)
    //             USMDataWindow[CurUSMDataWindow].CurNum = cur;
    //         else 
    //             USMDataWindow[CurUSMDataWindow].CurNum = ValidNum;
    //         USMDataWindow[CurUSMDataWindow].EndNum = USMDataWindow[CurUSMDataWindow].StartNum + ValidNum;
    //     }
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {//Чǰ˵ѡ+1
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
    
    // if (op == 1) {  //+
    //     if ((USMDataWindow[CurUSMDataWindow].EndNum < ValidNum) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum) < 2)) {
    //         USMDataWindow[CurUSMDataWindow].CurNum++;  
    //         USMSelectMovePoint = -32;      
    //     } else if ((USMDataWindow[CurUSMDataWindow].EndNum < ValidNum) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum)  == 2)) {
    //         USMTextMovePoint = 32;
    //         USMDataWindow[CurUSMDataWindow].StartNum++;
    //         USMDataWindow[CurUSMDataWindow].CurNum++;   
    //         USMDataWindow[CurUSMDataWindow].EndNum++;
    //     } else if (USMDataWindow[CurUSMDataWindow].CurNum == ValidNum) {
    //         CalcUSMDataWindow(CurUSMDataWindow, CurUSM, 0, 0, 0);
    //         USMSelectMovePoint = 0;
    //         USMTextMovePoint = 0;
    //     } else if (USMDataWindow[CurUSMDataWindow].EndNum == ValidNum) {
    //         if (USMDataWindow[CurUSMDataWindow].CurNum < USMDataWindow[CurUSMDataWindow].EndNum) {
    //             USMDataWindow[CurUSMDataWindow].CurNum++;
    //             USMSelectMovePoint = -32; 
    //         }
    //     }
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
    
    // if (op == 2) { //-
    //     if ((USMDataWindow[CurUSMDataWindow].StartNum > 0) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum) > 1)) {
    //         USMDataWindow[CurUSMDataWindow].CurNum--;   
    //         USMSelectMovePoint = 32;
    //     } else if ((USMDataWindow[CurUSMDataWindow].StartNum > 0) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum)  == 1)) {
    //         USMTextMovePoint = -32;
    //         USMDataWindow[CurUSMDataWindow].StartNum--;
    //         USMDataWindow[CurUSMDataWindow].CurNum--;   
    //         USMDataWindow[CurUSMDataWindow].EndNum--;
    //     } else if (USMDataWindow[CurUSMDataWindow].CurNum == 0) {
    //         CalcUSMDataWindow(CurUSMDataWindow, CurUSM, 0, 255, 255);
    //     } else if (USMDataWindow[CurUSMDataWindow].StartNum == 0) {
    //         if (USMDataWindow[CurUSMDataWindow].CurNum > USMDataWindow[CurUSMDataWindow].StartNum) {
    //             USMDataWindow[CurUSMDataWindow].CurNum--;
    //             USMSelectMovePoint = 32;
    //         }
    //     }      
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
}


void CalcUSMDataWindow_ServiceInterval(uint8_t CurUSMDataWindow, CUR_USM_PARA *CurUSM, uint8_t op, uint8_t start, uint8_t cur)   //0:init   1:+   2:-
{
    // uint8_t i;
    // uint8_t ValidNum = 0;
    // uint8_t ItemNum = 0;
    // for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) {
    //     if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) {
    //         ValidNum++;
    //     }
    // }
    // if (ValidNum)
    //     ValidNum--;
    
    // if (op == 0) {
    //     if (ValidNum > 2) {
    //         if ((start < ValidNum) && ((start + 2) < ValidNum))
    //             USMDataWindow[CurUSMDataWindow].StartNum = start;
    //         else
    //             USMDataWindow[CurUSMDataWindow].StartNum = ValidNum - 2;
    //         if ((cur < ValidNum) && ((cur + 2) <= ValidNum))
    //             USMDataWindow[CurUSMDataWindow].CurNum = cur;
    //         else
    //             USMDataWindow[CurUSMDataWindow].CurNum = ValidNum;
    //         USMDataWindow[CurUSMDataWindow].EndNum = USMDataWindow[CurUSMDataWindow].StartNum + 2;
    //     } else {
    //         USMDataWindow[CurUSMDataWindow].StartNum = 0;
    //         if (cur < ValidNum)
    //             USMDataWindow[CurUSMDataWindow].CurNum = cur;
    //         else 
    //             USMDataWindow[CurUSMDataWindow].CurNum = ValidNum;
    //         USMDataWindow[CurUSMDataWindow].EndNum = USMDataWindow[CurUSMDataWindow].StartNum + ValidNum;
    //     }
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {//Чǰ˵ѡ+1
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
    
    // if (op == 1) {  //+
    //     if ((USMDataWindow[CurUSMDataWindow].EndNum < ValidNum) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum) < 1)) {
    //         USMDataWindow[CurUSMDataWindow].CurNum++;  
    //         USMSelectMovePoint = -32;      
    //     } else if ((USMDataWindow[CurUSMDataWindow].EndNum < ValidNum) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum)  == 1)) {
    //         USMTextMovePoint = 32;
    //         USMDataWindow[CurUSMDataWindow].StartNum++;
    //         USMDataWindow[CurUSMDataWindow].CurNum++;   
    //         USMDataWindow[CurUSMDataWindow].EndNum++;
    //     } else if (USMDataWindow[CurUSMDataWindow].CurNum == ValidNum) {
    //         CalcUSMDataWindow_ServiceInterval(CurUSMDataWindow, CurUSM, 0, 0, 0);
    //         USMSelectMovePoint = 0;
    //         USMTextMovePoint = 0;
    //     } else if (USMDataWindow[CurUSMDataWindow].EndNum == ValidNum) {
    //         if (USMDataWindow[CurUSMDataWindow].CurNum < USMDataWindow[CurUSMDataWindow].EndNum) {
    //             USMDataWindow[CurUSMDataWindow].CurNum++;
    //             USMSelectMovePoint = -32; 
    //         }
    //     }
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
    
    // if (op == 2) { //-
    //     if ((USMDataWindow[CurUSMDataWindow].StartNum > 0) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum) > 1)) {
    //         USMDataWindow[CurUSMDataWindow].CurNum--;   
    //         USMSelectMovePoint = 32;
    //     } else if ((USMDataWindow[CurUSMDataWindow].StartNum > 0) && ((USMDataWindow[CurUSMDataWindow].CurNum - USMDataWindow[CurUSMDataWindow].StartNum)  == 1)) {
    //         USMTextMovePoint = -32;
    //         USMDataWindow[CurUSMDataWindow].StartNum--;
    //         USMDataWindow[CurUSMDataWindow].CurNum--;   
    //         USMDataWindow[CurUSMDataWindow].EndNum--;
    //     } else if (USMDataWindow[CurUSMDataWindow].CurNum == 0) {
    //         CalcUSMDataWindow_ServiceInterval(CurUSMDataWindow, CurUSM, 0, 255, 255);
    //     } else if (USMDataWindow[CurUSMDataWindow].StartNum == 0) {
    //         if (USMDataWindow[CurUSMDataWindow].CurNum > USMDataWindow[CurUSMDataWindow].StartNum) {
    //             USMDataWindow[CurUSMDataWindow].CurNum--;
    //             USMSelectMovePoint = 32;
    //         }
    //     }      
    //     GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow] = USMDataWindow[CurUSMDataWindow].CurNum;
    //     for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    //     {
    //         if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //         {
    //             ItemNum++;
    //             if(CurUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[CurUSMDataWindow].CurNum)
    //             {
    //                 GroupTabPara.GroupTabUSM.CurDepthSelect[CurUSMDataWindow]++;
    //             }
    //         }
    //     }
    // }
}

void USMChange(uint8_t CurDepth, uint8_t DestUSM, uint8_t op)
{
    // uint8_t i = 1;
    // if (CurDepth < 3) 
    // {
    //     LastUSM = CurUSM;
    //     LastUSMTransitionTime = LAST_USM_TRANSITION_TIME_MAX;
    //     CurUSM = DestUSM;
    //     USMOp = op;
    //     GroupTabPara.GroupTabUSM.LastDepth = GroupTabPara.GroupTabUSM.CurDepth;
    //     if (op == USM_OP_FORWARD) 
    //     {
    //         GroupTabPara.GroupTabUSM.CurDepth++;
    //         if (CurDepth < 2) 
    //         {
    //             GroupTabPara.GroupTabUSM.CurDepthSelect[CurDepth] |= GroupTabPara.GroupTabUSM.CurDepthSelect[CurDepth] << 4; 
    //             GroupTabPara.GroupTabUSM.CurDepthSelect[CurDepth + 1] = 1;
    //         }
    //         if(CurUSM != USM_DEPTH2_SERVICEINTERVAL)
    //         {
    //             CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 1);
    //             while(CheckUSMDisabled(&CurUSMPara[CurUSM], GroupTabPara.GroupTabUSM.CurDepth))
    //             {
    //                 i++;
    //                 CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, i);
    //                 USMSelectMovePoint = 0;
    //                 USMTextMovePoint = 0;
    //             }
    //         }
    //         else
    //         {
    //             CalcUSMDataWindow_ServiceInterval(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 1);
    //             while(CheckUSMDisabled(&CurUSMPara[CurUSM], GroupTabPara.GroupTabUSM.CurDepth))
    //             {
    //                 i++;
    //                 CalcUSMDataWindow_ServiceInterval(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, i);
    //                 USMSelectMovePoint = 0;
    //                 USMTextMovePoint = 0;
    //             }
    //         }
    //     } 
    //     else if (op == USM_OP_BACKWARD) 
    //     {
    //         GroupTabPara.GroupTabUSM.CurDepth--;
    //         if (CurDepth > 0) 
    //         {
    //             GroupTabPara.GroupTabUSM.CurDepthSelect[CurDepth - 1] &= ~0xf0;
    //         }
    //         if(CurUSMPara[DestUSM].CurUSMValidNum < 4 && USMDataWindow[GroupTabPara.GroupTabUSM.CurDepth].EndNum < CurUSMPara[DestUSM].CurUSMValidNum)
    //         {
    //             USMDataWindow[GroupTabPara.GroupTabUSM.CurDepth].EndNum = CurUSMPara[DestUSM].CurUSMValidNum;
    //         }
    //     }
    // }
}

void DisplayUSMTransitionPic(CENTER_AREA_DISPLAY_ITEM *DisplayItem, int16_t Xoffset)
{

}


static void SideWayPro(uint16_t length, uint32_t Pic)
{

}

uint8_t SearchUSMHelp(CUR_USM_PARA *CurUSM, uint8_t DataWindow)
{
    uint8_t n = 0;
    uint8_t ValidNum = 0;
    uint8_t i = 0;
    
    for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    {
        if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) 
        {
            ValidNum++;
            n = ValidNum - 1;
            if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Pic.HelpPic != 0)
            {
                return 1;
            }
        }
    }
    return 0;
}
uint8_t Flag_USMParkStep = 0;

void USMParkPro(uint8_t Key)
{}

void UpdataUSMPark(void)
{}

void UpdataUSMServiceReset(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_USM;
    
    if(Flag_ServiceReset == 1)
    {
        if (UsmSelfPara.Language == CHINESE) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Reset_Title_Word0, 14, 82, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word0, 100, 162, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word0, 100, 196, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == ENGLISH) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Reset_Title_Word2_X26_Y91, 26, 91, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word2, 100, 162, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word2, 100, 196, DRAW_ICON);
        } 
        else if (UsmSelfPara.Language == KOREAN) 
        {
            SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Reset_Title_Word1_X26_Y91, 26, 91, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word1, 100, 162, DRAW_ICON);
            SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word1_X90_Y198, 90, 198, DRAW_ICON);
        } 
        SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        //SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word0, 100, 162, DRAW_ICON);
        SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        //SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word0, 100, 196, DRAW_ICON);
        SET_DISPLAY_STATIC_ITEM_WINDOW(2, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        
        if(ServiceResetSetNum == 0)
        {
            SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 162 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
            SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        }
        else
        {
            SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 196 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
            SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        }
        SetCenterAreaDisplayList(&DisplayItem, 0);
    }
}

void UpdataUSMReset(void)
{
    // CENTER_AREA_DISPLAY_ITEM DisplayItem;
    // memset(&DisplayItem, 0, sizeof (DisplayItem));
    // DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_USM;
    
    // if(Flag_Reset == 1 && Flag_Reset_OK == 0 && Flag_Reset_Cancel == 0)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu2_Reset_Title_Word0, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word0, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word0, 100, 196, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu2_Reset_Title_Word2_X26_Y91, 26, 91, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word2, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word2, 100, 196, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu2_Reset_Title_Word1_X26_Y91, 26, 91, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word1, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word1_X90_Y198, 90, 198, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);       
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);       
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(2, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        
    //     if(ResetSetNum == 0)
    //     {
    //         SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 162 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
    //         SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     }
    //     else
    //     {
    //         SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 196 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
    //         SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     }
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
    // else if(Flag_Reset_OK == 1)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_01_Word0, 14, 148, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_01_Word2_X15_Y136, 15, 136, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_01_Word1_X15_Y136, 15, 136, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
    // else if(Flag_Reset_Cancel == 1)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_02_Word0, 14, 148, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_02_Word2_X15_Y136, 15, 136, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_Reset_02_Word1_X15_Y136, 15, 136, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
}

void UpdataUSMServiceIntervalSetting(void)
{
    // CENTER_AREA_DISPLAY_ITEM DisplayItem;
    // memset(&DisplayItem, 0, sizeof (DisplayItem));
    // DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_USM;
    
    // if(ServicePara.Flag_Confirm == 0 && ServicePara.Flag_OK == 0 && ServicePara.Flag_Cancel == 0)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_ServiceInterval_AdjustInterval_Title_Word0, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu3_ServiceInterval_AdjustInterval_01_Word0, 123, 139, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_ServiceInterval_AdjustInterval_Title_Word2, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu3_ServiceInterval_AdjustInterval_01_Word2, 123, 139, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu3_ServiceInterval_AdjustInterval_Title_Word1, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu3_ServiceInterval_AdjustInterval_01_Word1, 123, 139, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        
    //     //λ
    //     SET_DISPLAY_DYNC_ITEM(0, Number36List[ServicePara.SetTempKm / 10000], ServiceNumberCoordinate[0][0], ServiceNumberCoordinate[0][1], DRAW_ICON);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     //ǧλ
    //     SET_DISPLAY_DYNC_ITEM(1, Number36List[ServicePara.SetTempKm % 10000 / 1000], ServiceNumberCoordinate[1][0], ServiceNumberCoordinate[1][1], DRAW_ICON);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     //λ
    //     SET_DISPLAY_DYNC_ITEM(2, Number36List[ServicePara.SetTempKm % 1000 / 100], ServiceNumberCoordinate[2][0], ServiceNumberCoordinate[2][1], DRAW_ICON);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        
    //     //·ݣʮλ
    //     SET_DISPLAY_DYNC_ITEM(3, Number36List[ServicePara.SetTempMonth / 10], ServiceNumberCoordinate[3][0], ServiceNumberCoordinate[3][1], DRAW_ICON);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(3, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        
    //     //·ݣλ
    //     SET_DISPLAY_DYNC_ITEM(4, Number36List[ServicePara.SetTempMonth % 10], ServiceNumberCoordinate[4][0], ServiceNumberCoordinate[4][1], DRAW_ICON);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(4, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        
    //     SET_DISPLAY_DYNC_ITEM(5, Set_Menu3_ServiceInterval_AdjustInterval_image, ServiceImageCoordinate[ServicePara.SetBit][0], ServiceImageCoordinate[ServicePara.SetBit][1], DRAW_MIM_ALPHA_ICON_WINDOW);
    //     SET_DISPLAY_DYNC_ITEM_WINDOW(5, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
        
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
    // else if(ServicePara.Flag_Confirm == 1)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_Title_Word0, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word0, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word0, 100, 196, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_Title_Word2, 14, 82, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word2, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word2, 100, 196, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_Title_Word1_X26_Y91, 26, 91, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(1, Set_Menu2_Reset_01_Word1, 100, 162, DRAW_ICON);
    //         SET_DISPLAY_STATIC_ITEM(2, Set_Menu2_Reset_02_Word1_X90_Y198, 90, 198, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y); 
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(2, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        
    //     if(ServicePara.SetNum == 0)
    //     {
    //         SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 162 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
    //         SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     }
    //     else
    //     {
    //         SET_DISPLAY_DYNC_ITEM(0, Set_Current_02, 68, 196 + USMSelectMovePoint, DRAW_MIM_ALPHA_ICON_WINDOW);
    //         SET_DISPLAY_DYNC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, MID_BOTTOM_Y);
    //     }
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
    // else if(ServicePara.Flag_OK == 1)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_01_Word0, 14, 148, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_01_Word2_X15_Y136, 15, 136, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_01_Word1_X15_Y136, 15, 136, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
    // else if(ServicePara.Flag_Cancel == 1)
    // {
    //     if (UsmSelfPara.Language == CHINESE) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_02_Word0, 14, 148, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == ENGLISH) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_02_Word2_X15_Y136, 15, 136, DRAW_ICON);
    //     } 
    //     else if (UsmSelfPara.Language == KOREAN) 
    //     {
    //         SET_DISPLAY_STATIC_ITEM(0, Set_Menu4_ServiceInterval_AdjustInterval_Save_02_Word1_X15_Y136, 15, 136, DRAW_ICON);
    //     }
        
    //     SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    //     SetCenterAreaDisplayList(&DisplayItem, 0);
    // }
} 

void USMHelpInit(CUR_USM_PARA *CurUSM, uint8_t DataWindow)
{
    uint8_t n = 0;
    uint8_t ValidNum = 0;
    uint8_t i = 0;
    
    for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    {
        if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) 
        {
            ValidNum++;
            n = ValidNum - 1;
            if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Pic.HelpPic != 0)
            {
                USMHelpPara.HelpPic = CurUSM->pCurUSM[i + 1].Pic.HelpPic;
                USMHelpPara.TotalHelpLine = CurUSM->pCurUSM[i + 1].HelpLine;
                USMHelpPara.HelpTitleLine = CurUSM->pCurUSM[i + 1].HelpTitleLine;
                USMHelpPara.CurHelpLine = 5;
                USMHelpPara.EveryOffsetPixel = 27;
                USMHelpPara.OffsetStep = 0;
                Flag_USM_Help = 1;
                return;
            }
        }
    }
    return;
}

void USMHelpPro(uint8_t Key)
{
    switch(Key)
    {
    case TRIP_SW1_CUR_UP:
        if(USMHelpPara.TotalHelpLine <= USMHelpPara.CurHelpLine)
        {//Ҫ
            Flag_USM_Help = 0;
        }
        else
        {
            if(USMHelpPara.OffsetStep == 0)
            {
                USMHelpPara.OffsetStep = USMHelpPara.TotalHelpLine - USMHelpPara.CurHelpLine;
            }
            else
            {
                USMHelpPara.OffsetStep--;
            }
        }
        USM_Help_Count = 0;
        break;
    case TRIP_SW1_CUR_DOWN:
        if(USMHelpPara.TotalHelpLine <= USMHelpPara.CurHelpLine)
        {//Ҫ
            Flag_USM_Help = 0;
        }
        else
        {
            if(USMHelpPara.OffsetStep == USMHelpPara.TotalHelpLine - USMHelpPara.CurHelpLine)
            {
                USMHelpPara.OffsetStep = 0;
            }
            else
            {
                USMHelpPara.OffsetStep++;
            }
        }
        USM_Help_Count = 0;
        break;
    default:
        Flag_USM_Help = 0;
        break;
    }
}

void UpdateUSMHelp(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_USM;
           
    SET_DISPLAY_STATIC_ITEM(0, USMHelpPara.HelpPic, 26, 88 - USMHelpPara.EveryOffsetPixel * USMHelpPara.OffsetStep, DRAW_ICON);
    if(USMHelpPara.OffsetStep >= USMHelpPara.HelpTitleLine)
    {
        SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, USM_HELP_TOP_Y + 12, USM_HELP_BOTTOM_Y);
    }
    else
    {
        SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, RIGHT_X_END, USM_HELP_TOP_Y, USM_HELP_BOTTOM_Y);
    }
    SetCenterAreaDisplayList(&DisplayItem, 0);
    
}

void USMHelpRightBarPro(void)
{
    int16_t EachItemHigh = 0;
    int16_t ScaollTopY = 0;
    int16_t ScaollBottomY = 0;
    if(USMHelpPara.TotalHelpLine <= USMHelpPara.CurHelpLine)
    {
        return;
    }
    else
    {
        SET_DRAW_INFO(223, 91, Set_Scroll_01_Gray_X223_Y91, 0, 0);
        GUI_DrawDispFunc(0, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            
        EachItemHigh = 138 / USMHelpPara.TotalHelpLine;  //ÿһڹռõص
        ScaollTopY = 91 + EachItemHigh * (USMHelpPara.OffsetStep);
        if(USMHelpPara.OffsetStep + 5 == USMHelpPara.TotalHelpLine)
        {
            ScaollBottomY = 91 + 138;
        }
        else
        {
            ScaollBottomY = 91 + EachItemHigh * (USMHelpPara.OffsetStep + 5);
        }
        
        SET_DRAW_INFO(223, 91, Set_Scroll_01_White_X223_Y91, 0, 0);
        GUI_DrawDispFunc(0, LEFT_X_START, RIGHT_X_END, ScaollTopY, ScaollBottomY);
    }
}
 
void UpdateUSMItem(CUR_USM_PARA *CurrentUSM, uint8_t DataWindow)
{
    // uint8_t i = 0;
    // uint8_t tmp = 0xff;
    // uint8_t ItemNum = 0;
    // uint8_t ValidNum = 0;
    
    // for (i = 1; i < (CurrentUSM->CurUSMMaxItem - 1); i++)
    // {//в˵ͷ
    //     if (CurrentUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurrentUSM->pCurUSM[i + 1].Invalid != 1) 
    //     {
    //         ValidNum++;
    //     }
    // }
    
    // if(ValidNum == 0)//ȫЧһ㣬ٴж
    // {
    //     tmp = FindUSMID(USM_OP_BACKWARD);
    //     if (tmp != 0xff) 
    //     {
    //         Flag_USM_InvalidJump = 1;   //ʾǿƷϼҪԲ˵³ʼ
    //         LastUSM = CurUSM;
    //         CurUSM = tmp;
    //         GroupTabPara.GroupTabUSM.LastDepth = GroupTabPara.GroupTabUSM.CurDepth;
    //         if (GroupTabPara.GroupTabUSM.CurDepth > 0) {
    //             GroupTabPara.GroupTabUSM.CurDepthSelect[GroupTabPara.GroupTabUSM.CurDepth] = 0x00;
    //         }
    //         GroupTabPara.GroupTabUSM.CurDepth--;
    //         UpdateUSMItem(&CurUSMPara[CurUSM], GroupTabPara.GroupTabUSM.CurDepth);
    //         return;
    //     }
    // }
    // if(Flag_USM_InvalidJump == 1)
    // {
    //     CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 0);
    //     Flag_USM_InvalidJump = 0;
    // }
    // CurrentUSM->CurUSMValidNum = ValidNum;
     
    // if(CurrentUSM->CurUSMValidNum != CurrentUSM->LastUSMValidNum)//Ч仯ƶǰ˵λ
    // {
    //     if(CurUSM == 0)//Ŀ¼
    //     {
    //         CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 0);
    //         i = 0;
    //     }
    //     else
    //     {
    //         if(CurUSM != USM_DEPTH2_SERVICEINTERVAL)
    //         {
    //             CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 0);
    //         }
    //         else
    //         {
    //             CalcUSMDataWindow_ServiceInterval(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, 0);
    //         }
    //         i = 1;
    //     }
    // }
    // CurrentUSM->LastUSMValidNum = CurrentUSM->CurUSMValidNum;
    
    // while(CheckUSMDisabled(&CurUSMPara[CurUSM], GroupTabPara.GroupTabUSM.CurDepth))
    // {
    //     i++;
    //     if(CurUSM != USM_DEPTH2_SERVICEINTERVAL)
    //     {
    //         CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, i);
    //     }
    //     else
    //     {
    //         CalcUSMDataWindow(GroupTabPara.GroupTabUSM.CurDepth, &CurUSMPara[CurUSM], 0, 0, i);
    //     }
    //     USMSelectMovePoint = 0;
    //     USMTextMovePoint = 0;
    // }
    
    // GroupTabPara.GroupTabUSM.CurDepthSelect[DataWindow] = USMDataWindow[DataWindow].CurNum;
    // for (i = 0; i < (CurrentUSM->CurUSMMaxItem - 1); i++) 
    // {
    //     if (CurrentUSM->pCurUSM[i + 1].Pic.WhitePic != 0) 
    //     {
    //         ItemNum++;
    //         if(CurrentUSM->pCurUSM[i + 1].Invalid == 1 && ItemNum - 1 <= USMDataWindow[DataWindow].CurNum)
    //         {//Чǰ˵ѡ+1
    //             GroupTabPara.GroupTabUSM.CurDepthSelect[DataWindow]++;
    //             ItemNum--;
    //         }
    //     }
    // }
}

uint8_t CheckUSMDisabled(CUR_USM_PARA *CurUSM, uint8_t DataWindow)
{
    uint8_t i = 0;
    uint8_t n = 0;
    uint8_t ValidNum = 0;
    for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    {
        if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) 
        {
            ValidNum++;
            n = ValidNum - 1;
            if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Disabled != 0)
            {
                return 1;
            }
        }
    }
    return 0;
}

static uint8_t CalDataLen(uint32_t data)
{
    uint8_t len = one;
    
    if (data / 10 > null)
        len = 2;
    if (data / 100 > null)
        len = 3;
    if (data / 1000 > null)
        len = 4;
    if (data / 10000 > null)
        len = 5;
    if (data / 100000 > null)
        len = 6;
    return len;
}

void UpdateUSM(CUR_USM_PARA *CurUSM, uint8_t DataWindow, uint8_t Transition, int16_t TransitionXOffset)
{
    int16_t CurSelectTargetX;
    int16_t CurSelectTargetY;
    int16_t ItemTargetX;
    int16_t ItemTargetY;
    int16_t ArrowOrBoxTargetX;
    int16_t ArrowOrBoxTargetY;
    uint8_t ValidNum = 0;
    uint16_t DefStartTime = 0;
    int i;
    uint8_t n;
    uint16_t EachItemHigh = 0;
    int16_t ScaollTopY = 0;
    int16_t ScaollBottomY = 0;
    
    uint8_t KmLen = 0;    
    uint8_t DayLen = 0;
    int DisplayKm = 0;
    int DisplayDay = 0;
    uint16_t AllLen = 0;
    int16_t KmPos = 0;
    int16_t DayPos = 0;
    int16_t WindowButtom = 0;
    
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_USM;
    
    if(CurUSM != &CurUSMPara[USM_DEPTH2_SERVICEINTERVAL])
    {
        WindowButtom = MID_BOTTOM_Y;
    }
    else
    {
        WindowButtom = 208;
    }
        
    SET_DISPLAY_STATIC_ITEM(0, CurUSM->pCurUSM[0].Pic.WhitePic, TitleCoordinate[0], TitleCoordinate[1], DRAW_ICON);
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, WindowButtom);
    ValidNum = 0;
    for (i = 0; i < (CurUSM->CurUSMMaxItem - 1); i++) 
    {
        if (CurUSM->pCurUSM[i + 1].Pic.WhitePic != 0 && CurUSM->pCurUSM[i + 1].Invalid != 1) 
        {
            ValidNum++;
            n = ValidNum - 1;
            if (USMTextMovePoint == 0) 
            {
                if ((n >= USMDataWindow[DataWindow].StartNum) && (n <= USMDataWindow[DataWindow].EndNum)) 
                {
                    if(CurUSM->pCurUSM[i + 1].Disabled == 1)
                    {
                        ItemTargetX = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                        ItemTargetY = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1];
                        SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.GrayPic, ItemTargetX, ItemTargetY, DRAW_ICON);
                        SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                    }
                    else if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Pic.AllPic != 0)
                    {//
                        SideWayPro(CurUSM->pCurUSM[i + 1].ALL_Length, CurUSM->pCurUSM[i + 1].Pic.AllPic);
                        ItemTargetX = 14 - Sideway_Offset;
                        ItemTargetY = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1];
                        SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.AllPic, ItemTargetX, ItemTargetY, DRAW_ICON);
                        SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, 20, 192, MID_USM_TOP_Y, WindowButtom);
                    }
                    else
                    {
                        ItemTargetX = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                        ItemTargetY = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1];
                        SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.WhitePic, ItemTargetX, ItemTargetY, DRAW_ICON);
                        SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                    }
                    if(n == USMDataWindow[DataWindow].CurNum && CurUSM->pCurUSM[i + 1].Pic.AllPic == 0)
                    {
                        Sideway_Count = 0;
                        Sideway_TimeFlag = 0;
                        Sideway_30MsFlag = 0;
                        Sideway_Offset = 0;
                    }
                    ArrowOrBoxTargetX = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                    ArrowOrBoxTargetY = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1];
                    
                    if(CurUSM->pCurUSM[i + 1].Disabled != 1)
                    {
                        if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_Arrow_NextLevel_White, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        } 
                        else if (CurUSM->pCurUSM[i + 1].Type == USM_TIEM_TYPE_CHECK_BOX) 
                        {
                            if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                            {
                                SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_CheckBoxOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            }
                            else
                            {
                                SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_CheckBox, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            }
                        } 
                        else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_RADIO_BOX) 
                        {
                            if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                            {
                                SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_RadioButtonOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            }
                            else
                            {
                                SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_RadioButton, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            }
                        }
                    }
                    else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                    {
                        SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_Arrow_NextLevel_Gray, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                        SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                    }
                }
            } 
            else 
            {
                if (USMTextMovePoint > 0) 
                {
                    if ((n >= (USMDataWindow[DataWindow].StartNum - 1)) && (n <= USMDataWindow[DataWindow].EndNum)) 
                    {
                        if (n < USMDataWindow[DataWindow].EndNum) 
                        {
                            ItemTargetX = ItemCoordinate[n - (USMDataWindow[DataWindow].StartNum - 1)][0];
                            ItemTargetY = ItemCoordinate[n - (USMDataWindow[DataWindow].StartNum - 1)][1] - 32 + USMTextMovePoint;
                            ArrowOrBoxTargetX = RightItemCoordinate[n - (USMDataWindow[DataWindow].StartNum - 1)][0];
                            ArrowOrBoxTargetY = RightItemCoordinate[n - (USMDataWindow[DataWindow].StartNum - 1)][1] - 32 + USMTextMovePoint;
                        } 
                        else 
                        {
                            ItemTargetX = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                            ItemTargetY = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1] + USMTextMovePoint;
                            ArrowOrBoxTargetX = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                            ArrowOrBoxTargetY = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1] + USMTextMovePoint;
                        }
                        if(CurUSM->pCurUSM[i + 1].Disabled == 1)
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.GrayPic, ItemTargetX, ItemTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                        else 
                        {
                            SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2, CurUSM->pCurUSM[i + 1].Pic.WhitePic, ItemTargetX, ItemTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                        if(CurUSM->pCurUSM[i + 1].Disabled != 1)
                        {
                            if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                            {
                                SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, Set_Arrow_NextLevel_White, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            } 
                            else if (CurUSM->pCurUSM[i + 1].Type == USM_TIEM_TYPE_CHECK_BOX) 
                            {
                                if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, Set_CheckBoxOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                                else
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, Set_CheckBox, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                            } 
                            else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_RADIO_BOX) 
                            {
                                if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, Set_RadioButtonOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                                else
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, Set_RadioButton, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - (USMDataWindow[DataWindow].StartNum - 1)) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                            }
                        }
                        else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_Arrow_NextLevel_Gray, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                    }
                } 
                else if (USMTextMovePoint < 0) 
                {
                    if ((n >= USMDataWindow[DataWindow].StartNum) && (n <= (USMDataWindow[DataWindow].EndNum + 1))) 
                    {
                        if (n <= USMDataWindow[DataWindow].EndNum) 
                        {
                            ItemTargetX = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                            ItemTargetY = ItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1] + USMTextMovePoint;
                            ArrowOrBoxTargetX = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][0];
                            ArrowOrBoxTargetY = RightItemCoordinate[n - USMDataWindow[DataWindow].StartNum][1] + USMTextMovePoint;
                        } else {
                            ItemTargetX = ItemCoordinate[n - 1 - USMDataWindow[DataWindow].StartNum][0];
                            ItemTargetY = ItemCoordinate[n - 1 - USMDataWindow[DataWindow].StartNum][1] + 32 + USMTextMovePoint;
                            ArrowOrBoxTargetX = RightItemCoordinate[n - 1 - USMDataWindow[DataWindow].StartNum][0];
                            ArrowOrBoxTargetY = RightItemCoordinate[n - 1 - USMDataWindow[DataWindow].StartNum][1] + 32 + USMTextMovePoint;
                        }
                        if(CurUSM->pCurUSM[i + 1].Disabled == 1)
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.GrayPic, ItemTargetX, ItemTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                        else 
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2, CurUSM->pCurUSM[i + 1].Pic.WhitePic, ItemTargetX, ItemTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                        if(CurUSM->pCurUSM[i + 1].Disabled != 1)
                        {
                            if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                            {
                                SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_Arrow_NextLevel_White, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                            } 
                            else if (CurUSM->pCurUSM[i + 1].Type == USM_TIEM_TYPE_CHECK_BOX) 
                            {
                                if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_CheckBoxOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                                else
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_CheckBox, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                            } 
                            else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_RADIO_BOX) 
                            {
                                if(CurUSM->pCurUSM[i + 1].Attribute == 1)
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_RadioButtonOK, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                                else
                                {
                                    SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_RadioButton, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                                    SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                                }
                            }
                        }
                        else if (CurUSM->pCurUSM[i + 1].Type == USM_ITEM_TYPE_ARROW) 
                        {
                            SET_DISPLAY_DYNC_ITEM((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, Set_Arrow_NextLevel_Gray, ArrowOrBoxTargetX, ArrowOrBoxTargetY, DRAW_ICON);
                            SET_DISPLAY_DYNC_ITEM_WINDOW((n - USMDataWindow[DataWindow].StartNum) * 2 + 1, LEFT_X_START, MID_X_RIGHT, MID_USM_TOP_Y, WindowButtom);
                        }
                    }
                }
            }
        }
    }  
    CurSelectTargetX = CurSelectCoordinate[USMDataWindow[DataWindow].CurNum - USMDataWindow[DataWindow].StartNum][0];
    CurSelectTargetY = CurSelectCoordinate[USMDataWindow[DataWindow].CurNum - USMDataWindow[DataWindow].StartNum][1] + USMSelectMovePoint;
    SET_DISPLAY_DYNC_ITEM((n + 1)* 2, Set_Current_01, CurSelectTargetX, CurSelectTargetY, DRAW_MIM_ALPHA_ICON_WINDOW);
    SET_DISPLAY_DYNC_ITEM_WINDOW((n + 1)* 2, LEFT_X_START, MID_X_RIGHT, MID_TOP_Y, WindowButtom);
    
    if(CurUSM != &CurUSMPara[USM_DEPTH2_SERVICEINTERVAL])
    {
        if ((ValidNum > 4))// && (Transition == 0)) 
        {
            SET_DISPLAY_DYNC_ITEM((n + 1)* 2 + 1, Set_Scroll_02_Gray_X223_Y117, 223, 117, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM_WINDOW((n + 1)* 2 + 1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, WindowButtom);
            
            EachItemHigh = 120 / ValidNum;//ÿһ˵ڹռõص
            SET_DISPLAY_DYNC_ITEM((n + 1)* 2 + 2, Set_Scroll_02_White_X223_Y117, 223, 117, DRAW_ICON);
            ScaollTopY = 117 + EachItemHigh * (USMDataWindow[DataWindow].StartNum);
            ScaollBottomY = 117 + EachItemHigh * (USMDataWindow[DataWindow].StartNum + 4);
            SET_DISPLAY_DYNC_ITEM_WINDOW((n + 1)* 2 + 2, LEFT_X_START, RIGHT_X_END, ScaollTopY, ScaollBottomY);
        }
    }
    else
    {
        //˵̺ʾ
        n = (n + 1)* 2 + 1;
        if(ServicePara.RemainKm != 0 || ServicePara.RemainDay != 0)
        {
            if(ServicePara.RemainKm != 0 && ServicePara.RemainDay != 0)
            {
                if(ServicePara.RemainKm > 0)
                {
                    DisplayKm = ServicePara.RemainKm;
                    KmLen = CalDataLen(DisplayKm);
                }
                else
                {
                    DisplayKm = abs(ServicePara.RemainKm);
                    KmLen = CalDataLen(DisplayKm) + 1;
                }
                if(ServicePara.RemainDay > 0)
                {
                    DisplayDay = ServicePara.RemainDay;
                    DayLen = CalDataLen(DisplayDay);
                }
                else
                {
                    DisplayDay = abs(ServicePara.RemainDay);
                    DayLen = CalDataLen(DisplayDay) + 1;
                }
                AllLen = (KmLen + DayLen) * 12 + 36 + 16;
                if(AllLen >= 240)
                {
                    AllLen = 240;
                }
                KmPos = 120 - (AllLen / 2) + (KmLen * 12) - 3;
                DayPos = 120 + (AllLen / 2) - 16;
            }
            else if(ServicePara.RemainKm != 0 && ServicePara.RemainDay == 0)
            {
                if(ServicePara.RemainKm > 0)
                {
                    DisplayKm = ServicePara.RemainKm;
                    KmLen = CalDataLen(DisplayKm);
                }
                else
                {
                    DisplayKm = abs(ServicePara.RemainKm);
                    KmLen = CalDataLen(DisplayKm) + 1;
                }
                DayLen = 0; 
                AllLen = KmLen * 12 + 22;
                if(AllLen >= 240)
                {
                    AllLen = 240;
                }
                KmPos = 120 - (AllLen / 2) + (KmLen * 12) - 3;
                DayPos = 800;
            }
            else if(ServicePara.RemainKm == 0 && ServicePara.RemainDay != 0)
            {
                KmLen = 0;
                if(ServicePara.RemainDay > 0)
                {
                    DisplayDay = ServicePara.RemainDay;
                    DayLen = CalDataLen(DisplayDay);
                }
                else
                {
                    DisplayDay = abs(ServicePara.RemainDay);
                    DayLen = CalDataLen(DisplayDay) + 1;
                }
                AllLen = DayLen * 12 + 16;
                if(AllLen >= 240)
                {
                    AllLen = 240;
                }
                KmPos = 800;
                DayPos = 120 + (AllLen / 2) - 16;
            }
            if(ServicePara.RemainKm < 0)
            {
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n, Number_25_White_Line, KmPos - KmLen * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n, Number_25_Gray_Line, KmPos - KmLen * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
                KmLen--;
            }
            switch(KmLen)
            {
            case 5:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 1, Number25List[(DisplayKm / 10000) % 10], KmPos - 5 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 1, Number25GrayList[(DisplayKm / 10000) % 10], KmPos - 5 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 1, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 4:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 2, Number25List[(DisplayKm / 1000) % 10], KmPos - 4 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 2, Number25GrayList[(DisplayKm / 1000) % 10], KmPos - 4 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 2, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 3:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 3, Number25List[(DisplayKm / 100) % 10], KmPos - 3 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 3, Number25GrayList[(DisplayKm / 100) % 10], KmPos - 3 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 3, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 2:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 4, Number25List[(DisplayKm / 10) % 10], KmPos - 2 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 4, Number25GrayList[(DisplayKm / 10) % 10], KmPos - 2 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 4, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 1:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 5, Number25List[DisplayKm % 10], KmPos - 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 5, Number25GrayList[DisplayKm % 10], KmPos - 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 5, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            default:
                break;
            }
            if(ServicePara.RemainDay != 0)
            {
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 6, Set_Menu2_Service_Interval_Unit_km_02_White, KmPos + 3, 221, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 6, Set_Menu2_Service_Interval_Unit_km_02_Gray, KmPos + 3, 221, DRAW_ICON);
            }
            else
            {
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 6, Set_Menu2_Service_Interval_Unit_km_01_White, KmPos + 3, 221, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 6, Set_Menu2_Service_Interval_Unit_km_01_Gray, KmPos + 3, 221, DRAW_ICON);
            }
            SET_DISPLAY_DYNC_ITEM_WINDOW(n + 6, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            
            
            if(ServicePara.RemainDay < 0)
            {
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 7, Number_25_White_Line, DayPos - DayLen * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 7, Number_25_White_Line, DayPos - DayLen * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 7, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
                DayLen--;
            }
            switch(DayLen)
            {
            case 5:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 8, Number25List[(DisplayDay / 10000) % 10], DayPos - 5 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 8, Number25GrayList[(DisplayDay / 10000) % 10], DayPos - 5 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 8, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 4:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 9, Number25List[(DisplayDay / 1000) % 10], DayPos - 4 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 9, Number25GrayList[(DisplayDay / 1000) % 10], DayPos - 4 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 9, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 3:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 10, Number25List[(DisplayDay / 100) % 10], DayPos - 3 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 10, Number25GrayList[(DisplayDay / 100) % 10], DayPos - 3 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 10, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 2:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 11, Number25List[(DisplayDay / 10) % 10], DayPos - 2 * 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 11, Number25GrayList[(DisplayDay / 10) % 10], DayPos - 2 * 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 11, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            case 1:
                if(ServicePara.ServiceValid != 0)
                    SET_DISPLAY_DYNC_ITEM(n + 12, Number25List[DisplayDay % 10], DayPos - 12, 220, DRAW_ICON);
                else
                    SET_DISPLAY_DYNC_ITEM(n + 12, Number25GrayList[DisplayDay % 10], DayPos - 12, 220, DRAW_ICON);
                SET_DISPLAY_DYNC_ITEM_WINDOW(n + 12, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            default:
                break;
            }
            if(ServicePara.ServiceValid != 0)
                SET_DISPLAY_DYNC_ITEM(n + 13, Set_Menu2_Service_Interval_Unit_Day_White, DayPos + 4, 221, DRAW_ICON);
            else
                SET_DISPLAY_DYNC_ITEM(n + 13, Set_Menu2_Service_Interval_Unit_Day_Gray, DayPos + 4, 221, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM_WINDOW(n + 13, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
        }
        
        if ((ValidNum > 3))// && (Transition == 0)) 
        {   
            SET_DISPLAY_DYNC_ITEM(n + 14, Set_Scroll_03_Gray_X223_Y119, 223, 119, DRAW_ICON);
            SET_DISPLAY_DYNC_ITEM_WINDOW(n + 14, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
            
            EachItemHigh = 84 / ValidNum;//ÿһ˵ڹռõص
            SET_DISPLAY_DYNC_ITEM(n + 15, Set_Scroll_03_White_X223_Y119, 223, 119, DRAW_ICON);
            ScaollTopY = 119 + EachItemHigh * (USMDataWindow[DataWindow].StartNum);
            ScaollBottomY = 119 + EachItemHigh * (USMDataWindow[DataWindow].StartNum + 3);
            SET_DISPLAY_DYNC_ITEM_WINDOW(n + 15, LEFT_X_START, RIGHT_X_END, ScaollTopY, ScaollBottomY);
        }
        if(ServicePara.ServiceValid != SERVICE_REMAINDER_OFF)
            SET_DISPLAY_DYNC_ITEM(n + 16, Set_Menu2_Service_Interval_Line_White, 24, 209, DRAW_ICON);
        else
            SET_DISPLAY_DYNC_ITEM(n + 16, Set_Menu2_Service_Interval_Line_Gray, 24, 209, DRAW_ICON);
        SET_DISPLAY_DYNC_ITEM_WINDOW(n + 16, LEFT_X_START, RIGHT_X_END, MID_TOP_Y, MID_BOTTOM_Y);
    }
    
    //if (Transition == 0) {
        SetCenterAreaDisplayList(&DisplayItem, DefStartTime);
    //} else {
    //    DisplayUSMTransitionPic(&DisplayItem, TransitionXOffset);
    //}
} 

void USMOptionPro(void)
{
    uint8_t i = 0, j = 0;
    uint8_t ValidNum = 0;
    switch(Can1DataStruct.C_ADrLRValue)
    {//Զ
    case 0x01:
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Attribute      = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Attribute    = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Attribute         = 1;
        USMDepth2Door[USM_DOOR_AUTO_LOCK].Invalid = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Invalid        = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Invalid      = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Invalid           = 0;
        break;
    case 0x02:
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Attribute      = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Attribute    = 1;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Attribute         = 0;
        USMDepth2Door[USM_DOOR_AUTO_LOCK].Invalid = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Invalid        = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Invalid      = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Invalid           = 0;
        break;
    case 0x03:
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Attribute      = 1;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Attribute    = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Attribute         = 0;
        USMDepth2Door[USM_DOOR_AUTO_LOCK].Invalid = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Invalid        = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Invalid      = 0;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Invalid           = 0;
        break;
    default:
        USMDepth2Door[USM_DOOR_AUTO_LOCK].Invalid = 1;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Invalid        = 1;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Invalid      = 1;
        USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Invalid           = 1;
        break;
    }
    switch(Can1DataStruct.C_ADrURValue)
    {//Զ
    case 0x01:
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Attribute  = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Attribute            = 1;
        USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid                                = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Invalid    = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Invalid              = 0;
        break;
    case 0x02:
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Attribute  = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Attribute            = 0;
        USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid                                = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Invalid    = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Invalid              = 0;
        break;
    case 0x03:
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Attribute           = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Attribute  = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Attribute            = 0;
        USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid                                = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Invalid    = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Invalid              = 0;
        break;
    case 0x04:
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Attribute           = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Attribute           = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Attribute  = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Attribute            = 0;
        USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid                                = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Invalid             = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Invalid    = 0;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Invalid              = 0;
        break;
    default:
        USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid                                = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Invalid             = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Invalid             = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Invalid    = 1;
        USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Invalid              = 1;
        break;
    }
    if(Can1DataStruct.C_HfreeTrunkTgRValue == 0x01)
    {//
        USMDepth2Door[USM_DOOR_SMART_SUITCASE].Attribute  = 0;
        USMDepth2Door[USM_DOOR_SMART_SUITCASE].Invalid = 0;
    }
    else if(Can1DataStruct.C_HfreeTrunkTgRValue == 0x02)
    {
        USMDepth2Door[USM_DOOR_SMART_SUITCASE].Attribute  = 1;
        USMDepth2Door[USM_DOOR_SMART_SUITCASE].Invalid = 0;
    }
    else
    {
        USMDepth2Door[USM_DOOR_SMART_SUITCASE].Invalid = 1;
    }
    
    if(Can1DataStruct.C_WALRValue == 0x01)
    {//복ʱ
        USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid  = 0;
        USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Attribute  = 0;
    }
    else if(Can1DataStruct.C_WALRValue == 0x02)
    {
        USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid  = 0;
        USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Attribute  = 1;
    }
    else
    { 
        USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid  = 1;
    }
    
    if(USMDepth2Door[USM_DOOR_AUTO_LOCK].Invalid == 1
       && USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Invalid == 1
       && USMDepth2Door[USM_DOOR_SMART_SUITCASE].Invalid == 1
       && USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid == 1)
    {
        USMDepth1Para[USM_DOOR].Invalid = 1;
    }
    else
    {
        USMDepth1Para[USM_DOOR].Invalid = 0;
    }
    
    switch(Can1DataStruct.C_OTTurnRValue)
    {//һת
    case 0x01:
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Attribute       = 1;
        USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid  = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Invalid         = 0;
        break;
    case 0x02:
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Attribute     = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Attribute       = 0;
        USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid  = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Invalid         = 0;
        break;
    case 0x03:
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Attribute     = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Attribute       = 0;
        USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid  = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Invalid         = 0;
        break;
    case 0x04:
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Attribute     = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Attribute     = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Attribute       = 0;
        USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid  = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Invalid       = 0;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Invalid         = 0;
        break;
    default:
        USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid  = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Invalid       = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Invalid       = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Invalid       = 1;
        USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Invalid         = 1;
        break;
    }
    if(Can1DataStruct.C_EscortHLRValue == 0x01)
    {//ӳ
        USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Attribute  = 0;
        USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Invalid = 0;
    }
    else if(Can1DataStruct.C_EscortHLRValue == 0x02)
    {
        USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Attribute  = 1;
        USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Invalid = 0;
    }
    else
    {
        USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Invalid = 1;
    }
    
    if(USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Invalid == 1
       && USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Invalid == 1)
    {
        USMDepth1Para[USM_LIGHT].Invalid = 1;
    }
    else
    {
        USMDepth1Para[USM_LIGHT].Invalid = 0;
    }
    
    if(UsmSelfPara.Flag_WiperLight_Display == WIPER_LIGHT_OFF)
    {///ģʽʾ
        USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Attribute  = 0;
        USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Invalid = 0;
    }
    else if(UsmSelfPara.Flag_WiperLight_Display == WIPER_LIGHT_ON)
    {
        USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Attribute  = 1;
        USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Invalid = 0;
    }
    else
    {
        USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Invalid = 1;
    }
    
    if(Can1DataStruct.C_RearWiperRValue == 0x01)
    {//ʱԶ
        USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Attribute  = 0;
        USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Invalid = 0;
    }
    else if(Can1DataStruct.C_RearWiperRValue == 0x02)
    {
        USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Attribute  = 1;
        USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Invalid = 0;
    }
    else
    {
        USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Invalid = 1;
    }
    
    if(UsmSelfPara.Flag_GearPositionPopUp == GEAR_POPUP_OFF)
    {//лλʾ
        USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Attribute  = 0;
        USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Invalid = 0;
    }
    else if(UsmSelfPara.Flag_GearPositionPopUp == GEAR_POPUP_ON)
    {
        USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Attribute  = 1;
        USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Invalid = 0;
    }
    else
    {
        USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Invalid = 1;
    }
    
    if(Can1DataStruct.C_WPCRValue == 0x01)
    {//߳ϵͳ
        USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid = 0;
        USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Attribute  = 0;
    }
    else if(Can1DataStruct.C_WPCRValue == 0x02)
    {
        USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid = 0;
        USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Attribute  = 1;
    }
    else
    {
        USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid = 1;
    }
    
    if(USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Invalid == 1
       && USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Invalid == 1
       && USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Invalid == 1
       && USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid == 1)
    {
        USMDepth1Para[USM_CONVENIENCE].Invalid = 1;
    }
    else
    {
        USMDepth1Para[USM_CONVENIENCE].Invalid = 0;
    }
    
    if(ServicePara.ServiceTips != SERVICE_REMAINDER_OFF)
    {
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Attribute = 1;
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Disabled = 0;
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Disabled = 0;
    }
    else
    {
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Attribute = 0;
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Disabled = 1;
        USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Disabled = 1;
    }
    
    
    switch(Can0DataStruct.CF_Datc_TempDispUnit)
    {//¶ȵλ
    case 0x00:
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Attribute = 1;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Attribute = 0;
        USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Invalid                    = 0;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Invalid   = 0;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Invalid   = 0;
        break;
    case 0x01:
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Attribute = 0;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Attribute = 1;
        USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Invalid                    = 0;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Invalid   = 0;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Invalid   = 0;
        break;
    default:
        USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Invalid                    = 1;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Invalid   = 1;
        USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Invalid   = 1;
        break;
    }
    
    if(USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Invalid == 1
       && USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Invalid == 1)
    {
        USMDepth1Para[USM_OTHER].Invalid = 1;
    }
    else
    {
        USMDepth1Para[USM_OTHER].Invalid = 0;
    }
    
    switch(UsmSelfPara.Language)
    {///Language
    case CHINESE://
        USMDepth2Language[USM_LANGUAGE_CHINESE].Attribute  = 1;
        USMDepth2Language[USM_LANGUAGE_KOREAN].Attribute   = 0;
        USMDepth2Language[USM_LANGUAGE_ENGLISH].Attribute  = 0;
        break;
    case ENGLISH://Ӣ
        USMDepth2Language[USM_LANGUAGE_CHINESE].Attribute  = 0;
        USMDepth2Language[USM_LANGUAGE_KOREAN].Attribute   = 0;
        USMDepth2Language[USM_LANGUAGE_ENGLISH].Attribute  = 1;
        break;
    case KOREAN://
        USMDepth2Language[USM_LANGUAGE_CHINESE].Attribute  = 0;
        USMDepth2Language[USM_LANGUAGE_KOREAN].Attribute   = 1;
        USMDepth2Language[USM_LANGUAGE_ENGLISH].Attribute  = 0;
        break;
    }
    Can0DataStruct.CF_DAW_Opt_USM = 1;
    if(Can0DataStruct.CF_DAW_Opt_USM == 0)
    {//ʻԱעʾ
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid = 1;
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Invalid   = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Invalid = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Invalid  = 1;
    }
    else if(Can0DataStruct.CF_DAW_Opt_USM == 0x02 || (Can0DataStruct.CF_DAW_Opt_USM >= 0x05 && Can0DataStruct.CF_DAW_Opt_USM <= 0x07))
    {
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled = 1;
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Invalid   = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Invalid = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Invalid  = 1;
    }
    else if(Can0DataStruct.CF_DAW_Opt_USM == 0x01)
    {
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled = 0;
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Invalid   = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Invalid  = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Attribute   = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Attribute = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Attribute  = 1;
    }
    else if(Can0DataStruct.CF_DAW_Opt_USM == 0x03)
    {
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled = 0;
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Invalid   = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Invalid  = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Attribute   = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Attribute = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Attribute  = 0;
    }
    else if(Can0DataStruct.CF_DAW_Opt_USM == 0x04)
    {
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled = 0;
        USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Invalid   = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Invalid = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Invalid  = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Attribute   = 1;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Attribute = 0;
        USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Attribute  = 0;
    }
    if(Can0DataStruct.CF_LKA_Mode == 1 && (Can0DataStruct.CF_LKA_Opt_USM == 0x01 || Can0DataStruct.CF_LKA_Opt_USM == 0x02 || Can0DataStruct.CF_LKA_Opt_USM == 0x03 || Can0DataStruct.CF_LKA_Opt_USM == 0x06))
    {//ȫ
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid       = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid       = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid             = 0;
        switch(Can0DataStruct.CF_LKA_Opt_USM)
        {
        case 0x01:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x02:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x03:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x06:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 1;
            break;
        default:
            break;
        }
    }
    else if(Can0DataStruct.CF_LKA_Mode == 0 && (Can0DataStruct.CF_LKA_Opt_USM == 0x01 || Can0DataStruct.CF_LKA_Opt_USM == 0x02 || Can0DataStruct.CF_LKA_Opt_USM == 0x06))
    {
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid       = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid       = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid             = 0;
        
        switch(Can0DataStruct.CF_LKA_Opt_USM)
        {
        case 0x01:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x02:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x06:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 1;
            break;
        default:
            break;
        }
    }
    else if(Can0DataStruct.CF_LKA_Mode == 0 && (Can0DataStruct.CF_LKA_Opt_USM == 0x04 || Can0DataStruct.CF_LKA_Opt_USM == 0x05))
    {
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid       = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid       = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid = 0;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid             = 0;
        
        switch(Can0DataStruct.CF_LKA_Opt_USM)
        {
        case 0x04:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 0;
            break;
        case 0x05:
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Attribute       = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Attribute = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Attribute             = 1;
            break;
        default:
            break;
        }
    }
    else if(Can0DataStruct.CF_LKA_Opt_USM == 0x0 || Can0DataStruct.CF_LKA_Opt_USM == 0x07
            ||(Can0DataStruct.CF_LKA_Mode == 0 && Can0DataStruct.CF_LKA_Opt_USM == 0x03)
              ||(Can0DataStruct.CF_LKA_Mode == 1 && (Can0DataStruct.CF_LKA_Opt_USM == 0x04 || Can0DataStruct.CF_LKA_Opt_USM == 0x05)))
    {
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid       = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid       = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid = 1;
        USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid             = 1;
    }
    if((Can0DataStruct.FCA_USM >= 0x01 && Can0DataStruct.FCA_USM <= 0x03) || Can0DataStruct.FCA_USM == 0x07)
    {//ǰȫ 
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid = 0;
        if(Can0DataStruct.FCA_USM == 0x07)
        {
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Disabled = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Invalid = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Invalid      = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Invalid                 = 1;
        }
        else
        {
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Disabled = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Invalid = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Invalid      = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Invalid                 = 0;
            switch(Can0DataStruct.FCA_USM)
            {
            case 0x01:
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Attribute = 0;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Attribute      = 0;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Attribute                 = 1;
                break;
            case 0x02:
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Attribute = 0;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Attribute      = 1;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Attribute                 = 0;
                break;
            case 0x03:
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Attribute = 1;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Attribute      = 0;
                USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Attribute                 = 0;
                break;
            default:
                break;
            }
        }
    }
    else if(Can0DataStruct.FCA_USM == 0 || (Can0DataStruct.FCA_USM >= 0x04 && Can0DataStruct.FCA_USM <= 0x06))
    {
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid = 1;
        USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Disabled = 1;
        USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Invalid = 1;
        USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Invalid      = 1;
        USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Invalid                 = 1;
    }
    if(USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid == 1
       && USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid == 1
         && USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid == 1)
    {
        USMDepth1Para[USM_DRIVE_ASSIST].Invalid = 1;
    }
    else
    {
        USMDepth1Para[USM_DRIVE_ASSIST].Invalid = 0;
    }
    if(Flag_USM_Park == 1)
    {
        USMDepth1Para[USM_DOOR].Disabled             = 1;
        USMDepth1Para[USM_LIGHT].Disabled            = 1;
        USMDepth1Para[USM_SOUND].Disabled            = 1;
        USMDepth1Para[USM_CONVENIENCE].Disabled      = 1;
        USMDepth1Para[USM_SERVICE_INTERVAL].Disabled = 1;
        USMDepth1Para[USM_OTHER].Disabled            = 1;
        USMDepth1Para[USM_LANGUAGE].Disabled         = 1;
        USMDepth1Para[USM_RESET].Disabled            = 1;
    }
    else
    {
        USMDepth1Para[USM_DOOR].Disabled             = 0;
        USMDepth1Para[USM_LIGHT].Disabled            = 0;
        USMDepth1Para[USM_SOUND].Disabled            = 0;
        USMDepth1Para[USM_CONVENIENCE].Disabled      = 0;
        USMDepth1Para[USM_SERVICE_INTERVAL].Disabled = 0;
        USMDepth1Para[USM_OTHER].Disabled            = 0;
        USMDepth1Para[USM_LANGUAGE].Disabled         = 0;
        USMDepth1Para[USM_RESET].Disabled            = 0;
    }
    
    for(i = 0; i < sizeof(CurUSMPara) / sizeof(CUR_USM_PARA); i++)
    {
        if(CurUSM != i)
        {
            ValidNum = 0;
            for (j = 1; j < (CurUSMPara[i].CurUSMMaxItem - 1); j++)
            {//в˵ͷ
                if (CurUSMPara[i].pCurUSM[j + 1].Pic.WhitePic != 0 && CurUSMPara[i].pCurUSM[j + 1].Invalid != 1) 
                {
                    ValidNum++;
                }
            }
            CurUSMPara[i].CurUSMValidNum = ValidNum;
            CurUSMPara[i].LastUSMValidNum = CurUSMPara[i].CurUSMValidNum;
        }
    }
}

void CheckUsmSetState(void)
{
    // if(EolStruct._AT == TCU_TYPE_AT)//AT
    // {
    //     if(Can0DataStruct.G_SEL_DISP == 0 && Can0Frame[CAN0_FRAME_0x111].AliveTime != 0)//gear = P
    //     {
    //         USM_Park_Step = 2;
    //         Flag_USM_Park = 0;//Park
    //     }
    //     else
    //     {
    //         if(Flag_USM_Park == 0)
    //         {
    //             if(GroupTabPara.GroupTabUSM.CurDepth > 0)
    //             {
    //                 USM_Park_Step = USM_PARK_POPUP;
    //                 USMPark_Count = 0;
    //             }
    //             else
    //             {
    //                 USM_Park_Step = USM_PARK_NORMAL;
    //             }
    //         }
    //         Flag_USM_Park = 1;//Move
    //     }
    // }
    // else if(EolStruct._AT == TCU_TYPE_MT)//MT
    // {
    //     if(Can1DataStruct.C_ParkBrakeSw == 1 && TripCPara.Speed <= 1)
    //     {
    //         USM_Park_Step = 2;
    //         Flag_USM_Park = 0;//Park
    //     }
    //     else
    //     {
    //         if(Flag_USM_Park == 0)
    //         {
    //             if(GroupTabPara.GroupTabUSM.CurDepth > 0 || Flag_Reset == 1)
    //             {
    //                 USM_Park_Step = USM_PARK_POPUP;
    //                 USMPark_Count = 0;
    //             }
    //             else
    //             {
    //                 USM_Park_Step = USM_PARK_NORMAL;
    //             }
    //         }
    //         Flag_USM_Park = 1;//Move
    //     }
    // }

}

static void USM_ServiceIntervalTips(void)
{
 
}

static void USM_ServiceIntervalSetting(void)
{
 
}

static void USM_ServiceIntervalReset(void)
{

}

static void USM_Reset(void)
{

}

static void USM_DriverAssistDawHigh(void)
{
}

static void USM_DriverAssistDawNormal(void)
{
}

static void USM_DriverAssistDawClose(void)
{
}

static void USM_DriverAsstistLaneSafetyKeepCenter(void)
{
}

static void USM_DriverAsstistLaneSafetyKeepAssist(void)
{
}

static void USM_DriverAsstistLaneSafetyDeviationWarning(void)
{
}

static void USM_DriverAsstistLaneSafetyClose(void)
{
}

static void USM_DriverAssistForwardSafetyAntiCollisionAssist(void)
{
}

static void USM_DriverAssistForwardSafetyConflictWarning(void)
{
}

static void USM_DriverAssistForwardSafetyClose(void)
{
}

static void USM_DoorSmartSuitcase(void)
{
}

static void USM_DoorWalkawayLock(void)
{
}

static void USM_DoorAutoLockWhenRND(void)
{
}

static void USM_DoorAutoLockWhenDriver(void)
{
}

static void USM_DoorAutoLockClose(void)
{
}

static void USM_DoorAutoUnlockWhenP(void)
{
}

static void USM_DoorAutoUnlockDriver(void)
{
}

static void USM_DoorAutoUnlockWhenPowerDown(void)
{
}

static void USM_DoorAutoUnlockClose(void)
{
}

static void USM_LightHeadlightDelay(void)
{
}

static void USM_LightOttsTimes3(void)
{
}

static void USM_LightOttsTimes5(void)
{
}

static void USM_LightOttsTimes7(void)
{
}

static void USM_LightOttsClose(void)
{
}

static void USM_ConverienceWiperLightsDisplay(void)
{
    if(UsmSelfPara.Flag_WiperLight_Display == WIPER_LIGHT_OFF)
    {
        UsmSelfPara.Flag_WiperLight_Display = WIPER_LIGHT_ON;
    }
    else if(UsmSelfPara.Flag_WiperLight_Display == WIPER_LIGHT_ON)
    {
        UsmSelfPara.Flag_WiperLight_Display = WIPER_LIGHT_OFF;
    }
    //SaveMiscValid = 1;
}

static void USM_ConverienceAutoRearWiper(void)
{
}

static void USM_ConverienceGearPositionPopUp(void)
{
}

static void USM_ConverienceWirelessChargingSystem(void)
{
}

static void USM_OherFuelEconomyResetClose(void)
{

}

static void USM_OherFuelEconomyResetEveryStart(void)
{

}

static void USM_OherFuelEconomyResetEveryRefuel(void)
{

}

static void USM_OtherTemperatureUnitC(void)
{
}

static void USM_OtherTemperatureUnitF(void)
{
}

static void USM_LanguageChinese(void)
{
}

static void USM_LanguageEnglish(void)
{
}

static void USM_LanguageKorean(void)
{
}

void InitUSMPara(uint8_t Languate, uint8_t ReInit)
{
    if(ReInit == 1)
    {
        CurUSM = 0;
        LastUSM = 0;
        USMOp = 0;
        LastUSMTransitionTime = 0;
        Flag_USM_Park = 0;
        ServicePara.Flag = 0;
        ServicePara.Flag_Cancel = 0;
        ServicePara.Flag_Confirm = 0;
        ServicePara.Flag_OK = 0;
        Flag_USM_Help = 0;
        Flag_Reset = 0;
        Flag_Reset_OK = 0;
        Flag_Reset_Cancel = 0;
        Flag_ServiceReset = 0;
    }
    switch(Languate)
    {
    case CHINESE:
        {
            USMDepth1Para[USM_TITLE].Pic.WhitePic                = Set_Menu1_Title_Word0;
            USMDepth1Para[USM_HUD].Pic.WhitePic                  = 0;
            USMDepth1Para[USM_ESC_OFF].Pic.WhitePic              = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Pic.WhitePic         = Set_Menu1_01_Word0;
            USMDepth1Para[USM_DOOR].Pic.WhitePic                 = Set_Menu1_02_Word0;
            USMDepth1Para[USM_DOOR].Pic.GrayPic                  = Set_Menu1_02_Gray_Word0;
            USMDepth1Para[USM_LIGHT].Pic.WhitePic                = Set_Menu1_03_Word0;
            USMDepth1Para[USM_LIGHT].Pic.GrayPic                 = Set_Menu1_03_Gray_Word0;
            USMDepth1Para[USM_SOUND].Pic.WhitePic                = 0;
            USMDepth1Para[USM_CONVENIENCE].Pic.WhitePic          = Set_Menu1_05_Word0;
            USMDepth1Para[USM_CONVENIENCE].Pic.GrayPic           = Set_Menu1_05_Gray_Word0;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.WhitePic     = Set_Menu1_06_Word0;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.GrayPic      = Set_Menu1_06_Gray_Word0;
            USMDepth1Para[USM_OTHER].Pic.WhitePic                = Set_Menu1_07_Word0;
            USMDepth1Para[USM_OTHER].Pic.GrayPic                 = Set_Menu1_07_Gray_Word0;
            USMDepth1Para[USM_LANGUAGE].Pic.WhitePic             = Set_Menu1_08_Word0;
            USMDepth1Para[USM_LANGUAGE].Pic.GrayPic              = Set_Menu1_08_Gray_Word0;
            //USMDepth1Para[USM_LANGUAGE].Pic.HelpPic              = Set_Help_Menu1_08_Word0_X26_Y88;
            //USMDepth1Para[USM_LANGUAGE].HelpLine                 = 2;
            //USMDepth1Para[USM_LANGUAGE].HelpTitleLine            = 1;
            USMDepth1Para[USM_RESET].Pic.WhitePic                = Set_Menu1_09_Word0;
            USMDepth1Para[USM_RESET].Pic.GrayPic                 = Set_Menu1_09_Gray_Word0;
            USMDepth1Para[USM_HUD].Type                          = 0;
            USMDepth1Para[USM_ESC_OFF].Type                      = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Type                 = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_DRIVE_ASSIST].Invalid              = 1;
            USMDepth1Para[USM_DOOR].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LIGHT].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SOUND].Type                        = 0;
            USMDepth1Para[USM_CONVENIENCE].Type                  = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SERVICE_INTERVAL].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_OTHER].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LANGUAGE].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].CurUSMFunc                  = USM_Reset;
            
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_TITLE].Pic.WhitePic               = Set_Menu2_Driver_Assistance_Title_Word0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Pic.WhitePic              = Set_Menu2_Driver_Assistance_01_Word0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.WhitePic                 = Set_Menu2_Driver_Assistance_04_Word0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.AllPic                   = Set_Menu2_Driver_Assistance_04_All_Word0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].ALL_Length                   = 173;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.HelpPic                  = Set_Help_Menu2_Driver_Assistance_04_Word0_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpLine                     = 4;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpTitleLine                = 1;
           
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.GrayPic                  = Set_Menu2_Driver_Assistance_04_Gray_Word0;
            
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid                      = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled                     = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Pic.WhitePic        = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Pic.WhitePic       = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Pic.WhitePic                = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.WhitePic        = Set_Menu2_Driver_Assistance_08_Word0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.HelpPic         = Set_Help_Menu2_Driver_Assistance_08_Word0_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpLine            = 2;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpTitleLine       = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid             = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.WhitePic     = Set_Menu2_Driver_Assistance_09_Word0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.GrayPic      = Set_Menu2_Driver_Assistance_09_Gray_Word0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.HelpPic      = Set_Help_Menu2_Driver_Assistance_09_Word0_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpLine         = 2;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpTitleLine    = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid          = 1;       
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Type                      = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Type                = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Type               = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Type                        = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Type                = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Type             = USM_ITEM_TYPE_ARROW;
            
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_TITLE].Pic.WhitePic   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_RETURN].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Pic.WhitePic    = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Pic.WhitePic     = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Type   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Type = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Type    = 0;
            
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TITLE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_Title_Word0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TITLE].Pic.AllPic      = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_01_Word0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Pic.WhitePic     = Set_Menu3_DriverAssistance_DriverAttentionWarning_02_Word0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_03_Word0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.AllPic     = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_04_Word0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Type           = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Type             = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].CurUSMFunc       = USM_DriverAssistDawHigh;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].CurUSMFunc     = USM_DriverAssistDawNormal;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].CurUSMFunc      = USM_DriverAssistDawClose;
            
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_TITLE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_Title_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Pic.WhitePic                   = Set_Menu3_DriverAssistance_LaneSafety_01_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_05_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.AllPic                = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_05_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpLine                  = 5;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpTitleLine             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_02_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.AllPic                = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_02_Word0_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpLine                  = 4;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpTitleLine             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.WhitePic        = Set_Menu3_DriverAssistance_LaneSafety_03_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.AllPic          = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.HelpPic         = Set_Help_Menu3_DriverAssistance_LaneSafety_03_Word0_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpLine            = 3;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpTitleLine       = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_04_Word0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Type                           = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepCenter;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepAssist;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].CurUSMFunc          = USM_DriverAsstistLaneSafetyDeviationWarning;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Type                            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].CurUSMFunc                      = USM_DriverAsstistLaneSafetyClose;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid                         = 1;

            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_TITLE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_Title_Word0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Pic.WhitePic                      = Set_Menu3_DriverAssistance_ForwardSafety_01_Word0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.WhitePic       = Set_Menu3_DriverAssistance_ForwardSafety_02_Word0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.HelpPic        = Set_Help_Menu3_DriverAssistance_ForwardSafety_02_Word0_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpLine           = 5;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpTitleLine      = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.WhitePic            = Set_Menu3_DriverAssistance_ForwardSafety_03_Word0;   
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.HelpPic             = Set_Help_Menu3_DriverAssistance_ForwardSafety_03_Word0_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpLine                = 3;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpTitleLine           = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_04_Word0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Type                              = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].CurUSMFunc         = USM_DriverAssistForwardSafetyAntiCollisionAssist;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].CurUSMFunc              = USM_DriverAssistForwardSafetyConflictWarning;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Type                               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].CurUSMFunc                         = USM_DriverAssistForwardSafetyClose;
            
            USMDepth2Door[USM_DOOR_TITLE].Pic.WhitePic           = Set_Menu2_Door_Title_Word0;
            USMDepth2Door[USM_DOOR_RETURN].Pic.WhitePic          = Set_Menu2_Door_01_Word0;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.WhitePic       = Set_Menu2_Door_02_Word0;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.HelpPic        = Set_Help_Menu2_Door_02_Word0_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpLine           = 2; 
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpTitleLine      = 1;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.WhitePic     = Set_Menu2_Door_03_Word0;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.HelpPic      = Set_Help_Menu2_Door_03_Word0_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpLine         = 2; 
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpTitleLine    = 1;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.WhitePic  = Set_Menu2_Door_05_Word0;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.HelpPic   = Set_Help_Menu2_Door_05_Word0_X26_Y88;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpLine      = 4;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpTitleLine = 1;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.WhitePic   = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.HelpPic    = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Pic.WhitePic   = Set_Menu2_Door_06_Word0;
            USMDepth2Door[USM_DOOR_RETURN].Type                  = 0;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Type               = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].CurUSMFunc    = USM_DoorSmartSuitcase;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Type           = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].CurUSMFunc     = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Type           = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].CurUSMFunc     = USM_DoorWalkawayLock;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Invalid        = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid        = 1;

            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_TITLE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_Title_Word0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Pic.WhitePic        = Set_Menu3_Door_AutoLock_01_Word0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Pic.WhitePic      = Set_Menu3_Door_AutoLock_04_Word0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Pic.WhitePic    = Set_Menu3_Door_AutoLock_03_Word0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_02_Word0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Type                = 0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].CurUSMFunc        = USM_DoorAutoLockWhenRND;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].CurUSMFunc      = USM_DoorAutoLockWhenDriver;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].CurUSMFunc           = USM_DoorAutoLockClose;

            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_TITLE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_Title_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_RETURN].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_01_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_05_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_04_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.AllPic              = 0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Pic.WhitePic   = Set_Menu3_Door_AutoUnlock_06_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_02_Word0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].CurUSMFunc              = USM_DoorAutoUnlockWhenP;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].CurUSMFunc              = USM_DoorAutoUnlockDriver;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].CurUSMFunc     = USM_DoorAutoUnlockWhenPowerDown;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].CurUSMFunc               = USM_DoorAutoUnlockClose;
            
            USMDepth2Light[USM_LIGHT_TITLE].Pic.WhitePic                    = Set_Menu2_Lights_Title_Word0;
            USMDepth2Light[USM_LIGHT_RETURN].Pic.WhitePic                   = Set_Menu2_Lights_01_Word0;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.WhitePic    = Set_Menu2_Lights_02_Word0;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.AllPic      = 0;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.HelpPic     = Set_Help_Menu2_Lights_02_Word0_X26_Y88;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpLine        = 4; 
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpTitleLine   = 1;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.WhitePic          = Set_Menu2_Lights_03_Word0;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.HelpPic           = Set_Help_Menu2_Lights_03_Word0_X26_Y88;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpLine              = 4; 
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpTitleLine         = 1;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Type                  = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].CurUSMFunc            = USM_LightHeadlightDelay;
            
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TITLE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_Title_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TITLE].Pic.AllPic          = 0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_RETURN].Pic.WhitePic       = Set_Menu3_Lights_OneTouchTurnSignal_01_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_02_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_03_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_04_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_05_Word0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].CurUSMFunc        = USM_LightOttsTimes3;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].CurUSMFunc        = USM_LightOttsTimes5;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].CurUSMFunc        = USM_LightOttsTimes7;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].CurUSMFunc          = USM_LightOttsClose;

            USMDepth2Sound[USM_SOUND_TITLE].Pic.WhitePic                         = 0;
            USMDepth2Sound[USM_SOUND_RETURN].Pic.WhitePic                        = 0;
            USMDepth2Sound[USM_SOUND_CLUSTER_VOICE_GUIDANCE_VOLUME].Pic.WhitePic = 0;
            USMDepth2Sound[USM_SOUND_PARK_ASSIST_VOLUME].Pic.WhitePic            = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Pic.WhitePic                 = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Type                         = 0;
            
            USMDepth3SoundVPV[USM_SOUND_VPV_TITLE].Pic.WhitePic          = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_RETURN].Pic.WhitePic         = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Pic.WhitePic    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Type   = 0;
            
            
            USMDepth3SoundPDWV[USM_SOUND_PDWV_TITLE].Pic.WhitePic        = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_RETURN].Pic.WhitePic       = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Type  = 0;
           
            USMDepth2Convenience[USM_CONVENIENCE_TITLE].Pic.WhitePic                     = Set_Menu2_Convenience_Title_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_RETURN].Pic.WhitePic                    = Set_Menu2_Convenience_01_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT].Pic.WhitePic      = 0;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.WhitePic      = Set_Menu2_Convenience_02_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.AllPic        = Set_Menu2_Convenience_02_All_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].ALL_Length        = 210;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.HelpPic       = Set_Help_Menu2_Convenience_02_Word0_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpLine          = 5;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpTitleLine     = 2;
            
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.WhitePic           = Set_Menu2_Convenience_03_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.AllPic             = Set_Menu2_Convenience_03_All_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].ALL_Length             = 260;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.HelpPic            = Set_Help_Menu2_Convenience_03_Word0_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpLine               = 7;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpTitleLine          = 2;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.WhitePic      = Set_Menu2_Convenience_04_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.AllPic        = 0;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.HelpPic       = Set_Help_Menu2_Convenience_04_Word0_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpLine          = 3;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpTitleLine     = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.WhitePic  = Set_Menu2_Convenience_05_Word0;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.AllPic    = 0;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.HelpPic   = Set_Help_Menu2_Convenience_05_Word0_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpLine      = 3;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpTitleLine = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid       = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].CurUSMFunc        = USM_ConverienceWiperLightsDisplay;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Type                   = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].CurUSMFunc             = USM_ConverienceAutoRearWiper;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].CurUSMFunc        = USM_ConverienceGearPositionPopUp;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].CurUSMFunc    = USM_ConverienceWirelessChargingSystem;
            
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TITLE].Pic.WhitePic    = Set_Menu2_Service_Interval_Title_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RETURN].Pic.WhitePic   = Set_Menu2_Service_Interval_01_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.WhitePic     = Set_Menu2_Service_Interval_02_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.AllPic       = 0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.HelpPic      = Set_Help_Menu2_Service_Interval_02_Word0_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpLine         = 2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpTitleLine    = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.WhitePic  = Set_Menu2_Service_Interval_03_White_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.GrayPic   = Set_Menu2_Service_Interval_03_Gray_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.HelpPic   = Set_Help_Menu2_Service_Interval_03_Word0_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpLine      = 3;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpTitleLine = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Type             = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].CurUSMFunc       = USM_ServiceIntervalTips;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Disabled      = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Type          = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].CurUSMFunc    = USM_ServiceIntervalSetting;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.WhitePic    = Set_Menu2_Service_Interval_04_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.GrayPic     = Set_Menu2_Service_Interval_04_Gray_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.HelpPic     = Set_Help_Menu2_Service_Interval_04_Word0_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpLine        = 3;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpTitleLine   = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].CurUSMFunc      = USM_ServiceIntervalReset;
            
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TITLE].Pic.WhitePic              = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_RETURN].Pic.WhitePic             = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Pic.WhitePic        = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Pic.WhitePic       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Type       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Type      = 0;
            
            USMDepth2Other[USM_OTHER_TITLE].Pic.WhitePic                        = Set_Menu2_Other_Title_Word0;
            USMDepth2Other[USM_OTHER_RETURN].Pic.WhitePic                       = Set_Menu2_Other_01_Word0;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Pic.WhitePic    = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.WhitePic           = Set_Menu2_Other_02_Word0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.AllPic             = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.HelpPic            = Set_Help_Menu2_Other_02_Word0_X26_Y88;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpLine               = 3;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpTitleLine          = 1;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Pic.WhitePic             = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Pic.WhitePic                    = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Pic.WhitePic            = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.WhitePic             = Set_Menu2_Other_04_Word0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.HelpPic              = Set_Help_Menu2_Other_04_Word0_X26_Y88;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpLine                 = 2;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpTitleLine            = 1;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Pic.WhitePic          = 0;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Type            = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Type                   = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Type                     = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Type                            = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Type                           = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Type                           = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Type                    = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Type                  = 0;
            
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Pic.WhitePic     = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Type      = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Type    = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Type      = 0;

            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_Title_Word0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.AllPic                = 0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_RETURN].Pic.WhitePic             = Set_Menu3_Other_FuelEconomyAutoReset_01_Word0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_02_Word0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Pic.WhitePic        = Set_Menu3_Other_FuelEconomyAutoReset_03_Word0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Pic.WhitePic       = Set_Menu3_Other_FuelEconomyAutoReset_04_Word0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].CurUSMFunc                = USM_OherFuelEconomyResetClose;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].CurUSMFunc          = USM_OherFuelEconomyResetEveryStart;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].CurUSMFunc         = USM_OherFuelEconomyResetEveryRefuel;

            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_TITLE].Pic.WhitePic       = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_RETURN].Pic.WhitePic      = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Type        = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Type        = 0;

            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Type      = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Type      = 0;

            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Type      = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Type      = 0;
          
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Pic.WhitePic          = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Type         = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Type      = 0;

            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_TITLE].Pic.WhitePic         = Set_Menu3_Other_TemperatureUnit_Title_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_RETURN].Pic.WhitePic        = Set_Menu3_Other_TemperatureUnit_01_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_02_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_03_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].CurUSMFunc               = USM_OtherTemperatureUnitC;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].CurUSMFunc               = USM_OtherTemperatureUnitF;

            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_TITLE].Pic.WhitePic    = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_RETURN].Pic.WhitePic   = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Type     = 0;
            
            USMDepth2Language[USM_LANGUAGE_TITLE].Pic.WhitePic           = Set_Menu2_Language_Title_Word0;
            USMDepth2Language[USM_LANGUAGE_RETURN].Pic.WhitePic          = Set_Menu2_Language_01_Word0;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Pic.WhitePic         = Set_Menu2_Language_03_Word0;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Pic.WhitePic          = Set_Menu2_Language_04_Word0;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Pic.WhitePic         = Set_Menu2_Language_02_Word0;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_CHINESE].CurUSMFunc           = USM_LanguageChinese;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Type                  = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_KOREAN].CurUSMFunc            = USM_LanguageKorean;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].CurUSMFunc           = USM_LanguageEnglish;
        }
        break;
    case ENGLISH:
        {
            USMDepth1Para[USM_TITLE].Pic.WhitePic                = Set_Menu1_Title_Word2;
            USMDepth1Para[USM_HUD].Pic.WhitePic                  = 0;
            USMDepth1Para[USM_ESC_OFF].Pic.WhitePic              = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Pic.WhitePic         = Set_Menu1_01_Word2;
            USMDepth1Para[USM_DOOR].Pic.WhitePic                 = Set_Menu1_02_Word2;
            USMDepth1Para[USM_DOOR].Pic.GrayPic                  = Set_Menu1_02_Gray_Word2;
            USMDepth1Para[USM_LIGHT].Pic.WhitePic                = Set_Menu1_03_Word2;
            USMDepth1Para[USM_LIGHT].Pic.GrayPic                 = Set_Menu1_03_Gray_Word2;
            USMDepth1Para[USM_SOUND].Pic.WhitePic                = 0;
            USMDepth1Para[USM_CONVENIENCE].Pic.WhitePic          = Set_Menu1_05_Word2;
            USMDepth1Para[USM_CONVENIENCE].Pic.GrayPic           = Set_Menu1_05_Gray_Word2;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.WhitePic     = Set_Menu1_06_Word2;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.GrayPic      = Set_Menu1_06_Gray_Word2;
            USMDepth1Para[USM_OTHER].Pic.WhitePic                = Set_Menu1_07_Word2;
            USMDepth1Para[USM_OTHER].Pic.GrayPic                 = Set_Menu1_07_Gray_Word2;
            USMDepth1Para[USM_LANGUAGE].Pic.WhitePic             = Set_Menu1_08_Word2;
            USMDepth1Para[USM_LANGUAGE].Pic.GrayPic              = Set_Menu1_08_Gray_Word2;
            //USMDepth1Para[USM_LANGUAGE].Pic.HelpPic              = Set_Help_Menu1_08_Word2_X26_Y88;
            //USMDepth1Para[USM_LANGUAGE].HelpLine                 = 4;
            //USMDepth1Para[USM_LANGUAGE].HelpTitleLine            = 1;
            USMDepth1Para[USM_RESET].Pic.WhitePic                = Set_Menu1_09_Word2;
            USMDepth1Para[USM_RESET].Pic.GrayPic                 = Set_Menu1_09_Gray_Word2;
            USMDepth1Para[USM_HUD].Type                          = 0;
            USMDepth1Para[USM_ESC_OFF].Type                      = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Type                 = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_DRIVE_ASSIST].Invalid              = 1;
            USMDepth1Para[USM_DOOR].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LIGHT].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SOUND].Type                        = 0;
            USMDepth1Para[USM_CONVENIENCE].Type                  = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SERVICE_INTERVAL].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_OTHER].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LANGUAGE].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].CurUSMFunc                  = USM_Reset;
            
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_TITLE].Pic.WhitePic               = Set_Menu2_Driver_Assistance_Title_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Pic.WhitePic              = Set_Menu2_Driver_Assistance_01_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.WhitePic                 = Set_Menu2_Driver_Assistance_04_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.HelpPic                  = Set_Help_Menu2_Driver_Assistance_04_Word2_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpLine                     = 8;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpTitleLine                = 2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.AllPic                   = Set_Menu2_Driver_Assistance_04_All_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.GrayPic                  = Set_Menu2_Driver_Assistance_04_Gray_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].ALL_Length                   = 324;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid                      = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled                     = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Pic.WhitePic        = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Pic.WhitePic       = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Pic.WhitePic                = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.WhitePic        = Set_Menu2_Driver_Assistance_08_Word2;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.HelpPic         = Set_Help_Menu2_Driver_Assistance_08_Word2_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpLine            = 4;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpTitleLine       = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid             = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.WhitePic     = Set_Menu2_Driver_Assistance_09_Word2;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.GrayPic      = Set_Menu2_Driver_Assistance_09_Gray_Word2;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.HelpPic      = Set_Help_Menu2_Driver_Assistance_09_Word2_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid          = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpLine         = 4;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpTitleLine    = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Type                      = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Type                = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Type               = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Type                        = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Type                = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Type             = USM_ITEM_TYPE_ARROW;
            
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_TITLE].Pic.WhitePic   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_RETURN].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Pic.WhitePic    = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Pic.WhitePic     = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Type   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Type = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Type    = 0;
            
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TITLE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_Title_Word2;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_01_Word2;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Pic.WhitePic     = Set_Menu3_DriverAssistance_DriverAttentionWarning_02_Word2;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_03_Word2;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_04_Word2;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.AllPic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_03_All_Word2;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].ALL_Length                = 184;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Type           = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Type             = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].CurUSMFunc       = USM_DriverAssistDawHigh;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].CurUSMFunc     = USM_DriverAssistDawNormal;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].CurUSMFunc      = USM_DriverAssistDawClose;
            
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_TITLE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_Title_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Pic.WhitePic                   = Set_Menu3_DriverAssistance_LaneSafety_01_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_05_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.AllPic                = Set_Menu3_DriverAssistance_LaneSafety_05_All_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].ALL_Length                = 316;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_05_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpLine                  = 7;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpTitleLine             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_02_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.AllPic                = Set_Menu3_DriverAssistance_LaneSafety_02_All_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].ALL_Length                = 266;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_02_Word2_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpLine                  = 8;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpTitleLine             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.WhitePic        = Set_Menu3_DriverAssistance_LaneSafety_03_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.AllPic          =Set_Menu3_DriverAssistance_LaneSafety_03_All_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].ALL_Length          = 316;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.HelpPic         = Set_Help_Menu3_DriverAssistance_LaneSafety_03_Word2_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpLine            = 7;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpTitleLine       = 3;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_04_Word2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Type                           = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepCenter;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepAssist;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].CurUSMFunc          = USM_DriverAsstistLaneSafetyDeviationWarning;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Type                            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].CurUSMFunc                      = USM_DriverAsstistLaneSafetyClose;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid                         = 1;

            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_TITLE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_Title_Word2;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Pic.WhitePic                      = Set_Menu3_DriverAssistance_ForwardSafety_01_Word2;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.WhitePic       = Set_Menu3_DriverAssistance_ForwardSafety_02_Word2;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.HelpPic        = Set_Help_Menu3_DriverAssistance_ForwardSafety_02_Word2_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpLine           = 11;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpTitleLine      = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.WhitePic            = Set_Menu3_DriverAssistance_ForwardSafety_03_Word2;   
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.HelpPic             = Set_Help_Menu3_DriverAssistance_ForwardSafety_03_Word2_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpLine                = 6;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpTitleLine           = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_04_Word2;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Type                              = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].CurUSMFunc         = USM_DriverAssistForwardSafetyAntiCollisionAssist;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].CurUSMFunc              = USM_DriverAssistForwardSafetyConflictWarning;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Type                               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].CurUSMFunc                         = USM_DriverAssistForwardSafetyClose;
            
            USMDepth2Door[USM_DOOR_TITLE].Pic.WhitePic           = Set_Menu2_Door_Title_Word2;
            USMDepth2Door[USM_DOOR_RETURN].Pic.WhitePic          = Set_Menu2_Door_01_Word2;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.WhitePic       = Set_Menu2_Door_02_Word2;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.HelpPic        = Set_Help_Menu2_Door_02_Word2_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpLine           = 6; 
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpTitleLine      = 1;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.WhitePic     = Set_Menu2_Door_03_Word2;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.HelpPic      = Set_Help_Menu2_Door_03_Word2_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpLine         = 5; 
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpTitleLine    = 1;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.WhitePic  = Set_Menu2_Door_05_Word2;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.HelpPic   = Set_Help_Menu2_Door_05_Word2_X26_Y88;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpLine      = 7;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpTitleLine = 1;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.WhitePic   = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.HelpPic    = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Pic.WhitePic   = Set_Menu2_Door_06_Word2;
            USMDepth2Door[USM_DOOR_RETURN].Type                  = 0;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Type               = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].CurUSMFunc    = USM_DoorSmartSuitcase;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Type           = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].CurUSMFunc     = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Type           = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].CurUSMFunc     = USM_DoorWalkawayLock;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Invalid        = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid        = 1;

            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_TITLE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_Title_Word2;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Pic.WhitePic        = Set_Menu3_Door_AutoLock_01_Word2;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Pic.WhitePic      = Set_Menu3_Door_AutoLock_04_Word2;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Pic.WhitePic    = Set_Menu3_Door_AutoLock_03_Word2;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_02_Word2;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Type                = 0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].CurUSMFunc        = USM_DoorAutoLockWhenRND;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].CurUSMFunc      = USM_DoorAutoLockWhenDriver;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].CurUSMFunc           = USM_DoorAutoLockClose;

            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_TITLE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_Title_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_RETURN].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_01_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_05_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_04_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.AllPic              = Set_Menu3_Door_AutoUnlock_04_All_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].ALL_Length              = 188;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Pic.WhitePic   = Set_Menu3_Door_AutoUnlock_06_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_02_Word2;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].CurUSMFunc              = USM_DoorAutoUnlockWhenP;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].CurUSMFunc              = USM_DoorAutoUnlockDriver;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].CurUSMFunc     = USM_DoorAutoUnlockWhenPowerDown;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].CurUSMFunc               = USM_DoorAutoUnlockClose;
            
            USMDepth2Light[USM_LIGHT_TITLE].Pic.WhitePic                    = Set_Menu2_Lights_Title_Word2;
            USMDepth2Light[USM_LIGHT_RETURN].Pic.WhitePic                   = Set_Menu2_Lights_01_Word2;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.WhitePic    = Set_Menu2_Lights_02_Word2;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.AllPic      = Set_Menu2_Lights_02_All_Word2;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].ALL_Length      = 244;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.HelpPic     = Set_Help_Menu2_Lights_02_Word2_X26_Y88;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpLine        = 8; 
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpTitleLine   = 2;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.WhitePic          = Set_Menu2_Lights_03_Word2;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.HelpPic           = Set_Help_Menu2_Lights_03_Word2_X26_Y88;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpLine              = 8; 
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpTitleLine         = 1;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Type                  = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].CurUSMFunc            = USM_LightHeadlightDelay;
            
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TITLE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_Title_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_RETURN].Pic.WhitePic       = Set_Menu3_Lights_OneTouchTurnSignal_01_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_02_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_03_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_04_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_05_Word2;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].CurUSMFunc        = USM_LightOttsTimes3;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].CurUSMFunc        = USM_LightOttsTimes5;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].CurUSMFunc        = USM_LightOttsTimes7;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].CurUSMFunc          = USM_LightOttsClose;

            USMDepth2Sound[USM_SOUND_TITLE].Pic.WhitePic                         = 0;
            USMDepth2Sound[USM_SOUND_RETURN].Pic.WhitePic                        = 0;
            USMDepth2Sound[USM_SOUND_CLUSTER_VOICE_GUIDANCE_VOLUME].Pic.WhitePic = 0;
            USMDepth2Sound[USM_SOUND_PARK_ASSIST_VOLUME].Pic.WhitePic            = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Pic.WhitePic                 = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Type                         = 0;
            
            USMDepth3SoundVPV[USM_SOUND_VPV_TITLE].Pic.WhitePic          = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_RETURN].Pic.WhitePic         = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Pic.WhitePic    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Type   = 0;
            
            
            USMDepth3SoundPDWV[USM_SOUND_PDWV_TITLE].Pic.WhitePic        = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_RETURN].Pic.WhitePic       = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Type  = 0;
           
            USMDepth2Convenience[USM_CONVENIENCE_TITLE].Pic.WhitePic                     = Set_Menu2_Convenience_Title_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_RETURN].Pic.WhitePic                    = Set_Menu2_Convenience_01_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT].Pic.WhitePic      = 0;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.WhitePic      = Set_Menu2_Convenience_02_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.AllPic        = Set_Menu2_Convenience_02_All_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.HelpPic       = Set_Help_Menu2_Convenience_02_Word2_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpLine          = 6;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpTitleLine     = 2;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].ALL_Length        = 208;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.WhitePic           = Set_Menu2_Convenience_03_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.HelpPic            = Set_Help_Menu2_Convenience_03_Word2_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpLine               = 9;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpTitleLine          = 2;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.AllPic             = Set_Menu2_Convenience_03_All_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].ALL_Length             = 264;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpLine               = 7;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpTitleLine          = 2;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.WhitePic      = Set_Menu2_Convenience_04_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.AllPic        = Set_Menu2_Convenience_04_All_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].ALL_Length        = 206;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.HelpPic       = Set_Help_Menu2_Convenience_04_Word2_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpLine          = 5;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpTitleLine     = 2;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.WhitePic  = Set_Menu2_Convenience_05_Word2;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.HelpPic   = Set_Help_Menu2_Convenience_05_Word2_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpLine      = 8;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpTitleLine = 2;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid       = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].CurUSMFunc        = USM_ConverienceWiperLightsDisplay;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Type                   = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].CurUSMFunc             = USM_ConverienceAutoRearWiper;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].CurUSMFunc        = USM_ConverienceGearPositionPopUp;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].CurUSMFunc    = USM_ConverienceWirelessChargingSystem;
            
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TITLE].Pic.WhitePic    = Set_Menu2_Service_Interval_Title_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RETURN].Pic.WhitePic   = Set_Menu2_Service_Interval_01_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.WhitePic     = Set_Menu2_Service_Interval_02_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.AllPic       = Set_Menu2_Service_Interval_02_All_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].ALL_Length      = 234;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.HelpPic      = Set_Help_Menu2_Service_Interval_02_Word2_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpLine         = 7;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpTitleLine    = 2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.WhitePic  = Set_Menu2_Service_Interval_03_White_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.GrayPic   = Set_Menu2_Service_Interval_03_Gray_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.HelpPic   = Set_Help_Menu2_Service_Interval_03_Word2_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpLine      = 5;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpTitleLine = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Type             = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].CurUSMFunc       = USM_ServiceIntervalTips;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Disabled      = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Type          = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].CurUSMFunc    = USM_ServiceIntervalSetting;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.WhitePic    = Set_Menu2_Service_Interval_04_Word2;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.GrayPic     = Set_Menu2_Service_Interval_04_Gray_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.HelpPic     = Set_Help_Menu2_Service_Interval_04_Word2_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpLine        = 4;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpTitleLine   = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].CurUSMFunc      = USM_ServiceIntervalReset;
            
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TITLE].Pic.WhitePic              = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_RETURN].Pic.WhitePic             = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Pic.WhitePic        = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Pic.WhitePic       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Type       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Type      = 0;
            
            USMDepth2Other[USM_OTHER_TITLE].Pic.WhitePic                        = Set_Menu2_Other_Title_Word2;
            USMDepth2Other[USM_OTHER_RETURN].Pic.WhitePic                       = Set_Menu2_Other_01_Word2;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Pic.WhitePic    = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.WhitePic           = Set_Menu2_Other_02_Word2;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.HelpPic            = Set_Help_Menu2_Other_02_Word2_X26_Y88;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.AllPic             = Set_Menu2_Other_02_All_Word2;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].ALL_Length             = 250;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpLine               = 7;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpTitleLine          = 2;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Pic.WhitePic             = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Pic.WhitePic                    = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Pic.WhitePic            = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.WhitePic             = Set_Menu2_Other_04_Word2;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.HelpPic              = Set_Help_Menu2_Other_04_Word2_X26_Y88;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpLine                 = 4;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpTitleLine            = 1;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Pic.WhitePic          = 0;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Type            = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Type                   = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Type                     = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Type                            = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Type                           = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Type                           = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Type                    = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Type                  = 0;
            
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Pic.WhitePic     = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Type      = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Type    = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Type      = 0;

            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_Title_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.AllPic                = Set_Menu3_Other_FuelEconomyAutoReset_Title_All_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].ALL_Length                = 252;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_RETURN].Pic.WhitePic             = Set_Menu3_Other_FuelEconomyAutoReset_01_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_02_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Pic.WhitePic        = Set_Menu3_Other_FuelEconomyAutoReset_03_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Pic.WhitePic       = Set_Menu3_Other_FuelEconomyAutoReset_04_Word2;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].CurUSMFunc                = USM_OherFuelEconomyResetClose;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].CurUSMFunc          = USM_OherFuelEconomyResetEveryStart;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].CurUSMFunc         = USM_OherFuelEconomyResetEveryRefuel;

            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_TITLE].Pic.WhitePic       = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_RETURN].Pic.WhitePic      = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Type        = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Type        = 0;

            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Type      = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Type      = 0;

            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Type      = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Type      = 0;
          
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Pic.WhitePic          = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Type         = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Type      = 0;

            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_TITLE].Pic.WhitePic         = Set_Menu3_Other_TemperatureUnit_Title_Word2;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_RETURN].Pic.WhitePic        = Set_Menu3_Other_TemperatureUnit_01_Word2;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_02_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_03_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].CurUSMFunc               = USM_OtherTemperatureUnitC;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].CurUSMFunc               = USM_OtherTemperatureUnitF;

            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_TITLE].Pic.WhitePic    = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_RETURN].Pic.WhitePic   = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Type     = 0;
            
            USMDepth2Language[USM_LANGUAGE_TITLE].Pic.WhitePic           = Set_Menu2_Language_Title_Word2;
            USMDepth2Language[USM_LANGUAGE_RETURN].Pic.WhitePic          = Set_Menu2_Language_01_Word2;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Pic.WhitePic         = Set_Menu2_Language_03_Word0;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Pic.WhitePic          = Set_Menu2_Language_04_Word0;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Pic.WhitePic         = Set_Menu2_Language_02_Word0;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_CHINESE].CurUSMFunc           = USM_LanguageChinese;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Type                  = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_KOREAN].CurUSMFunc            = USM_LanguageKorean;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].CurUSMFunc           = USM_LanguageEnglish;
        }
        break;
    case KOREAN:
        {
            USMDepth1Para[USM_TITLE].Pic.WhitePic                = Set_Menu1_Title_Word1;
            USMDepth1Para[USM_TITLE].Pic.AllPic                  = 0;
            USMDepth1Para[USM_TITLE].ALL_Length                  = 0;
            USMDepth1Para[USM_HUD].Pic.WhitePic                  = 0;
            USMDepth1Para[USM_ESC_OFF].Pic.WhitePic              = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Pic.WhitePic         = Set_Menu1_01_Word1;
            USMDepth1Para[USM_DOOR].Pic.WhitePic                 = Set_Menu1_02_Word1;
            USMDepth1Para[USM_DOOR].Pic.GrayPic                  = Set_Menu1_02_Gray_Word1;
            USMDepth1Para[USM_LIGHT].Pic.WhitePic                = Set_Menu1_03_Word1;
            USMDepth1Para[USM_LIGHT].Pic.GrayPic                 = Set_Menu1_03_Gray_Word1;
            USMDepth1Para[USM_SOUND].Pic.WhitePic                = 0;
            USMDepth1Para[USM_CONVENIENCE].Pic.WhitePic          = Set_Menu1_05_Word1;
            USMDepth1Para[USM_CONVENIENCE].Pic.GrayPic           = Set_Menu1_05_Gray_Word1;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.WhitePic     = Set_Menu1_06_Word1;
            USMDepth1Para[USM_SERVICE_INTERVAL].Pic.GrayPic      = Set_Menu1_06_Gray_Word1;
            USMDepth1Para[USM_OTHER].Pic.WhitePic                = Set_Menu1_07_Word1;
            USMDepth1Para[USM_OTHER].Pic.GrayPic                 = Set_Menu1_07_Gray_Word1;
            USMDepth1Para[USM_LANGUAGE].Pic.WhitePic             = Set_Menu1_08_Word1;
            USMDepth1Para[USM_LANGUAGE].Pic.GrayPic              = Set_Menu1_08_Gray_Word1;
            //USMDepth1Para[USM_LANGUAGE].Pic.HelpPic              = Set_Help_Menu1_08_Word1_X26_Y88;
            //USMDepth1Para[USM_LANGUAGE].HelpLine                 = 3;
            //USMDepth1Para[USM_LANGUAGE].HelpTitleLine            = 1;
            USMDepth1Para[USM_RESET].Pic.WhitePic                = Set_Menu1_09_Word1;
            USMDepth1Para[USM_RESET].Pic.GrayPic                 = Set_Menu1_09_Gray_Word1;
            USMDepth1Para[USM_HUD].Type                          = 0;
            USMDepth1Para[USM_ESC_OFF].Type                      = 0;
            USMDepth1Para[USM_DRIVE_ASSIST].Type                 = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_DRIVE_ASSIST].Invalid              = 1;
            USMDepth1Para[USM_DOOR].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LIGHT].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SOUND].Type                        = 0;
            USMDepth1Para[USM_CONVENIENCE].Type                  = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_SERVICE_INTERVAL].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_OTHER].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_LANGUAGE].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].Type                        = USM_ITEM_TYPE_ARROW;
            USMDepth1Para[USM_RESET].CurUSMFunc                  = USM_Reset;
            
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_TITLE].Pic.WhitePic               = Set_Menu2_Driver_Assistance_Title_Word1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Pic.WhitePic              = Set_Menu2_Driver_Assistance_01_Word1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.WhitePic                 = Set_Menu2_Driver_Assistance_04_Word1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.AllPic                   = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.HelpPic                  = Set_Help_Menu2_Driver_Assistance_04_Word1_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpLine                     = 4;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].HelpTitleLine                = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Pic.GrayPic                  = Set_Menu2_Driver_Assistance_04_Gray_Word1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Invalid                      = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Disabled                     = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Pic.WhitePic        = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Pic.WhitePic                 = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Pic.WhitePic       = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Pic.WhitePic                = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.WhitePic        = Set_Menu2_Driver_Assistance_08_Word1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Pic.HelpPic         = Set_Help_Menu2_Driver_Assistance_08_Word1_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpLine            = 3;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].HelpTitleLine       = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Invalid             = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.WhitePic     = Set_Menu2_Driver_Assistance_09_Word1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.GrayPic      = Set_Menu2_Driver_Assistance_09_Gray_Word1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Pic.HelpPic      = Set_Help_Menu2_Driver_Assistance_09_Word1_X26_Y88;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Invalid          = 1;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpLine         = 3;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].HelpTitleLine    = 1;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_RETURN].Type                      = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_DAW].Type                         = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_SCC_RESPONSE].Type                = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_AEB].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVE_ASSIST_FCW].Type                         = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_SCC_REACTION].Type               = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_DAW].Type                        = 0;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_LANE_SAFETY].Type                = USM_ITEM_TYPE_ARROW;
            USMDepth2DriveAssist[USM_DRIVER_ASSIST_FORWARD_SAFETY].Type             = USM_ITEM_TYPE_ARROW;
            
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_TITLE].Pic.WhitePic   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_RETURN].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Pic.WhitePic    = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Pic.WhitePic  = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Pic.WhitePic     = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_FAST].Type   = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_NORMAL].Type = 0;
            USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_LOW].Type    = 0;
            
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TITLE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_Title_Word1;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TITLE].Pic.AllPic      = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_01_Word1;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Pic.WhitePic     = Set_Menu3_DriverAssistance_DriverAttentionWarning_02_Word1;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.WhitePic   = Set_Menu3_DriverAssistance_DriverAttentionWarning_03_Word1;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Pic.AllPic     = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Pic.WhitePic    = Set_Menu3_DriverAssistance_DriverAttentionWarning_04_Word1;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_RETURN].Type           = 0;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].Type             = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_HIGH].CurUSMFunc       = USM_DriverAssistDawHigh;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_NORMAL].CurUSMFunc     = USM_DriverAssistDawNormal;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_CLOSE].CurUSMFunc      = USM_DriverAssistDawClose;
            
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_TITLE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_Title_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Pic.WhitePic                   = Set_Menu3_DriverAssistance_LaneSafety_01_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_05_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.AllPic                = Set_Menu3_DriverAssistance_LaneSafety_05_All_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].ALL_Length                = 213;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_05_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpLine                  = 7;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].HelpTitleLine             = 2;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.WhitePic              = Set_Menu3_DriverAssistance_LaneSafety_02_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.AllPic                = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Pic.HelpPic               = Set_Help_Menu3_DriverAssistance_LaneSafety_02_Word1_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpLine                  = 5;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].HelpTitleLine             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.WhitePic        = Set_Menu3_DriverAssistance_LaneSafety_03_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.AllPic          = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Pic.HelpPic         = Set_Help_Menu3_DriverAssistance_LaneSafety_03_Word1_X26_Y88;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpLine            = 3;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].HelpTitleLine       = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Pic.WhitePic                    = Set_Menu3_DriverAssistance_LaneSafety_04_Word1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_RETURN].Type                           = 0;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepCenter;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].CurUSMFunc                = USM_DriverAsstistLaneSafetyKeepAssist;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].CurUSMFunc          = USM_DriverAsstistLaneSafetyDeviationWarning;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Type                            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].CurUSMFunc                      = USM_DriverAsstistLaneSafetyClose;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST].Invalid                   = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING].Invalid             = 1;
            USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE].Invalid                         = 1;

            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_TITLE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_Title_Word1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Pic.WhitePic                      = Set_Menu3_DriverAssistance_ForwardSafety_01_Word1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.WhitePic       = Set_Menu3_DriverAssistance_ForwardSafety_02_Word1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Pic.HelpPic        = Set_Help_Menu3_DriverAssistance_ForwardSafety_02_Word1_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpLine           = 5;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].HelpTitleLine      = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.WhitePic            = Set_Menu3_DriverAssistance_ForwardSafety_03_Word1;   
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Pic.HelpPic             = Set_Help_Menu3_DriverAssistance_ForwardSafety_03_Word1_X26_Y88;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpLine                = 3;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].HelpTitleLine           = 1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Pic.WhitePic                       = Set_Menu3_DriverAssistance_ForwardSafety_04_Word1;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN].Type                              = 0;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST].CurUSMFunc         = USM_DriverAssistForwardSafetyAntiCollisionAssist;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING].CurUSMFunc              = USM_DriverAssistForwardSafetyConflictWarning;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].Type                               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE].CurUSMFunc                         = USM_DriverAssistForwardSafetyClose;
            
            USMDepth2Door[USM_DOOR_TITLE].Pic.WhitePic           = Set_Menu2_Door_Title_Word1;
            USMDepth2Door[USM_DOOR_RETURN].Pic.WhitePic          = Set_Menu2_Door_01_Word1;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.WhitePic       = Set_Menu2_Door_02_Word1;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Pic.HelpPic        = Set_Help_Menu2_Door_02_Word1_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpLine           = 4; 
            USMDepth2Door[USM_DOOR_AUTO_LOCK].HelpTitleLine      = 1;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.WhitePic     = Set_Menu2_Door_03_Word1;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Pic.HelpPic      = Set_Help_Menu2_Door_03_Word1_X26_Y88;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpLine         = 4; 
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].HelpTitleLine    = 1;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.WhitePic  = Set_Menu2_Door_05_Word1;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Pic.HelpPic   = Set_Help_Menu2_Door_05_Word1_X26_Y88;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpLine      = 5;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].HelpTitleLine = 1;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.WhitePic   = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Pic.HelpPic    = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Pic.WhitePic   = Set_Menu2_Door_06_Word1;
            USMDepth2Door[USM_DOOR_RETURN].Type                  = 0;
            USMDepth2Door[USM_DOOR_AUTO_LOCK].Type               = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_AUTO_UNLOCK].Type             = USM_ITEM_TYPE_ARROW;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_SMART_SUITCASE].CurUSMFunc    = USM_DoorSmartSuitcase;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Type           = 0;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].CurUSMFunc     = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Type           = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].CurUSMFunc     = USM_DoorWalkawayLock;
            USMDepth2Door[USM_DOOR_HORN_FEEDBACK].Invalid        = 0;
            USMDepth2Door[USM_DOOR_WALKAWAY_LCOK].Invalid        = 1;

            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_TITLE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_Title_Word1;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Pic.WhitePic        = Set_Menu3_Door_AutoLock_01_Word1;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Pic.WhitePic      = Set_Menu3_Door_AutoLock_04_Word1;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Pic.WhitePic    = Set_Menu3_Door_AutoLock_03_Word1;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Pic.WhitePic         = Set_Menu3_Door_AutoLock_02_Word1;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_RETURN].Type                = 0;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_RND].CurUSMFunc        = USM_DoorAutoLockWhenRND;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].Type            = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_WHEN_DRIVE].CurUSMFunc      = USM_DoorAutoLockWhenDriver;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_CLOSE].CurUSMFunc           = USM_DoorAutoLockClose;

            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_TITLE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_Title_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_RETURN].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_01_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_05_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.WhitePic            = Set_Menu3_Door_AutoUnlock_04_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Pic.AllPic              = 0;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Pic.WhitePic   = Set_Menu3_Door_AutoUnlock_06_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Pic.WhitePic             = Set_Menu3_Door_AutoUnlock_02_Word1;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_P].CurUSMFunc              = USM_DoorAutoUnlockWhenP;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].Type                    = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_DRIVER].CurUSMFunc              = USM_DoorAutoUnlockDriver;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].Type           = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN].CurUSMFunc     = USM_DoorAutoUnlockWhenPowerDown;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_CLOSE].CurUSMFunc               = USM_DoorAutoUnlockClose;
            
            USMDepth2Light[USM_LIGHT_TITLE].Pic.WhitePic                    = Set_Menu2_Lights_Title_Word1;
            USMDepth2Light[USM_LIGHT_RETURN].Pic.WhitePic                   = Set_Menu2_Lights_01_Word1;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.WhitePic    = Set_Menu2_Lights_02_Word1;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.AllPic      = 0;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Pic.HelpPic     = Set_Help_Menu2_Lights_02_Word1_X26_Y88;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpLine        = 6; 
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].HelpTitleLine   = 1;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.WhitePic          = Set_Menu2_Lights_03_Word1;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Pic.HelpPic           = Set_Help_Menu2_Lights_03_Word1_X26_Y88;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpLine              = 5; 
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].HelpTitleLine         = 1;
            USMDepth2Light[USM_LIGHT_ONE_TOUCH_TURN_SIGNAL].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].Type                  = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Light[USM_LIGHT_HEADLIGHT_DELAY].CurUSMFunc            = USM_LightHeadlightDelay;
            
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TITLE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_Title_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TITLE].Pic.AllPic          = 0;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_RETURN].Pic.WhitePic       = Set_Menu3_Lights_OneTouchTurnSignal_01_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_02_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_03_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Pic.WhitePic      = Set_Menu3_Lights_OneTouchTurnSignal_04_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Pic.WhitePic        = Set_Menu3_Lights_OneTouchTurnSignal_05_Word1;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_3].CurUSMFunc        = USM_LightOttsTimes3;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_5].CurUSMFunc        = USM_LightOttsTimes5;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].Type              = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_TIMES_7].CurUSMFunc        = USM_LightOttsTimes7;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3LightOTTS[USM_LIGHT_OTTS_CLOSE].CurUSMFunc          = USM_LightOttsClose;

            USMDepth2Sound[USM_SOUND_TITLE].Pic.WhitePic                         = 0;
            USMDepth2Sound[USM_SOUND_RETURN].Pic.WhitePic                        = 0;
            USMDepth2Sound[USM_SOUND_CLUSTER_VOICE_GUIDANCE_VOLUME].Pic.WhitePic = 0;
            USMDepth2Sound[USM_SOUND_PARK_ASSIST_VOLUME].Pic.WhitePic            = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Pic.WhitePic                 = 0;
            USMDepth2Sound[USM_SOUND_WELCOME_SOUND].Type                         = 0;
            
            USMDepth3SoundVPV[USM_SOUND_VPV_TITLE].Pic.WhitePic          = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_RETURN].Pic.WhitePic         = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Pic.WhitePic     = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Pic.WhitePic    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV1].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV2].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_LV3].Type    = 0;
            USMDepth3SoundVPV[USM_SOUND_VPV_VOLUME_MUTE].Type   = 0;
            
            
            USMDepth3SoundPDWV[USM_SOUND_PDWV_TITLE].Pic.WhitePic        = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_RETURN].Pic.WhitePic       = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Pic.WhitePic   = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV1].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV2].Type  = 0;
            USMDepth3SoundPDWV[USM_SOUND_PDWV_VOLUME_LV3].Type  = 0;
           
            USMDepth2Convenience[USM_CONVENIENCE_TITLE].Pic.WhitePic                     = Set_Menu2_Convenience_Title_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_RETURN].Pic.WhitePic                    = Set_Menu2_Convenience_01_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT].Pic.WhitePic      = 0;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.WhitePic      = Set_Menu2_Convenience_02_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.AllPic        = Set_Menu2_Convenience_02_All_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].ALL_Length        = 216;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Pic.HelpPic       = Set_Help_Menu2_Convenience_02_Word1_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpLine          = 5;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].HelpTitleLine     = 2;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.WhitePic           = Set_Menu2_Convenience_03_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.AllPic             = Set_Menu2_Convenience_03_All_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].ALL_Length             = 235;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Pic.HelpPic            = Set_Help_Menu2_Convenience_03_Word1_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpLine               = 6;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].HelpTitleLine          = 2;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.WhitePic      = Set_Menu2_Convenience_04_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.AllPic        = 0;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Pic.HelpPic       = Set_Help_Menu2_Convenience_04_Word1_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpLine          = 4;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].HelpTitleLine     = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.WhitePic  = Set_Menu2_Convenience_05_Word1;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.AllPic    = 0;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Pic.HelpPic   = Set_Help_Menu2_Convenience_05_Word1_X26_Y88;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpLine      = 5;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].HelpTitleLine = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Invalid       = 1;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY].CurUSMFunc        = USM_ConverienceWiperLightsDisplay;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].Type                   = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_AUTO_REAR_WIPER].CurUSMFunc             = USM_ConverienceAutoRearWiper;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].Type              = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_GEAR_POSITION_POP_UP].CurUSMFunc        = USM_ConverienceGearPositionPopUp;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].Type          = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2Convenience[USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM].CurUSMFunc    = USM_ConverienceWirelessChargingSystem;
            
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TITLE].Pic.WhitePic    = Set_Menu2_Service_Interval_Title_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RETURN].Pic.WhitePic   = Set_Menu2_Service_Interval_01_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.WhitePic     = Set_Menu2_Service_Interval_02_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.AllPic       = 0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Pic.HelpPic      = Set_Help_Menu2_Service_Interval_02_Word1_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpLine         = 5;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].HelpTitleLine    = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.WhitePic  = Set_Menu2_Service_Interval_03_White_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.GrayPic   = Set_Menu2_Service_Interval_03_Gray_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Pic.HelpPic   = Set_Help_Menu2_Service_Interval_03_Word1_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpLine      = 4;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].HelpTitleLine = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].Type             = USM_TIEM_TYPE_CHECK_BOX;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_TIPS].CurUSMFunc       = USM_ServiceIntervalTips;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Disabled      = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].Type          = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_SETTING].CurUSMFunc    = USM_ServiceIntervalSetting;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.WhitePic    = Set_Menu2_Service_Interval_04_Word1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.GrayPic     = Set_Menu2_Service_Interval_04_Gray_Word0;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Pic.HelpPic     = Set_Help_Menu2_Service_Interval_04_Word1_X26_Y88;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpLine        = 4;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].HelpTitleLine   = 1;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].Type            = USM_ITEM_TYPE_ARROW;
            USMDepth2ServiceInterval[USM_SERVICE_INTERVAL_RESET].CurUSMFunc      = USM_ServiceIntervalReset;
            
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TITLE].Pic.WhitePic              = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_RETURN].Pic.WhitePic             = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Pic.WhitePic        = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Pic.WhitePic       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK].Type       = 0;
            USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE].Type      = 0;
            
            USMDepth2Other[USM_OTHER_TITLE].Pic.WhitePic                        = Set_Menu2_Other_Title_Word1;
            USMDepth2Other[USM_OTHER_RETURN].Pic.WhitePic                       = Set_Menu2_Other_01_Word1;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Pic.WhitePic    = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.WhitePic           = Set_Menu2_Other_02_Word1;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.AllPic             = Set_Menu2_Other_02_All_Word1;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].ALL_Length             = 235;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Pic.HelpPic            = Set_Help_Menu2_Other_02_Word1_X26_Y88;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpLine               = 4;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].HelpTitleLine          = 1;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Pic.WhitePic             = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Pic.WhitePic                    = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Pic.WhitePic                   = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Pic.WhitePic            = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.WhitePic             = Set_Menu2_Other_04_Word1;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Pic.HelpPic              = Set_Help_Menu2_Other_04_Word1_X26_Y88;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpLine                 = 3;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].HelpTitleLine            = 1;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Pic.WhitePic          = 0;
            USMDepth2Other[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT].Type            = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_RESET].Type                   = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TRAILER_SUBSCALE].Type                     = 0;
            USMDepth2Other[USM_OTHER_FONT_SIZE].Type                            = 0;
            USMDepth2Other[USM_OTHER_SPEED_SIZE].Type                           = 0;
            USMDepth2Other[USM_OTHER_SPEED_UNIT].Type                           = 0;
            USMDepth2Other[USM_OTHER_FUEL_ECONOMY_UNIT].Type                    = 0;
            USMDepth2Other[USM_OTHER_TEMPERATURE_UNIT].Type                     = USM_ITEM_TYPE_ARROW;
            USMDepth2Other[USM_OTHER_TIRE_PRESSSURE_UNIT].Type                  = 0;
            
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Pic.WhitePic     = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Pic.WhitePic       = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE].Type      = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS].Type    = 0;
            USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL].Type      = 0;

            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_Title_Word1;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TITLE].Pic.AllPic                = 0;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_RETURN].Pic.WhitePic             = Set_Menu3_Other_FuelEconomyAutoReset_01_Word1;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Pic.WhitePic              = Set_Menu3_Other_FuelEconomyAutoReset_02_Word1;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Pic.WhitePic        = Set_Menu3_Other_FuelEconomyAutoReset_03_Word1;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Pic.WhitePic       = Set_Menu3_Other_FuelEconomyAutoReset_04_Word1;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].Type                      = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_CLOSE].CurUSMFunc                = USM_OherFuelEconomyResetClose;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].Type                = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START].CurUSMFunc          = USM_OherFuelEconomyResetEveryStart;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].Type               = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL].CurUSMFunc         = USM_OherFuelEconomyResetEveryRefuel;

            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_TITLE].Pic.WhitePic       = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_RETURN].Pic.WhitePic      = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Pic.WhitePic         = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_MID].Type        = 0;
            USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_BIG].Type        = 0;

            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_MID].Type      = 0;
            USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_BIG].Type      = 0;

            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_TITLE].Pic.WhitePic     = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_RETURN].Pic.WhitePic    = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Pic.WhitePic       = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_KMH].Type      = 0;
            USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_MPH].Type      = 0;
          
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_TITLE].Pic.WhitePic        = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_RETURN].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Pic.WhitePic          = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Pic.WhitePic       = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_KML].Type         = 0;
            USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_L100KM].Type      = 0;

            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_TITLE].Pic.WhitePic         = Set_Menu3_Other_TemperatureUnit_Title_Word1;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_RETURN].Pic.WhitePic        = Set_Menu3_Other_TemperatureUnit_01_Word1;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_02_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Pic.WhitePic             = Set_Menu3_Other_TemperatureUnit_03_Word0;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_C].CurUSMFunc               = USM_OtherTemperatureUnitC;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].Type                     = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_F].CurUSMFunc               = USM_OtherTemperatureUnitF;

            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_TITLE].Pic.WhitePic    = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_RETURN].Pic.WhitePic   = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Pic.WhitePic      = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_PSI].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_KPA].Type     = 0;
            USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_BAR].Type     = 0;
            
            USMDepth2Language[USM_LANGUAGE_TITLE].Pic.WhitePic           = Set_Menu2_Language_Title_Word1;
            USMDepth2Language[USM_LANGUAGE_RETURN].Pic.WhitePic          = Set_Menu2_Language_01_Word1;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Pic.WhitePic         = Set_Menu2_Language_03_Word0;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Pic.WhitePic          = Set_Menu2_Language_04_Word0;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Pic.WhitePic         = Set_Menu2_Language_02_Word0;
            USMDepth2Language[USM_LANGUAGE_CHINESE].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_CHINESE].CurUSMFunc           = USM_LanguageChinese;
            USMDepth2Language[USM_LANGUAGE_KOREAN].Type                  = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_KOREAN].CurUSMFunc            = USM_LanguageKorean;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].Type                 = USM_ITEM_TYPE_RADIO_BOX;
            USMDepth2Language[USM_LANGUAGE_ENGLISH].CurUSMFunc           = USM_LanguageEnglish;
        }
        break;
    default:
        break;
    }
    
}
