/******************************************************************************
  DoCAN_ISO15765.h
ISO 15765 淶涨Ϸͷļ
    ߣ
    V1.0
    ڣ2016.7.18
******************************************************************************/

/******************************************************************************
                         ϷOSIģӳ
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
         7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
         5      Session          ISO 14229-2
  *      4      Transport        ISO 15765-2
  *      3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/

#ifndef _DOCAN_ISO15765_H_
#define _DOCAN_ISO15765_H_

#include "TYW_stdint.h"
#include "DoCAN_ISO15765_Config.h"
#include "RTE_CAN.h"
//#pragma MESSAGE DISABLE C1106
/*-----------------------------------------------------------------------------
Transfer_Status
-----------------------------------------------------------------------------*/
#ifndef   DIAG_COMPLETE
#define DIAG_COMPLETE                 0x00u
#endif

#ifndef   DIAG_NOT_COMPLETE
#define   DIAG_NOT_COMPLETE           (!DIAG_COMPLETE)
#endif

/*-----------------------------------------------------------------------------
N_PDU 
-----------------------------------------------------------------------------*/
#define SINGLE_FRAME               0x00u
#define FIRST_FRAME                0x01u
#define CONSECUTIVE_FRAME          0x02u
#define FLOW_CONTROL               0x03u

/*-----------------------------------------------------------------------------
֡
-----------------------------------------------------------------------------*/
#define FC_FS_CTS                  0x00u
#define FC_FS_WAIT                 0x01u
#define FC_FS_OVFL                 0x02u

/*-----------------------------------------------------------------------------
ʱ
-----------------------------------------------------------------------------*/
#define TIMING_PARA_NONE           0X00u
#define TIMING_PARA_N_As           0X01u
#define TIMING_PARA_N_Ar           0X02u
#define TIMING_PARA_N_Bs           0X03u
#define TIMING_PARA_N_Br           0X04u
#define TIMING_PARA_N_Cs           0X05u
#define TIMING_PARA_N_Cr           0X06u

/*-----------------------------------------------------------------------------
STminʱ״̬
-----------------------------------------------------------------------------*/
#define STmin_TIMER_IDLE           0X00u         /*STminʱ*/
#define STmin_TIME_UP              0X01u         /*STminʱʱ䵽*/
#define STmin_TIMING               0X02u         /*STminʱʱ*/

/*-----------------------------------------------------------------------------
շ
-----------------------------------------------------------------------------*/
#define TP_DIR_MASK                0x80u         /*շ־λ*/
#define TP_RX                      0x00u         /*״̬*/
#define TP_TX                      0x80u         /*㷢״̬*/

#define TP_IDLE                    0x00u         /*Rx״̬*/
/*Tx״̬*/
#define TP_ERR                     0x01u         /*Rxϵͳ*/
/*Txϵͳ*/

#define TP_RX_INIT                 0x10u         /*Rxѽյ֡,ʼ֡*/
#define TP_TX_INIT                 0x90u         /*Txͳʼ,ڷ֡֡(עⵥ֡Ҳʹô˱־)*/
#define TP_RX_CTS                  0x11u         /*Rxջͻ֡(Clear To Send)*/
#define TP_TX_CTS                  0x91u         /*Txͻɷ֡(Clear To Send)*/

#define TP_RX_RTS                  0x20u         /*RxͶ֡(Request To Send)*/
#define TP_TX_RTS                  0xA0u         /*Txȴջɶ֡(Request To Send)*/
#define TP_RX_WAIT                 0x21u         /*Rxͻͣ*/
#define TP_TX_WAIT                 0xA1u         /*Txջȴ*/
#define TP_RX_OVFL                 0x22u         /*Rxջ*/
#define TP_TX_OVFL                 0xA2u         /*Txջ*/

/******************************************************************************
ṹ
******************************************************************************/

/*** ·֡ṹ ***/
typedef struct
{
    uint32_t            Identifier;          /*֡ID*/
    uint8_t             Data[8];             /*֡*/
    uint8_t             DLC;                 /*֡*/
} LinkDataStruct;

/*** ·FIFOṹ ***/
typedef struct
{
    LinkDataStruct      LinkData[LINK_RX_FIFO_MAX_DEPTH];
    uint8_t             Depth;        /*FIFO*/
    uint8_t             IPtr;         /*ָ*/
    uint8_t             OPtr;         /*ָ*/
} LinkRxFIFOStruct;

/*** ·㷢Ϳƽṹ ***/
typedef struct
{
    uint32_t            Identifier; /*֡ID*/
    uint8_t             Data[8];    /*֡*/
    uint8_t             Busy;       /*æ־*/
} LinkTxCtrlStruct;

/*---------------------------------------------------------------------------*/

/*** ֡ṹ ***/
typedef struct
{
    uint32_t            Identifier;
    uint8_t             Data[8];
    uint8_t             DLC;
    uint8_t             New;
} TP_Data_Struct;


/*** ͨN_PCIṹ ***/
typedef struct
{
    uint8_t  Rsvd      :  4;
    uint8_t  Type      :  4;
} TP_N_PCI_Struct;

/*** ͨN_PDUṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    TP_N_PCI_Struct     N_PCI;
    uint8_t             N_Data[7];
    uint8_t             DLC;
    uint8_t             New;
} TP_N_PDU_Struct;


/*** ֡N_PCIṹ ***/
typedef struct
{
    uint8_t  SF_DL     :  4;
    uint8_t  Type      :  4;
} TP_SF_N_PCI_Struct;

/*** ֡N_PDUṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    TP_SF_N_PCI_Struct  N_PCI;
    uint8_t             N_Data[7];
    uint8_t             DLC;
    uint8_t             New;
} TP_N_PDU_SF_Struct;


/*** ֡N_PCIṹ ***/
typedef struct
{
    uint8_t  FF_DL_H   :  4;
    uint8_t  Type      :  4;
    uint16_t FF_DL_L   :  8;
} TP_FF_N_PCI_Struct;

/*** ֡N_PDUṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    TP_FF_N_PCI_Struct  N_PCI;
    uint8_t             N_Data[6];
    uint8_t             DLC;
    uint8_t             New;
} TP_N_PDU_FF_Struct;


/*** ֡N_PCIṹ ***/
typedef struct
{
    uint8_t  SN        :  4;
    uint8_t  Type      :  4;
} TP_CF_N_PCI_Struct;

/*** ֡N_PDUṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    TP_CF_N_PCI_Struct  N_PCI;
    uint8_t             N_Data[7];
    uint8_t             DLC;
    uint8_t             New;
} TP_N_PDU_CF_Struct;


/*** ֡N_PCIṹ ***/
typedef struct
{
    uint8_t  FS        :  4;
    uint8_t  Type      :  4;
    uint8_t  BS        :  8;
    uint8_t  STmin     :  8;
} TP_FC_N_PCI_Struct;

/*** ֡N_PDUṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    TP_FC_N_PCI_Struct  N_PCI;
    uint8_t             N_Data[5];
    uint8_t             DLC;
    uint8_t             New;
} TP_N_PDU_FC_Struct;


/*** ݽ ***/
typedef union
{
    TP_Data_Struct      Frame;
    TP_N_PDU_Struct     N_PDU;
    TP_N_PDU_SF_Struct  N_PDU_SF;
    TP_N_PDU_FF_Struct  N_PDU_FF;
    TP_N_PDU_CF_Struct  N_PDU_CF;
    TP_N_PDU_FC_Struct  N_PDU_FC;
} TransportDataUnion;


/*** շƽṹ ***/
typedef struct
{
    uint8_t             Process;      /*ǰշ*/
    uint8_t             NonStopMode;  /*շģʽ(FC֡)*/
    uint16_t            Len;          /*ѽյѷͳݳ*/
    uint16_t            TotalLen;     /*ܳ*/
    uint16_t            BlockSize;    /*Block*/
    uint16_t            BlockCnt;     /*ѽյѷͳBlock*/
    uint8_t             BSMax;        /*ǰջʣBlock*/
    uint8_t             WFTCnt;       /*[]ȴ*/
    uint8_t             STmin;        /*[]ǰջҪСʱ*/
    uint8_t             TxReq;        /*[]*/
} TransportControlStruct;

/*** ʱƽṹ ***/
typedef struct
{
    uint16_t            Cnt;          /**/
    uint16_t            LastCnt;      /*ϴθʱĹ*/
    uint32_t            NTimer;       /*ʱʱ,λus*/
    uint32_t            STimer;       /*Сʱ(STmin)ʱ,λus*/
    uint8_t             Type;         /*ǰʱʱ*/
    uint8_t             STminStatus;  /*STminʱ״̬*/
} TransportTimingControlStruct;

/*---------------------------------------------------------------------------*/

/*** շN_Resultö ***/
typedef enum
{
    N_OK = 0,
    N_TIMEOUT_A,
    N_TIMEOUT_Bs,
    N_TIMEOUT_Cr,
    N_WRONG_SN,
    N_INVALID_FS,
    N_UNEXP_PDU,
    N_WFT_OVRN,
    N_BUFFER_OVFLW,
    N_ERROR,
} N_ResultEnum;

/*** N_USDataݽṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    uint16_t            Length;
    uint8_t             MsgData[N_USDATA_RX_BUFFER_SIZE];
} N_USDataRxStruct;

/*** N_USDataݽṹ ***/
typedef struct
{
    uint32_t            N_TAtype;
    uint16_t            Length;
    uint8_t             MsgData[N_USDATA_TX_BUFFER_SIZE];
} N_USDataTxStruct;

extern TransportTimingControlStruct  TpTimingCtrl;

/******************************************************************************

******************************************************************************/

/*-- ⲿӿں -----------------------------------------------------------*/

/*** ̨ ***/
void DoCAN_Communication_Service ( void );
extern void DoCAN_Timer_Update ( uint16_t Interval );

/*** ϲӿں ***/
void DoCAN_N_USData_Request( uint32_t N_TAtype, uint8_t MessageData[], uint16_t Length );
void DoCAN_N_USData_Confirm ( uint32_t N_TAtype, N_ResultEnum N_Result );
void DoCAN_N_USData_FF_Indication( uint32_t N_TAtype, uint16_t Length );
void DoCAN_N_USData_Indication( uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result );

/*** ·²ӿں ***/
void DoCAN_L_Data_Request ( uint32_t Identifier, uint8_t dlc, uint8_t Data[] );
void DoCAN_L_Data_Confirm ( uint32_t Identifier, uint8_t TransferStatus );
extern void DoCAN_L_Data_Indication ( uint32_t Identifier, uint8_t dlc, uint8_t pData[] );

extern void CAN_LLC_Ch5_Data_Request ( uint32_t Identifier, uint8_t DLC, uint8_t *Data );

/*-- ڲ ---------------------------------------------------------------*/

/*** Э ***/
void DoCAN_Receive_And_Assemble_N_USData ( void );      /**/
void DoCAN_Get_N_PDU ( void );
void DoCAN_Receive_Single_Frame_N_Data ( void );
void DoCAN_Receive_First_Frame_N_Data ( void );
void DoCAN_Receive_Consecutive_Frame_N_Data ( void );
void DoCAN_Receive_Flow_Control ( void );
void DoCAN_Transmit_Flow_Control ( void );
void DoCAN_Handle_Unknown_N_PDU ( void );
void DoCAN_Disassemble_And_Transmit_N_USData ( void );  /**/

/*** ʱ ***/
void DoCAN_Update_Timer ( void );
void DoCAN_Handle_Time_Out ( void );
void DoCAN_Start_Timer ( uint8_t TimingParameter );
void DoCAN_Stop_Timer ( void );
void DoCAN_Start_STmin_Timer ( uint8_t STminTime );
uint8_t DoCAN_Get_STmin_Timer_Status ( void );

void UDS_TP_ArTimeOutHandle(void);

#endif