/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_GPIO_H
#define __S6J3360_GPIO_H

#include "s6j3360io_basetypes.h"

/* GPIO base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define GPIO	stcGPIO
#else /* __IO_DEFINE */
#define GPIO	(*((volatile stc_gpio_t*)0xB4738000))
#endif /* __IO_DEFINE */

/* POSR[0-3] */
#define GPIO_POSR0	(GPIO.unPOSR0.u32Register)  /*@rg@*/
#define GPIO_POSR0_POS0	(*(volatile uint_io8_t*)0xB71C0000)  /*@bfbba@*/
#define GPIO_POSR0_POS1	(*(volatile uint_io8_t*)0xB71C0001)  /*@bfbba@*/
#define GPIO_POSR0_POS2	(*(volatile uint_io8_t*)0xB71C0002)  /*@bfbba@*/
#define GPIO_POSR0_POS3	(*(volatile uint_io8_t*)0xB71C0003)  /*@bfbba@*/
#define GPIO_POSR0_POS4	(*(volatile uint_io8_t*)0xB71C0004)  /*@bfbba@*/
#define GPIO_POSR0_POS5	(*(volatile uint_io8_t*)0xB71C0005)  /*@bfbba@*/
#define GPIO_POSR0_POS6	(*(volatile uint_io8_t*)0xB71C0006)  /*@bfbba@*/
#define GPIO_POSR0_POS7	(*(volatile uint_io8_t*)0xB71C0007)  /*@bfbba@*/
#define GPIO_POSR0_POS8	(*(volatile uint_io8_t*)0xB71C0008)  /*@bfbba@*/
#define GPIO_POSR0_POS9	(*(volatile uint_io8_t*)0xB71C0009)  /*@bfbba@*/
#define GPIO_POSR0_POS10	(*(volatile uint_io8_t*)0xB71C000A)  /*@bfbba@*/
#define GPIO_POSR0_POS11	(*(volatile uint_io8_t*)0xB71C000B)  /*@bfbba@*/
#define GPIO_POSR0_POS12	(*(volatile uint_io8_t*)0xB71C000C)  /*@bfbba@*/
#define GPIO_POSR0_POS13	(*(volatile uint_io8_t*)0xB71C000D)  /*@bfbba@*/
#define GPIO_POSR0_POS14	(*(volatile uint_io8_t*)0xB71C000E)  /*@bfbba@*/
#define GPIO_POSR0_POS15	(*(volatile uint_io8_t*)0xB71C000F)  /*@bfbba@*/
#define GPIO_POSR0_POS16	(*(volatile uint_io8_t*)0xB71C0010)  /*@bfbba@*/
#define GPIO_POSR0_POS17	(*(volatile uint_io8_t*)0xB71C0011)  /*@bfbba@*/
#define GPIO_POSR0_POS18	(*(volatile uint_io8_t*)0xB71C0012)  /*@bfbba@*/
#define GPIO_POSR0_POS19	(*(volatile uint_io8_t*)0xB71C0013)  /*@bfbba@*/
#define GPIO_POSR0_POS20	(*(volatile uint_io8_t*)0xB71C0014)  /*@bfbba@*/
#define GPIO_POSR0_POS21	(*(volatile uint_io8_t*)0xB71C0015)  /*@bfbba@*/
#define GPIO_POSR0_POS22	(*(volatile uint_io8_t*)0xB71C0016)  /*@bfbba@*/
#define GPIO_POSR0_POS23	(*(volatile uint_io8_t*)0xB71C0017)  /*@bfbba@*/
#define GPIO_POSR0_POS24	(*(volatile uint_io8_t*)0xB71C0018)  /*@bfbba@*/
#define GPIO_POSR0_POS25	(*(volatile uint_io8_t*)0xB71C0019)  /*@bfbba@*/
#define GPIO_POSR0_POS26	(*(volatile uint_io8_t*)0xB71C001A)  /*@bfbba@*/
#define GPIO_POSR0_POS27	(*(volatile uint_io8_t*)0xB71C001B)  /*@bfbba@*/
#define GPIO_POSR0_POS28	(*(volatile uint_io8_t*)0xB71C001C)  /*@bfbba@*/
#define GPIO_POSR0_POS29	(*(volatile uint_io8_t*)0xB71C001D)  /*@bfbba@*/
#define GPIO_POSR0_POS30	(*(volatile uint_io8_t*)0xB71C001E)  /*@bfbba@*/
#define GPIO_POSR0_POS31	(*(volatile uint_io8_t*)0xB71C001F)  /*@bfbba@*/

#define GPIO_POSR1	(GPIO.unPOSR1.u32Register)  /*@rg@*/
#define GPIO_POSR1_POS0	(*(volatile uint_io8_t*)0xB71C0080)  /*@bfbba@*/
#define GPIO_POSR1_POS1	(*(volatile uint_io8_t*)0xB71C0081)  /*@bfbba@*/
#define GPIO_POSR1_POS2	(*(volatile uint_io8_t*)0xB71C0082)  /*@bfbba@*/
#define GPIO_POSR1_POS3	(*(volatile uint_io8_t*)0xB71C0083)  /*@bfbba@*/
#define GPIO_POSR1_POS4	(*(volatile uint_io8_t*)0xB71C0084)  /*@bfbba@*/
#define GPIO_POSR1_POS5	(*(volatile uint_io8_t*)0xB71C0085)  /*@bfbba@*/
#define GPIO_POSR1_POS6	(*(volatile uint_io8_t*)0xB71C0086)  /*@bfbba@*/
#define GPIO_POSR1_POS7	(*(volatile uint_io8_t*)0xB71C0087)  /*@bfbba@*/
#define GPIO_POSR1_POS8	(*(volatile uint_io8_t*)0xB71C0088)  /*@bfbba@*/
#define GPIO_POSR1_POS9	(*(volatile uint_io8_t*)0xB71C0089)  /*@bfbba@*/
#define GPIO_POSR1_POS10	(*(volatile uint_io8_t*)0xB71C008A)  /*@bfbba@*/
#define GPIO_POSR1_POS11	(*(volatile uint_io8_t*)0xB71C008B)  /*@bfbba@*/
#define GPIO_POSR1_POS12	(*(volatile uint_io8_t*)0xB71C008C)  /*@bfbba@*/
#define GPIO_POSR1_POS13	(*(volatile uint_io8_t*)0xB71C008D)  /*@bfbba@*/
#define GPIO_POSR1_POS14	(*(volatile uint_io8_t*)0xB71C008E)  /*@bfbba@*/
#define GPIO_POSR1_POS15	(*(volatile uint_io8_t*)0xB71C008F)  /*@bfbba@*/
#define GPIO_POSR1_POS16	(*(volatile uint_io8_t*)0xB71C0090)  /*@bfbba@*/
#define GPIO_POSR1_POS17	(*(volatile uint_io8_t*)0xB71C0091)  /*@bfbba@*/
#define GPIO_POSR1_POS18	(*(volatile uint_io8_t*)0xB71C0092)  /*@bfbba@*/
#define GPIO_POSR1_POS19	(*(volatile uint_io8_t*)0xB71C0093)  /*@bfbba@*/
#define GPIO_POSR1_POS20	(*(volatile uint_io8_t*)0xB71C0094)  /*@bfbba@*/
#define GPIO_POSR1_POS21	(*(volatile uint_io8_t*)0xB71C0095)  /*@bfbba@*/
#define GPIO_POSR1_POS22	(*(volatile uint_io8_t*)0xB71C0096)  /*@bfbba@*/
#define GPIO_POSR1_POS23	(*(volatile uint_io8_t*)0xB71C0097)  /*@bfbba@*/
#define GPIO_POSR1_POS24	(*(volatile uint_io8_t*)0xB71C0098)  /*@bfbba@*/
#define GPIO_POSR1_POS25	(*(volatile uint_io8_t*)0xB71C0099)  /*@bfbba@*/
#define GPIO_POSR1_POS26	(*(volatile uint_io8_t*)0xB71C009A)  /*@bfbba@*/
#define GPIO_POSR1_POS27	(*(volatile uint_io8_t*)0xB71C009B)  /*@bfbba@*/
#define GPIO_POSR1_POS28	(*(volatile uint_io8_t*)0xB71C009C)  /*@bfbba@*/
#define GPIO_POSR1_POS29	(*(volatile uint_io8_t*)0xB71C009D)  /*@bfbba@*/
#define GPIO_POSR1_POS30	(*(volatile uint_io8_t*)0xB71C009E)  /*@bfbba@*/
#define GPIO_POSR1_POS31	(*(volatile uint_io8_t*)0xB71C009F)  /*@bfbba@*/

#define GPIO_POSR2	(GPIO.unPOSR2.u32Register)  /*@rg@*/
#define GPIO_POSR2_POS0	(*(volatile uint_io8_t*)0xB71C0100)  /*@bfbba@*/
#define GPIO_POSR2_POS1	(*(volatile uint_io8_t*)0xB71C0101)  /*@bfbba@*/
#define GPIO_POSR2_POS2	(*(volatile uint_io8_t*)0xB71C0102)  /*@bfbba@*/
#define GPIO_POSR2_POS3	(*(volatile uint_io8_t*)0xB71C0103)  /*@bfbba@*/
#define GPIO_POSR2_POS4	(*(volatile uint_io8_t*)0xB71C0104)  /*@bfbba@*/
#define GPIO_POSR2_POS5	(*(volatile uint_io8_t*)0xB71C0105)  /*@bfbba@*/
#define GPIO_POSR2_POS6	(*(volatile uint_io8_t*)0xB71C0106)  /*@bfbba@*/
#define GPIO_POSR2_POS7	(*(volatile uint_io8_t*)0xB71C0107)  /*@bfbba@*/
#define GPIO_POSR2_POS8	(*(volatile uint_io8_t*)0xB71C0108)  /*@bfbba@*/
#define GPIO_POSR2_POS9	(*(volatile uint_io8_t*)0xB71C0109)  /*@bfbba@*/
#define GPIO_POSR2_POS10	(*(volatile uint_io8_t*)0xB71C010A)  /*@bfbba@*/
#define GPIO_POSR2_POS11	(*(volatile uint_io8_t*)0xB71C010B)  /*@bfbba@*/
#define GPIO_POSR2_POS12	(*(volatile uint_io8_t*)0xB71C010C)  /*@bfbba@*/
#define GPIO_POSR2_POS13	(*(volatile uint_io8_t*)0xB71C010D)  /*@bfbba@*/
#define GPIO_POSR2_POS14	(*(volatile uint_io8_t*)0xB71C010E)  /*@bfbba@*/
#define GPIO_POSR2_POS15	(*(volatile uint_io8_t*)0xB71C010F)  /*@bfbba@*/
#define GPIO_POSR2_POS16	(*(volatile uint_io8_t*)0xB71C0110)  /*@bfbba@*/
#define GPIO_POSR2_POS17	(*(volatile uint_io8_t*)0xB71C0111)  /*@bfbba@*/
#define GPIO_POSR2_POS18	(*(volatile uint_io8_t*)0xB71C0112)  /*@bfbba@*/
#define GPIO_POSR2_POS19	(*(volatile uint_io8_t*)0xB71C0113)  /*@bfbba@*/
#define GPIO_POSR2_POS20	(*(volatile uint_io8_t*)0xB71C0114)  /*@bfbba@*/
#define GPIO_POSR2_POS21	(*(volatile uint_io8_t*)0xB71C0115)  /*@bfbba@*/
#define GPIO_POSR2_POS22	(*(volatile uint_io8_t*)0xB71C0116)  /*@bfbba@*/
#define GPIO_POSR2_POS23	(*(volatile uint_io8_t*)0xB71C0117)  /*@bfbba@*/
#define GPIO_POSR2_POS24	(*(volatile uint_io8_t*)0xB71C0118)  /*@bfbba@*/
#define GPIO_POSR2_POS25	(*(volatile uint_io8_t*)0xB71C0119)  /*@bfbba@*/
#define GPIO_POSR2_POS26	(*(volatile uint_io8_t*)0xB71C011A)  /*@bfbba@*/
#define GPIO_POSR2_POS27	(*(volatile uint_io8_t*)0xB71C011B)  /*@bfbba@*/
#define GPIO_POSR2_POS28	(*(volatile uint_io8_t*)0xB71C011C)  /*@bfbba@*/
#define GPIO_POSR2_POS29	(*(volatile uint_io8_t*)0xB71C011D)  /*@bfbba@*/
#define GPIO_POSR2_POS30	(*(volatile uint_io8_t*)0xB71C011E)  /*@bfbba@*/
#define GPIO_POSR2_POS31	(*(volatile uint_io8_t*)0xB71C011F)  /*@bfbba@*/

#define GPIO_POSR3	(GPIO.unPOSR3.u32Register)  /*@rg@*/
#define GPIO_POSR3_POS0	(*(volatile uint_io8_t*)0xB71C0180)  /*@bfbba@*/
#define GPIO_POSR3_POS1	(*(volatile uint_io8_t*)0xB71C0181)  /*@bfbba@*/
#define GPIO_POSR3_POS2	(*(volatile uint_io8_t*)0xB71C0182)  /*@bfbba@*/
#define GPIO_POSR3_POS3	(*(volatile uint_io8_t*)0xB71C0183)  /*@bfbba@*/
#define GPIO_POSR3_POS4	(*(volatile uint_io8_t*)0xB71C0184)  /*@bfbba@*/
#define GPIO_POSR3_POS5	(*(volatile uint_io8_t*)0xB71C0185)  /*@bfbba@*/
#define GPIO_POSR3_POS6	(*(volatile uint_io8_t*)0xB71C0186)  /*@bfbba@*/
#define GPIO_POSR3_POS7	(*(volatile uint_io8_t*)0xB71C0187)  /*@bfbba@*/
#define GPIO_POSR3_POS8	(*(volatile uint_io8_t*)0xB71C0188)  /*@bfbba@*/
#define GPIO_POSR3_POS9	(*(volatile uint_io8_t*)0xB71C0189)  /*@bfbba@*/
#define GPIO_POSR3_POS10	(*(volatile uint_io8_t*)0xB71C018A)  /*@bfbba@*/
#define GPIO_POSR3_POS11	(*(volatile uint_io8_t*)0xB71C018B)  /*@bfbba@*/
#define GPIO_POSR3_POS12	(*(volatile uint_io8_t*)0xB71C018C)  /*@bfbba@*/
#define GPIO_POSR3_POS13	(*(volatile uint_io8_t*)0xB71C018D)  /*@bfbba@*/
#define GPIO_POSR3_POS14	(*(volatile uint_io8_t*)0xB71C018E)  /*@bfbba@*/
#define GPIO_POSR3_POS15	(*(volatile uint_io8_t*)0xB71C018F)  /*@bfbba@*/
#define GPIO_POSR3_POS16	(*(volatile uint_io8_t*)0xB71C0190)  /*@bfbba@*/
#define GPIO_POSR3_POS17	(*(volatile uint_io8_t*)0xB71C0191)  /*@bfbba@*/
#define GPIO_POSR3_POS18	(*(volatile uint_io8_t*)0xB71C0192)  /*@bfbba@*/
#define GPIO_POSR3_POS19	(*(volatile uint_io8_t*)0xB71C0193)  /*@bfbba@*/
#define GPIO_POSR3_POS20	(*(volatile uint_io8_t*)0xB71C0194)  /*@bfbba@*/
#define GPIO_POSR3_POS21	(*(volatile uint_io8_t*)0xB71C0195)  /*@bfbba@*/
#define GPIO_POSR3_POS22	(*(volatile uint_io8_t*)0xB71C0196)  /*@bfbba@*/
#define GPIO_POSR3_POS23	(*(volatile uint_io8_t*)0xB71C0197)  /*@bfbba@*/
#define GPIO_POSR3_POS24	(*(volatile uint_io8_t*)0xB71C0198)  /*@bfbba@*/
#define GPIO_POSR3_POS25	(*(volatile uint_io8_t*)0xB71C0199)  /*@bfbba@*/
#define GPIO_POSR3_POS26	(*(volatile uint_io8_t*)0xB71C019A)  /*@bfbba@*/
#define GPIO_POSR3_POS27	(*(volatile uint_io8_t*)0xB71C019B)  /*@bfbba@*/
#define GPIO_POSR3_POS28	(*(volatile uint_io8_t*)0xB71C019C)  /*@bfbba@*/
#define GPIO_POSR3_POS29	(*(volatile uint_io8_t*)0xB71C019D)  /*@bfbba@*/
#define GPIO_POSR3_POS30	(*(volatile uint_io8_t*)0xB71C019E)  /*@bfbba@*/
#define GPIO_POSR3_POS31	(*(volatile uint_io8_t*)0xB71C019F)  /*@bfbba@*/

typedef struct stc_gpio_posrn_field{
    uint_io32_t		u1POS0:1;
    uint_io32_t		u1POS1:1;
    uint_io32_t		u1POS2:1;
    uint_io32_t		u1POS3:1;
    uint_io32_t		u1POS4:1;
    uint_io32_t		u1POS5:1;
    uint_io32_t		u1POS6:1;
    uint_io32_t		u1POS7:1;
    uint_io32_t		u1POS8:1;
    uint_io32_t		u1POS9:1;
    uint_io32_t		u1POS10:1;
    uint_io32_t		u1POS11:1;
    uint_io32_t		u1POS12:1;
    uint_io32_t		u1POS13:1;
    uint_io32_t		u1POS14:1;
    uint_io32_t		u1POS15:1;
    uint_io32_t		u1POS16:1;
    uint_io32_t		u1POS17:1;
    uint_io32_t		u1POS18:1;
    uint_io32_t		u1POS19:1;
    uint_io32_t		u1POS20:1;
    uint_io32_t		u1POS21:1;
    uint_io32_t		u1POS22:1;
    uint_io32_t		u1POS23:1;
    uint_io32_t		u1POS24:1;
    uint_io32_t		u1POS25:1;
    uint_io32_t		u1POS26:1;
    uint_io32_t		u1POS27:1;
    uint_io32_t		u1POS28:1;
    uint_io32_t		u1POS29:1;
    uint_io32_t		u1POS30:1;
    uint_io32_t		u1POS31:1;
}stc_gpio_posrn_field_t;

typedef union un_gpio_posrn{
    uint_io32_t		u32Register;
    stc_gpio_posrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_posrn_t;

/* POCR[0-3] */
#define GPIO_POCR0	(GPIO.unPOCR0.u32Register)  /*@rg@*/
#define GPIO_POCR0_POC0	(*(volatile uint_io8_t*)0xB71C0020)  /*@bfbba@*/
#define GPIO_POCR0_POC1	(*(volatile uint_io8_t*)0xB71C0021)  /*@bfbba@*/
#define GPIO_POCR0_POC2	(*(volatile uint_io8_t*)0xB71C0022)  /*@bfbba@*/
#define GPIO_POCR0_POC3	(*(volatile uint_io8_t*)0xB71C0023)  /*@bfbba@*/
#define GPIO_POCR0_POC4	(*(volatile uint_io8_t*)0xB71C0024)  /*@bfbba@*/
#define GPIO_POCR0_POC5	(*(volatile uint_io8_t*)0xB71C0025)  /*@bfbba@*/
#define GPIO_POCR0_POC6	(*(volatile uint_io8_t*)0xB71C0026)  /*@bfbba@*/
#define GPIO_POCR0_POC7	(*(volatile uint_io8_t*)0xB71C0027)  /*@bfbba@*/
#define GPIO_POCR0_POC8	(*(volatile uint_io8_t*)0xB71C0028)  /*@bfbba@*/
#define GPIO_POCR0_POC9	(*(volatile uint_io8_t*)0xB71C0029)  /*@bfbba@*/
#define GPIO_POCR0_POC10	(*(volatile uint_io8_t*)0xB71C002A)  /*@bfbba@*/
#define GPIO_POCR0_POC11	(*(volatile uint_io8_t*)0xB71C002B)  /*@bfbba@*/
#define GPIO_POCR0_POC12	(*(volatile uint_io8_t*)0xB71C002C)  /*@bfbba@*/
#define GPIO_POCR0_POC13	(*(volatile uint_io8_t*)0xB71C002D)  /*@bfbba@*/
#define GPIO_POCR0_POC14	(*(volatile uint_io8_t*)0xB71C002E)  /*@bfbba@*/
#define GPIO_POCR0_POC15	(*(volatile uint_io8_t*)0xB71C002F)  /*@bfbba@*/
#define GPIO_POCR0_POC16	(*(volatile uint_io8_t*)0xB71C0030)  /*@bfbba@*/
#define GPIO_POCR0_POC17	(*(volatile uint_io8_t*)0xB71C0031)  /*@bfbba@*/
#define GPIO_POCR0_POC18	(*(volatile uint_io8_t*)0xB71C0032)  /*@bfbba@*/
#define GPIO_POCR0_POC19	(*(volatile uint_io8_t*)0xB71C0033)  /*@bfbba@*/
#define GPIO_POCR0_POC20	(*(volatile uint_io8_t*)0xB71C0034)  /*@bfbba@*/
#define GPIO_POCR0_POC21	(*(volatile uint_io8_t*)0xB71C0035)  /*@bfbba@*/
#define GPIO_POCR0_POC22	(*(volatile uint_io8_t*)0xB71C0036)  /*@bfbba@*/
#define GPIO_POCR0_POC23	(*(volatile uint_io8_t*)0xB71C0037)  /*@bfbba@*/
#define GPIO_POCR0_POC24	(*(volatile uint_io8_t*)0xB71C0038)  /*@bfbba@*/
#define GPIO_POCR0_POC25	(*(volatile uint_io8_t*)0xB71C0039)  /*@bfbba@*/
#define GPIO_POCR0_POC26	(*(volatile uint_io8_t*)0xB71C003A)  /*@bfbba@*/
#define GPIO_POCR0_POC27	(*(volatile uint_io8_t*)0xB71C003B)  /*@bfbba@*/
#define GPIO_POCR0_POC28	(*(volatile uint_io8_t*)0xB71C003C)  /*@bfbba@*/
#define GPIO_POCR0_POC29	(*(volatile uint_io8_t*)0xB71C003D)  /*@bfbba@*/
#define GPIO_POCR0_POC30	(*(volatile uint_io8_t*)0xB71C003E)  /*@bfbba@*/
#define GPIO_POCR0_POC31	(*(volatile uint_io8_t*)0xB71C003F)  /*@bfbba@*/

#define GPIO_POCR1	(GPIO.unPOCR1.u32Register)  /*@rg@*/
#define GPIO_POCR1_POC0	(*(volatile uint_io8_t*)0xB71C00A0)  /*@bfbba@*/
#define GPIO_POCR1_POC1	(*(volatile uint_io8_t*)0xB71C00A1)  /*@bfbba@*/
#define GPIO_POCR1_POC2	(*(volatile uint_io8_t*)0xB71C00A2)  /*@bfbba@*/
#define GPIO_POCR1_POC3	(*(volatile uint_io8_t*)0xB71C00A3)  /*@bfbba@*/
#define GPIO_POCR1_POC4	(*(volatile uint_io8_t*)0xB71C00A4)  /*@bfbba@*/
#define GPIO_POCR1_POC5	(*(volatile uint_io8_t*)0xB71C00A5)  /*@bfbba@*/
#define GPIO_POCR1_POC6	(*(volatile uint_io8_t*)0xB71C00A6)  /*@bfbba@*/
#define GPIO_POCR1_POC7	(*(volatile uint_io8_t*)0xB71C00A7)  /*@bfbba@*/
#define GPIO_POCR1_POC8	(*(volatile uint_io8_t*)0xB71C00A8)  /*@bfbba@*/
#define GPIO_POCR1_POC9	(*(volatile uint_io8_t*)0xB71C00A9)  /*@bfbba@*/
#define GPIO_POCR1_POC10	(*(volatile uint_io8_t*)0xB71C00AA)  /*@bfbba@*/
#define GPIO_POCR1_POC11	(*(volatile uint_io8_t*)0xB71C00AB)  /*@bfbba@*/
#define GPIO_POCR1_POC12	(*(volatile uint_io8_t*)0xB71C00AC)  /*@bfbba@*/
#define GPIO_POCR1_POC13	(*(volatile uint_io8_t*)0xB71C00AD)  /*@bfbba@*/
#define GPIO_POCR1_POC14	(*(volatile uint_io8_t*)0xB71C00AE)  /*@bfbba@*/
#define GPIO_POCR1_POC15	(*(volatile uint_io8_t*)0xB71C00AF)  /*@bfbba@*/
#define GPIO_POCR1_POC16	(*(volatile uint_io8_t*)0xB71C00B0)  /*@bfbba@*/
#define GPIO_POCR1_POC17	(*(volatile uint_io8_t*)0xB71C00B1)  /*@bfbba@*/
#define GPIO_POCR1_POC18	(*(volatile uint_io8_t*)0xB71C00B2)  /*@bfbba@*/
#define GPIO_POCR1_POC19	(*(volatile uint_io8_t*)0xB71C00B3)  /*@bfbba@*/
#define GPIO_POCR1_POC20	(*(volatile uint_io8_t*)0xB71C00B4)  /*@bfbba@*/
#define GPIO_POCR1_POC21	(*(volatile uint_io8_t*)0xB71C00B5)  /*@bfbba@*/
#define GPIO_POCR1_POC22	(*(volatile uint_io8_t*)0xB71C00B6)  /*@bfbba@*/
#define GPIO_POCR1_POC23	(*(volatile uint_io8_t*)0xB71C00B7)  /*@bfbba@*/
#define GPIO_POCR1_POC24	(*(volatile uint_io8_t*)0xB71C00B8)  /*@bfbba@*/
#define GPIO_POCR1_POC25	(*(volatile uint_io8_t*)0xB71C00B9)  /*@bfbba@*/
#define GPIO_POCR1_POC26	(*(volatile uint_io8_t*)0xB71C00BA)  /*@bfbba@*/
#define GPIO_POCR1_POC27	(*(volatile uint_io8_t*)0xB71C00BB)  /*@bfbba@*/
#define GPIO_POCR1_POC28	(*(volatile uint_io8_t*)0xB71C00BC)  /*@bfbba@*/
#define GPIO_POCR1_POC29	(*(volatile uint_io8_t*)0xB71C00BD)  /*@bfbba@*/
#define GPIO_POCR1_POC30	(*(volatile uint_io8_t*)0xB71C00BE)  /*@bfbba@*/
#define GPIO_POCR1_POC31	(*(volatile uint_io8_t*)0xB71C00BF)  /*@bfbba@*/

#define GPIO_POCR2	(GPIO.unPOCR2.u32Register)  /*@rg@*/
#define GPIO_POCR2_POC0	(*(volatile uint_io8_t*)0xB71C0120)  /*@bfbba@*/
#define GPIO_POCR2_POC1	(*(volatile uint_io8_t*)0xB71C0121)  /*@bfbba@*/
#define GPIO_POCR2_POC2	(*(volatile uint_io8_t*)0xB71C0122)  /*@bfbba@*/
#define GPIO_POCR2_POC3	(*(volatile uint_io8_t*)0xB71C0123)  /*@bfbba@*/
#define GPIO_POCR2_POC4	(*(volatile uint_io8_t*)0xB71C0124)  /*@bfbba@*/
#define GPIO_POCR2_POC5	(*(volatile uint_io8_t*)0xB71C0125)  /*@bfbba@*/
#define GPIO_POCR2_POC6	(*(volatile uint_io8_t*)0xB71C0126)  /*@bfbba@*/
#define GPIO_POCR2_POC7	(*(volatile uint_io8_t*)0xB71C0127)  /*@bfbba@*/
#define GPIO_POCR2_POC8	(*(volatile uint_io8_t*)0xB71C0128)  /*@bfbba@*/
#define GPIO_POCR2_POC9	(*(volatile uint_io8_t*)0xB71C0129)  /*@bfbba@*/
#define GPIO_POCR2_POC10	(*(volatile uint_io8_t*)0xB71C012A)  /*@bfbba@*/
#define GPIO_POCR2_POC11	(*(volatile uint_io8_t*)0xB71C012B)  /*@bfbba@*/
#define GPIO_POCR2_POC12	(*(volatile uint_io8_t*)0xB71C012C)  /*@bfbba@*/
#define GPIO_POCR2_POC13	(*(volatile uint_io8_t*)0xB71C012D)  /*@bfbba@*/
#define GPIO_POCR2_POC14	(*(volatile uint_io8_t*)0xB71C012E)  /*@bfbba@*/
#define GPIO_POCR2_POC15	(*(volatile uint_io8_t*)0xB71C012F)  /*@bfbba@*/
#define GPIO_POCR2_POC16	(*(volatile uint_io8_t*)0xB71C0130)  /*@bfbba@*/
#define GPIO_POCR2_POC17	(*(volatile uint_io8_t*)0xB71C0131)  /*@bfbba@*/
#define GPIO_POCR2_POC18	(*(volatile uint_io8_t*)0xB71C0132)  /*@bfbba@*/
#define GPIO_POCR2_POC19	(*(volatile uint_io8_t*)0xB71C0133)  /*@bfbba@*/
#define GPIO_POCR2_POC20	(*(volatile uint_io8_t*)0xB71C0134)  /*@bfbba@*/
#define GPIO_POCR2_POC21	(*(volatile uint_io8_t*)0xB71C0135)  /*@bfbba@*/
#define GPIO_POCR2_POC22	(*(volatile uint_io8_t*)0xB71C0136)  /*@bfbba@*/
#define GPIO_POCR2_POC23	(*(volatile uint_io8_t*)0xB71C0137)  /*@bfbba@*/
#define GPIO_POCR2_POC24	(*(volatile uint_io8_t*)0xB71C0138)  /*@bfbba@*/
#define GPIO_POCR2_POC25	(*(volatile uint_io8_t*)0xB71C0139)  /*@bfbba@*/
#define GPIO_POCR2_POC26	(*(volatile uint_io8_t*)0xB71C013A)  /*@bfbba@*/
#define GPIO_POCR2_POC27	(*(volatile uint_io8_t*)0xB71C013B)  /*@bfbba@*/
#define GPIO_POCR2_POC28	(*(volatile uint_io8_t*)0xB71C013C)  /*@bfbba@*/
#define GPIO_POCR2_POC29	(*(volatile uint_io8_t*)0xB71C013D)  /*@bfbba@*/
#define GPIO_POCR2_POC30	(*(volatile uint_io8_t*)0xB71C013E)  /*@bfbba@*/
#define GPIO_POCR2_POC31	(*(volatile uint_io8_t*)0xB71C013F)  /*@bfbba@*/

#define GPIO_POCR3	(GPIO.unPOCR3.u32Register)  /*@rg@*/
#define GPIO_POCR3_POC0	(*(volatile uint_io8_t*)0xB71C01A0)  /*@bfbba@*/
#define GPIO_POCR3_POC1	(*(volatile uint_io8_t*)0xB71C01A1)  /*@bfbba@*/
#define GPIO_POCR3_POC2	(*(volatile uint_io8_t*)0xB71C01A2)  /*@bfbba@*/
#define GPIO_POCR3_POC3	(*(volatile uint_io8_t*)0xB71C01A3)  /*@bfbba@*/
#define GPIO_POCR3_POC4	(*(volatile uint_io8_t*)0xB71C01A4)  /*@bfbba@*/
#define GPIO_POCR3_POC5	(*(volatile uint_io8_t*)0xB71C01A5)  /*@bfbba@*/
#define GPIO_POCR3_POC6	(*(volatile uint_io8_t*)0xB71C01A6)  /*@bfbba@*/
#define GPIO_POCR3_POC7	(*(volatile uint_io8_t*)0xB71C01A7)  /*@bfbba@*/
#define GPIO_POCR3_POC8	(*(volatile uint_io8_t*)0xB71C01A8)  /*@bfbba@*/
#define GPIO_POCR3_POC9	(*(volatile uint_io8_t*)0xB71C01A9)  /*@bfbba@*/
#define GPIO_POCR3_POC10	(*(volatile uint_io8_t*)0xB71C01AA)  /*@bfbba@*/
#define GPIO_POCR3_POC11	(*(volatile uint_io8_t*)0xB71C01AB)  /*@bfbba@*/
#define GPIO_POCR3_POC12	(*(volatile uint_io8_t*)0xB71C01AC)  /*@bfbba@*/
#define GPIO_POCR3_POC13	(*(volatile uint_io8_t*)0xB71C01AD)  /*@bfbba@*/
#define GPIO_POCR3_POC14	(*(volatile uint_io8_t*)0xB71C01AE)  /*@bfbba@*/
#define GPIO_POCR3_POC15	(*(volatile uint_io8_t*)0xB71C01AF)  /*@bfbba@*/
#define GPIO_POCR3_POC16	(*(volatile uint_io8_t*)0xB71C01B0)  /*@bfbba@*/
#define GPIO_POCR3_POC17	(*(volatile uint_io8_t*)0xB71C01B1)  /*@bfbba@*/
#define GPIO_POCR3_POC18	(*(volatile uint_io8_t*)0xB71C01B2)  /*@bfbba@*/
#define GPIO_POCR3_POC19	(*(volatile uint_io8_t*)0xB71C01B3)  /*@bfbba@*/
#define GPIO_POCR3_POC20	(*(volatile uint_io8_t*)0xB71C01B4)  /*@bfbba@*/
#define GPIO_POCR3_POC21	(*(volatile uint_io8_t*)0xB71C01B5)  /*@bfbba@*/
#define GPIO_POCR3_POC22	(*(volatile uint_io8_t*)0xB71C01B6)  /*@bfbba@*/
#define GPIO_POCR3_POC23	(*(volatile uint_io8_t*)0xB71C01B7)  /*@bfbba@*/
#define GPIO_POCR3_POC24	(*(volatile uint_io8_t*)0xB71C01B8)  /*@bfbba@*/
#define GPIO_POCR3_POC25	(*(volatile uint_io8_t*)0xB71C01B9)  /*@bfbba@*/
#define GPIO_POCR3_POC26	(*(volatile uint_io8_t*)0xB71C01BA)  /*@bfbba@*/
#define GPIO_POCR3_POC27	(*(volatile uint_io8_t*)0xB71C01BB)  /*@bfbba@*/
#define GPIO_POCR3_POC28	(*(volatile uint_io8_t*)0xB71C01BC)  /*@bfbba@*/
#define GPIO_POCR3_POC29	(*(volatile uint_io8_t*)0xB71C01BD)  /*@bfbba@*/
#define GPIO_POCR3_POC30	(*(volatile uint_io8_t*)0xB71C01BE)  /*@bfbba@*/
#define GPIO_POCR3_POC31	(*(volatile uint_io8_t*)0xB71C01BF)  /*@bfbba@*/

typedef struct stc_gpio_pocrn_field{
    uint_io32_t		u1POC0:1;
    uint_io32_t		u1POC1:1;
    uint_io32_t		u1POC2:1;
    uint_io32_t		u1POC3:1;
    uint_io32_t		u1POC4:1;
    uint_io32_t		u1POC5:1;
    uint_io32_t		u1POC6:1;
    uint_io32_t		u1POC7:1;
    uint_io32_t		u1POC8:1;
    uint_io32_t		u1POC9:1;
    uint_io32_t		u1POC10:1;
    uint_io32_t		u1POC11:1;
    uint_io32_t		u1POC12:1;
    uint_io32_t		u1POC13:1;
    uint_io32_t		u1POC14:1;
    uint_io32_t		u1POC15:1;
    uint_io32_t		u1POC16:1;
    uint_io32_t		u1POC17:1;
    uint_io32_t		u1POC18:1;
    uint_io32_t		u1POC19:1;
    uint_io32_t		u1POC20:1;
    uint_io32_t		u1POC21:1;
    uint_io32_t		u1POC22:1;
    uint_io32_t		u1POC23:1;
    uint_io32_t		u1POC24:1;
    uint_io32_t		u1POC25:1;
    uint_io32_t		u1POC26:1;
    uint_io32_t		u1POC27:1;
    uint_io32_t		u1POC28:1;
    uint_io32_t		u1POC29:1;
    uint_io32_t		u1POC30:1;
    uint_io32_t		u1POC31:1;
}stc_gpio_pocrn_field_t;

typedef union un_gpio_pocrn{
    uint_io32_t		u32Register;
    stc_gpio_pocrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pocrn_t;

/* DDSR[0-3] */
#define GPIO_DDSR0	(GPIO.unDDSR0.u32Register)  /*@rg@*/
#define GPIO_DDSR0_DDS0	(*(volatile uint_io8_t*)0xB71C0040)  /*@bfbba@*/
#define GPIO_DDSR0_DDS1	(*(volatile uint_io8_t*)0xB71C0041)  /*@bfbba@*/
#define GPIO_DDSR0_DDS2	(*(volatile uint_io8_t*)0xB71C0042)  /*@bfbba@*/
#define GPIO_DDSR0_DDS3	(*(volatile uint_io8_t*)0xB71C0043)  /*@bfbba@*/
#define GPIO_DDSR0_DDS4	(*(volatile uint_io8_t*)0xB71C0044)  /*@bfbba@*/
#define GPIO_DDSR0_DDS5	(*(volatile uint_io8_t*)0xB71C0045)  /*@bfbba@*/
#define GPIO_DDSR0_DDS6	(*(volatile uint_io8_t*)0xB71C0046)  /*@bfbba@*/
#define GPIO_DDSR0_DDS7	(*(volatile uint_io8_t*)0xB71C0047)  /*@bfbba@*/
#define GPIO_DDSR0_DDS8	(*(volatile uint_io8_t*)0xB71C0048)  /*@bfbba@*/
#define GPIO_DDSR0_DDS9	(*(volatile uint_io8_t*)0xB71C0049)  /*@bfbba@*/
#define GPIO_DDSR0_DDS10	(*(volatile uint_io8_t*)0xB71C004A)  /*@bfbba@*/
#define GPIO_DDSR0_DDS11	(*(volatile uint_io8_t*)0xB71C004B)  /*@bfbba@*/
#define GPIO_DDSR0_DDS12	(*(volatile uint_io8_t*)0xB71C004C)  /*@bfbba@*/
#define GPIO_DDSR0_DDS13	(*(volatile uint_io8_t*)0xB71C004D)  /*@bfbba@*/
#define GPIO_DDSR0_DDS14	(*(volatile uint_io8_t*)0xB71C004E)  /*@bfbba@*/
#define GPIO_DDSR0_DDS15	(*(volatile uint_io8_t*)0xB71C004F)  /*@bfbba@*/
#define GPIO_DDSR0_DDS16	(*(volatile uint_io8_t*)0xB71C0050)  /*@bfbba@*/
#define GPIO_DDSR0_DDS17	(*(volatile uint_io8_t*)0xB71C0051)  /*@bfbba@*/
#define GPIO_DDSR0_DDS18	(*(volatile uint_io8_t*)0xB71C0052)  /*@bfbba@*/
#define GPIO_DDSR0_DDS19	(*(volatile uint_io8_t*)0xB71C0053)  /*@bfbba@*/
#define GPIO_DDSR0_DDS20	(*(volatile uint_io8_t*)0xB71C0054)  /*@bfbba@*/
#define GPIO_DDSR0_DDS21	(*(volatile uint_io8_t*)0xB71C0055)  /*@bfbba@*/
#define GPIO_DDSR0_DDS22	(*(volatile uint_io8_t*)0xB71C0056)  /*@bfbba@*/
#define GPIO_DDSR0_DDS23	(*(volatile uint_io8_t*)0xB71C0057)  /*@bfbba@*/
#define GPIO_DDSR0_DDS24	(*(volatile uint_io8_t*)0xB71C0058)  /*@bfbba@*/
#define GPIO_DDSR0_DDS25	(*(volatile uint_io8_t*)0xB71C0059)  /*@bfbba@*/
#define GPIO_DDSR0_DDS26	(*(volatile uint_io8_t*)0xB71C005A)  /*@bfbba@*/
#define GPIO_DDSR0_DDS27	(*(volatile uint_io8_t*)0xB71C005B)  /*@bfbba@*/
#define GPIO_DDSR0_DDS28	(*(volatile uint_io8_t*)0xB71C005C)  /*@bfbba@*/
#define GPIO_DDSR0_DDS29	(*(volatile uint_io8_t*)0xB71C005D)  /*@bfbba@*/
#define GPIO_DDSR0_DDS30	(*(volatile uint_io8_t*)0xB71C005E)  /*@bfbba@*/
#define GPIO_DDSR0_DDS31	(*(volatile uint_io8_t*)0xB71C005F)  /*@bfbba@*/

#define GPIO_DDSR1	(GPIO.unDDSR1.u32Register)  /*@rg@*/
#define GPIO_DDSR1_DDS0	(*(volatile uint_io8_t*)0xB71C00C0)  /*@bfbba@*/
#define GPIO_DDSR1_DDS1	(*(volatile uint_io8_t*)0xB71C00C1)  /*@bfbba@*/
#define GPIO_DDSR1_DDS2	(*(volatile uint_io8_t*)0xB71C00C2)  /*@bfbba@*/
#define GPIO_DDSR1_DDS3	(*(volatile uint_io8_t*)0xB71C00C3)  /*@bfbba@*/
#define GPIO_DDSR1_DDS4	(*(volatile uint_io8_t*)0xB71C00C4)  /*@bfbba@*/
#define GPIO_DDSR1_DDS5	(*(volatile uint_io8_t*)0xB71C00C5)  /*@bfbba@*/
#define GPIO_DDSR1_DDS6	(*(volatile uint_io8_t*)0xB71C00C6)  /*@bfbba@*/
#define GPIO_DDSR1_DDS7	(*(volatile uint_io8_t*)0xB71C00C7)  /*@bfbba@*/
#define GPIO_DDSR1_DDS8	(*(volatile uint_io8_t*)0xB71C00C8)  /*@bfbba@*/
#define GPIO_DDSR1_DDS9	(*(volatile uint_io8_t*)0xB71C00C9)  /*@bfbba@*/
#define GPIO_DDSR1_DDS10	(*(volatile uint_io8_t*)0xB71C00CA)  /*@bfbba@*/
#define GPIO_DDSR1_DDS11	(*(volatile uint_io8_t*)0xB71C00CB)  /*@bfbba@*/
#define GPIO_DDSR1_DDS12	(*(volatile uint_io8_t*)0xB71C00CC)  /*@bfbba@*/
#define GPIO_DDSR1_DDS13	(*(volatile uint_io8_t*)0xB71C00CD)  /*@bfbba@*/
#define GPIO_DDSR1_DDS14	(*(volatile uint_io8_t*)0xB71C00CE)  /*@bfbba@*/
#define GPIO_DDSR1_DDS15	(*(volatile uint_io8_t*)0xB71C00CF)  /*@bfbba@*/
#define GPIO_DDSR1_DDS16	(*(volatile uint_io8_t*)0xB71C00D0)  /*@bfbba@*/
#define GPIO_DDSR1_DDS17	(*(volatile uint_io8_t*)0xB71C00D1)  /*@bfbba@*/
#define GPIO_DDSR1_DDS18	(*(volatile uint_io8_t*)0xB71C00D2)  /*@bfbba@*/
#define GPIO_DDSR1_DDS19	(*(volatile uint_io8_t*)0xB71C00D3)  /*@bfbba@*/
#define GPIO_DDSR1_DDS20	(*(volatile uint_io8_t*)0xB71C00D4)  /*@bfbba@*/
#define GPIO_DDSR1_DDS21	(*(volatile uint_io8_t*)0xB71C00D5)  /*@bfbba@*/
#define GPIO_DDSR1_DDS22	(*(volatile uint_io8_t*)0xB71C00D6)  /*@bfbba@*/
#define GPIO_DDSR1_DDS23	(*(volatile uint_io8_t*)0xB71C00D7)  /*@bfbba@*/
#define GPIO_DDSR1_DDS24	(*(volatile uint_io8_t*)0xB71C00D8)  /*@bfbba@*/
#define GPIO_DDSR1_DDS25	(*(volatile uint_io8_t*)0xB71C00D9)  /*@bfbba@*/
#define GPIO_DDSR1_DDS26	(*(volatile uint_io8_t*)0xB71C00DA)  /*@bfbba@*/
#define GPIO_DDSR1_DDS27	(*(volatile uint_io8_t*)0xB71C00DB)  /*@bfbba@*/
#define GPIO_DDSR1_DDS28	(*(volatile uint_io8_t*)0xB71C00DC)  /*@bfbba@*/
#define GPIO_DDSR1_DDS29	(*(volatile uint_io8_t*)0xB71C00DD)  /*@bfbba@*/
#define GPIO_DDSR1_DDS30	(*(volatile uint_io8_t*)0xB71C00DE)  /*@bfbba@*/
#define GPIO_DDSR1_DDS31	(*(volatile uint_io8_t*)0xB71C00DF)  /*@bfbba@*/

#define GPIO_DDSR2	(GPIO.unDDSR2.u32Register)  /*@rg@*/
#define GPIO_DDSR2_DDS0	(*(volatile uint_io8_t*)0xB71C0140)  /*@bfbba@*/
#define GPIO_DDSR2_DDS1	(*(volatile uint_io8_t*)0xB71C0141)  /*@bfbba@*/
#define GPIO_DDSR2_DDS2	(*(volatile uint_io8_t*)0xB71C0142)  /*@bfbba@*/
#define GPIO_DDSR2_DDS3	(*(volatile uint_io8_t*)0xB71C0143)  /*@bfbba@*/
#define GPIO_DDSR2_DDS4	(*(volatile uint_io8_t*)0xB71C0144)  /*@bfbba@*/
#define GPIO_DDSR2_DDS5	(*(volatile uint_io8_t*)0xB71C0145)  /*@bfbba@*/
#define GPIO_DDSR2_DDS6	(*(volatile uint_io8_t*)0xB71C0146)  /*@bfbba@*/
#define GPIO_DDSR2_DDS7	(*(volatile uint_io8_t*)0xB71C0147)  /*@bfbba@*/
#define GPIO_DDSR2_DDS8	(*(volatile uint_io8_t*)0xB71C0148)  /*@bfbba@*/
#define GPIO_DDSR2_DDS9	(*(volatile uint_io8_t*)0xB71C0149)  /*@bfbba@*/
#define GPIO_DDSR2_DDS10	(*(volatile uint_io8_t*)0xB71C014A)  /*@bfbba@*/
#define GPIO_DDSR2_DDS11	(*(volatile uint_io8_t*)0xB71C014B)  /*@bfbba@*/
#define GPIO_DDSR2_DDS12	(*(volatile uint_io8_t*)0xB71C014C)  /*@bfbba@*/
#define GPIO_DDSR2_DDS13	(*(volatile uint_io8_t*)0xB71C014D)  /*@bfbba@*/
#define GPIO_DDSR2_DDS14	(*(volatile uint_io8_t*)0xB71C014E)  /*@bfbba@*/
#define GPIO_DDSR2_DDS15	(*(volatile uint_io8_t*)0xB71C014F)  /*@bfbba@*/
#define GPIO_DDSR2_DDS16	(*(volatile uint_io8_t*)0xB71C0150)  /*@bfbba@*/
#define GPIO_DDSR2_DDS17	(*(volatile uint_io8_t*)0xB71C0151)  /*@bfbba@*/
#define GPIO_DDSR2_DDS18	(*(volatile uint_io8_t*)0xB71C0152)  /*@bfbba@*/
#define GPIO_DDSR2_DDS19	(*(volatile uint_io8_t*)0xB71C0153)  /*@bfbba@*/
#define GPIO_DDSR2_DDS20	(*(volatile uint_io8_t*)0xB71C0154)  /*@bfbba@*/
#define GPIO_DDSR2_DDS21	(*(volatile uint_io8_t*)0xB71C0155)  /*@bfbba@*/
#define GPIO_DDSR2_DDS22	(*(volatile uint_io8_t*)0xB71C0156)  /*@bfbba@*/
#define GPIO_DDSR2_DDS23	(*(volatile uint_io8_t*)0xB71C0157)  /*@bfbba@*/
#define GPIO_DDSR2_DDS24	(*(volatile uint_io8_t*)0xB71C0158)  /*@bfbba@*/
#define GPIO_DDSR2_DDS25	(*(volatile uint_io8_t*)0xB71C0159)  /*@bfbba@*/
#define GPIO_DDSR2_DDS26	(*(volatile uint_io8_t*)0xB71C015A)  /*@bfbba@*/
#define GPIO_DDSR2_DDS27	(*(volatile uint_io8_t*)0xB71C015B)  /*@bfbba@*/
#define GPIO_DDSR2_DDS28	(*(volatile uint_io8_t*)0xB71C015C)  /*@bfbba@*/
#define GPIO_DDSR2_DDS29	(*(volatile uint_io8_t*)0xB71C015D)  /*@bfbba@*/
#define GPIO_DDSR2_DDS30	(*(volatile uint_io8_t*)0xB71C015E)  /*@bfbba@*/
#define GPIO_DDSR2_DDS31	(*(volatile uint_io8_t*)0xB71C015F)  /*@bfbba@*/

#define GPIO_DDSR3	(GPIO.unDDSR3.u32Register)  /*@rg@*/
#define GPIO_DDSR3_DDS0	(*(volatile uint_io8_t*)0xB71C01C0)  /*@bfbba@*/
#define GPIO_DDSR3_DDS1	(*(volatile uint_io8_t*)0xB71C01C1)  /*@bfbba@*/
#define GPIO_DDSR3_DDS2	(*(volatile uint_io8_t*)0xB71C01C2)  /*@bfbba@*/
#define GPIO_DDSR3_DDS3	(*(volatile uint_io8_t*)0xB71C01C3)  /*@bfbba@*/
#define GPIO_DDSR3_DDS4	(*(volatile uint_io8_t*)0xB71C01C4)  /*@bfbba@*/
#define GPIO_DDSR3_DDS5	(*(volatile uint_io8_t*)0xB71C01C5)  /*@bfbba@*/
#define GPIO_DDSR3_DDS6	(*(volatile uint_io8_t*)0xB71C01C6)  /*@bfbba@*/
#define GPIO_DDSR3_DDS7	(*(volatile uint_io8_t*)0xB71C01C7)  /*@bfbba@*/
#define GPIO_DDSR3_DDS8	(*(volatile uint_io8_t*)0xB71C01C8)  /*@bfbba@*/
#define GPIO_DDSR3_DDS9	(*(volatile uint_io8_t*)0xB71C01C9)  /*@bfbba@*/
#define GPIO_DDSR3_DDS10	(*(volatile uint_io8_t*)0xB71C01CA)  /*@bfbba@*/
#define GPIO_DDSR3_DDS11	(*(volatile uint_io8_t*)0xB71C01CB)  /*@bfbba@*/
#define GPIO_DDSR3_DDS12	(*(volatile uint_io8_t*)0xB71C01CC)  /*@bfbba@*/
#define GPIO_DDSR3_DDS13	(*(volatile uint_io8_t*)0xB71C01CD)  /*@bfbba@*/
#define GPIO_DDSR3_DDS14	(*(volatile uint_io8_t*)0xB71C01CE)  /*@bfbba@*/
#define GPIO_DDSR3_DDS15	(*(volatile uint_io8_t*)0xB71C01CF)  /*@bfbba@*/
#define GPIO_DDSR3_DDS16	(*(volatile uint_io8_t*)0xB71C01D0)  /*@bfbba@*/
#define GPIO_DDSR3_DDS17	(*(volatile uint_io8_t*)0xB71C01D1)  /*@bfbba@*/
#define GPIO_DDSR3_DDS18	(*(volatile uint_io8_t*)0xB71C01D2)  /*@bfbba@*/
#define GPIO_DDSR3_DDS19	(*(volatile uint_io8_t*)0xB71C01D3)  /*@bfbba@*/
#define GPIO_DDSR3_DDS20	(*(volatile uint_io8_t*)0xB71C01D4)  /*@bfbba@*/
#define GPIO_DDSR3_DDS21	(*(volatile uint_io8_t*)0xB71C01D5)  /*@bfbba@*/
#define GPIO_DDSR3_DDS22	(*(volatile uint_io8_t*)0xB71C01D6)  /*@bfbba@*/
#define GPIO_DDSR3_DDS23	(*(volatile uint_io8_t*)0xB71C01D7)  /*@bfbba@*/
#define GPIO_DDSR3_DDS24	(*(volatile uint_io8_t*)0xB71C01D8)  /*@bfbba@*/
#define GPIO_DDSR3_DDS25	(*(volatile uint_io8_t*)0xB71C01D9)  /*@bfbba@*/
#define GPIO_DDSR3_DDS26	(*(volatile uint_io8_t*)0xB71C01DA)  /*@bfbba@*/
#define GPIO_DDSR3_DDS27	(*(volatile uint_io8_t*)0xB71C01DB)  /*@bfbba@*/
#define GPIO_DDSR3_DDS28	(*(volatile uint_io8_t*)0xB71C01DC)  /*@bfbba@*/
#define GPIO_DDSR3_DDS29	(*(volatile uint_io8_t*)0xB71C01DD)  /*@bfbba@*/
#define GPIO_DDSR3_DDS30	(*(volatile uint_io8_t*)0xB71C01DE)  /*@bfbba@*/
#define GPIO_DDSR3_DDS31	(*(volatile uint_io8_t*)0xB71C01DF)  /*@bfbba@*/

typedef struct stc_gpio_ddsrn_field{
    uint_io32_t		u1DDS0:1;
    uint_io32_t		u1DDS1:1;
    uint_io32_t		u1DDS2:1;
    uint_io32_t		u1DDS3:1;
    uint_io32_t		u1DDS4:1;
    uint_io32_t		u1DDS5:1;
    uint_io32_t		u1DDS6:1;
    uint_io32_t		u1DDS7:1;
    uint_io32_t		u1DDS8:1;
    uint_io32_t		u1DDS9:1;
    uint_io32_t		u1DDS10:1;
    uint_io32_t		u1DDS11:1;
    uint_io32_t		u1DDS12:1;
    uint_io32_t		u1DDS13:1;
    uint_io32_t		u1DDS14:1;
    uint_io32_t		u1DDS15:1;
    uint_io32_t		u1DDS16:1;
    uint_io32_t		u1DDS17:1;
    uint_io32_t		u1DDS18:1;
    uint_io32_t		u1DDS19:1;
    uint_io32_t		u1DDS20:1;
    uint_io32_t		u1DDS21:1;
    uint_io32_t		u1DDS22:1;
    uint_io32_t		u1DDS23:1;
    uint_io32_t		u1DDS24:1;
    uint_io32_t		u1DDS25:1;
    uint_io32_t		u1DDS26:1;
    uint_io32_t		u1DDS27:1;
    uint_io32_t		u1DDS28:1;
    uint_io32_t		u1DDS29:1;
    uint_io32_t		u1DDS30:1;
    uint_io32_t		u1DDS31:1;
}stc_gpio_ddsrn_field_t;

typedef union un_gpio_ddsrn{
    uint_io32_t		u32Register;
    stc_gpio_ddsrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddsrn_t;

/* DDCR[0-3] */
#define GPIO_DDCR0	(GPIO.unDDCR0.u32Register)  /*@rg@*/
#define GPIO_DDCR0_DDC0	(*(volatile uint_io8_t*)0xB71C0060)  /*@bfbba@*/
#define GPIO_DDCR0_DDC1	(*(volatile uint_io8_t*)0xB71C0061)  /*@bfbba@*/
#define GPIO_DDCR0_DDC2	(*(volatile uint_io8_t*)0xB71C0062)  /*@bfbba@*/
#define GPIO_DDCR0_DDC3	(*(volatile uint_io8_t*)0xB71C0063)  /*@bfbba@*/
#define GPIO_DDCR0_DDC4	(*(volatile uint_io8_t*)0xB71C0064)  /*@bfbba@*/
#define GPIO_DDCR0_DDC5	(*(volatile uint_io8_t*)0xB71C0065)  /*@bfbba@*/
#define GPIO_DDCR0_DDC6	(*(volatile uint_io8_t*)0xB71C0066)  /*@bfbba@*/
#define GPIO_DDCR0_DDC7	(*(volatile uint_io8_t*)0xB71C0067)  /*@bfbba@*/
#define GPIO_DDCR0_DDC8	(*(volatile uint_io8_t*)0xB71C0068)  /*@bfbba@*/
#define GPIO_DDCR0_DDC9	(*(volatile uint_io8_t*)0xB71C0069)  /*@bfbba@*/
#define GPIO_DDCR0_DDC10	(*(volatile uint_io8_t*)0xB71C006A)  /*@bfbba@*/
#define GPIO_DDCR0_DDC11	(*(volatile uint_io8_t*)0xB71C006B)  /*@bfbba@*/
#define GPIO_DDCR0_DDC12	(*(volatile uint_io8_t*)0xB71C006C)  /*@bfbba@*/
#define GPIO_DDCR0_DDC13	(*(volatile uint_io8_t*)0xB71C006D)  /*@bfbba@*/
#define GPIO_DDCR0_DDC14	(*(volatile uint_io8_t*)0xB71C006E)  /*@bfbba@*/
#define GPIO_DDCR0_DDC15	(*(volatile uint_io8_t*)0xB71C006F)  /*@bfbba@*/
#define GPIO_DDCR0_DDC16	(*(volatile uint_io8_t*)0xB71C0070)  /*@bfbba@*/
#define GPIO_DDCR0_DDC17	(*(volatile uint_io8_t*)0xB71C0071)  /*@bfbba@*/
#define GPIO_DDCR0_DDC18	(*(volatile uint_io8_t*)0xB71C0072)  /*@bfbba@*/
#define GPIO_DDCR0_DDC19	(*(volatile uint_io8_t*)0xB71C0073)  /*@bfbba@*/
#define GPIO_DDCR0_DDC20	(*(volatile uint_io8_t*)0xB71C0074)  /*@bfbba@*/
#define GPIO_DDCR0_DDC21	(*(volatile uint_io8_t*)0xB71C0075)  /*@bfbba@*/
#define GPIO_DDCR0_DDC22	(*(volatile uint_io8_t*)0xB71C0076)  /*@bfbba@*/
#define GPIO_DDCR0_DDC23	(*(volatile uint_io8_t*)0xB71C0077)  /*@bfbba@*/
#define GPIO_DDCR0_DDC24	(*(volatile uint_io8_t*)0xB71C0078)  /*@bfbba@*/
#define GPIO_DDCR0_DDC25	(*(volatile uint_io8_t*)0xB71C0079)  /*@bfbba@*/
#define GPIO_DDCR0_DDC26	(*(volatile uint_io8_t*)0xB71C007A)  /*@bfbba@*/
#define GPIO_DDCR0_DDC27	(*(volatile uint_io8_t*)0xB71C007B)  /*@bfbba@*/
#define GPIO_DDCR0_DDC28	(*(volatile uint_io8_t*)0xB71C007C)  /*@bfbba@*/
#define GPIO_DDCR0_DDC29	(*(volatile uint_io8_t*)0xB71C007D)  /*@bfbba@*/
#define GPIO_DDCR0_DDC30	(*(volatile uint_io8_t*)0xB71C007E)  /*@bfbba@*/
#define GPIO_DDCR0_DDC31	(*(volatile uint_io8_t*)0xB71C007F)  /*@bfbba@*/

#define GPIO_DDCR1	(GPIO.unDDCR1.u32Register)  /*@rg@*/
#define GPIO_DDCR1_DDC0	(*(volatile uint_io8_t*)0xB71C00E0)  /*@bfbba@*/
#define GPIO_DDCR1_DDC1	(*(volatile uint_io8_t*)0xB71C00E1)  /*@bfbba@*/
#define GPIO_DDCR1_DDC2	(*(volatile uint_io8_t*)0xB71C00E2)  /*@bfbba@*/
#define GPIO_DDCR1_DDC3	(*(volatile uint_io8_t*)0xB71C00E3)  /*@bfbba@*/
#define GPIO_DDCR1_DDC4	(*(volatile uint_io8_t*)0xB71C00E4)  /*@bfbba@*/
#define GPIO_DDCR1_DDC5	(*(volatile uint_io8_t*)0xB71C00E5)  /*@bfbba@*/
#define GPIO_DDCR1_DDC6	(*(volatile uint_io8_t*)0xB71C00E6)  /*@bfbba@*/
#define GPIO_DDCR1_DDC7	(*(volatile uint_io8_t*)0xB71C00E7)  /*@bfbba@*/
#define GPIO_DDCR1_DDC8	(*(volatile uint_io8_t*)0xB71C00E8)  /*@bfbba@*/
#define GPIO_DDCR1_DDC9	(*(volatile uint_io8_t*)0xB71C00E9)  /*@bfbba@*/
#define GPIO_DDCR1_DDC10	(*(volatile uint_io8_t*)0xB71C00EA)  /*@bfbba@*/
#define GPIO_DDCR1_DDC11	(*(volatile uint_io8_t*)0xB71C00EB)  /*@bfbba@*/
#define GPIO_DDCR1_DDC12	(*(volatile uint_io8_t*)0xB71C00EC)  /*@bfbba@*/
#define GPIO_DDCR1_DDC13	(*(volatile uint_io8_t*)0xB71C00ED)  /*@bfbba@*/
#define GPIO_DDCR1_DDC14	(*(volatile uint_io8_t*)0xB71C00EE)  /*@bfbba@*/
#define GPIO_DDCR1_DDC15	(*(volatile uint_io8_t*)0xB71C00EF)  /*@bfbba@*/
#define GPIO_DDCR1_DDC16	(*(volatile uint_io8_t*)0xB71C00F0)  /*@bfbba@*/
#define GPIO_DDCR1_DDC17	(*(volatile uint_io8_t*)0xB71C00F1)  /*@bfbba@*/
#define GPIO_DDCR1_DDC18	(*(volatile uint_io8_t*)0xB71C00F2)  /*@bfbba@*/
#define GPIO_DDCR1_DDC19	(*(volatile uint_io8_t*)0xB71C00F3)  /*@bfbba@*/
#define GPIO_DDCR1_DDC20	(*(volatile uint_io8_t*)0xB71C00F4)  /*@bfbba@*/
#define GPIO_DDCR1_DDC21	(*(volatile uint_io8_t*)0xB71C00F5)  /*@bfbba@*/
#define GPIO_DDCR1_DDC22	(*(volatile uint_io8_t*)0xB71C00F6)  /*@bfbba@*/
#define GPIO_DDCR1_DDC23	(*(volatile uint_io8_t*)0xB71C00F7)  /*@bfbba@*/
#define GPIO_DDCR1_DDC24	(*(volatile uint_io8_t*)0xB71C00F8)  /*@bfbba@*/
#define GPIO_DDCR1_DDC25	(*(volatile uint_io8_t*)0xB71C00F9)  /*@bfbba@*/
#define GPIO_DDCR1_DDC26	(*(volatile uint_io8_t*)0xB71C00FA)  /*@bfbba@*/
#define GPIO_DDCR1_DDC27	(*(volatile uint_io8_t*)0xB71C00FB)  /*@bfbba@*/
#define GPIO_DDCR1_DDC28	(*(volatile uint_io8_t*)0xB71C00FC)  /*@bfbba@*/
#define GPIO_DDCR1_DDC29	(*(volatile uint_io8_t*)0xB71C00FD)  /*@bfbba@*/
#define GPIO_DDCR1_DDC30	(*(volatile uint_io8_t*)0xB71C00FE)  /*@bfbba@*/
#define GPIO_DDCR1_DDC31	(*(volatile uint_io8_t*)0xB71C00FF)  /*@bfbba@*/

#define GPIO_DDCR2	(GPIO.unDDCR2.u32Register)  /*@rg@*/
#define GPIO_DDCR2_DDC0	(*(volatile uint_io8_t*)0xB71C0160)  /*@bfbba@*/
#define GPIO_DDCR2_DDC1	(*(volatile uint_io8_t*)0xB71C0161)  /*@bfbba@*/
#define GPIO_DDCR2_DDC2	(*(volatile uint_io8_t*)0xB71C0162)  /*@bfbba@*/
#define GPIO_DDCR2_DDC3	(*(volatile uint_io8_t*)0xB71C0163)  /*@bfbba@*/
#define GPIO_DDCR2_DDC4	(*(volatile uint_io8_t*)0xB71C0164)  /*@bfbba@*/
#define GPIO_DDCR2_DDC5	(*(volatile uint_io8_t*)0xB71C0165)  /*@bfbba@*/
#define GPIO_DDCR2_DDC6	(*(volatile uint_io8_t*)0xB71C0166)  /*@bfbba@*/
#define GPIO_DDCR2_DDC7	(*(volatile uint_io8_t*)0xB71C0167)  /*@bfbba@*/
#define GPIO_DDCR2_DDC8	(*(volatile uint_io8_t*)0xB71C0168)  /*@bfbba@*/
#define GPIO_DDCR2_DDC9	(*(volatile uint_io8_t*)0xB71C0169)  /*@bfbba@*/
#define GPIO_DDCR2_DDC10	(*(volatile uint_io8_t*)0xB71C016A)  /*@bfbba@*/
#define GPIO_DDCR2_DDC11	(*(volatile uint_io8_t*)0xB71C016B)  /*@bfbba@*/
#define GPIO_DDCR2_DDC12	(*(volatile uint_io8_t*)0xB71C016C)  /*@bfbba@*/
#define GPIO_DDCR2_DDC13	(*(volatile uint_io8_t*)0xB71C016D)  /*@bfbba@*/
#define GPIO_DDCR2_DDC14	(*(volatile uint_io8_t*)0xB71C016E)  /*@bfbba@*/
#define GPIO_DDCR2_DDC15	(*(volatile uint_io8_t*)0xB71C016F)  /*@bfbba@*/
#define GPIO_DDCR2_DDC16	(*(volatile uint_io8_t*)0xB71C0170)  /*@bfbba@*/
#define GPIO_DDCR2_DDC17	(*(volatile uint_io8_t*)0xB71C0171)  /*@bfbba@*/
#define GPIO_DDCR2_DDC18	(*(volatile uint_io8_t*)0xB71C0172)  /*@bfbba@*/
#define GPIO_DDCR2_DDC19	(*(volatile uint_io8_t*)0xB71C0173)  /*@bfbba@*/
#define GPIO_DDCR2_DDC20	(*(volatile uint_io8_t*)0xB71C0174)  /*@bfbba@*/
#define GPIO_DDCR2_DDC21	(*(volatile uint_io8_t*)0xB71C0175)  /*@bfbba@*/
#define GPIO_DDCR2_DDC22	(*(volatile uint_io8_t*)0xB71C0176)  /*@bfbba@*/
#define GPIO_DDCR2_DDC23	(*(volatile uint_io8_t*)0xB71C0177)  /*@bfbba@*/
#define GPIO_DDCR2_DDC24	(*(volatile uint_io8_t*)0xB71C0178)  /*@bfbba@*/
#define GPIO_DDCR2_DDC25	(*(volatile uint_io8_t*)0xB71C0179)  /*@bfbba@*/
#define GPIO_DDCR2_DDC26	(*(volatile uint_io8_t*)0xB71C017A)  /*@bfbba@*/
#define GPIO_DDCR2_DDC27	(*(volatile uint_io8_t*)0xB71C017B)  /*@bfbba@*/
#define GPIO_DDCR2_DDC28	(*(volatile uint_io8_t*)0xB71C017C)  /*@bfbba@*/
#define GPIO_DDCR2_DDC29	(*(volatile uint_io8_t*)0xB71C017D)  /*@bfbba@*/
#define GPIO_DDCR2_DDC30	(*(volatile uint_io8_t*)0xB71C017E)  /*@bfbba@*/
#define GPIO_DDCR2_DDC31	(*(volatile uint_io8_t*)0xB71C017F)  /*@bfbba@*/

#define GPIO_DDCR3	(GPIO.unDDCR3.u32Register)  /*@rg@*/
#define GPIO_DDCR3_DDC0	(*(volatile uint_io8_t*)0xB71C01E0)  /*@bfbba@*/
#define GPIO_DDCR3_DDC1	(*(volatile uint_io8_t*)0xB71C01E1)  /*@bfbba@*/
#define GPIO_DDCR3_DDC2	(*(volatile uint_io8_t*)0xB71C01E2)  /*@bfbba@*/
#define GPIO_DDCR3_DDC3	(*(volatile uint_io8_t*)0xB71C01E3)  /*@bfbba@*/
#define GPIO_DDCR3_DDC4	(*(volatile uint_io8_t*)0xB71C01E4)  /*@bfbba@*/
#define GPIO_DDCR3_DDC5	(*(volatile uint_io8_t*)0xB71C01E5)  /*@bfbba@*/
#define GPIO_DDCR3_DDC6	(*(volatile uint_io8_t*)0xB71C01E6)  /*@bfbba@*/
#define GPIO_DDCR3_DDC7	(*(volatile uint_io8_t*)0xB71C01E7)  /*@bfbba@*/
#define GPIO_DDCR3_DDC8	(*(volatile uint_io8_t*)0xB71C01E8)  /*@bfbba@*/
#define GPIO_DDCR3_DDC9	(*(volatile uint_io8_t*)0xB71C01E9)  /*@bfbba@*/
#define GPIO_DDCR3_DDC10	(*(volatile uint_io8_t*)0xB71C01EA)  /*@bfbba@*/
#define GPIO_DDCR3_DDC11	(*(volatile uint_io8_t*)0xB71C01EB)  /*@bfbba@*/
#define GPIO_DDCR3_DDC12	(*(volatile uint_io8_t*)0xB71C01EC)  /*@bfbba@*/
#define GPIO_DDCR3_DDC13	(*(volatile uint_io8_t*)0xB71C01ED)  /*@bfbba@*/
#define GPIO_DDCR3_DDC14	(*(volatile uint_io8_t*)0xB71C01EE)  /*@bfbba@*/
#define GPIO_DDCR3_DDC15	(*(volatile uint_io8_t*)0xB71C01EF)  /*@bfbba@*/
#define GPIO_DDCR3_DDC16	(*(volatile uint_io8_t*)0xB71C01F0)  /*@bfbba@*/
#define GPIO_DDCR3_DDC17	(*(volatile uint_io8_t*)0xB71C01F1)  /*@bfbba@*/
#define GPIO_DDCR3_DDC18	(*(volatile uint_io8_t*)0xB71C01F2)  /*@bfbba@*/
#define GPIO_DDCR3_DDC19	(*(volatile uint_io8_t*)0xB71C01F3)  /*@bfbba@*/
#define GPIO_DDCR3_DDC20	(*(volatile uint_io8_t*)0xB71C01F4)  /*@bfbba@*/
#define GPIO_DDCR3_DDC21	(*(volatile uint_io8_t*)0xB71C01F5)  /*@bfbba@*/
#define GPIO_DDCR3_DDC22	(*(volatile uint_io8_t*)0xB71C01F6)  /*@bfbba@*/
#define GPIO_DDCR3_DDC23	(*(volatile uint_io8_t*)0xB71C01F7)  /*@bfbba@*/
#define GPIO_DDCR3_DDC24	(*(volatile uint_io8_t*)0xB71C01F8)  /*@bfbba@*/
#define GPIO_DDCR3_DDC25	(*(volatile uint_io8_t*)0xB71C01F9)  /*@bfbba@*/
#define GPIO_DDCR3_DDC26	(*(volatile uint_io8_t*)0xB71C01FA)  /*@bfbba@*/
#define GPIO_DDCR3_DDC27	(*(volatile uint_io8_t*)0xB71C01FB)  /*@bfbba@*/
#define GPIO_DDCR3_DDC28	(*(volatile uint_io8_t*)0xB71C01FC)  /*@bfbba@*/
#define GPIO_DDCR3_DDC29	(*(volatile uint_io8_t*)0xB71C01FD)  /*@bfbba@*/
#define GPIO_DDCR3_DDC30	(*(volatile uint_io8_t*)0xB71C01FE)  /*@bfbba@*/
#define GPIO_DDCR3_DDC31	(*(volatile uint_io8_t*)0xB71C01FF)  /*@bfbba@*/

typedef struct stc_gpio_ddcrn_field{
    uint_io32_t		u1DDC0:1;
    uint_io32_t		u1DDC1:1;
    uint_io32_t		u1DDC2:1;
    uint_io32_t		u1DDC3:1;
    uint_io32_t		u1DDC4:1;
    uint_io32_t		u1DDC5:1;
    uint_io32_t		u1DDC6:1;
    uint_io32_t		u1DDC7:1;
    uint_io32_t		u1DDC8:1;
    uint_io32_t		u1DDC9:1;
    uint_io32_t		u1DDC10:1;
    uint_io32_t		u1DDC11:1;
    uint_io32_t		u1DDC12:1;
    uint_io32_t		u1DDC13:1;
    uint_io32_t		u1DDC14:1;
    uint_io32_t		u1DDC15:1;
    uint_io32_t		u1DDC16:1;
    uint_io32_t		u1DDC17:1;
    uint_io32_t		u1DDC18:1;
    uint_io32_t		u1DDC19:1;
    uint_io32_t		u1DDC20:1;
    uint_io32_t		u1DDC21:1;
    uint_io32_t		u1DDC22:1;
    uint_io32_t		u1DDC23:1;
    uint_io32_t		u1DDC24:1;
    uint_io32_t		u1DDC25:1;
    uint_io32_t		u1DDC26:1;
    uint_io32_t		u1DDC27:1;
    uint_io32_t		u1DDC28:1;
    uint_io32_t		u1DDC29:1;
    uint_io32_t		u1DDC30:1;
    uint_io32_t		u1DDC31:1;
}stc_gpio_ddcrn_field_t;

typedef union un_gpio_ddcrn{
    uint_io32_t		u32Register;
    stc_gpio_ddcrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddcrn_t;

/* PODR[0-3] */
#define GPIO_PODR0	(GPIO.unPODR0.u32Register)  /*@rg@*/
#define GPIO_PODR0_POD0	(*(volatile uint_io8_t*)0xB71C1000)  /*@bfbba@*/
#define GPIO_PODR0_POD1	(*(volatile uint_io8_t*)0xB71C1001)  /*@bfbba@*/
#define GPIO_PODR0_POD2	(*(volatile uint_io8_t*)0xB71C1002)  /*@bfbba@*/
#define GPIO_PODR0_POD3	(*(volatile uint_io8_t*)0xB71C1003)  /*@bfbba@*/
#define GPIO_PODR0_POD4	(*(volatile uint_io8_t*)0xB71C1004)  /*@bfbba@*/
#define GPIO_PODR0_POD5	(*(volatile uint_io8_t*)0xB71C1005)  /*@bfbba@*/
#define GPIO_PODR0_POD6	(*(volatile uint_io8_t*)0xB71C1006)  /*@bfbba@*/
#define GPIO_PODR0_POD7	(*(volatile uint_io8_t*)0xB71C1007)  /*@bfbba@*/
#define GPIO_PODR0_POD8	(*(volatile uint_io8_t*)0xB71C1008)  /*@bfbba@*/
#define GPIO_PODR0_POD9	(*(volatile uint_io8_t*)0xB71C1009)  /*@bfbba@*/
#define GPIO_PODR0_POD10	(*(volatile uint_io8_t*)0xB71C100A)  /*@bfbba@*/
#define GPIO_PODR0_POD11	(*(volatile uint_io8_t*)0xB71C100B)  /*@bfbba@*/
#define GPIO_PODR0_POD12	(*(volatile uint_io8_t*)0xB71C100C)  /*@bfbba@*/
#define GPIO_PODR0_POD13	(*(volatile uint_io8_t*)0xB71C100D)  /*@bfbba@*/
#define GPIO_PODR0_POD14	(*(volatile uint_io8_t*)0xB71C100E)  /*@bfbba@*/
#define GPIO_PODR0_POD15	(*(volatile uint_io8_t*)0xB71C100F)  /*@bfbba@*/
#define GPIO_PODR0_POD16	(*(volatile uint_io8_t*)0xB71C1010)  /*@bfbba@*/
#define GPIO_PODR0_POD17	(*(volatile uint_io8_t*)0xB71C1011)  /*@bfbba@*/
#define GPIO_PODR0_POD18	(*(volatile uint_io8_t*)0xB71C1012)  /*@bfbba@*/
#define GPIO_PODR0_POD19	(*(volatile uint_io8_t*)0xB71C1013)  /*@bfbba@*/
#define GPIO_PODR0_POD20	(*(volatile uint_io8_t*)0xB71C1014)  /*@bfbba@*/
#define GPIO_PODR0_POD21	(*(volatile uint_io8_t*)0xB71C1015)  /*@bfbba@*/
#define GPIO_PODR0_POD22	(*(volatile uint_io8_t*)0xB71C1016)  /*@bfbba@*/
#define GPIO_PODR0_POD23	(*(volatile uint_io8_t*)0xB71C1017)  /*@bfbba@*/
#define GPIO_PODR0_POD24	(*(volatile uint_io8_t*)0xB71C1018)  /*@bfbba@*/
#define GPIO_PODR0_POD25	(*(volatile uint_io8_t*)0xB71C1019)  /*@bfbba@*/
#define GPIO_PODR0_POD26	(*(volatile uint_io8_t*)0xB71C101A)  /*@bfbba@*/
#define GPIO_PODR0_POD27	(*(volatile uint_io8_t*)0xB71C101B)  /*@bfbba@*/
#define GPIO_PODR0_POD28	(*(volatile uint_io8_t*)0xB71C101C)  /*@bfbba@*/
#define GPIO_PODR0_POD29	(*(volatile uint_io8_t*)0xB71C101D)  /*@bfbba@*/
#define GPIO_PODR0_POD30	(*(volatile uint_io8_t*)0xB71C101E)  /*@bfbba@*/
#define GPIO_PODR0_POD31	(*(volatile uint_io8_t*)0xB71C101F)  /*@bfbba@*/

#define GPIO_PODR1	(GPIO.unPODR1.u32Register)  /*@rg@*/
#define GPIO_PODR1_POD0	(*(volatile uint_io8_t*)0xB71C1040)  /*@bfbba@*/
#define GPIO_PODR1_POD1	(*(volatile uint_io8_t*)0xB71C1041)  /*@bfbba@*/
#define GPIO_PODR1_POD2	(*(volatile uint_io8_t*)0xB71C1042)  /*@bfbba@*/
#define GPIO_PODR1_POD3	(*(volatile uint_io8_t*)0xB71C1043)  /*@bfbba@*/
#define GPIO_PODR1_POD4	(*(volatile uint_io8_t*)0xB71C1044)  /*@bfbba@*/
#define GPIO_PODR1_POD5	(*(volatile uint_io8_t*)0xB71C1045)  /*@bfbba@*/
#define GPIO_PODR1_POD6	(*(volatile uint_io8_t*)0xB71C1046)  /*@bfbba@*/
#define GPIO_PODR1_POD7	(*(volatile uint_io8_t*)0xB71C1047)  /*@bfbba@*/
#define GPIO_PODR1_POD8	(*(volatile uint_io8_t*)0xB71C1048)  /*@bfbba@*/
#define GPIO_PODR1_POD9	(*(volatile uint_io8_t*)0xB71C1049)  /*@bfbba@*/
#define GPIO_PODR1_POD10	(*(volatile uint_io8_t*)0xB71C104A)  /*@bfbba@*/
#define GPIO_PODR1_POD11	(*(volatile uint_io8_t*)0xB71C104B)  /*@bfbba@*/
#define GPIO_PODR1_POD12	(*(volatile uint_io8_t*)0xB71C104C)  /*@bfbba@*/
#define GPIO_PODR1_POD13	(*(volatile uint_io8_t*)0xB71C104D)  /*@bfbba@*/
#define GPIO_PODR1_POD14	(*(volatile uint_io8_t*)0xB71C104E)  /*@bfbba@*/
#define GPIO_PODR1_POD15	(*(volatile uint_io8_t*)0xB71C104F)  /*@bfbba@*/
#define GPIO_PODR1_POD16	(*(volatile uint_io8_t*)0xB71C1050)  /*@bfbba@*/
#define GPIO_PODR1_POD17	(*(volatile uint_io8_t*)0xB71C1051)  /*@bfbba@*/
#define GPIO_PODR1_POD18	(*(volatile uint_io8_t*)0xB71C1052)  /*@bfbba@*/
#define GPIO_PODR1_POD19	(*(volatile uint_io8_t*)0xB71C1053)  /*@bfbba@*/
#define GPIO_PODR1_POD20	(*(volatile uint_io8_t*)0xB71C1054)  /*@bfbba@*/
#define GPIO_PODR1_POD21	(*(volatile uint_io8_t*)0xB71C1055)  /*@bfbba@*/
#define GPIO_PODR1_POD22	(*(volatile uint_io8_t*)0xB71C1056)  /*@bfbba@*/
#define GPIO_PODR1_POD23	(*(volatile uint_io8_t*)0xB71C1057)  /*@bfbba@*/
#define GPIO_PODR1_POD24	(*(volatile uint_io8_t*)0xB71C1058)  /*@bfbba@*/
#define GPIO_PODR1_POD25	(*(volatile uint_io8_t*)0xB71C1059)  /*@bfbba@*/
#define GPIO_PODR1_POD26	(*(volatile uint_io8_t*)0xB71C105A)  /*@bfbba@*/
#define GPIO_PODR1_POD27	(*(volatile uint_io8_t*)0xB71C105B)  /*@bfbba@*/
#define GPIO_PODR1_POD28	(*(volatile uint_io8_t*)0xB71C105C)  /*@bfbba@*/
#define GPIO_PODR1_POD29	(*(volatile uint_io8_t*)0xB71C105D)  /*@bfbba@*/
#define GPIO_PODR1_POD30	(*(volatile uint_io8_t*)0xB71C105E)  /*@bfbba@*/
#define GPIO_PODR1_POD31	(*(volatile uint_io8_t*)0xB71C105F)  /*@bfbba@*/

#define GPIO_PODR2	(GPIO.unPODR2.u32Register)  /*@rg@*/
#define GPIO_PODR2_POD0	(*(volatile uint_io8_t*)0xB71C1080)  /*@bfbba@*/
#define GPIO_PODR2_POD1	(*(volatile uint_io8_t*)0xB71C1081)  /*@bfbba@*/
#define GPIO_PODR2_POD2	(*(volatile uint_io8_t*)0xB71C1082)  /*@bfbba@*/
#define GPIO_PODR2_POD3	(*(volatile uint_io8_t*)0xB71C1083)  /*@bfbba@*/
#define GPIO_PODR2_POD4	(*(volatile uint_io8_t*)0xB71C1084)  /*@bfbba@*/
#define GPIO_PODR2_POD5	(*(volatile uint_io8_t*)0xB71C1085)  /*@bfbba@*/
#define GPIO_PODR2_POD6	(*(volatile uint_io8_t*)0xB71C1086)  /*@bfbba@*/
#define GPIO_PODR2_POD7	(*(volatile uint_io8_t*)0xB71C1087)  /*@bfbba@*/
#define GPIO_PODR2_POD8	(*(volatile uint_io8_t*)0xB71C1088)  /*@bfbba@*/
#define GPIO_PODR2_POD9	(*(volatile uint_io8_t*)0xB71C1089)  /*@bfbba@*/
#define GPIO_PODR2_POD10	(*(volatile uint_io8_t*)0xB71C108A)  /*@bfbba@*/
#define GPIO_PODR2_POD11	(*(volatile uint_io8_t*)0xB71C108B)  /*@bfbba@*/
#define GPIO_PODR2_POD12	(*(volatile uint_io8_t*)0xB71C108C)  /*@bfbba@*/
#define GPIO_PODR2_POD13	(*(volatile uint_io8_t*)0xB71C108D)  /*@bfbba@*/
#define GPIO_PODR2_POD14	(*(volatile uint_io8_t*)0xB71C108E)  /*@bfbba@*/
#define GPIO_PODR2_POD15	(*(volatile uint_io8_t*)0xB71C108F)  /*@bfbba@*/
#define GPIO_PODR2_POD16	(*(volatile uint_io8_t*)0xB71C1090)  /*@bfbba@*/
#define GPIO_PODR2_POD17	(*(volatile uint_io8_t*)0xB71C1091)  /*@bfbba@*/
#define GPIO_PODR2_POD18	(*(volatile uint_io8_t*)0xB71C1092)  /*@bfbba@*/
#define GPIO_PODR2_POD19	(*(volatile uint_io8_t*)0xB71C1093)  /*@bfbba@*/
#define GPIO_PODR2_POD20	(*(volatile uint_io8_t*)0xB71C1094)  /*@bfbba@*/
#define GPIO_PODR2_POD21	(*(volatile uint_io8_t*)0xB71C1095)  /*@bfbba@*/
#define GPIO_PODR2_POD22	(*(volatile uint_io8_t*)0xB71C1096)  /*@bfbba@*/
#define GPIO_PODR2_POD23	(*(volatile uint_io8_t*)0xB71C1097)  /*@bfbba@*/
#define GPIO_PODR2_POD24	(*(volatile uint_io8_t*)0xB71C1098)  /*@bfbba@*/
#define GPIO_PODR2_POD25	(*(volatile uint_io8_t*)0xB71C1099)  /*@bfbba@*/
#define GPIO_PODR2_POD26	(*(volatile uint_io8_t*)0xB71C109A)  /*@bfbba@*/
#define GPIO_PODR2_POD27	(*(volatile uint_io8_t*)0xB71C109B)  /*@bfbba@*/
#define GPIO_PODR2_POD28	(*(volatile uint_io8_t*)0xB71C109C)  /*@bfbba@*/
#define GPIO_PODR2_POD29	(*(volatile uint_io8_t*)0xB71C109D)  /*@bfbba@*/
#define GPIO_PODR2_POD30	(*(volatile uint_io8_t*)0xB71C109E)  /*@bfbba@*/
#define GPIO_PODR2_POD31	(*(volatile uint_io8_t*)0xB71C109F)  /*@bfbba@*/

#define GPIO_PODR3	(GPIO.unPODR3.u32Register)  /*@rg@*/
#define GPIO_PODR3_POD0	(*(volatile uint_io8_t*)0xB71C10C0)  /*@bfbba@*/
#define GPIO_PODR3_POD1	(*(volatile uint_io8_t*)0xB71C10C1)  /*@bfbba@*/
#define GPIO_PODR3_POD2	(*(volatile uint_io8_t*)0xB71C10C2)  /*@bfbba@*/
#define GPIO_PODR3_POD3	(*(volatile uint_io8_t*)0xB71C10C3)  /*@bfbba@*/
#define GPIO_PODR3_POD4	(*(volatile uint_io8_t*)0xB71C10C4)  /*@bfbba@*/
#define GPIO_PODR3_POD5	(*(volatile uint_io8_t*)0xB71C10C5)  /*@bfbba@*/
#define GPIO_PODR3_POD6	(*(volatile uint_io8_t*)0xB71C10C6)  /*@bfbba@*/
#define GPIO_PODR3_POD7	(*(volatile uint_io8_t*)0xB71C10C7)  /*@bfbba@*/
#define GPIO_PODR3_POD8	(*(volatile uint_io8_t*)0xB71C10C8)  /*@bfbba@*/
#define GPIO_PODR3_POD9	(*(volatile uint_io8_t*)0xB71C10C9)  /*@bfbba@*/
#define GPIO_PODR3_POD10	(*(volatile uint_io8_t*)0xB71C10CA)  /*@bfbba@*/
#define GPIO_PODR3_POD11	(*(volatile uint_io8_t*)0xB71C10CB)  /*@bfbba@*/
#define GPIO_PODR3_POD12	(*(volatile uint_io8_t*)0xB71C10CC)  /*@bfbba@*/
#define GPIO_PODR3_POD13	(*(volatile uint_io8_t*)0xB71C10CD)  /*@bfbba@*/
#define GPIO_PODR3_POD14	(*(volatile uint_io8_t*)0xB71C10CE)  /*@bfbba@*/
#define GPIO_PODR3_POD15	(*(volatile uint_io8_t*)0xB71C10CF)  /*@bfbba@*/
#define GPIO_PODR3_POD16	(*(volatile uint_io8_t*)0xB71C10D0)  /*@bfbba@*/
#define GPIO_PODR3_POD17	(*(volatile uint_io8_t*)0xB71C10D1)  /*@bfbba@*/
#define GPIO_PODR3_POD18	(*(volatile uint_io8_t*)0xB71C10D2)  /*@bfbba@*/
#define GPIO_PODR3_POD19	(*(volatile uint_io8_t*)0xB71C10D3)  /*@bfbba@*/
#define GPIO_PODR3_POD20	(*(volatile uint_io8_t*)0xB71C10D4)  /*@bfbba@*/
#define GPIO_PODR3_POD21	(*(volatile uint_io8_t*)0xB71C10D5)  /*@bfbba@*/
#define GPIO_PODR3_POD22	(*(volatile uint_io8_t*)0xB71C10D6)  /*@bfbba@*/
#define GPIO_PODR3_POD23	(*(volatile uint_io8_t*)0xB71C10D7)  /*@bfbba@*/
#define GPIO_PODR3_POD24	(*(volatile uint_io8_t*)0xB71C10D8)  /*@bfbba@*/
#define GPIO_PODR3_POD25	(*(volatile uint_io8_t*)0xB71C10D9)  /*@bfbba@*/
#define GPIO_PODR3_POD26	(*(volatile uint_io8_t*)0xB71C10DA)  /*@bfbba@*/
#define GPIO_PODR3_POD27	(*(volatile uint_io8_t*)0xB71C10DB)  /*@bfbba@*/
#define GPIO_PODR3_POD28	(*(volatile uint_io8_t*)0xB71C10DC)  /*@bfbba@*/
#define GPIO_PODR3_POD29	(*(volatile uint_io8_t*)0xB71C10DD)  /*@bfbba@*/
#define GPIO_PODR3_POD30	(*(volatile uint_io8_t*)0xB71C10DE)  /*@bfbba@*/
#define GPIO_PODR3_POD31	(*(volatile uint_io8_t*)0xB71C10DF)  /*@bfbba@*/

typedef struct stc_gpio_podrn_field{
    uint_io32_t		u1POD0:1;
    uint_io32_t		u1POD1:1;
    uint_io32_t		u1POD2:1;
    uint_io32_t		u1POD3:1;
    uint_io32_t		u1POD4:1;
    uint_io32_t		u1POD5:1;
    uint_io32_t		u1POD6:1;
    uint_io32_t		u1POD7:1;
    uint_io32_t		u1POD8:1;
    uint_io32_t		u1POD9:1;
    uint_io32_t		u1POD10:1;
    uint_io32_t		u1POD11:1;
    uint_io32_t		u1POD12:1;
    uint_io32_t		u1POD13:1;
    uint_io32_t		u1POD14:1;
    uint_io32_t		u1POD15:1;
    uint_io32_t		u1POD16:1;
    uint_io32_t		u1POD17:1;
    uint_io32_t		u1POD18:1;
    uint_io32_t		u1POD19:1;
    uint_io32_t		u1POD20:1;
    uint_io32_t		u1POD21:1;
    uint_io32_t		u1POD22:1;
    uint_io32_t		u1POD23:1;
    uint_io32_t		u1POD24:1;
    uint_io32_t		u1POD25:1;
    uint_io32_t		u1POD26:1;
    uint_io32_t		u1POD27:1;
    uint_io32_t		u1POD28:1;
    uint_io32_t		u1POD29:1;
    uint_io32_t		u1POD30:1;
    uint_io32_t		u1POD31:1;
}stc_gpio_podrn_field_t;

typedef union un_gpio_podrn{
    uint_io32_t		u32Register;
    stc_gpio_podrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_podrn_t;

/* DDR[0-3] */
#define GPIO_DDR0	(GPIO.unDDR0.u32Register)  /*@rg@*/
#define GPIO_DDR0_DD0	(*(volatile uint_io8_t*)0xB71C1020)  /*@bfbba@*/
#define GPIO_DDR0_DD1	(*(volatile uint_io8_t*)0xB71C1021)  /*@bfbba@*/
#define GPIO_DDR0_DD2	(*(volatile uint_io8_t*)0xB71C1022)  /*@bfbba@*/
#define GPIO_DDR0_DD3	(*(volatile uint_io8_t*)0xB71C1023)  /*@bfbba@*/
#define GPIO_DDR0_DD4	(*(volatile uint_io8_t*)0xB71C1024)  /*@bfbba@*/
#define GPIO_DDR0_DD5	(*(volatile uint_io8_t*)0xB71C1025)  /*@bfbba@*/
#define GPIO_DDR0_DD6	(*(volatile uint_io8_t*)0xB71C1026)  /*@bfbba@*/
#define GPIO_DDR0_DD7	(*(volatile uint_io8_t*)0xB71C1027)  /*@bfbba@*/
#define GPIO_DDR0_DD8	(*(volatile uint_io8_t*)0xB71C1028)  /*@bfbba@*/
#define GPIO_DDR0_DD9	(*(volatile uint_io8_t*)0xB71C1029)  /*@bfbba@*/
#define GPIO_DDR0_DD10	(*(volatile uint_io8_t*)0xB71C102A)  /*@bfbba@*/
#define GPIO_DDR0_DD11	(*(volatile uint_io8_t*)0xB71C102B)  /*@bfbba@*/
#define GPIO_DDR0_DD12	(*(volatile uint_io8_t*)0xB71C102C)  /*@bfbba@*/
#define GPIO_DDR0_DD13	(*(volatile uint_io8_t*)0xB71C102D)  /*@bfbba@*/
#define GPIO_DDR0_DD14	(*(volatile uint_io8_t*)0xB71C102E)  /*@bfbba@*/
#define GPIO_DDR0_DD15	(*(volatile uint_io8_t*)0xB71C102F)  /*@bfbba@*/
#define GPIO_DDR0_DD16	(*(volatile uint_io8_t*)0xB71C1030)  /*@bfbba@*/
#define GPIO_DDR0_DD17	(*(volatile uint_io8_t*)0xB71C1031)  /*@bfbba@*/
#define GPIO_DDR0_DD18	(*(volatile uint_io8_t*)0xB71C1032)  /*@bfbba@*/
#define GPIO_DDR0_DD19	(*(volatile uint_io8_t*)0xB71C1033)  /*@bfbba@*/
#define GPIO_DDR0_DD20	(*(volatile uint_io8_t*)0xB71C1034)  /*@bfbba@*/
#define GPIO_DDR0_DD21	(*(volatile uint_io8_t*)0xB71C1035)  /*@bfbba@*/
#define GPIO_DDR0_DD22	(*(volatile uint_io8_t*)0xB71C1036)  /*@bfbba@*/
#define GPIO_DDR0_DD23	(*(volatile uint_io8_t*)0xB71C1037)  /*@bfbba@*/
#define GPIO_DDR0_DD24	(*(volatile uint_io8_t*)0xB71C1038)  /*@bfbba@*/
#define GPIO_DDR0_DD25	(*(volatile uint_io8_t*)0xB71C1039)  /*@bfbba@*/
#define GPIO_DDR0_DD26	(*(volatile uint_io8_t*)0xB71C103A)  /*@bfbba@*/
#define GPIO_DDR0_DD27	(*(volatile uint_io8_t*)0xB71C103B)  /*@bfbba@*/
#define GPIO_DDR0_DD28	(*(volatile uint_io8_t*)0xB71C103C)  /*@bfbba@*/
#define GPIO_DDR0_DD29	(*(volatile uint_io8_t*)0xB71C103D)  /*@bfbba@*/
#define GPIO_DDR0_DD30	(*(volatile uint_io8_t*)0xB71C103E)  /*@bfbba@*/
#define GPIO_DDR0_DD31	(*(volatile uint_io8_t*)0xB71C103F)  /*@bfbba@*/

#define GPIO_DDR1	(GPIO.unDDR1.u32Register)  /*@rg@*/
#define GPIO_DDR1_DD0	(*(volatile uint_io8_t*)0xB71C1060)  /*@bfbba@*/
#define GPIO_DDR1_DD1	(*(volatile uint_io8_t*)0xB71C1061)  /*@bfbba@*/
#define GPIO_DDR1_DD2	(*(volatile uint_io8_t*)0xB71C1062)  /*@bfbba@*/
#define GPIO_DDR1_DD3	(*(volatile uint_io8_t*)0xB71C1063)  /*@bfbba@*/
#define GPIO_DDR1_DD4	(*(volatile uint_io8_t*)0xB71C1064)  /*@bfbba@*/
#define GPIO_DDR1_DD5	(*(volatile uint_io8_t*)0xB71C1065)  /*@bfbba@*/
#define GPIO_DDR1_DD6	(*(volatile uint_io8_t*)0xB71C1066)  /*@bfbba@*/
#define GPIO_DDR1_DD7	(*(volatile uint_io8_t*)0xB71C1067)  /*@bfbba@*/
#define GPIO_DDR1_DD8	(*(volatile uint_io8_t*)0xB71C1068)  /*@bfbba@*/
#define GPIO_DDR1_DD9	(*(volatile uint_io8_t*)0xB71C1069)  /*@bfbba@*/
#define GPIO_DDR1_DD10	(*(volatile uint_io8_t*)0xB71C106A)  /*@bfbba@*/
#define GPIO_DDR1_DD11	(*(volatile uint_io8_t*)0xB71C106B)  /*@bfbba@*/
#define GPIO_DDR1_DD12	(*(volatile uint_io8_t*)0xB71C106C)  /*@bfbba@*/
#define GPIO_DDR1_DD13	(*(volatile uint_io8_t*)0xB71C106D)  /*@bfbba@*/
#define GPIO_DDR1_DD14	(*(volatile uint_io8_t*)0xB71C106E)  /*@bfbba@*/
#define GPIO_DDR1_DD15	(*(volatile uint_io8_t*)0xB71C106F)  /*@bfbba@*/
#define GPIO_DDR1_DD16	(*(volatile uint_io8_t*)0xB71C1070)  /*@bfbba@*/
#define GPIO_DDR1_DD17	(*(volatile uint_io8_t*)0xB71C1071)  /*@bfbba@*/
#define GPIO_DDR1_DD18	(*(volatile uint_io8_t*)0xB71C1072)  /*@bfbba@*/
#define GPIO_DDR1_DD19	(*(volatile uint_io8_t*)0xB71C1073)  /*@bfbba@*/
#define GPIO_DDR1_DD20	(*(volatile uint_io8_t*)0xB71C1074)  /*@bfbba@*/
#define GPIO_DDR1_DD21	(*(volatile uint_io8_t*)0xB71C1075)  /*@bfbba@*/
#define GPIO_DDR1_DD22	(*(volatile uint_io8_t*)0xB71C1076)  /*@bfbba@*/
#define GPIO_DDR1_DD23	(*(volatile uint_io8_t*)0xB71C1077)  /*@bfbba@*/
#define GPIO_DDR1_DD24	(*(volatile uint_io8_t*)0xB71C1078)  /*@bfbba@*/
#define GPIO_DDR1_DD25	(*(volatile uint_io8_t*)0xB71C1079)  /*@bfbba@*/
#define GPIO_DDR1_DD26	(*(volatile uint_io8_t*)0xB71C107A)  /*@bfbba@*/
#define GPIO_DDR1_DD27	(*(volatile uint_io8_t*)0xB71C107B)  /*@bfbba@*/
#define GPIO_DDR1_DD28	(*(volatile uint_io8_t*)0xB71C107C)  /*@bfbba@*/
#define GPIO_DDR1_DD29	(*(volatile uint_io8_t*)0xB71C107D)  /*@bfbba@*/
#define GPIO_DDR1_DD30	(*(volatile uint_io8_t*)0xB71C107E)  /*@bfbba@*/
#define GPIO_DDR1_DD31	(*(volatile uint_io8_t*)0xB71C107F)  /*@bfbba@*/

#define GPIO_DDR2	(GPIO.unDDR2.u32Register)  /*@rg@*/
#define GPIO_DDR2_DD0	(*(volatile uint_io8_t*)0xB71C10A0)  /*@bfbba@*/
#define GPIO_DDR2_DD1	(*(volatile uint_io8_t*)0xB71C10A1)  /*@bfbba@*/
#define GPIO_DDR2_DD2	(*(volatile uint_io8_t*)0xB71C10A2)  /*@bfbba@*/
#define GPIO_DDR2_DD3	(*(volatile uint_io8_t*)0xB71C10A3)  /*@bfbba@*/
#define GPIO_DDR2_DD4	(*(volatile uint_io8_t*)0xB71C10A4)  /*@bfbba@*/
#define GPIO_DDR2_DD5	(*(volatile uint_io8_t*)0xB71C10A5)  /*@bfbba@*/
#define GPIO_DDR2_DD6	(*(volatile uint_io8_t*)0xB71C10A6)  /*@bfbba@*/
#define GPIO_DDR2_DD7	(*(volatile uint_io8_t*)0xB71C10A7)  /*@bfbba@*/
#define GPIO_DDR2_DD8	(*(volatile uint_io8_t*)0xB71C10A8)  /*@bfbba@*/
#define GPIO_DDR2_DD9	(*(volatile uint_io8_t*)0xB71C10A9)  /*@bfbba@*/
#define GPIO_DDR2_DD10	(*(volatile uint_io8_t*)0xB71C10AA)  /*@bfbba@*/
#define GPIO_DDR2_DD11	(*(volatile uint_io8_t*)0xB71C10AB)  /*@bfbba@*/
#define GPIO_DDR2_DD12	(*(volatile uint_io8_t*)0xB71C10AC)  /*@bfbba@*/
#define GPIO_DDR2_DD13	(*(volatile uint_io8_t*)0xB71C10AD)  /*@bfbba@*/
#define GPIO_DDR2_DD14	(*(volatile uint_io8_t*)0xB71C10AE)  /*@bfbba@*/
#define GPIO_DDR2_DD15	(*(volatile uint_io8_t*)0xB71C10AF)  /*@bfbba@*/
#define GPIO_DDR2_DD16	(*(volatile uint_io8_t*)0xB71C10B0)  /*@bfbba@*/
#define GPIO_DDR2_DD17	(*(volatile uint_io8_t*)0xB71C10B1)  /*@bfbba@*/
#define GPIO_DDR2_DD18	(*(volatile uint_io8_t*)0xB71C10B2)  /*@bfbba@*/
#define GPIO_DDR2_DD19	(*(volatile uint_io8_t*)0xB71C10B3)  /*@bfbba@*/
#define GPIO_DDR2_DD20	(*(volatile uint_io8_t*)0xB71C10B4)  /*@bfbba@*/
#define GPIO_DDR2_DD21	(*(volatile uint_io8_t*)0xB71C10B5)  /*@bfbba@*/
#define GPIO_DDR2_DD22	(*(volatile uint_io8_t*)0xB71C10B6)  /*@bfbba@*/
#define GPIO_DDR2_DD23	(*(volatile uint_io8_t*)0xB71C10B7)  /*@bfbba@*/
#define GPIO_DDR2_DD24	(*(volatile uint_io8_t*)0xB71C10B8)  /*@bfbba@*/
#define GPIO_DDR2_DD25	(*(volatile uint_io8_t*)0xB71C10B9)  /*@bfbba@*/
#define GPIO_DDR2_DD26	(*(volatile uint_io8_t*)0xB71C10BA)  /*@bfbba@*/
#define GPIO_DDR2_DD27	(*(volatile uint_io8_t*)0xB71C10BB)  /*@bfbba@*/
#define GPIO_DDR2_DD28	(*(volatile uint_io8_t*)0xB71C10BC)  /*@bfbba@*/
#define GPIO_DDR2_DD29	(*(volatile uint_io8_t*)0xB71C10BD)  /*@bfbba@*/
#define GPIO_DDR2_DD30	(*(volatile uint_io8_t*)0xB71C10BE)  /*@bfbba@*/
#define GPIO_DDR2_DD31	(*(volatile uint_io8_t*)0xB71C10BF)  /*@bfbba@*/

#define GPIO_DDR3	(GPIO.unDDR3.u32Register)  /*@rg@*/
#define GPIO_DDR3_DD0	(*(volatile uint_io8_t*)0xB71C10E0)  /*@bfbba@*/
#define GPIO_DDR3_DD1	(*(volatile uint_io8_t*)0xB71C10E1)  /*@bfbba@*/
#define GPIO_DDR3_DD2	(*(volatile uint_io8_t*)0xB71C10E2)  /*@bfbba@*/
#define GPIO_DDR3_DD3	(*(volatile uint_io8_t*)0xB71C10E3)  /*@bfbba@*/
#define GPIO_DDR3_DD4	(*(volatile uint_io8_t*)0xB71C10E4)  /*@bfbba@*/
#define GPIO_DDR3_DD5	(*(volatile uint_io8_t*)0xB71C10E5)  /*@bfbba@*/
#define GPIO_DDR3_DD6	(*(volatile uint_io8_t*)0xB71C10E6)  /*@bfbba@*/
#define GPIO_DDR3_DD7	(*(volatile uint_io8_t*)0xB71C10E7)  /*@bfbba@*/
#define GPIO_DDR3_DD8	(*(volatile uint_io8_t*)0xB71C10E8)  /*@bfbba@*/
#define GPIO_DDR3_DD9	(*(volatile uint_io8_t*)0xB71C10E9)  /*@bfbba@*/
#define GPIO_DDR3_DD10	(*(volatile uint_io8_t*)0xB71C10EA)  /*@bfbba@*/
#define GPIO_DDR3_DD11	(*(volatile uint_io8_t*)0xB71C10EB)  /*@bfbba@*/
#define GPIO_DDR3_DD12	(*(volatile uint_io8_t*)0xB71C10EC)  /*@bfbba@*/
#define GPIO_DDR3_DD13	(*(volatile uint_io8_t*)0xB71C10ED)  /*@bfbba@*/
#define GPIO_DDR3_DD14	(*(volatile uint_io8_t*)0xB71C10EE)  /*@bfbba@*/
#define GPIO_DDR3_DD15	(*(volatile uint_io8_t*)0xB71C10EF)  /*@bfbba@*/
#define GPIO_DDR3_DD16	(*(volatile uint_io8_t*)0xB71C10F0)  /*@bfbba@*/
#define GPIO_DDR3_DD17	(*(volatile uint_io8_t*)0xB71C10F1)  /*@bfbba@*/
#define GPIO_DDR3_DD18	(*(volatile uint_io8_t*)0xB71C10F2)  /*@bfbba@*/
#define GPIO_DDR3_DD19	(*(volatile uint_io8_t*)0xB71C10F3)  /*@bfbba@*/
#define GPIO_DDR3_DD20	(*(volatile uint_io8_t*)0xB71C10F4)  /*@bfbba@*/
#define GPIO_DDR3_DD21	(*(volatile uint_io8_t*)0xB71C10F5)  /*@bfbba@*/
#define GPIO_DDR3_DD22	(*(volatile uint_io8_t*)0xB71C10F6)  /*@bfbba@*/
#define GPIO_DDR3_DD23	(*(volatile uint_io8_t*)0xB71C10F7)  /*@bfbba@*/
#define GPIO_DDR3_DD24	(*(volatile uint_io8_t*)0xB71C10F8)  /*@bfbba@*/
#define GPIO_DDR3_DD25	(*(volatile uint_io8_t*)0xB71C10F9)  /*@bfbba@*/
#define GPIO_DDR3_DD26	(*(volatile uint_io8_t*)0xB71C10FA)  /*@bfbba@*/
#define GPIO_DDR3_DD27	(*(volatile uint_io8_t*)0xB71C10FB)  /*@bfbba@*/
#define GPIO_DDR3_DD28	(*(volatile uint_io8_t*)0xB71C10FC)  /*@bfbba@*/
#define GPIO_DDR3_DD29	(*(volatile uint_io8_t*)0xB71C10FD)  /*@bfbba@*/
#define GPIO_DDR3_DD30	(*(volatile uint_io8_t*)0xB71C10FE)  /*@bfbba@*/
#define GPIO_DDR3_DD31	(*(volatile uint_io8_t*)0xB71C10FF)  /*@bfbba@*/

typedef struct stc_gpio_ddrn_field{
    uint_io32_t		u1DD0:1;
    uint_io32_t		u1DD1:1;
    uint_io32_t		u1DD2:1;
    uint_io32_t		u1DD3:1;
    uint_io32_t		u1DD4:1;
    uint_io32_t		u1DD5:1;
    uint_io32_t		u1DD6:1;
    uint_io32_t		u1DD7:1;
    uint_io32_t		u1DD8:1;
    uint_io32_t		u1DD9:1;
    uint_io32_t		u1DD10:1;
    uint_io32_t		u1DD11:1;
    uint_io32_t		u1DD12:1;
    uint_io32_t		u1DD13:1;
    uint_io32_t		u1DD14:1;
    uint_io32_t		u1DD15:1;
    uint_io32_t		u1DD16:1;
    uint_io32_t		u1DD17:1;
    uint_io32_t		u1DD18:1;
    uint_io32_t		u1DD19:1;
    uint_io32_t		u1DD20:1;
    uint_io32_t		u1DD21:1;
    uint_io32_t		u1DD22:1;
    uint_io32_t		u1DD23:1;
    uint_io32_t		u1DD24:1;
    uint_io32_t		u1DD25:1;
    uint_io32_t		u1DD26:1;
    uint_io32_t		u1DD27:1;
    uint_io32_t		u1DD28:1;
    uint_io32_t		u1DD29:1;
    uint_io32_t		u1DD30:1;
    uint_io32_t		u1DD31:1;
}stc_gpio_ddrn_field_t;

typedef union un_gpio_ddrn{
    uint_io32_t		u32Register;
    stc_gpio_ddrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddrn_t;

/* PIDR[0-3] */
#define GPIO_PIDR0	(GPIO.unPIDR0.u32Register)  /*@rg@*/
#define GPIO_PIDR0_PID0	(*(volatile uint_io8_t*)0xB71C1800)  /*@bfbba@*/
#define GPIO_PIDR0_PID1	(*(volatile uint_io8_t*)0xB71C1801)  /*@bfbba@*/
#define GPIO_PIDR0_PID2	(*(volatile uint_io8_t*)0xB71C1802)  /*@bfbba@*/
#define GPIO_PIDR0_PID3	(*(volatile uint_io8_t*)0xB71C1803)  /*@bfbba@*/
#define GPIO_PIDR0_PID4	(*(volatile uint_io8_t*)0xB71C1804)  /*@bfbba@*/
#define GPIO_PIDR0_PID5	(*(volatile uint_io8_t*)0xB71C1805)  /*@bfbba@*/
#define GPIO_PIDR0_PID6	(*(volatile uint_io8_t*)0xB71C1806)  /*@bfbba@*/
#define GPIO_PIDR0_PID7	(*(volatile uint_io8_t*)0xB71C1807)  /*@bfbba@*/
#define GPIO_PIDR0_PID8	(*(volatile uint_io8_t*)0xB71C1808)  /*@bfbba@*/
#define GPIO_PIDR0_PID9	(*(volatile uint_io8_t*)0xB71C1809)  /*@bfbba@*/
#define GPIO_PIDR0_PID10	(*(volatile uint_io8_t*)0xB71C180A)  /*@bfbba@*/
#define GPIO_PIDR0_PID11	(*(volatile uint_io8_t*)0xB71C180B)  /*@bfbba@*/
#define GPIO_PIDR0_PID12	(*(volatile uint_io8_t*)0xB71C180C)  /*@bfbba@*/
#define GPIO_PIDR0_PID13	(*(volatile uint_io8_t*)0xB71C180D)  /*@bfbba@*/
#define GPIO_PIDR0_PID14	(*(volatile uint_io8_t*)0xB71C180E)  /*@bfbba@*/
#define GPIO_PIDR0_PID15	(*(volatile uint_io8_t*)0xB71C180F)  /*@bfbba@*/
#define GPIO_PIDR0_PID16	(*(volatile uint_io8_t*)0xB71C1810)  /*@bfbba@*/
#define GPIO_PIDR0_PID17	(*(volatile uint_io8_t*)0xB71C1811)  /*@bfbba@*/
#define GPIO_PIDR0_PID18	(*(volatile uint_io8_t*)0xB71C1812)  /*@bfbba@*/
#define GPIO_PIDR0_PID19	(*(volatile uint_io8_t*)0xB71C1813)  /*@bfbba@*/
#define GPIO_PIDR0_PID20	(*(volatile uint_io8_t*)0xB71C1814)  /*@bfbba@*/
#define GPIO_PIDR0_PID21	(*(volatile uint_io8_t*)0xB71C1815)  /*@bfbba@*/
#define GPIO_PIDR0_PID22	(*(volatile uint_io8_t*)0xB71C1816)  /*@bfbba@*/
#define GPIO_PIDR0_PID23	(*(volatile uint_io8_t*)0xB71C1817)  /*@bfbba@*/
#define GPIO_PIDR0_PID24	(*(volatile uint_io8_t*)0xB71C1818)  /*@bfbba@*/
#define GPIO_PIDR0_PID25	(*(volatile uint_io8_t*)0xB71C1819)  /*@bfbba@*/
#define GPIO_PIDR0_PID26	(*(volatile uint_io8_t*)0xB71C181A)  /*@bfbba@*/
#define GPIO_PIDR0_PID27	(*(volatile uint_io8_t*)0xB71C181B)  /*@bfbba@*/
#define GPIO_PIDR0_PID28	(*(volatile uint_io8_t*)0xB71C181C)  /*@bfbba@*/
#define GPIO_PIDR0_PID29	(*(volatile uint_io8_t*)0xB71C181D)  /*@bfbba@*/
#define GPIO_PIDR0_PID30	(*(volatile uint_io8_t*)0xB71C181E)  /*@bfbba@*/
#define GPIO_PIDR0_PID31	(*(volatile uint_io8_t*)0xB71C181F)  /*@bfbba@*/

#define GPIO_PIDR1	(GPIO.unPIDR1.u32Register)  /*@rg@*/
#define GPIO_PIDR1_PID0	(*(volatile uint_io8_t*)0xB71C1820)  /*@bfbba@*/
#define GPIO_PIDR1_PID1	(*(volatile uint_io8_t*)0xB71C1821)  /*@bfbba@*/
#define GPIO_PIDR1_PID2	(*(volatile uint_io8_t*)0xB71C1822)  /*@bfbba@*/
#define GPIO_PIDR1_PID3	(*(volatile uint_io8_t*)0xB71C1823)  /*@bfbba@*/
#define GPIO_PIDR1_PID4	(*(volatile uint_io8_t*)0xB71C1824)  /*@bfbba@*/
#define GPIO_PIDR1_PID5	(*(volatile uint_io8_t*)0xB71C1825)  /*@bfbba@*/
#define GPIO_PIDR1_PID6	(*(volatile uint_io8_t*)0xB71C1826)  /*@bfbba@*/
#define GPIO_PIDR1_PID7	(*(volatile uint_io8_t*)0xB71C1827)  /*@bfbba@*/
#define GPIO_PIDR1_PID8	(*(volatile uint_io8_t*)0xB71C1828)  /*@bfbba@*/
#define GPIO_PIDR1_PID9	(*(volatile uint_io8_t*)0xB71C1829)  /*@bfbba@*/
#define GPIO_PIDR1_PID10	(*(volatile uint_io8_t*)0xB71C182A)  /*@bfbba@*/
#define GPIO_PIDR1_PID11	(*(volatile uint_io8_t*)0xB71C182B)  /*@bfbba@*/
#define GPIO_PIDR1_PID12	(*(volatile uint_io8_t*)0xB71C182C)  /*@bfbba@*/
#define GPIO_PIDR1_PID13	(*(volatile uint_io8_t*)0xB71C182D)  /*@bfbba@*/
#define GPIO_PIDR1_PID14	(*(volatile uint_io8_t*)0xB71C182E)  /*@bfbba@*/
#define GPIO_PIDR1_PID15	(*(volatile uint_io8_t*)0xB71C182F)  /*@bfbba@*/
#define GPIO_PIDR1_PID16	(*(volatile uint_io8_t*)0xB71C1830)  /*@bfbba@*/
#define GPIO_PIDR1_PID17	(*(volatile uint_io8_t*)0xB71C1831)  /*@bfbba@*/
#define GPIO_PIDR1_PID18	(*(volatile uint_io8_t*)0xB71C1832)  /*@bfbba@*/
#define GPIO_PIDR1_PID19	(*(volatile uint_io8_t*)0xB71C1833)  /*@bfbba@*/
#define GPIO_PIDR1_PID20	(*(volatile uint_io8_t*)0xB71C1834)  /*@bfbba@*/
#define GPIO_PIDR1_PID21	(*(volatile uint_io8_t*)0xB71C1835)  /*@bfbba@*/
#define GPIO_PIDR1_PID22	(*(volatile uint_io8_t*)0xB71C1836)  /*@bfbba@*/
#define GPIO_PIDR1_PID23	(*(volatile uint_io8_t*)0xB71C1837)  /*@bfbba@*/
#define GPIO_PIDR1_PID24	(*(volatile uint_io8_t*)0xB71C1838)  /*@bfbba@*/
#define GPIO_PIDR1_PID25	(*(volatile uint_io8_t*)0xB71C1839)  /*@bfbba@*/
#define GPIO_PIDR1_PID26	(*(volatile uint_io8_t*)0xB71C183A)  /*@bfbba@*/
#define GPIO_PIDR1_PID27	(*(volatile uint_io8_t*)0xB71C183B)  /*@bfbba@*/
#define GPIO_PIDR1_PID28	(*(volatile uint_io8_t*)0xB71C183C)  /*@bfbba@*/
#define GPIO_PIDR1_PID29	(*(volatile uint_io8_t*)0xB71C183D)  /*@bfbba@*/
#define GPIO_PIDR1_PID30	(*(volatile uint_io8_t*)0xB71C183E)  /*@bfbba@*/
#define GPIO_PIDR1_PID31	(*(volatile uint_io8_t*)0xB71C183F)  /*@bfbba@*/

#define GPIO_PIDR2	(GPIO.unPIDR2.u32Register)  /*@rg@*/
#define GPIO_PIDR2_PID0	(*(volatile uint_io8_t*)0xB71C1840)  /*@bfbba@*/
#define GPIO_PIDR2_PID1	(*(volatile uint_io8_t*)0xB71C1841)  /*@bfbba@*/
#define GPIO_PIDR2_PID2	(*(volatile uint_io8_t*)0xB71C1842)  /*@bfbba@*/
#define GPIO_PIDR2_PID3	(*(volatile uint_io8_t*)0xB71C1843)  /*@bfbba@*/
#define GPIO_PIDR2_PID4	(*(volatile uint_io8_t*)0xB71C1844)  /*@bfbba@*/
#define GPIO_PIDR2_PID5	(*(volatile uint_io8_t*)0xB71C1845)  /*@bfbba@*/
#define GPIO_PIDR2_PID6	(*(volatile uint_io8_t*)0xB71C1846)  /*@bfbba@*/
#define GPIO_PIDR2_PID7	(*(volatile uint_io8_t*)0xB71C1847)  /*@bfbba@*/
#define GPIO_PIDR2_PID8	(*(volatile uint_io8_t*)0xB71C1848)  /*@bfbba@*/
#define GPIO_PIDR2_PID9	(*(volatile uint_io8_t*)0xB71C1849)  /*@bfbba@*/
#define GPIO_PIDR2_PID10	(*(volatile uint_io8_t*)0xB71C184A)  /*@bfbba@*/
#define GPIO_PIDR2_PID11	(*(volatile uint_io8_t*)0xB71C184B)  /*@bfbba@*/
#define GPIO_PIDR2_PID12	(*(volatile uint_io8_t*)0xB71C184C)  /*@bfbba@*/
#define GPIO_PIDR2_PID13	(*(volatile uint_io8_t*)0xB71C184D)  /*@bfbba@*/
#define GPIO_PIDR2_PID14	(*(volatile uint_io8_t*)0xB71C184E)  /*@bfbba@*/
#define GPIO_PIDR2_PID15	(*(volatile uint_io8_t*)0xB71C184F)  /*@bfbba@*/
#define GPIO_PIDR2_PID16	(*(volatile uint_io8_t*)0xB71C1850)  /*@bfbba@*/
#define GPIO_PIDR2_PID17	(*(volatile uint_io8_t*)0xB71C1851)  /*@bfbba@*/
#define GPIO_PIDR2_PID18	(*(volatile uint_io8_t*)0xB71C1852)  /*@bfbba@*/
#define GPIO_PIDR2_PID19	(*(volatile uint_io8_t*)0xB71C1853)  /*@bfbba@*/
#define GPIO_PIDR2_PID20	(*(volatile uint_io8_t*)0xB71C1854)  /*@bfbba@*/
#define GPIO_PIDR2_PID21	(*(volatile uint_io8_t*)0xB71C1855)  /*@bfbba@*/
#define GPIO_PIDR2_PID22	(*(volatile uint_io8_t*)0xB71C1856)  /*@bfbba@*/
#define GPIO_PIDR2_PID23	(*(volatile uint_io8_t*)0xB71C1857)  /*@bfbba@*/
#define GPIO_PIDR2_PID24	(*(volatile uint_io8_t*)0xB71C1858)  /*@bfbba@*/
#define GPIO_PIDR2_PID25	(*(volatile uint_io8_t*)0xB71C1859)  /*@bfbba@*/
#define GPIO_PIDR2_PID26	(*(volatile uint_io8_t*)0xB71C185A)  /*@bfbba@*/
#define GPIO_PIDR2_PID27	(*(volatile uint_io8_t*)0xB71C185B)  /*@bfbba@*/
#define GPIO_PIDR2_PID28	(*(volatile uint_io8_t*)0xB71C185C)  /*@bfbba@*/
#define GPIO_PIDR2_PID29	(*(volatile uint_io8_t*)0xB71C185D)  /*@bfbba@*/
#define GPIO_PIDR2_PID30	(*(volatile uint_io8_t*)0xB71C185E)  /*@bfbba@*/
#define GPIO_PIDR2_PID31	(*(volatile uint_io8_t*)0xB71C185F)  /*@bfbba@*/

#define GPIO_PIDR3	(GPIO.unPIDR3.u32Register)  /*@rg@*/
#define GPIO_PIDR3_PID0	(*(volatile uint_io8_t*)0xB71C1860)  /*@bfbba@*/
#define GPIO_PIDR3_PID1	(*(volatile uint_io8_t*)0xB71C1861)  /*@bfbba@*/
#define GPIO_PIDR3_PID2	(*(volatile uint_io8_t*)0xB71C1862)  /*@bfbba@*/
#define GPIO_PIDR3_PID3	(*(volatile uint_io8_t*)0xB71C1863)  /*@bfbba@*/
#define GPIO_PIDR3_PID4	(*(volatile uint_io8_t*)0xB71C1864)  /*@bfbba@*/
#define GPIO_PIDR3_PID5	(*(volatile uint_io8_t*)0xB71C1865)  /*@bfbba@*/
#define GPIO_PIDR3_PID6	(*(volatile uint_io8_t*)0xB71C1866)  /*@bfbba@*/
#define GPIO_PIDR3_PID7	(*(volatile uint_io8_t*)0xB71C1867)  /*@bfbba@*/
#define GPIO_PIDR3_PID8	(*(volatile uint_io8_t*)0xB71C1868)  /*@bfbba@*/
#define GPIO_PIDR3_PID9	(*(volatile uint_io8_t*)0xB71C1869)  /*@bfbba@*/
#define GPIO_PIDR3_PID10	(*(volatile uint_io8_t*)0xB71C186A)  /*@bfbba@*/
#define GPIO_PIDR3_PID11	(*(volatile uint_io8_t*)0xB71C186B)  /*@bfbba@*/
#define GPIO_PIDR3_PID12	(*(volatile uint_io8_t*)0xB71C186C)  /*@bfbba@*/
#define GPIO_PIDR3_PID13	(*(volatile uint_io8_t*)0xB71C186D)  /*@bfbba@*/
#define GPIO_PIDR3_PID14	(*(volatile uint_io8_t*)0xB71C186E)  /*@bfbba@*/
#define GPIO_PIDR3_PID15	(*(volatile uint_io8_t*)0xB71C186F)  /*@bfbba@*/
#define GPIO_PIDR3_PID16	(*(volatile uint_io8_t*)0xB71C1870)  /*@bfbba@*/
#define GPIO_PIDR3_PID17	(*(volatile uint_io8_t*)0xB71C1871)  /*@bfbba@*/
#define GPIO_PIDR3_PID18	(*(volatile uint_io8_t*)0xB71C1872)  /*@bfbba@*/
#define GPIO_PIDR3_PID19	(*(volatile uint_io8_t*)0xB71C1873)  /*@bfbba@*/
#define GPIO_PIDR3_PID20	(*(volatile uint_io8_t*)0xB71C1874)  /*@bfbba@*/
#define GPIO_PIDR3_PID21	(*(volatile uint_io8_t*)0xB71C1875)  /*@bfbba@*/
#define GPIO_PIDR3_PID22	(*(volatile uint_io8_t*)0xB71C1876)  /*@bfbba@*/
#define GPIO_PIDR3_PID23	(*(volatile uint_io8_t*)0xB71C1877)  /*@bfbba@*/
#define GPIO_PIDR3_PID24	(*(volatile uint_io8_t*)0xB71C1878)  /*@bfbba@*/
#define GPIO_PIDR3_PID25	(*(volatile uint_io8_t*)0xB71C1879)  /*@bfbba@*/
#define GPIO_PIDR3_PID26	(*(volatile uint_io8_t*)0xB71C187A)  /*@bfbba@*/
#define GPIO_PIDR3_PID27	(*(volatile uint_io8_t*)0xB71C187B)  /*@bfbba@*/
#define GPIO_PIDR3_PID28	(*(volatile uint_io8_t*)0xB71C187C)  /*@bfbba@*/
#define GPIO_PIDR3_PID29	(*(volatile uint_io8_t*)0xB71C187D)  /*@bfbba@*/
#define GPIO_PIDR3_PID30	(*(volatile uint_io8_t*)0xB71C187E)  /*@bfbba@*/
#define GPIO_PIDR3_PID31	(*(volatile uint_io8_t*)0xB71C187F)  /*@bfbba@*/

typedef struct stc_gpio_pidrn_field{
    uint_io32_t		u1PID0:1;
    uint_io32_t		u1PID1:1;
    uint_io32_t		u1PID2:1;
    uint_io32_t		u1PID3:1;
    uint_io32_t		u1PID4:1;
    uint_io32_t		u1PID5:1;
    uint_io32_t		u1PID6:1;
    uint_io32_t		u1PID7:1;
    uint_io32_t		u1PID8:1;
    uint_io32_t		u1PID9:1;
    uint_io32_t		u1PID10:1;
    uint_io32_t		u1PID11:1;
    uint_io32_t		u1PID12:1;
    uint_io32_t		u1PID13:1;
    uint_io32_t		u1PID14:1;
    uint_io32_t		u1PID15:1;
    uint_io32_t		u1PID16:1;
    uint_io32_t		u1PID17:1;
    uint_io32_t		u1PID18:1;
    uint_io32_t		u1PID19:1;
    uint_io32_t		u1PID20:1;
    uint_io32_t		u1PID21:1;
    uint_io32_t		u1PID22:1;
    uint_io32_t		u1PID23:1;
    uint_io32_t		u1PID24:1;
    uint_io32_t		u1PID25:1;
    uint_io32_t		u1PID26:1;
    uint_io32_t		u1PID27:1;
    uint_io32_t		u1PID28:1;
    uint_io32_t		u1PID29:1;
    uint_io32_t		u1PID30:1;
    uint_io32_t		u1PID31:1;
}stc_gpio_pidrn_field_t;

typedef union un_gpio_pidrn{
    uint_io32_t		u32Register;
    stc_gpio_pidrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pidrn_t;

/* PORTEN */
#define GPIO_PORTEN	(GPIO.unPORTEN.u32Register)  /*@rg@*/
#define GPIO_PORTEN_GPORTEN	(*(volatile uint_io8_t*)0xB71C2000)  /*@bfbba@*/

typedef struct stc_gpio_porten_field{
    uint_io32_t		u1GPORTEN:1;
    uint_io32_t		:31;
}stc_gpio_porten_field_t;

typedef union un_gpio_porten{
    uint_io32_t		u32Register;
    stc_gpio_porten_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_porten_t;

/* KEYCDR */
#define GPIO_KEYCDR	(GPIO.unKEYCDR.u32Register)  /*@rg@*/
#define GPIO_KEYCDR_RADR	(GPIO.unKEYCDR.stcField.u15RADR)  /*@bf@*/
#define GPIO_KEYCDR_SIZE	(GPIO.unKEYCDR.stcField.u2SIZE)  /*@bf@*/
#define GPIO_KEYCDR_KEY	(GPIO.unKEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_gpio_keycdr_field{
    uint_io32_t		u15RADR:15;
    uint_io32_t		:13;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_gpio_keycdr_field_t;

typedef union un_gpio_keycdr{
    uint_io32_t		u32Register;
    stc_gpio_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_keycdr_t;


typedef struct stc_gpio{
    un_gpio_posrn_t	unPOSR0;	/* 0x00000000 */
    un_gpio_pocrn_t	unPOCR0;	/* 0x00000004 */
    un_gpio_ddsrn_t	unDDSR0;	/* 0x00000008 */
    un_gpio_ddcrn_t	unDDCR0;	/* 0x0000000C */
    un_gpio_posrn_t	unPOSR1;	/* 0x00000010 */
    un_gpio_pocrn_t	unPOCR1;	/* 0x00000014 */
    un_gpio_ddsrn_t	unDDSR1;	/* 0x00000018 */
    un_gpio_ddcrn_t	unDDCR1;	/* 0x0000001C */
    un_gpio_posrn_t	unPOSR2;	/* 0x00000020 */
    un_gpio_pocrn_t	unPOCR2;	/* 0x00000024 */
    un_gpio_ddsrn_t	unDDSR2;	/* 0x00000028 */
    un_gpio_ddcrn_t	unDDCR2;	/* 0x0000002C */
    un_gpio_posrn_t	unPOSR3;	/* 0x00000030 */
    un_gpio_pocrn_t	unPOCR3;	/* 0x00000034 */
    un_gpio_ddsrn_t	unDDSR3;	/* 0x00000038 */
    un_gpio_ddcrn_t	unDDCR3;	/* 0x0000003C */
    uint_io8_t	au8Reserved0[448];	/* 0x00000040 */
    un_gpio_podrn_t	unPODR0;	/* 0x00000200 */
    un_gpio_ddrn_t	unDDR0;	/* 0x00000204 */
    un_gpio_podrn_t	unPODR1;	/* 0x00000208 */
    un_gpio_ddrn_t	unDDR1;	/* 0x0000020C */
    un_gpio_podrn_t	unPODR2;	/* 0x00000210 */
    un_gpio_ddrn_t	unDDR2;	/* 0x00000214 */
    un_gpio_podrn_t	unPODR3;	/* 0x00000218 */
    un_gpio_ddrn_t	unDDR3;	/* 0x0000021C */
    uint_io8_t	au8Reserved1[224];	/* 0x00000220 */
    un_gpio_pidrn_t	unPIDR0;	/* 0x00000300 */
    un_gpio_pidrn_t	unPIDR1;	/* 0x00000304 */
    un_gpio_pidrn_t	unPIDR2;	/* 0x00000308 */
    un_gpio_pidrn_t	unPIDR3;	/* 0x0000030C */
    uint_io8_t	au8Reserved2[240];	/* 0x00000310 */
    un_gpio_porten_t	unPORTEN;	/* 0x00000400 */
    un_gpio_keycdr_t	unKEYCDR;	/* 0x00000404 */
    uint_io8_t	au8Reserved3[31736];	/* 0x00000408 */
}stc_gpio_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_gpio_t	stcGPIO;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_GPIO_H */
