/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file sysctrl.h
 **
 ** Headerfile for System Controller
 **
 ** History:
 **   - 2014-06-04  0.01  HS  Initial version for Traveo
 **   - 2014-07-02  0.02  HS  Delete definitions not referred
 *****************************************************************************/

#ifndef __SYSCTRL_H__
#define __SYSCTRL_H__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/


/**
 *****************************************************************************
 ** \defgroup SyscGroup System Controller (SYSCTRL)
 **
 ** \brief This section describes the interface for the System Controller.
 **
 ** Provided functions of SYSCTRL module:
 **
 **  - SysCtrl_GetSourceClockFrequencyHz()
 **  - SysCtrl_GetDistributedClockFrequencyHz()
 **  - SysCtrl_CalculatePllFrequency()
 **
 ** These functions are used to get clock frequencies.
 **
 ** \note This module is allowed PDL internal use only.
 **
 *****************************************************************************/
/** @{ */

/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/
                                        
/*****************************************************************************
 * Global type definitions
 *****************************************************************************/

/**
 *****************************************************************************
 ** \brief System Controller Prescaler 2
 *****************************************************************************/
typedef enum en_sys_ctrl_clock_prescaler_type_b
{
    SysCtrlPrescalerTypeBDiv2     = 0x1,    /*!< Divided by 2 */
    SysCtrlPrescalerTypeBDiv4     = 0x2,    /*!< Divided by 4 */
    SysCtrlPrescalerTypeBDiv6     = 0x3,    /*!< Divided by 6 */
    SysCtrlPrescalerTypeBDiv8     = 0x4,    /*!< Divided by 8 */
    SysCtrlPrescalerTypeBDiv10    = 0x5,    /*!< Divided by 10 */
    SysCtrlPrescalerTypeBDiv12    = 0x6,    /*!< Divided by 12 */
    SysCtrlPrescalerTypeBDiv14    = 0x7,    /*!< Divided by 14 */
    SysCtrlPrescalerTypeBDiv16    = 0x8,    /*!< Divided by 16 */
    SysCtrlPrescalerTypeBDiv18    = 0x9,    /*!< Divided by 18 */
    SysCtrlPrescalerTypeBDiv20    = 0xA,    /*!< Divided by 20 */
    SysCtrlPrescalerTypeBDiv22    = 0xB,    /*!< Divided by 22 */
    SysCtrlPrescalerTypeBDiv24    = 0xC,    /*!< Divided by 24 */
    SysCtrlPrescalerTypeBDiv26    = 0xD,    /*!< Divided by 26 */
    SysCtrlPrescalerTypeBDiv28    = 0xE,    /*!< Divided by 28 */
    SysCtrlPrescalerTypeBDiv30    = 0xF     /*!< Divided by 30 */
} en_sys_ctrl_clock_prescaler_type_b_t;

/**
 *****************************************************************************
 ** \brief Possible clocks for clock distribution
 *****************************************************************************/
typedef enum en_sys_ctrl_clock_source
{
    SysCtrlClockSourceRcClock       = 0,    /*!< High-speed CR clock */
    SysCtrlClockSourceSlowRcClock   = 1,    /*!< Low-speed CR clock */
    SysCtrlClockSourceMainClock     = 2,    /*!< Main clock */
    SysCtrlClockSourceSubClock      = 3,    /*!< Sub clock */
    SysCtrlClockSourceMainPll0Clock = 4,    /*!< PLL0 clock */
    SysCtrlClockSourceSscgPll0Clock = 5,    /*!< SSCG PLL0 clock */
    SysCtrlClockSourceTiedLow       = 7,    /*!< Clock fixed at "L" */
} en_sys_ctrl_clock_source_t;

/**
 *****************************************************************************
 ** \brief Possible clocks for clock output and frequency determination
 *****************************************************************************/
typedef enum en_sys_ctrl_source_clock
{
    SysCtrlSourceClockSlowRcClock   = 0,    /*!< High-speed CR clock */
    SysCtrlSourceClockRcClock       = 1,    /*!< Low-speed CR clock */
    SysCtrlSourceClockSubClock      = 2,    /*!< Sub clock */
    SysCtrlSourceClockMainClock     = 3,    /*!< Main clock */
    SysCtrlSourceClockMainPll0Clock = 4,    /*!< PLL0 clock */
    SysCtrlSourceClockMainPll1Clock = 5,    /*!< PLL1 clock */
    SysCtrlSourceClockMainPll2Clock = 6,    /*!< PLL2 clock */
    SysCtrlSourceClockMainPll3Clock = 7,    /*!< PLL3 clock */
    SysCtrlSourceClockSscgPll0Clock = 8,    /*!< SSCG PLL0 clock */
    SysCtrlSourceClockSscgPll1Clock = 9,    /*!< SSCG PLL1 clock */
    SysCtrlSourceClockSscgPll2Clock = 10,   /*!< SSCG PLL2 clock */
    SysCtrlSourceClockSscgPll3Clock = 11    /*!< SSCG PLL3 clock */
} en_sys_ctrl_source_clock_t;

/**
 *****************************************************************************
 ** \brief Possible clocks for clock output and frequency determination
 *****************************************************************************/
typedef enum en_sys_ctrl_pll_input_clk
{
    SysCtrlPllInputClkMain   = 0,   /*!< Main clock */
    SysCtrlPllInputClkRc     = 1,   /*!< High-speed CR clock */
} en_sys_ctrl_pll_input_clk_t;

/**
 *****************************************************************************
 ** \brief Distributed clock types (internal clocks derived from a source clock)
 *****************************************************************************/
typedef enum en_sys_ctrl_distributed_clock
{
    SysCtrlDistributedClockLCP0A    /*!< CLK_LCP0A */
} en_sys_ctrl_distributed_clock_t;


/**
 *****************************************************************************
 ** \brief PLL settings configuration for RUN/PSS profile and PLL frequency calculation
 *****************************************************************************/
typedef struct stc_sys_ctrl_pll_settings
{
    en_sys_ctrl_pll_input_clk_t             enInputClk; /*!< Input clock selection */
    en_sys_ctrl_clock_prescaler_type_b_t    enDivL;     /*!< Input clock divider (max. SysCtrlPrescalerTypeBDiv6) */
    en_sys_ctrl_clock_prescaler_type_b_t    enDivM;     /*!< VCO output clock divider */
    uint8_t                                 u8DivN;     /*!< Feedback divider N value (see SYSCTRL_{pll}_DIVN_MIN/MAX for limitations of corresponding PLL) */
} stc_sys_ctrl_pll_settings_t;


/*****************************************************************************
 * Global function prototypes
 *****************************************************************************/
extern uint32_t    SysCtrl_GetSourceClockFrequencyHz(en_sys_ctrl_source_clock_t enSourceClockId);
extern uint32_t    SysCtrl_GetDistributedClockFrequencyHz(en_sys_ctrl_distributed_clock_t enDistributedClockId);
extern uint32_t    SysCtrl_CalculatePllFrequency(const stc_sys_ctrl_pll_settings_t* pstcPllSettings,
                                                 boolean_t bCalculateVcoFrequency);


#endif /* __SYSCTRL_H__ */
