#ifndef _NM_PROTOCOL_DEF_H_
    #define _NM_PROTOCOL_DEF_H_

    typedef union
    {
        struct
        {
            uint8_t DestID     :8;
            
            uint8_t Opcode     :8;
            
            uint8_t NM_Data0   :8;
            uint8_t NM_Data1   :8;
            uint8_t NM_Data2   :8;
            uint8_t NM_Data3   :8;
            uint8_t Reserved0  :8;
            uint8_t Reserved1  :8;
            
            uint8_t SourceID   :8;
            
            uint8_t ProceF     :8;
        }bits;
        uint8_t       msg[10];
    }_NMPDU;
    
    typedef struct
    {
        uint8_t NMactive;
        uint8_t bussleep;
        uint8_t BusOffEvent; //bus off emerge set 1 to BusOffEvent
        uint8_t WakeupEvent; //Wakeup
        uint8_t APPactive;
    }_NetWorkStatus;
    
    typedef struct
    {
        uint8_t ind;
        uint8_t ack;
    }_SleepStatus;
    
    typedef struct
    {
        uint8_t limphome;
        uint8_t stable;
    }_MarkerStatus;
   
      
    typedef struct
    {
        uint16_t OverTmaxTime;
        uint16_t TmaxTime;
        
        uint16_t OverTtypTime;
        uint16_t TtypTime;
        
        uint16_t OverTwbsTime;
        uint16_t TwbsTime;
        
        uint16_t OverSleepTime;
        uint16_t SleepTime;
        
        uint8_t  TtypEnable;
        
        uint8_t  TmaxEnable;
        
        uint8_t  TwbsEnable;
        
        uint8_t  SleepEnable;
        
        uint16_t NM_CheckTime;
    }_NM_TimeInfo;

    
#endif
