#ifndef API_CAN_H_
#define API_CAN_H_
#if (CAN_3RD)
#ifdef    GLOBALS_VARIABLE
#define   EXTERN_VAR

#else
#define   EXTERN_VAR     extern

#endif

typedef             char            INT8;
typedef             short  	    INT16;
typedef             unsigned char   INT8U;

#define CRC_AC_OK		0u
#define CRC_AC_ERROR	1u

enum {
	PROFILENONE = 0u, 
	PROFILE5,
	PROFILE11,
};

typedef struct {
    uint8_t ModuleFCA;
    uint8_t ModuleFCARecvCnt;
    uint8_t ModuleDAW;
    uint8_t ModuleDAWRecvCnt;
    uint8_t ModuleAVN_AV;
    uint8_t ModuleAVN_TBT;
    uint8_t ModuleAVN_Language;
    uint8_t ModuleBCW;
    uint8_t ModuleBCWRecvCnt;
    uint8_t ModuleHBA;
    uint8_t ModuleHBARecvCnt;
    uint8_t ModuleISLW;
    uint8_t ModuleISLWRecvCnt;
    uint8_t ModuleTPMS;
    uint8_t ModuleTPMSRecvCnt;
    uint8_t ModuleDCT;
    uint8_t ModuleDCTRecvCnt;
    uint8_t ModuleSBW;
    uint8_t ModuleSBWRecvCnt;
    uint8_t ModuleSMART;
    uint8_t ModuleSMARTRecvCnt;
    uint8_t ModuleBLE;
    uint8_t ModuleBLERecvCnt;
}SOFTWARE_VARIANT_CODING_STRUCT;
extern SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;  

extern uint8_t UDSSend;
extern uint8_t UDSSend_check;
extern void SetCan0Mode(uint8_t n);
extern void SetCan1Mode(uint8_t n);
extern void CANInit(void);
extern void Send0x553(void);


typedef struct
{   
    union
    {  
        uint8_t data[8];
        struct
        {   
            
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits;
    }msg;
}Send_7DF;  

typedef struct
{ 
    union
    {  
        uint8_t data[1];
        struct
        {   
            
            unsigned int   Byte0Data        : 8 ;
        }bits;
    }msg;
}Send_7DF_ectype;  
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_7C6; 
typedef struct
{       uint32_t ID; 
uint8_t DataLen;
uint8_t data[8];
struct
{   
    unsigned int   Byte0Data        : 8 ;
    unsigned int   Byte1Data        : 8 ;
    unsigned int   Byte2Data        : 8 ;
    unsigned int   Byte3Data        : 8 ;
    unsigned int   Byte4Data        : 8 ;
    unsigned int   Byte5Data        : 8 ;       
    unsigned int   Byte6Data        : 8 ;
    unsigned int   Byte7Data        : 8 ;
}; 
}Receive_7CE; 

typedef union {
	uint8_t Data[64];
	struct {
		uint32_t CLU_Crc1Val : 16;
		uint32_t CLU_AlvCnt1Val : 8;
		uint32_t CLU_PrtyBitSta : 2;
		uint32_t   : 2;
		uint32_t CLU_DtntOutSta : 2;
		uint32_t CLU_SpdUnitTyp : 2;
		uint32_t CLU_DisSpdDcmlVal : 2;
		uint32_t CLU_SWRCCrsMainSwSta : 2;
		uint32_t CLU_SWRCCrsSwSta : 3;
		uint32_t CLU_SWRCLFASwSta : 2;
		uint32_t CLU_SWRCSldMainSwSta : 2;
		uint32_t CLU_RhstaLvlSta : 5;
		uint32_t CLU_DisSpdVal : 10;
		uint32_t CLU_DisTyp : 2;
		uint32_t   : 2;
		uint32_t CLU_OKSwSta : 2;
		uint32_t CLU_DisSpdVal_KPH : 9;
		uint32_t   : 23;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
	};
}CLU_01_20ms_; 




typedef union {
	uint8_t Data[64];
	struct {
		uint32_t CLU_Crc2Val : 16;
		uint32_t CLU_AlvCnt2Val : 8;
		uint32_t CLU_OutTempCSta : 8;
		uint32_t CLU_DTEVal : 12;
		uint32_t CLU_TripUnitSta : 2;
		uint32_t CLU_AvgFuelCnsmptnVal : 10;
		uint32_t CLU_AvgFuelCnsmptnUnitSta : 2;
		uint32_t CLU_LoFuelWrngSta : 2;
		uint32_t CLU_RefuelDetSta : 2;
		uint32_t CLU_TerrainMainSwSta : 2;
		uint32_t CLU_LngSta : 5;
		uint32_t CLU_SRSWrngLmpSta : 3;
		uint32_t CLU_OdoVal : 24;
		uint32_t CLU_DawLastBrkTimeVal : 4;
		uint32_t CLU_RefuelWrnSta : 2;
		uint32_t CLU_IceWrnIndSta : 2;
		uint32_t CLU_DrvngModSwSta : 4;
		uint32_t CLU_FuelLvlSta : 7;
		uint32_t CLU_OutTempFSta : 8;
		uint32_t CLU_TerrainModSwSta : 3;
		uint32_t   : 2;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
		uint32_t   : 32;
	};
}CLU_02_100ms_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_null;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_111_;




typedef union 
{
    unsigned char      mdata[8];
    struct {
        unsigned int Byte0Data     :   8 ;
        unsigned int Byte1Data     :   8 ;
        unsigned int Byte2Data     :   8 ;
        unsigned int Byte3Data     :   8 ;
        unsigned int Byte4Data     :   8 ;
        unsigned int Byte5Data     :   8 ;
        unsigned int Byte6Data     :   8 ;
        unsigned int Byte7Data     :   8 ;
    };
}Send_Data;

typedef union 
{
    unsigned char      mdata[1];
    struct {
        unsigned int Byte0Data     :   8 ;
    };
}SRC_;

//0x180
typedef union {
        uint8_t Data[64];
        struct {
        uint32_t CLU_Crc17Val    : 16;
        uint32_t CLU_AlvCnt17Val : 8;
        uint32_t              : 8;
        uint32_t              : 8;
        uint32_t              : 8;
        uint32_t              : 6;
        uint32_t CLU_PddlUpSwSta : 1;
        uint32_t CLU_PddlDnSwSta : 1;
        uint32_t              : 8;
        uint32_t              : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                  : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32;
        uint32_t                 : 32; 
        };
}CLU_17_20ms_;

EXTERN_VAR     volatile Send_7DF             Send_7DF_Data ;//LHY  
EXTERN_VAR     volatile Send_7DF_ectype            Send_7DF_ectype_Data ;//LHY  
EXTERN_VAR     volatile Send_7C6             Send_7C6_Data ;//LHY 
EXTERN_VAR     volatile Receive_7CE          Receive_7CE_Data ;//LHY
EXTERN_VAR     volatile CLU_01_20ms_          CLU_01_20ms;
EXTERN_VAR     volatile CLU_17_20ms_          CLU_17_20ms;
EXTERN_VAR     volatile CLU_02_100ms_         CLU_02_100ms;
//
EXTERN_VAR     volatile Send_null             Send_06F ;//LHY  
EXTERN_VAR     volatile Send_null             Send_20A ;//LHY 
EXTERN_VAR     volatile Send_null             Send_1F0 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_060 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_220 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_12A ;//LHY  
EXTERN_VAR     volatile Send_null             Send_0EA ;//LHY 
EXTERN_VAR     volatile Send_null             Send_1A0 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_3A0 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_1A5 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_040 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_3B3 ;//LHY
EXTERN_VAR     volatile Send_null             Send_3BF ;//LHY
EXTERN_VAR     volatile Send_null             Send_586 ;//LHY  
EXTERN_VAR     volatile Send_111_             Send_111 ;//LHY 

EXTERN_VAR     volatile SRC_                  CRC001 ;//LHY 
EXTERN_VAR     volatile Send_Data            Send_7CE_Data;
EXTERN_VAR  void Can_Clear(uint8_t *data, uint8_t DataLen);
EXTERN_VAR  void CanCRCInint(void);
EXTERN_VAR  uint16_t Calculate_CRC16(uint8_t puchMsg[], uint32_t usDataLen);
EXTERN_VAR  uint8_t Calculate_CRC8(uint8_t puchMsg[], uint32_t usDataLen);
EXTERN_VAR  void    CalCrcVal(uint32_t ID, uint8_t Length, uint8_t data[]); 


#endif
#endif /* API_CAN_H_ */