#include "common_include.h"
#include "bsp_button.h"
#include "bsp_speed_check.h"
#include "bsp_app_led_output.h"
#include "bsp_app_tft_output.h"

#define STATIC_BEGIN_CHECK_TIME 6*1000


uint8_t AutoStep7_SubStep = 0;
//uint8_t num4[10];
uint8_t AutoStep0Result = 0;
uint8_t AutoStep1Result = 0;
uint8_t AutoStep2Result = 0;
uint8_t AutoStep3Result = 0;
uint8_t AutoStep4Result = 0;
uint8_t AutoStep5Result = 0;
uint8_t AutoStep6Result = 0;
uint8_t AutoStep7Result = 0;
uint8_t AutoStep8Result = 0;
uint8_t AutoStep9Result = 0;
uint8_t AutoStep10Result = 0;
uint8_t DetentValid = 0;
uint8_t CheckIll_LV12_OkFlag = 0;
uint8_t CheckIll_LV18_OkFlag = 0;
uint8_t SW1_CHECK_RESULT = 0;
uint8_t SW2_CHECK_RESULT = 0;
uint8_t SW_Data[10];
uint8_t SW_Data_Short[10];
uint8_t HW_Data[10];
uint8_t HJYB_Data[10];
uint8_t DAY_Data[10];
uint8_t NUM1_Data[10];
uint8_t NUM2_Data[10];
uint8_t NUM3_Data[10];
uint8_t NUM4_Data[21];
uint8_t NUM5_Data[10];
uint8_t NUM6_Data[10];
uint8_t NUM7_Data[10];
uint8_t NUM8_Data[20];
uint8_t CSW_Data[10];
uint8_t SendSW;
uint8_t SendNUM1;
uint8_t SendNUM2;
uint8_t SendNUM3;
uint8_t SendNUM4;
uint8_t SendNUM5;
uint8_t SendNUM6;
uint8_t SendNUM7;
uint8_t SendNUM8;
uint8_t SendHW;
uint8_t SendHJYB;
uint8_t SendDAY;


uint8_t SendCSW;
uint32_t CurRpm = 0;
uint16_t CheckOkTimerCnts = 0;
uint8_t g_uiTripSW_Step  = 0;
#define   GetNUM1(idx)  \
if (MultiplePack.Data[idx] >= 0x00)\
    NUM1_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM2(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM2_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM3(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM3_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM4(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM4_Data[uiSWidx++] = MultiplePack.Data[idx]
    //num4[uiSWidx++] = MultiplePack.Data[idx]
    

#define   GetNUM5(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM5_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM6(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM6_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM7(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM7_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetNUM8(idx)  \
    if (MultiplePack.Data[idx] >= 0x00)\
    NUM8_Data[uiSWidx++] = MultiplePack.Data[idx]


#define   GetSW(idx)  \
if (MultiplePack.Data[idx] >= 0x21)\
    SW_Data[uiSWidx++] = MultiplePack.Data[idx]

#define   GetHW(idx)  \
if (MultiplePack.Data[idx] >= 0x21)\
    HW_Data[uiHWidx++] = MultiplePack.Data[idx]

#define   GetHJYB(idx)  \
if (MultiplePack.Data[idx] >= 0x21)\
    HJYB_Data[uiHWidx++] = MultiplePack.Data[idx] 

#define   GetDAY(idx)  \
if (MultiplePack.Data[idx] >= 0x21)\
    DAY_Data[uiHWidx++] = MultiplePack.Data[idx]  
 
    
#define   GetCSW(idx)  \
if (CorePack.Data[idx] >= 0x00)\
    CSW_Data[uiCSWidx++] = CorePack.Data[idx]    

uint8_t g_uiBackDoorFlag = 0;
uint8_t g_uiStaticCurrentCheckFlag = 0;
uint8_t g_uiOtherCheckCurStep = AUTO_BEGIN;
void Auto_Init(uint8_t uiType)
{
    AutoStep0Result = 0;
    AutoStep1Result = 0;
    AutoStep2Result = 0;
    AutoStep3Result = 0;
    AutoStep4Result = 0;
    AutoStep5Result = 0;
    AutoStep6Result = 0;
    AutoStep7Result = 0;
    AutoStep8Result = 0;
    AutoStep9Result = 0;
    AutoStep7_SubStep = 0;
    g_uiStaticCurrentCheckFlag = 0;
    ButtomCurrent.enable = 1;
    ButtomCurrent.count = 0;
    SetStartTime(0);
    g_uiOtherCheckCurStep = AUTO_BEGIN;
    SW1_CHECK_RESULT = 0;
    SW2_CHECK_RESULT = 0;
    EngineState = 0;
    GearCheckResult = 0;
    
    CAN_0x4F1 = 0;
    CAN_0x1DF = 0;

    CAN_0x225 = 0;
    CAN_0x620 = 0;
    
    GearDisp = 0;
    Freque_Flag = 0;

    CheckIll_LV12_OkFlag = 0;
    CheckIll_LV18_OkFlag = 0;
    
    ErrorCode = 0;
    Default_flag = 1;

    RxFinish = UNFINISH;
    SendSW = UNFINISH;
    SendHW = UNFINISH;
    SendHJYB = UNFINISH;
    SendDAY = UNFINISH;
    SendNUM1 = UNFINISH;
    SendNUM2 = UNFINISH;
    SendNUM3 = UNFINISH;
    SendNUM4 = UNFINISH;
    SendNUM5 = UNFINISH;
    SendNUM6 = UNFINISH;
    SendNUM7 = UNFINISH;
    SendNUM8 = UNFINISH;
    SendCSW = UNFINISH;
    
    ButtomCurrent.statu = 0;
    ButtomCurrent.Flag = 0;
    ButtomCurrent.count = 0;
    SetStartTime(0);
    g_uiTripSW_Step = 0;
    SetCurrentStep(0);
    InitPressKeySimulation();
    g_uiStaticCurrentCheckFlag = uiType;
    CheckStep = 0;

    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    memset(CheckResult, 0, sizeof(CheckResult));
}

//Step 0
en_port_gpio_level_t g_MCanLineLevel = PortGpioHigh;
en_port_gpio_level_t g_CCanLineLevel = PortGpioHigh;
void MessageCheck(void)
{
#if (CAN_2ND)        
    CAN_0x225 = 1;
    CAN_0x620 = 1;
#endif         
#if (CAN_3RD)
    CAN_0x4F1 = 1;
    CAN_0x1DF = 1;
#endif
#if ((PRO_NU2) || (PRO_NX4C))//No M Can output
    CAN_0x620 = 1;
#endif
    if (LessThan(1000)) {
        if (g_MCanLineLevel == PortGpioHigh)
            Port_GetPortPinLevel(0, 30,&g_MCanLineLevel);
        if (g_CCanLineLevel == PortGpioHigh)
            Port_GetPortPinLevel(0, 31,&g_CCanLineLevel);
    }
    else if (GreaterThan(1000)) {
        if (g_MCanLineLevel == PortGpioLow) {
            g_stCheckResult.MsgCheck_CcanState = 1;
            SetError(03);//?????????
            AutoStep0Result = 4;
        }
        else if (g_CCanLineLevel == PortGpioLow){
            g_stCheckResult.MsgCheck_CcanState = 1;
            SetError(04);//?????????
            AutoStep0Result = 5;
        }
        else  {
            if(CAN_0x4F1 == 0 || CAN_0x225 == 0){//C CAN
                g_stCheckResult.MsgCheck_CcanMsgOut = 1;
                SetError(01);//?????????
                AutoStep0Result = 2;
            }
            else if(CAN_0x1DF == 0 || CAN_0x620 == 0){//M CAN
                g_stCheckResult.MsgCheck_McanMsgOut = 1;
                SetError(02);//?????????
                AutoStep0Result = 3;
            }
            else {    
                ButtomCurrent.count++;
                SetStartTime(0);
                AutoStep0Result = 1;
            }
        }
        if(AutoStep0Result >= 2) {
            Buzzer_Alarm();
        }
    }
}

uint8_t HJ_SWStateFlag = 0;
uint8_t HJ_HWStateFlag = 0;
uint8_t HJ_HJYBStateFlag = 0;
uint8_t HJ_DAYFlag = 0;
uint8_t NUM1Flag = 0;
uint8_t NUM2Flag = 0;
uint8_t NUM3Flag = 0;
uint8_t NUM4Flag = 0;
uint8_t NUM5Flag = 0;
uint8_t NUM6Flag = 0;
uint8_t NUM7Flag = 0;
uint8_t NUM8Flag = 0;
uint16_t time1=0;
uint16_t count1=0;

uint16_t FuelResTest = 0;
void TestReadFuel(void)
{
    Send_7CE_Data.Byte0Data = 0xAB;
    Send_7CE_Data.Byte1Data = 0xCD;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7df, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 2);
    Delay(5);
    Send_7CE_Data.Byte0Data = 0x03;
    Send_7CE_Data.Byte1Data = 0x22;
    Send_7CE_Data.Byte2Data = 0xFE;
    Send_7CE_Data.Byte3Data = 0xDC;
    Send_7CE_Data.Byte4Data = 0x00;
    Send_7CE_Data.Byte5Data = 0x00;
    Send_7CE_Data.Byte6Data = 0x00;
    Send_7CE_Data.Byte7Data = 0x00;
    CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_41, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
}

//Step 1
//内部版本号1
void build_number1(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;
  

    if (BetweenTime(0,100) && SendNUM1 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM1 == UNFINISH) {
            memset(NUM1_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x95;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM1 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM1(0);GetNUM1(1);GetNUM1(2);GetNUM1(3);GetNUM1(4);GetNUM1(5);GetNUM1(6);GetNUM1(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM1Flag = NUM1_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM1 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM1Flag = NUM1_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM1 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM1Flag = NUM1_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}

//内部版本号2
void build_number2(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM2 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM2 == UNFINISH) {
            memset(NUM2_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x93;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM2 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM2(0);GetNUM2(1);GetNUM2(2);GetNUM2(3);GetNUM2(4);GetNUM2(5);GetNUM2(6);GetNUM2(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM2Flag = NUM2_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM2 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM2Flag = NUM2_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM2 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM2Flag = NUM2_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}


//内部版本号3
void build_number3(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM3 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM3 == UNFINISH) {
            memset(NUM3_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x80;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM3 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM3(0);GetNUM3(1);GetNUM3(2);GetNUM3(3);GetNUM3(4);GetNUM3(5);GetNUM3(6);GetNUM3(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM3Flag = NUM3_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM3 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM3Flag = NUM3_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM3 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM3Flag = NUM3_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
//内部版本号4
void build_number4(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM4 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM4 == UNFINISH) {
            memset(NUM4_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x87;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM4 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        for(int i=0; i<=20; i++)
        {
            GetNUM4(i);
        }
        //GetNUM4(0);GetNUM4(1);GetNUM4(2);GetNUM4(3);GetNUM4(4);GetNUM4(5);GetNUM4(6);GetNUM4(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM4Flag = NUM4_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM2 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM4Flag = NUM4_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM4 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM4Flag = NUM4_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}

//内部版本号5
void build_number5(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM5 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM5 == UNFINISH) {
            memset(NUM5_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0x00;
            Send_7CE_Data.Byte3Data = 0x05;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM5 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM5(0);GetNUM5(1);GetNUM5(2);GetNUM5(3);GetNUM5(4);GetNUM5(5);GetNUM5(6);GetNUM5(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM5Flag = NUM5_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM5 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM5Flag = NUM5_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM5 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM5Flag = NUM5_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}

//内部版本号6
void build_number6(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM6 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM6 == UNFINISH) {
            memset(NUM6_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0x10;
            Send_7CE_Data.Byte3Data = 0x24;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM6 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM6(5);GetNUM6(6);GetNUM6(7);GetNUM6(8);GetNUM6(9);GetNUM6(10);GetNUM6(11);GetNUM6(12);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM6Flag = NUM6_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM6 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM6Flag = NUM6_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM6 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM6Flag = NUM6_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}

//内部版本号7
void build_number7(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM7 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM7 == UNFINISH) {
            memset(NUM7_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0x00;
            Send_7CE_Data.Byte3Data = 0x07;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM7 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM7(0);GetNUM7(1);GetNUM7(2);GetNUM7(3);GetNUM7(4);GetNUM7(5);GetNUM7(6);GetNUM7(7);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM7Flag = NUM7_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM7 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM7Flag = NUM7_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM7 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM7Flag = NUM7_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}

//内部版本号8
void build_number8(void)
{   
    
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;


    if (BetweenTime(0,100) && SendNUM8 == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(100,200) && SendNUM8 == UNFINISH) {
            memset(NUM8_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0x00;
            Send_7CE_Data.Byte3Data = 0x08;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendNUM8 = FINISH;
            
    }
    
    if (BetweenTime(100,200) && RxFinish == FINISH ) {  //??????? 
        GetNUM8(0);GetNUM8(1);GetNUM8(2);GetNUM8(3);GetNUM8(4);GetNUM8(5);GetNUM8(6);GetNUM8(7);
        GetNUM8(8);GetNUM8(9);GetNUM8(10);GetNUM8(11);GetNUM8(12);
    }
    else if (BetweenTime(200,300) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        NUM7Flag = NUM7_UDSStateSuc;
    }
    else if (GreaterThan(300) && (MultiplePack.Data[0] != 0x42)){
        SendNUM8 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        NUM7Flag = NUM7_UDSStateFail;
    } else if (GreaterThan(400)){
        SendNUM8 = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        NUM7Flag = NUM7_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
void SWandHW_Version(void)
{   
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;
    if (BetweenTime(0,500) && SendSW == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(500,1000) && SendSW == UNFINISH) {
            memset(NUM2_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x95;//
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendSW = FINISH;
    }
    
    if (BetweenTime(100,3000) && RxFinish == FINISH ) {  //??????? 
        //Delay(1000);
        // if ((MultiplePack.Data[0] == 0x53) && (MultiplePack.Data[3] == 0x30)) {             
            GetSW(0);GetSW(1);GetSW(2);GetSW(3);GetSW(4);GetSW(5);GetSW(6);GetSW(7);// 1.00.00
      //      memcpy(SW_Data_Short,SW_Data,4);  
//        } 
    }
    else if (BetweenTime(3000,3500) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        HJ_SWStateFlag = HJ_UDSStateSuc;
    }
    else if (GreaterThan(3500) && (MultiplePack.Data[0] != 0x42)){
        SendSW = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        HJ_SWStateFlag = HJ_UDSStateFail;
    } else if (GreaterThan(4000)){
        SendSW = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        HJ_SWStateFlag = HJ_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
//HW

void HWandHW_Version(void)
{   
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;
    if (BetweenTime(0,500) && SendHW == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(500,1000) && SendHW == UNFINISH) {
            memset(HW_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x93;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendHW = FINISH;
    }
    
    if (BetweenTime(100,3000) && RxFinish == FINISH ) {  //??????? 
        //Delay(1000);
        // if ((MultiplePack.Data[0] == 0x53) && (MultiplePack.Data[3] == 0x30)) {             
            GetHW(0);GetHW(1);GetHW(2);GetHW(3);GetHW(4);GetHW(5);GetHW(6);GetHW(7);// 1.00.00
    //        memcpy(SW_Data_Short,SW_Data,4);  
//        } 
    }
    else if (BetweenTime(3000,3500) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        HJ_HWStateFlag = HW_UDSStateSuc;
    }
    else if (GreaterThan(3500) && (MultiplePack.Data[0] != 0x42)){
        SendHW = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        HJ_HWStateFlag = HW_UDSStateFail;
    } else if (GreaterThan(4000)){
        SendHW = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        HJ_HWStateFlag = HW_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
//HJYB
void HJYB_Version(void)
{   
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;
    if (BetweenTime(0,500) && SendHJYB == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(500,1000) && SendHJYB == UNFINISH) {
            memset(HJYB_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x87;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendHJYB = FINISH;
    }
    
    if (BetweenTime(100,3000) && RxFinish == FINISH ) {  //??????? 
        GetHJYB(0);GetHJYB(1);GetHJYB(2);GetHJYB(3);GetHJYB(4);GetHJYB(5);GetHJYB(6);GetHJYB(7);
    }
    else if (BetweenTime(3000,3500) && MultiplePack.Data[0] != 0x0){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        HJ_HJYBStateFlag = HJYB_UDSStateSuc;
    }
    else if (GreaterThan(3500) && (MultiplePack.Data[0] != 0x42)){
        SendHJYB = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        HJ_HJYBStateFlag = HJYB_UDSStateFail;
    } else if (GreaterThan(4000)){
        SendHJYB = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        HJ_HJYBStateFlag = HJYB_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
//����

void DAY_Version(void)
{   
    uint8_t uiOffset = 0;
    uint8_t uiSWidx = 0;
    uint8_t uiHWidx = 0;
    uint8_t uiCSWidx = 0;
    if (BetweenTime(0,500) && SendDAY == UNFINISH) {
        //SendCan0Message_7DF();
        g_uiBackDoorFlag = 1;    
        CANSendEnable = OFF; //??????????????
        RxFinish = UNFINISH;
    }
  
    if (BetweenTime(500,1000) && SendDAY == UNFINISH) {
            memset(DAY_Data,0 , 8);
            memset(TestSrcBuf,0,sizeof(TestSrcBuf));
            memset(MultiplePack.Data,0,256);
            MyRecvCount = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0x10;
            Send_7CE_Data.Byte3Data = 0x28;
            Send_7CE_Data.Byte4Data = 0x00;
            Send_7CE_Data.Byte5Data = 0x00;
            Send_7CE_Data.Byte6Data = 0x00;
            Send_7CE_Data.Byte7Data = 0x00;
            CanFD_Send_StandMsg(CANFD0_Type, 0x781, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 8);
            SendDAY = FINISH;
    }
    
    if (BetweenTime(100,3000) && RxFinish == FINISH ) {  //??????? 
        GetDAY(0);GetDAY(1);GetDAY(2);GetDAY(3);GetDAY(4);GetDAY(5);GetDAY(6);GetDAY(7);
    }
    else if (BetweenTime(3000,3500) && SendCSW == UNFINISH){
        CANSendEnable = ON; //??????????????
        RxFinish  = FINISH;
        ButtomCurrent.count++;
        SetStartTime(0);
        AutoStep1Result = 1;
        HJ_DAYFlag = DAY_UDSStateSuc;
    }
    else if (GreaterThan(3500) && (MultiplePack.Data[0] != 0x42)){
        SendDAY = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(11);//?????????
        AutoStep1Result = 2;
        HJ_DAYFlag = DAY_UDSStateFail;
    } else if (GreaterThan(4000)){
        SendDAY = UNFINISH;
        g_stCheckResult.SW_VER = 0;
        g_stCheckResult.HW_VER = 0;
        g_stCheckResult.CB_VER = 0;        
        SetError(12);//?????????
        AutoStep1Result = 2;
        HJ_DAYFlag = DAY_UDSStateFail;
    }
    if(AutoStep1Result == 2) {
        Buzzer_Alarm();
    }
}
void CompilationDate(void)
{
    Send_7CE_Data.Byte0Data = 0x03;
    Send_7CE_Data.Byte1Data = 0x22;
    Send_7CE_Data.Byte2Data = 0xF1;
    Send_7CE_Data.Byte3Data = 0x8B;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
}
//Step 2
void TripSW1Check(void)
{
    switch(g_uiTripSW_Step) 
    {
        case 0:
            SetStartTime(0);
            SetCurrentStep(0);
            InitPressKeySimulation();
            g_uiTripSW_Step = 1;
            break;
        case 1:
            SetPressKeySequence(KEY_SW1_OK,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            DoPressKeySimulation(TIME_0);
            if (GreaterThan(1000)) {
                g_uiTripSW_Step = 2;
            }
            break;
        case 2:
            if (SW1_CHECK_RESULT == 1) {
                ButtomCurrent.count++;
                SetStartTime(0);
                SetCurrentStep(0);
                AutoStep2Result = 1; 
                g_uiTripSW_Step = 0;
            }
            else{
                g_stCheckResult.TripC_SW1 = 1;
                SetError(21);//?????????
                AutoStep2Result = 2;
            }
            break;
    }
//#if (PRO_SP2) 
//        LampState_M.Lamps.TripSW1_4  = 1;//KEY_SW1_OK
//#elif (PRO_SG2)
//        SWRC_01_200ms.Cluster_TripOkSwSta = 1;
//#else        
//        LampState_M.Lamps.TripSW1_5  = 1;//KEY_SW1_OK
//#endif        
//    }
//    else if (LessThan(200)) {
//#if (PRO_SP2) 
//        LampState_M.Lamps.TripSW1_4  = 0;//KEY_SW1_OK
//#elif (PRO_SG2)
//        SWRC_01_200ms.Cluster_TripOkSwSta = 0;
//#else        
//        LampState_M.Lamps.TripSW1_5  = 0;//KEY_SW1_OK
//#endif 

    if(AutoStep2Result == 2) {
        Buzzer_Alarm();
        //LampState_M.Lamps.TripSW1_5  = 0;
    }
}
//Step 3
void TripSW2Check(void)
{
    switch(g_uiTripSW_Step) 
    {
        case 0:
            SetStartTime(0);
            SetCurrentStep(0);
            InitPressKeySimulation();
            g_uiTripSW_Step = 1;
            break;
        case 1:
            SetPressKeySequence(KEY_SW2_CRUISE,KEY_SW2_CRUISE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            DoPressKeySimulation(TIME_400);
            if (GreaterThan(1000)) {
                g_uiTripSW_Step = 2;
            }
            break;
        case 2:
            if (SW2_CHECK_RESULT == 1) {
                ButtomCurrent.count++;
                SetStartTime(0);
                SetCurrentStep(0);
                AutoStep3Result = 1; 
            }
            else{
                g_stCheckResult.TripC_SW2 = 1;
                SetError(31);//?????????
                AutoStep3Result = 2;
            }
            break;
    }
    if(AutoStep3Result == 2) {
        Buzzer_Alarm();
    }
}
//Step 4
void EngStateCheck(void)
{
#if (CAN_2ND)  
    EMS16.msg.bits.ENG_STAT = 0x3;
#endif    
    //GET_BUTTON_EngRun_LEVEL;
    if (/*(BUTTON_EngRun_IN == 1) && */GreaterThan(320)) {
        AutoStep4Result = 2;
        g_stCheckResult.ENG_STATE = 1;
        SetError(41);
    } else if (GreaterThan(320)) {
        SetStartTime(0);
        ButtomCurrent.count++;
        AutoStep4Result = 1; 
    }
    if(AutoStep4Result == 2) {
        Buzzer_Alarm();
    }
}

//Step 5
void GearCheck(void)
{     
 #if (PRO_AC3_PE)
    if(BetweenTime(1000, 2000)){// Gear R
        //TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
        //HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 7;
        PAS11.msg.bits.CF_Gway_PASCheckSound = 0x1;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x4;
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
       HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x7; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            SetError(52);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 2;
    }
    else if(BetweenTime(2000, 3000)){// Gear N
        //TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
        //HTCU_05_10ms.HDCT_GearSelDis = 0x6;
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 6;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 6;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x3;
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
       HTCU_05_10ms.HDCT_GearSelDis = 0x6; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x6; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);

            SetError(53);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 3;
    }
    else if(BetweenTime(3000, 4000)){// Gear D
        //TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
        //HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 5;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 5;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x2;
        
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
       HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x5; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            SetError(54);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 4;
    }
    else if(BetweenTime(4000, 5000)){// Gear S
        //TCU_01_10ms.TCU_GearSlctDis = 0x4;//S
        //HTCU_05_10ms.HDCT_GearSelDis = 0x4; 
#if (CAN_2ND)       
#if (PRO_BR2)
        Err_Status = 0;//No S gear
#else
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 4;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x1;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
#endif        
#endif
#if (CAN_3RD)
        TCU_01_10ms.TCU_GearSlctDis = 0x4;//S
        HTCU_05_10ms.HDCT_GearSelDis = 0x4 ;
        HTCU_04_10ms.HTCU_GearSlctrDis = 0x4 ;
        DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            SetError(55);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 5;
    }
    else if(GreaterThan(7000)) {
        if(GearCheckResult == 1) {
            ButtomCurrent.count++;
            AutoStep5Result = 1;
            SetStartTime(0);
#if (CAN_2ND)      
        CGW_PC5.msg.bits.G_SEL_DISP = 0;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 0;
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
       HTCU_05_10ms.HDCT_GearSelDis = 0x0 ;
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x0 ;
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        }
        else {
            SetStartTime(7000);
            SetError(56);//?????????
            AutoStep5Result = 2;
        }
    }
    if(AutoStep5Result == 2) {
        Buzzer_Alarm();
    }
#elif (PRO_QYC)
    if(BetweenTime(1000, 2000)){// Gear P
        //TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
        //HTCU_05_10ms.HDCT_GearSelDis = 0x0 ;
 #if (CAN_2ND)      
        CGW_PC5.msg.bits.G_SEL_DISP = 0;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 0;
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x0;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
       HTCU_05_10ms.HDCT_GearSelDis = 0x0;
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x0;
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_P = 1;            
            SetError(51);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 1;
    }
    else if(BetweenTime(2000, 3000)){// Gear R
        //TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
        //HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 7;
        PAS11.msg.bits.CF_Gway_PASCheckSound = 0x1;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x4;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x7;
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
       HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x7; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_R = 1;            
            SetError(52);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 2;
    }
    else if(BetweenTime(3000, 4000)){// Gear N
        //TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
        //HTCU_05_10ms.HDCT_GearSelDis = 0x6;
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 6;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 6;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x3;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x6;
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
       HTCU_05_10ms.HDCT_GearSelDis = 0x6; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x6; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_N = 1;
            SetError(53);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 3;
    }
    else if(BetweenTime(4000, 5000)){// Gear D
        //TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
        //HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 5;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 5;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x2;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x5;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
       HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x5; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_D = 1;            
            SetError(54);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 4;
    }
    else if(GreaterThan(6000)) {
        if(GearCheckResult == 1) {
            ButtomCurrent.count++;
            AutoStep5Result = 1;
            SetStartTime(0);
#if (CAN_2ND)      
        CGW_PC5.msg.bits.G_SEL_DISP = 0;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 0;
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x0;
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
       HTCU_05_10ms.HDCT_GearSelDis = 0x0 ;
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x0 ;
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        }
        else {
            SetStartTime(7000);
            g_stCheckResult.GEAR_P = 1;            
            SetError(56);//?????????
            AutoStep5Result = 2;
        }
    }
    if(AutoStep5Result == 2) {
        Buzzer_Alarm();
    }
#else //AC3????
    if(BetweenTime(1000, 2000)){// Gear P
        //TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
        //HTCU_05_10ms.HDCT_GearSelDis = 0x0 ;
 #if (CAN_2ND)      
        CGW_PC5.msg.bits.G_SEL_DISP = 0;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 0;
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x0;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
       HTCU_05_10ms.HDCT_GearSelDis = 0x0;
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x0;
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_P = 1;            
            SetError(51);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 1;
    }
    else if(BetweenTime(2000, 3000)){// Gear R
        //TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
        //HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 7;
        PAS11.msg.bits.CF_Gway_PASCheckSound = 0x1;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x4;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x7;
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x7;//R
       HTCU_05_10ms.HDCT_GearSelDis = 0x7; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x7; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            //g_stCheckResult.GEAR_R = 1;            
            SetError(52);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 2;
    }
    else if(BetweenTime(3000, 4000)){// Gear N
        //TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
        //HTCU_05_10ms.HDCT_GearSelDis = 0x6;
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 6;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 6;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x3;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x6;
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x6;//N
       HTCU_05_10ms.HDCT_GearSelDis = 0x6; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x6; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_N = 1;
            SetError(53);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 3;
    }
    else if(BetweenTime(4000, 5000)){// Gear D
        //TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
        //HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
#if (CAN_2ND)       
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 5;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 5;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x2;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x5;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
#endif
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x5;//D
       HTCU_05_10ms.HDCT_GearSelDis = 0x5; 
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x5; 
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_D = 1;            
            SetError(54);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 4;
    }
    else if(BetweenTime(5000, 6000)){// Gear S
        //TCU_01_10ms.TCU_GearSlctDis = 0x4;//S
        //HTCU_05_10ms.HDCT_GearSelDis = 0x4; 
#if (CAN_2ND)       
#if (PRO_BR2)
        Err_Status = 0;//No S gear
#else
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC5.msg.bits.G_SEL_DISP = 4;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x1;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x4;
#endif        
#endif
#if (CAN_3RD)
        TCU_01_10ms.TCU_GearSlctDis = 0x4;//S
        HTCU_05_10ms.HDCT_GearSelDis = 0x4 ;
        HTCU_04_10ms.HTCU_GearSlctrDis = 0x4 ;
        DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        if (Err_Status == 0) {
            GearCheckResult = 1;
        } else {
            GearCheckResult = 0;
            SetStartTime(7000);
            g_stCheckResult.GEAR_S = 1;            
            SetError(55);//?????????
            AutoStep5Result = 2;
        }
        GearDisp = 5;
    }
    else if(GreaterThan(7000)) {
        if(GearCheckResult == 1) {
            ButtomCurrent.count++;
            AutoStep5Result = 1;
            SetStartTime(0);
#if (CAN_2ND)      
        CGW_PC5.msg.bits.G_SEL_DISP = 0;
        CGW_PC5.msg.bits.TCU_GearSlctDis = 0;
        CGW_PC11.TCU_TYPE_eCLUTCH = 0x3;
        CGW_PC11.CF_IMT_DispCMD = 0x1;
        CGW_PC11.CF_IMT_EOL_state = 0x0;
        CGW_PC11.G_SEL_DISP_eClutch = 0x0;
        DearCheck(CGW_PC5.msg.bits.G_SEL_DISP);
        HEV_PC5.msg.bits.CF_Tcu_GarSelDisp = 0x0;
#endif 
#if (CAN_3RD)
       TCU_01_10ms.TCU_GearSlctDis = 0x0;//P
       HTCU_05_10ms.HDCT_GearSelDis = 0x0 ;
   	   HTCU_04_10ms.HTCU_GearSlctrDis = 0x0 ;
       DearCheck(HTCU_04_10ms.HTCU_GearSlctrDis);
#endif
        }
        else {
            SetStartTime(7000);
            g_stCheckResult.GEAR_P = 1;            
            SetError(56);//?????????
            AutoStep5Result = 2;
        }
    }
    if(AutoStep5Result == 2) {
        Buzzer_Alarm();
    }
#endif
}

//Step 6
void Gnd3Check(void)
{
#if (PRO_US4)
    RxFinish = UNFINISH;
    Send_7CE_Data.Byte0Data = 0x03;
    Send_7CE_Data.Byte1Data = 0x22;
    Send_7CE_Data.Byte2Data = 0xF1;
    Send_7CE_Data.Byte3Data = 0x8B;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_39, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
 if (RxFinish == FINISH){
        ButtomCurrent.count++;
    }
#else
    GET_BUTTON_GND_Signal3_LEVEL;
    if ((BUTTON_GND_Signal3_IN == 1) && GreaterThan(320)) {
        AutoStep6Result = 2; 
        g_stCheckResult.GND_SIGNAL3 = 1;        
        SetError(61);//?????????
    } else if (GreaterThan(320)) {
        SetStartTime(0);
        ButtomCurrent.count++;
        AutoStep6Result = 1; 
    }
    if(AutoStep6Result == 2) {
        Buzzer_Alarm();
    }
#endif
}

//Step 7
void RheoCheck(void)
{
    if (BetweenTime(0,5000)) {
        Default_flag = 0;
        Port_SetPortPinLevel(2, 12, PortGpioLow);
    } else if (BetweenTime(5100,5400)) {    
#if (CAN_2ND)       
        if (CLU_HU_PE_01.Clu_RheostatLvl == 0x1) {
            AutoStep7_SubStep++;
            SetStartTime(5500);
        }
#endif  
#if (CAN_3RD)       
        if (CLU_01_20ms.CLU_RhstaLvlSta == 0x1) {
            AutoStep7_SubStep++;
            SetStartTime(5500);
        }
#endif 
    } else if (BetweenTime(5500,10500)) {    

    } else if (BetweenTime(10600,10900)) {
#if (CAN_2ND)       
        if (CLU_HU_PE_01.Clu_RheostatLvl == 0x14) {
            AutoStep7_SubStep++;
            SetStartTime(11000);
        }
#endif  
#if (CAN_3RD)       
        if (CLU_01_20ms.CLU_RhstaLvlSta == 0x14) {
            AutoStep7_SubStep++;
            SetStartTime(11000);
        }
#endif 
    } else if (GreaterThan(11000)) {
        Default_flag = 1;
        Port_SetPortPinLevel(2, 12, PortGpioLow);
        Port_SetPortPinLevel(2, 13, PortGpioLow);
        if(AutoStep7_SubStep == 2) {
           AutoStep7Result = 1;
           ButtomCurrent.count++;
           SetStartTime(0);
        }
        else {
            SetStartTime(0);
            AutoStep7Result = 2;
            g_stCheckResult.RHEO_01 = 1;        
            SetError(71);//?????????
        }
    }
    if(AutoStep7Result == 2) {
        Buzzer_Alarm();
    }
}

void SetDetentSignal(uint8_t uiCheckSignal)
{
#if (CAN_2ND) 
        CGW2.msg.bits.CF_Gway_AutoLightValue = uiCheckSignal;
#endif
#if (CAN_3RD)
        BCM_09_200ms.Lamp_AutoLtSnsrNightSta = uiCheckSignal;
#endif
}

uint8_t GetDetentSignal(void)
{
#if (CAN_2ND) 
        return CGW2.msg.bits.CF_Gway_AutoLightValue;
#endif
#if (CAN_3RD)
        return BCM_09_200ms.Lamp_AutoLtSnsrNightSta;
#endif
}

void SetAutolightMode(uint8_t uiModeType)
{
        // 1 ????? 0 ??????
#if (CAN_2ND)         
        CGW2.msg.bits.CF_Gway_AvTail = uiModeType;
        CGW2.msg.bits.CF_Gway_AutoLightValue = 0;
#endif
#if (CAN_3RD)
        BCM_07_200ms.Lamp_AvTailLmpSta = uiModeType;
        BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x0;
#endif
}

//Step 8
void DetentCheck (void)
{
    uint8_t uiCheckSignal;
    
    if (LessThan(800)) {
        SetDetentSignal(0x1);
#if (CAN_2ND)        
        CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;
#endif
        DetentValid = 0;
    } else if (LessThan(1500)) {   
        SetDetentSignal(0x1);
        GET_BUTTON_DETENT_LEVEL;
        if (BUTTON_DETENT_IN == 1 && GetDetentSignal() == 1) {
            DetentValid = 1;
        } 
    } else if (LessThan(1700)) {
        SetDetentSignal(0x0);
    } else if (BetweenTime(2000,3000)) {      
        SetDetentSignal(0x0);
        GET_BUTTON_DETENT_LEVEL;
        if (BUTTON_DETENT_IN == 0 && GetDetentSignal() == 0) {
            if (DetentValid == 1) {
                DetentValid = 2;
                AutoStep8Result = 1;
            }
        }
    } else if (GreaterThan(4000)){
        if(DetentValid == 2) {
            SetStartTime(0);
            if(g_uiStaticCurrentCheckFlag == 1){
                ButtomCurrent.count = ButtomCurrent.count + 2;
            } else {
                ButtomCurrent.count++;
              }
        } else {
            DetentValid = 0;
            AutoStep8Result = 2;
            g_stCheckResult.Detent = 1;            
            SetError(81);//?????????
        }
    }
    if(AutoStep8Result == 2) {
        Buzzer_Alarm();
    }
}
uint16_t StaticCurrentNum = 0;
void StaticCurrentCheck(void)//???????
{
     if (BetweenTime(0,500)) {
         //LampState_L.Lamps.RELAY_B_ = 1;
         //if(LampState_L.Lamps.RELAY_B_ == 1){
             //LampState_L.Lamps.RELAY_IGN1 = 0;
         //}
        MC1413_B_ON;
        MC1413_IGNOFF;
        g_CostTimeSecond = 0;
        StaticCurrent.enable = 1;
     }
     else if (BetweenTime(500,1000)) {
        SetStartTime(1000);
        StaticCurrent.Finsh = 0;//Can send OFF
        CANSendEnable = OFF;
     }
     else if (BetweenTime(1000,2000)) {
        //LampState_L.Lamps.RELAY_B = 0;
        MC1413_BOFF;
     }
     else if(GreaterThan(3000)){//
     StaticCurrentNum = StaticCurrent.Value;
        if(GreaterThan(STATIC_BEGIN_CHECK_TIME) && (StaticCurrent.Finsh == 0)){
            if(StaticCurrent.Value < 15) {StaticCurrent.Finsh = 1;
                //LampState_L.Lamps.RELAY_B = 1;
                //LampState_L.Lamps.RELAY_IGN1 = 1;
                //LampState_L.Lamps.RELAY_B_ = 0;
                MC1413_IGNON;
                MC1413_BON;
                MC1413_B_OFF;
                CANSendEnable = ON;
                if (BetweenTime(STATIC_BEGIN_CHECK_TIME,STATIC_BEGIN_CHECK_TIME+CLUSTER_START_TIME))  {
                   //uint8_t test1=1;
                   SetStartTime(0);
                   AutoStep9Result = 1; //1:next 
                   g_uiOtherCheckCurStep = AUTO_END;//????????
                   StaticCurrent.enable = 0;
                } else {
                 //  StaticCurrent.Finsh = 1;
                 //  
                 //  SetStartTime(0);
                 //  AutoStep9Result = 1; //1:next 
                 //  g_uiOtherCheckCurStep = AUTO_END;//????????
                 //  StaticCurrent.enable = 0;
                }
            }
            else {//>1.4MA
                //if(LampState_L.Lamps.RELAY_B_ == 1){
                    //LampState_L.Lamps.RELAY_B = 1;
                    //LampState_L.Lamps.RELAY_IGN1 = 1;
                    //LampState_L.Lamps.RELAY_B_ = 0; 
                    MC1413_IGNON;
                    MC1413_BON;
                    MC1413_B_OFF;
                    CANSendEnable = ON;
                    if (BetweenTime(STATIC_BEGIN_CHECK_TIME,STATIC_BEGIN_CHECK_TIME+CLUSTER_START_TIME)) {
                       //uint8_t test2=1;
                    } else {
                        StaticCurrent.Finsh = 2;
                        
                        SetStartTime(0);
                        //g_stCheckResult.StaticCurrent = 1;                        
                        SetError(91);//?????????
                        AutoStep9Result = 2; //2:stop
                        g_uiOtherCheckCurStep = AUTO_END;
                        StaticCurrent.enable = 0;
                    }
                //}  
            }

        }
        
     } 
    
}

void SpeedFreqILLCheck(void)
{     
    if(BetweenTime(1000,3000)){
        Default_flag = 0;
        Speed20(1);
        HU_USM_E_04.CF_AVN_CluRheostatLvl = 12; 

        SetAutolightMode(1);//?????
        User_Delay(2000);
        if(CheckCurrent.Value == FINISH){
            if(Frequeice.Value > FREQ_LV12_S && Frequeice.Value < FREQ_LV12_E){
                Freque_Flag = 1;
            }else{
                Freque_Flag = 2;
            }
        } else {
            SetStartTime(1500);
        }
#if ((PRO_BR2) || (PRO_KS))        
        CheckIll_LV12_OkFlag = 1;
#else
        if ((BackLight.Value >= BackLightValue_LV12_S) && (BackLight.Value <= BackLightValue_LV12_E)){
            CheckIll_LV12_OkFlag = 1;
        }
#endif
        if (GreaterThan(2000)) {
          if (Freque_Flag != 1) { 
            SetStartTime(2000);
            AutoStep9Result = 2; 
            Speed20(1);
            g_stCheckResult.SPEED_020_FREQ = 1;            
            SetError(92);//?????????
          } else if (CheckIll_LV12_OkFlag == 0) {
            SetStartTime(2000);
            AutoStep9Result = 2; 
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 12; 
            g_stCheckResult.BackLight_12_ILL = 1;            
            SetError(93);//?????????
          }
        }
    }
    else  if(BetweenTime(3000,5000)){
        Default_flag = 0;
        Speed40(1);
        HU_USM_E_04.CF_AVN_CluRheostatLvl = 18; 
        SetAutolightMode(1);//?????
        User_Delay(2000);
        if(CheckCurrent.Value == FINISH){
            if(Frequeice.Value > FREQ_LV18_S && Frequeice.Value < FREQ_LV18_E){
                Freque_Flag = 1;
            }else{
                Freque_Flag = 2;
            }
        } else {
            SetStartTime(3500);
        }
#if ((PRO_BR2) || (PRO_KS) || (PRO_SQFL))        
        CheckIll_LV18_OkFlag = 1;
#else
        if ((BackLight.Value >= BackLightValue_LV18_S) && (BackLight.Value <= BackLightValue_LV18_E)){
            CheckIll_LV18_OkFlag = 1;
        }
#endif        
        if (GreaterThan(4000)) {
              if (Freque_Flag != 1) { 
                    SetStartTime(4000);
                    AutoStep9Result = 2; 
                    Speed40(1);
                    g_stCheckResult.SPEED_040_FREQ = 1;                    
                    SetError(94);//?????????
              } else if (CheckIll_LV18_OkFlag == 0) {
                    SetStartTime(4000);
                    AutoStep9Result = 2; 
                    HU_USM_E_04.CF_AVN_CluRheostatLvl = 18; 
                    g_stCheckResult.BackLight_18_ILL = 1;                    
                    SetError(95);//?????????
              } else if((Freque_Flag == 1) && (CheckIll_LV18_OkFlag == 1)){
                    AutoStep9Result = 1; 
             }
        }
    }
    else if(GreaterThan(7000)){
        if(AutoStep9Result == 1){
            //ButtomCurrent.count++;
            SetStartTime(0);
            SetAutolightMode(1);//??????
            Default_flag = 1;
        }
        g_uiOtherCheckCurStep = AUTO_END;
    }
#if (CAN_2ND)     
    CurRpm = CGW_PC4.msg.bits.N;
    HU_MON_PE_01.HU_OptionInfo_L=0x2;
#endif
#if (CAN_3RD)
    CurRpm = EMS_01_10ms.ENG_EngSpdVal;
    HU_MON_PE_01.HU_OptionInfo=0x2;
#endif
}

//Step 9
void OtherCheck(void)
{
    switch(g_uiOtherCheckCurStep)
    {
    case AUTO_BEGIN:
         if(g_uiStaticCurrentCheckFlag == 1)
            g_uiOtherCheckCurStep = AUTO_STATIC;
         else
            g_uiOtherCheckCurStep = AUTO_OTHER;
         SetStartTime(0);
         break;
    case AUTO_STATIC:
         StaticCurrentCheck();
         break;
    // case AUTO_OTHER:
    //      SpeedFreqILLCheck();
    //      break;
    case AUTO_END:
         if(AutoStep9Result == 2) {
            Buzzer_Alarm();
         }
         else if(AutoStep9Result == 1)
         {
            ButtomCurrent.count++;
         }
         break;
    }
}

uint16_t DisplayVehicleSpeedOutput;//??????
void CanOutPutSpeedCheck(void) 
{
    switch(SpeedOutPutNum.Flag)
    {
        case 0:
            if(BetweenTime(0,6000))
            {
                ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x00;
                ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
                //CanSendCan0Msg(0x2E9,  ESP_ABS_FailSts, 8,1);
                DisplayVehicleSpeedOutput = ((ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_L << 8) + ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_H)*0.0625;
                if(DisplayVehicleSpeedOutput == 11 )
                {
                    SpeedOutPutNum.Finsh = 1;
                    SpeedOutPutNum.Flag = 1; 
                }
            }
            else if(BetweenTime(6000,8000))
            {
                SpeedOutPutNum.Flag = 1;
            }
            break;
        case 1:
            if(SpeedOutPutNum.Finsh == 0)
            {
                SpeedOutPutNum.Finsh = 2;
                SetError(92);
                SpeedOutPutNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            SetStartTime(0);
        break;
    }
}
uint8_t DisPlayMessageCounterOutPut;

void CanOutPutMessageCounterCheck(void) 
{
    switch(MessageCounterNum.Flag)
    {
        case 0:
            if(BetweenTime(0,6000))
            {
                
                if(ICM_DisplayVehicleSpeed.msg.bits.MessageCounter == 15)
                {
                    MessageCounterNum.Finsh = 1;
                    MessageCounterNum.Flag = 1;
                    DisPlayMessageCounterOutPut = ICM_DisplayVehicleSpeed.msg.bits.MessageCounter;
                }
            }
            else if(BetweenTime(6000,8000))
            {
                MessageCounterNum.Flag = 1;
            }
            break;
        case 1:
            if(MessageCounterNum.Finsh == 0)
            {
                MessageCounterNum.Finsh = 2;
                SetError(98);
                MessageCounterNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            SetStartTime(0);
        break;
    }
}
uint16_t DisPlayBatteryVoltageOutPut;//??????
void CanOutPutVolCheck(void) 
{
    switch(VolOutPutNum.Flag)
    {
        case 0:
            if(BetweenTime(0,1000))
            {
                DisPlayBatteryVoltageOutPut = ICM_DisplayVehicleSpeed.msg.bits.ICM_BatteryVoltage * 0.1; 
                if(DisPlayBatteryVoltageOutPut >= 9 && DisPlayBatteryVoltageOutPut <= 16)
                {
                    VolOutPutNum.Finsh = 1;
                    VolOutPutNum.Flag = 1; 
                }
            }
            else if(BetweenTime(1000,2000))
            {
                VolOutPutNum.Flag = 1;
            }
            break;
        case 1:
            if(VolOutPutNum.Finsh == 0)
            {
                VolOutPutNum.Finsh = 2;
                SetError(93);
                VolOutPutNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            SetStartTime(0);
        break;
    }
}

uint8_t DisPlayAirBagLampFailStsOutPut = 0;
void CanOutPutAirBagLampFailSts(void) 
{
    switch(AirBagLampFail.Flag)
    {
        case 0:
            if(BetweenTime(0,1000))
            {
                ABM_AirBagFailSts.msg.bits.ABM_AirBagFailSts = 0x1;
                DisPlayAirBagLampFailStsOutPut = ICM_AirBagLampFailSts_Reserved.msg.bits.ICM_AirBagLampFailSts_Reserved;
                if(DisPlayAirBagLampFailStsOutPut == 0)
                {
                    AirBagLampFail.Finsh = 1;
                    AirBagLampFail.Flag = 1; 
                }
            }
            else if(BetweenTime(1000,2000))
            {
                AirBagLampFail.Flag = 1;
            }
            break;
        case 1:
            if(AirBagLampFail.Finsh == 0)
            {
                AirBagLampFail.Finsh = 2;
                SetError(97);
                AirBagLampFail.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            SetStartTime(0);
        break;
    }
}
uint16_t DisPlayHandBrakeSystemStsOutput;//???
void CanOutPutandBrakeCheck(void) 
{
    switch(HandBreakOutPutNum.Flag)
    {
        case 0:
            if(BetweenTime(0,2000))
            {
                Port_SetPortPinLevel(0, 0, PortGpioLow);           
                Port_SetPortPinLevel(2, 14, PortGpioLow); 
                DisPlayHandBrakeSystemStsOutput = ICM_DisplayVehicleSpeed.msg.bits.ICM_HandBrakeSystemSts;
                if(DisPlayHandBrakeSystemStsOutput == 0x1 )
                {
                    HandBreakOutPutNum.Finsh = 1;
                    HandBreakOutPutNum.Flag = 1; 
                }
            }
            else if(BetweenTime(2000,3000))
            {
                HandBreakOutPutNum.Flag = 1;
            }
            break;
        case 1:
            if(HandBreakOutPutNum.Finsh == 0)
            {
                HandBreakOutPutNum.Finsh = 2;
                SetError(94);
                HandBreakOutPutNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            SetStartTime(0);
        break;
    }
}

uint16_t DisPlayICM_DriverSeatBeltSwitchOutPut;//????????
void CanOutPutSeatBeltCheck(void) 
{
    switch(DriverSeatBeltOutPutNum.Flag)
    {
        case 0:
            if(BetweenTime(0,2000))
            {
                Port_SetPortPinLevel(0, 0, PortGpioHigh); 
                DisPlayICM_DriverSeatBeltSwitchOutPut = ICM_DisplayVehicleSpeed.msg.bits.ICM_DriverSeatBeltSwitch;
                if(DisPlayICM_DriverSeatBeltSwitchOutPut == 0x1 )
                {
                    DriverSeatBeltOutPutNum.Finsh = 1;
                    DriverSeatBeltOutPutNum.Flag = 1; 
                }
            }
            else if(BetweenTime(2000,4000))
            {
                DriverSeatBeltOutPutNum.Flag = 1;
            }
            break;
        case 1:
            if(DriverSeatBeltOutPutNum.Finsh == 0)
            {
                DriverSeatBeltOutPutNum.Finsh = 2;
                SetError(95);
                DriverSeatBeltOutPutNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
           
            SetStartTime(0);
        break;
    }
}

uint16_t DisPlayBrakeFluidOutPut;//????????
void CanOutPutLowBrakeCheck(void) 
{
    switch(DriverLow_BrakeOutPutNum.Flag)
    {
        case 0:
            if(BetweenTime(0,2000))
            {
                //Port_SetPortPinLevel(2, 14, PortGpioHigh);
                DisPlayBrakeFluidOutPut = ICM_DisplayVehicleSpeed.msg.bits.ICM_Low_Brake_Fluid;
                if(DisPlayBrakeFluidOutPut == 0x1 )
                {
                    DriverLow_BrakeOutPutNum.Finsh = 1;
                    DriverLow_BrakeOutPutNum.Flag = 1; 
                }
            }
            else if(BetweenTime(2000,3000))
            {
                DriverLow_BrakeOutPutNum.Flag = 1;
                
            }
            break;
        case 1:
            if(DriverLow_BrakeOutPutNum.Finsh == 0)
            {
                DriverLow_BrakeOutPutNum.Finsh = 2;
                SetError(96);
                DriverLow_BrakeOutPutNum.Flag = 2;
            }
            else
            {
                ButtomCurrent.count++;
            }
            Port_SetPortPinLevel(0, 0, PortGpioLow);           
            Port_SetPortPinLevel(2, 13, PortGpioLow); 
            Port_SetPortPinLevel(2, 14, PortGpioLow); 
            SetStartTime(0);
        break;
    }
}
void DrivingMode(uint8_t number)
{
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif
    if (number == 1){
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);   
        
    } else if (number == 2){
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    } else if (number == 3){
        SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }else if (number == 4){
        SetPressKeySequence(KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }else if (number == 5){
        SetPressKeySequence(KEY_GRIB_UP,KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }else if (number == 6){
        SetPressKeySequence(KEY_GRIB_UP,KEY_GRIB_DOWN,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }else if (number == 7){
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_GRIB_UP,KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }else if (number == 8){
        SetPressKeySequence(KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
    DoPressKeySimulation(TIME_400);
}

void DrivingModeCheck(void)
{
    if (BetweenTime(0,1000)){
#if((PRO_NQ5) || (PRO_SU2BFL) || (PRO_SU2IFL) || (PRO_QX23) || (PRO_SG2) || (PRO_AX) || (PRO_LX2) || (PRO_NQ5C) || (PRO_SU2ID_FL) || (PRO_NU2))
        DrivingMode(1);
#endif
#if((PRO_CN7) ||  (PRO_KY) || (PRO_CN7C) || (PRO_SK3_PE) || (PRO_QYC))
        DrivingMode(4);
#endif
#if((PRO_KS) || (PRO_BN7I) || (PRO_US4) || (PRO_BC3) || (PRO_BL7M) || (PRO_BL7R))
        DrivingMode(3);
#endif
#if (PRO_SP2C_PE)
        DrivingMode(5);
#endif
#if (PRO_DL3C)
        DrivingMode(8);
#endif
#if (PRO_KU)
        DrivingMode(7);
#endif
#if (PRO_QXI)
        DrivingMode(2);
#endif
#if (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        DrivingMode(6);
    }else if (JudgePartNum() == PartNum_SP2I){
        DrivingMode(5);
    }
#endif
    } else if (BetweenTime(1000,3000)){
        if ((DMS_SPORT == 1) || (DMS_ECO == 1)) { // SPORT  
            AutoStep10Result = 1;
            ButtomCurrent.count++;
        } else {
            AutoStep10Result = 0;
            SetError(101);//?????????
        }
    }
}


void APP_AUTO(void)
{
    switch (ButtomCurrent.count) {
        case 0:
       // OtherCheck();
        if(g_AutoConfig.AUTO_STEP10_APPLY == 0){
            ButtomCurrent.count++;
        } else {
            if(time1 <= 200)
            {
                if(time1 == 0) {
                    time1=400;
                    count1++;
                    if(count1 == 6) {
                        ButtomCurrent.count ++;
                        SetStartTime(0);
                    }
                }else {
                    HJ_SetHightLed(PortGpioHigh);
                }
            } else {
                HJ_SetHightLed(PortGpioLow);
            }
        }
        break;
        case 1:
            count1 = 0;
            if(g_AutoConfig.AUTO_STEP1_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                //ButtomCurrent.enable = 1;
            build_number1();
            // build_number2();
            // build_number3();
            // build_number3();
            // build_number4();
            // build_number5();
            // build_number6();
            // build_number7();
             //   SWandHW_Version();
                
            }
            break;  
        case 2://??
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                //CanOutPutSpeedCheck();
               // HWandHW_Version();
                build_number2();
            }
            break;
        case 3:
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                //CanOutPutVolCheck();
                //HJYB_Version();
                build_number3();
            }
            break;
        case 4:
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                //ButtomCurrent.count++;
                ButtomCurrent.count ++;
            }
            else {

                //CanOutPutandBrakeCheck();
                //DAY_Version();
                build_number4();
            }
            break;           
        case 5:
        if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
            ButtomCurrent.count++;
        }
        else {
            build_number6();
            //CanOutPutLowBrakeCheck();
        }
            //         ErrorCode = 99;//??????
            // SetStartTime(0);
            // ButtomCurrent.enable = 0;
            //if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
            //    ButtomCurrent.count++;
            //}
            //else {
            //    build_number6();
            //    //CanOutPutSeatBeltCheck();
            //}
            break;  
        case 7:
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                build_number7();
                //CanOutPutLowBrakeCheck();
            }
            break;  
        case 8:
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                build_number8();
                //CanOutPutLowBrakeCheck();
            }
            break;  
        case 9:
            RxFinish = UNFINISH;
            if(g_AutoConfig.AUTO_STEP11_APPLY == 0){
                ButtomCurrent.count++;
            }
            else {
                OtherCheck();
                //CanOutPutMessageCounterCheck();
            }
            break; 
        default:
            ErrorCode = 99;//??????
            SetStartTime(0);
            ButtomCurrent.enable = 0;
            break;
    }
}


