#include "common_include.h"
#include "bsp_button.h"
#include "bsp_speed_check.h"
#include "bsp_app_led_output.h"
#include "bsp_app_tft_output.h"

uint8_t Button_Press = 0;
uint8_t Button_Value=0;
uint8_t g_butto_msg[8];
uint8_t start_uart_timer = 0;
uint8_t uart_send_end_flag=0;
uint8_t uart_send_flag=0;
uint8_t uart_send_count;
uint8_t stop_uart_timer;
uint8_t TFTUp_Switch = 0;

_BUTTON   Botton;

volatile uint16_t ErrorCode = 0;
volatile uint8_t  Default_flag = 1;

uint8_t Err_Status = 0;
uint8_t Err_Flag = 0;

uint8_t CluPartNum[16] = {0};
uint8_t GetPartNumSent = 0;
uint8_t GetPartNumFinish = 0;
uint16_t GetPartNumTimerCnts = 0;
uint8_t Freque_Flag;
uint8_t g_uiCuntDownFlag = 0;

#if (SEMI_AUTOMATIC_STAGE)
#define STAGE_COUNT_EOL 4
#define STAGE_COUNT_AUTO 10
#define STAGE_COUNT_HARD_LINE_LED 3
#define STAGE_COUNT_OTHER_LED 0
#define STAGE_COUNT_FUEL_WATER 4
#define STAGE_COUNT_TFT_SEG 18

#define STAGE_COUNT_OIL_WAIT_TIME 5
#define STAGE_COUNT_EOL_WAIT_TIME 8
#define STAGE_COUNT_AUTO_WAIT_TIME 24
#endif

/*-------------------------------------------------------------------------
* Function Name  : Get_Button_Value
* Description    : ��ȡ����״̬
* Input          : None
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/

void Buzzer_Alarm() //����������3�뱨��
{
#if ((RELEASE_CONFIG) || (FALSE_CONFIG))
     if (Buzz_Play == 1) {
        Port_SetPortPinLevel(1, 18, PortGpioHigh);//������
        BuzzerAlarm.Value = 1;
    } else if (Buzz_Play == 0) {
        Port_SetPortPinLevel(1, 18, PortGpioLow);//������
        BuzzerAlarm.Value = 2;
    }
#if (CAN_2ND)    
    PAS11.msg.bits.CF_Gway_PASCheckSound = 0x1;
    PAS11.msg.bits.CF_Gway_PASRsound = 3;
#endif
#if (CAN_3RD)    
    BCM_05_200ms.PDW_SysChkSndSta = 0x1;
    BCM_05_200ms.PDW_FrSnsrWrngLvlSta= 0x3;
#endif
#endif
}


void User_Delay(uint16_t Delay_Time) //��ʱ���� ��Ӱ����������
{
    if(!CheckCurrent.Flag)
    {
        CheckCurrent.enable = ON;
        if(CheckCurrent.Time < Delay_Time)
        {
            CheckCurrent.Value = UNFINISH;
        }
        else if(CheckCurrent.Time >= Delay_Time)
        {
            //CheckCurrent.enable = OFF;
            CheckCurrent.Value = FINISH;
            CheckCurrent.Flag = FINISH;
        }
    }
}


void Get_Button_Value()//��ȡ����AD
{
    if (Err_Status != 1) { 
        GET_BUTTON_S30_LEVEL;
        if(BUTTON_S30_IN == 0)
            Botton.S30.Flag = 1;
        else
            Botton.S30.Flag = 0;
        
        GET_BUTTON_S15_LEVEL;
        if(BUTTON_S15_IN == 0)
            Botton.S15.Flag = 1;
        else
            Botton.S15.Flag = 0;

        GET_BUTTON_EOL_LEVEL;
        if(BUTTON_EOL_IN == 0)
            Botton.EOL.Flag = 1;
        else
            Botton.EOL.Flag = 0;

        GET_BUTTON_END_LEVEL;
        if(BUTTON_END_IN == 0)
            Botton.End.Flag = 1;
        else
            Botton.End.Flag = 0;
#if 0        
        GET_Luminosity_LEVEL;
        if(BUTTON_Luminosity_IN == 0)//����
            Botton.Luminosity.Flag = 1;
        else
            Botton.Luminosity.Flag = 0;
        
        GET_BUTTON_Back_light_LEVEL;
        if(BUTTON_Back_light_IN == 0)//����
            Botton.Back_light.Flag = 1;
        else
            Botton.Back_light.Flag = 0;
#else        
        if (g_Stage != STAGE_AutoCheck) {
            Test_AD = Calculate_Thermistor(AdcValList[15]);
            if((Test_AD > 130) && (Test_AD < 150))//����
                Botton.Luminosity.Flag = 1;
            else
                Botton.Luminosity.Flag = 0;
            
            if((Test_AD > 180) && (Test_AD < 195))//����
                Botton.Back_light.Flag = 1;
            else 
                Botton.Back_light.Flag = 0; 
            
            if((Test_AD > 220) && (Test_AD < 250))//�˵�
                Botton.Menu.Flag = 1;
            else 
                Botton.Menu.Flag = 0; 
            
            if((Test_AD > 270) && (Test_AD < 310))//��
                Botton.Up.Flag = 1;
            else 
                Botton.Up.Flag = 0; 
            if((Test_AD > 330) && (Test_AD < 350))//��
                Botton.Down.Flag = 1;
            else 
                Botton.Down.Flag = 0; 
            if((Test_AD > 370) && (Test_AD < 415))//OK
                Botton.OK.Flag = 1;
            else 
                Botton.OK.Flag = 0; 
            if((Test_AD > 430) && (Test_AD < 460))//EOL����ȫ0
                Botton.EOLClear.Flag = 1;
            else 
                Botton.EOLClear.Flag = 0;
        }
#endif        
#if (FUNCTION_KEY_AUTO)
        GET_BUTTON_AUTO_LEVEL;
        if(BUTTON_AUTO_IN == 0){
            if (CheckOkTimerCnts == 0) {
                Botton.Auto.Flag = 1;
            }
        } else {
            CheckOkTimerCnts = 0;
            Botton.Auto.Flag = 0;
        }
#endif
#if (FUNCTION_KEY_EOL)
        GET_BUTTON_EOL_LEVEL;
        if(BUTTON_EOL_IN == 0){
            Botton.EOL.Flag = 1;
        }
        else
            Botton.EOL.Flag = 0;
#endif
#if (FUNCTION_KEY_SPEED_UP)
        GET_BUTTON_SPEED_UP_LEVEL;
        if(BUTTON_SPEED_UP_IN == 0)
            Botton.SpeedUp.Flag = 1;
        else
            Botton.SpeedUp.Flag = 0;
#endif
#if (FUNCTION_KEY_SPEED_DOWN)
        GET_BUTTON_SPEED_DOWN_LEVEL;
        if(BUTTON_SPEED_DOWN_IN == 0)
            Botton.SpeedDown.Flag = 1;
        else
            Botton.SpeedDown.Flag = 0; 
#endif
#if (FUNCTION_KEY_LED)
        GET_BUTTON_LED_LEVEL;
        if(BUTTON_LED_IN == 0){
            Botton.LED.Flag = 1;
        }
        else{
            Botton.LED.Flag = 0;
          //  Delay(1000);
            }
#endif
#if (FUNCTION_KEY_IOL_UP)
        GET_BUTTON_IOL_UP_LEVEL;
        if(BUTTON_IOL_UP_IN == 0)
            Botton.FuelWaterUp.Flag = 1;
        else
            Botton.FuelWaterUp.Flag = 0;
#endif
#if (FUNCTION_KEY_IOL_DOWN)
        GET_BUTTON_IOL_DOWN_LEVEL;
        if(BUTTON_IOL_DOWN_IN == 0)
            Botton.FuelWaterDown.Flag = 1;
        else
            Botton.FuelWaterDown.Flag = 0;   
#endif
#if (FUNCTION_KEY_TFT_UP)
        GET_BUTTON_TFT_UP_LEVEL;
        if(BUTTON_TFT_UP_IN == 0)
            Botton.TFTUp.Flag = 1;
        else
            Botton.TFTUp.Flag = 0;   
#endif
#if (FUNCTION_KEY_TFT_DOWN)
        GET_BUTTON_TFT_DOWN_LEVEL;
        if(BUTTON_TFT_DOWN_IN == 0)
            Botton.TFTDown.Flag = 1;
        else
            Botton.TFTDown.Flag = 0;   
#endif
#if (FUNCTION_KEY_ELSE)
        GET_BUTTON_ELSE_LEVEL;
        if(BUTTON_ELSE_IN == 0){
            Botton.Other.Flag = 1;
        }
        else
            Botton.Other.Flag = 0;   
#endif
#if (FUNCTION_KEY_END)
        GET_BUTTON_END_LEVEL;
        if(BUTTON_END_IN == 0)
            Botton.End.Flag = 1;
        else
            Botton.End.Flag = 0;   
#endif
    }  
}


uint8_t Calc_Checksum(uint8_t  *msg, uint8_t len)
{
    uint8_t i_loop, j_loop;
    uint8_t ret = 0;
    uint8_t bit=0x1;
    
    for (i_loop=0; i_loop < len; i_loop++)
    {
        bit=0x1;
        for (j_loop= 0; j_loop< 8; j_loop++)
        {
            if ((msg[i_loop] & bit) !=0)
            {
                ret++;
            }
            bit = (bit <<1);
            
        }
    }
    
    ret = 8*len - ret +1;
    
    
    return ret;
}



///*-------------------------------------------------------------------------
//* Function Name  : Button_Statu_Manage
//* Description    : ����״̬����
//* Input          : None
//* Output         : None
//* Return         : None
//* onther         : xxhh
//--------------------------------------------------------------------------*/

//void Button_Statu_Manage_Slave()
//{
//    uint8_t checkSum;
//    uint8_t  tmp_val;
//    
//    if (Button_Slave_Receive_Flag)
//	{
//		Button_Slave_Receive_Flag=0;
//		tmp_val = Button_Value_Slave;
//		
//		switch (tmp_val)
//		{
//		case 1:
//			Botton.S30.Statu = 1;
//			break;
//			
//		case 2:
//			Botton.S15.Statu = 1;
//			break;
//			
//		case 3:
//			Botton.Auto.Statu = 1;
//			ButtomCurrent.enable = 1;    
//			break;  
//			
//		case 4:
//			Botton.LED.Statu = 1;
//			break;  
//			
//		case 5:
//			Botton.SpeedUp.Statu = 1;
//			break;  
//			
//		case 6:
//			Botton.SpeedDown.Statu = 1;
//			break;
//			
//		case 7:
//			Botton.FuelWaterUp.Statu = 1;
//			break;                
//			
//		case 8:
//			Botton.FuelWaterDown.Statu = 1;
//			break;      
//		case 9:
//			Botton.TFTUp.Statu = 1;
//			break;      
//		case 10:
//			Botton.TFTDown.Statu = 1;
//			break;      
//		case 11:
//			Botton.Other.Statu = 1;
//			break;      
//		case 12:
//			Botton.End.Statu = 1;
//			break;
//		case 13:
//			Botton.EOL.Statu = 1;
//			break;   
//		case 14:
//			Botton.Back_light.Statu = 1;
//			break; 
//		case 15:
//			Botton.Luminosity.Statu = 1;
//			break;     
//		case 16:
//			Flag_CheckBarcode = 1;//yrf++
//			break;      
//		case 17:
//			if(CheckClusterValid == 0u)
//			{
//				Botton.S30.Statu = 2;
//			}
//			break;     
//		case 30:
//			BarcodeErr = 0u;
//			g_Stage = 0;
//			Flag_CheckBarcode = 0;
//			Flag_DisplayErr = 0;
//			//memset((void *)&Botton, 0, sizeof(Botton));
//			memset((void *)&g_UDS, 0, sizeof(g_UDS));
//			memset((void *)&EOL, 0, sizeof(EOL));
//			memset((void *)&StaticCurrent, 0, sizeof(StaticCurrent)); 
//			memset((void *)&ButtomCurrent, 0, sizeof(ButtomCurrent)); 
//			memset((void *)&LedCurrent, 0, sizeof(LedCurrent));
//			memset((void *)&SpeedCurrent, 0, sizeof(SpeedCurrent));
//			memset((void *)&Iol_TempCurrent, 0, sizeof(Iol_TempCurrent));
//			memset((void *)&TFTCurrent, 0, sizeof(TFTCurrent));
//			memset((void *)&Back_lightCurrent, 0, sizeof(Back_lightCurrent));
//			memset((void *)&LuminosityCurrent, 0, sizeof(LuminosityCurrent));
//			memset((void *)&ElseCurrent, 0, sizeof(ElseCurrent));
//			memset((void *)&EndCurrent, 0, sizeof(EndCurrent));
//			memset((void *)&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
//			memset((void *)&CheckCurrent, 0, sizeof(CheckCurrent));
//			
//			LampState_L.Lamps.RELAY_B = 0;
//			LampState_L.Lamps.RELAY_IGN1 = 0;
//			bsp_BD8379_WriteData(LampState_L.LampData, LampState_M.LampData);
//			
//			Delay(200);
//			LampState_L.Lamps.RELAY_B = 1;
//			LampState_L.Lamps.RELAY_IGN1 = 1;
//			bsp_BD8379_WriteData(LampState_L.LampData, LampState_M.LampData);
//			Delay(20);
//			break;  
//		default:
//			break;
//		}
//		
//		g_butto_msg[0] = 0xFF;    
//		g_butto_msg[1] = 0x1;
//		g_butto_msg[2] = 0x1;
//		g_butto_msg[3] = 0x1;
//		
//		checkSum = Calc_Checksum(g_butto_msg, 4);
//		g_butto_msg[4] = checkSum;
//		Mfs_Uart_Write(UART9_Type, g_butto_msg, 5, TRUE);
//	}
//    
//    if (0 == Button_Press && CheckClusterValid == 1u)  
//    {
//        if(Botton.S30.Flag == 1){   //30
//            if(Botton.S30.Time < 3000){
//                Botton.S30.Time += IntervalTimerDelta;
//            }
//			if(Botton.S30.Time >= 1000){
//                Botton.S30.Statu = 2;
//            }
//        }else{
//            Botton.S30.Time = 0;
//        }
//	}
//	else if (0 == Button_Press && CheckClusterValid == 0u)  
//	{
//		if(Botton.S15.Flag == 1){   //30
//            if(Botton.S15.Time < 3000){
//                Botton.S15.Time += IntervalTimerDelta;
//            }
//			if(Botton.S15.Time >= 1000 && Botton.Other.Flag == 1){
//				if (Botton.S15.Statu !=3) {
//                	Botton.S15.Statu = 2;
//				}
//            }
//        }else{
//            Botton.S15.Time = 0;
//        }
//		if(Botton.Other.Flag == 1){   //30
//            if(Botton.Other.Time < 3000){
//                Botton.Other.Time += IntervalTimerDelta;
//            }
//			if(Botton.Other.Time >= 1000 && Botton.S15.Flag == 1){
//				if(Botton.Other.Statu != 3) {
//                	Botton.Other.Statu = 2;
//				}
//            }
//        }else{
//            Botton.Other.Time = 0;
//        }
//	}
//}

void Button_Statu_Manage(void)
{
    uint8_t checkSum;
    
    if (0 == Button_Press)  
	{
		if(Botton.S30.Flag == 1){   //30
			if(Botton.S30.Time < 3000){
				Botton.S30.Time += IntervalTimerDelta;
			}
			
			if(Botton.S30.Time > 1000){
				Botton.S30.Statu = 2;
				Button_Press= 1;
				Button_Value=17;
			}
		}else{
			if(Botton.S30.Time > 100 && Botton.S30.Time < 1000){
				Botton.S30.Statu = 1;
				Button_Press= 1;
				Button_Value=1;
			}
			Botton.S30.Time = 0;
		} 
		
		if(Botton.S15.Flag == 1){  //15
			if(Botton.S15.Time < 3000){
				Botton.S15.Time += IntervalTimerDelta;
			}
            if(Botton.S15.Time > 1000){
				Botton.S15.Statu = 2;
				Button_Press= 1;
			}
			//if(Botton.S15.Time >= 1000 && Botton.Other.Flag == 1 && CheckClusterValid == 0u){
			//	if (Botton.S15.Statu !=3) {
			//		Botton.S15.Statu = 2;
			//	}
			//	Button_Press= 1;
			//}
		}else{
			if(Botton.S15.Time > 100 && Botton.S15.Time < 1000){
				Botton.S15.Statu = 1;
				Button_Press= 1;
				Button_Value=2;
			}
			Botton.S15.Time = 0;
		}
		
		if(Botton.Auto.Flag == 1){  //AUTO
			if(Botton.Auto.Time < 3000){
				Botton.Auto.Time += IntervalTimerDelta;
			}
		}else{
			if(Botton.Auto.Time > 100){
				Botton.Auto.Statu = 1;
				Button_Press= 1;
				Button_Value=3;
			}
			Botton.Auto.Time = 0;
		}
		
		if(Botton.EOL.Flag == 1){  //EOL
			if(Botton.EOL.Time < 3000){
				Botton.EOL.Time += IntervalTimerDelta;
             }
		}else{
			if(Botton.EOL.Time > 100 && Botton.EOL.Time < 1000){
				Botton.EOL.Statu = 1;
				Button_Press= 1;
				Button_Value=13;
			}
			Botton.EOL.Time = 0;
		}  
		
		if(Botton.SpeedUp.Flag == 1){ //SPEED UP
			if(Botton.SpeedUp.Time < 3000){
				Botton.SpeedUp.Time += IntervalTimerDelta;
			}
            if(Botton.SpeedUp.Time > 2000){
                if(g_SpeedUpflag == 0 && g_SpeedDownflag == 0){
                    g_SpeedUpflag = 1;
                }
				Button_Press= 1;
			}
		} else{
			if(Botton.SpeedUp.Time > 100&& Botton.SpeedUp.Time < 2000){
				Botton.SpeedUp.Statu = 1;
				Button_Press= 1;
				Button_Value=5;
			}
			Botton.SpeedUp.Time = 0;
		}
		
		if(Botton.SpeedDown.Flag == 1){  //SPEED DOWN 
			if(Botton.SpeedDown.Time < 3000){
				Botton.SpeedDown.Time += IntervalTimerDelta;
			}
            if(Botton.SpeedDown.Time > 2000){
                if(g_SpeedUpflag == 1 && g_SpeedDownflag == 0){
                    g_SpeedDownflag = 1;
                }
				Button_Press= 1;
			}
		}else{
			if(Botton.SpeedDown.Time > 100 && Botton.SpeedDown.Time < 2000){
				Botton.SpeedDown.Statu = 1;
				Button_Press= 1;
				Button_Value=6;
			}
			Botton.SpeedDown.Time = 0;
		}
		
		
		if(Botton.LED.Flag == 1){            //LED
			if(Botton.LED.Time < 3000){
				Botton.LED.Time += IntervalTimerDelta;
				
			}
		}else{
			
			if(Botton.LED.Time > 100 && Botton.LED.Time <= 2900){
				Botton.LED.Statu = 1;
				Button_Press= 1;
				Button_Value= 4;
				LedCurrent.Flag = 0;
				
			}
			if(Botton.LED.Time > 2900)
			{
				LedCurrent.Flag = 1;
			}
			Botton.LED.Time = 0;
			
		}
		if(Botton.FuelWaterUp.Flag == 1){   //IOL UP
			if(Botton.FuelWaterUp.Time < 3000)
				Botton.FuelWaterUp.Time += IntervalTimerDelta;
		}else{
			if(Botton.FuelWaterUp.Time > 100){
				Botton.FuelWaterUp.Statu = 1;
				Button_Press= 1;
				Button_Value= 7;
			}
			Botton.FuelWaterUp.Time = 0;
		}
		
		if(Botton.FuelWaterDown.Flag == 1){   //IOL DOWN 
			if(Botton.FuelWaterDown.Time < 3000)
				Botton.FuelWaterDown.Time += IntervalTimerDelta;
		}else{
			if(Botton.FuelWaterDown.Time > 100){
				Botton.FuelWaterDown.Statu = 1;
				Button_Press= 1;
				Button_Value= 8;
			}
			Botton.FuelWaterDown.Time = 0;
		}
		
		if(Botton.TFTUp.Flag == 1){   //TFT UP
			if(Botton.TFTUp.Time < 3000)
				Botton.TFTUp.Time += IntervalTimerDelta;
		}else{
			if( TFTUp_Switch!=1)
			{
				//TFTCurrent.Time = 0;
				TFTCurrent.enable = 0;
			}
			if((Botton.TFTUp.Time > 100)&& (Botton.TFTUp.Time < 800)){
				Botton.TFTUp.Statu = 1;
				Button_Press= 1;
				Button_Value= 9;
			}
			else if (Botton.TFTUp.Time > 2900) {
				TFTUp_Switch = 1;
				TFTCurrent.count = 0;
				Button_Value = 14;
				
			}
			
			Botton.TFTUp.Time = 0;
		}
		
		if(Botton.TFTDown.Flag == 1){   //TFT DOWN
			if(Botton.TFTDown.Time < 3000)
				Botton.TFTDown.Time += IntervalTimerDelta;
		}else{
			if(Botton.TFTDown.Time > 100){
				Botton.TFTDown.Statu = 1;
				Button_Press= 1;
				Button_Value=10;
				TFTUp_Switch = 0;
			}
			Botton.TFTDown.Time = 0;
		}
		
		if(Botton.Other.Flag == 1){   //ELSE 
			if(Botton.Other.Time < 3000)
				Botton.Other.Time += IntervalTimerDelta;
			
			if(Botton.Other.Time >= 1000 && Botton.S15.Flag == 1 && CheckClusterValid == 0u){
				if(Botton.Other.Statu != 3) {
					Botton.Other.Statu = 2;
				}
				Button_Press= 1;
                Err_Flag = 1;
			}
		}else{
			if(Botton.Other.Time > 100 && Botton.Other.Time < 1000){
				Botton.Other.Statu = 1;
				Button_Press= 1;
				Button_Value=11;
				//ElseCurrent.enable = 1;
			}
			Botton.Other.Time = 0;
		}
		
		if(Botton.Back_light.Flag == 1){   //���� 
			if(Botton.Back_light.Time < 3000)
				Botton.Back_light.Time += IntervalTimerDelta;
		}else{
			if(Botton.Back_light.Time > 100){
				Botton.Back_light.Statu = 1;
				Button_Press= 1;
				Button_Value=14;
			}
			Botton.Back_light.Time = 0;
		}
		
		if(Botton.Luminosity.Flag == 1){   //���� 
			if(Botton.Luminosity.Time < 3000)
				Botton.Luminosity.Time += IntervalTimerDelta;
		}else{
			if(Botton.Luminosity.Time > 100){
				Botton.Luminosity.Statu = 1;
				Button_Press= 1;
				Button_Value=15;
			}
			Botton.Luminosity.Time = 0;
		}
        if(Botton.Menu.Flag == 1){   //�˵� 
			if(Botton.Menu.Time < 3000)
				Botton.Menu.Time += IntervalTimerDelta;
		}else{
			if(Botton.Menu.Time > 100){
				Botton.Menu.Statu = 1;
			}
			Botton.Menu.Time = 0;
		}
        if(Botton.Up.Flag == 1){   //��
			if(Botton.Up.Time < 3000)
				Botton.Up.Time += IntervalTimerDelta;
		}else{
			if(Botton.Up.Time > 100){
				Botton.Up.Statu = 1;
			}
			Botton.Up.Time = 0;
		}
        if(Botton.Down.Flag == 1){   //�� 
			if(Botton.Down.Time < 3000)
				Botton.Down.Time += IntervalTimerDelta;
		}else{
			if(Botton.Down.Time > 100){
				Botton.Down.Statu = 1;
			}
			Botton.Down.Time = 0;
		}
        if(Botton.OK.Flag == 1){   //OK 
			if(Botton.OK.Time < 3000)
				Botton.OK.Time += IntervalTimerDelta;
		}else{
			if(Botton.OK.Time > 100){
				Botton.OK.Statu = 1;
			}
			Botton.OK.Time = 0;
		}
        if(Botton.EOLClear.Flag == 1){   //OK 
			if(Botton.EOLClear.Time < 3000)
				Botton.EOLClear.Time += IntervalTimerDelta;
		}else{
			if(Botton.EOLClear.Time > 100){
				Botton.EOLClear.Statu = 1;
			}
			Botton.EOLClear.Time = 0;
		}
		if(Botton.End.Flag == 1)
		{   //END
			if(Botton.End.Time < 3000)
				Botton.End.Time += IntervalTimerDelta;
		} else {
			if(Botton.End.Time > 100 && Botton.End.Time < 2000)
			{
				Botton.End.Statu = 1;
				Button_Press= 1;
				Button_Value=12;
			}
			if(Botton.End.Time > 2900)
			{
				bsp_Save_Check_Service(3);// �������
				Diaplay_test = NewData.Data1;
			}
			Botton.End.Time = 0;
		}
		
	}
    
    /*added by k --  set button_val*/
    
    
    if (1==Button_Press)
    {       
        Button_Press = 0;
        /*
        g_butto_msg[0] = 0xFF;    
        g_butto_msg[1] = 0x01;
        g_butto_msg[2] = 0x01;
        g_butto_msg[3] = Button_Value;
        */
        
        g_butto_msg[0] = 0xFF;    
        g_butto_msg[1] = 0x1;
        g_butto_msg[2] = 0x1;
        g_butto_msg[3] = Button_Value;
        
        
        checkSum = Calc_Checksum(g_butto_msg, 4);
        
        g_butto_msg[4] = checkSum;
        
        
        start_uart_timer=1;
        
        //if (uart_send_flag==1)
        //{
        Mfs_Uart_Write(UART9_Type, g_butto_msg, 5, TRUE);
        uart_send_flag=0;
        //}
        
		if(Button_Value == 30)
		{
			//LampState_L.Lamps.RELAY_B = 0;
			//LampState_L.Lamps.RELAY_IGN1 = 0;
			bsp_BD8379_WriteData(LampState_L.LampData, LampState_M.LampData);
			
			Delay(200);
			//LampState_L.Lamps.RELAY_B = 1;
			//LampState_L.Lamps.RELAY_IGN1 = 1;
			bsp_BD8379_WriteData(LampState_L.LampData, LampState_M.LampData);
			Delay(20);
		}
    }
}



/*-------------------------------------------------------------------------
* Function Name  : StageManage
* Description    : ��ⲽ�账��
* Input          : None
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/

void Delay(uint16_t msec)
{
    int i = 0;
    int n = 0;
    for (n = 0; n < msec; n++)
        for (i = 0; i < 9600; i++);
}

void GetPartNum(void)
{
   // UDS_Backdoor();
	switch(GetPartNumSent)
	{
	case 0:
		memset(CluPartNum, 0, sizeof (CluPartNum));
		memset(&MultiplePack, 0, sizeof (MultiplePack));
		MyRecvCount = 0;
		GetPartNumFinish = 0;
		GetPartNumTimerCnts = 0;
		
		Send_7CE_Data.Byte0Data = 0x03;
		Send_7CE_Data.Byte1Data = 0x22;
		Send_7CE_Data.Byte2Data = 0xF1;
		Send_7CE_Data.Byte3Data = 0x87;
		CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
		RxFinish = UNFINISH;
		GetPartNumSent = 1;
		break;
	case 1:
		if (RxFinish == FINISH) {  //��ȡ����
			if (MyRecvCount >= 10) {
				if ((MultiplePack.Data[0] == '9') && (MultiplePack.Data[1] == '4')) {
					memcpy(CluPartNum, MultiplePack.Data, 10);
					memset(&MultiplePack, 0, sizeof (MultiplePack));
					//GetPartNumFinish = 1;
					GetPartNumSent = 2;
				}
			} else {
				if (GetPartNumFinish == 0) {
					if (GetPartNumSent == 1) {
						if (GetPartNumTimerCnts < 500) {
							GetPartNumTimerCnts++;
						}
						if (GetPartNumTimerCnts >= 150) {
							GetPartNumSent = 0;
						} else {
							if (GetPartNumTimerCnts >= 50) {
								UpdateGetClusterPartNum();
							}
						}
					}
				}
			}
		}
		break;
	case 2:
		memset(&MultiplePack, 0, sizeof (MultiplePack));
		MyRecvCount = 0;
		GetPartNumFinish = 0;
		GetPartNumTimerCnts = 0;
		
		Send_7CE_Data.Byte0Data = 0x03;
		Send_7CE_Data.Byte1Data = 0x22;
		Send_7CE_Data.Byte2Data = 0xF1;
		Send_7CE_Data.Byte3Data = 0x8C;
		CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
		RxFinish = UNFINISH;
		GetPartNumSent = 3;
		break;
	case 3:
		if (RxFinish == FINISH) {  //��ȡ����
			CluBarcodeDate = 0;
			CluClusterID = 0;
                        
			CluBarcodeDate = (MultiplePack.Data[2] - 0x30) * 100000;
			CluBarcodeDate += (MultiplePack.Data[3] - 0x30) * 10000;
			CluBarcodeDate += (MultiplePack.Data[4] - 0x30) * 1000;
			CluBarcodeDate += (MultiplePack.Data[5] - 0x30) * 100;
			CluBarcodeDate += (MultiplePack.Data[6] - 0x30) * 10;
			CluBarcodeDate += (MultiplePack.Data[7] - 0x30) * 1;
			
            CluClusterID = (MultiplePack.Data[8] - 0x30) * 1000;
			CluClusterID += (MultiplePack.Data[9] - 0x30) * 100;
			CluClusterID += (MultiplePack.Data[10] - 0x30) * 10;
			CluClusterID += (MultiplePack.Data[11] - 0x30) * 1;
			//GetPartNumFinish = 1;
			GetPartNumSent = 4;
		} else {
			if (GetPartNumFinish == 0) {
				if (GetPartNumSent == 1) {
					if (GetPartNumTimerCnts < 500) {
						GetPartNumTimerCnts++;
					}
					if (GetPartNumTimerCnts >= 150) {
						GetPartNumSent = 0;
					} else {
						if (GetPartNumTimerCnts >= 50) {
							UpdateGetClusterPartNum();
						}
					}
				}
			}
		}
		break;
#if (0)	    //��Ʒ�Ų���
	case 4:
		memset(&MultiplePack, 0, sizeof (MultiplePack));
		MyRecvCount = 0;
		GetPartNumFinish = 0;
		GetPartNumTimerCnts = 0;
		
		Send_7CE_Data.Byte0Data = 0x03;
		Send_7CE_Data.Byte1Data = 0x22;
		Send_7CE_Data.Byte2Data = 0xF1;
		Send_7CE_Data.Byte3Data = 0x8F;
		CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
		RxFinish = UNFINISH;
		GetPartNumSent = 5;
       // USD_Backdoor();
		break;
	case 5:
#if (PRO_CN7C)
  UDS_F18F_Response();
#endif     
		if (RxFinish == FINISH) {  //��ȡ����
			memcpy(CluWriteCompleteFlag, &MultiplePack.Data[0], 8);
			GetPartNumFinish = 1;
			GetPartNumSent = 6;
            Speed_Output_Update(PWMCH_SPEED_OUT, 0, 0);
		} else {
			if (GetPartNumFinish == 0) {
				if (GetPartNumSent == 1) {
					if (GetPartNumTimerCnts < 500) {
						GetPartNumTimerCnts++;
					}
					if (GetPartNumTimerCnts >= 150) {
						GetPartNumSent = 0;
					} else {
						if (GetPartNumTimerCnts >= 50) {
							UpdateGetClusterPartNum();
						}
					}
				}
			}
		}
		break;
	//KSר��
    case 6:
        memset(&MultiplePack, 0, sizeof (MultiplePack));
		MyRecvCount = 0;
		
		Send_7CE_Data.Byte0Data = 0x03;
		Send_7CE_Data.Byte1Data = 0x22;
		Send_7CE_Data.Byte2Data = 0xF1;
		Send_7CE_Data.Byte3Data = 0x8B;
		CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_40, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
		RxFinish = UNFINISH;
        GetPartNumSent = 7;
        break;
    case 7:                               //KS ��ȡ����ʱ��
        if (RxFinish == FINISH) {  //��ȡ����
            GetPartNumSent = 8;
        }
        break;
#endif		
	default:
		break;
	}
}

void SendCan0Message_7DF(void)
{
    if ((Timer10msCnts > SendCanMessage3000msTimer) && ((Timer10msCnts - SendCanMessage3000msTimer) >= 3000)) 
    {
      // 1000ms
      SendCanMessage3000msTimer = Timer10msCnts;
      Send_7DF_Data.msg.bits.Byte0Data = 0x02;
      Send_7DF_Data.msg.bits.Byte1Data = 0x3E;   
      Send_7DF_Data.msg.bits.Byte1Data = 0x80; 
      CanFD_Send_StandMsg(CANFD0_Type, 0x7DF, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7DF_Data.msg.data, 3);
    }
}

void SetError(uint16_t uiErrorCode)
{
    ErrorCode = uiErrorCode;//���ش�����
    if (uiErrorCode != 11 && uiErrorCode != 12) {
        Err_Status = 1;
    }
    if (Err_Status == 1 && g_uiCheckResultSaveFlag == 0) {
        SaveMiscValid = 1;
        g_uiCheckResultSaveFlag = 1;
        memset(CheckResult,0,sizeof(CheckResult));
        memcpy(CheckResult,&g_stCheckResult,sizeof(g_stCheckResult));
    }
}

void APP_OIL_Down(void) //ȼ��ˮ��- �鿴SN��
{
    switch(CurrNum)
    {
        case 0:
        EOL_UDS_Key22Step_2_1();
        RxFinish = UNFINISH;

        CurrNum = 1;
        break;
        case 1:
        if(RxFinish == FINISH)
        {
            
        }
        break;
    }
}

void APP_OIL_TEMP(void) //ȼ��ˮ��  ˮ�µı��ķ��ͷŵ���10ms
{
    Default_flag=1;
    if(g_Stage != STAGE_WaterAndFuel)
    {
        //Iol_TempCurrent.enable = 0;
    }
  // switch (Iol_TempCurrent.count)
  // {
  //     case 0:
  //         LampState_L.Lamps.RELAY_L4 = 0;
  //         LampState_L.Lamps.RELAY_F1 = 0;
  //         LampState_L.Lamps.RELAY_F2 = 0;
  //         LampState_L.Lamps.RELAY_F3 = 0;
  //         LampState_L.Lamps.RELAY_F4 = 0;
  //         LampState_L.Lamps.RELAY_L3 = 0;
  //         Iol_TempCurrent.statu = UNFINISH;
  //         break;
  //         
  //     case 1:
  //         if(Iol_TempCurrent.enable == 1)
  //         {
  //             LampState_L.Lamps.RELAY_B = 0;
  //             LampState_L.Lamps.RELAY_IGN1 = 0;
  //             if(Iol_TempCurrent.Time > 1000)
  //             {
  //                 LampState_L.Lamps.RELAY_IGN1 = 1;
  //                 LampState_L.Lamps.RELAY_B = 1;
  //                 Iol_TempCurrent.enable = 0;
  //             } 
  //         }
  //         LampState_L.Lamps.RELAY_L4 = 0;
  //         LampState_L.Lamps.RELAY_F1 = 1;//ȼ�Ϳյ� һ����˸                   
  //         LampState_L.Lamps.RELAY_F2 = 0;
  //         LampState_L.Lamps.RELAY_F3 = 0;
  //         LampState_L.Lamps.RELAY_F4 = 0;
  //         LampState_L.Lamps.RELAY_L3 = 0;
  //         //Gear_P();
  //         DisPlayCurChargingTime_H = 0106;         
  //         
  //         Iol_TempCurrent.statu = UNFINISH;
  //         break;
  //     case 2:
  //         if(Iol_TempCurrent.enable == 1) 
  //         {
  //             LampState_L.Lamps.RELAY_IGN1 = 0;
  //             LampState_L.Lamps.RELAY_B = 0;
  //             if(Iol_TempCurrent.Time > 1000)
  //             {
  //                 LampState_L.Lamps.RELAY_IGN1 = 1;
  //                 LampState_L.Lamps.RELAY_B = 1;
  //                 Iol_TempCurrent.enable = 0;
  //             }
  //         }
  //         LampState_L.Lamps.RELAY_L4 = 0;
  //         LampState_L.Lamps.RELAY_F1 = 0;                 
  //         LampState_L.Lamps.RELAY_F2 = 1;//ȼ�ͱ����� һ��
  //         LampState_L.Lamps.RELAY_F3 = 0;
  //         LampState_L.Lamps.RELAY_F4 = 0;
  //         LampState_L.Lamps.RELAY_L3 = 0;   
             
             //Gear_R();

// #if (CAN_2ND)
//            EMS12.msg.bits.TEMP_ENG = TEMP_SEG1 ;   //70.5  
//#if (PRO_AI3)
//            EMS_CNG11.msg.bits.CNG_FTL = CNG_SEG1;
//#elif ((PRO_CN7C) || (PRO_QYC))
//            if(GetCluType() == SVC_CFG){
//                EMS12.msg.bits.TEMP_ENG = TEMP_SEG1_SVC;
//            }
//            else{
//                EMS12.msg.bits.TEMP_ENG = TEMP_SEG1;
//            }
//#elif (PRO_CN7)
//            EMS12.msg.bits.TEMP_ENG = TEMP_SEG1 ;   //62.25 
//            HEV_PC9.msg.bits.CR_Bms_DisplaySoc = SOC_WARNING1;
//#endif
//#endif
//#if (CAN_3RD)
//#if (PRO_NU2)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG1_STD; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG1;
//            }
//#elif (PRO_NX4C)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_WARNING;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG1; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_WARNING_SVC;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG1;
//            }
//#else
//            BMS_02_100ms.xEV_SocDis = SOC_WARNING;
//            EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG1;
//#endif
//#endif                            
//           Iol_TempCurrent.statu = UNFINISH;
//           break;
//        case 3://�������������
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                LampState_L.Lamps.RELAY_B = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
//            LampState_L.Lamps.RELAY_L3 = 1;///ȼ������ 
//            LampState_L.Lamps.RELAY_L4 = 0;
//            LampState_L.Lamps.RELAY_F1 = 0;                   
//            LampState_L.Lamps.RELAY_F2 = 0;
//            LampState_L.Lamps.RELAY_F3 = 0;
//            LampState_L.Lamps.RELAY_F4 = 0;
//#if (CAN_2ND)
//            EMS12.msg.bits.TEMP_ENG = 0x85 ;   //116.25    
//#endif
//#if (CAN_3RD)
//            BMS_02_100ms.xEV_SocDis = 0x3D;
//            EMS_02_10ms.ENG_EngClntTempVal=0x82;
//#endif                   
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//        case 3:
//            // if(Iol_TempCurrent.enable == 1)
//            // {
//            //     LampState_L.Lamps.RELAY_IGN1 = 0;
//            //     LampState_L.Lamps.RELAY_B = 0;
//            //     if(Iol_TempCurrent.Time > 1000)
//            //     {
//            //         LampState_L.Lamps.RELAY_IGN1 = 1;
//            //         LampState_L.Lamps.RELAY_B = 1;
//            //         Iol_TempCurrent.enable = 0;
//            //     }
//            // }
//            // LampState_L.Lamps.RELAY_L4 = 0;
//            // LampState_L.Lamps.RELAY_F1 = 0;                   
//            // LampState_L.Lamps.RELAY_F2 = 0;
//            // LampState_L.Lamps.RELAY_F3 = 1;//ȼ������ 
//            // LampState_L.Lamps.RELAY_F4 = 0;
//            // LampState_L.Lamps.RELAY_L3 = 0;
//            
//            Gear_N();
//#if (CAN_2ND)
//            EMS12.msg.bits.TEMP_ENG = TEMP_SEG6 ;   //120.75 
//#if (PRO_AI3)
//            EMS_CNG11.msg.bits.CNG_FTL = CNG_SEG6;
//#elif ((PRO_CN7C) || (PRO_QYC))
//            if(GetCluType() == SVC_CFG){
//                EMS12.msg.bits.TEMP_ENG = TEMP_SEG6_SVC;
//            }
//            else{
//                EMS12.msg.bits.TEMP_ENG = TEMP_SEG6;
//            }
//#elif (PRO_CN7)
//            EMS12.msg.bits.TEMP_ENG = TEMP_SEG6 ;   //62.25 
//            HEV_PC9.msg.bits.CR_Bms_DisplaySoc = SOC_MIDDLE1;
//#endif        
//#endif
//#if (CAN_3RD)
//#if (PRO_NU2)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG6_STD; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG6;
//            }
//#elif (PRO_NX4C)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_MIDDLE;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG6; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_MIDDLE_SVC;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG6;
//            }
//#else
//            BMS_02_100ms.xEV_SocDis = SOC_MIDDLE;
//            EMS_02_10ms.ENG_EngClntTempVal=TEMP_SEG6;
//#endif
//#endif                         
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//       
//        case 4:
//            // if(Iol_TempCurrent.enable == 1)
//            // {
//            //     LampState_L.Lamps.RELAY_IGN1 = 0;
//            //     LampState_L.Lamps.RELAY_B = 0;
//            //     if(Iol_TempCurrent.Time > 1000)
//            //     {
//            //         LampState_L.Lamps.RELAY_IGN1 = 1;
//            //         LampState_L.Lamps.RELAY_B = 1;
//            //         Iol_TempCurrent.enable = 0;
//            //     }
//            // }
//            // LampState_L.Lamps.RELAY_L4 = 0;
//            // LampState_L.Lamps.RELAY_F1 = 0;                    
//            // LampState_L.Lamps.RELAY_F2 = 0;
//            // LampState_L.Lamps.RELAY_F3 = 0;
//            // LampState_L.Lamps.RELAY_F4 = 1;//ȼ������
//            // LampState_L.Lamps.RELAY_L3 = 0;
//            
//            Gear_D();
//#if (CAN_2ND)
//            EMS12.msg.bits.TEMP_ENG = TEMP_FULL ;   //120.75 
//#if (PRO_AI3)
//            EMS_CNG11.msg.bits.CNG_FTL = CNG_FULL;
//#elif ((PRO_CN7C) || (PRO_QYC))
//            if(GetCluType() == SVC_CFG){
//                EMS12.msg.bits.TEMP_ENG = TEMP_FULL_SVC;
//            }
//            else{
//                EMS12.msg.bits.TEMP_ENG = TEMP_FULL;
//            }
//#elif (PRO_CN7)
//            EMS12.msg.bits.TEMP_ENG = TEMP_FULL ;   //62.25 
//            HEV_PC9.msg.bits.CR_Bms_DisplaySoc = SOC_FULL1;
//#endif
//#endif
//#if (CAN_3RD)
//#if (PRO_NU2)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_FULL_STD; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_EMPTY;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_FULL;
//            }
//#elif (PRO_NX4C)
//            if(GetCluType() == STD_CFG){
//               BMS_02_100ms.xEV_SocDis = SOC_FULL;
//               EMS_02_10ms.ENG_EngClntTempVal=TEMP_FULL; 
//            }
//            else if(GetCluType() == SVC_CFG){
//                BMS_02_100ms.xEV_SocDis = SOC_FULL_SVC;
//                EMS_02_10ms.ENG_EngClntTempVal=TEMP_FULL;
//            }
//#else
//            BMS_02_100ms.xEV_SocDis = SOC_FULL;
//            EMS_02_10ms.ENG_EngClntTempVal=TEMP_FULL;
//#endif
//#endif            
//           Iol_TempCurrent.statu = UNFINISH;
//           break;    
//#if (PRO_QYC)
//        case 5:
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                LampState_L.Lamps.RELAY_B = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
//            LampState_L.Lamps.RELAY_L4 = 0;
//            LampState_L.Lamps.RELAY_F1 = 0;                    
//            LampState_L.Lamps.RELAY_F2 = 0;
//            LampState_L.Lamps.RELAY_F3 = 0;
//            LampState_L.Lamps.RELAY_F4 = 1;//ȼ������
//            LampState_L.Lamps.RELAY_L3 = 0;
//            if(GetCluType() == SVC_CFG){
//                EMS12.msg.bits.TEMP_ENG = TEMP_FULL_SVC;
//            }
//            else{
//                EMS12.msg.bits.TEMP_ENG = TEMP_FULL_UP;
//            }
//           Iol_TempCurrent.statu = UNFINISH;
//           break;  
//#endif
//            case 5://�������������
//            //            if(Iol_TempCurrent.enable == 1)
//            //            {
//            //                LampState_L.Lamps.RELAY_IGN1 = 0;
//            //                LampState_L.Lamps.RELAY_B = 0;
//            //                if(Iol_TempCurrent.Time > 1000)
//            //                {
//            //                    LampState_L.Lamps.RELAY_IGN1 = 1;
//            //                    LampState_L.Lamps.RELAY_B = 1;
//            //                    Iol_TempCurrent.enable = 0;
//            //                }
//            //            }
//            //            LampState_L.Lamps.RELAY_L4 = 1;//ȼ�;Ÿ� 
//            //            LampState_L.Lamps.RELAY_F1 = 0;                   
//            //            LampState_L.Lamps.RELAY_F2 = 0;
//            //            LampState_L.Lamps.RELAY_F3 = 0;
//            //            LampState_L.Lamps.RELAY_F4 = 0;
//            //            LampState_L.Lamps.RELAY_L3 = 0;
//            // #if (CAN_2ND)
//            //            EMS12.msg.bits.TEMP_ENG = 0xdb ;   //120.75  
//            // #endif
//            // #if (CAN_3RD)
//            //            BMS_02_100ms.xEV_SocDis = 0x83;
//            //            EMS_02_10ms.ENG_EngClntTempVal=0xDB;
//            // #endif                           
//            //            Iol_TempCurrent.statu = UNFINISH;
//            Gear_OUT();
//            break;
//            case 6://�������������
//            //            if(Iol_TempCurrent.enable == 1)
//            //            {
//            //                LampState_L.Lamps.RELAY_IGN1 = 0;
//            //                LampState_L.Lamps.RELAY_B = 0;
//            //                if(Iol_TempCurrent.Time > 1000)
//            //                {
//            //                    LampState_L.Lamps.RELAY_IGN1 = 1;
//            //                    LampState_L.Lamps.RELAY_B = 1;
//            //                    Iol_TempCurrent.enable = 0;
//            //                }
//            //            }
//            //            LampState_L.Lamps.RELAY_L4 = 1;//ȼ�;Ÿ� 
//            //            LampState_L.Lamps.RELAY_F1 = 0;                   
//            //            LampState_L.Lamps.RELAY_F2 = 0;
//            //            LampState_L.Lamps.RELAY_F3 = 0;
//            //            LampState_L.Lamps.RELAY_F4 = 0;
//            //            LampState_L.Lamps.RELAY_L3 = 0;
//            // #if (CAN_2ND)
//            //            EMS12.msg.bits.TEMP_ENG = 0xdb ;   //120.75  
//            // #endif
//            // #if (CAN_3RD)
//            //            BMS_02_100ms.xEV_SocDis = 0x83;
//            //            EMS_02_10ms.ENG_EngClntTempVal=0xDB;
//            // #endif                           
//            //            Iol_TempCurrent.statu = UNFINISH;
//            //SpeedRpmMax();
//            APP_END();
//            break;
//    }
}

void ProjectDynamicConfig(void)
{
        Default_flag = 1;
        Err_Status = 0;
        ErrorCode  = 0;
        g_uiBackDoorFlag = 0;
#if (PRO_NQ5C)
        if (JudgePartNum() == PartNum_NQ5C_Outlet){
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 8;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
        } else if (JudgePartNum() == PartNum_NQ5C){
            if (g_VehicleType == CAR_TYPE_ICV) {
                g_SpeedMaxCheckSteps = SPEED_MAX;
                g_ElseDmsMaxCheckSteps = 3;
                if(IsSupportBVM() == BVM_YES)
                    g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
                else
                    g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
            
            }
            else {
                g_SpeedMaxCheckSteps = SPEED_MAX;
                g_ElseDmsMaxCheckSteps = 2;
                if(IsSupportBVM() == BVM_YES)
                    g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
                else
                    g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
            }
        }
#elif (PRO_SQFL)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        if(IsHaveSportPlus() == SPORT_PLUS_YES) {
            g_ElseDmsMaxCheckSteps = 3;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
        }    
        else {
            g_ElseDmsMaxCheckSteps = 3;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        }   
#elif (PRO_PDEPE2)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        if(IsSupportBVM() == BVM_YES)
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
        else
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_BN7R)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        if(IsSupportBVM() == BVM_YES)
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
        else
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_SU2IFL)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 6;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_SU2BFL)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 7;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_SU2ID_FL)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 10;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_BN7I)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_KY)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_GL3)
    if (g_VehicleType == CAR_TYPE_ICV){
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;  
    }
    else {
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;  
    }
#elif (PRO_SG2)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_BC3)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_KS)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 10;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_YB_PE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_SP2C_PE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 10;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_SP2)
        if (JudgePartNum() == PartNum_SP2){
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 8;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        } else if (JudgePartNum() == PartNum_SP2I){
            g_SpeedMaxCheckSteps = SPEED_MAX_SP2I;
            g_ElseDmsMaxCheckSteps = 6;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
        }
#elif (PRO_KU)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 8;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
//#elif (PRO_SQFL)
//        g_SpeedMaxCheckSteps = SPEED_MAX;
//        g_ElseDmsMaxCheckSteps = 1;
//        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_LX2)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 8;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_SK3_PE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_BL7M)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_BL7R)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_CN7)
    if (g_VehicleType == CAR_TYPE_ICV){
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 7;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
    }
    else {
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 3;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
    }
#elif (PRO_AX)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 2;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM; 
#elif (PRO_US4)
        if(g_VehicleType == CAR_TYPE_ICV) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 3;
        }
        else if(g_VehicleType == CAR_TYPE_HEV) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 2;
        }

        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;   
#elif (PRO_NUPE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 10;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;     
#elif (PRO_QX23)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 6;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;        
#elif (PRO_ONPE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 8;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;  
#elif (PRO_QXI)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;  
#elif (PRO_NQ5)
        if(g_VehicleType == CAR_TYPE_ICV) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 7;
        }
        else {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 3;
        }
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;   
#elif ((PRO_CN7C))
        if (GetCluType() == SVC_CFG) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 9;
            if(IsSupportBVM() == BVM_YES)
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
            else
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        
        }
        else {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 8;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
            if(IsSupportBVM() == BVM_YES)
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
            else
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        }
#elif (PRO_NX4C)
        if(g_VehicleType == CAR_TYPE_ICV) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 10;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        }else {
            g_SpeedMaxCheckSteps = SPEED_MAX_HEV;
            g_ElseDmsMaxCheckSteps = 3;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
         }
#elif (PRO_QYC)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 14;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_AI3)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 0;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif ((PRO_TAM) || (PRO_BR2))
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 1;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_AC3_PE)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 4;
        g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_DL3C)
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 8;
        if(IsSupportBVM() == BVM_YES)
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
        else
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif (PRO_JAPE2)
       g_SpeedMaxCheckSteps = SPEED_MAX;
       g_ElseDmsMaxCheckSteps = 4;
       g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
#elif ((PRO_NU2))
        if (GetCluType() == SVC_CFG) {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 10;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
            if(IsSupportBVM() == BVM_YES)
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM + BVM_STEP_NUM;
            else
                g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        
        }
        else {
            g_SpeedMaxCheckSteps = SPEED_MAX;
            g_ElseDmsMaxCheckSteps = 10;
            g_ElseMaxCheckSteps = g_ElseDmsMaxCheckSteps + PDWLV_STEP_NUM;
        }
#else
        g_SpeedMaxCheckSteps = SPEED_MAX;
        g_ElseDmsMaxCheckSteps = 0;
        g_ElseMaxCheckSteps = 0;
#endif  
}

void UserPressKey30(void)
{
    //LampState_L.Lamps.RELAY_B = ~LampState_L.Lamps.RELAY_B;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    if(LampState_L.Lamps.RELAY_B == 1) {
        LampState_L.Lamps.RELAY_B = 0;
    } else {
        LampState_L.Lamps.RELAY_B = 1;
    }
}

void can(void)
{
#if (PRO_JAPE2)
    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) {        
        //10ms 
        SendCanMessage10msTimer = Timer10msCnts;   
        CGW1.msg.bits.CF_Gway_TurnSigLh = 0x1;
        CGW1.msg.bits.CF_Gway_TurnSigRh = 0x1;
        CanFD_Send_StandMsg(CANFD0_Type, 0x541, BUF_39, TX_ISR_EN, (uint8_t *)&CGW1, 8);
      //Can_Clear((uint8_t *)&CGW1, 8);
        }
#endif
}

void UserPressKey15(void)
{
#if (PRO_JAPE2)
    if(LampState_L.Lamps.RELAY_IGN1 == 1){
        LampState_L.Lamps.RELAY_IGN1 = 0;
        TftTimer = CUNT_DOWN_TIME;
        g_uiCuntDownFlag = 1;
        CANSendEnable = OFF;
    }
    else if(LampState_L.Lamps.RELAY_IGN1 == 0){
        LampState_L.Lamps.RELAY_IGN1 = 1;
        TftTimer = 0;
        g_uiCuntDownFlag = 0;
        CANSendEnable = ON;
    }
#else
    //LampState_L.Lamps.RELAY_IGN1 = ~LampState_L.Lamps.RELAY_IGN1;  
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    
    if(LampState_L.Lamps.RELAY_IGN == 1) {
        LampState_L.Lamps.RELAY_IGN = 0;
    } else {
        LampState_L.Lamps.RELAY_IGN = 1;
    }
#endif
}

void UserPressAuto(void)
{
    g_Stage = STAGE_AutoCheck;
#if (PRO_CONFIG_CHECK_APPLY)       
   Auto_Init(1);//��������̬�������
#endif
}

void UserPressEOL(void)
{
        g_Stage = STAGE_SetEOL;
//#if (PRO_NQ5C)        
//        g_EolCfgFuelType = 0;
#if ((PRO_US4) || (PRO_NQ5) || (PRO_GL3))
        g_EolCfgFuelType++;
        if (g_EolCfgFuelType == 3)
            g_EolCfgFuelType = 0;
#elif (PRO_CN7)
    if (g_VehicleType == CAR_TYPE_ICV){
        g_EolCfgFuelType++;
        if (g_EolCfgFuelType == 3)
            g_EolCfgFuelType = 0;
    }else{
        g_EolCfgFuelType++;
        if (g_EolCfgFuelType == 2)
            g_EolCfgFuelType = 0;
     }
#else
        g_EolCfgFuelType = !g_EolCfgFuelType;
#endif
        EOL.Flag = 0;
        EOL.Statu = 0;
        Key27Step = 0;
        Eol_Timer = 0;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        
}
uint8_t g_LedCheckDeriction = 0;
void UserPressWarning(void)
{
    g_Stage = STAGE_Led_Telltale_Check;
#if (PRO_CONFIG_CHECK_APPLY)    
    if(g_LedCheckDeriction == 1 && LedCurrent.count > 0) {
        LedCurrent.count = 0;
    }    
    g_LedCheckDeriction = 0;
    if (g_uiLedWaitTimer <= 0){
#if (SEMI_AUTOMATIC_STAGE)
        if(LedCurrent.count < STAGE_COUNT_HARD_LINE_LED)           
            LedCurrent.count ++;
            g_uiLedWaitTimer = 1000;
//        if(LedCurrent.count == 4){
//            LedCurrent.count = 1;
//        }
#else
#if (PRO_NU2)
        if(LedCurrent.count < 6)           
            LedCurrent.count ++;
            g_uiLedWaitTimer = 1000;
        if(LedCurrent.count == 6){
            LedCurrent.count = 1;
        }
#else 
        if(LedCurrent.count < 4)           
            LedCurrent.count ++;
            g_uiLedWaitTimer = 1000;
        if(LedCurrent.count == 4){
            LedCurrent.count = 1;
        }
#endif 
#endif
    }
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    LedCurrent.Flag = 0;
#endif    
}
uint8_t g_SpeedCheckDeriction = 0;
void UserPressKeySpeedUp(void)
{
    g_Stage = STAGE_Speed;
#if (PRO_CONFIG_CHECK_APPLY)       
    g_SpeedCheckDeriction = 0;
    SpeedCurrent.Time = 0;
    SpeedCurrent.enable = 1;
#if (SEMI_AUTOMATIC_STAGE)
    if (SpeedCurrent.count < g_SpeedMaxCheckSteps)
        SpeedCurrent.count ++;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
//    if(SpeedCurrent.count > g_SpeedMaxCheckSteps)
//        SpeedCurrent.count = 0;
#else
    if(LedCurrent.count != 0)
    {
        LedCurrent.count--;
    }
    else
    {
        LedCurrent.count = g_uiLedNum;
    }
    if(LedCurrent.count < 1)
    LedCurrent.count = g_uiLedNum;
    // SpeedCurrent.count ++;
    // memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    // memset(&CheckCurrent,0,sizeof(CheckCurrent));
    // if(SpeedCurrent.count > g_SpeedMaxCheckSteps)
    //     SpeedCurrent.count = 0;
#endif
#endif    
}

void UserPressKeySpeedDown(void)
{
    g_Stage = STAGE_Speed;
#if (PRO_CONFIG_CHECK_APPLY)       
    g_SpeedCheckDeriction = 1;
    if(g_LedCheckDeriction == 0 && LedCurrent.count > 0) {
        LedCurrent.count = 0;
    }    
    g_LedCheckDeriction = 1;    
    if (g_uiB_PlusResetWaitTimer == 0) {//�����Ǳ��ָ�Ĭ�ϼ�ʻģʽǰ�������л������
        if (g_uiSmartComfortWaitTimer <= 1) {
#if (SEMI_AUTOMATIC_STAGE)
            if (LedCurrent.count < g_uiLedNum)
                LedCurrent.count++;
//            if(LedCurrent.count > g_uiLedNum)
//                LedCurrent.count = 1;
#else
            LedCurrent.count++;
            if(LedCurrent.count > g_uiLedNum)
                LedCurrent.count = 1;
#endif
            ResetLedFlag();
            SetCurrentStep(0);
        } 
    }
#endif    
}
uint8_t g_OilTempCheckDeriction = 0;
void UserPressKeyOilTempUp(void)
{
    g_Stage = STAGE_WaterAndFuel;
#if (PRO_CONFIG_CHECK_APPLY)       
    g_OilTempCheckDeriction = 0;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    //Iol_TempCurrent.enable = 1;
    Iol_TempCurrent.Flag = 1;
    
#if (SEMI_AUTOMATIC_STAGE)
#if (PRO_QYC)
    if (GetCluType() == STD_CFG){
        if (Iol_TempCurrent.count < STAGE_COUNT_FUEL_WATER_QYC)
            Iol_TempCurrent.count ++;  
    }else{
        if (Iol_TempCurrent.count < STAGE_COUNT_FUEL_WATER)
            Iol_TempCurrent.count ++;  
    }
#else
    if (Iol_TempCurrent.count < STAGE_COUNT_FUEL_WATER)
        Iol_TempCurrent.count ++;  
#endif
#else
#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
    Iol_TempCurrent.count ++;
#if (PRO_QYC)
    if (GetCluType() == STD_CFG){
        if(Iol_TempCurrent.count > 5){
            Iol_TempCurrent.count = 1;
        }
    }else{
        if(Iol_TempCurrent.count > 4){
            Iol_TempCurrent.count = 1;
        }
    }
#else
    if(Iol_TempCurrent.count > 6){
        Iol_TempCurrent.count = 1;
    }
#endif
#elif (PRO_CONFIG_CHECK_APPLY_TYPE2)
    Iol_TempCurrent.count = 6;
#endif
#endif
#endif    
}
uint8_t CurrNum = 0;
void UserPressKeyOilTempDown(void)
{
    g_Stage = STAGE_OilDown;
#if (PRO_CONFIG_CHECK_APPLY)       
    //g_OilTempCheckDeriction = 1;
    //Auto_Init(1);
    //CurrNum = 0;
    //Err_Stage = 0;        
    //memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    //memset(&CheckCurrent,0,sizeof(CheckCurrent));
    //Iol_TempCurrent.enable = 1;
    //if((Iol_TempCurrent.count==0)||(Iol_TempCurrent.count==1)){
    //    Iol_TempCurrent.count= 7;
    //}
    //Iol_TempCurrent.count --;
    //Iol_TempCurrent.Flag = 0;
    //if(Iol_TempCurrent.count == 3){
    //    Iol_TempCurrent.count = 2;
    //}
    //else if(Iol_TempCurrent.count == 5){
    //    Iol_TempCurrent.count = 4;
    //}  
#endif 
}
uint8_t g_TftCheckDeriction = 0;
void UserPressKeyTftUp(void)
{
#if (PRO_CONFIG_CHECK_APPLY)
    g_Stage = STAGE_TFTCheck;
    if(g_TftCheckDeriction == 1 && TFTCurrent.count > 0) {
        TFTCurrent.count = 0;
    }
    g_TftCheckDeriction = 0;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    TFTCurrent.count++;
#endif
}

void UserPressKeyTftDown(void)
{ 
#if (PRO_CONFIG_CHECK_APPLY)
    g_Stage = STAGE_TFTCheck;
    if(g_TftCheckDeriction == 0 && TFTCurrent.count > 0) {
        TFTCurrent.count = 0;
    }
    g_TftCheckDeriction = 1;
    ResetLedFlag();
    g_SEAT_BELT_Sound_Check = 1;
    SetCurrentStep(0);
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    TFTCurrent.count++;
#if (SEMI_AUTOMATIC_STAGE)
//    if(TFTCurrent.count > g_uiTftNum)
//        TFTCurrent.count = 1;
#else
    if(TFTCurrent.count > g_uiTftNum)
        TFTCurrent.count = 1;
#endif
#endif
}

void UserPressKeyBackLight(void)
{     
    g_Stage = STAGE_LCDCheck;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    Back_lightCurrent.count ++;
    if(Back_lightCurrent.count > 3){
        Back_lightCurrent.count = 0;
    }
}

void UserPressKeyLuminosity(void)
{        
    g_Stage = STAGE_LCDCheck;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    LuminosityCurrent.count ++;
    if(LuminosityCurrent.count > 20){
        LuminosityCurrent.count = 1;
    }       
}
uint8_t g_CurPressMenuKey = 0;
void UserPressKeyMenu(void)
{   
    switch(LCDCurrent.count){
        case 0:
            PressStateReset();
            Default_flag = 0;
            LCDCurrent.count = 1;
            break;
        case 1:
            LCDCurrent.enable = 1;
    //        PressKey(LCDCurrent.count,KEY_30,TRIPSW_SHORT_PRESS);
            AfterTimeGoNext(&LCDCurrent,5000);
            break;
        case 2:
            SetPressKeySequence(KEY_SW1_MENU,KEY_SW1_MENU,KEY_SW1_DOWN,KEY_SW1_DOWN,KEY_SW1_OK,KEY_SW1_OK,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            DoPressKeySimulation(TIME_400);
            AfterTimeGoNext(&LCDCurrent,5000);
            break;
        }
}
uint8_t g_CurPressUpKey = 0;
void UserPressKeyUp(void)
{        
    SetPressKeySequence(KEY_SW1_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    DoPressKeySimulation(TIME_400);
}
uint8_t g_CurPressDownKey = 0;
void UserPressKeyDown(void)
{        
    SetPressKeySequence(KEY_SW1_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    DoPressKeySimulation(TIME_400);
}
uint8_t g_CurPressOKKey = 0;
void UserPressKeyOK(void)
{        
    LedCurrent.statu = UNFINISH;
             Send_7C6_Data.msg.bits.Byte0Data = 0x02;
             Send_7C6_Data.msg.bits.Byte1Data = 0x10;
             Send_7C6_Data.msg.bits.Byte2Data = 0x01;  
             CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
             Delay(5);//5ms
    SetPressKeySequence(KEY_30,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    Default_flag = 1;
    DoPressKeySimulation(TIME_400);
}

void UserPressKeyElse(void)
{
    g_Stage = STAGE_Other;
#if (PRO_CONFIG_CHECK_APPLY)       
    Err_Timer = 0;
    MODEtimer = 0;
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
#if (SEMI_AUTOMATIC_STAGE)
    if(0 == ElseCurrent.count && ElseCurrent.count <= g_ElseDmsMaxCheckSteps) {
         DMS_NORMAL = 0;
         DMS_ECO   = 0;
         DMS_SPORT = 0;
         if(ElseCurrent.count == 1){
            DMS_SMART = 0;
         }
         DMS_Mud = 0;
         DMS_Sand = 0;
         DMS_Snow = 0;
         ElseCurrent.count++;
         SetCurrentStep(0);
         InitPressKeySimulation(); 
    } 
    else if(1 <= ElseCurrent.count && ElseCurrent.count <= g_ElseDmsMaxCheckSteps) {
          if(GetPressUpOver() == 1) {
             DMS_NORMAL = 0;
             DMS_ECO   = 0;
             DMS_SPORT = 0;
             if(ElseCurrent.count == 1){
                DMS_SMART = 0;
             }
             DMS_Mud = 0;
             DMS_Sand = 0;
             DMS_Snow = 0;
             ElseCurrent.count++;
             SetCurrentStep(0);
             InitPressKeySimulation(); 
          }
    }
    else{
        ElseCurrent.enable = 1;
        ElseCurrent.Time = 0;
        ElseCurrent.Value = 0; 
    }
#else
    if(1 <= ElseCurrent.count && ElseCurrent.count <= g_ElseDmsMaxCheckSteps) {
          if(GetPressUpOver() == 1) {
             DMS_NORMAL = 0;
             DMS_ECO   = 0;
             DMS_SPORT = 0;
             if(ElseCurrent.count == 1){
                DMS_SMART = 0;
                }
             DMS_Mud = 0;
             DMS_Sand = 0;
             DMS_Snow = 0;
             ElseCurrent.count++;
             SetCurrentStep(0);
             InitPressKeySimulation(); 
          }
    }
    else{
        if(PowerCheckFlag == POWER_CHECK_END)
            ElseCurrent.count++;
       
        ElseCurrent.enable = 1;
        ElseCurrent.Time = 0;
        ElseCurrent.Value = 0; 
    }
    if(ElseCurrent.count >= g_ElseMaxCheckSteps + 1)
        ElseCurrent.count = 1;
#endif
#endif
      if (g_uiB_PlusResetWaitTimer == 0) {//�����Ǳ��ָ�Ĭ�ϼ�ʻģʽǰ�������л������
        if (g_uiSmartComfortWaitTimer <= 1) {
            LedCurrent.count++;
            if(LedCurrent.count > g_uiLedNum)
                LedCurrent.count = 1;
            ResetLedFlag();
            SetCurrentStep(0);
        } 
      }
}

void UserPressKeyEnd(void)
{
    g_Stage = STAGE_ClearODO;
#if (PRO_CONFIG_CHECK_APPLY)       
    g_CostTimeSecond = 0;
    ClearedOdoFlag = 0;
   
    memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
    memset(&CheckCurrent,0,sizeof(CheckCurrent));
    if((EndCurrent.Flag != FINISH) || (g_OldStage != g_Stage) )
    { 
        EndCurrent.Flag = 0;
        EndCurrent.statu = 0;
        EndCurrent.Time = 0;
		Key27Step = 0;
        EndCurrent.count = OFF;
        EndCurrent.enable = 1;
    }
#endif    
}

uint8_t g_BackLightSetFlag = 0;
void APP_LCD_OUTPUT(void) 
{
    //LampState_L.Lamps.RELAY_B = 1;
   // LampState_L.Lamps.RELAY_IGN1 = 1;
#if ((PRO_KS) || (PRO_BR2))
    if (g_CurPressMenuKey == 1){
        UserPressKeyMenu();
        Send_7C6_Data.msg.bits.Byte0Data = 0x02;
        Send_7C6_Data.msg.bits.Byte1Data = 0x10;
        Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
        
        Delay(5);//5ms
        Send_7C6_Data.msg.bits.Byte0Data = 0x04;
        Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
        Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
        Send_7C6_Data.msg.bits.Byte3Data = 0x01;
        Send_7C6_Data.msg.bits.Byte4Data = 0x03;
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
    }else if (g_CurPressUpKey == 1){
        UserPressKeyUp();
        Send_7C6_Data.msg.bits.Byte0Data = 0x02;
        Send_7C6_Data.msg.bits.Byte1Data = 0x10;
        Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
        
        Delay(5);//5ms
        Send_7C6_Data.msg.bits.Byte0Data = 0x04;
        Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
        Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
        Send_7C6_Data.msg.bits.Byte3Data = 0x01;
        Send_7C6_Data.msg.bits.Byte4Data = 0x03;
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
    }else if (g_CurPressDownKey == 1){
        UserPressKeyDown();
        Send_7C6_Data.msg.bits.Byte0Data = 0x02;
        Send_7C6_Data.msg.bits.Byte1Data = 0x10;
        Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
        
        Delay(5);//5ms
        Send_7C6_Data.msg.bits.Byte0Data = 0x04;
        Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
        Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
        Send_7C6_Data.msg.bits.Byte3Data = 0x01;
        Send_7C6_Data.msg.bits.Byte4Data = 0x03;
        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
    }else if (g_CurPressOKKey == 1){
        UserPressKeyOK();
    }
    
    g_BackLightSetFlag = 5;
    switch(Back_lightCurrent.count)//����ģʽ
    {
        case 1://����ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x0;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x0;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x0;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x0;
#endif
            break;
        case 2://����ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x0;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x1;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x0;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x1;
#endif        
            break;
        case 3://ҹ��ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x1;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x0;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x1;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x0;
#endif        
            break;
        default:
            Default_flag = 1;
            break;
    }
#else
#if (CAN_2ND)     
    HU_MON_PE_01.HU_OptionInfo_L=0x2;
#endif
#if (CAN_3RD)
    HU_MON_PE_01.HU_OptionInfo=0x2;
#endif     

    Send_7C6_Data.msg.bits.Byte0Data = 0x02;
    Send_7C6_Data.msg.bits.Byte1Data = 0x10;
    Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
    
    Delay(5);//5ms
    Send_7C6_Data.msg.bits.Byte0Data = 0x04;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
    Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
    Send_7C6_Data.msg.bits.Byte3Data = 0x01;
    Send_7C6_Data.msg.bits.Byte4Data = 0x03;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
    g_BackLightSetFlag = 5;
    switch(Back_lightCurrent.count)//����ģʽ
    {
        case 1://����ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x0;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x0;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x0;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x0;
#endif
            break;
        case 2://����ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x0;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x1;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x0;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x1;
#endif        
            break;
        case 3://ҹ��ģʽ
            Default_flag = 0;
#if (CAN_2ND)         
            CGW2.msg.bits.CF_Gway_AvTail = 0x1;
            CGW2.msg.bits.CF_Gway_AutoLightValue = 0x0;
#endif
#if (CAN_3RD)
            BCM_07_200ms.Lamp_AvTailLmpSta = 0x1;
            BCM_09_200ms.Lamp_AutoLtSnsrNightSta = 0x0;
#endif        
            break;
        default:
            Default_flag = 1;
            break;
    }
    if(1 <= Back_lightCurrent.count && Back_lightCurrent.count <= 3) {
        HU_USM_E_04.CF_AVN_CluRheostatLvl = LuminosityCurrent.count;//���ȵȼ�
    }
#endif    
}

extern uint8_t g_uiCommState;

void LedCtrl(uint8_t uiLedNo, uint8_t uiLedState)
{
    switch (uiLedNo) {
        case LED1:
            LampState_M.Lamps.LED1 = uiLedState;
            break;
        case LED2:
            LampState_M.Lamps.LED2 = uiLedState;
            break;
        case LED3:
            LampState_M.Lamps.LED3 = uiLedState;
            break;
        case LED4:
            LampState_M.Lamps.LED4 = uiLedState;
            break;
    }
    bsp_BD8379_WriteData(LampState_L.LampData, LampState_M.LampData);
}

uint8_t g_uiSemiAutomaticStage = 0;

#define GoNextCheck()  {\
    if (g_PerFuncExecSecond == 0)\
        g_uiSemiAutomaticStage++;\
}
#define GoBackCheck()  {\
    if ((g_PerFuncExecSecond == 0) && (g_uiSemiAutomaticStage >= 1))\
        g_uiSemiAutomaticStage--;\
}
#if (SEMI_AUTOMATIC_STAGE)
void SetFunctionExecMinTimeBySecond(uint8_t uiMinTime)
{
    g_PerFuncExecSecond = uiMinTime;
}

void ExecSemiAutomaticCheck(uint8_t uiCallType)
{
    switch(g_uiSemiAutomaticStage)
    {
        case 0:
            if (uiCallType == 0) {
                if (EOL.Statu != STAGE_COUNT_EOL && EOL.Statu > 0) {//����ʧ��
                    g_EolCfgFuelType = !g_EolCfgFuelType;//�ָ���һ������
                }
                UserPressEOL();//ִ������EOL
                SetFunctionExecMinTimeBySecond(STAGE_COUNT_EOL_WAIT_TIME);
            } else {
                if (EOL.Statu == STAGE_COUNT_EOL) {
                    //SetFunctionExecMinTimeBySecond(0);
                    GoNextCheck();
                }
            }
            break;
        case 1:
            if (uiCallType == 0) {
                UserPressAuto();//ִ���Լ�
                SetFunctionExecMinTimeBySecond(STAGE_COUNT_AUTO_WAIT_TIME);
            } else {
                if (ButtomCurrent.count >= STAGE_COUNT_AUTO) {
                    SetFunctionExecMinTimeBySecond(0);
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }            
            break;  
        case 2:
            if (uiCallType == 0) {
                UserPressWarning();//ִ��Ӳ�߱����Ƽ��
                EOL.Statu = 0;
            } else {
                if(LedCurrent.count >= STAGE_COUNT_HARD_LINE_LED) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
        case 3:
            if (uiCallType == 0) {
                if (EOL.Statu != STAGE_COUNT_EOL && EOL.Statu > 0) {//����ʧ��
                    g_EolCfgFuelType = !g_EolCfgFuelType;//�ָ���һ������
                }
                UserPressEOL();//ִ������EOL
                SetFunctionExecMinTimeBySecond(STAGE_COUNT_EOL_WAIT_TIME);
                LedCurrent.count = 0;
                ButtomCurrent.count = 0;
            } else {
                if (EOL.Statu == STAGE_COUNT_EOL) {
                    //SetFunctionExecMinTimeBySecond(0);
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
        case 4:
            if (uiCallType == 0) {
                APP_LED_CLOS();//ִ���������������μ��
            } else {
                if(LedCurrent.count >= g_uiLedNum) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
        case 5:
            if (uiCallType == 0) {
                UserPressKeyBackLight();//����ҹ��
            } else {
                if(Back_lightCurrent.count >= STAGE_COUNT_FUEL_WATER) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
//        case 7:
//            if (uiCallType == 0) {
//                UserPressKeySpeedDown();//ִ���������������μ��
//            } else {
//                if(LedCurrent.count >= g_uiLedNum) {
//                    GoNextCheck();
//                }
//            }
//            break;
       case 6:
            if (uiCallType == 0) {
                UserPressKeyOilTempUp();//ִ��ȼ��ˮ�¼��
                SetFunctionExecMinTimeBySecond(STAGE_COUNT_EOL_WAIT_TIME);
                Back_lightCurrent.count = 0;
            } else {
                if (Iol_TempCurrent.count >= STAGE_COUNT_FUEL_WATER) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
       case 7:
            if (uiCallType == 0) {
                UserPressKeySpeedUp();//ִ�г��ټ��
                Iol_TempCurrent.count = 0;
            } else {
                if (SpeedCurrent.count >= g_SpeedMaxCheckSteps) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
       case 8:
            if (uiCallType == 0) {
                UserPressKeyTftDown();//ִ��TFT�������
                SpeedCurrent.count = 0;
            } else {
                if (TFTCurrent.count >= g_uiTftNum) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
       case 9:
            if (uiCallType == 0) {
                UserPressKeyTftUp();//ִ��TFT������
            } else {
                if (TFTCurrent.count >= STAGE_COUNT_TFT_SEG) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
       case 10:
            if (uiCallType == 0) {
                UserPressKeyElse();//ִ���������
                SetFunctionExecMinTimeBySecond(4);
            } else {
                if (ElseCurrent.count >= g_ElseMaxCheckSteps) {
                    if (Botton.SpeedUp.Flag == 1){
                        GoNextCheck();
                    }else if (Botton.SpeedDown.Flag == 1){
                        GoBackCheck();
                    }
                }
            }
            break;
        case 11:
            if (uiCallType == 0) {
                ElseCurrent.count = 0;
                UserPressKeyEnd();//ִ������
                SetFunctionExecMinTimeBySecond(45);
                g_uiSemiAutomaticStage = 99;
            } else {
            }
            break;
        case 99:
            //Do nothing
            break;
        default:
            //g_uiSemiAutomaticStage = 0;
            break;            
    }
}
#endif
uint8_t HJ_CurvSpeedNum = 0;
uint8_t HJ_FrontOtherKeyCurrent = 0;
uint16_t HJ_CureSpeedNum = 0;
uint8_t HJ_CurFuelNum = 0;
uint8_t HJ_SettingNum = 0;
uint8_t HJ_SetTimeSucFlag = 0;
uint8_t HJ_SetTimeStep_0 = 0;
uint8_t HJ_SetTimeStep_1 = 0;
uint8_t HJ_SetTimeStep_2 = 0;
uint8_t HJ_SetTimeStep_3 = 0;
uint8_t HJ_SetTimeFinish = 0;
void ClearOtherFlagFun()
{
    HJ_CurvSpeedNum = 0;
    HJ_FrontOtherKeyCurrent = 0;
    //HJ_CureSpeedNum = 0;
    //HJ_CurFuelNum = 0;
    HJ_SetTimeSucFlag = 0;
    HJ_SetTimeStep_0 = 0;
    HJ_SetTimeStep_1 = 0;
    HJ_SetTimeStep_2 = 0;
    HJ_SetTimeStep_3 = 0;
    HJ_SetTimeFinish = 0;
}
uint8_t Othercount = 0;
uint16_t OthercountTime = 0;
uint8_t FortOthercount = 0;
uint8_t laohuaflag = 0;
uint16_t laohuatime = 0;
void laohuafun()
{
    if(laohuaflag == 0) {
        laohuaflag = 1;
        switch(HJ_OtherKeyCurrent.count)
        {
            case 1:
            laohuatime = 5000;
            break;
            case 2:
            laohuatime = 10000;
            break;
            case 3:
            laohuatime = 15000;
            break;
            case 4:
            laohuatime = 18000;
            break;
            case 5:
            laohuatime = 5000;
            break;
            case 6:
            laohuatime = 5000;
            break;
        }
        if(HJ_OtherKeyCurrent.count > 6) {
            laohuatime = 500;
        }
        //laohuatime = 15000;
        Othercount = 0;
        
    }
    if(laohuatime == 0){
        HJ_OtherKeyCurrent.count ++;
        if(HJ_OtherKeyCurrent.count > 12) {
            HJ_OtherKeyCurrent.count = 1;
        }
        laohuaflag = 0;

    }
    
}
void HJ_SwitchSecondPage()
{
    g_Stage = STAGE_Other;
    
    //VSPEED
         if(HJ_OtherKeyCurrent.count <= 10) {
        HJ_CurvSpeedNum = ((((HJ_OtherKeyCurrent.count - 1) * 20 )*100)/105) + 1;
        if(HJ_CurvSpeedNum < 25)
            HJ_CurvSpeedNum-=1;
        
    } else {
        HJ_CurvSpeedNum = 199;
    }

    //Gear
    if(HJ_OtherKeyCurrent.count <= 7) {
         HJ_SettingNum = (HJ_OtherKeyCurrent.count-1);}
         else if(HJ_OtherKeyCurrent.count == 8 ) {
           HJ_SettingNum = 0;
          } else{
            HJ_SettingNum = 15 - HJ_OtherKeyCurrent.count;
         } 

    //ESPEED
    if(HJ_OtherKeyCurrent.count <= 9) {
        HJ_CureSpeedNum = ((HJ_OtherKeyCurrent.count - 1) * 1000) ;
    } else if(HJ_OtherKeyCurrent.count == 10 ) {
        HJ_CureSpeedNum = 10000;
    } else if((HJ_OtherKeyCurrent.count == 11) ) {
        HJ_CureSpeedNum = 12000;
    }else {
        HJ_CureSpeedNum = 0;
    }
    HJ_VSpeed(HJ_CurvSpeedNum);
    HJ_ESpeed(HJ_CureSpeedNum * 4);
  // if(HJ_OtherKeyCurrent.count <= 7) {
  //     HJ_SetGear(PortGpioHigh, HJ_OtherKeyCurrent.count - 1);
  // } else {
        HJ_SetGear();
   // }
//    if(HJ_OtherKeyCurrent.count == 1) {
//        Speed_Output_Update(PWMCH_SPEED_OUT, 1500, 50);
//    }
    HJ_LED(PortGpioHigh);
   
    if(FortOthercount != Othercount)
    {
        OthercountTime = 200;
    }
    FortOthercount = Othercount;
    if(OthercountTime > 0) {
        Port_SetPortPinLevel(2, 27, PortGpioLow);
        Port_SetPortPinLevel(2, 12, PortGpioLow);
    }
    else if(OthercountTime == 0) {
        if(HJ_OtherKeyCurrent.count > 11) {
            Othercount = 2;
        }
        switch(Othercount)
        {
        case 0:
            //flue
            if(HJ_OtherKeyCurrent.count <= 8) {
                HJ_CurFuelNum = HJ_OtherKeyCurrent.count - 1;
            } else{
                HJ_CurFuelNum = 8 ;
            }
           HJ_FuelFun(HJ_CurFuelNum);
            
        break;
        case 1:
            //swpush
            if(HJ_OtherKeyCurrent.count == 2) {
                switch(HJ_SetTimeStep_1)
                {
                    case 0:
                    HJ_SWPush(HJ_SETMODE_LongPush_2S, 1, 1);
                    break;
                    case 1:
                    HJ_SWPush(HJ_MODE_ShortPush, 1, 1);
                    break; 
                    case 2:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 1);
                    break;
                    case 3:
                    HJ_SWPush(HJ_MODE_ShortPush, 1, 1);
                    break;
                    case 4:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 1);
                    break;
                    case 5:
                    HJ_SWPush(HJ_MODE_ShortPush, 1, 1);
                    break;
                    case 6:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 1);
                    break;
                    case 7:
                    HJ_SWPush(HJ_MODE_ShortPush, 1, 1);
                    break;
                    case 8:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 1);
                    break;
                    default:
                    Othercount ++;
                    break;
                }
            }else if(HJ_OtherKeyCurrent.count == 3) {
                switch(HJ_SetTimeStep_2)
                {
                    case 0:
                    HJ_SWPush(HJ_SETMODE_LongPush_2S, 1, 2);
                    break;
                    case 1:
                    HJ_SWPush(HJ_MODE_ShortPush, 23, 2);
                    break;
                    case 2:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 2);
                    break;
                    case 3:
                    HJ_SWPush(HJ_MODE_ShortPush, 22, 2);
                    break;
                    case 4:
                    HJ_SWPush(HJ_SET_LongPush, 1, 2);
                    break;
                    default:
                    Othercount ++;
                    break;
                }
            } else if(HJ_OtherKeyCurrent.count == 4) {
                switch(HJ_SetTimeStep_3)
                {
                    case 0:
                    HJ_SWPush(HJ_SETMODE_LongPush_2S, 1, 3);
                    break;
                    case 1:
                    HJ_SWPush(HJ_MODE_ShortPush, 24, 3);
                    break;
                    case 2:
                    HJ_SWPush(HJ_SET_ShortPush, 1, 3);
                    break;
                    case 3:
                    HJ_SWPush(HJ_MODE_ShortPush, 59, 3);
                    break;
                    case 4:
                    HJ_SWPush(HJ_SET_LongPush, 1, 3);
                    break;
                    default:
                    Othercount++;
                    break;
                }
            } else {
                Othercount ++;
            }
        break;
        case 2:
            if((HJ_OtherKeyCurrent.count >= 3)) {
                HJ_StartStopSystem(PortGpioHigh);
                if(HJ_OtherKeyCurrent.count <= 6) {
                    switch(HJ_SetTimeStep_0) 
                    {
                        case 0:
                        HJ_SWPush(HJ_MODE_LongPush, 0, 0);
                        break;
                        default:
                        Othercount ++;
                        break;
                    }
                } else {
                    Othercount ++;
                }
            } else {
                Othercount ++;
            } 
            //��ѹ
            HJ_VoltageNumLamp();
        break;    
        default:
        HJ_SetTimeStep_0 = 0;
         ClearOtherSWFlagFun();
         ClearOtherFlagFun();

        break;
        
        // HJ_SetLeftLed(PortGpioHigh);
        // HJ_SetRightLed(PortGpioHigh);
        // HJ_SetHightLed(PortGpioHigh);
        // //����
        // HJ_ECU_Warning_Lamp();
        //����ͣ
    

        }


    }
    
    
    
    



}
uint8_t Gear_SWCount = 1;
uint8_t SWCountConfig = 0;
void Stage_Manage()
{
    if(SWCountConfig == 0)
    {
        SWCountConfig = 1;
        OKKeyCurrent.count = 2;
        UPKeyCurrent.count = 3;
        DOWNKeyCurrent.count = 4;
    }
    

    if(Botton.S30.Statu == 1){ //KL30
        Botton.S30.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
    UserPressKey30();
#else
        UserPressKey30();//KL30����
#endif
    }
    
    if(Botton.S15.Statu == 1){  // 15  
        Botton.S15.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
        UserPressKey15();//KL15����
#else
        UserPressKey15();//KL15����
#endif
    }

    if(Botton.Auto.Statu == 1){  // �Լ�
        Botton.Auto.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressAuto();//�Լ찴��
#endif
    }
    
    if(Botton.EOL.Statu == 1){  //EOL�����������
        Botton.EOL.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        // UserPressEOL();//��������
        
        g_Stage = STAGE_Other;
        if (HJ_OtherKeyCurrent.count == 0) {
            HJ_OtherKeyCurrent.count = 11;
        } else {
            HJ_OtherKeyCurrent.count --;
        }
        ClearOtherSWFlagFun();
        ClearOtherFlagFun();
        Othercount = 0;
#endif
    }   

    if(Botton.SpeedUp.Statu == 1){  // SPEED UP
        Botton.SpeedUp.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
        if (g_PerFuncExecSecond == 0)
        ExecSemiAutomaticCheck(0);
#else
        UserPressKeySpeedUp();//����+����
#endif
    }
    
    if(Botton.SpeedDown.Statu == 1){ // SPEED DOWN
        Botton.SpeedDown.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
        if (g_PerFuncExecSecond == 0)
        ExecSemiAutomaticCheck(0);
#else
        UserPressKeySpeedDown();//����-����
#endif
    }

    if(Botton.LED.Statu == 1){   //LED������Ӳ��
        Botton.LED.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressWarning();//��������
#endif
    }

    if(Botton.FuelWaterUp.Statu == 1){ 
        Botton.FuelWaterUp.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyOilTempUp();//ȼ�͡�ˮ��+����
        Gear_SWCount ++;
        if(Gear_SWCount > 5)
        {
            Gear_SWCount = 1;
        }
#endif
    }  
    
    if(Botton.FuelWaterDown.Statu == 1){
        Botton.FuelWaterDown.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyOilTempDown();//ȼ�͡�ˮ��-����
#endif
    }  
    
    if(Botton.TFTUp.Statu == 1){
        Botton.TFTUp.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyTftUp();//TFT +����
        OKKeyCurrent.count ++;
        
        
        
#endif
    }  

    if(Botton.TFTDown.Statu == 1){
        Botton.TFTDown.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyTftDown();//TFT -����
        UPKeyCurrent.count ++;
#endif
    } 
    
    if(Botton.Back_light.Statu == 1){ //����
        Botton.Back_light.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyBackLight();
#endif
    }  

    if(Botton.Luminosity.Statu == 1){ //����
        Botton.Luminosity.Statu = 0;
        UserPressKeyLuminosity();
    }

    if(Botton.Menu.Statu == 1){ // �˵�
        Botton.Menu.Statu = 0;
        g_Stage = STAGE_LCDCheck;
        g_CurPressOKKey = 0;
        g_CurPressDownKey = 0;
        g_CurPressUpKey = 0;
        g_CurPressMenuKey = 1;
        LCDCurrent.count = 0;
        SetCurrentStep(0);
        InitPressKeySimulation(); 
    }

    if(Botton.Up.Statu == 1){ //��
        Botton.Up.Statu = 0;
        g_Stage = STAGE_LCDCheck;
        g_CurPressOKKey = 0;
        g_CurPressDownKey = 0;
        g_CurPressUpKey = 1;
        g_CurPressMenuKey = 0;
        SetCurrentStep(0);
        InitPressKeySimulation(); 
    }

    if(Botton.Down.Statu == 1){ //��
        Botton.Down.Statu = 0;
        g_Stage = STAGE_LCDCheck;
        g_CurPressOKKey = 0;
        g_CurPressDownKey = 1;
        g_CurPressUpKey = 0;
        g_CurPressMenuKey = 0;
        SetCurrentStep(0);
        InitPressKeySimulation(); 
    }
    if(Botton.EOLClear.Statu == 1){ //EOL����ȫ0
        Botton.EOLClear.Statu = 0;
        SetEOL4(1);
    }

    if(Botton.OK.Statu == 1){ //OK
        Botton.OK.Statu = 0;
        g_Stage = STAGE_LCDCheck;
        g_CurPressOKKey = 1;
        g_CurPressDownKey = 0;
        g_CurPressUpKey = 0;
        g_CurPressMenuKey = 0;
        SetCurrentStep(0);
        InitPressKeySimulation(); 
    }
    
    if(Botton.Other.Statu == 1){
        Botton.Other.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        //UserPressKeyElse();//��������
        // DOWNKeyCurrent.count ++;
        g_Stage = STAGE_Other;
        HJ_OtherKeyCurrent.count ++;
        ClearOtherSWFlagFun();
        ClearOtherFlagFun();
        Othercount = 0;
        if(HJ_OtherKeyCurrent.count > 11) {
            HJ_OtherKeyCurrent.count = 1;
            
        }
#endif
    } 
    
    if(Botton.End.Statu == 1){
        Botton.End.Statu = 0;
#if (SEMI_AUTOMATIC_STAGE)
#else
        UserPressKeyEnd();//����  ��������
        LONGOKKeyCurrent.count ++;
#endif
    } 

    g_OldStage = g_Stage;
    
    if(g_Stage != STAGE_AutoCheck)
    {
        ErrorCode = 0;
        StaticCurrent.Finsh = 0; 
        SetStartTime(0);
    }
    if(g_Stage != STAGE_SetEOL){
        //LampState_M.Lamps.TripSW1_2 = 0;
    }

    if(g_Stage != STAGE_Led_Telltale_Check  && g_Stage != STAGE_Speed){
     //   Port_SetPortPinLevel(2, 0,  PortGpioLow);//AIRBAG
#if ((PRO_CN7C) || (PRO_QYC) || (PRO_BDC_PE) || (PRO_SQFL) || (PRO_DL3C))
        ACU14.msg.bits.CF_SWL_Ind = 0x1;
#endif
        Port_SetPortPinLevel(2, 3,  PortGpioLow);//��ȫ��
        Port_SetPortPinLevel(2, 20, PortGpioLow);//����ѹ��
        //Port_SetPortPinLevel(0, 0,  PortGpioLow);//���ر���
        Port_SetPortPinLevel(2, 1,  PortGpioLow);//WaterSeparator
#if (CAN_2ND)
        CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x4;          //ISG ��
        CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x1;         //ISG ��
#endif
#if (CAN_3RD)   
        EMS_01_10ms.ENG_IsgSta = 0x4;
        EMS_01_10ms.ENG_Isg2Sta = 0x1;
#endif
        SpeedCurrent.count = 0;
        LedCurrent.count = 0;
        LedCurrent.enable = 0;
        LedCurrent.Flag = 0;
        SpeedCurrent.enable = 0;
    } 
    else if(g_Stage == STAGE_Led_Telltale_Check)
    {
#if (CAN_2ND)
        CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x4;          //ISG ��
        CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x1;         //ISG ��
#endif
#if (CAN_3RD)   
        EMS_01_10ms.ENG_IsgSta = 0x4;
        EMS_01_10ms.ENG_Isg2Sta = 0x1;
#endif
    }
    
    if(g_Stage != STAGE_WaterAndFuel){       
        if(g_uiLowFuelLedCheckFlag == 0) {
#if (PRO_AI3)
            LampState_L.Lamps.RELAY_L4 = 0;//һ����˸ 
            LampState_L.Lamps.RELAY_F1 = 0;                  
            LampState_L.Lamps.RELAY_F2 = 0;
            LampState_L.Lamps.RELAY_F3 = 0;
            LampState_L.Lamps.RELAY_F4 = 1;//ȼ������
            LampState_L.Lamps.RELAY_L3 = 0;
            EMS_CNG11.msg.bits.CNG_FTL = 0xFF;
#else
         //   LampState_L.Lamps.RELAY_L4 = 0;//һ����˸ 
            // LampState_L.Lamps.RELAY_F1 = 0;                  
            // LampState_L.Lamps.RELAY_F2 = 0;
            // LampState_L.Lamps.RELAY_F3 = 0;
            // LampState_L.Lamps.RELAY_F4 = 1;//ȼ������
         //   LampState_L.Lamps.RELAY_L3 = 0;
#endif            
        }
        else if(g_uiLowFuelLedCheckFlag == 2) {
            //LampState_L.Lamps.RELAY_L4 = 0;//һ����˸ 
            LampState_L.Lamps.RELAY_F1 = 0;                  
            LampState_L.Lamps.RELAY_F2 = 0;
            LampState_L.Lamps.RELAY_F3 = 0;
            LampState_L.Lamps.RELAY_F4 = 1;//ȼ������
            //LampState_L.Lamps.RELAY_L3 = 0;
        }
        else {
           // LampState_L.Lamps.RELAY_L4 = 0;
            LampState_L.Lamps.RELAY_F1 = 0;   
            LampState_L.Lamps.RELAY_F2 = 0;
            LampState_L.Lamps.RELAY_F3 = 0;
            LampState_L.Lamps.RELAY_F4 = 0;//ȼ�Ϳյ�
          //  LampState_L.Lamps.RELAY_L3 = 0;
        }
        
        Iol_TempCurrent.count = 0;
        Iol_TempCurrent.statu = UNFINISH;
        LampState_M.Lamps.TripSW1_4 = 0;
    }
    
    if(g_Stage != STAGE_TFTCheck){
#if (PRO_CONFIG_CHECK_APPLY)
        TFTCurrent.count = 0;
        TFTCurrent.statu = 0;
#endif          
    }
    if(g_Stage != STAGE_LCDCheck  && g_Stage != STAGE_Led_Telltale_Check){
#if (PRO_CONFIG_CHECK_APPLY)
        if (g_BackLightSetFlag > 0) {
            if (g_BackLightSetFlag - 1 >= 0)
                g_BackLightSetFlag--;
            Send_7C6_Data.msg.bits.Byte0Data = 0x02;
            Send_7C6_Data.msg.bits.Byte1Data = 0x10;
            Send_7C6_Data.msg.bits.Byte2Data = 0x01;
            CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3); 
        }
#endif          
    }    
    if(g_Stage != STAGE_Other){
        //ElseCurrent.count = 0;
        ElseCurrent.enable = 0;
        ElseCurrent.statu = 0;
        ElseCurrent.Flag = 0;
        ElseCurrent.Finsh = 0;
        Port_SetPortPinLevel(2, 19, 0); // �����������ִ� 
        //Port_SetPortPinLevel(2, 21, 0); //BREAK OIL
       // Port_SetPortPinLevel(2, 14, 0 ); // ����
        Port_SetPortPinLevel(2, 29, 0); // ����ʻ��ȫ��
        //Port_SetPortPinLevel(2, 28, 0);
       // Port_SetPortPinLevel(0, 0, 0);//���ر���
    }
#if (PRO_CONFIG_EOL_APPLY)
    switch(g_Stage)
    {
        case STAGE_TFTCheck://TFT
            break;
        case STAGE_SetEOL: //eol
            APP_EOL();
            break;
        default:
            break;
    }
#endif

#if (PRO_CONFIG_CHECK_APPLY)
#if (SEMI_AUTOMATIC_STAGE)
    ExecSemiAutomaticCheck(1);
#endif  
    switch(g_Stage)
    {
        case 0:
            ProjectDynamicConfig();//��Ŀ��̬��������ȼ�͡�BVM��DMS�� 
#if (PRO_JAPE2)
        	if ((g_uiCuntDownFlag == 1)&&(TftTimer == 0)){
            	can();
            }
#endif
			 break;
        case STAGE_AutoCheck:       //�Լ�
            APP_AUTO();
            //APP_CAN_Output_Show();
            break;
            
        case STAGE_Led_Telltale_Check: //������
            //PressKey(TripKeyCurrent.count,KEY_SW1_MENU,TRIPSW_SHORT_PRESS);
            APP_LED_OUTPUT();
            
            break;
            
       case STAGE_Speed: //���� Ƶ�� ռ�ձ�
            InitLedDsp();
            APP_SPEED_OUTPUT();
            break;
            
        case STAGE_WaterAndFuel:     //ȼ�͡�ˮ��
            APP_OIL_TEMP();
            break;    
        case STAGE_OilDown:
            APP_OIL_Down();
            break;
        case STAGE_TFTCheck:         //TFT+ TFT- ����ɨ��
            APP_TFT_OUTPUT();
            break;  
            
        case STAGE_Other:            //����
            //APP_ELSE();
            //laohuafun();
            HJ_SwitchSecondPage();
            break;  
            
        case STAGE_ClearODO:         //END ����
            APP_END();
            break;
        case STAGE_SetEOL:          //���� ����EOL
            APP_EOL();
            break;

        case STAGE_LCDCheck:        //LCD ������� 
            APP_LCD_OUTPUT();
            break; 

        default:
            break;            
    }  
#endif    
}

