/******************************************************************************
*****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c) 2014-2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ("Software"), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ("Cypress") and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ("EULA").
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress's
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ("High Risk Product"). By
* including Cypress's product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
** \file hsspi_flash_setting.h
**
** HSSPI Flash setting code.
**
*****************************************************************************/

#ifndef __BSP_DDRHSSPI_H__
#define __BSP_DDRHSSPI_H__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "mcu_settings.h"
#include "abstract.h"

#define     WPREG_PPC(n,d)                          \
{                                                   \
un_ppc_keycdr_t wk;                             \
unsigned long adr = (unsigned long)&n;          \
unsigned char size_key;                         \
wk.au16Halfword[0] = adr & 0x7FFF;              \
size_key = (sizeof(n) >> 1) << 4;               \
wk.au8Byte[3] = size_key | (0 << 6);            \
PPC_KEYCDR = wk.u32Register;                    \
wk.au8Byte[3] = size_key | (1 << 6);            \
PPC_KEYCDR = wk.u32Register;                    \
wk.au8Byte[3] = size_key | (2 << 6);            \
PPC_KEYCDR = wk.u32Register;                    \
wk.au8Byte[3] = size_key | (3 << 6);            \
PPC_KEYCDR = wk.u32Register;                    \
n = d;                                          \
}
#define GIGADEVICE_256M_MANUFACTURER_ID     0xC8
#define GIGADEVICE_256M_DEVICE_ID           0x18
#define GIGADEVICE_64M_MANUFACTURER_ID      0xC8
#define GIGADEVICE_64M_DEVICE_ID            0x16
#define ISSI_256M_MANUFACTURER_ID           0x9D
#define ISSI_256M_DEVICE_ID                 0x18
#define ISSI_512M_MANUFACTURER_ID           0x9D
#define ISSI_512M_DEVICE_ID                 0x19
#define WINBOND_256M_MANUFACTURER_ID        0xEF
#define WINBOND_256M_DEVICE_ID              0x18
#define WINBOND_128M_MANUFACTURER_ID        0xEF
#define WINBOND_128M_DEVICE_ID              0x17
#define WINBOND_64M_DEVICE_ID               0x16

#define GIGADEVICE_256M                     0
#define ISSI_256M                           1
#define ISSI_512M                           1
#define WINBOND_256M                        2
#define GIGADEVICE_64M                      3
#define WINBOND_128M		            	4
#define WINBOND_64M		            		5
#define WINBOND_Q256M                       6
#define WINBOND_Q256M_DTR					7

#define WINBOND_H256M_MEMORY_CAPACITY_ID    			0x9019
#define WINBOND_Q256M_NONDTR_SPI_MEMORY_CAPACITY_ID   	0x4019
#define WINBOND_Q256M_NONDTR_QPI_MEMORY_CAPACITY_ID   	0x6019
#define WINBOND_Q256M_DTR_MEMORY_CAPACITY_ID    		0x7019

extern uint32_t ManufacturerID;
extern uint32_t DeviceID;
extern uint8_t FlashType;

/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/
extern  int hsspi_SetSingleQuad_GigeDevice(void);
extern  int hsspi_SetSingleQuad_GigeDevice_64M(void);
extern  int hsspi_SetDualQuad(void);
extern  void DualQuad_MCU_SDR_Write(uint32_t *startAddr, uint32_t size, uint32_t destinationOffsetAddr);
extern  void Flsh_Rst(void);
extern  void Dual_Sctr_Ers(unsigned long topAddress);
extern  void HSSPI_port_GFX(void);
extern  void BSP_QSPI_Init(void);
extern int hsspi_SetSingleQuad_ISSI(void);
extern int hsspi_SetSingleQuad_WINBOND(void);
extern int hsspi_SetSingleQuad_WINBOND_128M(void);
extern int hsspi_SetSingleQuad_WINBOND_25Q_DTR(void);
extern uint8_t hsspi_SetSingleQuad(void);
/*****************************************************************************/
    /* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/
    #define HSSPI_PASS         (0)
    #define HSSPI_ERROR        (1)

extern uint8_t QSPI_Init; /*qitiancun λ */
extern uint16_t QSPI_InitTime; /*qitiancun ?a??????a */

#endif /* __HSSPI_FLASH_SETTING_H__ */

