/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file rtc.h
 **
 ** Headerfile for Real time clock functions.
 **
 ** History:
 **   - 2014-05-16  0.01  HS  Initial version for Traveo
 *****************************************************************************/
#ifndef __BSP_RTC_H__
#define __BSP_RTC_H__
   
extern uint32_t u32Count;
// Buffer for RTC access
extern uint8_t m_u8Hours;
extern uint8_t m_u8Minutes;
extern uint8_t m_u8Seconds;
/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"

/*
?* Similar to the struct tm in userspace <time.h>, but it needs to be here so
?* that the kernel source is self contained.
?*/
typedef struct
{
    /*
? ? ?* the number of seconds after the minute, normally in the range
? ? ?* 0 to 59, but can be up to 60 to allow for leap seconds
? ? ?*/
    int tm_sec;
    /* the number of minutes after the hour, in the range 0 to 59*/
    int tm_min;
    /* the number of hours past midnight, in the range 0 to 23 */
    int tm_hour;
    /* the day of the month, in the range 1 to 31 */
    int tm_mday;
    /* the number of months since January, in the range 1 to 12 */
    int tm_mon;
    /* the number of years since 1900 */
    long tm_year;
    /* the number of days since Sunday, in the range 0 to 6 */
    int tm_wday;
    /* the number of days since January 1, in the range 0 to 365 */
    int tm_yday;
    int A[10];
}_TimeInfo;

/**
 *****************************************************************************
 ** \defgroup RtcGroup Real time clock (RTC)
 **
 ** \brief This section describes the interface for the RTC.
 **
 ** Provided functions of RTC module:
 **
 ** - Rtc_Init()
 ** - Rtc_Start()
 ** - Rtc_Stop()
 **
 ** Rtc_Init() is used to initialize RTC with parameter pstcConfig of type #stc_rtc_config_t.
 ** This function can be used only once after a reset.
 **
 *****************************************************************************/
/*! @{ */


/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/

/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/
typedef enum en_rtc_clock_selection
{
    RtcMainClock      = 0, /*!< Main clock (CLK_MAIN/2) used as CLKRTC */
    RtcSubClock       = 1, /*!< Sub clock (CLK_SUB/2) used as CLKRTC */
    RtcRcClock        = 2, /*!< Slow RC clock (CLK_SRC/2) used as CLKRTC */
} en_rtc_clock_selection_t;

typedef struct stc_rtc_intern_data
{
    func_ptr_t pfnCallback;      // Callback for RTC interrupt
} stc_rtc_intern_data_t;

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
extern void Rtc_Callback(void);
extern void Rtc_Stop(void);
extern void bsp_RTC_GetTime(uint8_t* pu8Hours, uint8_t* pu8Minutes, uint8_t* pu8Seconds);
extern void bsp_RTC_Service_GetTime(uint16_t* pu16Days,uint8_t* pu8Hours, uint8_t* pu8Minutes);
extern void bsp_RTC_CalTime(void);
extern void BSP_RTC_Init(void);
extern void RTC_Service_SetTime(void);
extern void RTC_Service_GetTime(void);
extern __irq __arm void  bsp_RtcMode_Isr(void);


#endif /* __RTC_H__ */
