/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file mfs_csio_generated.c
 **
 ** Generated file for csio.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in csio.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by csio.c automatically!
 **
 ** History:
 **   - 2014-12-18  0.01  HSh  Initial version for Traveo
 *****************************************************************************/

#ifndef __MFS_CSIO_GENERATED_C__
#define __MFS_CSIO_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** Macro to return the number of enabled CSIO instances */
#define CSIO_INSTANCE_COUNT (uint32_t)(sizeof(m_astcCsioInstanceDataLut) / sizeof(m_astcCsioInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/// Enumeration to define an index for each enabled CSIO instance
typedef enum en_csio_instance_index
{
    #if (PDL_PERIPHERAL_ENABLE_CSIO0 == PDL_ON)
    CsioInstanceIndexCsio0,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO1 == PDL_ON)
    CsioInstanceIndexCsio1,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO2 == PDL_ON)
    CsioInstanceIndexCsio2,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO3 == PDL_ON)
    CsioInstanceIndexCsio3,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO4 == PDL_ON)
    CsioInstanceIndexCsio4,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO5 == PDL_ON)
    CsioInstanceIndexCsio5,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO6 == PDL_ON)
    CsioInstanceIndexCsio6,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO7 == PDL_ON)
    CsioInstanceIndexCsio7,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO8 == PDL_ON)
    CsioInstanceIndexCsio8,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO9 == PDL_ON)
    CsioInstanceIndexCsio9,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO10 == PDL_ON)
    CsioInstanceIndexCsio10,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO11 == PDL_ON)
    CsioInstanceIndexCsio11,
    #endif
    CsioInstanceIndexMax
} en_csio_instance_index_t;
    
/** CSIO instance data type */
typedef struct stc_csio_instance_data
{
    volatile stc_cpg_mfsn_csio_t* pstcInstance;         /*!< pointer to registers of an instance */
    stc_csio_intern_data_t stcInternData;               /*!< module internal data of instance */
} stc_csio_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/** Look-up table for all enabled CSIO instances and their internal data */
static stc_csio_instance_data_t m_astcCsioInstanceDataLut[CsioInstanceIndexMax] =
{
    #if (PDL_PERIPHERAL_ENABLE_CSIO0 == PDL_ON)
    {
         &CPG_MFS00_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO1 == PDL_ON)
    {
         &CPG_MFS01_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO2 == PDL_ON)
    {
         &CPG_MFS02_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO3 == PDL_ON)
    {
         &CPG_MFS03_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO4 == PDL_ON)
    {
         &CPG_MFS04_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO5 == PDL_ON)
    {
         &CPG_MFS05_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO6 == PDL_ON)
    {
         &CPG_MFS06_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO7 == PDL_ON)
    {
         &CPG_MFS07_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO8 == PDL_ON)
    {
         &CPG_MFS08_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO9 == PDL_ON)
    {
         &CPG_MFS09_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO10 == PDL_ON)
    {
         &CPG_MFS10_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_CSIO11 == PDL_ON)
    {
         &CPG_MFS11_CSIO,   /* pstcInstance */
         {NULL}             /* stc_csio_intern_data_t */
    },
    #endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain CSIO instance.
 **
 ** \param pstcCsio Pointer to CSIO instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
static stc_csio_intern_data_t* CsioGetInternDataPtr(volatile stc_cpg_mfsn_csio_t* pstcCsio)
{
    stc_csio_intern_data_t *pstcInternData = NULL;
    uint32_t                u32Instance;

    if (pstcCsio != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)CsioInstanceIndexMax; u32Instance++)
        {
            if (pstcCsio == m_astcCsioInstanceDataLut[u32Instance].pstcInstance)
            {
                pstcInternData = &m_astcCsioInstanceDataLut[u32Instance].stcInternData;
                break;
            }
        }
    }

    return pstcInternData;
}

/*
 * Definition of ISR for each enabled MFS_CSIO instance.
 * The individual ISR calls the generic IRQ handler with
 * the instance pointer and its internal data to handle the interrupt.
 */
#if (PDL_PERIPHERAL_ENABLE_CSIO0== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio0_Rx, INTERRUPTS_IRQ_NUMBER_46)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS00_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio0].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio0_Tx, INTERRUPTS_IRQ_NUMBER_47)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS00_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio0].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio0_Error, INTERRUPTS_IRQ_NUMBER_222)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS00_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio0].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO1== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio1_Rx, INTERRUPTS_IRQ_NUMBER_48)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS01_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio1].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio1_Tx, INTERRUPTS_IRQ_NUMBER_49)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS01_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio1].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio1_Error, INTERRUPTS_IRQ_NUMBER_223)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS01_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio1].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_CSIO2== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio2_Rx, INTERRUPTS_IRQ_NUMBER_50)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS02_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio2].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio2_Tx, INTERRUPTS_IRQ_NUMBER_51)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS02_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio2].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio2_Error, INTERRUPTS_IRQ_NUMBER_224)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS02_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio2].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO3== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio3_Rx, INTERRUPTS_IRQ_NUMBER_52)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS03_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio3].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio3_Tx, INTERRUPTS_IRQ_NUMBER_53)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS03_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio3].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio3_Error, INTERRUPTS_IRQ_NUMBER_225)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS03_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio3].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO4== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio4_Rx, INTERRUPTS_IRQ_NUMBER_54)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS04_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio4].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio4_Tx, INTERRUPTS_IRQ_NUMBER_55)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS04_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio4].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio4_Error, INTERRUPTS_IRQ_NUMBER_226)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS04_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio4].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO5== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio5_Rx, INTERRUPTS_IRQ_NUMBER_56)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS05_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio5].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio5_Tx, INTERRUPTS_IRQ_NUMBER_57)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS05_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio5].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio5_Error, INTERRUPTS_IRQ_NUMBER_227)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS05_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio5].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO6== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio6_Rx, INTERRUPTS_IRQ_NUMBER_58)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS06_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio6].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio6_Tx, INTERRUPTS_IRQ_NUMBER_59)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS06_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio6].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio6_Error, INTERRUPTS_IRQ_NUMBER_228)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS06_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio6].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif

       
#if (PDL_PERIPHERAL_ENABLE_CSIO7== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio7_Rx, INTERRUPTS_IRQ_NUMBER_60)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS07_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio7].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio7_Tx, INTERRUPTS_IRQ_NUMBER_61)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS07_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio7].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio7_Error, INTERRUPTS_IRQ_NUMBER_229)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS07_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio7].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_CSIO8== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio8_Rx, INTERRUPTS_IRQ_NUMBER_62)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS08_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio8].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio8_Tx, INTERRUPTS_IRQ_NUMBER_63)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS08_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio8].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio8_Error, INTERRUPTS_IRQ_NUMBER_230)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS08_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio8].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_CSIO9== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio9_Rx, INTERRUPTS_IRQ_NUMBER_64)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS09_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio9].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio9_Tx, INTERRUPTS_IRQ_NUMBER_65)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS09_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio9].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio9_Error, INTERRUPTS_IRQ_NUMBER_231)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS09_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio9].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO10== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio10_Rx, INTERRUPTS_IRQ_NUMBER_66)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS10_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio10].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio10_Tx, INTERRUPTS_IRQ_NUMBER_67)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS10_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio10].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio10_Error, INTERRUPTS_IRQ_NUMBER_232)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS10_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio10].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
#if (PDL_PERIPHERAL_ENABLE_CSIO11== PDL_ON)
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio11_Rx, INTERRUPTS_IRQ_NUMBER_68)
     {
         MfsCsioIrqHandlerRx(&CPG_MFS11_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio11].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio11_Tx, INTERRUPTS_IRQ_NUMBER_69)
     {
         MfsCsioIrqHandlerTx(&CPG_MFS11_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio11].stcInternData));
     }
     FN_IRQ_DEFINE_END()
     FN_IRQ_DEFINE_BEGIN(Csio_Isr_Csio11_Error, INTERRUPTS_IRQ_NUMBER_233)
     {
         MfsCsioIrqHandlerStatus(&CPG_MFS11_CSIO, &(m_astcCsioInstanceDataLut[CsioInstanceIndexCsio11].stcInternData));
     }
     FN_IRQ_DEFINE_END()
#endif
       
       
#endif  // __MFS_CSIO_GENERATED_C__

