/*===========================================================================*/
/* Project:  F1x StarterKit V3 Sample Software                               */
/* Module :  r_clkc.c                                                        */
/* Version:  V1.00                                                           */
/*===========================================================================*/
/*                                  COPYRIGHT                                */
/*===========================================================================*/
/* Copyright (c) 2016 by Renesas Electronics Europe GmbH,                    */
/*               a company of the Renesas Electronics Corporation            */
/*===========================================================================*/
/* In case of any question please do not hesitate to contact:                */
/*                                                                           */
/*        ABG Software Tool Support                                          */
/*                                                                           */
/*        Renesas Electronics Europe GmbH                                    */
/*        Arcadiastrasse 10                                                  */
/*        D-40472 Duesseldorf, Germany                                       */
/*                                                                           */
/*        e-mail: software_support-eu@lm.renesas.com                         */
/*        FAX:   +49 - (0)211 / 65 03 - 11 31                                */
/*                                                                           */
/*===========================================================================*/
/* Warranty Disclaimer                                                       */
/*                                                                           */
/* Because the Product(s) is licensed free of charge, there is no warranty   */
/* of any kind whatsoever and expressly disclaimed and excluded by Renesas,  */
/* either expressed or implied, including but not limited to those for       */
/* non-infringement of intellectual property, merchantability and/or         */
/* fitness for the particular purpose.                                       */
/* Renesas shall not have any obligation to maintain, service or provide bug */
/* fixes for the supplied Product(s) and/or the Application.                 */
/*                                                                           */
/* Each User is solely responsible for determining the appropriateness of    */
/* using the Product(s) and assumes all risks associated with its exercise   */
/* of rights under this Agreement, including, but not limited to the risks   */
/* and costs of program errors, compliance with applicable laws, damage to   */
/* or loss of data, programs or equipment, and unavailability or             */
/* interruption of operations.                                               */
/*                                                                           */
/* Limitation of Liability                                                   */
/*                                                                           */
/* In no event shall Renesas be liable to the User for any incidental,       */
/* consequential, indirect, or punitive damage (including but not limited    */
/* to lost profits) regardless of whether such liability is based on breach  */
/* of contract, tort, strict liability, breach of warranties, failure of     */
/* essential purpose or otherwise and even if advised of the possibility of  */
/* such damages. Renesas shall not be liable for any services or products    */
/* provided by third party vendors, developers or consultants identified or  */
/* referred to the User by Renesas in connection with the Product(s) and/or  */
/* the Application.                                                          */
/*                                                                           */
/*===========================================================================*/
/* History:                                                                  */
/*              V1.00: Initial version                                       */
/*                                                                           */
/*===========================================================================*/
/*                                                                           */
/* Source code for the clock controller configurations.                      */
/*                                                                           */
/*===========================================================================*/


/*===========================================================================*/
/* Includes */
/*===========================================================================*/
#include "r_device.h"
#include "r_clkc.h"
#include "dr7f701684.dvf.h"
//#include "iodefine.h"
#define _WRITE_PROTECT_COMMAND              (0x000000A5UL)  /* Write protected */

/*===========================================================================*/
/* Functions */
/*===========================================================================*/
/*****************************************************************************
** Function:    R_CLKC_PllInit
** Description: This function generates 120MHz CPU CLK and 80MHz PeripheralPLL CLK.
** Parameter:   None
** Return:      None
******************************************************************************/
uint16_t t =0;
void R_CLKC_PllInit(void)
{ 
    CLKCTL.MOSCM = _CGC_MAINOSC_OSC_MODE;
    CLKCTL.MOSCC = _CGC_MOSCC_DEFAULT_VALUE | _CGC_MAINOSC_8MHZ;
    CLKCTL.MOSCST = _CGC_MAINOSC_STABILIZE_TIME;
    CLKCTL.MOSCSTPM = _CGC_MOSCSTPM_DEFAULT_VALUE  | _CGC_MAINOSC_REQUEST_STOP;
    WPROTR.PROTCMD0 = _WRITE_PROTECT_COMMAND;
    CLKCTL.MOSCE = _CGC_MAINOSC_START;
    CLKCTL.MOSCE = (uint32_t) ~_CGC_MAINOSC_START;
    CLKCTL.MOSCE = _CGC_MAINOSC_START;
    while ((CLKCTL.MOSCS & _CGC_MAINOSC_ACTIVE) != _CGC_MAINOSC_ACTIVE)
    {
    t++;
    }
    /* HS IntOSC setting */
    CLKCTL.ROSCSTPM = _CGC_ROSCSTPM_DEFAULT_VALUE | _CGC_HSOSC_REQUEST_STOP;
    /* PLL setting */
    WPROTR.PROTCMD1 = _WRITE_PROTECT_COMMAND;
    CLKCTL.CKSC_PLL1IS_CTL = _CGC_PLL1_SOURCE_MAINOSC;
    CLKCTL.CKSC_PLL1IS_CTL = (uint32_t) ~_CGC_PLL1_SOURCE_MAINOSC;
    CLKCTL.CKSC_PLL1IS_CTL = _CGC_PLL1_SOURCE_MAINOSC;
    while ((CLKCTL.CKSC_PLL1IS_ACT & _CGC_PLL1_SOURCE_ACTIVE) != _CGC_PLL1_SOURCE_MAINOSC)
    {
    
    t++;
    }
    CLKCTL.PLL1C = _CGC_PLL1C_DEFAULT_VALUE | _CGC_PLL1_DIVISION_RATIO;
    WPROTR.PROTCMD1 = _WRITE_PROTECT_COMMAND;
    CLKCTL.PLL1E = _CGC_PLL1_START;
    CLKCTL.PLL1E = (uint32_t) ~_CGC_PLL1_START;
    CLKCTL.PLL1E = _CGC_PLL1_START;
    while ((CLKCTL.PLL1S & _CGC_PLL1_ACTIVE) != _CGC_PLL1_ACTIVE)
    {
    
    t++;
    }
    /* PPLLCLK setting */
    WPROTR.PROTCMD1 = _WRITE_PROTECT_COMMAND;
    CLKCTL.CKSC_PPLLCLKS_CTL = _CGC_PPLLCLK_SOURCE_PPLLOUT;
    CLKCTL.CKSC_PPLLCLKS_CTL = (uint32_t) ~_CGC_PPLLCLK_SOURCE_PPLLOUT;
    CLKCTL.CKSC_PPLLCLKS_CTL = _CGC_PPLLCLK_SOURCE_PPLLOUT;
    while ((CLKCTL.CKSC_PPLLCLKS_ACT & _CGC_PPLLCLK_SOURCE_ACTIVE) != _CGC_PPLLCLK_SOURCE_PPLLOUT)
    {
    
    t++;
    }
    /* CPU clock setting */
    WPROTR.PROTCMD1 = _WRITE_PROTECT_COMMAND;
    CLKCTL.CKSC_CPUCLKS_CTL = _CGC_CPU_CLK_SOURCE_CPLL1OUT;
    CLKCTL.CKSC_CPUCLKS_CTL = (uint32_t) ~_CGC_CPU_CLK_SOURCE_CPLL1OUT;
    CLKCTL.CKSC_CPUCLKS_CTL = _CGC_CPU_CLK_SOURCE_CPLL1OUT;
    while (CLKCTL.CKSC_CPUCLKS_ACT != _CGC_CPU_CLK_SOURCE_CPLL1OUT)
    {
    
    t++;
    }
    WPROTR.PROTCMD1 = _WRITE_PROTECT_COMMAND;
    CLKCTL.CKSC_CPUCLKD_CTL = _CGC_CPLLOUT_DIVIDER_4 | _CGC_CPU_CLK_DIVIDER_1;
    CLKCTL.CKSC_CPUCLKD_CTL = (uint32_t) ~(_CGC_CPLLOUT_DIVIDER_4 | _CGC_CPU_CLK_DIVIDER_1);
    CLKCTL.CKSC_CPUCLKD_CTL = _CGC_CPLLOUT_DIVIDER_4 | _CGC_CPU_CLK_DIVIDER_1;
    while (CLKCTL.CKSC_CPUCLKD_ACT != (_CGC_CPLLOUT_DIVIDER_4 | _CGC_CPU_CLK_DIVIDER_1))
    {
    
    t++;
    }
}

/*****************************************************************************
** Function:    R_CLKC_SetRscanClockDomain
** Description: Select the RS-CAN Module Clock and the Communication Clock.
** Parameter:   RscanModuleClockDomain - Clock for operation of the CAN module itself.
**              RscanComClockDomain - Clock used for the communication speed setting.
** Return:      None
******************************************************************************/
void R_CLKC_SetRscanClockDomain(uint32_t RscanModuleClockDomain, uint32_t RscanComClockDomain)
{
  	/* Select RS-CAN Module Clock */
  	protected_write(WPROTR.PROTCMD1, WPROTR.PROTS1, CLKCTL.CKSC_ICANS_CTL, RscanModuleClockDomain);
  	while (CLKCTL.CKSC_ICANS_ACT != RscanModuleClockDomain);

  	/* Select RS-CAN Communication Clock */
  	protected_write(WPROTR.PROTCMD1, WPROTR.PROTS1, CLKCTL.CKSC_ICANOSCD_CTL, RscanComClockDomain);
  	while (CLKCTL.CKSC_ICANOSCD_CTL != RscanComClockDomain);
}

/*****************************************************************************
** Function:    R_CLKC_SetAdca0ClockDomain
** Description: Select the ADCA0 Clock domain.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_SetAdca0ClockDomain(uint32_t Adca0ClockDomain)
{
  	protected_write(WPROTR.PROTCMD0, WPROTR.PROTS0, CLKCTL.CKSC_AADCAS_CTL, Adca0ClockDomain);
  	while(CLKCTL.CKSC_AADCAS_ACT != Adca0ClockDomain);
}

/*****************************************************************************
** Function:    R_CLKC_SetTaujClockDomain
** Description: Select the TAUJ Clock domain.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_SetTaujClockDomain(uint32_t TaujClockDomain)
{
  	protected_write(WPROTR.PROTCMD0, WPROTR.PROTS0, CLKCTL.CKSC_ATAUJS_CTL, TaujClockDomain);
  	while(CLKCTL.CKSC_ATAUJS_CTL != TaujClockDomain);
}  

/*****************************************************************************
** Function:    R_CLKC_SetAdca0StopMask
** Description: Sets the stop-mask bit for the ADCA0 clock supply so it is not  
**              stopped in DeepSTOP.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_SetAdca0StopMask(void)
{
    CLKCTL.CKSC_AADCAD_STPM = R_CLKC_STOPMASK_SET;
}

/*****************************************************************************
** Function:    R_CLKC_ResetAdca0StopMask
** Description: Resets the stop-mask bit for the ADCA0 clock supply so it is  
**              stopped in DeepSTOP.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_ResetAdca0StopMask(void)
{
    CLKCTL.CKSC_AADCAD_STPM = R_CLKC_STOPMASK_RESET;
}

/*****************************************************************************
** Function:    R_CLKC_SetTaujStopMask
** Description: Sets the stop-mask bit for the TAUJ clock supply so it is not  
**              stopped in DeepSTOP.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_SetTaujStopMask(void)
{
    CLKCTL.CKSC_ATAUJD_STPM = R_CLKC_STOPMASK_SET;
}

/*****************************************************************************
** Function:    R_CLKC_ResetTaujStopMask
** Description: Resets the stop-mask bit for the TAUJ clock supply so it is  
**              stopped in DeepSTOP.
** Parameter:   None
** Return:      None
******************************************************************************/
void R_CLKC_ResetTaujStopMask(void)
{
    CLKCTL.CKSC_ATAUJD_STPM = R_CLKC_STOPMASK_RESET;
}
