/******************************************************************************
  UDS_ISO14229_Server.h
ISO 14229 淶涨Ϸ˺ͷļ
    ߣ
    V1.0
    ڣ2016.11.1
******************************************************************************/

/******************************************************************************
                         ϷOSIģӳ
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
  *      7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
  *      5      Session          ISO 14229-2
         4      Transport        ISO 15765-2
         3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/
#ifndef _UDS_ISO14229_SERVER_H_
#define _UDS_ISO14229_SERVER_H_
#include "DoCAN_ISO15765.h"
#include "TYW_stdint.h"
#include "UDS_ISO14229_Server_Config.h"


/******************************************************************************
ṹ
******************************************************************************/

/*** Ựݷͽö ***/
typedef enum
{
    S_OK = 0,
    S_NOK,
} S_Result_Enum;

/*---------------------------------------------------------------------------*/

/*** A_PCIṹ(Ǹ) ***/
typedef struct
{
    uint8_t SI;
} UDS_A_PCI_Struct;

/*** A_PCIṹ() ***/
typedef struct
{
    uint8_t NR_SI;
    uint8_t SI;
} UDS_NEG_A_PCI_Struct;

/*** Ӧòݽṹ ***/
typedef struct
{
    uint32_t                TA_type;
    uint8_t                 A_Data[A_DATA_RX_BUFFER_SIZE];
    uint16_t                Length;   /*Чݳ(A_PCI)*/
    uint8_t                 New;      /*յ*/
} UDS_RX_App_Data_Struct;

/*** ӦòA_PDUṹ ***/
typedef struct
{
    uint32_t                TA_type;
    UDS_A_PCI_Struct        A_PCI;
    uint8_t                 Data[A_DATA_RX_BUFFER_SIZE - (uint8_t)1];
    uint16_t                Length;   /*Чݳ(A_PCI)*/
    uint8_t                 New;      /*յ*/
} UDS_RX_A_PDU_Struct;

/*** Ӧò㷢ݽṹ ***/
typedef struct
{
    uint32_t                TA_type;
    uint8_t                 A_Data[A_DATA_TX_BUFFER_SIZE];
    uint16_t                Length;   /*Чݳ(A_PCI)*/
} UDS_TX_App_Data_Struct;

/*** Ӧò㷢A_PDUṹ ***/
typedef struct
{
    uint32_t                TA_type;
    UDS_A_PCI_Struct        A_PCI;
    uint8_t                 Data[A_DATA_TX_BUFFER_SIZE - (uint8_t)1];
    uint16_t                Length;   /*Чݳ(A_PCI)*/
} UDS_TX_A_PDU_Struct;

/*** Ӧòݽ ***/
typedef union
{
    UDS_RX_App_Data_Struct  Data;
    UDS_RX_A_PDU_Struct     A_PDU;
} UDS_APP_RX_Union;

/*** Ӧò㷢ݽ ***/
typedef union
{
    UDS_TX_App_Data_Struct  Data;
    UDS_TX_A_PDU_Struct     A_PDU;
} UDS_APP_TX_Union;

/******************************************************************************

******************************************************************************/

/*-- ⲿӿں -----------------------------------------------------------*/

/*** ̨ ***/
void UDS_Server_Application_Service ( void );

/*** /²ӿں ***/
void UDS_N_USData_Request ( uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length );
extern void UDS_N_USData_Confirm (uint32_t N_TAtype, N_ResultEnum N_Result);
extern void UDS_N_USData_FF_Indication(uint32_t N_TAtype, uint16_t Length);
extern void UDS_N_USData_Indication(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result);

/*-- ڲ ---------------------------------------------------------------*/

/*** Ựݽӿں ***/
void UDS_S_Data_Request ( uint32_t S_TAtype, uint8_t *S_Data, uint16_t S_Length );
void UDS_S_Data_Confirm ( uint32_t S_TAtype, S_Result_Enum S_Result );
void UDS_S_Data_Indication ( uint32_t S_TAtype, uint8_t S_Data[], uint16_t S_Length, S_Result_Enum S_Result );

/*** Ựʱƺ ***/

/*** Ӧòƺ ***/
void UDS_Process_Service_Request ( void );
void UDS_Service_Response ( uint8_t si, uint8_t RspType, uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[] );

#endif
