/******************************************************************************
 * $Revision: 425 $
 * $Date:: 2017-05-19 10:28:09 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file interrupts.c
 **
 ** Definition of Interrupt Controller initialization and service functions.
 ** The assignment of interrupt (IRQ) and non-maskable interrupt (NMI)
 ** vectors and priority levels must be done in interrupts.h.
 **
 ** History:
 **   - 2015-09-01  0.01  HS  Initial version for Traveo
 *****************************************************************************/

// File version 0xYYXX = vYY.XX
#define INTERRUPTS_C_VERSION          0x0001

#ifndef __FILE_VERSION_CHECK__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "interrupts.h"
#include "abstract.h"
#include "mcu_settings.h"

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** IRQ: IRQ channel count */
#define IRQ_CHANNEL_COUNT                               256
/** IRQ: lowest priority level */
#define IRQ_PRIORITY_LEVEL_LOWEST                       31
/** IRQ: highest priority level */
#define IRQ_PRIORITY_LEVEL_HIGHEST                      0
/** IRQ: number of channels in the priority level register */
#define IRQ_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT       4
/** IRQ: number of channels in the enable register */
#define IRQ_ENABLE_REGISTER_CHANNEL_COUNT               32

/** NMI: NMI channel count */
#define NMI_CHANNEL_COUNT                               32
/** NMI: lowest priority level */
#define NMI_PRIORITY_LEVEL_LOWEST                       15
/** NMI: highest priority level */
#define NMI_PRIORITY_LEVEL_HIGHEST                      0
/** NMI: number of channels in the priority level register */
#define NMI_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT       4

/** Key to unlock the Interrupt Controller by writing to IRQn_UNLOCK register */
#define INT_CTRL_KEY_UNLOCK             0x17ACC911
/** Key to lock the Interrupt Controller by writing to IRQn_UNLOCK register */
#define INT_CTRL_KEY_LOCK               0x17B10C11

#define USER_IRQ_COUNT                  (sizeof(m_astcUserIrqTable)     / sizeof(m_astcUserIrqTable[0]))
#define USER_NMI_COUNT                  (sizeof(m_astcUserNmiTable)     / sizeof(m_astcUserNmiTable[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/

/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

#ifdef __TOOLCHAIN_GHS_MULTI__
typedef void (*irq_func_ptr_t)(void);
typedef void (*nmi_func_ptr_t)(void);
#endif
#ifdef __TOOLCHAIN_IAR__
typedef void (FN_IRQ_NOT_NESTED *irq_func_ptr_t)(void);
typedef void (FN_NMI *nmi_func_ptr_t)(void);
#endif
#ifdef __TOOLCHAIN_GCC__
typedef void (*irq_func_ptr_t)(void);
typedef void (*nmi_func_ptr_t)(void);
#endif

typedef struct stc_irq_vector_entry
{
    irq_func_ptr_t  pfnIsr;
    uint16_t        u16Channel;
    uint8_t         u8Level;
} stc_irq_vector_entry_t;

typedef struct stc_nmi_vector_entry
{
    nmi_func_ptr_t  pfnIsr;
    uint16_t        u16Channel;
    uint8_t         u8Level;
} stc_nmi_vector_entry_t;

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/
static FN_IRQ_NOT_NESTED void DefaultIrqHandler(void);
static FN_NMI void DefaultNmiHandler(void);
static void UnlockIntCtrl(void);
static void LockIntCtrl(void);

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

#ifdef __TOOLCHAIN_IAR__
    // suppress warning "zero used for undefined preprocessing identifier"
    #pragma diag_suppress=Pe193
#endif


/** Table of all user specific IRQ vectors */
const stc_irq_vector_entry_t m_astcUserIrqTable[] =
{
    { .u16Channel = 0, .pfnIsr = (irq_func_ptr_t)DefaultIrqHandler, .u8Level = 31 },      // Dummy entry (in case no user specific ISR is assigned)
#if (INTERRUPTS_IRQ_ISR_0 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_0, .pfnIsr = INTERRUPTS_IRQ_ISR_0, .u8Level = INTERRUPTS_IRQ_LEVEL_0 },
#endif
#if (INTERRUPTS_IRQ_ISR_1 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_1, .pfnIsr = INTERRUPTS_IRQ_ISR_1, .u8Level = INTERRUPTS_IRQ_LEVEL_1 },
#endif
#if (INTERRUPTS_IRQ_ISR_2 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_2, .pfnIsr = INTERRUPTS_IRQ_ISR_2, .u8Level = INTERRUPTS_IRQ_LEVEL_2 },
#endif
#if (INTERRUPTS_IRQ_ISR_3 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_3, .pfnIsr = INTERRUPTS_IRQ_ISR_3, .u8Level = INTERRUPTS_IRQ_LEVEL_3 },
#endif
#if (INTERRUPTS_IRQ_ISR_4 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_4, .pfnIsr = INTERRUPTS_IRQ_ISR_4, .u8Level = INTERRUPTS_IRQ_LEVEL_4 },
#endif
#if (INTERRUPTS_IRQ_ISR_5 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_5, .pfnIsr = INTERRUPTS_IRQ_ISR_5, .u8Level = INTERRUPTS_IRQ_LEVEL_5 },
#endif
#if (INTERRUPTS_IRQ_ISR_6 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_6, .pfnIsr = INTERRUPTS_IRQ_ISR_6, .u8Level = INTERRUPTS_IRQ_LEVEL_6 },
#endif
#if (INTERRUPTS_IRQ_ISR_7 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_7, .pfnIsr = INTERRUPTS_IRQ_ISR_7, .u8Level = INTERRUPTS_IRQ_LEVEL_7 },
#endif
#if (INTERRUPTS_IRQ_ISR_8 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_8, .pfnIsr = INTERRUPTS_IRQ_ISR_8, .u8Level = INTERRUPTS_IRQ_LEVEL_8 },
#endif
#if (INTERRUPTS_IRQ_ISR_9 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_9, .pfnIsr = INTERRUPTS_IRQ_ISR_9, .u8Level = INTERRUPTS_IRQ_LEVEL_9 },
#endif
#if (INTERRUPTS_IRQ_ISR_10 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_10, .pfnIsr = INTERRUPTS_IRQ_ISR_10, .u8Level = INTERRUPTS_IRQ_LEVEL_10 },
#endif
#if (INTERRUPTS_IRQ_ISR_11 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_11, .pfnIsr = INTERRUPTS_IRQ_ISR_11, .u8Level = INTERRUPTS_IRQ_LEVEL_11 },
#endif
#if (INTERRUPTS_IRQ_ISR_12 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_12, .pfnIsr = INTERRUPTS_IRQ_ISR_12, .u8Level = INTERRUPTS_IRQ_LEVEL_12 },
#endif
#if (INTERRUPTS_IRQ_ISR_13 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_13, .pfnIsr = INTERRUPTS_IRQ_ISR_13, .u8Level = INTERRUPTS_IRQ_LEVEL_13 },
#endif
#if (INTERRUPTS_IRQ_ISR_14 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_14, .pfnIsr = INTERRUPTS_IRQ_ISR_14, .u8Level = INTERRUPTS_IRQ_LEVEL_14 },
#endif
#if (INTERRUPTS_IRQ_ISR_15 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_15, .pfnIsr = INTERRUPTS_IRQ_ISR_15, .u8Level = INTERRUPTS_IRQ_LEVEL_15 },
#endif
#if (INTERRUPTS_IRQ_ISR_16 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_16, .pfnIsr = INTERRUPTS_IRQ_ISR_16, .u8Level = INTERRUPTS_IRQ_LEVEL_16 },
#endif
#if (INTERRUPTS_IRQ_ISR_17 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_17, .pfnIsr = INTERRUPTS_IRQ_ISR_17, .u8Level = INTERRUPTS_IRQ_LEVEL_17 },
#endif
#if (INTERRUPTS_IRQ_ISR_18 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_18, .pfnIsr = INTERRUPTS_IRQ_ISR_18, .u8Level = INTERRUPTS_IRQ_LEVEL_18 },
#endif
#if (INTERRUPTS_IRQ_ISR_19 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_19, .pfnIsr = INTERRUPTS_IRQ_ISR_19, .u8Level = INTERRUPTS_IRQ_LEVEL_19 },
#endif
#if (INTERRUPTS_IRQ_ISR_20 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_20, .pfnIsr = INTERRUPTS_IRQ_ISR_20, .u8Level = INTERRUPTS_IRQ_LEVEL_20 },
#endif
#if (INTERRUPTS_IRQ_ISR_21 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_21, .pfnIsr = INTERRUPTS_IRQ_ISR_21, .u8Level = INTERRUPTS_IRQ_LEVEL_21 },
#endif
#if (INTERRUPTS_IRQ_ISR_22 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_22, .pfnIsr = INTERRUPTS_IRQ_ISR_22, .u8Level = INTERRUPTS_IRQ_LEVEL_22 },
#endif
#if (INTERRUPTS_IRQ_ISR_23 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_23, .pfnIsr = INTERRUPTS_IRQ_ISR_23, .u8Level = INTERRUPTS_IRQ_LEVEL_23 },
#endif
#if (INTERRUPTS_IRQ_ISR_24 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_24, .pfnIsr = INTERRUPTS_IRQ_ISR_24, .u8Level = INTERRUPTS_IRQ_LEVEL_24 },
#endif
#if (INTERRUPTS_IRQ_ISR_25 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_25, .pfnIsr = INTERRUPTS_IRQ_ISR_25, .u8Level = INTERRUPTS_IRQ_LEVEL_25 },
#endif
#if (INTERRUPTS_IRQ_ISR_26 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_26, .pfnIsr = INTERRUPTS_IRQ_ISR_26, .u8Level = INTERRUPTS_IRQ_LEVEL_26 },
#endif
#if (INTERRUPTS_IRQ_ISR_27 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_27, .pfnIsr = INTERRUPTS_IRQ_ISR_27, .u8Level = INTERRUPTS_IRQ_LEVEL_27 },
#endif
#if (INTERRUPTS_IRQ_ISR_28 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_28, .pfnIsr = INTERRUPTS_IRQ_ISR_28, .u8Level = INTERRUPTS_IRQ_LEVEL_28 },
#endif
#if (INTERRUPTS_IRQ_ISR_29 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_29, .pfnIsr = INTERRUPTS_IRQ_ISR_29, .u8Level = INTERRUPTS_IRQ_LEVEL_29 },
#endif
#if (INTERRUPTS_IRQ_ISR_30 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_30, .pfnIsr = INTERRUPTS_IRQ_ISR_30, .u8Level = INTERRUPTS_IRQ_LEVEL_30 },
#endif
#if (INTERRUPTS_IRQ_ISR_31 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_31, .pfnIsr = INTERRUPTS_IRQ_ISR_31, .u8Level = INTERRUPTS_IRQ_LEVEL_31 },
#endif
#if (INTERRUPTS_IRQ_ISR_32 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_32, .pfnIsr = INTERRUPTS_IRQ_ISR_32, .u8Level = INTERRUPTS_IRQ_LEVEL_32 },
#endif
#if (INTERRUPTS_IRQ_ISR_33 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_33, .pfnIsr = INTERRUPTS_IRQ_ISR_33, .u8Level = INTERRUPTS_IRQ_LEVEL_33 },
#endif
#if (INTERRUPTS_IRQ_ISR_34 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_34, .pfnIsr = INTERRUPTS_IRQ_ISR_34, .u8Level = INTERRUPTS_IRQ_LEVEL_34 },
#endif
#if (INTERRUPTS_IRQ_ISR_35 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_35, .pfnIsr = INTERRUPTS_IRQ_ISR_35, .u8Level = INTERRUPTS_IRQ_LEVEL_35 },
#endif
#if (INTERRUPTS_IRQ_ISR_36 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_36, .pfnIsr = INTERRUPTS_IRQ_ISR_36, .u8Level = INTERRUPTS_IRQ_LEVEL_36 },
#endif
#if (INTERRUPTS_IRQ_ISR_37 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_37, .pfnIsr = INTERRUPTS_IRQ_ISR_37, .u8Level = INTERRUPTS_IRQ_LEVEL_37 },
#endif
#if (INTERRUPTS_IRQ_ISR_38 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_38, .pfnIsr = INTERRUPTS_IRQ_ISR_38, .u8Level = INTERRUPTS_IRQ_LEVEL_38 },
#endif
#if (INTERRUPTS_IRQ_ISR_39 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_39, .pfnIsr = INTERRUPTS_IRQ_ISR_39, .u8Level = INTERRUPTS_IRQ_LEVEL_39 },
#endif
#if (INTERRUPTS_IRQ_ISR_40 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_40, .pfnIsr = INTERRUPTS_IRQ_ISR_40, .u8Level = INTERRUPTS_IRQ_LEVEL_40 },
#endif
#if (INTERRUPTS_IRQ_ISR_41 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_41, .pfnIsr = INTERRUPTS_IRQ_ISR_41, .u8Level = INTERRUPTS_IRQ_LEVEL_41 },
#endif
#if (INTERRUPTS_IRQ_ISR_42 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_42, .pfnIsr = INTERRUPTS_IRQ_ISR_42, .u8Level = INTERRUPTS_IRQ_LEVEL_42 },
#endif
#if (INTERRUPTS_IRQ_ISR_43 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_43, .pfnIsr = INTERRUPTS_IRQ_ISR_43, .u8Level = INTERRUPTS_IRQ_LEVEL_43 },
#endif
#if (INTERRUPTS_IRQ_ISR_44 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_44, .pfnIsr = INTERRUPTS_IRQ_ISR_44, .u8Level = INTERRUPTS_IRQ_LEVEL_44 },
#endif
#if (INTERRUPTS_IRQ_ISR_45 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_45, .pfnIsr = INTERRUPTS_IRQ_ISR_45, .u8Level = INTERRUPTS_IRQ_LEVEL_45 },
#endif
#if (INTERRUPTS_IRQ_ISR_46 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_46, .pfnIsr = INTERRUPTS_IRQ_ISR_46, .u8Level = INTERRUPTS_IRQ_LEVEL_46 },
#endif
#if (INTERRUPTS_IRQ_ISR_47 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_47, .pfnIsr = INTERRUPTS_IRQ_ISR_47, .u8Level = INTERRUPTS_IRQ_LEVEL_47 },
#endif
#if (INTERRUPTS_IRQ_ISR_48 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_48, .pfnIsr = INTERRUPTS_IRQ_ISR_48, .u8Level = INTERRUPTS_IRQ_LEVEL_48 },
#endif
#if (INTERRUPTS_IRQ_ISR_49 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_49, .pfnIsr = INTERRUPTS_IRQ_ISR_49, .u8Level = INTERRUPTS_IRQ_LEVEL_49 },
#endif
#if (INTERRUPTS_IRQ_ISR_50 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_50, .pfnIsr = INTERRUPTS_IRQ_ISR_50, .u8Level = INTERRUPTS_IRQ_LEVEL_50 },
#endif
#if (INTERRUPTS_IRQ_ISR_51 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_51, .pfnIsr = INTERRUPTS_IRQ_ISR_51, .u8Level = INTERRUPTS_IRQ_LEVEL_51 },
#endif
#if (INTERRUPTS_IRQ_ISR_52 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_52, .pfnIsr = INTERRUPTS_IRQ_ISR_52, .u8Level = INTERRUPTS_IRQ_LEVEL_52 },
#endif
#if (INTERRUPTS_IRQ_ISR_53 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_53, .pfnIsr = INTERRUPTS_IRQ_ISR_53, .u8Level = INTERRUPTS_IRQ_LEVEL_53 },
#endif
#if (INTERRUPTS_IRQ_ISR_54 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_54, .pfnIsr = INTERRUPTS_IRQ_ISR_54, .u8Level = INTERRUPTS_IRQ_LEVEL_54 },
#endif
#if (INTERRUPTS_IRQ_ISR_55 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_55, .pfnIsr = INTERRUPTS_IRQ_ISR_55, .u8Level = INTERRUPTS_IRQ_LEVEL_55 },
#endif
#if (INTERRUPTS_IRQ_ISR_56 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_56, .pfnIsr = INTERRUPTS_IRQ_ISR_56, .u8Level = INTERRUPTS_IRQ_LEVEL_56 },
#endif
#if (INTERRUPTS_IRQ_ISR_57 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_57, .pfnIsr = INTERRUPTS_IRQ_ISR_57, .u8Level = INTERRUPTS_IRQ_LEVEL_57 },
#endif
#if (INTERRUPTS_IRQ_ISR_58 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_58, .pfnIsr = INTERRUPTS_IRQ_ISR_58, .u8Level = INTERRUPTS_IRQ_LEVEL_58 },
#endif
#if (INTERRUPTS_IRQ_ISR_59 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_59, .pfnIsr = INTERRUPTS_IRQ_ISR_59, .u8Level = INTERRUPTS_IRQ_LEVEL_59 },
#endif
#if (INTERRUPTS_IRQ_ISR_60 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_60, .pfnIsr = INTERRUPTS_IRQ_ISR_60, .u8Level = INTERRUPTS_IRQ_LEVEL_60 },
#endif
#if (INTERRUPTS_IRQ_ISR_61 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_61, .pfnIsr = INTERRUPTS_IRQ_ISR_61, .u8Level = INTERRUPTS_IRQ_LEVEL_61 },
#endif
#if (INTERRUPTS_IRQ_ISR_62 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_62, .pfnIsr = INTERRUPTS_IRQ_ISR_62, .u8Level = INTERRUPTS_IRQ_LEVEL_62 },
#endif
#if (INTERRUPTS_IRQ_ISR_63 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_63, .pfnIsr = INTERRUPTS_IRQ_ISR_63, .u8Level = INTERRUPTS_IRQ_LEVEL_63 },
#endif
#if (INTERRUPTS_IRQ_ISR_64 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_64, .pfnIsr = INTERRUPTS_IRQ_ISR_64, .u8Level = INTERRUPTS_IRQ_LEVEL_64 },
#endif
#if (INTERRUPTS_IRQ_ISR_65 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_65, .pfnIsr = INTERRUPTS_IRQ_ISR_65, .u8Level = INTERRUPTS_IRQ_LEVEL_65 },
#endif
#if (INTERRUPTS_IRQ_ISR_66 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_66, .pfnIsr = INTERRUPTS_IRQ_ISR_66, .u8Level = INTERRUPTS_IRQ_LEVEL_66 },
#endif
#if (INTERRUPTS_IRQ_ISR_67 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_67, .pfnIsr = INTERRUPTS_IRQ_ISR_67, .u8Level = INTERRUPTS_IRQ_LEVEL_67 },
#endif
#if (INTERRUPTS_IRQ_ISR_68 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_68, .pfnIsr = INTERRUPTS_IRQ_ISR_68, .u8Level = INTERRUPTS_IRQ_LEVEL_68 },
#endif
#if (INTERRUPTS_IRQ_ISR_69 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_69, .pfnIsr = INTERRUPTS_IRQ_ISR_69, .u8Level = INTERRUPTS_IRQ_LEVEL_69 },
#endif
#if (INTERRUPTS_IRQ_ISR_70 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_70, .pfnIsr = INTERRUPTS_IRQ_ISR_70, .u8Level = INTERRUPTS_IRQ_LEVEL_70 },
#endif
#if (INTERRUPTS_IRQ_ISR_71 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_71, .pfnIsr = INTERRUPTS_IRQ_ISR_71, .u8Level = INTERRUPTS_IRQ_LEVEL_71 },
#endif
#if (INTERRUPTS_IRQ_ISR_72 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_72, .pfnIsr = INTERRUPTS_IRQ_ISR_72, .u8Level = INTERRUPTS_IRQ_LEVEL_72 },
#endif
#if (INTERRUPTS_IRQ_ISR_73 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_73, .pfnIsr = INTERRUPTS_IRQ_ISR_73, .u8Level = INTERRUPTS_IRQ_LEVEL_73 },
#endif
#if (INTERRUPTS_IRQ_ISR_74 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_74, .pfnIsr = INTERRUPTS_IRQ_ISR_74, .u8Level = INTERRUPTS_IRQ_LEVEL_74 },
#endif
#if (INTERRUPTS_IRQ_ISR_75 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_75, .pfnIsr = INTERRUPTS_IRQ_ISR_75, .u8Level = INTERRUPTS_IRQ_LEVEL_75 },
#endif
#if (INTERRUPTS_IRQ_ISR_76 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_76, .pfnIsr = INTERRUPTS_IRQ_ISR_76, .u8Level = INTERRUPTS_IRQ_LEVEL_76 },
#endif
#if (INTERRUPTS_IRQ_ISR_77 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_77, .pfnIsr = INTERRUPTS_IRQ_ISR_77, .u8Level = INTERRUPTS_IRQ_LEVEL_77 },
#endif
#if (INTERRUPTS_IRQ_ISR_78 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_78, .pfnIsr = INTERRUPTS_IRQ_ISR_78, .u8Level = INTERRUPTS_IRQ_LEVEL_78 },
#endif
#if (INTERRUPTS_IRQ_ISR_79 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_79, .pfnIsr = INTERRUPTS_IRQ_ISR_79, .u8Level = INTERRUPTS_IRQ_LEVEL_79 },
#endif
#if (INTERRUPTS_IRQ_ISR_80 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_80, .pfnIsr = INTERRUPTS_IRQ_ISR_80, .u8Level = INTERRUPTS_IRQ_LEVEL_80 },
#endif
#if (INTERRUPTS_IRQ_ISR_81 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_81, .pfnIsr = INTERRUPTS_IRQ_ISR_81, .u8Level = INTERRUPTS_IRQ_LEVEL_81 },
#endif
#if (INTERRUPTS_IRQ_ISR_82 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_82, .pfnIsr = INTERRUPTS_IRQ_ISR_82, .u8Level = INTERRUPTS_IRQ_LEVEL_82 },
#endif
#if (INTERRUPTS_IRQ_ISR_83 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_83, .pfnIsr = INTERRUPTS_IRQ_ISR_83, .u8Level = INTERRUPTS_IRQ_LEVEL_83 },
#endif
#if (INTERRUPTS_IRQ_ISR_84 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_84, .pfnIsr = INTERRUPTS_IRQ_ISR_84, .u8Level = INTERRUPTS_IRQ_LEVEL_84 },
#endif
#if (INTERRUPTS_IRQ_ISR_85 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_85, .pfnIsr = INTERRUPTS_IRQ_ISR_85, .u8Level = INTERRUPTS_IRQ_LEVEL_85 },
#endif
#if (INTERRUPTS_IRQ_ISR_86 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_86, .pfnIsr = INTERRUPTS_IRQ_ISR_86, .u8Level = INTERRUPTS_IRQ_LEVEL_86 },
#endif
#if (INTERRUPTS_IRQ_ISR_87 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_87, .pfnIsr = INTERRUPTS_IRQ_ISR_87, .u8Level = INTERRUPTS_IRQ_LEVEL_87 },
#endif
#if (INTERRUPTS_IRQ_ISR_88 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_88, .pfnIsr = INTERRUPTS_IRQ_ISR_88, .u8Level = INTERRUPTS_IRQ_LEVEL_88 },
#endif
#if (INTERRUPTS_IRQ_ISR_89 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_89, .pfnIsr = INTERRUPTS_IRQ_ISR_89, .u8Level = INTERRUPTS_IRQ_LEVEL_89 },
#endif
#if (INTERRUPTS_IRQ_ISR_90 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_90, .pfnIsr = INTERRUPTS_IRQ_ISR_90, .u8Level = INTERRUPTS_IRQ_LEVEL_90 },
#endif
#if (INTERRUPTS_IRQ_ISR_91 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_91, .pfnIsr = INTERRUPTS_IRQ_ISR_91, .u8Level = INTERRUPTS_IRQ_LEVEL_91 },
#endif
#if (INTERRUPTS_IRQ_ISR_92 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_92, .pfnIsr = INTERRUPTS_IRQ_ISR_92, .u8Level = INTERRUPTS_IRQ_LEVEL_92 },
#endif
#if (INTERRUPTS_IRQ_ISR_93 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_93, .pfnIsr = INTERRUPTS_IRQ_ISR_93, .u8Level = INTERRUPTS_IRQ_LEVEL_93 },
#endif
#if (INTERRUPTS_IRQ_ISR_94 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_94, .pfnIsr = INTERRUPTS_IRQ_ISR_94, .u8Level = INTERRUPTS_IRQ_LEVEL_94 },
#endif
#if (INTERRUPTS_IRQ_ISR_95 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_95, .pfnIsr = INTERRUPTS_IRQ_ISR_95, .u8Level = INTERRUPTS_IRQ_LEVEL_95 },
#endif
#if (INTERRUPTS_IRQ_ISR_96 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_96, .pfnIsr = INTERRUPTS_IRQ_ISR_96, .u8Level = INTERRUPTS_IRQ_LEVEL_96 },
#endif
#if (INTERRUPTS_IRQ_ISR_97 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_97, .pfnIsr = INTERRUPTS_IRQ_ISR_97, .u8Level = INTERRUPTS_IRQ_LEVEL_97 },
#endif
#if (INTERRUPTS_IRQ_ISR_98 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_98, .pfnIsr = INTERRUPTS_IRQ_ISR_98, .u8Level = INTERRUPTS_IRQ_LEVEL_98 },
#endif
#if (INTERRUPTS_IRQ_ISR_99 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_99, .pfnIsr = INTERRUPTS_IRQ_ISR_99, .u8Level = INTERRUPTS_IRQ_LEVEL_99 },
#endif
#if (INTERRUPTS_IRQ_ISR_100 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_100, .pfnIsr = INTERRUPTS_IRQ_ISR_100, .u8Level = INTERRUPTS_IRQ_LEVEL_100 },
#endif
#if (INTERRUPTS_IRQ_ISR_101 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_101, .pfnIsr = INTERRUPTS_IRQ_ISR_101, .u8Level = INTERRUPTS_IRQ_LEVEL_101 },
#endif
#if (INTERRUPTS_IRQ_ISR_102 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_102, .pfnIsr = INTERRUPTS_IRQ_ISR_102, .u8Level = INTERRUPTS_IRQ_LEVEL_102 },
#endif
#if (INTERRUPTS_IRQ_ISR_103 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_103, .pfnIsr = INTERRUPTS_IRQ_ISR_103, .u8Level = INTERRUPTS_IRQ_LEVEL_103 },
#endif
#if (INTERRUPTS_IRQ_ISR_104 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_104, .pfnIsr = INTERRUPTS_IRQ_ISR_104, .u8Level = INTERRUPTS_IRQ_LEVEL_104 },
#endif
#if (INTERRUPTS_IRQ_ISR_105 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_105, .pfnIsr = INTERRUPTS_IRQ_ISR_105, .u8Level = INTERRUPTS_IRQ_LEVEL_105 },
#endif
#if (INTERRUPTS_IRQ_ISR_106 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_106, .pfnIsr = INTERRUPTS_IRQ_ISR_106, .u8Level = INTERRUPTS_IRQ_LEVEL_106 },
#endif
#if (INTERRUPTS_IRQ_ISR_107 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_107, .pfnIsr = INTERRUPTS_IRQ_ISR_107, .u8Level = INTERRUPTS_IRQ_LEVEL_107 },
#endif
#if (INTERRUPTS_IRQ_ISR_108 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_108, .pfnIsr = INTERRUPTS_IRQ_ISR_108, .u8Level = INTERRUPTS_IRQ_LEVEL_108 },
#endif
#if (INTERRUPTS_IRQ_ISR_109 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_109, .pfnIsr = INTERRUPTS_IRQ_ISR_109, .u8Level = INTERRUPTS_IRQ_LEVEL_109 },
#endif
#if (INTERRUPTS_IRQ_ISR_110 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_110, .pfnIsr = INTERRUPTS_IRQ_ISR_110, .u8Level = INTERRUPTS_IRQ_LEVEL_110 },
#endif
#if (INTERRUPTS_IRQ_ISR_111 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_111, .pfnIsr = INTERRUPTS_IRQ_ISR_111, .u8Level = INTERRUPTS_IRQ_LEVEL_111 },
#endif
#if (INTERRUPTS_IRQ_ISR_112 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_112, .pfnIsr = INTERRUPTS_IRQ_ISR_112, .u8Level = INTERRUPTS_IRQ_LEVEL_112 },
#endif
#if (INTERRUPTS_IRQ_ISR_113 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_113, .pfnIsr = INTERRUPTS_IRQ_ISR_113, .u8Level = INTERRUPTS_IRQ_LEVEL_113 },
#endif
#if (INTERRUPTS_IRQ_ISR_114 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_114, .pfnIsr = INTERRUPTS_IRQ_ISR_114, .u8Level = INTERRUPTS_IRQ_LEVEL_114 },
#endif
#if (INTERRUPTS_IRQ_ISR_115 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_115, .pfnIsr = INTERRUPTS_IRQ_ISR_115, .u8Level = INTERRUPTS_IRQ_LEVEL_115 },
#endif
#if (INTERRUPTS_IRQ_ISR_116 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_116, .pfnIsr = INTERRUPTS_IRQ_ISR_116, .u8Level = INTERRUPTS_IRQ_LEVEL_116 },
#endif
#if (INTERRUPTS_IRQ_ISR_117 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_117, .pfnIsr = INTERRUPTS_IRQ_ISR_117, .u8Level = INTERRUPTS_IRQ_LEVEL_117 },
#endif
#if (INTERRUPTS_IRQ_ISR_118 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_118, .pfnIsr = INTERRUPTS_IRQ_ISR_118, .u8Level = INTERRUPTS_IRQ_LEVEL_118 },
#endif
#if (INTERRUPTS_IRQ_ISR_119 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_119, .pfnIsr = INTERRUPTS_IRQ_ISR_119, .u8Level = INTERRUPTS_IRQ_LEVEL_119 },
#endif
#if (INTERRUPTS_IRQ_ISR_120 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_120, .pfnIsr = INTERRUPTS_IRQ_ISR_120, .u8Level = INTERRUPTS_IRQ_LEVEL_120 },
#endif
#if (INTERRUPTS_IRQ_ISR_121 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_121, .pfnIsr = INTERRUPTS_IRQ_ISR_121, .u8Level = INTERRUPTS_IRQ_LEVEL_121 },
#endif
#if (INTERRUPTS_IRQ_ISR_122 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_122, .pfnIsr = INTERRUPTS_IRQ_ISR_122, .u8Level = INTERRUPTS_IRQ_LEVEL_122 },
#endif
#if (INTERRUPTS_IRQ_ISR_123 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_123, .pfnIsr = INTERRUPTS_IRQ_ISR_123, .u8Level = INTERRUPTS_IRQ_LEVEL_123 },
#endif
#if (INTERRUPTS_IRQ_ISR_124 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_124, .pfnIsr = INTERRUPTS_IRQ_ISR_124, .u8Level = INTERRUPTS_IRQ_LEVEL_124 },
#endif
#if (INTERRUPTS_IRQ_ISR_125 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_125, .pfnIsr = INTERRUPTS_IRQ_ISR_125, .u8Level = INTERRUPTS_IRQ_LEVEL_125 },
#endif
#if (INTERRUPTS_IRQ_ISR_126 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_126, .pfnIsr = INTERRUPTS_IRQ_ISR_126, .u8Level = INTERRUPTS_IRQ_LEVEL_126 },
#endif
#if (INTERRUPTS_IRQ_ISR_127 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_127, .pfnIsr = INTERRUPTS_IRQ_ISR_127, .u8Level = INTERRUPTS_IRQ_LEVEL_127 },
#endif
#if (INTERRUPTS_IRQ_ISR_128 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_128, .pfnIsr = INTERRUPTS_IRQ_ISR_128, .u8Level = INTERRUPTS_IRQ_LEVEL_128 },
#endif
#if (INTERRUPTS_IRQ_ISR_129 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_129, .pfnIsr = INTERRUPTS_IRQ_ISR_129, .u8Level = INTERRUPTS_IRQ_LEVEL_129 },
#endif
#if (INTERRUPTS_IRQ_ISR_130 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_130, .pfnIsr = INTERRUPTS_IRQ_ISR_130, .u8Level = INTERRUPTS_IRQ_LEVEL_130 },
#endif
#if (INTERRUPTS_IRQ_ISR_131 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_131, .pfnIsr = INTERRUPTS_IRQ_ISR_131, .u8Level = INTERRUPTS_IRQ_LEVEL_131 },
#endif
#if (INTERRUPTS_IRQ_ISR_132 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_132, .pfnIsr = INTERRUPTS_IRQ_ISR_132, .u8Level = INTERRUPTS_IRQ_LEVEL_132 },
#endif
#if (INTERRUPTS_IRQ_ISR_133 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_133, .pfnIsr = INTERRUPTS_IRQ_ISR_133, .u8Level = INTERRUPTS_IRQ_LEVEL_133 },
#endif
#if (INTERRUPTS_IRQ_ISR_134 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_134, .pfnIsr = INTERRUPTS_IRQ_ISR_134, .u8Level = INTERRUPTS_IRQ_LEVEL_134 },
#endif
#if (INTERRUPTS_IRQ_ISR_135 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_135, .pfnIsr = INTERRUPTS_IRQ_ISR_135, .u8Level = INTERRUPTS_IRQ_LEVEL_135 },
#endif
#if (INTERRUPTS_IRQ_ISR_136 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_136, .pfnIsr = INTERRUPTS_IRQ_ISR_136, .u8Level = INTERRUPTS_IRQ_LEVEL_136 },
#endif
#if (INTERRUPTS_IRQ_ISR_137 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_137, .pfnIsr = INTERRUPTS_IRQ_ISR_137, .u8Level = INTERRUPTS_IRQ_LEVEL_137 },
#endif
#if (INTERRUPTS_IRQ_ISR_138 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_138, .pfnIsr = INTERRUPTS_IRQ_ISR_138, .u8Level = INTERRUPTS_IRQ_LEVEL_138 },
#endif
#if (INTERRUPTS_IRQ_ISR_139 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_139, .pfnIsr = INTERRUPTS_IRQ_ISR_139, .u8Level = INTERRUPTS_IRQ_LEVEL_139 },
#endif
#if (INTERRUPTS_IRQ_ISR_140 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_140, .pfnIsr = INTERRUPTS_IRQ_ISR_140, .u8Level = INTERRUPTS_IRQ_LEVEL_140 },
#endif
#if (INTERRUPTS_IRQ_ISR_141 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_141, .pfnIsr = INTERRUPTS_IRQ_ISR_141, .u8Level = INTERRUPTS_IRQ_LEVEL_141 },
#endif
#if (INTERRUPTS_IRQ_ISR_142 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_142, .pfnIsr = INTERRUPTS_IRQ_ISR_142, .u8Level = INTERRUPTS_IRQ_LEVEL_142 },
#endif
#if (INTERRUPTS_IRQ_ISR_143 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_143, .pfnIsr = INTERRUPTS_IRQ_ISR_143, .u8Level = INTERRUPTS_IRQ_LEVEL_143 },
#endif
#if (INTERRUPTS_IRQ_ISR_144 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_144, .pfnIsr = INTERRUPTS_IRQ_ISR_144, .u8Level = INTERRUPTS_IRQ_LEVEL_144 },
#endif
#if (INTERRUPTS_IRQ_ISR_145 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_145, .pfnIsr = INTERRUPTS_IRQ_ISR_145, .u8Level = INTERRUPTS_IRQ_LEVEL_145 },
#endif
#if (INTERRUPTS_IRQ_ISR_146 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_146, .pfnIsr = INTERRUPTS_IRQ_ISR_146, .u8Level = INTERRUPTS_IRQ_LEVEL_146 },
#endif
#if (INTERRUPTS_IRQ_ISR_147 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_147, .pfnIsr = INTERRUPTS_IRQ_ISR_147, .u8Level = INTERRUPTS_IRQ_LEVEL_147 },
#endif
#if (INTERRUPTS_IRQ_ISR_148 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_148, .pfnIsr = INTERRUPTS_IRQ_ISR_148, .u8Level = INTERRUPTS_IRQ_LEVEL_148 },
#endif
#if (INTERRUPTS_IRQ_ISR_149 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_149, .pfnIsr = INTERRUPTS_IRQ_ISR_149, .u8Level = INTERRUPTS_IRQ_LEVEL_149 },
#endif
#if (INTERRUPTS_IRQ_ISR_150 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_150, .pfnIsr = INTERRUPTS_IRQ_ISR_150, .u8Level = INTERRUPTS_IRQ_LEVEL_150 },
#endif
#if (INTERRUPTS_IRQ_ISR_151 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_151, .pfnIsr = INTERRUPTS_IRQ_ISR_151, .u8Level = INTERRUPTS_IRQ_LEVEL_151 },
#endif
#if (INTERRUPTS_IRQ_ISR_152 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_152, .pfnIsr = INTERRUPTS_IRQ_ISR_152, .u8Level = INTERRUPTS_IRQ_LEVEL_152 },
#endif
#if (INTERRUPTS_IRQ_ISR_153 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_153, .pfnIsr = INTERRUPTS_IRQ_ISR_153, .u8Level = INTERRUPTS_IRQ_LEVEL_153 },
#endif
#if (INTERRUPTS_IRQ_ISR_154 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_154, .pfnIsr = INTERRUPTS_IRQ_ISR_154, .u8Level = INTERRUPTS_IRQ_LEVEL_154 },
#endif
#if (INTERRUPTS_IRQ_ISR_155 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_155, .pfnIsr = INTERRUPTS_IRQ_ISR_155, .u8Level = INTERRUPTS_IRQ_LEVEL_155 },
#endif
#if (INTERRUPTS_IRQ_ISR_156 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_156, .pfnIsr = INTERRUPTS_IRQ_ISR_156, .u8Level = INTERRUPTS_IRQ_LEVEL_156 },
#endif
#if (INTERRUPTS_IRQ_ISR_157 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_157, .pfnIsr = INTERRUPTS_IRQ_ISR_157, .u8Level = INTERRUPTS_IRQ_LEVEL_157 },
#endif
#if (INTERRUPTS_IRQ_ISR_158 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_158, .pfnIsr = INTERRUPTS_IRQ_ISR_158, .u8Level = INTERRUPTS_IRQ_LEVEL_158 },
#endif
#if (INTERRUPTS_IRQ_ISR_159 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_159, .pfnIsr = INTERRUPTS_IRQ_ISR_159, .u8Level = INTERRUPTS_IRQ_LEVEL_159 },
#endif
#if (INTERRUPTS_IRQ_ISR_160 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_160, .pfnIsr = INTERRUPTS_IRQ_ISR_160, .u8Level = INTERRUPTS_IRQ_LEVEL_160 },
#endif
#if (INTERRUPTS_IRQ_ISR_161 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_161, .pfnIsr = INTERRUPTS_IRQ_ISR_161, .u8Level = INTERRUPTS_IRQ_LEVEL_161 },
#endif
#if (INTERRUPTS_IRQ_ISR_162 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_162, .pfnIsr = INTERRUPTS_IRQ_ISR_162, .u8Level = INTERRUPTS_IRQ_LEVEL_162 },
#endif
#if (INTERRUPTS_IRQ_ISR_163 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_163, .pfnIsr = INTERRUPTS_IRQ_ISR_163, .u8Level = INTERRUPTS_IRQ_LEVEL_163 },
#endif
#if (INTERRUPTS_IRQ_ISR_164 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_164, .pfnIsr = INTERRUPTS_IRQ_ISR_164, .u8Level = INTERRUPTS_IRQ_LEVEL_164 },
#endif
#if (INTERRUPTS_IRQ_ISR_165 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_165, .pfnIsr = INTERRUPTS_IRQ_ISR_165, .u8Level = INTERRUPTS_IRQ_LEVEL_165 },
#endif
#if (INTERRUPTS_IRQ_ISR_166 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_166, .pfnIsr = INTERRUPTS_IRQ_ISR_166, .u8Level = INTERRUPTS_IRQ_LEVEL_166 },
#endif
#if (INTERRUPTS_IRQ_ISR_167 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_167, .pfnIsr = INTERRUPTS_IRQ_ISR_167, .u8Level = INTERRUPTS_IRQ_LEVEL_167 },
#endif
#if (INTERRUPTS_IRQ_ISR_168 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_168, .pfnIsr = INTERRUPTS_IRQ_ISR_168, .u8Level = INTERRUPTS_IRQ_LEVEL_168 },
#endif
#if (INTERRUPTS_IRQ_ISR_169 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_169, .pfnIsr = INTERRUPTS_IRQ_ISR_169, .u8Level = INTERRUPTS_IRQ_LEVEL_169 },
#endif
#if (INTERRUPTS_IRQ_ISR_170 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_170, .pfnIsr = INTERRUPTS_IRQ_ISR_170, .u8Level = INTERRUPTS_IRQ_LEVEL_170 },
#endif
#if (INTERRUPTS_IRQ_ISR_171 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_171, .pfnIsr = INTERRUPTS_IRQ_ISR_171, .u8Level = INTERRUPTS_IRQ_LEVEL_171 },
#endif
#if (INTERRUPTS_IRQ_ISR_172 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_172, .pfnIsr = INTERRUPTS_IRQ_ISR_172, .u8Level = INTERRUPTS_IRQ_LEVEL_172 },
#endif
#if (INTERRUPTS_IRQ_ISR_173 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_173, .pfnIsr = INTERRUPTS_IRQ_ISR_173, .u8Level = INTERRUPTS_IRQ_LEVEL_173 },
#endif
#if (INTERRUPTS_IRQ_ISR_174 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_174, .pfnIsr = INTERRUPTS_IRQ_ISR_174, .u8Level = INTERRUPTS_IRQ_LEVEL_174 },
#endif
#if (INTERRUPTS_IRQ_ISR_175 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_175, .pfnIsr = INTERRUPTS_IRQ_ISR_175, .u8Level = INTERRUPTS_IRQ_LEVEL_175 },
#endif
#if (INTERRUPTS_IRQ_ISR_176 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_176, .pfnIsr = INTERRUPTS_IRQ_ISR_176, .u8Level = INTERRUPTS_IRQ_LEVEL_176 },
#endif
#if (INTERRUPTS_IRQ_ISR_177 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_177, .pfnIsr = INTERRUPTS_IRQ_ISR_177, .u8Level = INTERRUPTS_IRQ_LEVEL_177 },
#endif
#if (INTERRUPTS_IRQ_ISR_178 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_178, .pfnIsr = INTERRUPTS_IRQ_ISR_178, .u8Level = INTERRUPTS_IRQ_LEVEL_178 },
#endif
#if (INTERRUPTS_IRQ_ISR_179 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_179, .pfnIsr = INTERRUPTS_IRQ_ISR_179, .u8Level = INTERRUPTS_IRQ_LEVEL_179 },
#endif
#if (INTERRUPTS_IRQ_ISR_180 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_180, .pfnIsr = INTERRUPTS_IRQ_ISR_180, .u8Level = INTERRUPTS_IRQ_LEVEL_180 },
#endif
#if (INTERRUPTS_IRQ_ISR_181 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_181, .pfnIsr = INTERRUPTS_IRQ_ISR_181, .u8Level = INTERRUPTS_IRQ_LEVEL_181 },
#endif
#if (INTERRUPTS_IRQ_ISR_182 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_182, .pfnIsr = INTERRUPTS_IRQ_ISR_182, .u8Level = INTERRUPTS_IRQ_LEVEL_182 },
#endif
#if (INTERRUPTS_IRQ_ISR_183 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_183, .pfnIsr = INTERRUPTS_IRQ_ISR_183, .u8Level = INTERRUPTS_IRQ_LEVEL_183 },
#endif
#if (INTERRUPTS_IRQ_ISR_184 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_184, .pfnIsr = INTERRUPTS_IRQ_ISR_184, .u8Level = INTERRUPTS_IRQ_LEVEL_184 },
#endif
#if (INTERRUPTS_IRQ_ISR_185 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_185, .pfnIsr = INTERRUPTS_IRQ_ISR_185, .u8Level = INTERRUPTS_IRQ_LEVEL_185 },
#endif
#if (INTERRUPTS_IRQ_ISR_186 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_186, .pfnIsr = INTERRUPTS_IRQ_ISR_186, .u8Level = INTERRUPTS_IRQ_LEVEL_186 },
#endif
#if (INTERRUPTS_IRQ_ISR_187 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_187, .pfnIsr = INTERRUPTS_IRQ_ISR_187, .u8Level = INTERRUPTS_IRQ_LEVEL_187 },
#endif
#if (INTERRUPTS_IRQ_ISR_188 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_188, .pfnIsr = INTERRUPTS_IRQ_ISR_188, .u8Level = INTERRUPTS_IRQ_LEVEL_188 },
#endif
#if (INTERRUPTS_IRQ_ISR_189 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_189, .pfnIsr = INTERRUPTS_IRQ_ISR_189, .u8Level = INTERRUPTS_IRQ_LEVEL_189 },
#endif
#if (INTERRUPTS_IRQ_ISR_190 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_190, .pfnIsr = INTERRUPTS_IRQ_ISR_190, .u8Level = INTERRUPTS_IRQ_LEVEL_190 },
#endif
#if (INTERRUPTS_IRQ_ISR_191 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_191, .pfnIsr = INTERRUPTS_IRQ_ISR_191, .u8Level = INTERRUPTS_IRQ_LEVEL_191 },
#endif
#if (INTERRUPTS_IRQ_ISR_192 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_192, .pfnIsr = INTERRUPTS_IRQ_ISR_192, .u8Level = INTERRUPTS_IRQ_LEVEL_192 },
#endif
#if (INTERRUPTS_IRQ_ISR_193 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_193, .pfnIsr = INTERRUPTS_IRQ_ISR_193, .u8Level = INTERRUPTS_IRQ_LEVEL_193 },
#endif
#if (INTERRUPTS_IRQ_ISR_194 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_194, .pfnIsr = INTERRUPTS_IRQ_ISR_194, .u8Level = INTERRUPTS_IRQ_LEVEL_194 },
#endif
#if (INTERRUPTS_IRQ_ISR_195 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_195, .pfnIsr = INTERRUPTS_IRQ_ISR_195, .u8Level = INTERRUPTS_IRQ_LEVEL_195 },
#endif
#if (INTERRUPTS_IRQ_ISR_196 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_196, .pfnIsr = INTERRUPTS_IRQ_ISR_196, .u8Level = INTERRUPTS_IRQ_LEVEL_196 },
#endif
#if (INTERRUPTS_IRQ_ISR_197 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_197, .pfnIsr = INTERRUPTS_IRQ_ISR_197, .u8Level = INTERRUPTS_IRQ_LEVEL_197 },
#endif
#if (INTERRUPTS_IRQ_ISR_198 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_198, .pfnIsr = INTERRUPTS_IRQ_ISR_198, .u8Level = INTERRUPTS_IRQ_LEVEL_198 },
#endif
#if (INTERRUPTS_IRQ_ISR_199 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_199, .pfnIsr = INTERRUPTS_IRQ_ISR_199, .u8Level = INTERRUPTS_IRQ_LEVEL_199 },
#endif
#if (INTERRUPTS_IRQ_ISR_200 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_200, .pfnIsr = INTERRUPTS_IRQ_ISR_200, .u8Level = INTERRUPTS_IRQ_LEVEL_200 },
#endif
#if (INTERRUPTS_IRQ_ISR_201 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_201, .pfnIsr = INTERRUPTS_IRQ_ISR_201, .u8Level = INTERRUPTS_IRQ_LEVEL_201 },
#endif
#if (INTERRUPTS_IRQ_ISR_202 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_202, .pfnIsr = INTERRUPTS_IRQ_ISR_202, .u8Level = INTERRUPTS_IRQ_LEVEL_202 },
#endif
#if (INTERRUPTS_IRQ_ISR_203 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_203, .pfnIsr = INTERRUPTS_IRQ_ISR_203, .u8Level = INTERRUPTS_IRQ_LEVEL_203 },
#endif
#if (INTERRUPTS_IRQ_ISR_204 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_204, .pfnIsr = INTERRUPTS_IRQ_ISR_204, .u8Level = INTERRUPTS_IRQ_LEVEL_204 },
#endif
#if (INTERRUPTS_IRQ_ISR_205 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_205, .pfnIsr = INTERRUPTS_IRQ_ISR_205, .u8Level = INTERRUPTS_IRQ_LEVEL_205 },
#endif
#if (INTERRUPTS_IRQ_ISR_206 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_206, .pfnIsr = INTERRUPTS_IRQ_ISR_206, .u8Level = INTERRUPTS_IRQ_LEVEL_206 },
#endif
#if (INTERRUPTS_IRQ_ISR_207 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_207, .pfnIsr = INTERRUPTS_IRQ_ISR_207, .u8Level = INTERRUPTS_IRQ_LEVEL_207 },
#endif
#if (INTERRUPTS_IRQ_ISR_208 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_208, .pfnIsr = INTERRUPTS_IRQ_ISR_208, .u8Level = INTERRUPTS_IRQ_LEVEL_208 },
#endif
#if (INTERRUPTS_IRQ_ISR_209 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_209, .pfnIsr = INTERRUPTS_IRQ_ISR_209, .u8Level = INTERRUPTS_IRQ_LEVEL_209 },
#endif
#if (INTERRUPTS_IRQ_ISR_210 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_210, .pfnIsr = INTERRUPTS_IRQ_ISR_210, .u8Level = INTERRUPTS_IRQ_LEVEL_210 },
#endif
#if (INTERRUPTS_IRQ_ISR_211 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_211, .pfnIsr = INTERRUPTS_IRQ_ISR_211, .u8Level = INTERRUPTS_IRQ_LEVEL_211 },
#endif
#if (INTERRUPTS_IRQ_ISR_212 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_212, .pfnIsr = INTERRUPTS_IRQ_ISR_212, .u8Level = INTERRUPTS_IRQ_LEVEL_212 },
#endif
#if (INTERRUPTS_IRQ_ISR_213 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_213, .pfnIsr = INTERRUPTS_IRQ_ISR_213, .u8Level = INTERRUPTS_IRQ_LEVEL_213 },
#endif
#if (INTERRUPTS_IRQ_ISR_214 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_214, .pfnIsr = INTERRUPTS_IRQ_ISR_214, .u8Level = INTERRUPTS_IRQ_LEVEL_214 },
#endif
#if (INTERRUPTS_IRQ_ISR_215 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_215, .pfnIsr = INTERRUPTS_IRQ_ISR_215, .u8Level = INTERRUPTS_IRQ_LEVEL_215 },
#endif
#if (INTERRUPTS_IRQ_ISR_216 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_216, .pfnIsr = INTERRUPTS_IRQ_ISR_216, .u8Level = INTERRUPTS_IRQ_LEVEL_216 },
#endif
#if (INTERRUPTS_IRQ_ISR_217 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_217, .pfnIsr = INTERRUPTS_IRQ_ISR_217, .u8Level = INTERRUPTS_IRQ_LEVEL_217 },
#endif
#if (INTERRUPTS_IRQ_ISR_218 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_218, .pfnIsr = INTERRUPTS_IRQ_ISR_218, .u8Level = INTERRUPTS_IRQ_LEVEL_218 },
#endif
#if (INTERRUPTS_IRQ_ISR_219 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_219, .pfnIsr = INTERRUPTS_IRQ_ISR_219, .u8Level = INTERRUPTS_IRQ_LEVEL_219 },
#endif
#if (INTERRUPTS_IRQ_ISR_220 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_220, .pfnIsr = INTERRUPTS_IRQ_ISR_220, .u8Level = INTERRUPTS_IRQ_LEVEL_220 },
#endif
#if (INTERRUPTS_IRQ_ISR_221 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_221, .pfnIsr = INTERRUPTS_IRQ_ISR_221, .u8Level = INTERRUPTS_IRQ_LEVEL_221 },
#endif
#if (INTERRUPTS_IRQ_ISR_222 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_222, .pfnIsr = INTERRUPTS_IRQ_ISR_222, .u8Level = INTERRUPTS_IRQ_LEVEL_222 },
#endif
#if (INTERRUPTS_IRQ_ISR_223 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_223, .pfnIsr = INTERRUPTS_IRQ_ISR_223, .u8Level = INTERRUPTS_IRQ_LEVEL_223 },
#endif
#if (INTERRUPTS_IRQ_ISR_224 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_224, .pfnIsr = INTERRUPTS_IRQ_ISR_224, .u8Level = INTERRUPTS_IRQ_LEVEL_224 },
#endif
#if (INTERRUPTS_IRQ_ISR_225 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_225, .pfnIsr = INTERRUPTS_IRQ_ISR_225, .u8Level = INTERRUPTS_IRQ_LEVEL_225 },
#endif
#if (INTERRUPTS_IRQ_ISR_226 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_226, .pfnIsr = INTERRUPTS_IRQ_ISR_226, .u8Level = INTERRUPTS_IRQ_LEVEL_226 },
#endif
#if (INTERRUPTS_IRQ_ISR_227 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_227, .pfnIsr = INTERRUPTS_IRQ_ISR_227, .u8Level = INTERRUPTS_IRQ_LEVEL_227 },
#endif
#if (INTERRUPTS_IRQ_ISR_228 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_228, .pfnIsr = INTERRUPTS_IRQ_ISR_228, .u8Level = INTERRUPTS_IRQ_LEVEL_228 },
#endif
#if (INTERRUPTS_IRQ_ISR_229 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_229, .pfnIsr = INTERRUPTS_IRQ_ISR_229, .u8Level = INTERRUPTS_IRQ_LEVEL_229 },
#endif
#if (INTERRUPTS_IRQ_ISR_230 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_230, .pfnIsr = INTERRUPTS_IRQ_ISR_230, .u8Level = INTERRUPTS_IRQ_LEVEL_230 },
#endif
#if (INTERRUPTS_IRQ_ISR_231 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_231, .pfnIsr = INTERRUPTS_IRQ_ISR_231, .u8Level = INTERRUPTS_IRQ_LEVEL_231 },
#endif
#if (INTERRUPTS_IRQ_ISR_232 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_232, .pfnIsr = INTERRUPTS_IRQ_ISR_232, .u8Level = INTERRUPTS_IRQ_LEVEL_232 },
#endif
#if (INTERRUPTS_IRQ_ISR_233 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_233, .pfnIsr = INTERRUPTS_IRQ_ISR_233, .u8Level = INTERRUPTS_IRQ_LEVEL_233 },
#endif
#if (INTERRUPTS_IRQ_ISR_234 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_234, .pfnIsr = INTERRUPTS_IRQ_ISR_234, .u8Level = INTERRUPTS_IRQ_LEVEL_234 },
#endif
#if (INTERRUPTS_IRQ_ISR_235 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_235, .pfnIsr = INTERRUPTS_IRQ_ISR_235, .u8Level = INTERRUPTS_IRQ_LEVEL_235 },
#endif
#if (INTERRUPTS_IRQ_ISR_236 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_236, .pfnIsr = INTERRUPTS_IRQ_ISR_236, .u8Level = INTERRUPTS_IRQ_LEVEL_236 },
#endif
#if (INTERRUPTS_IRQ_ISR_237 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_237, .pfnIsr = INTERRUPTS_IRQ_ISR_237, .u8Level = INTERRUPTS_IRQ_LEVEL_237 },
#endif
#if (INTERRUPTS_IRQ_ISR_238 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_238, .pfnIsr = INTERRUPTS_IRQ_ISR_238, .u8Level = INTERRUPTS_IRQ_LEVEL_238 },
#endif
#if (INTERRUPTS_IRQ_ISR_239 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_239, .pfnIsr = INTERRUPTS_IRQ_ISR_239, .u8Level = INTERRUPTS_IRQ_LEVEL_239 },
#endif
#if (INTERRUPTS_IRQ_ISR_240 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_240, .pfnIsr = INTERRUPTS_IRQ_ISR_240, .u8Level = INTERRUPTS_IRQ_LEVEL_240 },
#endif
#if (INTERRUPTS_IRQ_ISR_241 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_241, .pfnIsr = INTERRUPTS_IRQ_ISR_241, .u8Level = INTERRUPTS_IRQ_LEVEL_241 },
#endif
#if (INTERRUPTS_IRQ_ISR_242 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_242, .pfnIsr = INTERRUPTS_IRQ_ISR_242, .u8Level = INTERRUPTS_IRQ_LEVEL_242 },
#endif
#if (INTERRUPTS_IRQ_ISR_243 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_243, .pfnIsr = INTERRUPTS_IRQ_ISR_243, .u8Level = INTERRUPTS_IRQ_LEVEL_243 },
#endif
#if (INTERRUPTS_IRQ_ISR_244 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_244, .pfnIsr = INTERRUPTS_IRQ_ISR_244, .u8Level = INTERRUPTS_IRQ_LEVEL_244 },
#endif
#if (INTERRUPTS_IRQ_ISR_245 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_245, .pfnIsr = INTERRUPTS_IRQ_ISR_245, .u8Level = INTERRUPTS_IRQ_LEVEL_245 },
#endif
#if (INTERRUPTS_IRQ_ISR_246 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_246, .pfnIsr = INTERRUPTS_IRQ_ISR_246, .u8Level = INTERRUPTS_IRQ_LEVEL_246 },
#endif
#if (INTERRUPTS_IRQ_ISR_247 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_247, .pfnIsr = INTERRUPTS_IRQ_ISR_247, .u8Level = INTERRUPTS_IRQ_LEVEL_247 },
#endif
#if (INTERRUPTS_IRQ_ISR_248 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_248, .pfnIsr = INTERRUPTS_IRQ_ISR_248, .u8Level = INTERRUPTS_IRQ_LEVEL_248 },
#endif
#if (INTERRUPTS_IRQ_ISR_249 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_249, .pfnIsr = INTERRUPTS_IRQ_ISR_249, .u8Level = INTERRUPTS_IRQ_LEVEL_249 },
#endif
#if (INTERRUPTS_IRQ_ISR_250 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_250, .pfnIsr = INTERRUPTS_IRQ_ISR_250, .u8Level = INTERRUPTS_IRQ_LEVEL_250 },
#endif
#if (INTERRUPTS_IRQ_ISR_251 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_251, .pfnIsr = INTERRUPTS_IRQ_ISR_251, .u8Level = INTERRUPTS_IRQ_LEVEL_251 },
#endif
#if (INTERRUPTS_IRQ_ISR_252 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_252, .pfnIsr = INTERRUPTS_IRQ_ISR_252, .u8Level = INTERRUPTS_IRQ_LEVEL_252 },
#endif
#if (INTERRUPTS_IRQ_ISR_253 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_253, .pfnIsr = INTERRUPTS_IRQ_ISR_253, .u8Level = INTERRUPTS_IRQ_LEVEL_253 },
#endif
#if (INTERRUPTS_IRQ_ISR_254 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_254, .pfnIsr = INTERRUPTS_IRQ_ISR_254, .u8Level = INTERRUPTS_IRQ_LEVEL_254 },
#endif
#if (INTERRUPTS_IRQ_ISR_255 != INTERRUPTS_IRQ_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_IRQ_NUMBER_255, .pfnIsr = INTERRUPTS_IRQ_ISR_255, .u8Level = INTERRUPTS_IRQ_LEVEL_255 },
#endif
};


/** Table of all user specific NMI vectors */
const stc_nmi_vector_entry_t m_astcUserNmiTable[] =
{
    {  .u16Channel = 0, .pfnIsr = DefaultNmiHandler, .u8Level = 15 },          // Dummy entry (in case no user specific ISR is assigned)
#if (INTERRUPTS_NMI_ISR_0 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_0, .pfnIsr = INTERRUPTS_NMI_ISR_0, .u8Level = INTERRUPTS_NMI_LEVEL_0 },
#endif
#if (INTERRUPTS_NMI_ISR_1 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_1, .pfnIsr = INTERRUPTS_NMI_ISR_1, .u8Level = INTERRUPTS_NMI_LEVEL_1 },
#endif
#if (INTERRUPTS_NMI_ISR_2 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_2, .pfnIsr = INTERRUPTS_NMI_ISR_2, .u8Level = INTERRUPTS_NMI_LEVEL_2 },
#endif
#if (INTERRUPTS_NMI_ISR_3 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_3, .pfnIsr = INTERRUPTS_NMI_ISR_3, .u8Level = INTERRUPTS_NMI_LEVEL_3 },
#endif
#if (INTERRUPTS_NMI_ISR_4 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_4, .pfnIsr = INTERRUPTS_NMI_ISR_4, .u8Level = INTERRUPTS_NMI_LEVEL_4 },
#endif
#if (INTERRUPTS_NMI_ISR_5 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_5, .pfnIsr = INTERRUPTS_NMI_ISR_5, .u8Level = INTERRUPTS_NMI_LEVEL_5 },
#endif
#if (INTERRUPTS_NMI_ISR_6 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_6, .pfnIsr = INTERRUPTS_NMI_ISR_6, .u8Level = INTERRUPTS_NMI_LEVEL_6 },
#endif
#if (INTERRUPTS_NMI_ISR_7 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_7, .pfnIsr = INTERRUPTS_NMI_ISR_7, .u8Level = INTERRUPTS_NMI_LEVEL_7 },
#endif
#if (INTERRUPTS_NMI_ISR_8 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_8, .pfnIsr = INTERRUPTS_NMI_ISR_8, .u8Level = INTERRUPTS_NMI_LEVEL_8 },
#endif
#if (INTERRUPTS_NMI_ISR_9 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_9, .pfnIsr = INTERRUPTS_NMI_ISR_9, .u8Level = INTERRUPTS_NMI_LEVEL_9 },
#endif
#if (INTERRUPTS_NMI_ISR_10 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_10, .pfnIsr = INTERRUPTS_NMI_ISR_10, .u8Level = INTERRUPTS_NMI_LEVEL_10 },
#endif
#if (INTERRUPTS_NMI_ISR_11 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_11, .pfnIsr = INTERRUPTS_NMI_ISR_11, .u8Level = INTERRUPTS_NMI_LEVEL_11 },
#endif
#if (INTERRUPTS_NMI_ISR_12 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_12, .pfnIsr = INTERRUPTS_NMI_ISR_12, .u8Level = INTERRUPTS_NMI_LEVEL_12 },
#endif
#if (INTERRUPTS_NMI_ISR_13 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_13, .pfnIsr = INTERRUPTS_NMI_ISR_13, .u8Level = INTERRUPTS_NMI_LEVEL_13 },
#endif
#if (INTERRUPTS_NMI_ISR_14 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_14, .pfnIsr = INTERRUPTS_NMI_ISR_14, .u8Level = INTERRUPTS_NMI_LEVEL_14 },
#endif
#if (INTERRUPTS_NMI_ISR_15 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_15, .pfnIsr = INTERRUPTS_NMI_ISR_15, .u8Level = INTERRUPTS_NMI_LEVEL_15 },
#endif
#if (INTERRUPTS_NMI_ISR_16 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_16, .pfnIsr = INTERRUPTS_NMI_ISR_16, .u8Level = INTERRUPTS_NMI_LEVEL_16 },
#endif
#if (INTERRUPTS_NMI_ISR_17 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_17, .pfnIsr = INTERRUPTS_NMI_ISR_17, .u8Level = INTERRUPTS_NMI_LEVEL_17 },
#endif
#if (INTERRUPTS_NMI_ISR_18 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_18, .pfnIsr = INTERRUPTS_NMI_ISR_18, .u8Level = INTERRUPTS_NMI_LEVEL_18 },
#endif
#if (INTERRUPTS_NMI_ISR_19 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_19, .pfnIsr = INTERRUPTS_NMI_ISR_19, .u8Level = INTERRUPTS_NMI_LEVEL_19 },
#endif
#if (INTERRUPTS_NMI_ISR_20 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_20, .pfnIsr = INTERRUPTS_NMI_ISR_20, .u8Level = INTERRUPTS_NMI_LEVEL_20 },
#endif
#if (INTERRUPTS_NMI_ISR_21 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_21, .pfnIsr = INTERRUPTS_NMI_ISR_21, .u8Level = INTERRUPTS_NMI_LEVEL_21 },
#endif
#if (INTERRUPTS_NMI_ISR_22 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_22, .pfnIsr = INTERRUPTS_NMI_ISR_22, .u8Level = INTERRUPTS_NMI_LEVEL_22 },
#endif
#if (INTERRUPTS_NMI_ISR_23 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_23, .pfnIsr = INTERRUPTS_NMI_ISR_23, .u8Level = INTERRUPTS_NMI_LEVEL_23 },
#endif
#if (INTERRUPTS_NMI_ISR_24 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_24, .pfnIsr = INTERRUPTS_NMI_ISR_24, .u8Level = INTERRUPTS_NMI_LEVEL_24 },
#endif
#if (INTERRUPTS_NMI_ISR_25 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_25, .pfnIsr = INTERRUPTS_NMI_ISR_25, .u8Level = INTERRUPTS_NMI_LEVEL_25 },
#endif
#if (INTERRUPTS_NMI_ISR_26 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_26, .pfnIsr = INTERRUPTS_NMI_ISR_26, .u8Level = INTERRUPTS_NMI_LEVEL_26 },
#endif
#if (INTERRUPTS_NMI_ISR_27 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_27, .pfnIsr = INTERRUPTS_NMI_ISR_27, .u8Level = INTERRUPTS_NMI_LEVEL_27 },
#endif
#if (INTERRUPTS_NMI_ISR_28 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_28, .pfnIsr = INTERRUPTS_NMI_ISR_28, .u8Level = INTERRUPTS_NMI_LEVEL_28 },
#endif
#if (INTERRUPTS_NMI_ISR_29 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_29, .pfnIsr = INTERRUPTS_NMI_ISR_29, .u8Level = INTERRUPTS_NMI_LEVEL_29 },
#endif
#if (INTERRUPTS_NMI_ISR_30 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_30, .pfnIsr = INTERRUPTS_NMI_ISR_30, .u8Level = INTERRUPTS_NMI_LEVEL_30 },
#endif
#if (INTERRUPTS_NMI_ISR_31 != INTERRUPTS_NMI_DEFAULT_HANDLER)
    { .u16Channel = INTERRUPTS_NMI_NUMBER_31, .pfnIsr = INTERRUPTS_NMI_ISR_31, .u8Level = INTERRUPTS_NMI_LEVEL_31 },
#endif
};

#ifdef __TOOLCHAIN_IAR__
    #pragma diag_default=Pe193 // restore default behaviour for specific diag
#endif

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Initialize all entries in interrupt vector table for NMI support.
 **
 ** If an user defined interrupt service routine is assigned to an NMI
 ** vector (INTERRUPTS_NMI_ISR_??? != INTERRUPTS_NMI_DEFAULT_HANDLER), this function
 ** and the corresponding priority level (INTERRUPTS_NMI_nn_LEVEL_???) is set for the
 ** appropriate entry in the Interrupt Controller, which will be enabled finally.
 ** 
 ** If the default handler should be used (INTERRUPTS_NMI_ISR_??? == INTERRUPTS_NMI_DEFAULT_HANDLER)
 ** the appropriate vector is set to the DefaultNmiHandler().
 **
 ** \note There is no check of the vector addresses and priority levels!
 **       Please take care to define valid values in interrupts.h.
 **
 ** \pre Must be in system mode
 **
 ******************************************************************************/
void Interrupts_InitNmi(void)
{
    uint_fast16_t fu16Index;
    uint_fast16_t fu16Channel;
    uint_fast16_t fu16Level;
    uint_fast16_t fu16GroupIndex;

    volatile un_irc0_nmivan_t*  aunNmiVectorAddress = &IRC0.unNMIVA0;
    volatile un_irc0_nmipl0_t*  aunNmiPriorityLevel = &IRC0.unNMIPL0;

    // Unlock Interrupt Controller for write access
    UnlockIntCtrl();

    //------------------------------------------------------------------
    //  Set default handlers and lowest priority levels
    //------------------------------------------------------------------

    // Set default NMI handler for each available NMI vector
    for (fu16Channel = 0; fu16Channel < NMI_CHANNEL_COUNT; fu16Channel++)
    {
        // Set default handler
        aunNmiVectorAddress[fu16Channel].u32Register = (uint32_t)DefaultNmiHandler;
    }

    //------------------------------------------------------------------
    //  Set user specific ISRs and priority levels
    //------------------------------------------------------------------
    
    // Set user specific ISRs and levels for appropriate NMIs
    // (skip index 0 as this is the dummy entry)
    for (fu16Index = 1; fu16Index < USER_NMI_COUNT; fu16Index++)
    {
        fu16Channel = m_astcUserNmiTable[fu16Index].u16Channel;
        fu16Level   = m_astcUserNmiTable[fu16Index].u8Level;
        
        // Set user specific ISR
        aunNmiVectorAddress[fu16Channel].u32Register = (uint32_t)m_astcUserNmiTable[fu16Index].pfnIsr;

        // Set user specific priority level
        fu16GroupIndex = fu16Channel / NMI_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT;
        switch (fu16Channel % NMI_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT)
        {
            case 0:
                aunNmiPriorityLevel[fu16GroupIndex].stcField.u4NMIPL0 = fu16Level ;
                break ;
            case 1:
                aunNmiPriorityLevel[fu16GroupIndex].stcField.u4NMIPL1 = fu16Level ;
                break ;
            case 2:
                aunNmiPriorityLevel[fu16GroupIndex].stcField.u4NMIPL2 = fu16Level ;
                break ;
            case 3:
                aunNmiPriorityLevel[fu16GroupIndex].stcField.u4NMIPL3 = fu16Level ;
                break ;
            default:
                break ;
        }
    }

    // Finally lock Interrupt Controller
    LockIntCtrl();
}

/**
 ******************************************************************************
 ** \brief Initialize all entries in interrupt vector table for IRQ support.
 **
 ** If an user defined interrupt service routine is assigned to an interrupt
 ** vector (INTERRUPTS_IRQ_ISR_??? != INTERRUPTS_IRQ_DEFAULT_HANDLER), this function
 ** and the corresponding priority level (INTERRUPTS_IRQ_nn_LEVEL_???) is set for the
 ** appropriate entry in the Interrupt Controller, which will be enabled finally.
 ** 
 ** If the default handler should be used (INTERRUPTS_IRQ_ISR_??? == DefaultIrqHandler)
 ** the appropriate vector is set to the DefaultIrqHandler() with lowest priority
 ** level (31).
 **
 ** \note There is no check of the vector addresses and priority levels!
 **       Please take care to define valid values in interrupts.h.
 **
 ** \pre Must be in system mode
 **
 ******************************************************************************/
void Interrupts_InitIrq(void)
{
    uint_fast16_t fu16Index;
    uint_fast16_t fu16Channel;
    uint_fast8_t  fu8Level;
    uint_fast16_t fu16GroupIndex;

    volatile un_irc0_irqvan_t*  aunIrqVectorAddress      = &IRC0.unIRQVA0;
    volatile un_irc0_irqpl0_t*  aunIrqPriorityLevel      = (volatile un_irc0_irqpl0_t*)&IRC0.unIRQPL0;  // take un_irqn_irqpl8_t as this structure provides all IRQPL0...3
    volatile un_irc0_irqces0_t* aunIrqChannelEnableSet   = &IRC0.unIRQCES0;

    // Unlock Interrupt Controller for write access
    UnlockIntCtrl();

    //------------------------------------------------------------------
    //  Set default handlers and lowest priority levels
    //------------------------------------------------------------------

    // Set default IRQ handler for whole vector address RAM
    for (fu16Channel = 0; fu16Channel < IRQ_CHANNEL_COUNT; fu16Channel++)
    {
        // Set default handler
        aunIrqVectorAddress[fu16Channel].u32Register = (uint32_t)DefaultIrqHandler;
    }

    //------------------------------------------------------------------
    //  Set user specific ISRs and priority levels
    //------------------------------------------------------------------
    
    // Set user specific ISRs and levels for appropriate IRQs
    // (skip index 0 as this is the dummy entry)
    for (fu16Index = 1; fu16Index < USER_IRQ_COUNT; fu16Index++)
    {
        fu16Channel = m_astcUserIrqTable[fu16Index].u16Channel;
        fu8Level   = m_astcUserIrqTable[fu16Index].u8Level;
        
        // Set user specific ISR
        aunIrqVectorAddress[fu16Channel].u32Register = (uint32_t)m_astcUserIrqTable[fu16Index].pfnIsr;
        
        // Set user specific priority level (byte array in type is used to avoid RMW accesses)
        fu16GroupIndex = fu16Channel / IRQ_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT;
        switch (fu16Channel % IRQ_PRIORITY_LEVEL_REGISTER_CHANNEL_COUNT)
        {
            case 0:
                aunIrqPriorityLevel[fu16GroupIndex].au8Byte[0] = fu8Level;
                break;

            case 1:
                aunIrqPriorityLevel[fu16GroupIndex].au8Byte[1] = fu8Level;
                break;

            case 2:
                aunIrqPriorityLevel[fu16GroupIndex].au8Byte[2] = fu8Level;
                break;

            case 3:
                aunIrqPriorityLevel[fu16GroupIndex].au8Byte[3] = fu8Level;
                break;

            default:
                break;
        }
        
        // Enable IRQ channel
        fu16GroupIndex = fu16Channel / IRQ_ENABLE_REGISTER_CHANNEL_COUNT;
        aunIrqChannelEnableSet[fu16GroupIndex].u32Register = 1 << (fu16Channel % IRQ_ENABLE_REGISTER_CHANNEL_COUNT);
    }

    // Enable IRQs in Interrupt Controller
    IRC0.unCSR.stcField = (stc_irc0_csr_field_t) { .u1IRQEN = 1 };    
    // Finally lock Interrupt Controller
    LockIntCtrl();
}

/**
 ******************************************************************************
 ** \brief Default IRQ handler 
 **
 ** Default interrupt handler used for IRQ vectors which are not
 ** assigned to user specific interrupt service routines.
 **
 ******************************************************************************/
static FN_IRQ_NOT_NESTED void DefaultIrqHandler(void)
{
    // Current mode: Interrupt mode using interrupt stack
    // (not-nested interrupt!)

    while (1)
    {
        // wait for HWWD reset
        // or implement user handler
    }

    // If the ISR should be left, add the IRQ specific exit sequence
}

/**
 ******************************************************************************
 ** \brief Default NMI handler 
 **
 ** Default non-maskable interrupt handler used for NMI vectors which are not
 ** assigned to user specific interrupt service routines.
 **
 ******************************************************************************/
static FN_NMI void DefaultNmiHandler(void)
{
    // Current mode: FIQ mode using FIQ stack
    // (not-nested interrupt!)
    
    while (1)
    {
        // wait for HWWD reset
        // or implement user handler
    }

    // If the ISR should be left, add the IRQ specific exit sequence
}

/**
 ******************************************************************************
 ** \brief Unlock the Interrupt Controller
 **
 ** \pre Must be in system mode
 **
 ** \return None
 ******************************************************************************/
static void UnlockIntCtrl(void)
{
    // Write unlock key
    IRC0_UNLOCK = INTERRUPTS_INT_CTRL_KEY_UNLOCK;
}

/**
 ******************************************************************************
 ** \brief Lock Interrupt Controller
 **
 ** \pre Must be in system mode
 **
 ** \return None
 ******************************************************************************/
static void LockIntCtrl(void)
{
    // Write lock key
    IRC0_UNLOCK = INTERRUPTS_INT_CTRL_KEY_LOCK;
}

#endif /* __FILE_VERSION_CHECK__ */
