/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MODEC_H
#define __S6J3360_MODEC_H

#include "s6j3360io_basetypes.h"

/* MODEC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define MODEC	stcMODEC
#else /* __IO_DEFINE */
#define MODEC	(*((volatile stc_modec_t*)0xB0600800))
#endif /* __IO_DEFINE */

/* MODER */
#define MODEC_MODER	(MODEC.unMODER.u32Register)  /*@rg@*/
#define MODEC_MODER_MD	(*(volatile uint_io8_t*)0xB080400C)  /*@bfbba@*/
#define MODEC_MODER_USERMODE	(*(volatile uint_io8_t*)0xB080401F)  /*@bfbba@*/

typedef struct stc_modec_moder_field{
    uint_io32_t		:12;
    uint_io32_t		u1MD:1;
    uint_io32_t		:18;
    uint_io32_t		u1USERMODE:1;
}stc_modec_moder_field_t;

typedef union un_modec_moder{
    uint_io32_t		u32Register;
    stc_modec_moder_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_modec_moder_t;


typedef struct stc_modec{
    un_modec_moder_t	unMODER;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[47100];	/* 0x00000004 */
}stc_modec_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_modec_t	stcMODEC;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 47104(0xb800) bytes */


#endif /* __S6J3360_MODEC_H */
