/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PPC_H
#define __S6J3360_PPC_H

#include "s6j3360io_basetypes.h"

/* PPC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define PPC	stcPPC
#else /* __IO_DEFINE */
#define PPC	(*((volatile stc_ppc_t*)0xB4740000))
#endif /* __IO_DEFINE */

/* PCFGR[000-031/100-131/200-231/300-331] */
#define PPC_PCFGR000	(PPC.unPCFGR000.u16Register)  /*@rg@*/
#define PPC_PCFGR000_POF	(PPC.unPCFGR000.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR000_NFE	(*(volatile uint_io8_t*)0xB7200005)  /*@bfbba@*/
#define PPC_PCFGR000_ODR	(PPC.unPCFGR000.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR000_PDE	(*(volatile uint_io8_t*)0xB7200008)  /*@bfbba@*/
#define PPC_PCFGR000_PUE	(*(volatile uint_io8_t*)0xB7200009)  /*@bfbba@*/
#define PPC_PCFGR000_PIL	(PPC.unPCFGR000.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR000_PIE	(*(volatile uint_io8_t*)0xB720000C)  /*@bfbba@*/
#define PPC_PCFGR000_PID	(*(volatile uint_io8_t*)0xB720000D)  /*@bfbba@*/
#define PPC_PCFGR000_POD	(*(volatile uint_io8_t*)0xB720000E)  /*@bfbba@*/
#define PPC_PCFGR000_POE	(*(volatile uint_io8_t*)0xB720000F)  /*@bfbba@*/

#define PPC_PCFGR001	(PPC.unPCFGR001.u16Register)  /*@rg@*/
#define PPC_PCFGR001_POF	(PPC.unPCFGR001.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR001_NFE	(*(volatile uint_io8_t*)0xB7200015)  /*@bfbba@*/
#define PPC_PCFGR001_ODR	(PPC.unPCFGR001.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR001_PDE	(*(volatile uint_io8_t*)0xB7200018)  /*@bfbba@*/
#define PPC_PCFGR001_PUE	(*(volatile uint_io8_t*)0xB7200019)  /*@bfbba@*/
#define PPC_PCFGR001_PIL	(PPC.unPCFGR001.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR001_PIE	(*(volatile uint_io8_t*)0xB720001C)  /*@bfbba@*/
#define PPC_PCFGR001_PID	(*(volatile uint_io8_t*)0xB720001D)  /*@bfbba@*/
#define PPC_PCFGR001_POD	(*(volatile uint_io8_t*)0xB720001E)  /*@bfbba@*/
#define PPC_PCFGR001_POE	(*(volatile uint_io8_t*)0xB720001F)  /*@bfbba@*/

#define PPC_PCFGR002	(PPC.unPCFGR002.u16Register)  /*@rg@*/
#define PPC_PCFGR002_POF	(PPC.unPCFGR002.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR002_NFE	(*(volatile uint_io8_t*)0xB7200025)  /*@bfbba@*/
#define PPC_PCFGR002_ODR	(PPC.unPCFGR002.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR002_PDE	(*(volatile uint_io8_t*)0xB7200028)  /*@bfbba@*/
#define PPC_PCFGR002_PUE	(*(volatile uint_io8_t*)0xB7200029)  /*@bfbba@*/
#define PPC_PCFGR002_PIL	(PPC.unPCFGR002.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR002_PIE	(*(volatile uint_io8_t*)0xB720002C)  /*@bfbba@*/
#define PPC_PCFGR002_PID	(*(volatile uint_io8_t*)0xB720002D)  /*@bfbba@*/
#define PPC_PCFGR002_POD	(*(volatile uint_io8_t*)0xB720002E)  /*@bfbba@*/
#define PPC_PCFGR002_POE	(*(volatile uint_io8_t*)0xB720002F)  /*@bfbba@*/

#define PPC_PCFGR003	(PPC.unPCFGR003.u16Register)  /*@rg@*/
#define PPC_PCFGR003_POF	(PPC.unPCFGR003.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR003_NFE	(*(volatile uint_io8_t*)0xB7200035)  /*@bfbba@*/
#define PPC_PCFGR003_ODR	(PPC.unPCFGR003.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR003_PDE	(*(volatile uint_io8_t*)0xB7200038)  /*@bfbba@*/
#define PPC_PCFGR003_PUE	(*(volatile uint_io8_t*)0xB7200039)  /*@bfbba@*/
#define PPC_PCFGR003_PIL	(PPC.unPCFGR003.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR003_PIE	(*(volatile uint_io8_t*)0xB720003C)  /*@bfbba@*/
#define PPC_PCFGR003_PID	(*(volatile uint_io8_t*)0xB720003D)  /*@bfbba@*/
#define PPC_PCFGR003_POD	(*(volatile uint_io8_t*)0xB720003E)  /*@bfbba@*/
#define PPC_PCFGR003_POE	(*(volatile uint_io8_t*)0xB720003F)  /*@bfbba@*/

#define PPC_PCFGR004	(PPC.unPCFGR004.u16Register)  /*@rg@*/
#define PPC_PCFGR004_POF	(PPC.unPCFGR004.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR004_NFE	(*(volatile uint_io8_t*)0xB7200045)  /*@bfbba@*/
#define PPC_PCFGR004_ODR	(PPC.unPCFGR004.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR004_PDE	(*(volatile uint_io8_t*)0xB7200048)  /*@bfbba@*/
#define PPC_PCFGR004_PUE	(*(volatile uint_io8_t*)0xB7200049)  /*@bfbba@*/
#define PPC_PCFGR004_PIL	(PPC.unPCFGR004.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR004_PIE	(*(volatile uint_io8_t*)0xB720004C)  /*@bfbba@*/
#define PPC_PCFGR004_PID	(*(volatile uint_io8_t*)0xB720004D)  /*@bfbba@*/
#define PPC_PCFGR004_POD	(*(volatile uint_io8_t*)0xB720004E)  /*@bfbba@*/
#define PPC_PCFGR004_POE	(*(volatile uint_io8_t*)0xB720004F)  /*@bfbba@*/

#define PPC_PCFGR005	(PPC.unPCFGR005.u16Register)  /*@rg@*/
#define PPC_PCFGR005_POF	(PPC.unPCFGR005.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR005_NFE	(*(volatile uint_io8_t*)0xB7200055)  /*@bfbba@*/
#define PPC_PCFGR005_ODR	(PPC.unPCFGR005.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR005_PDE	(*(volatile uint_io8_t*)0xB7200058)  /*@bfbba@*/
#define PPC_PCFGR005_PUE	(*(volatile uint_io8_t*)0xB7200059)  /*@bfbba@*/
#define PPC_PCFGR005_PIL	(PPC.unPCFGR005.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR005_PIE	(*(volatile uint_io8_t*)0xB720005C)  /*@bfbba@*/
#define PPC_PCFGR005_PID	(*(volatile uint_io8_t*)0xB720005D)  /*@bfbba@*/
#define PPC_PCFGR005_POD	(*(volatile uint_io8_t*)0xB720005E)  /*@bfbba@*/
#define PPC_PCFGR005_POE	(*(volatile uint_io8_t*)0xB720005F)  /*@bfbba@*/

#define PPC_PCFGR006	(PPC.unPCFGR006.u16Register)  /*@rg@*/
#define PPC_PCFGR006_POF	(PPC.unPCFGR006.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR006_NFE	(*(volatile uint_io8_t*)0xB7200065)  /*@bfbba@*/
#define PPC_PCFGR006_ODR	(PPC.unPCFGR006.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR006_PDE	(*(volatile uint_io8_t*)0xB7200068)  /*@bfbba@*/
#define PPC_PCFGR006_PUE	(*(volatile uint_io8_t*)0xB7200069)  /*@bfbba@*/
#define PPC_PCFGR006_PIL	(PPC.unPCFGR006.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR006_PIE	(*(volatile uint_io8_t*)0xB720006C)  /*@bfbba@*/
#define PPC_PCFGR006_PID	(*(volatile uint_io8_t*)0xB720006D)  /*@bfbba@*/
#define PPC_PCFGR006_POD	(*(volatile uint_io8_t*)0xB720006E)  /*@bfbba@*/
#define PPC_PCFGR006_POE	(*(volatile uint_io8_t*)0xB720006F)  /*@bfbba@*/

#define PPC_PCFGR007	(PPC.unPCFGR007.u16Register)  /*@rg@*/
#define PPC_PCFGR007_POF	(PPC.unPCFGR007.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR007_NFE	(*(volatile uint_io8_t*)0xB7200075)  /*@bfbba@*/
#define PPC_PCFGR007_ODR	(PPC.unPCFGR007.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR007_PDE	(*(volatile uint_io8_t*)0xB7200078)  /*@bfbba@*/
#define PPC_PCFGR007_PUE	(*(volatile uint_io8_t*)0xB7200079)  /*@bfbba@*/
#define PPC_PCFGR007_PIL	(PPC.unPCFGR007.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR007_PIE	(*(volatile uint_io8_t*)0xB720007C)  /*@bfbba@*/
#define PPC_PCFGR007_PID	(*(volatile uint_io8_t*)0xB720007D)  /*@bfbba@*/
#define PPC_PCFGR007_POD	(*(volatile uint_io8_t*)0xB720007E)  /*@bfbba@*/
#define PPC_PCFGR007_POE	(*(volatile uint_io8_t*)0xB720007F)  /*@bfbba@*/

#define PPC_PCFGR008	(PPC.unPCFGR008.u16Register)  /*@rg@*/
#define PPC_PCFGR008_POF	(PPC.unPCFGR008.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR008_NFE	(*(volatile uint_io8_t*)0xB7200085)  /*@bfbba@*/
#define PPC_PCFGR008_ODR	(PPC.unPCFGR008.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR008_PDE	(*(volatile uint_io8_t*)0xB7200088)  /*@bfbba@*/
#define PPC_PCFGR008_PUE	(*(volatile uint_io8_t*)0xB7200089)  /*@bfbba@*/
#define PPC_PCFGR008_PIL	(PPC.unPCFGR008.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR008_PIE	(*(volatile uint_io8_t*)0xB720008C)  /*@bfbba@*/
#define PPC_PCFGR008_PID	(*(volatile uint_io8_t*)0xB720008D)  /*@bfbba@*/
#define PPC_PCFGR008_POD	(*(volatile uint_io8_t*)0xB720008E)  /*@bfbba@*/
#define PPC_PCFGR008_POE	(*(volatile uint_io8_t*)0xB720008F)  /*@bfbba@*/

#define PPC_PCFGR009	(PPC.unPCFGR009.u16Register)  /*@rg@*/
#define PPC_PCFGR009_POF	(PPC.unPCFGR009.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR009_NFE	(*(volatile uint_io8_t*)0xB7200095)  /*@bfbba@*/
#define PPC_PCFGR009_ODR	(PPC.unPCFGR009.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR009_PDE	(*(volatile uint_io8_t*)0xB7200098)  /*@bfbba@*/
#define PPC_PCFGR009_PUE	(*(volatile uint_io8_t*)0xB7200099)  /*@bfbba@*/
#define PPC_PCFGR009_PIL	(PPC.unPCFGR009.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR009_PIE	(*(volatile uint_io8_t*)0xB720009C)  /*@bfbba@*/
#define PPC_PCFGR009_PID	(*(volatile uint_io8_t*)0xB720009D)  /*@bfbba@*/
#define PPC_PCFGR009_POD	(*(volatile uint_io8_t*)0xB720009E)  /*@bfbba@*/
#define PPC_PCFGR009_POE	(*(volatile uint_io8_t*)0xB720009F)  /*@bfbba@*/

#define PPC_PCFGR010	(PPC.unPCFGR010.u16Register)  /*@rg@*/
#define PPC_PCFGR010_POF	(PPC.unPCFGR010.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR010_NFE	(*(volatile uint_io8_t*)0xB72000A5)  /*@bfbba@*/
#define PPC_PCFGR010_ODR	(PPC.unPCFGR010.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR010_PDE	(*(volatile uint_io8_t*)0xB72000A8)  /*@bfbba@*/
#define PPC_PCFGR010_PUE	(*(volatile uint_io8_t*)0xB72000A9)  /*@bfbba@*/
#define PPC_PCFGR010_PIL	(PPC.unPCFGR010.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR010_PIE	(*(volatile uint_io8_t*)0xB72000AC)  /*@bfbba@*/
#define PPC_PCFGR010_PID	(*(volatile uint_io8_t*)0xB72000AD)  /*@bfbba@*/
#define PPC_PCFGR010_POD	(*(volatile uint_io8_t*)0xB72000AE)  /*@bfbba@*/
#define PPC_PCFGR010_POE	(*(volatile uint_io8_t*)0xB72000AF)  /*@bfbba@*/

#define PPC_PCFGR011	(PPC.unPCFGR011.u16Register)  /*@rg@*/
#define PPC_PCFGR011_POF	(PPC.unPCFGR011.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR011_NFE	(*(volatile uint_io8_t*)0xB72000B5)  /*@bfbba@*/
#define PPC_PCFGR011_ODR	(PPC.unPCFGR011.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR011_PDE	(*(volatile uint_io8_t*)0xB72000B8)  /*@bfbba@*/
#define PPC_PCFGR011_PUE	(*(volatile uint_io8_t*)0xB72000B9)  /*@bfbba@*/
#define PPC_PCFGR011_PIL	(PPC.unPCFGR011.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR011_PIE	(*(volatile uint_io8_t*)0xB72000BC)  /*@bfbba@*/
#define PPC_PCFGR011_PID	(*(volatile uint_io8_t*)0xB72000BD)  /*@bfbba@*/
#define PPC_PCFGR011_POD	(*(volatile uint_io8_t*)0xB72000BE)  /*@bfbba@*/
#define PPC_PCFGR011_POE	(*(volatile uint_io8_t*)0xB72000BF)  /*@bfbba@*/

#define PPC_PCFGR012	(PPC.unPCFGR012.u16Register)  /*@rg@*/
#define PPC_PCFGR012_POF	(PPC.unPCFGR012.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR012_NFE	(*(volatile uint_io8_t*)0xB72000C5)  /*@bfbba@*/
#define PPC_PCFGR012_ODR	(PPC.unPCFGR012.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR012_PDE	(*(volatile uint_io8_t*)0xB72000C8)  /*@bfbba@*/
#define PPC_PCFGR012_PUE	(*(volatile uint_io8_t*)0xB72000C9)  /*@bfbba@*/
#define PPC_PCFGR012_PIL	(PPC.unPCFGR012.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR012_PIE	(*(volatile uint_io8_t*)0xB72000CC)  /*@bfbba@*/
#define PPC_PCFGR012_PID	(*(volatile uint_io8_t*)0xB72000CD)  /*@bfbba@*/
#define PPC_PCFGR012_POD	(*(volatile uint_io8_t*)0xB72000CE)  /*@bfbba@*/
#define PPC_PCFGR012_POE	(*(volatile uint_io8_t*)0xB72000CF)  /*@bfbba@*/

#define PPC_PCFGR013	(PPC.unPCFGR013.u16Register)  /*@rg@*/
#define PPC_PCFGR013_POF	(PPC.unPCFGR013.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR013_NFE	(*(volatile uint_io8_t*)0xB72000D5)  /*@bfbba@*/
#define PPC_PCFGR013_ODR	(PPC.unPCFGR013.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR013_PDE	(*(volatile uint_io8_t*)0xB72000D8)  /*@bfbba@*/
#define PPC_PCFGR013_PUE	(*(volatile uint_io8_t*)0xB72000D9)  /*@bfbba@*/
#define PPC_PCFGR013_PIL	(PPC.unPCFGR013.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR013_PIE	(*(volatile uint_io8_t*)0xB72000DC)  /*@bfbba@*/
#define PPC_PCFGR013_PID	(*(volatile uint_io8_t*)0xB72000DD)  /*@bfbba@*/
#define PPC_PCFGR013_POD	(*(volatile uint_io8_t*)0xB72000DE)  /*@bfbba@*/
#define PPC_PCFGR013_POE	(*(volatile uint_io8_t*)0xB72000DF)  /*@bfbba@*/

#define PPC_PCFGR014	(PPC.unPCFGR014.u16Register)  /*@rg@*/
#define PPC_PCFGR014_POF	(PPC.unPCFGR014.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR014_NFE	(*(volatile uint_io8_t*)0xB72000E5)  /*@bfbba@*/
#define PPC_PCFGR014_ODR	(PPC.unPCFGR014.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR014_PDE	(*(volatile uint_io8_t*)0xB72000E8)  /*@bfbba@*/
#define PPC_PCFGR014_PUE	(*(volatile uint_io8_t*)0xB72000E9)  /*@bfbba@*/
#define PPC_PCFGR014_PIL	(PPC.unPCFGR014.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR014_PIE	(*(volatile uint_io8_t*)0xB72000EC)  /*@bfbba@*/
#define PPC_PCFGR014_PID	(*(volatile uint_io8_t*)0xB72000ED)  /*@bfbba@*/
#define PPC_PCFGR014_POD	(*(volatile uint_io8_t*)0xB72000EE)  /*@bfbba@*/
#define PPC_PCFGR014_POE	(*(volatile uint_io8_t*)0xB72000EF)  /*@bfbba@*/

#define PPC_PCFGR015	(PPC.unPCFGR015.u16Register)  /*@rg@*/
#define PPC_PCFGR015_POF	(PPC.unPCFGR015.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR015_NFE	(*(volatile uint_io8_t*)0xB72000F5)  /*@bfbba@*/
#define PPC_PCFGR015_ODR	(PPC.unPCFGR015.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR015_PDE	(*(volatile uint_io8_t*)0xB72000F8)  /*@bfbba@*/
#define PPC_PCFGR015_PUE	(*(volatile uint_io8_t*)0xB72000F9)  /*@bfbba@*/
#define PPC_PCFGR015_PIL	(PPC.unPCFGR015.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR015_PIE	(*(volatile uint_io8_t*)0xB72000FC)  /*@bfbba@*/
#define PPC_PCFGR015_PID	(*(volatile uint_io8_t*)0xB72000FD)  /*@bfbba@*/
#define PPC_PCFGR015_POD	(*(volatile uint_io8_t*)0xB72000FE)  /*@bfbba@*/
#define PPC_PCFGR015_POE	(*(volatile uint_io8_t*)0xB72000FF)  /*@bfbba@*/

#define PPC_PCFGR016	(PPC.unPCFGR016.u16Register)  /*@rg@*/
#define PPC_PCFGR016_POF	(PPC.unPCFGR016.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR016_NFE	(*(volatile uint_io8_t*)0xB7200105)  /*@bfbba@*/
#define PPC_PCFGR016_ODR	(PPC.unPCFGR016.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR016_PDE	(*(volatile uint_io8_t*)0xB7200108)  /*@bfbba@*/
#define PPC_PCFGR016_PUE	(*(volatile uint_io8_t*)0xB7200109)  /*@bfbba@*/
#define PPC_PCFGR016_PIL	(PPC.unPCFGR016.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR016_PIE	(*(volatile uint_io8_t*)0xB720010C)  /*@bfbba@*/
#define PPC_PCFGR016_PID	(*(volatile uint_io8_t*)0xB720010D)  /*@bfbba@*/
#define PPC_PCFGR016_POD	(*(volatile uint_io8_t*)0xB720010E)  /*@bfbba@*/
#define PPC_PCFGR016_POE	(*(volatile uint_io8_t*)0xB720010F)  /*@bfbba@*/

#define PPC_PCFGR017	(PPC.unPCFGR017.u16Register)  /*@rg@*/
#define PPC_PCFGR017_POF	(PPC.unPCFGR017.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR017_NFE	(*(volatile uint_io8_t*)0xB7200115)  /*@bfbba@*/
#define PPC_PCFGR017_ODR	(PPC.unPCFGR017.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR017_PDE	(*(volatile uint_io8_t*)0xB7200118)  /*@bfbba@*/
#define PPC_PCFGR017_PUE	(*(volatile uint_io8_t*)0xB7200119)  /*@bfbba@*/
#define PPC_PCFGR017_PIL	(PPC.unPCFGR017.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR017_PIE	(*(volatile uint_io8_t*)0xB720011C)  /*@bfbba@*/
#define PPC_PCFGR017_PID	(*(volatile uint_io8_t*)0xB720011D)  /*@bfbba@*/
#define PPC_PCFGR017_POD	(*(volatile uint_io8_t*)0xB720011E)  /*@bfbba@*/
#define PPC_PCFGR017_POE	(*(volatile uint_io8_t*)0xB720011F)  /*@bfbba@*/

#define PPC_PCFGR018	(PPC.unPCFGR018.u16Register)  /*@rg@*/
#define PPC_PCFGR018_POF	(PPC.unPCFGR018.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR018_NFE	(*(volatile uint_io8_t*)0xB7200125)  /*@bfbba@*/
#define PPC_PCFGR018_ODR	(PPC.unPCFGR018.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR018_PDE	(*(volatile uint_io8_t*)0xB7200128)  /*@bfbba@*/
#define PPC_PCFGR018_PUE	(*(volatile uint_io8_t*)0xB7200129)  /*@bfbba@*/
#define PPC_PCFGR018_PIL	(PPC.unPCFGR018.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR018_PIE	(*(volatile uint_io8_t*)0xB720012C)  /*@bfbba@*/
#define PPC_PCFGR018_PID	(*(volatile uint_io8_t*)0xB720012D)  /*@bfbba@*/
#define PPC_PCFGR018_POD	(*(volatile uint_io8_t*)0xB720012E)  /*@bfbba@*/
#define PPC_PCFGR018_POE	(*(volatile uint_io8_t*)0xB720012F)  /*@bfbba@*/

#define PPC_PCFGR019	(PPC.unPCFGR019.u16Register)  /*@rg@*/
#define PPC_PCFGR019_POF	(PPC.unPCFGR019.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR019_NFE	(*(volatile uint_io8_t*)0xB7200135)  /*@bfbba@*/
#define PPC_PCFGR019_ODR	(PPC.unPCFGR019.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR019_PDE	(*(volatile uint_io8_t*)0xB7200138)  /*@bfbba@*/
#define PPC_PCFGR019_PUE	(*(volatile uint_io8_t*)0xB7200139)  /*@bfbba@*/
#define PPC_PCFGR019_PIL	(PPC.unPCFGR019.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR019_PIE	(*(volatile uint_io8_t*)0xB720013C)  /*@bfbba@*/
#define PPC_PCFGR019_PID	(*(volatile uint_io8_t*)0xB720013D)  /*@bfbba@*/
#define PPC_PCFGR019_POD	(*(volatile uint_io8_t*)0xB720013E)  /*@bfbba@*/
#define PPC_PCFGR019_POE	(*(volatile uint_io8_t*)0xB720013F)  /*@bfbba@*/

#define PPC_PCFGR020	(PPC.unPCFGR020.u16Register)  /*@rg@*/
#define PPC_PCFGR020_POF	(PPC.unPCFGR020.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR020_NFE	(*(volatile uint_io8_t*)0xB7200145)  /*@bfbba@*/
#define PPC_PCFGR020_ODR	(PPC.unPCFGR020.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR020_PDE	(*(volatile uint_io8_t*)0xB7200148)  /*@bfbba@*/
#define PPC_PCFGR020_PUE	(*(volatile uint_io8_t*)0xB7200149)  /*@bfbba@*/
#define PPC_PCFGR020_PIL	(PPC.unPCFGR020.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR020_PIE	(*(volatile uint_io8_t*)0xB720014C)  /*@bfbba@*/
#define PPC_PCFGR020_PID	(*(volatile uint_io8_t*)0xB720014D)  /*@bfbba@*/
#define PPC_PCFGR020_POD	(*(volatile uint_io8_t*)0xB720014E)  /*@bfbba@*/
#define PPC_PCFGR020_POE	(*(volatile uint_io8_t*)0xB720014F)  /*@bfbba@*/

#define PPC_PCFGR021	(PPC.unPCFGR021.u16Register)  /*@rg@*/
#define PPC_PCFGR021_POF	(PPC.unPCFGR021.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR021_NFE	(*(volatile uint_io8_t*)0xB7200155)  /*@bfbba@*/
#define PPC_PCFGR021_ODR	(PPC.unPCFGR021.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR021_PDE	(*(volatile uint_io8_t*)0xB7200158)  /*@bfbba@*/
#define PPC_PCFGR021_PUE	(*(volatile uint_io8_t*)0xB7200159)  /*@bfbba@*/
#define PPC_PCFGR021_PIL	(PPC.unPCFGR021.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR021_PIE	(*(volatile uint_io8_t*)0xB720015C)  /*@bfbba@*/
#define PPC_PCFGR021_PID	(*(volatile uint_io8_t*)0xB720015D)  /*@bfbba@*/
#define PPC_PCFGR021_POD	(*(volatile uint_io8_t*)0xB720015E)  /*@bfbba@*/
#define PPC_PCFGR021_POE	(*(volatile uint_io8_t*)0xB720015F)  /*@bfbba@*/

#define PPC_PCFGR022	(PPC.unPCFGR022.u16Register)  /*@rg@*/
#define PPC_PCFGR022_POF	(PPC.unPCFGR022.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR022_NFE	(*(volatile uint_io8_t*)0xB7200165)  /*@bfbba@*/
#define PPC_PCFGR022_ODR	(PPC.unPCFGR022.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR022_PDE	(*(volatile uint_io8_t*)0xB7200168)  /*@bfbba@*/
#define PPC_PCFGR022_PUE	(*(volatile uint_io8_t*)0xB7200169)  /*@bfbba@*/
#define PPC_PCFGR022_PIL	(PPC.unPCFGR022.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR022_PIE	(*(volatile uint_io8_t*)0xB720016C)  /*@bfbba@*/
#define PPC_PCFGR022_PID	(*(volatile uint_io8_t*)0xB720016D)  /*@bfbba@*/
#define PPC_PCFGR022_POD	(*(volatile uint_io8_t*)0xB720016E)  /*@bfbba@*/
#define PPC_PCFGR022_POE	(*(volatile uint_io8_t*)0xB720016F)  /*@bfbba@*/

#define PPC_PCFGR023	(PPC.unPCFGR023.u16Register)  /*@rg@*/
#define PPC_PCFGR023_POF	(PPC.unPCFGR023.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR023_NFE	(*(volatile uint_io8_t*)0xB7200175)  /*@bfbba@*/
#define PPC_PCFGR023_ODR	(PPC.unPCFGR023.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR023_PDE	(*(volatile uint_io8_t*)0xB7200178)  /*@bfbba@*/
#define PPC_PCFGR023_PUE	(*(volatile uint_io8_t*)0xB7200179)  /*@bfbba@*/
#define PPC_PCFGR023_PIL	(PPC.unPCFGR023.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR023_PIE	(*(volatile uint_io8_t*)0xB720017C)  /*@bfbba@*/
#define PPC_PCFGR023_PID	(*(volatile uint_io8_t*)0xB720017D)  /*@bfbba@*/
#define PPC_PCFGR023_POD	(*(volatile uint_io8_t*)0xB720017E)  /*@bfbba@*/
#define PPC_PCFGR023_POE	(*(volatile uint_io8_t*)0xB720017F)  /*@bfbba@*/

#define PPC_PCFGR024	(PPC.unPCFGR024.u16Register)  /*@rg@*/
#define PPC_PCFGR024_POF	(PPC.unPCFGR024.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR024_NFE	(*(volatile uint_io8_t*)0xB7200185)  /*@bfbba@*/
#define PPC_PCFGR024_ODR	(PPC.unPCFGR024.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR024_PDE	(*(volatile uint_io8_t*)0xB7200188)  /*@bfbba@*/
#define PPC_PCFGR024_PUE	(*(volatile uint_io8_t*)0xB7200189)  /*@bfbba@*/
#define PPC_PCFGR024_PIL	(PPC.unPCFGR024.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR024_PIE	(*(volatile uint_io8_t*)0xB720018C)  /*@bfbba@*/
#define PPC_PCFGR024_PID	(*(volatile uint_io8_t*)0xB720018D)  /*@bfbba@*/
#define PPC_PCFGR024_POD	(*(volatile uint_io8_t*)0xB720018E)  /*@bfbba@*/
#define PPC_PCFGR024_POE	(*(volatile uint_io8_t*)0xB720018F)  /*@bfbba@*/

#define PPC_PCFGR025	(PPC.unPCFGR025.u16Register)  /*@rg@*/
#define PPC_PCFGR025_POF	(PPC.unPCFGR025.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR025_NFE	(*(volatile uint_io8_t*)0xB7200195)  /*@bfbba@*/
#define PPC_PCFGR025_ODR	(PPC.unPCFGR025.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR025_PDE	(*(volatile uint_io8_t*)0xB7200198)  /*@bfbba@*/
#define PPC_PCFGR025_PUE	(*(volatile uint_io8_t*)0xB7200199)  /*@bfbba@*/
#define PPC_PCFGR025_PIL	(PPC.unPCFGR025.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR025_PIE	(*(volatile uint_io8_t*)0xB720019C)  /*@bfbba@*/
#define PPC_PCFGR025_PID	(*(volatile uint_io8_t*)0xB720019D)  /*@bfbba@*/
#define PPC_PCFGR025_POD	(*(volatile uint_io8_t*)0xB720019E)  /*@bfbba@*/
#define PPC_PCFGR025_POE	(*(volatile uint_io8_t*)0xB720019F)  /*@bfbba@*/

#define PPC_PCFGR026	(PPC.unPCFGR026.u16Register)  /*@rg@*/
#define PPC_PCFGR026_POF	(PPC.unPCFGR026.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR026_NFE	(*(volatile uint_io8_t*)0xB72001A5)  /*@bfbba@*/
#define PPC_PCFGR026_ODR	(PPC.unPCFGR026.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR026_PDE	(*(volatile uint_io8_t*)0xB72001A8)  /*@bfbba@*/
#define PPC_PCFGR026_PUE	(*(volatile uint_io8_t*)0xB72001A9)  /*@bfbba@*/
#define PPC_PCFGR026_PIL	(PPC.unPCFGR026.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR026_PIE	(*(volatile uint_io8_t*)0xB72001AC)  /*@bfbba@*/
#define PPC_PCFGR026_PID	(*(volatile uint_io8_t*)0xB72001AD)  /*@bfbba@*/
#define PPC_PCFGR026_POD	(*(volatile uint_io8_t*)0xB72001AE)  /*@bfbba@*/
#define PPC_PCFGR026_POE	(*(volatile uint_io8_t*)0xB72001AF)  /*@bfbba@*/

#define PPC_PCFGR027	(PPC.unPCFGR027.u16Register)  /*@rg@*/
#define PPC_PCFGR027_POF	(PPC.unPCFGR027.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR027_NFE	(*(volatile uint_io8_t*)0xB72001B5)  /*@bfbba@*/
#define PPC_PCFGR027_ODR	(PPC.unPCFGR027.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR027_PDE	(*(volatile uint_io8_t*)0xB72001B8)  /*@bfbba@*/
#define PPC_PCFGR027_PUE	(*(volatile uint_io8_t*)0xB72001B9)  /*@bfbba@*/
#define PPC_PCFGR027_PIL	(PPC.unPCFGR027.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR027_PIE	(*(volatile uint_io8_t*)0xB72001BC)  /*@bfbba@*/
#define PPC_PCFGR027_PID	(*(volatile uint_io8_t*)0xB72001BD)  /*@bfbba@*/
#define PPC_PCFGR027_POD	(*(volatile uint_io8_t*)0xB72001BE)  /*@bfbba@*/
#define PPC_PCFGR027_POE	(*(volatile uint_io8_t*)0xB72001BF)  /*@bfbba@*/

#define PPC_PCFGR028	(PPC.unPCFGR028.u16Register)  /*@rg@*/
#define PPC_PCFGR028_POF	(PPC.unPCFGR028.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR028_NFE	(*(volatile uint_io8_t*)0xB72001C5)  /*@bfbba@*/
#define PPC_PCFGR028_ODR	(PPC.unPCFGR028.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR028_PDE	(*(volatile uint_io8_t*)0xB72001C8)  /*@bfbba@*/
#define PPC_PCFGR028_PUE	(*(volatile uint_io8_t*)0xB72001C9)  /*@bfbba@*/
#define PPC_PCFGR028_PIL	(PPC.unPCFGR028.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR028_PIE	(*(volatile uint_io8_t*)0xB72001CC)  /*@bfbba@*/
#define PPC_PCFGR028_PID	(*(volatile uint_io8_t*)0xB72001CD)  /*@bfbba@*/
#define PPC_PCFGR028_POD	(*(volatile uint_io8_t*)0xB72001CE)  /*@bfbba@*/
#define PPC_PCFGR028_POE	(*(volatile uint_io8_t*)0xB72001CF)  /*@bfbba@*/

#define PPC_PCFGR029	(PPC.unPCFGR029.u16Register)  /*@rg@*/
#define PPC_PCFGR029_POF	(PPC.unPCFGR029.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR029_NFE	(*(volatile uint_io8_t*)0xB72001D5)  /*@bfbba@*/
#define PPC_PCFGR029_ODR	(PPC.unPCFGR029.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR029_PDE	(*(volatile uint_io8_t*)0xB72001D8)  /*@bfbba@*/
#define PPC_PCFGR029_PUE	(*(volatile uint_io8_t*)0xB72001D9)  /*@bfbba@*/
#define PPC_PCFGR029_PIL	(PPC.unPCFGR029.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR029_PIE	(*(volatile uint_io8_t*)0xB72001DC)  /*@bfbba@*/
#define PPC_PCFGR029_PID	(*(volatile uint_io8_t*)0xB72001DD)  /*@bfbba@*/
#define PPC_PCFGR029_POD	(*(volatile uint_io8_t*)0xB72001DE)  /*@bfbba@*/
#define PPC_PCFGR029_POE	(*(volatile uint_io8_t*)0xB72001DF)  /*@bfbba@*/

#define PPC_PCFGR030	(PPC.unPCFGR030.u16Register)  /*@rg@*/
#define PPC_PCFGR030_POF	(PPC.unPCFGR030.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR030_NFE	(*(volatile uint_io8_t*)0xB72001E5)  /*@bfbba@*/
#define PPC_PCFGR030_ODR	(PPC.unPCFGR030.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR030_PDE	(*(volatile uint_io8_t*)0xB72001E8)  /*@bfbba@*/
#define PPC_PCFGR030_PUE	(*(volatile uint_io8_t*)0xB72001E9)  /*@bfbba@*/
#define PPC_PCFGR030_PIL	(PPC.unPCFGR030.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR030_PIE	(*(volatile uint_io8_t*)0xB72001EC)  /*@bfbba@*/
#define PPC_PCFGR030_PID	(*(volatile uint_io8_t*)0xB72001ED)  /*@bfbba@*/
#define PPC_PCFGR030_POD	(*(volatile uint_io8_t*)0xB72001EE)  /*@bfbba@*/
#define PPC_PCFGR030_POE	(*(volatile uint_io8_t*)0xB72001EF)  /*@bfbba@*/

#define PPC_PCFGR031	(PPC.unPCFGR031.u16Register)  /*@rg@*/
#define PPC_PCFGR031_POF	(PPC.unPCFGR031.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR031_NFE	(*(volatile uint_io8_t*)0xB72001F5)  /*@bfbba@*/
#define PPC_PCFGR031_ODR	(PPC.unPCFGR031.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR031_PDE	(*(volatile uint_io8_t*)0xB72001F8)  /*@bfbba@*/
#define PPC_PCFGR031_PUE	(*(volatile uint_io8_t*)0xB72001F9)  /*@bfbba@*/
#define PPC_PCFGR031_PIL	(PPC.unPCFGR031.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR031_PIE	(*(volatile uint_io8_t*)0xB72001FC)  /*@bfbba@*/
#define PPC_PCFGR031_PID	(*(volatile uint_io8_t*)0xB72001FD)  /*@bfbba@*/
#define PPC_PCFGR031_POD	(*(volatile uint_io8_t*)0xB72001FE)  /*@bfbba@*/
#define PPC_PCFGR031_POE	(*(volatile uint_io8_t*)0xB72001FF)  /*@bfbba@*/

#define PPC_PCFGR100	(PPC.unPCFGR100.u16Register)  /*@rg@*/
#define PPC_PCFGR100_POF	(PPC.unPCFGR100.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR100_NFE	(*(volatile uint_io8_t*)0xB7200205)  /*@bfbba@*/
#define PPC_PCFGR100_ODR	(PPC.unPCFGR100.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR100_PDE	(*(volatile uint_io8_t*)0xB7200208)  /*@bfbba@*/
#define PPC_PCFGR100_PUE	(*(volatile uint_io8_t*)0xB7200209)  /*@bfbba@*/
#define PPC_PCFGR100_PIL	(PPC.unPCFGR100.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR100_PIE	(*(volatile uint_io8_t*)0xB720020C)  /*@bfbba@*/
#define PPC_PCFGR100_PID	(*(volatile uint_io8_t*)0xB720020D)  /*@bfbba@*/
#define PPC_PCFGR100_POD	(*(volatile uint_io8_t*)0xB720020E)  /*@bfbba@*/
#define PPC_PCFGR100_POE	(*(volatile uint_io8_t*)0xB720020F)  /*@bfbba@*/

#define PPC_PCFGR101	(PPC.unPCFGR101.u16Register)  /*@rg@*/
#define PPC_PCFGR101_POF	(PPC.unPCFGR101.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR101_NFE	(*(volatile uint_io8_t*)0xB7200215)  /*@bfbba@*/
#define PPC_PCFGR101_ODR	(PPC.unPCFGR101.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR101_PDE	(*(volatile uint_io8_t*)0xB7200218)  /*@bfbba@*/
#define PPC_PCFGR101_PUE	(*(volatile uint_io8_t*)0xB7200219)  /*@bfbba@*/
#define PPC_PCFGR101_PIL	(PPC.unPCFGR101.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR101_PIE	(*(volatile uint_io8_t*)0xB720021C)  /*@bfbba@*/
#define PPC_PCFGR101_PID	(*(volatile uint_io8_t*)0xB720021D)  /*@bfbba@*/
#define PPC_PCFGR101_POD	(*(volatile uint_io8_t*)0xB720021E)  /*@bfbba@*/
#define PPC_PCFGR101_POE	(*(volatile uint_io8_t*)0xB720021F)  /*@bfbba@*/

#define PPC_PCFGR102	(PPC.unPCFGR102.u16Register)  /*@rg@*/
#define PPC_PCFGR102_POF	(PPC.unPCFGR102.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR102_NFE	(*(volatile uint_io8_t*)0xB7200225)  /*@bfbba@*/
#define PPC_PCFGR102_ODR	(PPC.unPCFGR102.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR102_PDE	(*(volatile uint_io8_t*)0xB7200228)  /*@bfbba@*/
#define PPC_PCFGR102_PUE	(*(volatile uint_io8_t*)0xB7200229)  /*@bfbba@*/
#define PPC_PCFGR102_PIL	(PPC.unPCFGR102.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR102_PIE	(*(volatile uint_io8_t*)0xB720022C)  /*@bfbba@*/
#define PPC_PCFGR102_PID	(*(volatile uint_io8_t*)0xB720022D)  /*@bfbba@*/
#define PPC_PCFGR102_POD	(*(volatile uint_io8_t*)0xB720022E)  /*@bfbba@*/
#define PPC_PCFGR102_POE	(*(volatile uint_io8_t*)0xB720022F)  /*@bfbba@*/

#define PPC_PCFGR103	(PPC.unPCFGR103.u16Register)  /*@rg@*/
#define PPC_PCFGR103_POF	(PPC.unPCFGR103.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR103_NFE	(*(volatile uint_io8_t*)0xB7200235)  /*@bfbba@*/
#define PPC_PCFGR103_ODR	(PPC.unPCFGR103.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR103_PDE	(*(volatile uint_io8_t*)0xB7200238)  /*@bfbba@*/
#define PPC_PCFGR103_PUE	(*(volatile uint_io8_t*)0xB7200239)  /*@bfbba@*/
#define PPC_PCFGR103_PIL	(PPC.unPCFGR103.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR103_PIE	(*(volatile uint_io8_t*)0xB720023C)  /*@bfbba@*/
#define PPC_PCFGR103_PID	(*(volatile uint_io8_t*)0xB720023D)  /*@bfbba@*/
#define PPC_PCFGR103_POD	(*(volatile uint_io8_t*)0xB720023E)  /*@bfbba@*/
#define PPC_PCFGR103_POE	(*(volatile uint_io8_t*)0xB720023F)  /*@bfbba@*/

#define PPC_PCFGR104	(PPC.unPCFGR104.u16Register)  /*@rg@*/
#define PPC_PCFGR104_POF	(PPC.unPCFGR104.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR104_NFE	(*(volatile uint_io8_t*)0xB7200245)  /*@bfbba@*/
#define PPC_PCFGR104_ODR	(PPC.unPCFGR104.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR104_PDE	(*(volatile uint_io8_t*)0xB7200248)  /*@bfbba@*/
#define PPC_PCFGR104_PUE	(*(volatile uint_io8_t*)0xB7200249)  /*@bfbba@*/
#define PPC_PCFGR104_PIL	(PPC.unPCFGR104.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR104_PIE	(*(volatile uint_io8_t*)0xB720024C)  /*@bfbba@*/
#define PPC_PCFGR104_PID	(*(volatile uint_io8_t*)0xB720024D)  /*@bfbba@*/
#define PPC_PCFGR104_POD	(*(volatile uint_io8_t*)0xB720024E)  /*@bfbba@*/
#define PPC_PCFGR104_POE	(*(volatile uint_io8_t*)0xB720024F)  /*@bfbba@*/

#define PPC_PCFGR105	(PPC.unPCFGR105.u16Register)  /*@rg@*/
#define PPC_PCFGR105_POF	(PPC.unPCFGR105.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR105_NFE	(*(volatile uint_io8_t*)0xB7200255)  /*@bfbba@*/
#define PPC_PCFGR105_ODR	(PPC.unPCFGR105.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR105_PDE	(*(volatile uint_io8_t*)0xB7200258)  /*@bfbba@*/
#define PPC_PCFGR105_PUE	(*(volatile uint_io8_t*)0xB7200259)  /*@bfbba@*/
#define PPC_PCFGR105_PIL	(PPC.unPCFGR105.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR105_PIE	(*(volatile uint_io8_t*)0xB720025C)  /*@bfbba@*/
#define PPC_PCFGR105_PID	(*(volatile uint_io8_t*)0xB720025D)  /*@bfbba@*/
#define PPC_PCFGR105_POD	(*(volatile uint_io8_t*)0xB720025E)  /*@bfbba@*/
#define PPC_PCFGR105_POE	(*(volatile uint_io8_t*)0xB720025F)  /*@bfbba@*/

#define PPC_PCFGR106	(PPC.unPCFGR106.u16Register)  /*@rg@*/
#define PPC_PCFGR106_POF	(PPC.unPCFGR106.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR106_NFE	(*(volatile uint_io8_t*)0xB7200265)  /*@bfbba@*/
#define PPC_PCFGR106_ODR	(PPC.unPCFGR106.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR106_PDE	(*(volatile uint_io8_t*)0xB7200268)  /*@bfbba@*/
#define PPC_PCFGR106_PUE	(*(volatile uint_io8_t*)0xB7200269)  /*@bfbba@*/
#define PPC_PCFGR106_PIL	(PPC.unPCFGR106.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR106_PIE	(*(volatile uint_io8_t*)0xB720026C)  /*@bfbba@*/
#define PPC_PCFGR106_PID	(*(volatile uint_io8_t*)0xB720026D)  /*@bfbba@*/
#define PPC_PCFGR106_POD	(*(volatile uint_io8_t*)0xB720026E)  /*@bfbba@*/
#define PPC_PCFGR106_POE	(*(volatile uint_io8_t*)0xB720026F)  /*@bfbba@*/

#define PPC_PCFGR107	(PPC.unPCFGR107.u16Register)  /*@rg@*/
#define PPC_PCFGR107_POF	(PPC.unPCFGR107.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR107_NFE	(*(volatile uint_io8_t*)0xB7200275)  /*@bfbba@*/
#define PPC_PCFGR107_ODR	(PPC.unPCFGR107.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR107_PDE	(*(volatile uint_io8_t*)0xB7200278)  /*@bfbba@*/
#define PPC_PCFGR107_PUE	(*(volatile uint_io8_t*)0xB7200279)  /*@bfbba@*/
#define PPC_PCFGR107_PIL	(PPC.unPCFGR107.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR107_PIE	(*(volatile uint_io8_t*)0xB720027C)  /*@bfbba@*/
#define PPC_PCFGR107_PID	(*(volatile uint_io8_t*)0xB720027D)  /*@bfbba@*/
#define PPC_PCFGR107_POD	(*(volatile uint_io8_t*)0xB720027E)  /*@bfbba@*/
#define PPC_PCFGR107_POE	(*(volatile uint_io8_t*)0xB720027F)  /*@bfbba@*/

#define PPC_PCFGR108	(PPC.unPCFGR108.u16Register)  /*@rg@*/
#define PPC_PCFGR108_POF	(PPC.unPCFGR108.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR108_NFE	(*(volatile uint_io8_t*)0xB7200285)  /*@bfbba@*/
#define PPC_PCFGR108_ODR	(PPC.unPCFGR108.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR108_PDE	(*(volatile uint_io8_t*)0xB7200288)  /*@bfbba@*/
#define PPC_PCFGR108_PUE	(*(volatile uint_io8_t*)0xB7200289)  /*@bfbba@*/
#define PPC_PCFGR108_PIL	(PPC.unPCFGR108.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR108_PIE	(*(volatile uint_io8_t*)0xB720028C)  /*@bfbba@*/
#define PPC_PCFGR108_PID	(*(volatile uint_io8_t*)0xB720028D)  /*@bfbba@*/
#define PPC_PCFGR108_POD	(*(volatile uint_io8_t*)0xB720028E)  /*@bfbba@*/
#define PPC_PCFGR108_POE	(*(volatile uint_io8_t*)0xB720028F)  /*@bfbba@*/

#define PPC_PCFGR109	(PPC.unPCFGR109.u16Register)  /*@rg@*/
#define PPC_PCFGR109_POF	(PPC.unPCFGR109.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR109_NFE	(*(volatile uint_io8_t*)0xB7200295)  /*@bfbba@*/
#define PPC_PCFGR109_ODR	(PPC.unPCFGR109.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR109_PDE	(*(volatile uint_io8_t*)0xB7200298)  /*@bfbba@*/
#define PPC_PCFGR109_PUE	(*(volatile uint_io8_t*)0xB7200299)  /*@bfbba@*/
#define PPC_PCFGR109_PIL	(PPC.unPCFGR109.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR109_PIE	(*(volatile uint_io8_t*)0xB720029C)  /*@bfbba@*/
#define PPC_PCFGR109_PID	(*(volatile uint_io8_t*)0xB720029D)  /*@bfbba@*/
#define PPC_PCFGR109_POD	(*(volatile uint_io8_t*)0xB720029E)  /*@bfbba@*/
#define PPC_PCFGR109_POE	(*(volatile uint_io8_t*)0xB720029F)  /*@bfbba@*/

#define PPC_PCFGR110	(PPC.unPCFGR110.u16Register)  /*@rg@*/
#define PPC_PCFGR110_POF	(PPC.unPCFGR110.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR110_NFE	(*(volatile uint_io8_t*)0xB72002A5)  /*@bfbba@*/
#define PPC_PCFGR110_ODR	(PPC.unPCFGR110.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR110_PDE	(*(volatile uint_io8_t*)0xB72002A8)  /*@bfbba@*/
#define PPC_PCFGR110_PUE	(*(volatile uint_io8_t*)0xB72002A9)  /*@bfbba@*/
#define PPC_PCFGR110_PIL	(PPC.unPCFGR110.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR110_PIE	(*(volatile uint_io8_t*)0xB72002AC)  /*@bfbba@*/
#define PPC_PCFGR110_PID	(*(volatile uint_io8_t*)0xB72002AD)  /*@bfbba@*/
#define PPC_PCFGR110_POD	(*(volatile uint_io8_t*)0xB72002AE)  /*@bfbba@*/
#define PPC_PCFGR110_POE	(*(volatile uint_io8_t*)0xB72002AF)  /*@bfbba@*/

#define PPC_PCFGR111	(PPC.unPCFGR111.u16Register)  /*@rg@*/
#define PPC_PCFGR111_POF	(PPC.unPCFGR111.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR111_NFE	(*(volatile uint_io8_t*)0xB72002B5)  /*@bfbba@*/
#define PPC_PCFGR111_ODR	(PPC.unPCFGR111.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR111_PDE	(*(volatile uint_io8_t*)0xB72002B8)  /*@bfbba@*/
#define PPC_PCFGR111_PUE	(*(volatile uint_io8_t*)0xB72002B9)  /*@bfbba@*/
#define PPC_PCFGR111_PIL	(PPC.unPCFGR111.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR111_PIE	(*(volatile uint_io8_t*)0xB72002BC)  /*@bfbba@*/
#define PPC_PCFGR111_PID	(*(volatile uint_io8_t*)0xB72002BD)  /*@bfbba@*/
#define PPC_PCFGR111_POD	(*(volatile uint_io8_t*)0xB72002BE)  /*@bfbba@*/
#define PPC_PCFGR111_POE	(*(volatile uint_io8_t*)0xB72002BF)  /*@bfbba@*/

#define PPC_PCFGR112	(PPC.unPCFGR112.u16Register)  /*@rg@*/
#define PPC_PCFGR112_POF	(PPC.unPCFGR112.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR112_NFE	(*(volatile uint_io8_t*)0xB72002C5)  /*@bfbba@*/
#define PPC_PCFGR112_ODR	(PPC.unPCFGR112.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR112_PDE	(*(volatile uint_io8_t*)0xB72002C8)  /*@bfbba@*/
#define PPC_PCFGR112_PUE	(*(volatile uint_io8_t*)0xB72002C9)  /*@bfbba@*/
#define PPC_PCFGR112_PIL	(PPC.unPCFGR112.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR112_PIE	(*(volatile uint_io8_t*)0xB72002CC)  /*@bfbba@*/
#define PPC_PCFGR112_PID	(*(volatile uint_io8_t*)0xB72002CD)  /*@bfbba@*/
#define PPC_PCFGR112_POD	(*(volatile uint_io8_t*)0xB72002CE)  /*@bfbba@*/
#define PPC_PCFGR112_POE	(*(volatile uint_io8_t*)0xB72002CF)  /*@bfbba@*/

#define PPC_PCFGR113	(PPC.unPCFGR113.u16Register)  /*@rg@*/
#define PPC_PCFGR113_POF	(PPC.unPCFGR113.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR113_NFE	(*(volatile uint_io8_t*)0xB72002D5)  /*@bfbba@*/
#define PPC_PCFGR113_ODR	(PPC.unPCFGR113.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR113_PDE	(*(volatile uint_io8_t*)0xB72002D8)  /*@bfbba@*/
#define PPC_PCFGR113_PUE	(*(volatile uint_io8_t*)0xB72002D9)  /*@bfbba@*/
#define PPC_PCFGR113_PIL	(PPC.unPCFGR113.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR113_PIE	(*(volatile uint_io8_t*)0xB72002DC)  /*@bfbba@*/
#define PPC_PCFGR113_PID	(*(volatile uint_io8_t*)0xB72002DD)  /*@bfbba@*/
#define PPC_PCFGR113_POD	(*(volatile uint_io8_t*)0xB72002DE)  /*@bfbba@*/
#define PPC_PCFGR113_POE	(*(volatile uint_io8_t*)0xB72002DF)  /*@bfbba@*/

#define PPC_PCFGR114	(PPC.unPCFGR114.u16Register)  /*@rg@*/
#define PPC_PCFGR114_POF	(PPC.unPCFGR114.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR114_NFE	(*(volatile uint_io8_t*)0xB72002E5)  /*@bfbba@*/
#define PPC_PCFGR114_ODR	(PPC.unPCFGR114.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR114_PDE	(*(volatile uint_io8_t*)0xB72002E8)  /*@bfbba@*/
#define PPC_PCFGR114_PUE	(*(volatile uint_io8_t*)0xB72002E9)  /*@bfbba@*/
#define PPC_PCFGR114_PIL	(PPC.unPCFGR114.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR114_PIE	(*(volatile uint_io8_t*)0xB72002EC)  /*@bfbba@*/
#define PPC_PCFGR114_PID	(*(volatile uint_io8_t*)0xB72002ED)  /*@bfbba@*/
#define PPC_PCFGR114_POD	(*(volatile uint_io8_t*)0xB72002EE)  /*@bfbba@*/
#define PPC_PCFGR114_POE	(*(volatile uint_io8_t*)0xB72002EF)  /*@bfbba@*/

#define PPC_PCFGR115	(PPC.unPCFGR115.u16Register)  /*@rg@*/
#define PPC_PCFGR115_POF	(PPC.unPCFGR115.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR115_NFE	(*(volatile uint_io8_t*)0xB72002F5)  /*@bfbba@*/
#define PPC_PCFGR115_ODR	(PPC.unPCFGR115.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR115_PDE	(*(volatile uint_io8_t*)0xB72002F8)  /*@bfbba@*/
#define PPC_PCFGR115_PUE	(*(volatile uint_io8_t*)0xB72002F9)  /*@bfbba@*/
#define PPC_PCFGR115_PIL	(PPC.unPCFGR115.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR115_PIE	(*(volatile uint_io8_t*)0xB72002FC)  /*@bfbba@*/
#define PPC_PCFGR115_PID	(*(volatile uint_io8_t*)0xB72002FD)  /*@bfbba@*/
#define PPC_PCFGR115_POD	(*(volatile uint_io8_t*)0xB72002FE)  /*@bfbba@*/
#define PPC_PCFGR115_POE	(*(volatile uint_io8_t*)0xB72002FF)  /*@bfbba@*/

#define PPC_PCFGR116	(PPC.unPCFGR116.u16Register)  /*@rg@*/
#define PPC_PCFGR116_POF	(PPC.unPCFGR116.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR116_NFE	(*(volatile uint_io8_t*)0xB7200305)  /*@bfbba@*/
#define PPC_PCFGR116_ODR	(PPC.unPCFGR116.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR116_PDE	(*(volatile uint_io8_t*)0xB7200308)  /*@bfbba@*/
#define PPC_PCFGR116_PUE	(*(volatile uint_io8_t*)0xB7200309)  /*@bfbba@*/
#define PPC_PCFGR116_PIL	(PPC.unPCFGR116.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR116_PIE	(*(volatile uint_io8_t*)0xB720030C)  /*@bfbba@*/
#define PPC_PCFGR116_PID	(*(volatile uint_io8_t*)0xB720030D)  /*@bfbba@*/
#define PPC_PCFGR116_POD	(*(volatile uint_io8_t*)0xB720030E)  /*@bfbba@*/
#define PPC_PCFGR116_POE	(*(volatile uint_io8_t*)0xB720030F)  /*@bfbba@*/

#define PPC_PCFGR117	(PPC.unPCFGR117.u16Register)  /*@rg@*/
#define PPC_PCFGR117_POF	(PPC.unPCFGR117.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR117_NFE	(*(volatile uint_io8_t*)0xB7200315)  /*@bfbba@*/
#define PPC_PCFGR117_ODR	(PPC.unPCFGR117.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR117_PDE	(*(volatile uint_io8_t*)0xB7200318)  /*@bfbba@*/
#define PPC_PCFGR117_PUE	(*(volatile uint_io8_t*)0xB7200319)  /*@bfbba@*/
#define PPC_PCFGR117_PIL	(PPC.unPCFGR117.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR117_PIE	(*(volatile uint_io8_t*)0xB720031C)  /*@bfbba@*/
#define PPC_PCFGR117_PID	(*(volatile uint_io8_t*)0xB720031D)  /*@bfbba@*/
#define PPC_PCFGR117_POD	(*(volatile uint_io8_t*)0xB720031E)  /*@bfbba@*/
#define PPC_PCFGR117_POE	(*(volatile uint_io8_t*)0xB720031F)  /*@bfbba@*/

#define PPC_PCFGR118	(PPC.unPCFGR118.u16Register)  /*@rg@*/
#define PPC_PCFGR118_POF	(PPC.unPCFGR118.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR118_NFE	(*(volatile uint_io8_t*)0xB7200325)  /*@bfbba@*/
#define PPC_PCFGR118_ODR	(PPC.unPCFGR118.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR118_PDE	(*(volatile uint_io8_t*)0xB7200328)  /*@bfbba@*/
#define PPC_PCFGR118_PUE	(*(volatile uint_io8_t*)0xB7200329)  /*@bfbba@*/
#define PPC_PCFGR118_PIL	(PPC.unPCFGR118.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR118_PIE	(*(volatile uint_io8_t*)0xB720032C)  /*@bfbba@*/
#define PPC_PCFGR118_PID	(*(volatile uint_io8_t*)0xB720032D)  /*@bfbba@*/
#define PPC_PCFGR118_POD	(*(volatile uint_io8_t*)0xB720032E)  /*@bfbba@*/
#define PPC_PCFGR118_POE	(*(volatile uint_io8_t*)0xB720032F)  /*@bfbba@*/

#define PPC_PCFGR119	(PPC.unPCFGR119.u16Register)  /*@rg@*/
#define PPC_PCFGR119_POF	(PPC.unPCFGR119.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR119_NFE	(*(volatile uint_io8_t*)0xB7200335)  /*@bfbba@*/
#define PPC_PCFGR119_ODR	(PPC.unPCFGR119.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR119_PDE	(*(volatile uint_io8_t*)0xB7200338)  /*@bfbba@*/
#define PPC_PCFGR119_PUE	(*(volatile uint_io8_t*)0xB7200339)  /*@bfbba@*/
#define PPC_PCFGR119_PIL	(PPC.unPCFGR119.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR119_PIE	(*(volatile uint_io8_t*)0xB720033C)  /*@bfbba@*/
#define PPC_PCFGR119_PID	(*(volatile uint_io8_t*)0xB720033D)  /*@bfbba@*/
#define PPC_PCFGR119_POD	(*(volatile uint_io8_t*)0xB720033E)  /*@bfbba@*/
#define PPC_PCFGR119_POE	(*(volatile uint_io8_t*)0xB720033F)  /*@bfbba@*/

#define PPC_PCFGR120	(PPC.unPCFGR120.u16Register)  /*@rg@*/
#define PPC_PCFGR120_POF	(PPC.unPCFGR120.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR120_NFE	(*(volatile uint_io8_t*)0xB7200345)  /*@bfbba@*/
#define PPC_PCFGR120_ODR	(PPC.unPCFGR120.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR120_PDE	(*(volatile uint_io8_t*)0xB7200348)  /*@bfbba@*/
#define PPC_PCFGR120_PUE	(*(volatile uint_io8_t*)0xB7200349)  /*@bfbba@*/
#define PPC_PCFGR120_PIL	(PPC.unPCFGR120.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR120_PIE	(*(volatile uint_io8_t*)0xB720034C)  /*@bfbba@*/
#define PPC_PCFGR120_PID	(*(volatile uint_io8_t*)0xB720034D)  /*@bfbba@*/
#define PPC_PCFGR120_POD	(*(volatile uint_io8_t*)0xB720034E)  /*@bfbba@*/
#define PPC_PCFGR120_POE	(*(volatile uint_io8_t*)0xB720034F)  /*@bfbba@*/

#define PPC_PCFGR121	(PPC.unPCFGR121.u16Register)  /*@rg@*/
#define PPC_PCFGR121_POF	(PPC.unPCFGR121.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR121_NFE	(*(volatile uint_io8_t*)0xB7200355)  /*@bfbba@*/
#define PPC_PCFGR121_ODR	(PPC.unPCFGR121.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR121_PDE	(*(volatile uint_io8_t*)0xB7200358)  /*@bfbba@*/
#define PPC_PCFGR121_PUE	(*(volatile uint_io8_t*)0xB7200359)  /*@bfbba@*/
#define PPC_PCFGR121_PIL	(PPC.unPCFGR121.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR121_PIE	(*(volatile uint_io8_t*)0xB720035C)  /*@bfbba@*/
#define PPC_PCFGR121_PID	(*(volatile uint_io8_t*)0xB720035D)  /*@bfbba@*/
#define PPC_PCFGR121_POD	(*(volatile uint_io8_t*)0xB720035E)  /*@bfbba@*/
#define PPC_PCFGR121_POE	(*(volatile uint_io8_t*)0xB720035F)  /*@bfbba@*/

#define PPC_PCFGR122	(PPC.unPCFGR122.u16Register)  /*@rg@*/
#define PPC_PCFGR122_POF	(PPC.unPCFGR122.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR122_NFE	(*(volatile uint_io8_t*)0xB7200365)  /*@bfbba@*/
#define PPC_PCFGR122_ODR	(PPC.unPCFGR122.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR122_PDE	(*(volatile uint_io8_t*)0xB7200368)  /*@bfbba@*/
#define PPC_PCFGR122_PUE	(*(volatile uint_io8_t*)0xB7200369)  /*@bfbba@*/
#define PPC_PCFGR122_PIL	(PPC.unPCFGR122.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR122_PIE	(*(volatile uint_io8_t*)0xB720036C)  /*@bfbba@*/
#define PPC_PCFGR122_PID	(*(volatile uint_io8_t*)0xB720036D)  /*@bfbba@*/
#define PPC_PCFGR122_POD	(*(volatile uint_io8_t*)0xB720036E)  /*@bfbba@*/
#define PPC_PCFGR122_POE	(*(volatile uint_io8_t*)0xB720036F)  /*@bfbba@*/

#define PPC_PCFGR123	(PPC.unPCFGR123.u16Register)  /*@rg@*/
#define PPC_PCFGR123_POF	(PPC.unPCFGR123.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR123_NFE	(*(volatile uint_io8_t*)0xB7200375)  /*@bfbba@*/
#define PPC_PCFGR123_ODR	(PPC.unPCFGR123.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR123_PDE	(*(volatile uint_io8_t*)0xB7200378)  /*@bfbba@*/
#define PPC_PCFGR123_PUE	(*(volatile uint_io8_t*)0xB7200379)  /*@bfbba@*/
#define PPC_PCFGR123_PIL	(PPC.unPCFGR123.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR123_PIE	(*(volatile uint_io8_t*)0xB720037C)  /*@bfbba@*/
#define PPC_PCFGR123_PID	(*(volatile uint_io8_t*)0xB720037D)  /*@bfbba@*/
#define PPC_PCFGR123_POD	(*(volatile uint_io8_t*)0xB720037E)  /*@bfbba@*/
#define PPC_PCFGR123_POE	(*(volatile uint_io8_t*)0xB720037F)  /*@bfbba@*/

#define PPC_PCFGR124	(PPC.unPCFGR124.u16Register)  /*@rg@*/
#define PPC_PCFGR124_POF	(PPC.unPCFGR124.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR124_NFE	(*(volatile uint_io8_t*)0xB7200385)  /*@bfbba@*/
#define PPC_PCFGR124_ODR	(PPC.unPCFGR124.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR124_PDE	(*(volatile uint_io8_t*)0xB7200388)  /*@bfbba@*/
#define PPC_PCFGR124_PUE	(*(volatile uint_io8_t*)0xB7200389)  /*@bfbba@*/
#define PPC_PCFGR124_PIL	(PPC.unPCFGR124.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR124_PIE	(*(volatile uint_io8_t*)0xB720038C)  /*@bfbba@*/
#define PPC_PCFGR124_PID	(*(volatile uint_io8_t*)0xB720038D)  /*@bfbba@*/
#define PPC_PCFGR124_POD	(*(volatile uint_io8_t*)0xB720038E)  /*@bfbba@*/
#define PPC_PCFGR124_POE	(*(volatile uint_io8_t*)0xB720038F)  /*@bfbba@*/

#define PPC_PCFGR125	(PPC.unPCFGR125.u16Register)  /*@rg@*/
#define PPC_PCFGR125_POF	(PPC.unPCFGR125.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR125_NFE	(*(volatile uint_io8_t*)0xB7200395)  /*@bfbba@*/
#define PPC_PCFGR125_ODR	(PPC.unPCFGR125.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR125_PDE	(*(volatile uint_io8_t*)0xB7200398)  /*@bfbba@*/
#define PPC_PCFGR125_PUE	(*(volatile uint_io8_t*)0xB7200399)  /*@bfbba@*/
#define PPC_PCFGR125_PIL	(PPC.unPCFGR125.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR125_PIE	(*(volatile uint_io8_t*)0xB720039C)  /*@bfbba@*/
#define PPC_PCFGR125_PID	(*(volatile uint_io8_t*)0xB720039D)  /*@bfbba@*/
#define PPC_PCFGR125_POD	(*(volatile uint_io8_t*)0xB720039E)  /*@bfbba@*/
#define PPC_PCFGR125_POE	(*(volatile uint_io8_t*)0xB720039F)  /*@bfbba@*/

#define PPC_PCFGR126	(PPC.unPCFGR126.u16Register)  /*@rg@*/
#define PPC_PCFGR126_POF	(PPC.unPCFGR126.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR126_NFE	(*(volatile uint_io8_t*)0xB72003A5)  /*@bfbba@*/
#define PPC_PCFGR126_ODR	(PPC.unPCFGR126.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR126_PDE	(*(volatile uint_io8_t*)0xB72003A8)  /*@bfbba@*/
#define PPC_PCFGR126_PUE	(*(volatile uint_io8_t*)0xB72003A9)  /*@bfbba@*/
#define PPC_PCFGR126_PIL	(PPC.unPCFGR126.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR126_PIE	(*(volatile uint_io8_t*)0xB72003AC)  /*@bfbba@*/
#define PPC_PCFGR126_PID	(*(volatile uint_io8_t*)0xB72003AD)  /*@bfbba@*/
#define PPC_PCFGR126_POD	(*(volatile uint_io8_t*)0xB72003AE)  /*@bfbba@*/
#define PPC_PCFGR126_POE	(*(volatile uint_io8_t*)0xB72003AF)  /*@bfbba@*/

#define PPC_PCFGR127	(PPC.unPCFGR127.u16Register)  /*@rg@*/
#define PPC_PCFGR127_POF	(PPC.unPCFGR127.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR127_NFE	(*(volatile uint_io8_t*)0xB72003B5)  /*@bfbba@*/
#define PPC_PCFGR127_ODR	(PPC.unPCFGR127.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR127_PDE	(*(volatile uint_io8_t*)0xB72003B8)  /*@bfbba@*/
#define PPC_PCFGR127_PUE	(*(volatile uint_io8_t*)0xB72003B9)  /*@bfbba@*/
#define PPC_PCFGR127_PIL	(PPC.unPCFGR127.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR127_PIE	(*(volatile uint_io8_t*)0xB72003BC)  /*@bfbba@*/
#define PPC_PCFGR127_PID	(*(volatile uint_io8_t*)0xB72003BD)  /*@bfbba@*/
#define PPC_PCFGR127_POD	(*(volatile uint_io8_t*)0xB72003BE)  /*@bfbba@*/
#define PPC_PCFGR127_POE	(*(volatile uint_io8_t*)0xB72003BF)  /*@bfbba@*/

#define PPC_PCFGR128	(PPC.unPCFGR128.u16Register)  /*@rg@*/
#define PPC_PCFGR128_POF	(PPC.unPCFGR128.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR128_NFE	(*(volatile uint_io8_t*)0xB72003C5)  /*@bfbba@*/
#define PPC_PCFGR128_ODR	(PPC.unPCFGR128.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR128_PDE	(*(volatile uint_io8_t*)0xB72003C8)  /*@bfbba@*/
#define PPC_PCFGR128_PUE	(*(volatile uint_io8_t*)0xB72003C9)  /*@bfbba@*/
#define PPC_PCFGR128_PIL	(PPC.unPCFGR128.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR128_PIE	(*(volatile uint_io8_t*)0xB72003CC)  /*@bfbba@*/
#define PPC_PCFGR128_PID	(*(volatile uint_io8_t*)0xB72003CD)  /*@bfbba@*/
#define PPC_PCFGR128_POD	(*(volatile uint_io8_t*)0xB72003CE)  /*@bfbba@*/
#define PPC_PCFGR128_POE	(*(volatile uint_io8_t*)0xB72003CF)  /*@bfbba@*/

#define PPC_PCFGR129	(PPC.unPCFGR129.u16Register)  /*@rg@*/
#define PPC_PCFGR129_POF	(PPC.unPCFGR129.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR129_NFE	(*(volatile uint_io8_t*)0xB72003D5)  /*@bfbba@*/
#define PPC_PCFGR129_ODR	(PPC.unPCFGR129.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR129_PDE	(*(volatile uint_io8_t*)0xB72003D8)  /*@bfbba@*/
#define PPC_PCFGR129_PUE	(*(volatile uint_io8_t*)0xB72003D9)  /*@bfbba@*/
#define PPC_PCFGR129_PIL	(PPC.unPCFGR129.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR129_PIE	(*(volatile uint_io8_t*)0xB72003DC)  /*@bfbba@*/
#define PPC_PCFGR129_PID	(*(volatile uint_io8_t*)0xB72003DD)  /*@bfbba@*/
#define PPC_PCFGR129_POD	(*(volatile uint_io8_t*)0xB72003DE)  /*@bfbba@*/
#define PPC_PCFGR129_POE	(*(volatile uint_io8_t*)0xB72003DF)  /*@bfbba@*/

#define PPC_PCFGR130	(PPC.unPCFGR130.u16Register)  /*@rg@*/
#define PPC_PCFGR130_POF	(PPC.unPCFGR130.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR130_NFE	(*(volatile uint_io8_t*)0xB72003E5)  /*@bfbba@*/
#define PPC_PCFGR130_ODR	(PPC.unPCFGR130.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR130_PDE	(*(volatile uint_io8_t*)0xB72003E8)  /*@bfbba@*/
#define PPC_PCFGR130_PUE	(*(volatile uint_io8_t*)0xB72003E9)  /*@bfbba@*/
#define PPC_PCFGR130_PIL	(PPC.unPCFGR130.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR130_PIE	(*(volatile uint_io8_t*)0xB72003EC)  /*@bfbba@*/
#define PPC_PCFGR130_PID	(*(volatile uint_io8_t*)0xB72003ED)  /*@bfbba@*/
#define PPC_PCFGR130_POD	(*(volatile uint_io8_t*)0xB72003EE)  /*@bfbba@*/
#define PPC_PCFGR130_POE	(*(volatile uint_io8_t*)0xB72003EF)  /*@bfbba@*/

#define PPC_PCFGR131	(PPC.unPCFGR131.u16Register)  /*@rg@*/
#define PPC_PCFGR131_POF	(PPC.unPCFGR131.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR131_NFE	(*(volatile uint_io8_t*)0xB72003F5)  /*@bfbba@*/
#define PPC_PCFGR131_ODR	(PPC.unPCFGR131.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR131_PDE	(*(volatile uint_io8_t*)0xB72003F8)  /*@bfbba@*/
#define PPC_PCFGR131_PUE	(*(volatile uint_io8_t*)0xB72003F9)  /*@bfbba@*/
#define PPC_PCFGR131_PIL	(PPC.unPCFGR131.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR131_PIE	(*(volatile uint_io8_t*)0xB72003FC)  /*@bfbba@*/
#define PPC_PCFGR131_PID	(*(volatile uint_io8_t*)0xB72003FD)  /*@bfbba@*/
#define PPC_PCFGR131_POD	(*(volatile uint_io8_t*)0xB72003FE)  /*@bfbba@*/
#define PPC_PCFGR131_POE	(*(volatile uint_io8_t*)0xB72003FF)  /*@bfbba@*/

#define PPC_PCFGR200	(PPC.unPCFGR200.u16Register)  /*@rg@*/
#define PPC_PCFGR200_POF	(PPC.unPCFGR200.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR200_NFE	(*(volatile uint_io8_t*)0xB7200405)  /*@bfbba@*/
#define PPC_PCFGR200_ODR	(PPC.unPCFGR200.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR200_PDE	(*(volatile uint_io8_t*)0xB7200408)  /*@bfbba@*/
#define PPC_PCFGR200_PUE	(*(volatile uint_io8_t*)0xB7200409)  /*@bfbba@*/
#define PPC_PCFGR200_PIL	(PPC.unPCFGR200.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR200_PIE	(*(volatile uint_io8_t*)0xB720040C)  /*@bfbba@*/
#define PPC_PCFGR200_PID	(*(volatile uint_io8_t*)0xB720040D)  /*@bfbba@*/
#define PPC_PCFGR200_POD	(*(volatile uint_io8_t*)0xB720040E)  /*@bfbba@*/
#define PPC_PCFGR200_POE	(*(volatile uint_io8_t*)0xB720040F)  /*@bfbba@*/

#define PPC_PCFGR201	(PPC.unPCFGR201.u16Register)  /*@rg@*/
#define PPC_PCFGR201_POF	(PPC.unPCFGR201.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR201_NFE	(*(volatile uint_io8_t*)0xB7200415)  /*@bfbba@*/
#define PPC_PCFGR201_ODR	(PPC.unPCFGR201.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR201_PDE	(*(volatile uint_io8_t*)0xB7200418)  /*@bfbba@*/
#define PPC_PCFGR201_PUE	(*(volatile uint_io8_t*)0xB7200419)  /*@bfbba@*/
#define PPC_PCFGR201_PIL	(PPC.unPCFGR201.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR201_PIE	(*(volatile uint_io8_t*)0xB720041C)  /*@bfbba@*/
#define PPC_PCFGR201_PID	(*(volatile uint_io8_t*)0xB720041D)  /*@bfbba@*/
#define PPC_PCFGR201_POD	(*(volatile uint_io8_t*)0xB720041E)  /*@bfbba@*/
#define PPC_PCFGR201_POE	(*(volatile uint_io8_t*)0xB720041F)  /*@bfbba@*/

#define PPC_PCFGR202	(PPC.unPCFGR202.u16Register)  /*@rg@*/
#define PPC_PCFGR202_POF	(PPC.unPCFGR202.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR202_NFE	(*(volatile uint_io8_t*)0xB7200425)  /*@bfbba@*/
#define PPC_PCFGR202_ODR	(PPC.unPCFGR202.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR202_PDE	(*(volatile uint_io8_t*)0xB7200428)  /*@bfbba@*/
#define PPC_PCFGR202_PUE	(*(volatile uint_io8_t*)0xB7200429)  /*@bfbba@*/
#define PPC_PCFGR202_PIL	(PPC.unPCFGR202.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR202_PIE	(*(volatile uint_io8_t*)0xB720042C)  /*@bfbba@*/
#define PPC_PCFGR202_PID	(*(volatile uint_io8_t*)0xB720042D)  /*@bfbba@*/
#define PPC_PCFGR202_POD	(*(volatile uint_io8_t*)0xB720042E)  /*@bfbba@*/
#define PPC_PCFGR202_POE	(*(volatile uint_io8_t*)0xB720042F)  /*@bfbba@*/

#define PPC_PCFGR203	(PPC.unPCFGR203.u16Register)  /*@rg@*/
#define PPC_PCFGR203_POF	(PPC.unPCFGR203.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR203_NFE	(*(volatile uint_io8_t*)0xB7200435)  /*@bfbba@*/
#define PPC_PCFGR203_ODR	(PPC.unPCFGR203.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR203_PDE	(*(volatile uint_io8_t*)0xB7200438)  /*@bfbba@*/
#define PPC_PCFGR203_PUE	(*(volatile uint_io8_t*)0xB7200439)  /*@bfbba@*/
#define PPC_PCFGR203_PIL	(PPC.unPCFGR203.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR203_PIE	(*(volatile uint_io8_t*)0xB720043C)  /*@bfbba@*/
#define PPC_PCFGR203_PID	(*(volatile uint_io8_t*)0xB720043D)  /*@bfbba@*/
#define PPC_PCFGR203_POD	(*(volatile uint_io8_t*)0xB720043E)  /*@bfbba@*/
#define PPC_PCFGR203_POE	(*(volatile uint_io8_t*)0xB720043F)  /*@bfbba@*/

#define PPC_PCFGR204	(PPC.unPCFGR204.u16Register)  /*@rg@*/
#define PPC_PCFGR204_POF	(PPC.unPCFGR204.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR204_NFE	(*(volatile uint_io8_t*)0xB7200445)  /*@bfbba@*/
#define PPC_PCFGR204_ODR	(PPC.unPCFGR204.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR204_PDE	(*(volatile uint_io8_t*)0xB7200448)  /*@bfbba@*/
#define PPC_PCFGR204_PUE	(*(volatile uint_io8_t*)0xB7200449)  /*@bfbba@*/
#define PPC_PCFGR204_PIL	(PPC.unPCFGR204.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR204_PIE	(*(volatile uint_io8_t*)0xB720044C)  /*@bfbba@*/
#define PPC_PCFGR204_PID	(*(volatile uint_io8_t*)0xB720044D)  /*@bfbba@*/
#define PPC_PCFGR204_POD	(*(volatile uint_io8_t*)0xB720044E)  /*@bfbba@*/
#define PPC_PCFGR204_POE	(*(volatile uint_io8_t*)0xB720044F)  /*@bfbba@*/

#define PPC_PCFGR205	(PPC.unPCFGR205.u16Register)  /*@rg@*/
#define PPC_PCFGR205_POF	(PPC.unPCFGR205.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR205_NFE	(*(volatile uint_io8_t*)0xB7200455)  /*@bfbba@*/
#define PPC_PCFGR205_ODR	(PPC.unPCFGR205.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR205_PDE	(*(volatile uint_io8_t*)0xB7200458)  /*@bfbba@*/
#define PPC_PCFGR205_PUE	(*(volatile uint_io8_t*)0xB7200459)  /*@bfbba@*/
#define PPC_PCFGR205_PIL	(PPC.unPCFGR205.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR205_PIE	(*(volatile uint_io8_t*)0xB720045C)  /*@bfbba@*/
#define PPC_PCFGR205_PID	(*(volatile uint_io8_t*)0xB720045D)  /*@bfbba@*/
#define PPC_PCFGR205_POD	(*(volatile uint_io8_t*)0xB720045E)  /*@bfbba@*/
#define PPC_PCFGR205_POE	(*(volatile uint_io8_t*)0xB720045F)  /*@bfbba@*/

#define PPC_PCFGR206	(PPC.unPCFGR206.u16Register)  /*@rg@*/
#define PPC_PCFGR206_POF	(PPC.unPCFGR206.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR206_NFE	(*(volatile uint_io8_t*)0xB7200465)  /*@bfbba@*/
#define PPC_PCFGR206_ODR	(PPC.unPCFGR206.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR206_PDE	(*(volatile uint_io8_t*)0xB7200468)  /*@bfbba@*/
#define PPC_PCFGR206_PUE	(*(volatile uint_io8_t*)0xB7200469)  /*@bfbba@*/
#define PPC_PCFGR206_PIL	(PPC.unPCFGR206.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR206_PIE	(*(volatile uint_io8_t*)0xB720046C)  /*@bfbba@*/
#define PPC_PCFGR206_PID	(*(volatile uint_io8_t*)0xB720046D)  /*@bfbba@*/
#define PPC_PCFGR206_POD	(*(volatile uint_io8_t*)0xB720046E)  /*@bfbba@*/
#define PPC_PCFGR206_POE	(*(volatile uint_io8_t*)0xB720046F)  /*@bfbba@*/

#define PPC_PCFGR207	(PPC.unPCFGR207.u16Register)  /*@rg@*/
#define PPC_PCFGR207_POF	(PPC.unPCFGR207.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR207_NFE	(*(volatile uint_io8_t*)0xB7200475)  /*@bfbba@*/
#define PPC_PCFGR207_ODR	(PPC.unPCFGR207.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR207_PDE	(*(volatile uint_io8_t*)0xB7200478)  /*@bfbba@*/
#define PPC_PCFGR207_PUE	(*(volatile uint_io8_t*)0xB7200479)  /*@bfbba@*/
#define PPC_PCFGR207_PIL	(PPC.unPCFGR207.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR207_PIE	(*(volatile uint_io8_t*)0xB720047C)  /*@bfbba@*/
#define PPC_PCFGR207_PID	(*(volatile uint_io8_t*)0xB720047D)  /*@bfbba@*/
#define PPC_PCFGR207_POD	(*(volatile uint_io8_t*)0xB720047E)  /*@bfbba@*/
#define PPC_PCFGR207_POE	(*(volatile uint_io8_t*)0xB720047F)  /*@bfbba@*/

#define PPC_PCFGR208	(PPC.unPCFGR208.u16Register)  /*@rg@*/
#define PPC_PCFGR208_POF	(PPC.unPCFGR208.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR208_NFE	(*(volatile uint_io8_t*)0xB7200485)  /*@bfbba@*/
#define PPC_PCFGR208_ODR	(PPC.unPCFGR208.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR208_PDE	(*(volatile uint_io8_t*)0xB7200488)  /*@bfbba@*/
#define PPC_PCFGR208_PUE	(*(volatile uint_io8_t*)0xB7200489)  /*@bfbba@*/
#define PPC_PCFGR208_PIL	(PPC.unPCFGR208.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR208_PIE	(*(volatile uint_io8_t*)0xB720048C)  /*@bfbba@*/
#define PPC_PCFGR208_PID	(*(volatile uint_io8_t*)0xB720048D)  /*@bfbba@*/
#define PPC_PCFGR208_POD	(*(volatile uint_io8_t*)0xB720048E)  /*@bfbba@*/
#define PPC_PCFGR208_POE	(*(volatile uint_io8_t*)0xB720048F)  /*@bfbba@*/

#define PPC_PCFGR209	(PPC.unPCFGR209.u16Register)  /*@rg@*/
#define PPC_PCFGR209_POF	(PPC.unPCFGR209.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR209_NFE	(*(volatile uint_io8_t*)0xB7200495)  /*@bfbba@*/
#define PPC_PCFGR209_ODR	(PPC.unPCFGR209.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR209_PDE	(*(volatile uint_io8_t*)0xB7200498)  /*@bfbba@*/
#define PPC_PCFGR209_PUE	(*(volatile uint_io8_t*)0xB7200499)  /*@bfbba@*/
#define PPC_PCFGR209_PIL	(PPC.unPCFGR209.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR209_PIE	(*(volatile uint_io8_t*)0xB720049C)  /*@bfbba@*/
#define PPC_PCFGR209_PID	(*(volatile uint_io8_t*)0xB720049D)  /*@bfbba@*/
#define PPC_PCFGR209_POD	(*(volatile uint_io8_t*)0xB720049E)  /*@bfbba@*/
#define PPC_PCFGR209_POE	(*(volatile uint_io8_t*)0xB720049F)  /*@bfbba@*/

#define PPC_PCFGR210	(PPC.unPCFGR210.u16Register)  /*@rg@*/
#define PPC_PCFGR210_POF	(PPC.unPCFGR210.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR210_NFE	(*(volatile uint_io8_t*)0xB72004A5)  /*@bfbba@*/
#define PPC_PCFGR210_ODR	(PPC.unPCFGR210.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR210_PDE	(*(volatile uint_io8_t*)0xB72004A8)  /*@bfbba@*/
#define PPC_PCFGR210_PUE	(*(volatile uint_io8_t*)0xB72004A9)  /*@bfbba@*/
#define PPC_PCFGR210_PIL	(PPC.unPCFGR210.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR210_PIE	(*(volatile uint_io8_t*)0xB72004AC)  /*@bfbba@*/
#define PPC_PCFGR210_PID	(*(volatile uint_io8_t*)0xB72004AD)  /*@bfbba@*/
#define PPC_PCFGR210_POD	(*(volatile uint_io8_t*)0xB72004AE)  /*@bfbba@*/
#define PPC_PCFGR210_POE	(*(volatile uint_io8_t*)0xB72004AF)  /*@bfbba@*/

#define PPC_PCFGR211	(PPC.unPCFGR211.u16Register)  /*@rg@*/
#define PPC_PCFGR211_POF	(PPC.unPCFGR211.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR211_NFE	(*(volatile uint_io8_t*)0xB72004B5)  /*@bfbba@*/
#define PPC_PCFGR211_ODR	(PPC.unPCFGR211.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR211_PDE	(*(volatile uint_io8_t*)0xB72004B8)  /*@bfbba@*/
#define PPC_PCFGR211_PUE	(*(volatile uint_io8_t*)0xB72004B9)  /*@bfbba@*/
#define PPC_PCFGR211_PIL	(PPC.unPCFGR211.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR211_PIE	(*(volatile uint_io8_t*)0xB72004BC)  /*@bfbba@*/
#define PPC_PCFGR211_PID	(*(volatile uint_io8_t*)0xB72004BD)  /*@bfbba@*/
#define PPC_PCFGR211_POD	(*(volatile uint_io8_t*)0xB72004BE)  /*@bfbba@*/
#define PPC_PCFGR211_POE	(*(volatile uint_io8_t*)0xB72004BF)  /*@bfbba@*/

#define PPC_PCFGR212	(PPC.unPCFGR212.u16Register)  /*@rg@*/
#define PPC_PCFGR212_POF	(PPC.unPCFGR212.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR212_NFE	(*(volatile uint_io8_t*)0xB72004C5)  /*@bfbba@*/
#define PPC_PCFGR212_ODR	(PPC.unPCFGR212.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR212_PDE	(*(volatile uint_io8_t*)0xB72004C8)  /*@bfbba@*/
#define PPC_PCFGR212_PUE	(*(volatile uint_io8_t*)0xB72004C9)  /*@bfbba@*/
#define PPC_PCFGR212_PIL	(PPC.unPCFGR212.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR212_PIE	(*(volatile uint_io8_t*)0xB72004CC)  /*@bfbba@*/
#define PPC_PCFGR212_PID	(*(volatile uint_io8_t*)0xB72004CD)  /*@bfbba@*/
#define PPC_PCFGR212_POD	(*(volatile uint_io8_t*)0xB72004CE)  /*@bfbba@*/
#define PPC_PCFGR212_POE	(*(volatile uint_io8_t*)0xB72004CF)  /*@bfbba@*/

#define PPC_PCFGR213	(PPC.unPCFGR213.u16Register)  /*@rg@*/
#define PPC_PCFGR213_POF	(PPC.unPCFGR213.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR213_NFE	(*(volatile uint_io8_t*)0xB72004D5)  /*@bfbba@*/
#define PPC_PCFGR213_ODR	(PPC.unPCFGR213.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR213_PDE	(*(volatile uint_io8_t*)0xB72004D8)  /*@bfbba@*/
#define PPC_PCFGR213_PUE	(*(volatile uint_io8_t*)0xB72004D9)  /*@bfbba@*/
#define PPC_PCFGR213_PIL	(PPC.unPCFGR213.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR213_PIE	(*(volatile uint_io8_t*)0xB72004DC)  /*@bfbba@*/
#define PPC_PCFGR213_PID	(*(volatile uint_io8_t*)0xB72004DD)  /*@bfbba@*/
#define PPC_PCFGR213_POD	(*(volatile uint_io8_t*)0xB72004DE)  /*@bfbba@*/
#define PPC_PCFGR213_POE	(*(volatile uint_io8_t*)0xB72004DF)  /*@bfbba@*/

#define PPC_PCFGR214	(PPC.unPCFGR214.u16Register)  /*@rg@*/
#define PPC_PCFGR214_POF	(PPC.unPCFGR214.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR214_NFE	(*(volatile uint_io8_t*)0xB72004E5)  /*@bfbba@*/
#define PPC_PCFGR214_ODR	(PPC.unPCFGR214.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR214_PDE	(*(volatile uint_io8_t*)0xB72004E8)  /*@bfbba@*/
#define PPC_PCFGR214_PUE	(*(volatile uint_io8_t*)0xB72004E9)  /*@bfbba@*/
#define PPC_PCFGR214_PIL	(PPC.unPCFGR214.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR214_PIE	(*(volatile uint_io8_t*)0xB72004EC)  /*@bfbba@*/
#define PPC_PCFGR214_PID	(*(volatile uint_io8_t*)0xB72004ED)  /*@bfbba@*/
#define PPC_PCFGR214_POD	(*(volatile uint_io8_t*)0xB72004EE)  /*@bfbba@*/
#define PPC_PCFGR214_POE	(*(volatile uint_io8_t*)0xB72004EF)  /*@bfbba@*/

#define PPC_PCFGR215	(PPC.unPCFGR215.u16Register)  /*@rg@*/
#define PPC_PCFGR215_POF	(PPC.unPCFGR215.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR215_NFE	(*(volatile uint_io8_t*)0xB72004F5)  /*@bfbba@*/
#define PPC_PCFGR215_ODR	(PPC.unPCFGR215.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR215_PDE	(*(volatile uint_io8_t*)0xB72004F8)  /*@bfbba@*/
#define PPC_PCFGR215_PUE	(*(volatile uint_io8_t*)0xB72004F9)  /*@bfbba@*/
#define PPC_PCFGR215_PIL	(PPC.unPCFGR215.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR215_PIE	(*(volatile uint_io8_t*)0xB72004FC)  /*@bfbba@*/
#define PPC_PCFGR215_PID	(*(volatile uint_io8_t*)0xB72004FD)  /*@bfbba@*/
#define PPC_PCFGR215_POD	(*(volatile uint_io8_t*)0xB72004FE)  /*@bfbba@*/
#define PPC_PCFGR215_POE	(*(volatile uint_io8_t*)0xB72004FF)  /*@bfbba@*/

#define PPC_PCFGR216	(PPC.unPCFGR216.u16Register)  /*@rg@*/
#define PPC_PCFGR216_POF	(PPC.unPCFGR216.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR216_NFE	(*(volatile uint_io8_t*)0xB7200505)  /*@bfbba@*/
#define PPC_PCFGR216_ODR	(PPC.unPCFGR216.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR216_PDE	(*(volatile uint_io8_t*)0xB7200508)  /*@bfbba@*/
#define PPC_PCFGR216_PUE	(*(volatile uint_io8_t*)0xB7200509)  /*@bfbba@*/
#define PPC_PCFGR216_PIL	(PPC.unPCFGR216.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR216_PIE	(*(volatile uint_io8_t*)0xB720050C)  /*@bfbba@*/
#define PPC_PCFGR216_PID	(*(volatile uint_io8_t*)0xB720050D)  /*@bfbba@*/
#define PPC_PCFGR216_POD	(*(volatile uint_io8_t*)0xB720050E)  /*@bfbba@*/
#define PPC_PCFGR216_POE	(*(volatile uint_io8_t*)0xB720050F)  /*@bfbba@*/

#define PPC_PCFGR217	(PPC.unPCFGR217.u16Register)  /*@rg@*/
#define PPC_PCFGR217_POF	(PPC.unPCFGR217.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR217_NFE	(*(volatile uint_io8_t*)0xB7200515)  /*@bfbba@*/
#define PPC_PCFGR217_ODR	(PPC.unPCFGR217.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR217_PDE	(*(volatile uint_io8_t*)0xB7200518)  /*@bfbba@*/
#define PPC_PCFGR217_PUE	(*(volatile uint_io8_t*)0xB7200519)  /*@bfbba@*/
#define PPC_PCFGR217_PIL	(PPC.unPCFGR217.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR217_PIE	(*(volatile uint_io8_t*)0xB720051C)  /*@bfbba@*/
#define PPC_PCFGR217_PID	(*(volatile uint_io8_t*)0xB720051D)  /*@bfbba@*/
#define PPC_PCFGR217_POD	(*(volatile uint_io8_t*)0xB720051E)  /*@bfbba@*/
#define PPC_PCFGR217_POE	(*(volatile uint_io8_t*)0xB720051F)  /*@bfbba@*/

#define PPC_PCFGR218	(PPC.unPCFGR218.u16Register)  /*@rg@*/
#define PPC_PCFGR218_POF	(PPC.unPCFGR218.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR218_NFE	(*(volatile uint_io8_t*)0xB7200525)  /*@bfbba@*/
#define PPC_PCFGR218_ODR	(PPC.unPCFGR218.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR218_PDE	(*(volatile uint_io8_t*)0xB7200528)  /*@bfbba@*/
#define PPC_PCFGR218_PUE	(*(volatile uint_io8_t*)0xB7200529)  /*@bfbba@*/
#define PPC_PCFGR218_PIL	(PPC.unPCFGR218.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR218_PIE	(*(volatile uint_io8_t*)0xB720052C)  /*@bfbba@*/
#define PPC_PCFGR218_PID	(*(volatile uint_io8_t*)0xB720052D)  /*@bfbba@*/
#define PPC_PCFGR218_POD	(*(volatile uint_io8_t*)0xB720052E)  /*@bfbba@*/
#define PPC_PCFGR218_POE	(*(volatile uint_io8_t*)0xB720052F)  /*@bfbba@*/

#define PPC_PCFGR219	(PPC.unPCFGR219.u16Register)  /*@rg@*/
#define PPC_PCFGR219_POF	(PPC.unPCFGR219.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR219_NFE	(*(volatile uint_io8_t*)0xB7200535)  /*@bfbba@*/
#define PPC_PCFGR219_ODR	(PPC.unPCFGR219.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR219_PDE	(*(volatile uint_io8_t*)0xB7200538)  /*@bfbba@*/
#define PPC_PCFGR219_PUE	(*(volatile uint_io8_t*)0xB7200539)  /*@bfbba@*/
#define PPC_PCFGR219_PIL	(PPC.unPCFGR219.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR219_PIE	(*(volatile uint_io8_t*)0xB720053C)  /*@bfbba@*/
#define PPC_PCFGR219_PID	(*(volatile uint_io8_t*)0xB720053D)  /*@bfbba@*/
#define PPC_PCFGR219_POD	(*(volatile uint_io8_t*)0xB720053E)  /*@bfbba@*/
#define PPC_PCFGR219_POE	(*(volatile uint_io8_t*)0xB720053F)  /*@bfbba@*/

#define PPC_PCFGR220	(PPC.unPCFGR220.u16Register)  /*@rg@*/
#define PPC_PCFGR220_POF	(PPC.unPCFGR220.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR220_NFE	(*(volatile uint_io8_t*)0xB7200545)  /*@bfbba@*/
#define PPC_PCFGR220_ODR	(PPC.unPCFGR220.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR220_PDE	(*(volatile uint_io8_t*)0xB7200548)  /*@bfbba@*/
#define PPC_PCFGR220_PUE	(*(volatile uint_io8_t*)0xB7200549)  /*@bfbba@*/
#define PPC_PCFGR220_PIL	(PPC.unPCFGR220.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR220_PIE	(*(volatile uint_io8_t*)0xB720054C)  /*@bfbba@*/
#define PPC_PCFGR220_PID	(*(volatile uint_io8_t*)0xB720054D)  /*@bfbba@*/
#define PPC_PCFGR220_POD	(*(volatile uint_io8_t*)0xB720054E)  /*@bfbba@*/
#define PPC_PCFGR220_POE	(*(volatile uint_io8_t*)0xB720054F)  /*@bfbba@*/

#define PPC_PCFGR221	(PPC.unPCFGR221.u16Register)  /*@rg@*/
#define PPC_PCFGR221_POF	(PPC.unPCFGR221.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR221_NFE	(*(volatile uint_io8_t*)0xB7200555)  /*@bfbba@*/
#define PPC_PCFGR221_ODR	(PPC.unPCFGR221.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR221_PDE	(*(volatile uint_io8_t*)0xB7200558)  /*@bfbba@*/
#define PPC_PCFGR221_PUE	(*(volatile uint_io8_t*)0xB7200559)  /*@bfbba@*/
#define PPC_PCFGR221_PIL	(PPC.unPCFGR221.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR221_PIE	(*(volatile uint_io8_t*)0xB720055C)  /*@bfbba@*/
#define PPC_PCFGR221_PID	(*(volatile uint_io8_t*)0xB720055D)  /*@bfbba@*/
#define PPC_PCFGR221_POD	(*(volatile uint_io8_t*)0xB720055E)  /*@bfbba@*/
#define PPC_PCFGR221_POE	(*(volatile uint_io8_t*)0xB720055F)  /*@bfbba@*/

#define PPC_PCFGR222	(PPC.unPCFGR222.u16Register)  /*@rg@*/
#define PPC_PCFGR222_POF	(PPC.unPCFGR222.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR222_NFE	(*(volatile uint_io8_t*)0xB7200565)  /*@bfbba@*/
#define PPC_PCFGR222_ODR	(PPC.unPCFGR222.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR222_PDE	(*(volatile uint_io8_t*)0xB7200568)  /*@bfbba@*/
#define PPC_PCFGR222_PUE	(*(volatile uint_io8_t*)0xB7200569)  /*@bfbba@*/
#define PPC_PCFGR222_PIL	(PPC.unPCFGR222.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR222_PIE	(*(volatile uint_io8_t*)0xB720056C)  /*@bfbba@*/
#define PPC_PCFGR222_PID	(*(volatile uint_io8_t*)0xB720056D)  /*@bfbba@*/
#define PPC_PCFGR222_POD	(*(volatile uint_io8_t*)0xB720056E)  /*@bfbba@*/
#define PPC_PCFGR222_POE	(*(volatile uint_io8_t*)0xB720056F)  /*@bfbba@*/

#define PPC_PCFGR223	(PPC.unPCFGR223.u16Register)  /*@rg@*/
#define PPC_PCFGR223_POF	(PPC.unPCFGR223.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR223_NFE	(*(volatile uint_io8_t*)0xB7200575)  /*@bfbba@*/
#define PPC_PCFGR223_ODR	(PPC.unPCFGR223.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR223_PDE	(*(volatile uint_io8_t*)0xB7200578)  /*@bfbba@*/
#define PPC_PCFGR223_PUE	(*(volatile uint_io8_t*)0xB7200579)  /*@bfbba@*/
#define PPC_PCFGR223_PIL	(PPC.unPCFGR223.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR223_PIE	(*(volatile uint_io8_t*)0xB720057C)  /*@bfbba@*/
#define PPC_PCFGR223_PID	(*(volatile uint_io8_t*)0xB720057D)  /*@bfbba@*/
#define PPC_PCFGR223_POD	(*(volatile uint_io8_t*)0xB720057E)  /*@bfbba@*/
#define PPC_PCFGR223_POE	(*(volatile uint_io8_t*)0xB720057F)  /*@bfbba@*/

#define PPC_PCFGR224	(PPC.unPCFGR224.u16Register)  /*@rg@*/
#define PPC_PCFGR224_POF	(PPC.unPCFGR224.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR224_NFE	(*(volatile uint_io8_t*)0xB7200585)  /*@bfbba@*/
#define PPC_PCFGR224_ODR	(PPC.unPCFGR224.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR224_PDE	(*(volatile uint_io8_t*)0xB7200588)  /*@bfbba@*/
#define PPC_PCFGR224_PUE	(*(volatile uint_io8_t*)0xB7200589)  /*@bfbba@*/
#define PPC_PCFGR224_PIL	(PPC.unPCFGR224.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR224_PIE	(*(volatile uint_io8_t*)0xB720058C)  /*@bfbba@*/
#define PPC_PCFGR224_PID	(*(volatile uint_io8_t*)0xB720058D)  /*@bfbba@*/
#define PPC_PCFGR224_POD	(*(volatile uint_io8_t*)0xB720058E)  /*@bfbba@*/
#define PPC_PCFGR224_POE	(*(volatile uint_io8_t*)0xB720058F)  /*@bfbba@*/

#define PPC_PCFGR225	(PPC.unPCFGR225.u16Register)  /*@rg@*/
#define PPC_PCFGR225_POF	(PPC.unPCFGR225.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR225_NFE	(*(volatile uint_io8_t*)0xB7200595)  /*@bfbba@*/
#define PPC_PCFGR225_ODR	(PPC.unPCFGR225.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR225_PDE	(*(volatile uint_io8_t*)0xB7200598)  /*@bfbba@*/
#define PPC_PCFGR225_PUE	(*(volatile uint_io8_t*)0xB7200599)  /*@bfbba@*/
#define PPC_PCFGR225_PIL	(PPC.unPCFGR225.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR225_PIE	(*(volatile uint_io8_t*)0xB720059C)  /*@bfbba@*/
#define PPC_PCFGR225_PID	(*(volatile uint_io8_t*)0xB720059D)  /*@bfbba@*/
#define PPC_PCFGR225_POD	(*(volatile uint_io8_t*)0xB720059E)  /*@bfbba@*/
#define PPC_PCFGR225_POE	(*(volatile uint_io8_t*)0xB720059F)  /*@bfbba@*/

#define PPC_PCFGR226	(PPC.unPCFGR226.u16Register)  /*@rg@*/
#define PPC_PCFGR226_POF	(PPC.unPCFGR226.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR226_NFE	(*(volatile uint_io8_t*)0xB72005A5)  /*@bfbba@*/
#define PPC_PCFGR226_ODR	(PPC.unPCFGR226.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR226_PDE	(*(volatile uint_io8_t*)0xB72005A8)  /*@bfbba@*/
#define PPC_PCFGR226_PUE	(*(volatile uint_io8_t*)0xB72005A9)  /*@bfbba@*/
#define PPC_PCFGR226_PIL	(PPC.unPCFGR226.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR226_PIE	(*(volatile uint_io8_t*)0xB72005AC)  /*@bfbba@*/
#define PPC_PCFGR226_PID	(*(volatile uint_io8_t*)0xB72005AD)  /*@bfbba@*/
#define PPC_PCFGR226_POD	(*(volatile uint_io8_t*)0xB72005AE)  /*@bfbba@*/
#define PPC_PCFGR226_POE	(*(volatile uint_io8_t*)0xB72005AF)  /*@bfbba@*/

#define PPC_PCFGR227	(PPC.unPCFGR227.u16Register)  /*@rg@*/
#define PPC_PCFGR227_POF	(PPC.unPCFGR227.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR227_NFE	(*(volatile uint_io8_t*)0xB72005B5)  /*@bfbba@*/
#define PPC_PCFGR227_ODR	(PPC.unPCFGR227.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR227_PDE	(*(volatile uint_io8_t*)0xB72005B8)  /*@bfbba@*/
#define PPC_PCFGR227_PUE	(*(volatile uint_io8_t*)0xB72005B9)  /*@bfbba@*/
#define PPC_PCFGR227_PIL	(PPC.unPCFGR227.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR227_PIE	(*(volatile uint_io8_t*)0xB72005BC)  /*@bfbba@*/
#define PPC_PCFGR227_PID	(*(volatile uint_io8_t*)0xB72005BD)  /*@bfbba@*/
#define PPC_PCFGR227_POD	(*(volatile uint_io8_t*)0xB72005BE)  /*@bfbba@*/
#define PPC_PCFGR227_POE	(*(volatile uint_io8_t*)0xB72005BF)  /*@bfbba@*/

#define PPC_PCFGR228	(PPC.unPCFGR228.u16Register)  /*@rg@*/
#define PPC_PCFGR228_POF	(PPC.unPCFGR228.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR228_NFE	(*(volatile uint_io8_t*)0xB72005C5)  /*@bfbba@*/
#define PPC_PCFGR228_ODR	(PPC.unPCFGR228.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR228_PDE	(*(volatile uint_io8_t*)0xB72005C8)  /*@bfbba@*/
#define PPC_PCFGR228_PUE	(*(volatile uint_io8_t*)0xB72005C9)  /*@bfbba@*/
#define PPC_PCFGR228_PIL	(PPC.unPCFGR228.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR228_PIE	(*(volatile uint_io8_t*)0xB72005CC)  /*@bfbba@*/
#define PPC_PCFGR228_PID	(*(volatile uint_io8_t*)0xB72005CD)  /*@bfbba@*/
#define PPC_PCFGR228_POD	(*(volatile uint_io8_t*)0xB72005CE)  /*@bfbba@*/
#define PPC_PCFGR228_POE	(*(volatile uint_io8_t*)0xB72005CF)  /*@bfbba@*/

#define PPC_PCFGR229	(PPC.unPCFGR229.u16Register)  /*@rg@*/
#define PPC_PCFGR229_POF	(PPC.unPCFGR229.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR229_NFE	(*(volatile uint_io8_t*)0xB72005D5)  /*@bfbba@*/
#define PPC_PCFGR229_ODR	(PPC.unPCFGR229.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR229_PDE	(*(volatile uint_io8_t*)0xB72005D8)  /*@bfbba@*/
#define PPC_PCFGR229_PUE	(*(volatile uint_io8_t*)0xB72005D9)  /*@bfbba@*/
#define PPC_PCFGR229_PIL	(PPC.unPCFGR229.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR229_PIE	(*(volatile uint_io8_t*)0xB72005DC)  /*@bfbba@*/
#define PPC_PCFGR229_PID	(*(volatile uint_io8_t*)0xB72005DD)  /*@bfbba@*/
#define PPC_PCFGR229_POD	(*(volatile uint_io8_t*)0xB72005DE)  /*@bfbba@*/
#define PPC_PCFGR229_POE	(*(volatile uint_io8_t*)0xB72005DF)  /*@bfbba@*/

#define PPC_PCFGR230	(PPC.unPCFGR230.u16Register)  /*@rg@*/
#define PPC_PCFGR230_POF	(PPC.unPCFGR230.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR230_NFE	(*(volatile uint_io8_t*)0xB72005E5)  /*@bfbba@*/
#define PPC_PCFGR230_ODR	(PPC.unPCFGR230.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR230_PDE	(*(volatile uint_io8_t*)0xB72005E8)  /*@bfbba@*/
#define PPC_PCFGR230_PUE	(*(volatile uint_io8_t*)0xB72005E9)  /*@bfbba@*/
#define PPC_PCFGR230_PIL	(PPC.unPCFGR230.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR230_PIE	(*(volatile uint_io8_t*)0xB72005EC)  /*@bfbba@*/
#define PPC_PCFGR230_PID	(*(volatile uint_io8_t*)0xB72005ED)  /*@bfbba@*/
#define PPC_PCFGR230_POD	(*(volatile uint_io8_t*)0xB72005EE)  /*@bfbba@*/
#define PPC_PCFGR230_POE	(*(volatile uint_io8_t*)0xB72005EF)  /*@bfbba@*/

#define PPC_PCFGR231	(PPC.unPCFGR231.u16Register)  /*@rg@*/
#define PPC_PCFGR231_POF	(PPC.unPCFGR231.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR231_NFE	(*(volatile uint_io8_t*)0xB72005F5)  /*@bfbba@*/
#define PPC_PCFGR231_ODR	(PPC.unPCFGR231.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR231_PDE	(*(volatile uint_io8_t*)0xB72005F8)  /*@bfbba@*/
#define PPC_PCFGR231_PUE	(*(volatile uint_io8_t*)0xB72005F9)  /*@bfbba@*/
#define PPC_PCFGR231_PIL	(PPC.unPCFGR231.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR231_PIE	(*(volatile uint_io8_t*)0xB72005FC)  /*@bfbba@*/
#define PPC_PCFGR231_PID	(*(volatile uint_io8_t*)0xB72005FD)  /*@bfbba@*/
#define PPC_PCFGR231_POD	(*(volatile uint_io8_t*)0xB72005FE)  /*@bfbba@*/
#define PPC_PCFGR231_POE	(*(volatile uint_io8_t*)0xB72005FF)  /*@bfbba@*/

#define PPC_PCFGR300	(PPC.unPCFGR300.u16Register)  /*@rg@*/
#define PPC_PCFGR300_POF	(PPC.unPCFGR300.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR300_NFE	(*(volatile uint_io8_t*)0xB7200605)  /*@bfbba@*/
#define PPC_PCFGR300_ODR	(PPC.unPCFGR300.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR300_PDE	(*(volatile uint_io8_t*)0xB7200608)  /*@bfbba@*/
#define PPC_PCFGR300_PUE	(*(volatile uint_io8_t*)0xB7200609)  /*@bfbba@*/
#define PPC_PCFGR300_PIL	(PPC.unPCFGR300.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR300_PIE	(*(volatile uint_io8_t*)0xB720060C)  /*@bfbba@*/
#define PPC_PCFGR300_PID	(*(volatile uint_io8_t*)0xB720060D)  /*@bfbba@*/
#define PPC_PCFGR300_POD	(*(volatile uint_io8_t*)0xB720060E)  /*@bfbba@*/
#define PPC_PCFGR300_POE	(*(volatile uint_io8_t*)0xB720060F)  /*@bfbba@*/

#define PPC_PCFGR301	(PPC.unPCFGR301.u16Register)  /*@rg@*/
#define PPC_PCFGR301_POF	(PPC.unPCFGR301.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR301_NFE	(*(volatile uint_io8_t*)0xB7200615)  /*@bfbba@*/
#define PPC_PCFGR301_ODR	(PPC.unPCFGR301.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR301_PDE	(*(volatile uint_io8_t*)0xB7200618)  /*@bfbba@*/
#define PPC_PCFGR301_PUE	(*(volatile uint_io8_t*)0xB7200619)  /*@bfbba@*/
#define PPC_PCFGR301_PIL	(PPC.unPCFGR301.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR301_PIE	(*(volatile uint_io8_t*)0xB720061C)  /*@bfbba@*/
#define PPC_PCFGR301_PID	(*(volatile uint_io8_t*)0xB720061D)  /*@bfbba@*/
#define PPC_PCFGR301_POD	(*(volatile uint_io8_t*)0xB720061E)  /*@bfbba@*/
#define PPC_PCFGR301_POE	(*(volatile uint_io8_t*)0xB720061F)  /*@bfbba@*/

#define PPC_PCFGR302	(PPC.unPCFGR302.u16Register)  /*@rg@*/
#define PPC_PCFGR302_POF	(PPC.unPCFGR302.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR302_NFE	(*(volatile uint_io8_t*)0xB7200625)  /*@bfbba@*/
#define PPC_PCFGR302_ODR	(PPC.unPCFGR302.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR302_PDE	(*(volatile uint_io8_t*)0xB7200628)  /*@bfbba@*/
#define PPC_PCFGR302_PUE	(*(volatile uint_io8_t*)0xB7200629)  /*@bfbba@*/
#define PPC_PCFGR302_PIL	(PPC.unPCFGR302.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR302_PIE	(*(volatile uint_io8_t*)0xB720062C)  /*@bfbba@*/
#define PPC_PCFGR302_PID	(*(volatile uint_io8_t*)0xB720062D)  /*@bfbba@*/
#define PPC_PCFGR302_POD	(*(volatile uint_io8_t*)0xB720062E)  /*@bfbba@*/
#define PPC_PCFGR302_POE	(*(volatile uint_io8_t*)0xB720062F)  /*@bfbba@*/

#define PPC_PCFGR303	(PPC.unPCFGR303.u16Register)  /*@rg@*/
#define PPC_PCFGR303_POF	(PPC.unPCFGR303.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR303_NFE	(*(volatile uint_io8_t*)0xB7200635)  /*@bfbba@*/
#define PPC_PCFGR303_ODR	(PPC.unPCFGR303.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR303_PDE	(*(volatile uint_io8_t*)0xB7200638)  /*@bfbba@*/
#define PPC_PCFGR303_PUE	(*(volatile uint_io8_t*)0xB7200639)  /*@bfbba@*/
#define PPC_PCFGR303_PIL	(PPC.unPCFGR303.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR303_PIE	(*(volatile uint_io8_t*)0xB720063C)  /*@bfbba@*/
#define PPC_PCFGR303_PID	(*(volatile uint_io8_t*)0xB720063D)  /*@bfbba@*/
#define PPC_PCFGR303_POD	(*(volatile uint_io8_t*)0xB720063E)  /*@bfbba@*/
#define PPC_PCFGR303_POE	(*(volatile uint_io8_t*)0xB720063F)  /*@bfbba@*/

#define PPC_PCFGR304	(PPC.unPCFGR304.u16Register)  /*@rg@*/
#define PPC_PCFGR304_POF	(PPC.unPCFGR304.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR304_NFE	(*(volatile uint_io8_t*)0xB7200645)  /*@bfbba@*/
#define PPC_PCFGR304_ODR	(PPC.unPCFGR304.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR304_PDE	(*(volatile uint_io8_t*)0xB7200648)  /*@bfbba@*/
#define PPC_PCFGR304_PUE	(*(volatile uint_io8_t*)0xB7200649)  /*@bfbba@*/
#define PPC_PCFGR304_PIL	(PPC.unPCFGR304.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR304_PIE	(*(volatile uint_io8_t*)0xB720064C)  /*@bfbba@*/
#define PPC_PCFGR304_PID	(*(volatile uint_io8_t*)0xB720064D)  /*@bfbba@*/
#define PPC_PCFGR304_POD	(*(volatile uint_io8_t*)0xB720064E)  /*@bfbba@*/
#define PPC_PCFGR304_POE	(*(volatile uint_io8_t*)0xB720064F)  /*@bfbba@*/

#define PPC_PCFGR305	(PPC.unPCFGR305.u16Register)  /*@rg@*/
#define PPC_PCFGR305_POF	(PPC.unPCFGR305.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR305_NFE	(*(volatile uint_io8_t*)0xB7200655)  /*@bfbba@*/
#define PPC_PCFGR305_ODR	(PPC.unPCFGR305.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR305_PDE	(*(volatile uint_io8_t*)0xB7200658)  /*@bfbba@*/
#define PPC_PCFGR305_PUE	(*(volatile uint_io8_t*)0xB7200659)  /*@bfbba@*/
#define PPC_PCFGR305_PIL	(PPC.unPCFGR305.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR305_PIE	(*(volatile uint_io8_t*)0xB720065C)  /*@bfbba@*/
#define PPC_PCFGR305_PID	(*(volatile uint_io8_t*)0xB720065D)  /*@bfbba@*/
#define PPC_PCFGR305_POD	(*(volatile uint_io8_t*)0xB720065E)  /*@bfbba@*/
#define PPC_PCFGR305_POE	(*(volatile uint_io8_t*)0xB720065F)  /*@bfbba@*/

#define PPC_PCFGR306	(PPC.unPCFGR306.u16Register)  /*@rg@*/
#define PPC_PCFGR306_POF	(PPC.unPCFGR306.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR306_NFE	(*(volatile uint_io8_t*)0xB7200665)  /*@bfbba@*/
#define PPC_PCFGR306_ODR	(PPC.unPCFGR306.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR306_PDE	(*(volatile uint_io8_t*)0xB7200668)  /*@bfbba@*/
#define PPC_PCFGR306_PUE	(*(volatile uint_io8_t*)0xB7200669)  /*@bfbba@*/
#define PPC_PCFGR306_PIL	(PPC.unPCFGR306.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR306_PIE	(*(volatile uint_io8_t*)0xB720066C)  /*@bfbba@*/
#define PPC_PCFGR306_PID	(*(volatile uint_io8_t*)0xB720066D)  /*@bfbba@*/
#define PPC_PCFGR306_POD	(*(volatile uint_io8_t*)0xB720066E)  /*@bfbba@*/
#define PPC_PCFGR306_POE	(*(volatile uint_io8_t*)0xB720066F)  /*@bfbba@*/

#define PPC_PCFGR307	(PPC.unPCFGR307.u16Register)  /*@rg@*/
#define PPC_PCFGR307_POF	(PPC.unPCFGR307.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR307_NFE	(*(volatile uint_io8_t*)0xB7200675)  /*@bfbba@*/
#define PPC_PCFGR307_ODR	(PPC.unPCFGR307.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR307_PDE	(*(volatile uint_io8_t*)0xB7200678)  /*@bfbba@*/
#define PPC_PCFGR307_PUE	(*(volatile uint_io8_t*)0xB7200679)  /*@bfbba@*/
#define PPC_PCFGR307_PIL	(PPC.unPCFGR307.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR307_PIE	(*(volatile uint_io8_t*)0xB720067C)  /*@bfbba@*/
#define PPC_PCFGR307_PID	(*(volatile uint_io8_t*)0xB720067D)  /*@bfbba@*/
#define PPC_PCFGR307_POD	(*(volatile uint_io8_t*)0xB720067E)  /*@bfbba@*/
#define PPC_PCFGR307_POE	(*(volatile uint_io8_t*)0xB720067F)  /*@bfbba@*/

#define PPC_PCFGR308	(PPC.unPCFGR308.u16Register)  /*@rg@*/
#define PPC_PCFGR308_POF	(PPC.unPCFGR308.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR308_NFE	(*(volatile uint_io8_t*)0xB7200685)  /*@bfbba@*/
#define PPC_PCFGR308_ODR	(PPC.unPCFGR308.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR308_PDE	(*(volatile uint_io8_t*)0xB7200688)  /*@bfbba@*/
#define PPC_PCFGR308_PUE	(*(volatile uint_io8_t*)0xB7200689)  /*@bfbba@*/
#define PPC_PCFGR308_PIL	(PPC.unPCFGR308.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR308_PIE	(*(volatile uint_io8_t*)0xB720068C)  /*@bfbba@*/
#define PPC_PCFGR308_PID	(*(volatile uint_io8_t*)0xB720068D)  /*@bfbba@*/
#define PPC_PCFGR308_POD	(*(volatile uint_io8_t*)0xB720068E)  /*@bfbba@*/
#define PPC_PCFGR308_POE	(*(volatile uint_io8_t*)0xB720068F)  /*@bfbba@*/

#define PPC_PCFGR309	(PPC.unPCFGR309.u16Register)  /*@rg@*/
#define PPC_PCFGR309_POF	(PPC.unPCFGR309.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR309_NFE	(*(volatile uint_io8_t*)0xB7200695)  /*@bfbba@*/
#define PPC_PCFGR309_ODR	(PPC.unPCFGR309.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR309_PDE	(*(volatile uint_io8_t*)0xB7200698)  /*@bfbba@*/
#define PPC_PCFGR309_PUE	(*(volatile uint_io8_t*)0xB7200699)  /*@bfbba@*/
#define PPC_PCFGR309_PIL	(PPC.unPCFGR309.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR309_PIE	(*(volatile uint_io8_t*)0xB720069C)  /*@bfbba@*/
#define PPC_PCFGR309_PID	(*(volatile uint_io8_t*)0xB720069D)  /*@bfbba@*/
#define PPC_PCFGR309_POD	(*(volatile uint_io8_t*)0xB720069E)  /*@bfbba@*/
#define PPC_PCFGR309_POE	(*(volatile uint_io8_t*)0xB720069F)  /*@bfbba@*/

#define PPC_PCFGR310	(PPC.unPCFGR310.u16Register)  /*@rg@*/
#define PPC_PCFGR310_POF	(PPC.unPCFGR310.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR310_NFE	(*(volatile uint_io8_t*)0xB72006A5)  /*@bfbba@*/
#define PPC_PCFGR310_ODR	(PPC.unPCFGR310.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR310_PDE	(*(volatile uint_io8_t*)0xB72006A8)  /*@bfbba@*/
#define PPC_PCFGR310_PUE	(*(volatile uint_io8_t*)0xB72006A9)  /*@bfbba@*/
#define PPC_PCFGR310_PIL	(PPC.unPCFGR310.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR310_PIE	(*(volatile uint_io8_t*)0xB72006AC)  /*@bfbba@*/
#define PPC_PCFGR310_PID	(*(volatile uint_io8_t*)0xB72006AD)  /*@bfbba@*/
#define PPC_PCFGR310_POD	(*(volatile uint_io8_t*)0xB72006AE)  /*@bfbba@*/
#define PPC_PCFGR310_POE	(*(volatile uint_io8_t*)0xB72006AF)  /*@bfbba@*/

#define PPC_PCFGR311	(PPC.unPCFGR311.u16Register)  /*@rg@*/
#define PPC_PCFGR311_POF	(PPC.unPCFGR311.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR311_NFE	(*(volatile uint_io8_t*)0xB72006B5)  /*@bfbba@*/
#define PPC_PCFGR311_ODR	(PPC.unPCFGR311.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR311_PDE	(*(volatile uint_io8_t*)0xB72006B8)  /*@bfbba@*/
#define PPC_PCFGR311_PUE	(*(volatile uint_io8_t*)0xB72006B9)  /*@bfbba@*/
#define PPC_PCFGR311_PIL	(PPC.unPCFGR311.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR311_PIE	(*(volatile uint_io8_t*)0xB72006BC)  /*@bfbba@*/
#define PPC_PCFGR311_PID	(*(volatile uint_io8_t*)0xB72006BD)  /*@bfbba@*/
#define PPC_PCFGR311_POD	(*(volatile uint_io8_t*)0xB72006BE)  /*@bfbba@*/
#define PPC_PCFGR311_POE	(*(volatile uint_io8_t*)0xB72006BF)  /*@bfbba@*/

#define PPC_PCFGR312	(PPC.unPCFGR312.u16Register)  /*@rg@*/
#define PPC_PCFGR312_POF	(PPC.unPCFGR312.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR312_NFE	(*(volatile uint_io8_t*)0xB72006C5)  /*@bfbba@*/
#define PPC_PCFGR312_ODR	(PPC.unPCFGR312.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR312_PDE	(*(volatile uint_io8_t*)0xB72006C8)  /*@bfbba@*/
#define PPC_PCFGR312_PUE	(*(volatile uint_io8_t*)0xB72006C9)  /*@bfbba@*/
#define PPC_PCFGR312_PIL	(PPC.unPCFGR312.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR312_PIE	(*(volatile uint_io8_t*)0xB72006CC)  /*@bfbba@*/
#define PPC_PCFGR312_PID	(*(volatile uint_io8_t*)0xB72006CD)  /*@bfbba@*/
#define PPC_PCFGR312_POD	(*(volatile uint_io8_t*)0xB72006CE)  /*@bfbba@*/
#define PPC_PCFGR312_POE	(*(volatile uint_io8_t*)0xB72006CF)  /*@bfbba@*/

#define PPC_PCFGR313	(PPC.unPCFGR313.u16Register)  /*@rg@*/
#define PPC_PCFGR313_POF	(PPC.unPCFGR313.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR313_NFE	(*(volatile uint_io8_t*)0xB72006D5)  /*@bfbba@*/
#define PPC_PCFGR313_ODR	(PPC.unPCFGR313.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR313_PDE	(*(volatile uint_io8_t*)0xB72006D8)  /*@bfbba@*/
#define PPC_PCFGR313_PUE	(*(volatile uint_io8_t*)0xB72006D9)  /*@bfbba@*/
#define PPC_PCFGR313_PIL	(PPC.unPCFGR313.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR313_PIE	(*(volatile uint_io8_t*)0xB72006DC)  /*@bfbba@*/
#define PPC_PCFGR313_PID	(*(volatile uint_io8_t*)0xB72006DD)  /*@bfbba@*/
#define PPC_PCFGR313_POD	(*(volatile uint_io8_t*)0xB72006DE)  /*@bfbba@*/
#define PPC_PCFGR313_POE	(*(volatile uint_io8_t*)0xB72006DF)  /*@bfbba@*/

#define PPC_PCFGR314	(PPC.unPCFGR314.u16Register)  /*@rg@*/
#define PPC_PCFGR314_POF	(PPC.unPCFGR314.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR314_NFE	(*(volatile uint_io8_t*)0xB72006E5)  /*@bfbba@*/
#define PPC_PCFGR314_ODR	(PPC.unPCFGR314.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR314_PDE	(*(volatile uint_io8_t*)0xB72006E8)  /*@bfbba@*/
#define PPC_PCFGR314_PUE	(*(volatile uint_io8_t*)0xB72006E9)  /*@bfbba@*/
#define PPC_PCFGR314_PIL	(PPC.unPCFGR314.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR314_PIE	(*(volatile uint_io8_t*)0xB72006EC)  /*@bfbba@*/
#define PPC_PCFGR314_PID	(*(volatile uint_io8_t*)0xB72006ED)  /*@bfbba@*/
#define PPC_PCFGR314_POD	(*(volatile uint_io8_t*)0xB72006EE)  /*@bfbba@*/
#define PPC_PCFGR314_POE	(*(volatile uint_io8_t*)0xB72006EF)  /*@bfbba@*/

#define PPC_PCFGR315	(PPC.unPCFGR315.u16Register)  /*@rg@*/
#define PPC_PCFGR315_POF	(PPC.unPCFGR315.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR315_NFE	(*(volatile uint_io8_t*)0xB72006F5)  /*@bfbba@*/
#define PPC_PCFGR315_ODR	(PPC.unPCFGR315.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR315_PDE	(*(volatile uint_io8_t*)0xB72006F8)  /*@bfbba@*/
#define PPC_PCFGR315_PUE	(*(volatile uint_io8_t*)0xB72006F9)  /*@bfbba@*/
#define PPC_PCFGR315_PIL	(PPC.unPCFGR315.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR315_PIE	(*(volatile uint_io8_t*)0xB72006FC)  /*@bfbba@*/
#define PPC_PCFGR315_PID	(*(volatile uint_io8_t*)0xB72006FD)  /*@bfbba@*/
#define PPC_PCFGR315_POD	(*(volatile uint_io8_t*)0xB72006FE)  /*@bfbba@*/
#define PPC_PCFGR315_POE	(*(volatile uint_io8_t*)0xB72006FF)  /*@bfbba@*/

#define PPC_PCFGR316	(PPC.unPCFGR316.u16Register)  /*@rg@*/
#define PPC_PCFGR316_POF	(PPC.unPCFGR316.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR316_NFE	(*(volatile uint_io8_t*)0xB7200705)  /*@bfbba@*/
#define PPC_PCFGR316_ODR	(PPC.unPCFGR316.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR316_PDE	(*(volatile uint_io8_t*)0xB7200708)  /*@bfbba@*/
#define PPC_PCFGR316_PUE	(*(volatile uint_io8_t*)0xB7200709)  /*@bfbba@*/
#define PPC_PCFGR316_PIL	(PPC.unPCFGR316.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR316_PIE	(*(volatile uint_io8_t*)0xB720070C)  /*@bfbba@*/
#define PPC_PCFGR316_PID	(*(volatile uint_io8_t*)0xB720070D)  /*@bfbba@*/
#define PPC_PCFGR316_POD	(*(volatile uint_io8_t*)0xB720070E)  /*@bfbba@*/
#define PPC_PCFGR316_POE	(*(volatile uint_io8_t*)0xB720070F)  /*@bfbba@*/

#define PPC_PCFGR317	(PPC.unPCFGR317.u16Register)  /*@rg@*/
#define PPC_PCFGR317_POF	(PPC.unPCFGR317.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR317_NFE	(*(volatile uint_io8_t*)0xB7200715)  /*@bfbba@*/
#define PPC_PCFGR317_ODR	(PPC.unPCFGR317.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR317_PDE	(*(volatile uint_io8_t*)0xB7200718)  /*@bfbba@*/
#define PPC_PCFGR317_PUE	(*(volatile uint_io8_t*)0xB7200719)  /*@bfbba@*/
#define PPC_PCFGR317_PIL	(PPC.unPCFGR317.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR317_PIE	(*(volatile uint_io8_t*)0xB720071C)  /*@bfbba@*/
#define PPC_PCFGR317_PID	(*(volatile uint_io8_t*)0xB720071D)  /*@bfbba@*/
#define PPC_PCFGR317_POD	(*(volatile uint_io8_t*)0xB720071E)  /*@bfbba@*/
#define PPC_PCFGR317_POE	(*(volatile uint_io8_t*)0xB720071F)  /*@bfbba@*/

#define PPC_PCFGR318	(PPC.unPCFGR318.u16Register)  /*@rg@*/
#define PPC_PCFGR318_POF	(PPC.unPCFGR318.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR318_NFE	(*(volatile uint_io8_t*)0xB7200725)  /*@bfbba@*/
#define PPC_PCFGR318_ODR	(PPC.unPCFGR318.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR318_PDE	(*(volatile uint_io8_t*)0xB7200728)  /*@bfbba@*/
#define PPC_PCFGR318_PUE	(*(volatile uint_io8_t*)0xB7200729)  /*@bfbba@*/
#define PPC_PCFGR318_PIL	(PPC.unPCFGR318.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR318_PIE	(*(volatile uint_io8_t*)0xB720072C)  /*@bfbba@*/
#define PPC_PCFGR318_PID	(*(volatile uint_io8_t*)0xB720072D)  /*@bfbba@*/
#define PPC_PCFGR318_POD	(*(volatile uint_io8_t*)0xB720072E)  /*@bfbba@*/
#define PPC_PCFGR318_POE	(*(volatile uint_io8_t*)0xB720072F)  /*@bfbba@*/

#define PPC_PCFGR319	(PPC.unPCFGR319.u16Register)  /*@rg@*/
#define PPC_PCFGR319_POF	(PPC.unPCFGR319.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR319_NFE	(*(volatile uint_io8_t*)0xB7200735)  /*@bfbba@*/
#define PPC_PCFGR319_ODR	(PPC.unPCFGR319.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR319_PDE	(*(volatile uint_io8_t*)0xB7200738)  /*@bfbba@*/
#define PPC_PCFGR319_PUE	(*(volatile uint_io8_t*)0xB7200739)  /*@bfbba@*/
#define PPC_PCFGR319_PIL	(PPC.unPCFGR319.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR319_PIE	(*(volatile uint_io8_t*)0xB720073C)  /*@bfbba@*/
#define PPC_PCFGR319_PID	(*(volatile uint_io8_t*)0xB720073D)  /*@bfbba@*/
#define PPC_PCFGR319_POD	(*(volatile uint_io8_t*)0xB720073E)  /*@bfbba@*/
#define PPC_PCFGR319_POE	(*(volatile uint_io8_t*)0xB720073F)  /*@bfbba@*/

#define PPC_PCFGR320	(PPC.unPCFGR320.u16Register)  /*@rg@*/
#define PPC_PCFGR320_POF	(PPC.unPCFGR320.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR320_NFE	(*(volatile uint_io8_t*)0xB7200745)  /*@bfbba@*/
#define PPC_PCFGR320_ODR	(PPC.unPCFGR320.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR320_PDE	(*(volatile uint_io8_t*)0xB7200748)  /*@bfbba@*/
#define PPC_PCFGR320_PUE	(*(volatile uint_io8_t*)0xB7200749)  /*@bfbba@*/
#define PPC_PCFGR320_PIL	(PPC.unPCFGR320.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR320_PIE	(*(volatile uint_io8_t*)0xB720074C)  /*@bfbba@*/
#define PPC_PCFGR320_PID	(*(volatile uint_io8_t*)0xB720074D)  /*@bfbba@*/
#define PPC_PCFGR320_POD	(*(volatile uint_io8_t*)0xB720074E)  /*@bfbba@*/
#define PPC_PCFGR320_POE	(*(volatile uint_io8_t*)0xB720074F)  /*@bfbba@*/

#define PPC_PCFGR321	(PPC.unPCFGR321.u16Register)  /*@rg@*/
#define PPC_PCFGR321_POF	(PPC.unPCFGR321.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR321_NFE	(*(volatile uint_io8_t*)0xB7200755)  /*@bfbba@*/
#define PPC_PCFGR321_ODR	(PPC.unPCFGR321.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR321_PDE	(*(volatile uint_io8_t*)0xB7200758)  /*@bfbba@*/
#define PPC_PCFGR321_PUE	(*(volatile uint_io8_t*)0xB7200759)  /*@bfbba@*/
#define PPC_PCFGR321_PIL	(PPC.unPCFGR321.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR321_PIE	(*(volatile uint_io8_t*)0xB720075C)  /*@bfbba@*/
#define PPC_PCFGR321_PID	(*(volatile uint_io8_t*)0xB720075D)  /*@bfbba@*/
#define PPC_PCFGR321_POD	(*(volatile uint_io8_t*)0xB720075E)  /*@bfbba@*/
#define PPC_PCFGR321_POE	(*(volatile uint_io8_t*)0xB720075F)  /*@bfbba@*/

#define PPC_PCFGR322	(PPC.unPCFGR322.u16Register)  /*@rg@*/
#define PPC_PCFGR322_POF	(PPC.unPCFGR322.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR322_NFE	(*(volatile uint_io8_t*)0xB7200765)  /*@bfbba@*/
#define PPC_PCFGR322_ODR	(PPC.unPCFGR322.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR322_PDE	(*(volatile uint_io8_t*)0xB7200768)  /*@bfbba@*/
#define PPC_PCFGR322_PUE	(*(volatile uint_io8_t*)0xB7200769)  /*@bfbba@*/
#define PPC_PCFGR322_PIL	(PPC.unPCFGR322.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR322_PIE	(*(volatile uint_io8_t*)0xB720076C)  /*@bfbba@*/
#define PPC_PCFGR322_PID	(*(volatile uint_io8_t*)0xB720076D)  /*@bfbba@*/
#define PPC_PCFGR322_POD	(*(volatile uint_io8_t*)0xB720076E)  /*@bfbba@*/
#define PPC_PCFGR322_POE	(*(volatile uint_io8_t*)0xB720076F)  /*@bfbba@*/

#define PPC_PCFGR323	(PPC.unPCFGR323.u16Register)  /*@rg@*/
#define PPC_PCFGR323_POF	(PPC.unPCFGR323.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR323_NFE	(*(volatile uint_io8_t*)0xB7200775)  /*@bfbba@*/
#define PPC_PCFGR323_ODR	(PPC.unPCFGR323.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR323_PDE	(*(volatile uint_io8_t*)0xB7200778)  /*@bfbba@*/
#define PPC_PCFGR323_PUE	(*(volatile uint_io8_t*)0xB7200779)  /*@bfbba@*/
#define PPC_PCFGR323_PIL	(PPC.unPCFGR323.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR323_PIE	(*(volatile uint_io8_t*)0xB720077C)  /*@bfbba@*/
#define PPC_PCFGR323_PID	(*(volatile uint_io8_t*)0xB720077D)  /*@bfbba@*/
#define PPC_PCFGR323_POD	(*(volatile uint_io8_t*)0xB720077E)  /*@bfbba@*/
#define PPC_PCFGR323_POE	(*(volatile uint_io8_t*)0xB720077F)  /*@bfbba@*/

#define PPC_PCFGR324	(PPC.unPCFGR324.u16Register)  /*@rg@*/
#define PPC_PCFGR324_POF	(PPC.unPCFGR324.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR324_NFE	(*(volatile uint_io8_t*)0xB7200785)  /*@bfbba@*/
#define PPC_PCFGR324_ODR	(PPC.unPCFGR324.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR324_PDE	(*(volatile uint_io8_t*)0xB7200788)  /*@bfbba@*/
#define PPC_PCFGR324_PUE	(*(volatile uint_io8_t*)0xB7200789)  /*@bfbba@*/
#define PPC_PCFGR324_PIL	(PPC.unPCFGR324.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR324_PIE	(*(volatile uint_io8_t*)0xB720078C)  /*@bfbba@*/
#define PPC_PCFGR324_PID	(*(volatile uint_io8_t*)0xB720078D)  /*@bfbba@*/
#define PPC_PCFGR324_POD	(*(volatile uint_io8_t*)0xB720078E)  /*@bfbba@*/
#define PPC_PCFGR324_POE	(*(volatile uint_io8_t*)0xB720078F)  /*@bfbba@*/

#define PPC_PCFGR325	(PPC.unPCFGR325.u16Register)  /*@rg@*/
#define PPC_PCFGR325_POF	(PPC.unPCFGR325.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR325_NFE	(*(volatile uint_io8_t*)0xB7200795)  /*@bfbba@*/
#define PPC_PCFGR325_ODR	(PPC.unPCFGR325.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR325_PDE	(*(volatile uint_io8_t*)0xB7200798)  /*@bfbba@*/
#define PPC_PCFGR325_PUE	(*(volatile uint_io8_t*)0xB7200799)  /*@bfbba@*/
#define PPC_PCFGR325_PIL	(PPC.unPCFGR325.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR325_PIE	(*(volatile uint_io8_t*)0xB720079C)  /*@bfbba@*/
#define PPC_PCFGR325_PID	(*(volatile uint_io8_t*)0xB720079D)  /*@bfbba@*/
#define PPC_PCFGR325_POD	(*(volatile uint_io8_t*)0xB720079E)  /*@bfbba@*/
#define PPC_PCFGR325_POE	(*(volatile uint_io8_t*)0xB720079F)  /*@bfbba@*/

#define PPC_PCFGR326	(PPC.unPCFGR326.u16Register)  /*@rg@*/
#define PPC_PCFGR326_POF	(PPC.unPCFGR326.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR326_NFE	(*(volatile uint_io8_t*)0xB72007A5)  /*@bfbba@*/
#define PPC_PCFGR326_ODR	(PPC.unPCFGR326.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR326_PDE	(*(volatile uint_io8_t*)0xB72007A8)  /*@bfbba@*/
#define PPC_PCFGR326_PUE	(*(volatile uint_io8_t*)0xB72007A9)  /*@bfbba@*/
#define PPC_PCFGR326_PIL	(PPC.unPCFGR326.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR326_PIE	(*(volatile uint_io8_t*)0xB72007AC)  /*@bfbba@*/
#define PPC_PCFGR326_PID	(*(volatile uint_io8_t*)0xB72007AD)  /*@bfbba@*/
#define PPC_PCFGR326_POD	(*(volatile uint_io8_t*)0xB72007AE)  /*@bfbba@*/
#define PPC_PCFGR326_POE	(*(volatile uint_io8_t*)0xB72007AF)  /*@bfbba@*/

#define PPC_PCFGR327	(PPC.unPCFGR327.u16Register)  /*@rg@*/
#define PPC_PCFGR327_POF	(PPC.unPCFGR327.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR327_NFE	(*(volatile uint_io8_t*)0xB72007B5)  /*@bfbba@*/
#define PPC_PCFGR327_ODR	(PPC.unPCFGR327.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR327_PDE	(*(volatile uint_io8_t*)0xB72007B8)  /*@bfbba@*/
#define PPC_PCFGR327_PUE	(*(volatile uint_io8_t*)0xB72007B9)  /*@bfbba@*/
#define PPC_PCFGR327_PIL	(PPC.unPCFGR327.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR327_PIE	(*(volatile uint_io8_t*)0xB72007BC)  /*@bfbba@*/
#define PPC_PCFGR327_PID	(*(volatile uint_io8_t*)0xB72007BD)  /*@bfbba@*/
#define PPC_PCFGR327_POD	(*(volatile uint_io8_t*)0xB72007BE)  /*@bfbba@*/
#define PPC_PCFGR327_POE	(*(volatile uint_io8_t*)0xB72007BF)  /*@bfbba@*/

#define PPC_PCFGR328	(PPC.unPCFGR328.u16Register)  /*@rg@*/
#define PPC_PCFGR328_POF	(PPC.unPCFGR328.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR328_NFE	(*(volatile uint_io8_t*)0xB72007C5)  /*@bfbba@*/
#define PPC_PCFGR328_ODR	(PPC.unPCFGR328.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR328_PDE	(*(volatile uint_io8_t*)0xB72007C8)  /*@bfbba@*/
#define PPC_PCFGR328_PUE	(*(volatile uint_io8_t*)0xB72007C9)  /*@bfbba@*/
#define PPC_PCFGR328_PIL	(PPC.unPCFGR328.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR328_PIE	(*(volatile uint_io8_t*)0xB72007CC)  /*@bfbba@*/
#define PPC_PCFGR328_PID	(*(volatile uint_io8_t*)0xB72007CD)  /*@bfbba@*/
#define PPC_PCFGR328_POD	(*(volatile uint_io8_t*)0xB72007CE)  /*@bfbba@*/
#define PPC_PCFGR328_POE	(*(volatile uint_io8_t*)0xB72007CF)  /*@bfbba@*/

#define PPC_PCFGR329	(PPC.unPCFGR329.u16Register)  /*@rg@*/
#define PPC_PCFGR329_POF	(PPC.unPCFGR329.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR329_NFE	(*(volatile uint_io8_t*)0xB72007D5)  /*@bfbba@*/
#define PPC_PCFGR329_ODR	(PPC.unPCFGR329.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR329_PDE	(*(volatile uint_io8_t*)0xB72007D8)  /*@bfbba@*/
#define PPC_PCFGR329_PUE	(*(volatile uint_io8_t*)0xB72007D9)  /*@bfbba@*/
#define PPC_PCFGR329_PIL	(PPC.unPCFGR329.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR329_PIE	(*(volatile uint_io8_t*)0xB72007DC)  /*@bfbba@*/
#define PPC_PCFGR329_PID	(*(volatile uint_io8_t*)0xB72007DD)  /*@bfbba@*/
#define PPC_PCFGR329_POD	(*(volatile uint_io8_t*)0xB72007DE)  /*@bfbba@*/
#define PPC_PCFGR329_POE	(*(volatile uint_io8_t*)0xB72007DF)  /*@bfbba@*/

#define PPC_PCFGR330	(PPC.unPCFGR330.u16Register)  /*@rg@*/
#define PPC_PCFGR330_POF	(PPC.unPCFGR330.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR330_NFE	(*(volatile uint_io8_t*)0xB72007E5)  /*@bfbba@*/
#define PPC_PCFGR330_ODR	(PPC.unPCFGR330.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR330_PDE	(*(volatile uint_io8_t*)0xB72007E8)  /*@bfbba@*/
#define PPC_PCFGR330_PUE	(*(volatile uint_io8_t*)0xB72007E9)  /*@bfbba@*/
#define PPC_PCFGR330_PIL	(PPC.unPCFGR330.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR330_PIE	(*(volatile uint_io8_t*)0xB72007EC)  /*@bfbba@*/
#define PPC_PCFGR330_PID	(*(volatile uint_io8_t*)0xB72007ED)  /*@bfbba@*/
#define PPC_PCFGR330_POD	(*(volatile uint_io8_t*)0xB72007EE)  /*@bfbba@*/
#define PPC_PCFGR330_POE	(*(volatile uint_io8_t*)0xB72007EF)  /*@bfbba@*/

#define PPC_PCFGR331	(PPC.unPCFGR331.u16Register)  /*@rg@*/
#define PPC_PCFGR331_POF	(PPC.unPCFGR331.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR331_NFE	(*(volatile uint_io8_t*)0xB72007F5)  /*@bfbba@*/
#define PPC_PCFGR331_ODR	(PPC.unPCFGR331.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR331_PDE	(*(volatile uint_io8_t*)0xB72007F8)  /*@bfbba@*/
#define PPC_PCFGR331_PUE	(*(volatile uint_io8_t*)0xB72007F9)  /*@bfbba@*/
#define PPC_PCFGR331_PIL	(PPC.unPCFGR331.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR331_PIE	(*(volatile uint_io8_t*)0xB72007FC)  /*@bfbba@*/
#define PPC_PCFGR331_PID	(*(volatile uint_io8_t*)0xB72007FD)  /*@bfbba@*/
#define PPC_PCFGR331_POD	(*(volatile uint_io8_t*)0xB72007FE)  /*@bfbba@*/
#define PPC_PCFGR331_POE	(*(volatile uint_io8_t*)0xB72007FF)  /*@bfbba@*/

typedef struct stc_ppc_pcfgrn_field{
    uint_io16_t		u3POF:3;
    uint_io16_t		:2;
    uint_io16_t		u1NFE:1;
    uint_io16_t		u2ODR:2;
    uint_io16_t		u1PDE:1;
    uint_io16_t		u1PUE:1;
    uint_io16_t		u2PIL:2;
    uint_io16_t		u1PIE:1;
    uint_io16_t		u1PID:1;
    uint_io16_t		u1POD:1;
    uint_io16_t		u1POE:1;
}stc_ppc_pcfgrn_field_t;

typedef union un_ppc_pcfgrn{
    uint_io16_t		u16Register;
    stc_ppc_pcfgrn_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_ppc_pcfgrn_t;

/* KEYCDR */
#define PPC_KEYCDR	(PPC.unKEYCDR.u32Register)  /*@rg@*/
#define PPC_KEYCDR_RADR	(PPC.unKEYCDR.stcField.u15RADR)  /*@bf@*/
#define PPC_KEYCDR_SIZE	(PPC.unKEYCDR.stcField.u2SIZE)  /*@bf@*/
#define PPC_KEYCDR_KEY	(PPC.unKEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_ppc_keycdr_field{
    uint_io32_t		u15RADR:15;
    uint_io32_t		:13;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_ppc_keycdr_field_t;

typedef union un_ppc_keycdr{
    uint_io32_t		u32Register;
    stc_ppc_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppc_keycdr_t;


typedef struct stc_ppc{
    un_ppc_pcfgrn_t	unPCFGR000;	/* 0x00000000 */
    un_ppc_pcfgrn_t	unPCFGR001;	/* 0x00000002 */
    un_ppc_pcfgrn_t	unPCFGR002;	/* 0x00000004 */
    un_ppc_pcfgrn_t	unPCFGR003;	/* 0x00000006 */
    un_ppc_pcfgrn_t	unPCFGR004;	/* 0x00000008 */
    un_ppc_pcfgrn_t	unPCFGR005;	/* 0x0000000A */
    un_ppc_pcfgrn_t	unPCFGR006;	/* 0x0000000C */
    un_ppc_pcfgrn_t	unPCFGR007;	/* 0x0000000E */
    un_ppc_pcfgrn_t	unPCFGR008;	/* 0x00000010 */
    un_ppc_pcfgrn_t	unPCFGR009;	/* 0x00000012 */
    un_ppc_pcfgrn_t	unPCFGR010;	/* 0x00000014 */
    un_ppc_pcfgrn_t	unPCFGR011;	/* 0x00000016 */
    un_ppc_pcfgrn_t	unPCFGR012;	/* 0x00000018 */
    un_ppc_pcfgrn_t	unPCFGR013;	/* 0x0000001A */
    un_ppc_pcfgrn_t	unPCFGR014;	/* 0x0000001C */
    un_ppc_pcfgrn_t	unPCFGR015;	/* 0x0000001E */
    un_ppc_pcfgrn_t	unPCFGR016;	/* 0x00000020 */
    un_ppc_pcfgrn_t	unPCFGR017;	/* 0x00000022 */
    un_ppc_pcfgrn_t	unPCFGR018;	/* 0x00000024 */
    un_ppc_pcfgrn_t	unPCFGR019;	/* 0x00000026 */
    un_ppc_pcfgrn_t	unPCFGR020;	/* 0x00000028 */
    un_ppc_pcfgrn_t	unPCFGR021;	/* 0x0000002A */
    un_ppc_pcfgrn_t	unPCFGR022;	/* 0x0000002C */
    un_ppc_pcfgrn_t	unPCFGR023;	/* 0x0000002E */
    un_ppc_pcfgrn_t	unPCFGR024;	/* 0x00000030 */
    un_ppc_pcfgrn_t	unPCFGR025;	/* 0x00000032 */
    un_ppc_pcfgrn_t	unPCFGR026;	/* 0x00000034 */
    un_ppc_pcfgrn_t	unPCFGR027;	/* 0x00000036 */
    un_ppc_pcfgrn_t	unPCFGR028;	/* 0x00000038 */
    un_ppc_pcfgrn_t	unPCFGR029;	/* 0x0000003A */
    un_ppc_pcfgrn_t	unPCFGR030;	/* 0x0000003C */
    un_ppc_pcfgrn_t	unPCFGR031;	/* 0x0000003E */
    un_ppc_pcfgrn_t	unPCFGR100;	/* 0x00000040 */
    un_ppc_pcfgrn_t	unPCFGR101;	/* 0x00000042 */
    un_ppc_pcfgrn_t	unPCFGR102;	/* 0x00000044 */
    un_ppc_pcfgrn_t	unPCFGR103;	/* 0x00000046 */
    un_ppc_pcfgrn_t	unPCFGR104;	/* 0x00000048 */
    un_ppc_pcfgrn_t	unPCFGR105;	/* 0x0000004A */
    un_ppc_pcfgrn_t	unPCFGR106;	/* 0x0000004C */
    un_ppc_pcfgrn_t	unPCFGR107;	/* 0x0000004E */
    un_ppc_pcfgrn_t	unPCFGR108;	/* 0x00000050 */
    un_ppc_pcfgrn_t	unPCFGR109;	/* 0x00000052 */
    un_ppc_pcfgrn_t	unPCFGR110;	/* 0x00000054 */
    un_ppc_pcfgrn_t	unPCFGR111;	/* 0x00000056 */
    un_ppc_pcfgrn_t	unPCFGR112;	/* 0x00000058 */
    un_ppc_pcfgrn_t	unPCFGR113;	/* 0x0000005A */
    un_ppc_pcfgrn_t	unPCFGR114;	/* 0x0000005C */
    un_ppc_pcfgrn_t	unPCFGR115;	/* 0x0000005E */
    un_ppc_pcfgrn_t	unPCFGR116;	/* 0x00000060 */
    un_ppc_pcfgrn_t	unPCFGR117;	/* 0x00000062 */
    un_ppc_pcfgrn_t	unPCFGR118;	/* 0x00000064 */
    un_ppc_pcfgrn_t	unPCFGR119;	/* 0x00000066 */
    un_ppc_pcfgrn_t	unPCFGR120;	/* 0x00000068 */
    un_ppc_pcfgrn_t	unPCFGR121;	/* 0x0000006A */
    un_ppc_pcfgrn_t	unPCFGR122;	/* 0x0000006C */
    un_ppc_pcfgrn_t	unPCFGR123;	/* 0x0000006E */
    un_ppc_pcfgrn_t	unPCFGR124;	/* 0x00000070 */
    un_ppc_pcfgrn_t	unPCFGR125;	/* 0x00000072 */
    un_ppc_pcfgrn_t	unPCFGR126;	/* 0x00000074 */
    un_ppc_pcfgrn_t	unPCFGR127;	/* 0x00000076 */
    un_ppc_pcfgrn_t	unPCFGR128;	/* 0x00000078 */
    un_ppc_pcfgrn_t	unPCFGR129;	/* 0x0000007A */
    un_ppc_pcfgrn_t	unPCFGR130;	/* 0x0000007C */
    un_ppc_pcfgrn_t	unPCFGR131;	/* 0x0000007E */
    un_ppc_pcfgrn_t	unPCFGR200;	/* 0x00000080 */
    un_ppc_pcfgrn_t	unPCFGR201;	/* 0x00000082 */
    un_ppc_pcfgrn_t	unPCFGR202;	/* 0x00000084 */
    un_ppc_pcfgrn_t	unPCFGR203;	/* 0x00000086 */
    un_ppc_pcfgrn_t	unPCFGR204;	/* 0x00000088 */
    un_ppc_pcfgrn_t	unPCFGR205;	/* 0x0000008A */
    un_ppc_pcfgrn_t	unPCFGR206;	/* 0x0000008C */
    un_ppc_pcfgrn_t	unPCFGR207;	/* 0x0000008E */
    un_ppc_pcfgrn_t	unPCFGR208;	/* 0x00000090 */
    un_ppc_pcfgrn_t	unPCFGR209;	/* 0x00000092 */
    un_ppc_pcfgrn_t	unPCFGR210;	/* 0x00000094 */
    un_ppc_pcfgrn_t	unPCFGR211;	/* 0x00000096 */
    un_ppc_pcfgrn_t	unPCFGR212;	/* 0x00000098 */
    un_ppc_pcfgrn_t	unPCFGR213;	/* 0x0000009A */
    un_ppc_pcfgrn_t	unPCFGR214;	/* 0x0000009C */
    un_ppc_pcfgrn_t	unPCFGR215;	/* 0x0000009E */
    un_ppc_pcfgrn_t	unPCFGR216;	/* 0x000000A0 */
    un_ppc_pcfgrn_t	unPCFGR217;	/* 0x000000A2 */
    un_ppc_pcfgrn_t	unPCFGR218;	/* 0x000000A4 */
    un_ppc_pcfgrn_t	unPCFGR219;	/* 0x000000A6 */
    un_ppc_pcfgrn_t	unPCFGR220;	/* 0x000000A8 */
    un_ppc_pcfgrn_t	unPCFGR221;	/* 0x000000AA */
    un_ppc_pcfgrn_t	unPCFGR222;	/* 0x000000AC */
    un_ppc_pcfgrn_t	unPCFGR223;	/* 0x000000AE */
    un_ppc_pcfgrn_t	unPCFGR224;	/* 0x000000B0 */
    un_ppc_pcfgrn_t	unPCFGR225;	/* 0x000000B2 */
    un_ppc_pcfgrn_t	unPCFGR226;	/* 0x000000B4 */
    un_ppc_pcfgrn_t	unPCFGR227;	/* 0x000000B6 */
    un_ppc_pcfgrn_t	unPCFGR228;	/* 0x000000B8 */
    un_ppc_pcfgrn_t	unPCFGR229;	/* 0x000000BA */
    un_ppc_pcfgrn_t	unPCFGR230;	/* 0x000000BC */
    un_ppc_pcfgrn_t	unPCFGR231;	/* 0x000000BE */
    un_ppc_pcfgrn_t	unPCFGR300;	/* 0x000000C0 */
    un_ppc_pcfgrn_t	unPCFGR301;	/* 0x000000C2 */
    un_ppc_pcfgrn_t	unPCFGR302;	/* 0x000000C4 */
    un_ppc_pcfgrn_t	unPCFGR303;	/* 0x000000C6 */
    un_ppc_pcfgrn_t	unPCFGR304;	/* 0x000000C8 */
    un_ppc_pcfgrn_t	unPCFGR305;	/* 0x000000CA */
    un_ppc_pcfgrn_t	unPCFGR306;	/* 0x000000CC */
    un_ppc_pcfgrn_t	unPCFGR307;	/* 0x000000CE */
    un_ppc_pcfgrn_t	unPCFGR308;	/* 0x000000D0 */
    un_ppc_pcfgrn_t	unPCFGR309;	/* 0x000000D2 */
    un_ppc_pcfgrn_t	unPCFGR310;	/* 0x000000D4 */
    un_ppc_pcfgrn_t	unPCFGR311;	/* 0x000000D6 */
    un_ppc_pcfgrn_t	unPCFGR312;	/* 0x000000D8 */
    un_ppc_pcfgrn_t	unPCFGR313;	/* 0x000000DA */
    un_ppc_pcfgrn_t	unPCFGR314;	/* 0x000000DC */
    un_ppc_pcfgrn_t	unPCFGR315;	/* 0x000000DE */
    un_ppc_pcfgrn_t	unPCFGR316;	/* 0x000000E0 */
    un_ppc_pcfgrn_t	unPCFGR317;	/* 0x000000E2 */
    un_ppc_pcfgrn_t	unPCFGR318;	/* 0x000000E4 */
    un_ppc_pcfgrn_t	unPCFGR319;	/* 0x000000E6 */
    un_ppc_pcfgrn_t	unPCFGR320;	/* 0x000000E8 */
    un_ppc_pcfgrn_t	unPCFGR321;	/* 0x000000EA */
    un_ppc_pcfgrn_t	unPCFGR322;	/* 0x000000EC */
    un_ppc_pcfgrn_t	unPCFGR323;	/* 0x000000EE */
    un_ppc_pcfgrn_t	unPCFGR324;	/* 0x000000F0 */
    un_ppc_pcfgrn_t	unPCFGR325;	/* 0x000000F2 */
    un_ppc_pcfgrn_t	unPCFGR326;	/* 0x000000F4 */
    un_ppc_pcfgrn_t	unPCFGR327;	/* 0x000000F6 */
    un_ppc_pcfgrn_t	unPCFGR328;	/* 0x000000F8 */
    un_ppc_pcfgrn_t	unPCFGR329;	/* 0x000000FA */
    un_ppc_pcfgrn_t	unPCFGR330;	/* 0x000000FC */
    un_ppc_pcfgrn_t	unPCFGR331;	/* 0x000000FE */
    uint_io8_t	au8Reserved0[768];	/* 0x00000100 */
    un_ppc_keycdr_t	unKEYCDR;	/* 0x00000400 */
    uint_io8_t	au8Reserved1[31740];	/* 0x00000404 */
}stc_ppc_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ppc_t	stcPPC;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_PPC_H */
