#include "R485_Communication_Matrix.h"
#include "Barcode_Scanner.h"
#include "string.h"
#include "Key.h"
uint8_t barcode_Msg[64];
uint8_t barcode_Msg1[64];
uint8_t name1 = 0;
uint8_t name2 = 0;

uint32_t R485_Send_0xD0(void)
{
    memset(R485_IDD0h.Msg, 0xFF, 27);
    uint32_t u32sendendflag = 0;

    R485_IDD0h.Sig.IOT_RealTime_Year = 0x01;
    R485_IDD0h.Sig.IOT_RealTime_Month = 0x01;
    R485_IDD0h.Sig.IOT_RealTime_Day = 0x01;     //年月日

    if(clearOdoFlag == 0)
    {
        switch (MENU_CHECK_STEP)
        {
            case 0:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            break;

            case 1:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            break;

            case 2:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x0B;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x0B;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            break;

            case 3:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x16;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x16;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            R485_IDD0h.Sig.GPS_State = 0;       //GPS
            R485_IDD0h.Sig.GSM_State = 0;       //GSM
            break;

            case 4:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x0D;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x21;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒

            R485_IDD0h.Sig.EstimateRemainingMileage_L = 0x10;
            R485_IDD0h.Sig.EstimateRemainingMileage_H = 0x27;       //续航里程
            R485_IDD0h.Sig.GPS_State = 0;
            R485_IDD0h.Sig.GSM_State = 0;
            break;

            case 5:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x0E;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x2C;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            R485_IDD0h.Sig.GPS_State = 0;
            R485_IDD0h.Sig.GSM_State = 0;
            break;

            case 6:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x0F;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x37;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            R485_IDD0h.Sig.GPS_State = 0;
            R485_IDD0h.Sig.GSM_State = 0;
            break;

            case 7:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x10;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x06;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            R485_IDD0h.Sig.GPS_State = 0;
            R485_IDD0h.Sig.GSM_State = 0;
            break;

            // case 8:
            // R485_IDD0h.Sig.IOT_RealTime_Hour = 0x11;
            // R485_IDD0h.Sig.IOT_RealTime_Minute = 0x07;
            // R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            // R485_IDD0h.Sig.GPS_State = 0;
            // R485_IDD0h.Sig.GSM_State = 0;
            // break;

            case 8:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x12;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x08;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            R485_IDD0h.Sig.GPS_State = 0;
            R485_IDD0h.Sig.GSM_State = 0;
            break;

            case 9:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x13;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x09;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            break;

            default:
            R485_IDD0h.Sig.IOT_RealTime_Hour = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Minute = 0x00;
            R485_IDD0h.Sig.IOT_RealTime_Second = 0x00;      //时分秒
            break;
        }
    }
    else
    {
        R485_IDD0h.Sig.EstimateRemainingMileage_L = 0xCD;
        R485_IDD0h.Sig.EstimateRemainingMileage_H = 0xAB;       //续航里程
    }

    u32sendendflag = R485_Send(0xD0, R485_IDD0h.Msg, sizeof(R485_IDD0h.Msg));
    return u32sendendflag;
}

uint32_t R485_Send_0xD1(void)
{
    memset(R485_IDD1h.Msg, 0xFF, 139);
    uint32_t u32sendendflag = 0;

    if(clearOdoFlag == 0)
    {
        switch (MENU_CHECK_STEP)
        {
            case 0:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            case 1:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            case 2:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x14;      //电量
            R485_IDD1h.Sig.BatteryChargingStatus = 0x01;        //充电枪
            break;

            case 3:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x64;      //电量
            break;

            case 4:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            case 5:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            R485_IDD1h.Sig.BatteryChargingStatus = 0x03;
            break;

            case 6:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            case 7:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            // case 8:
            // R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            // break;

            case 8:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            break;

            case 9:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            // R485_IDD1h.Sig.BatteryChargingStatus = 0x01;        //充电枪
            break;

            case 13:
            R485_IDD1h.Sig.BatteryChargingStatus = 0x01;        //充电枪

            default:
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //电量
            R485_IDD1h.Sig.MainBatteryQuantity = 0x00;      //低电量指示灯
            break;
        }
    }
    else
    {
        R485_IDD1h.Sig.MainBatteryQuantity = 0xEF;      //电量
    }
    
    u32sendendflag = R485_Send(0xD1, R485_IDD1h.Msg, sizeof(R485_IDD1h.Msg));
    return u32sendendflag;
}

uint8_t RampParkedStatecounter = 0;        //红色闪烁两次

uint32_t R485_Send_0xD2(void)
{
    memset(R485_IDD2h.Msg, 0xFF, 36);
    uint32_t u32sendendflag = 0;

    R485_IDD2h.Sig.ParkinFeedback = 0;      //车速档位P档取消

    R485_IDD2h.Sig.BrakeSwitchFeedback = 0x00;      //ready灯熄灭

    if(clearOdoFlag == 0)
    {
        switch (MENU_CHECK_STEP)
        {
            case 0:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x3A;      //功率

            R485_IDD2h.Sig.ParkinFeedback = 0x01;      //ready灯熄灭
            break;

            case 1:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x3A;      //功率

            R485_IDD2h.Sig.ParkinFeedback = 0x00;
            R485_IDD2h.Sig.SpeedGear = 0x01;        //档位FREE
            break;

            case 2:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x47;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速10

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x3A;      //功率10%

            R485_IDD2h.Sig.ParkinFeedback = 0x00;
            R485_IDD2h.Sig.SpeedGear = 0x01;        //档位TTFAR

            R485_IDD2h.Sig.MCUFaultStatus_HandlebarFault = 0x01;        //故障灯
            break;

            case 3:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x6F;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x01;      //车速50

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x5A;      //功率50%

            R485_IDD2h.Sig.ParkinFeedback = 0x00;

            R485_IDD2h.Sig.SpeedGear = 0x03;        //档位SPORT

            RampParkedStatecounter = 0;

            R485_IDD2h.Sig.TCSDefined = 0x01;
            R485_IDD2h.Sig.TCSActivation = 0x02;        //TCS

            R485_IDD2h.Sig.FaultCorrecting = 0x00;      //修复模式

            R485_IDD2h.Sig.CruiseModeFeedback = 0x01;       //巡航灯

            R485_IDD2h.Sig.SlopeDescentFunctionStatus = 0x01;       //陡坡缓降
            R485_IDD2h.Sig.SteepHillDescentEnable = 0x00;
            break;

            case 4:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0xb8;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x01;      //车速60

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x82;      //功率100%

            R485_IDD2h.Sig.SpeedGear = 0x04;        //不为free模式

            if(RampParkedStatecounter < 10)
            {
                RampParkedStatecounter++;
                R485_IDD2h.Sig.RampParkedState = 0x01;      //坡道驻停状态（氛围灯红色闪烁两次）
            }
            else
            {
                R485_IDD2h.Sig.RampParkedState = 0x03;
            }
            break;

            case 5:
            RampParkedStatecounter = 0;

            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0xb8;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x01;      //车速60

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x82;      //功率100%

            R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式
            break;

            case 6:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x4B;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x02;      //车速80

            R485_IDD2h.Sig.BusbarVoltage = 0x28;
            R485_IDD2h.Sig.BusbarCurrent = 0x31;      //电流为负

            R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式

            R485_IDD2h.Sig.RecuperationStatusFeedback = 0x01;       //能量回收功能设置反馈为1       //能量回收10格

            R485_IDD2h.Sig.TPowerFeedback = 0x01;       //T动力
            break;

            case 7:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0xDE;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x02;      //车速99

            R485_IDD2h.Sig.BusbarVoltage = 0xC8;
            R485_IDD2h.Sig.BusbarCurrent = 0x31;      //电流为负

            R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式

            R485_IDD2h.Sig.RecuperationStatusFeedback = 0x01;       //能量回收功能设置反馈为1       //能量回收50格

            R485_IDD2h.Sig.ClaudicationPatternFeedback = 0x01;      //龟速行驶
            break;

            // case 8:
            // R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0xDE;
            // R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x02;      //车速99

            // R485_IDD2h.Sig.BusbarVoltage = 0xC8;
            // R485_IDD2h.Sig.BusbarCurrent = 0x30;      //电流为负

            // R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式

            // R485_IDD2h.Sig.RecuperationStatusFeedback = 0x01;       //能量回收功能设置反馈为1       //能量回收100格

            // // R485_IDD2h.Sig.MCUFaultStatus_HandlebarFault = 0x01;      //整车故障等

            // // R485_IDD2h.Sig.RampParkedState = 0x01;      //坡道驻停状态（氛围灯红色闪烁两次）
            // break;

            case 8:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0xDE;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x02;      //车速99

            R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式

            R485_IDD2h.Sig.BusbarVoltage = 0x05;
            R485_IDD2h.Sig.BusbarCurrent = 0x82;      //功率100%

            R485_IDD2h.Sig.RecuperationStatusFeedback = 0x01;       //能量回收功能设置反馈为1       //能量回收100格
            break;

            case 9:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.ParkinFeedback = 0x00;
            R485_IDD2h.Sig.SpeedGear = 0x00;        //档位-助力推行
            break;

            case 10:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.SpeedGear = 0x04;
            R485_IDD2h.Sig.ParkinFeedback = 0x01;       //驻车挡位P档
            break;

            case 11:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.SpeedGear = 0x04;
            R485_IDD2h.Sig.ParkinFeedback = 0x00;
            R485_IDD2h.Sig.ReverseModeFeedback = 0x01;      //倒挡模式
            break;

            case 12:
            R485_IDD2h.Sig.RampParkedState = 0x01;      //坡道驻停
            break;

            case 13:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速99

            R485_IDD2h.Sig.CruiseModeFeedback = 0x01;       //巡航灯

            R485_IDD2h.Sig.SpeedGear = 0x01;        //不为free模式

            R485_IDD2h.Sig.TPowerFeedback = 0x01;       //T动力

            R485_IDD2h.Sig.MCUFaultStatus_HandlebarFault = 0x01;      //整车故障等

            R485_IDD2h.Sig.ClaudicationPatternFeedback = 0x01;      //龟速行驶

            R485_IDD2h.Sig.TCSDefined = 0x01;
            R485_IDD2h.Sig.TCSActivation = 0x02;        //TCS

            R485_IDD2h.Sig.SlopeDescentFunctionStatus = 0x01;
            R485_IDD2h.Sig.SteepHillDescentEnable = 0x00;       //陡坡缓降

            // R485_IDD2h.Sig.FaultCorrecting = 0x00;      //修复模式
            break;

            default:
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x00;
            R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x00;      //车速00

            R485_IDD2h.Sig.BusbarVoltage = 0xFF;
            R485_IDD2h.Sig.BusbarCurrent = 0xFF;      //功率100%

            R485_IDD2h.Sig.CruiseModeFeedback = 0x00;       //巡航灯

            R485_IDD2h.Sig.TPowerFeedback = 0x00;       //T动力

            R485_IDD2h.Sig.SpeedGear = 0x00;
            R485_IDD2h.Sig.TCSDefined = 0x00;
            R485_IDD2h.Sig.TCSActivation = 0x00;        //TCS

            R485_IDD2h.Sig.SlopeDescentFunctionStatus = 0x00;
            R485_IDD2h.Sig.SteepHillDescentEnable = 0x00;       //陡坡缓降

            R485_IDD2h.Sig.ClaudicationPatternFeedback = 0x00;      //龟速行驶

            R485_IDD2h.Sig.MCUFaultStatus_HandlebarFault = 0x00;      //整车故障等

            R485_IDD2h.Sig.RampParkedState = 0x03;      //坡道驻停状态（氛围灯红色闪烁两次）
            break;
        }
    }
    else
    {
        R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_L = 0x78;
        R485_IDD2h.Sig.ICMCalculatesVehicleSpeed_H = 0x56;      //车速99

        R485_IDD2h.Sig.BusbarVoltage = 0x05;
        R485_IDD2h.Sig.BusbarCurrent = 0x82;      //功率100%
    }

    u32sendendflag = R485_Send(0xD2, R485_IDD2h.Msg, sizeof(R485_IDD2h.Msg));
    return u32sendendflag;
}

uint8_t mimayanzhengjieguo = 0;
uint32_t R485_Send_0xD3(void)
{
    memset(R485_IDD3h.Msg, 0xFF, 26);
    uint32_t u32sendendflag = 0;

    R485_IDD3h.Sig.AutoheadLightSetting = 0x00;       //自动大灯
    
    R485_IDD3h.Sig.BlueToothPair = 0x00;       //经典蓝牙配对指令
    
    if(clearOdoFlag == 0)
    {
        switch (MENU_CHECK_STEP)
        {
            case 2:
            R485_IDD3h.Sig.AutoheadLightSetting = 0x00;       //自动大灯
            R485_IDD3h.Sig.ElectronicCushionStatus = 0x01;      //座桶开启灯
            break;

            case 3:
            R485_IDD3h.Sig.AutoheadLightSetting = 0x00;       //自动大灯
            R485_IDD3h.Sig.RemainingMileageDisSetting = 0;      //续航里程
            R485_IDD3h.Sig.SupportSwitchState = 0x01;       //边撑状态
            break;

            case 4:
            R485_IDD3h.Sig.AutoheadLightSetting = 0x00;       //自动大灯

            R485_IDD3h.Sig.RemainingMileageDisSetting = 1;      //续航里程
            // R485_IDD3h.Sig.VehicleStatus = 0x00;
            // R485_IDD3h.Sig.AlarmStatus = 0x01;      //氛围灯红色（会线束故障挡住显示）
            break;

            case 5:
            R485_IDD3h.Sig.RemainingMileageDisSetting = 0;      //续航里程
            break;

            case 6:
            R485_IDD3h.Sig.AutoheadLightSetting = 0x01;      //自动大灯
            break;

            // case 7:
            // break;

            case 9:
            break;

            if(mimayanzhengjieguo == 1)
            {
                R485_IDD3h.Sig.PasswordAuthResult = 0x00;       //密码认证结果
            }
            else
            {
                R485_IDD3h.Sig.PasswordAuthResult = 0x03;       //密码认证结果
            }
            break;

            case 10:
            R485_IDD3h.Sig.ElectronicCushionStatus = 0x01;      //座桶开启灯
            
            default:
            R485_IDD3h.Sig.SupportSwitchState = 0x00;       //边撑状态
            R485_IDD3h.Sig.ElectronicCushionStatus = 0x00;      //座桶开启灯

            // R485_IDD3h.Sig.VehicleStatus = 0xFF;
            // R485_IDD3h.Sig.AlarmStatus = 0xFF;      //氛围灯颜色

            R485_IDD3h.Sig.AutoheadLightSetting = 0x00;       //自动大灯
            break;

            case 13:
            R485_IDD3h.Sig.SupportSwitchState = 0x01;       //边撑状态
            R485_IDD3h.Sig.AutoheadLightSetting = 0x01;       //自动大灯
            R485_IDD3h.Sig.ElectronicCushionStatus = 0x01;      //座桶开启灯
            break;
            
            case 14:
            if(KeyStep == 3)
            {
                R485_IDD3h.Sig.PasswordUnlockCommand = 0x00;      //密码解锁
            }
            else
            {
                R485_IDD3h.Sig.PasswordUnlockCommand = 0x01;      //密码解锁
            }
            break;
        }
    }
    else
    {
        R485_IDD3h.Sig.RemainingMileageDisSetting = 1;      //续航里程
    }

    u32sendendflag = R485_Send(0xD3, R485_IDD3h.Msg, sizeof(R485_IDD3h.Msg));
    return u32sendendflag;
}
uint8_t R485_zhenduan_Msg[64];
uint32_t zhenduandowntime = 0;
uint8_t timestart = 0;
uint8_t zhenduancishu = 0;
uint32_t R485_Send_0x04(void)
{
    uint8_t length;
    uint32_t u32sendendflag = 0;
    if(RS485_TX_finish == 0)
    {
        switch (zhenduansendStep)
        {
        case  0:
            length = 2;
            break;
        case 1:
            length = 2;
        break;
        case 2:
            length = 6;
            break;
        case 3:
            length = 37;
            break;
        case 4:
            break;
        case 5:
            length = 3;
            break;
        case 6:
            length = 3;
            break;
        default:
            break;
        }
        
        switch (zhenduansendStep)
        {
        case  0:
            R485_zhenduan_Msg[0] = 0x10;
            R485_zhenduan_Msg[1] = 0x03;
            break;
        case 1:
            R485_zhenduan_Msg[0] = 0x27;
            R485_zhenduan_Msg[1] = 0x1;
        break;
        case 2:
            R485_zhenduan_Msg[0] = 0x27;
            R485_zhenduan_Msg[1] = 0x2;
            R485_zhenduan_Msg[2] = key_array[0];
            R485_zhenduan_Msg[3] = key_array[1];
            R485_zhenduan_Msg[4] = key_array[2];
            R485_zhenduan_Msg[5] = key_array[3];
            break;
        case 3:
            R485_zhenduan_Msg[0] = 0x2E;
            R485_zhenduan_Msg[1] = 0x50;
            R485_zhenduan_Msg[2] = 0x0;
            memcpy(R485_zhenduan_Msg+3,barcode_Msg,34);
            break;
        case 5:
            R485_zhenduan_Msg[0] = 0x22;
            R485_zhenduan_Msg[1] = 0x50;
            R485_zhenduan_Msg[2] = 0x0;
            break;
        default:
            break;
        }
        RS485_TX_finish = 1;
        if(zhenduansendStep != 4)
        {
            u32sendendflag = R485_Send(0x04, R485_zhenduan_Msg, length);
        }
        
        RS485_send_time = 0;
        RS485_TX_finish = 1;
    }
    
    RS485_TX_finish = 1;
    return u32sendendflag;
}

uint32_t R485_Send_0xA4(void)
{
    memset(R485_IDA4h.Msg, 0xFF, 1);

    R485_IDA4h.Sig.Invalid_characters = 0x01;

    uint32_t u32sendendflag = 0;
    u32sendendflag = R485_Send(0xA4, R485_IDA4h.Msg, sizeof(R485_IDA4h.Msg));
    return u32sendendflag;
}

uint32_t R485_Send_0x41(void)
{
                    /**************0.437*********** */
                /*wtemp *= 9177l;
                wtemp /= 100;
                wtemp *= 157;
                wtemp /= 1000;*/
    uint32_t u32sendendflag = 0;
    memset(R485_ID41h.Msg, 0xFF, 64);
    R485_ID41h.Sig.VehicleStatus = 0x2;
    R485_ID41h.Sig.MetricImperialSetting = 0;
    R485_ID41h.Sig.CartMode = 0;
    R485_ID41h.Sig.ReverseMode = 0;
    R485_ID41h.Sig.RecuperationStatusFeedback = 0;
    R485_ID41h.Sig.EngineSymbolIndicatior = 0;
    // R485_ID41h.Sig.AlarmStatus = 0; // 报警器报警状态
    R485_ID41h.Sig.IOTRealTime_Year = 0x1; //时间：年
    R485_ID41h.Sig.IOTRealTime_Month = 0x1; //时间：月
    R485_ID41h.Sig.IOTRealTime_Day = 0x1;   //时间：日
    R485_ID41h.Sig.MetricImperialSetting = 0;
    R485_ID41h.Sig.EleHeadlightFunctionSettings = 0;
    R485_ID41h.Sig.RemainingMileageDisplaySettings = 0;
    switch (MENU_CHECK_STEP)
    {
    case 0:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航

        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30
        R485_ID41h.Sig.TotalBatterySOC = 0x0; //电量
        R485_ID41h.Sig.VehicleStatus = 0x1;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x2;     //挡位
        
        

        R485_ID41h.Sig.IOTRealTime_Hour = 0;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒

        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    case  1:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航


        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30
        R485_ID41h.Sig.TotalBatterySOC = 0x2; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x4;     //挡位
        
        R485_ID41h.Sig.TotalBatteryVoltage = 0x6D;   //总电池电压

        R485_ID41h.Sig.IOTRealTime_Hour = 0;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒


        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    case  2:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航



    
        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x50;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30  11km
        R485_ID41h.Sig.TotalBatterySOC = 0x1E; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x3;     //挡位
        
        R485_ID41h.Sig.TotalBatteryVoltage = 0x5A;   //总电池电压

        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.IOTRealTime_Hour = 0xB;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0xB;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒


        R485_ID41h.Sig.CartMode = 0;
        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;                                  
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    case  3:
        if(clearOdoFlag == 1)
        {
            R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
            R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
            R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
            R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
            R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
            R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
            R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
            R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
            R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
            R485_ID41h.Sig.CruiseMode = 0x0;    //巡航


            R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0xFFFE;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 22km
            R485_ID41h.Sig.TotalBatterySOC = 0x2C; //电量
            R485_ID41h.Sig.VehicleStatus = 0x2;   //整车状态
            R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
            
            R485_ID41h.Sig.TotalBatteryVoltage = 0x5E;   //总电池电压

            R485_ID41h.Sig.IOTRealTime_Hour = 0x16;    //时间：时
            R485_ID41h.Sig.IOTRealTime_Minute = 0x16;  //时间：分
            R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒


            R485_ID41h.Sig.HandlebarFaultIndicator = 0;
            R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
            R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
            R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
            R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
            R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
            R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
            R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
            R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
            R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
            R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
            R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
            R485_ID41h.Sig.MCUCommunicationStatus = 0;
            R485_ID41h.Sig.ALMCommunicationStatus = 0;
            R485_ID41h.Sig.ICMCommunicationStatus = 0;
            R485_ID41h.Sig.BrakeLeverFault = 0;
            R485_ID41h.Sig.PhaseLossFault = 0;
            R485_ID41h.Sig.MCUOverTempProtection = 0;
            R485_ID41h.Sig.MotorOvertempProtection = 0;
            R485_ID41h.Sig.RotorLocked = 0;

            R485_ID41h.Sig.MetricImperialSetting = 0;
            R485_ID41h.Sig.EleHeadlightFunctionSettings = 0;
            R485_ID41h.Sig.RemainingMileageDisplaySettings = 0;
        }
        else
        {
             R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x1; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航


        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0xA1;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 22km
        R485_ID41h.Sig.TotalBatterySOC = 0x2C; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        
        R485_ID41h.Sig.TotalBatteryVoltage = 0x4B;   //总电池电压

        R485_ID41h.Sig.IOTRealTime_Hour = 0x16;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x16;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒


        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        }
       
        break;
    case  4:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航




        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0xF1;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 33km
        R485_ID41h.Sig.TotalBatterySOC = 0x42; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        

        R485_ID41h.Sig.IOTRealTime_Hour = 0xD;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x21;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x1;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x1;    //巡航


        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        
        break;
    case  5:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x0; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航

        R485_ID41h.Sig.RecuperationStatusFeedback = 0x1;    //能量回收设置
        R485_ID41h.Sig.TotalBatteryVoltage = 0x2A;   //总电池电压

        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x140;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 44km
        R485_ID41h.Sig.TotalBatterySOC = 0x58; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0xE;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x2C;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x1;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x0;   //座桶开关


        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        
        break;
    case  6:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航


        R485_ID41h.Sig.RecuperationStatusFeedback = 0x1;    //能量回收设置
        R485_ID41h.Sig.TotalBatteryVoltage = 0xC8;   //总电池电压

        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x192;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 55km
        R485_ID41h.Sig.TotalBatterySOC = 0x6E; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        //功率暂空一会做

        R485_ID41h.Sig.IOTRealTime_Hour = 0xF;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x37;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒
        R485_ID41h.Sig.CushionSensorStatus = 0x0;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x1;    //陡坡缓降


        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    case  7:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x1;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航

        R485_ID41h.Sig.RecuperationStatusFeedback = 0x1;    //能量回收设置
        R485_ID41h.Sig.TotalBatteryVoltage = 0xFF;   //总电池电压


        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x1E0;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30  66km
        R485_ID41h.Sig.TotalBatterySOC = 0x84; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0x10;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x6;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒
        // R485_ID41h.Sig.SlopePattern = 0x1;   //跛行

        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    case  8:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航


        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x22F;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30  77km
        R485_ID41h.Sig.TotalBatterySOC = 0x9A; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0x11;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x7;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒

        R485_ID41h.Sig.HandlebarFaultIndicator = 0x1;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 1;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;

        break;  
    case  9:

        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航

        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x282;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 88km
        R485_ID41h.Sig.TotalBatterySOC = 0xB0; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0x1;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0x12;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x8;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒
        R485_ID41h.Sig.ChargeState = 0x1;   //充电状态
        

        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;  
    case  10:
        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x300;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 88km
        R485_ID41h.Sig.TotalBatterySOC = 0xC6; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0x13;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x9;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒

        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x1; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x1;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x1;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x1;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x1;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x0;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x1;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x1;    //巡航

        R485_ID41h.Sig.HandlebarFaultIndicator = 1;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 1;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
         case  11:
        R485_ID41h.Sig.ICMCalculatesVehicleSpeed = 0x300;   //速度 = (X * 0.512 * 3.14 * 1.05) / 30 88km
        R485_ID41h.Sig.TotalBatterySOC = 0xC8; //电量
        R485_ID41h.Sig.VehicleStatus = 0x3;   //整车状态
        R485_ID41h.Sig.SpeedGear = 0;     //挡位
        //功率暂空一会做
        R485_ID41h.Sig.IOTRealTime_Hour = 0x13;    //时间：时
        R485_ID41h.Sig.IOTRealTime_Minute = 0x9;  //时间：分
        R485_ID41h.Sig.IOTRealTime_Second = 0;  //时间：秒

        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x1; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x1;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x1;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x1;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x1;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x0;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x1;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x1;    //巡航

        R485_ID41h.Sig.HandlebarFaultIndicator = 1;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    default:
        R485_ID41h.Sig.EleHeadlightFunctionSettings = 0x0; // 自动大灯
        R485_ID41h.Sig.ChargeState = 0x0;   //充电状态
        R485_ID41h.Sig.SlopePattern = 0x0;   //跛行
        R485_ID41h.Sig.CushionSensorStatus = 0x1;   //坐垫压力
        R485_ID41h.Sig.SlopeDescentFunctionStatus = 0x0;    //陡坡缓降
        R485_ID41h.Sig.TCSActivation = 0x1; //TCS激活
        R485_ID41h.Sig.TCSFunctionalStatus = 0x0;   //TCS状态
        R485_ID41h.Sig.ElectronicCushionStatus = 0x1;   //座桶开关
        R485_ID41h.Sig.SupportSwitchSignalFeedback = 0x0;   //边撑
        R485_ID41h.Sig.CruiseMode = 0x0;    //巡航

        R485_ID41h.Sig.HandlebarFaultIndicator = 0;
        R485_ID41h.Sig.UUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.UDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.VUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.VDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.WUpBridgeArmMosFault = 0;
        R485_ID41h.Sig.WDownBridgeArmMosFault = 0;
        R485_ID41h.Sig.MCUFaultStateU_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateV_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStateW_PhaseHallFault = 0;
        R485_ID41h.Sig.MCUFaultStatus_HandlebarFault = 0;
        R485_ID41h.Sig.BMS_0CommunicationStatus = 0;
        R485_ID41h.Sig.MCUCommunicationStatus = 0;
        R485_ID41h.Sig.ALMCommunicationStatus = 0;
        R485_ID41h.Sig.ICMCommunicationStatus = 0;
        R485_ID41h.Sig.BrakeLeverFault = 0;
        R485_ID41h.Sig.PhaseLossFault = 0;
        R485_ID41h.Sig.MCUOverTempProtection = 0;
        R485_ID41h.Sig.MotorOvertempProtection = 0;
        R485_ID41h.Sig.RotorLocked = 0;
        break;
    }
    u32sendendflag = R485_Send(0x41, R485_ID41h.Msg, sizeof(R485_ID41h.Msg));
    return u32sendendflag;
}

uint32_t R485_Send_0x42(void)
{
    memset(R485_ID42h.Msg, 0xFF, 64);
    uint32_t u32sendendflag = 0;
    R485_ID42h.Sig.TPower = 0;        //T动力状态
    R485_ID42h.Sig.TotalBatteryCurrent = 0; 
    R485_ID42h.Sig.BLE_MAC01 = name1;       //发送mac地址
    R485_ID42h.Sig.BLE_MAC02 = name2; 
    R485_ID42h.Sig.BLE_MAC03 = 0xA;
    R485_ID42h.Sig.BLE_MAC04 = 0xA;
    R485_ID42h.Sig.BLE_MAC05 = 0xA;
    R485_ID42h.Sig.BLE_MAC06 = 0xA; 
    R485_ID42h.Sig.EggAnimation = 0;
    switch (MENU_CHECK_STEP)
    {
    case  0:
        break;
    case  1:
        R485_ID42h.Sig.TotalBatteryCurrent = 0x44;  //母线电流
        break;
    case  2:
        R485_ID42h.Sig.TotalBatteryCurrent = 0x74;  //母线电流
        break;
    case  3:
        R485_ID42h.Sig.TotalBatteryCurrent = 0xFA;  //母线电流
        break;
    case  4:
        
        R485_ID42h.Sig.SuperTPower = 0x0;   //超级T动力模式
        R485_ID42h.Sig.TPower = 0x1;        //T动力状态
        break;
    case  5:
        // R485_ID42h.Sig.nenglainhuishou = 0x1;
        R485_ID42h.Sig.TotalBatteryCurrent = 0x17;
        break;
    case  6:
        // R485_ID42h.Sig.nenglainhuishou = 0x1;
        R485_ID42h.Sig.TotalBatteryCurrent = 0x14;
        break;
    case  7:
    R485_ID42h.Sig.nenglainhuishou = 0x1;
        R485_ID42h.Sig.TotalBatteryCurrent = 0x0;
        break;  
    case  8:
        break;  
    case  9:  
        break;
    case 10:
        break;
    case 11:
        break;
    case 12:

        break;
    case 13:
        break;
    case 14:
            R485_ID42h.Sig.PasswordUnlockCommand = 0x1;
        R485_ID42h.Sig.PasswordCanbeEnter = 0x2;
        break;
    default:
        break;
    }
    u32sendendflag = R485_Send(0x42, R485_ID42h.Msg, sizeof(R485_ID42h.Msg));
    // RS485_TX_finish = 1;
    return u32sendendflag;
}
uint32_t R485_Send_ble0x42(void)
{
    // LINE_OUT_NEG_09 = 1;
    memset(R485_ID42h.Msg, 0xFF, 64);
    uint32_t u32sendendflag = 0;
    R485_ID42h.Sig.BLE_MAC01 = 0xAA;       //发送mac地址
    R485_ID42h.Sig.BLE_MAC02 = 0xBB; 
    R485_ID42h.Sig.BLE_MAC03 = 0xAA;
    R485_ID42h.Sig.BLE_MAC04 = 0xBB;
    R485_ID42h.Sig.BLE_MAC05 = 0xAA;
    R485_ID42h.Sig.BLE_MAC06 = 0xBB; 
    u32sendendflag = R485_Send(0x42, R485_ID42h.Msg, sizeof(R485_ID42h.Msg));
    // RS485_TX_finish = 1;
    return u32sendendflag;
}
uint32_t R485_Send_0x47(void)
{

}
uint8_t R485_0x80_msg[64];
uint32_t R485_Send_0x80(void)
{
    uint8_t length;
    uint32_t u32sendendflag = 0;
    if(clearOdoFlag != 0)
    {
        RS485_TX_finish = 0;
    }
    // memset(R485_0x80_msg,0xFF,sizeof(R485_0x80_msg));
    if(RS485_TX_finish == 0)
    {
        
        RS485_TX_finish = 1;
        u32sendendflag = R485_Send(0x80, R485_0x80_msg, sizeof(R485_0x80_msg));
        RS485_send_time = 0;
        RS485_TX_finish = 1;
    }
    
    RS485_TX_finish = 1;
    return u32sendendflag;
}
uint32_t R485_Send_0x45(void)
{
    uint8_t length;
    uint32_t u32sendendflag = 0;
    // memset(R485_0x80_msg,0xFF,sizeof(R485_0x80_msg));
    if(RS485_TX_finish == 0)
    {
        
        RS485_TX_finish = 1;
        u32sendendflag = R485_Send(0x45, R485_0x80_msg, sizeof(R485_0x80_msg));
        RS485_send_time = 0;
        RS485_TX_finish = 1;
    }
    
    RS485_TX_finish = 1;
    return u32sendendflag;
}
uint8_t Send_Lineget_Msg[64];
uint8_t firstsec = 0;;
uint32_t R485_Send_Line_0x47(uint8_t n)
{
    uint8_t num = n;
    uint8_t length;
    uint32_t u32sendendflag = 0;
    if(RS485_TX_finish == 0)
    {
        switch (n)
        {
            case 0:
                Send_Lineget_Msg[0] = 0x22;
                Send_Lineget_Msg[1] = 0xF2;
                Send_Lineget_Msg[2] = 0x0;
                break;
            case 8:
                Send_Lineget_Msg[0] = 0x22;
                Send_Lineget_Msg[1] = 0xF2;
                Send_Lineget_Msg[2] = 0x01;
                break;
            case 2:
                if(firstsec == 0)
                {
                    Send_Lineget_Msg[0] = 0x22;
                    Send_Lineget_Msg[1] = 0xF2;
                    Send_Lineget_Msg[2] = 0x06;
                    firstsec = 1;
                }
                else
                {
                    Send_Lineget_Msg[0] = 0x22;
                    Send_Lineget_Msg[1] = 0xF2;
                    Send_Lineget_Msg[2] = 0x02;
                    firstsec = 0;
                }
                    break;
            case 3:
                if(firstsec == 0)
                {
                    Send_Lineget_Msg[0] = 0x22;
                    Send_Lineget_Msg[1] = 0xF2;
                    Send_Lineget_Msg[2] = 0x07;
                    firstsec = 1;
                }
                else
                {
                    Send_Lineget_Msg[0] = 0x22;
                    Send_Lineget_Msg[1] = 0xF2;
                    Send_Lineget_Msg[2] = 0x03;
                    firstsec = 0;
                }
                
                break;
            case 7:
                Send_Lineget_Msg[0] = 0x22;
                Send_Lineget_Msg[1] = 0xF2;
                Send_Lineget_Msg[2] = 0x04;
                break;
            case 1:
                Send_Lineget_Msg[0] = 0x22;
                Send_Lineget_Msg[1] = 0xF2;
                Send_Lineget_Msg[2] = 0x05;
                break;
            case 4:
                
                break;
            case 5:
                
                break;
            default:
            break;
                
        }
        RS485_TX_finish = 1;
        u32sendendflag = R485_Send(0x47, Send_Lineget_Msg, 3);
        RS485_send_time = 0;
        RS485_TX_finish = 1;
    }
    RS485_TX_finish = 1;
    return u32sendendflag;
}
uint8_t R485_zhenduan_Msg1[64];
uint32_t R485_Sendcheck_0x47(void)
{
    uint8_t length;
    uint32_t u32sendendflag = 0;
    if(RS485_TX_finish == 0)
    {

        R485_zhenduan_Msg1[0] = 0x22;
        R485_zhenduan_Msg1[1] = 0x50;
        R485_zhenduan_Msg1[2] = 0x0;
        u32sendendflag = R485_Send(0x47, R485_zhenduan_Msg1, 3);
        RS485_send_time = 0;
    
    }
    RS485_TX_finish = 1;
    return u32sendendflag;
}
uint8_t Send_Lineget_Msg[64];
uint32_t R485_Send_clear(void)
{
    // uint8_t length;
    // HJ_OtherKeyCurrent.count = 3;
    // uint32_t u32sendendflag = 0;
    // if(RS485_TX_finish == 0)
    // {
    //     if(RS485_send_time > 3000)
    //     {
    //     Port_SetPortPinLevel(1, 4, PortGpioHigh);
    //     Delay(10);
    //     RS485_TX_finish = 1;
    //     u32sendendflag = R485_Send(0x41, R485_ID41h.Msg, sizeof(R485_ID41h.Msg));
    //     RS485_send_time = 0;
    //     Delay(10);
    //     Port_SetPortPinLevel(1, 4, PortGpioLow);
    //     Delay(10);
    //     RS485_TX_finish = 1;
    //     }
    // }
    // RS485_TX_finish = 1;
    // Port_SetPortPinLevel(1, 4, PortGpioLow);
    // return u32sendendflag;
}

uint32_t R485_Send_0x70(void)
{
    // uint8_t num  = 0;
    // uint8_t length;
    // uint32_t u32sendendflag = 0;
    // if(RS485_TX_finish == 0)
    // {
    //     switch (n)
    //     {
    //         case 0:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x0;
    //             break;
    //         case 1:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x01;
    //             break;
    //         case 2:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x02;
    //             break;
    //         case 3:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x03;
    //             break;
    //         case 4:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x04;
    //             break;
    //         case 5:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x05;
    //             break;
    //         case 6:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x06;
    //             break;
    //         case 7:
    //             Send_Lineget_Msg[0] = 0x22;
    //             Send_Lineget_Msg[1] = 0xF2;
    //             Send_Lineget_Msg[2] = 0x07;
    //             break;
    //         default:
    //         break;
                
    //     }
    //     RS485_TX_finish = 1;
    //     u32sendendflag = R485_Send(0x47, Send_Lineget_Msg, 3);
    //     RS485_send_time = 0;
    //     Delay(10);
    //     Delay(10);
    //     RS485_TX_finish = 1;
    // }
    // RS485_TX_finish = 1;

    // return u32sendendflag;
}
uint32_t R485_SendMACaddress_0x42(void)
{
    uint8_t length;
    uint32_t u32sendendflag = 0;
    if(RS485_TX_finish == 0)
    {
        R485_ID42h.Sig.BLE_MAC01 = 0;
        R485_ID42h.Sig.BLE_MAC02 = 0;
        u32sendendflag = R485_Send(0x42, R485_ID42h.Msg, sizeof(R485_ID42h.Msg));
        RS485_send_time = 0;
    
    }
    RS485_TX_finish = 1;
    return u32sendendflag;
}
