#ifndef __RIIC_H_
#define __RIIC_H_

#include "r_typedefs.h"

/*
Unused pins cannot be enabled!!!
Unused pins cannot be enabled!!!
Unused pins cannot be enabled!!!
*/

//P0_11 ,P0_12
#define RIIC0_PORT_P0_11_ENABLE 1U
//P10_2 ,P10_3
#define RIIC0_PORT_P10_2_ENABLE 0U
//P8_0  ,P8_1
#define RIIC1_PORT_P8_0_ENABLE 1U
//P9_0  ,P9_1
#define RIIC1_PORT_P9_0_ENABLE 0U

typedef struct
{
	uint32_t u32RIICSlaveAddr; /*仅在从机模式下有效，可识别的从设备地址，8bit有效*/
	uint32_t u32RIICBaud;	   /**波特率**/
	/**发送相关**/
	uint32_t u32RIICSlaveTxLen;	 /*从机模式时，设定的发送长度，有效数据的长度*/
	uint8_t *pu8RIICSlaveTxData; /*从机模式，发送状态时的指针*/
	/**接收相关**/
	uint32_t u32RIICSlaveRxLen;	 /*从机模式时，设定的接收长度，可以接收的数据长度，超出部分接收，但不存储。*/
	uint8_t *pu8RIICSlaveRxData; /*从机模式，接收状态时的指针*/
} RIIC_Init_st_t;

/***return 0: idle
       1: busy****/
uint32_t RIIC0_IsBusy(void);
void RIIC0_WaitForBusy_Block(void);
void RIIC0_TX_ISR(void);
void RIIC0_Event_ISR(void);
void RIIC0_TX_End_ISR(void);
void RIIC0_RX_End_ISR(void);
/***RIIC0初始化函数
  返回实际 设定的波特率***/
uint32_t RIIC0_Init(RIIC_Init_st_t *pstRIICInit);
uint32_t RIIC0_Master_SendMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICData, uint32_t RIICLEN);
uint32_t RIIC0_Master_RecvMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICData, uint32_t RIICLEN);
uint32_t RIIC0_Master_SendRecvMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICTXData, uint32_t RIICTXLEN, uint8_t *pu8RIICRXData, uint32_t RIICRXLEN);
/****return 1 :fail
return 0 :success
更新发送相关数据指针和长度信息******/
uint32_t RIIC0_Slave_SendMultiByte(uint8_t *pu8RIICData, uint32_t RIICLEN);
/****return 1 :fail
return 0 :success
更新接收相关数据指针和长度信息******/
uint32_t RIIC0_Slave_RecvMultiByte(uint8_t *pu8RIICData, uint32_t RIICLEN);

/**返回0：空闲(需手动清零)   1：正在接收  2：接收完成**/
uint32_t RIIC0_Slave_Recv_Flag(void);
/***从机接收标志清零，同时会清零上一帧接收计数***/
void RIIC0_Slave_Recv_Flag_Reset(void);
/**返回接收数据长度，注意一定是检测到接收完成后再读取**/
uint32_t RIIC0_Slave_Recv_Count(void);
/**返回0：空闲(需手动清零)   1：正在发送  2：发送完成**/
uint32_t RIIC0_Slave_Send_Flag(void);
/***从机发送标志清零，同时会清零上一帧发送计数***/
void RIIC0_Slave_Send_Flag_Reset(void);
/**返回发送数据长度，注意一定是检测到发送完成后再读取**/
uint32_t RIIC0_Slave_Send_Count(void);

/***return 0: idle
       1: busy****/
uint32_t RIIC1_IsBusy(void);
void RIIC1_WaitForBusy_Block(void);
void RIIC1_TX_ISR(void);
void RIIC1_Event_ISR(void);
void RIIC1_TX_End_ISR(void);
void RIIC1_RX_End_ISR(void);
/***RIIC1初始化函数
  返回实际 设定的波特率***/
uint32_t RIIC1_Init(RIIC_Init_st_t *pstRIICInit);
uint32_t RIIC1_Master_SendMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICData, uint32_t RIICLEN);
uint32_t RIIC1_Master_RecvMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICData, uint32_t RIICLEN);
uint32_t RIIC1_Master_SendRecvMultiByte_Interrupt(uint32_t u32RIICDevice, uint8_t *pu8RIICTXData, uint32_t RIICTXLEN, uint8_t *pu8RIICRXData, uint32_t RIICRXLEN);
/****return 1 :fail
return 0 :success
更新发送相关数据指针和长度信息******/
uint32_t RIIC1_Slave_SendMultiByte(uint8_t *pu8RIICData, uint32_t RIICLEN);
/****return 1 :fail
return 0 :success
更新接收相关数据指针和长度信息******/
uint32_t RIIC1_Slave_RecvMultiByte(uint8_t *pu8RIICData, uint32_t RIICLEN);

/**返回0：空闲(需手动清零)   1：正在接收  2：接收完成**/
uint32_t RIIC1_Slave_Recv_Flag(void);
/***从机接收标志清零，同时会清零上一帧接收计数***/
void RIIC1_Slave_Recv_Flag_Reset(void);
/**返回接收数据长度，注意一定是检测到接收完成后再读取**/
uint32_t RIIC1_Slave_Recv_Count(void);
/**返回0：空闲(需手动清零)   1：正在发送  2：发送完成**/
uint32_t RIIC1_Slave_Send_Flag(void);
/***从机发送标志清零，同时会清零上一帧发送计数***/
void RIIC1_Slave_Send_Flag_Reset(void);
/**返回发送数据长度，注意一定是检测到发送完成后再读取**/
uint32_t RIIC1_Slave_Send_Count(void);

#endif
