#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "COM_CAN.h"
#include "RTE_GPIO.h"
#include "DoCAN_ISO15765.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "TFT_LCD.h"
#include "TM035HFZGZx.h"
#include "UDS_ISO14229_Server.h"
#include "CAN_Lib.h"
#include "Display_Info.h"
#include "Key.h"
#include "Check_Ctrl.h"
#include "FreIn_User.h"
#include "../UART/UART.h"
#include "string.h"
#include "api_RS485.h"
#include "RTE_WDT.h"
#include "R485_Communication_Matrix.h"
/*******************************************************************************

------------------------------------------------------------------------------*/
uint8_t AutoFlag = 0;
uint8_t compareresult;
const unsigned char gImage_cuo1[] = {24, 24,0X00,0X00,0X00,0X00,0X30,0X70,0XE0,0XC0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0X70,0X30,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X83,0XC7,0X66,0X38,0X38,0X7C,0XE6,0XC3,0X81,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0C,0X0C,0X06,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X0E,0X0C,0X00,0X00,0X00,0X00,};
const unsigned char gImage_dui1[] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0XE0,0X40,0X00,0X00,0X00,0X00,0X08,0X18,0X30,0X70,0XC0,0X80,0X00,0X00,0X80,0XC0,0XE0,0X70,0X38,0X1C,0X0E,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{    
    DoCAN_Communication_Service( );
    if ( CAN_Msg_Tx_Enable != 0 )
    {
        UDS_Server_Application_Service( );
    }
    TFT_LCD_Display_Update_Service( );
    Fre_In_Service(FRE_VEHICLE);


    // if(UART_Ch0_Get_TX_Busy_Flag())
    // {
        LINE_OUT_NEG_09 = 1;        //发送
    // }
    // else
    // {
    //     LINE_OUT_NEG_09 = 0;        //接收
    // }


}
/*============================================================================*/

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
    RTE_ADC_Services( );
    Get_static_Current();
}

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
    
}

/*==============================================================================
10ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    Key_Service();
    Bluetoothname();
    if(clearOdoFlag == 0)
    {
        confirmkeyserve();
        upkeyserve();
        downkeyserve();
    }
    backsend();

    TX_RX_485_service();
}
/*==============================================================================
20ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{

}

/*==============================================================================
50ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group(void)
{

}

/*==============================================================================
100ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint8_t MENU_CHECK_STEPLAST;
void BluetoothAutoDisConnect(void)
{
    if((MENU_CHECK_STEPLAST == 8) && ((MENU_CHECK_STEP == 7) || (MENU_CHECK_STEP == 9)))
    {
        BlueTooth = 0;
    }
    MENU_CHECK_STEPLAST = MENU_CHECK_STEP;
}
uint16_t u16LJSText;
uint32_t AutoTime = 160;
uint32_t ONOFFtime = 450;
uint8_t flashtime = 0;
uint8_t showtime = 0;
uint8_t bleuarttime = 0;
uint8_t querendelay = 0;

void Sys_Run_Mode_100ms_Tasks_Group(void)
{
    ProcessBluetoothDeviceNameWithLock();
    // AutoClearCounterAfterAllLit();
    TimeDelay_3s();
    PasswordUnlock();
    BTEnableDelayPowerReset();
    BluetoothAutoDisConnect();

    static uint32_t loc_timer = 0;
    loc_timer++;
    if ( loc_timer >= 3 )
    {
        loc_timer = 0;
        Recv_Byte1();
    }
    Display_PageNum();

    if(firstpowerflag == 2)
    {
        if(AutoFlag == 1)
        {
            if(AutoTime <= 200)
            {
                AutoTime++;
            }
            else
            {
                MENU_CHECK_STEP_ADD( );   
                AutoTime = 160;
            }
            
        }


        if(Auto_ONOFF == 1)
        {
            if(ONOFFtime <=600)
            {
                ONOFFtime++;
            }
            else
            {
                if(LINE_OUT_NEG_01 == 1)
                {
                    LINE_OUT_NEG_01 = 0;
                    LINE_OUT_NEG_04 = 0;
                    ONOFFtime = 450;
                }
                else
                {
                    LINE_OUT_NEG_01 = 1;
                    LINE_OUT_NEG_04 = 1;
                    ONOFFtime = 0;
                }
            }
        }


        if(flashtime < 3)
        {
            flashtime++;
        }
        else
        {
            if(comparestart == 1)
            {
                compareresult = GetDataCompare();
                if(compareresult == 1)
                {
                    TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                }
                else
                {
                    TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                }
                comparestart = 0;
            }
            else if(comparestart == 0)
            {
                Total_Check( );
                if(zhenduanflag == 3)
                {
                    if(compareresult == 1)
                    {
                        TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                    }
                    else
                    {
                        TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                    }
                }
            }
            else
            {
                Total_Check();
            }
            flashtime = 0;
        }
    }

    if(firstpowerflag == 1)
    {
        zhenduanflag = Data_Mode_Read;
        Total_Check();
        firstpowerflag = 2;
        Display_TFT_Clear();
        if(compareresult == 1 && comparestart == 0)
        {
            if(compareresult == 1)
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
            }
            else
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
            }
            Total_Check();
            firstpowerflag = 3;
        }
    }
    else
    {
        if(compareresult == 1)
        {
            Total_Check();
            firstpowerflag = 3;
             zhenduanflag = Data_Mode_Read;
            if(compareresult == 1)
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
            }
            else
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
            }
        }
    }   
}
/*=================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��50us��ʱ�����б�                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��50us��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    GenDelay_Tick( );
    DoCAN_Timer_Update(50u);
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��100ms��ʱ�����б�                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��100ms��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
uint32_t clearodotimeflash = 0;
void Sys_Exact_100ms_Tasks(void)
{
    if (clearodotimeflash < 0xFFFFFFFF)
    {
        clearodotimeflash++;
        if (clearodotimeflash % 20 == 0)
        {
            if (R485_0x80_msg[11] < 5)
            {
                R485_0x80_msg[11]++;
                R485_0x80_msg[10]++; 
            }
            else
            {
                R485_0x80_msg[11] = 0;
                R485_0x80_msg[10] = 0; 
            }
        }
    }
    else
    {
        clearodotimeflash = 0;
    }
}
/*============================================================================*/
void Sys_Enter_Sleep_Mode(void)
{

}
