#ifndef API_485TR_H_
#define API_485TR_H_

#include "common_include.h"

#define RS485_RX_BUF_LEN 1024 * 4
#define RS485_RX_DATA_LEN 64

#define RS485_RECEIVE_ID_0X48 0X48
#define RS485_RECEIVE_ID_0X49 0X49
#define RS485_RECEIVE_ID_0X4A 0X4A
#define RS485_RECEIVE_ID_0X45 0X45

typedef enum
{
    RS485_Tx_ID48_Idx = 0,
    RS485_Tx_ID49_Idx,
    RS485_Tx_ID4A_Idx,
    RS485_Tx_ID_Idx_Max,
}RS485_Receive_ID_Idx_en_t;

typedef enum
{

    RS485_Rx_ID40_Idx = 0,
    RS485_Rx_ID41_Idx,
    RS485_Rx_ID42_Idx,
    RS485_Rx_ID_Idx_Max,
}RS485_Transmit_ID_Idx_en_t;

typedef struct
{
    uint8_t RS485Data[RS485_RX_BUF_LEN - 1];
    uint8_t length;
} RS485DataPacket;


typedef enum
{
    R485_Normal = 0,
    R485_Lost = 0x55,
}_en_485_Rx_Status_t;



typedef struct
{
    uint8_t u8RecVal[RS485_RX_DATA_LEN];
    uint8_t u8Received;
    uint8_t u8Status;
    uint16_t u16LostTime;
    uint8_t u8ReceivedFlag;
} RS485ValidDataPacket_st_t;
extern uint32_t RS485_send_time;
extern uint32_t R485_Send(const uint16_t cmdID, const uint8_t* pData, uint8_t len);
#endif /* API_ADC_H_ */
