/*
        *** THIS IS A FILE FOR DOXYGEN AND NOT A C HEADER FILE ***
*/

/**
 *******************************************************************************
 ** \mainpage PDL for Traveo - Documentation
 ** <hr>
 *******************************************************************************
 ** \image html Cypress_logo.png
 **
 ** (c) 2017, Cypress Semiconductor Corporation
 ** or a subsidiary of Cypress Semiconductor Corporation. All rights
 ** reserved.
 **
 ** This software, including source code, documentation and related
 ** materials ( "Software" ), is owned by Cypress Semiconductor
 ** Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
 ** and subject to worldwide patent protection (United States and foreign),
 ** United States copyright laws and international treaty provisions.
 ** Therefore, you may use this Software only as provided in the license
 ** agreement accompanying the software package from which you
 ** obtained this Software ( "EULA" ).
 **
 ** If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
 ** non-transferable license to copy, modify, and compile the
 ** Software source code solely for use in connection with Cypress's
 ** integrated circuit products. Any reproduction, modification, translation,
 ** compilation, or representation of this Software except as specified
 ** above is prohibited without the express written permission of Cypress.
 **
 ** Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
 ** WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
 ** BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 ** PARTICULAR PURPOSE. Cypress reserves the right to make
 ** changes to the Software without notice. Cypress does not assume any
 ** liability arising out of the application or use of the Software or any
 ** product or circuit described in the Software. Cypress does not
 ** authorize its products for use in any products where a malfunction or
 ** failure of the Cypress product may reasonably be expected to result in
 ** significant property damage, injury or death ( "High Risk Product" ). By
 ** including Cypress's product in a High Risk Product, the manufacturer
 ** of such system or application assumes all risk of such use and in doing
 ** so agrees to indemnify Cypress against all liability.
 **
 ** This software may be replicated in part or whole for the licensed use, 
 ** with the restriction that this Disclaimer and Copyright notice must be 
 ** included with each copy of this software, whether used in part or whole, 
 ** at all times. 
 **
 ** <br>
 ** <hr>
 ** <b>History</b>
 **  - 2017-03-30
 **    - Version 0.01
 **    - Comment: First alpha release version
 **
 ** <hr>
 ** 
 ** <b>Implementations in PDL:</b>
 ** <table border="0">
 ** <tr><td> HWDG       </td><td>&nbsp; Hardware Watch Dog Timer                        </td></tr>
 ** <tr><td> SWDG       </td><td>&nbsp; Software Watch Dog Timer                        </td></tr>
 ** <tr><td> PORT       </td><td>&nbsp; Port functions                                  </td></tr>
 ** <tr><td> WFLASH     </td><td>&nbsp; Work Flash operation                            </td></tr>
 ** <tr><td> TCFLASH	</td><td>&nbsp; Tightly Coupled Flash Functions                 </td></tr>
 ** <tr><td> CPU        </td><td>&nbsp; CPU Module                                      </td></tr>
 ** <tr><td> MEM        </td><td>&nbsp; Memory functions(i.e. configure core MPU)       </td></tr>
 ** <tr><td> MFS_UART   </td><td>&nbsp; Asynchronous Serial Interface                   </td></tr>
 ** <tr><td> MFS_LIN    </td><td>&nbsp; Local Interconnect Network                      </td></tr>
 ** <tr><td> MFS_I2C    </td><td>&nbsp; Inter-Integrated Circuit                        </td></tr>
 ** <tr><td> MFS_CSIO   </td><td>&nbsp; Clock Synchronous Serial Interface              </td></tr>
 ** <tr><td> ADC 12B    </td><td>&nbsp; Analog to Digital Converter                     </td></tr>
 ** <tr><td> CAN FD     </td><td>&nbsp; CAN with Flexible Data rate                     </td></tr>
 ** <tr><td> FRT        </td><td>&nbsp; Free Running Timer                              </td></tr>
 ** <tr><td> BT_PWM     </td><td>&nbsp; Pulse Width Modulation                          </td></tr>
 ** <tr><td> BT_RLT     </td><td>&nbsp; Reload Timer                                    </td></tr>
 ** <tr><td> BT_PPG     </td><td>&nbsp; Programmable Pulse Generation Timer             </td></tr>
 ** <tr><td> ICU        </td><td>&nbsp; Input Capture Unit                              </td></tr>
 ** <tr><td> EIC        </td><td>&nbsp; External Interrupt Controller                   </td></tr>
 ** <tr><td> DDRHSSPI   </td><td>&nbsp; DDR High Speed Serial Peripheral Interface      </td></tr>
 ** <tr><td> DMA        </td><td>&nbsp; Direct Memory Access                            </td></tr>
 ** <tr><td> RTC	    </td><td>&nbsp; Real time clock                                 </td></tr>
 ** <tr><td> I2S        </td><td>&nbsp; Inter-IC Sound (I2S)                            </td></tr>
 ** </table>
 **
 ** <hr>
 **
 ** <b>Examples:</b>
 ** 
 ** - HWDG
 **   - <pre>use_prewarn            Setup Hwdg(Use pre-warning interrupt)</pre>
 **
 ** - SWDG
 **   - <pre>use_prewarn            Setup Swdg(Use pre-warning interrupt)</pre>
 **
 ** - PORT
 **   - <pre>blink_led              Simple port setting (Blink LEDs) </pre>
 ** 
 ** - WFLASH
 **   - <pre>write_sector0          Work Flash operation test</pre>
 ** 
 ** - TCFLASH
 **   - <pre>write_tcflash          TCFlash operation test</pre>
 **
 ** - MFS_UART
 **   - <pre>fifo_use               UART normal mode (HW FIFO used) </pre>
 ** 
 ** - MFS_LIN
 **   - <pre>mfs_lin_use_ch8_ch10   Tansfer between Master(ch8) and Slave(ch10) </pre>
 **
 ** - MFS_I2C
 **   - <pre>write_data             Writing data from Master to Slave </pre>
 **
 ** - MFS_CSIO
 **   - <pre>init_device            Initialization of a device </pre>
 **
 ** - ADC 12B
 **   - <pre>single_irq_sw          Single channel conversion with conversion end interrupt </pre>
 **
 ** - CAN FD
 **   - <pre>echoback_message       Echoback by reception data, and not use FIFO</pre>
 ** 
 ** - FRT
 **   - <pre>updown_count           FRT up/down mode operation</pre>
 ** 
 ** - BT_PWM
 **   - <pre>output_waveform        Output waveform by 50% duty</pre>
 ** 
 ** - BT_RLT
 **   - <pre>reload_continuous      Running contunuous mode</pre>
 ** 
 ** - BT_PPG
 **   - <pre>ppg_continous          Running contunuous mode</pre>
 **
 ** - ICU
 **   - <pre>detect_falling_edge    Detect falling edge and get a timer data</pre>
 **
 ** - EIC
 **   - <pre>detect_rising_edge     Detect rising edge</pre>
 **
 ** - DDRHSSPI
 **   - <pre>write_hyperflash       Write to the external Spansion Flash</pre>
 **
 ** - DMA
 **   - <pre>ram_transfer           Data transfer between the RAM</pre>
 **
 ** - RTC
 **   - <pre>seconds_count          Count the seconds</pre>
 ** 
 ** <b>Usage of example code:</b>
 ** 
 ** Each example code consists of a 'main.c' and a 'driver/pdl_user.h' module.
 ** Some modules have flash_marker.asm, mcu_settings.h.
 ** The main module contains the example code, where 'pdl_user.h'
 ** contains all necessary settings and definitions for the example
 ** itself.
 ** To use and compile an example, just copy these modules
 ** to the 'source' and 'source/driver' folder, overwriting the modules located
 ** there.The overwritten modules have backups in the 'source/backup' folder for recovery.
 ** 
 ** <br><hr><br>
 ** 
 ******************************************************************************/
