#include "common_include.h"
#include "bsp_app_led_output.h"

void InitTelltale_KY(void)
{
#if (PRO_KY)
   SetTelltalePos("HighBeam",              HighBeam);
   SetTelltalePos("LowBeam",                LowBeam);
   SetTelltalePos("LeftTurn",              LeftTurn);
   SetTelltalePos("RightTurn",            RightTurn);
   SetTelltalePos("TailLamp",              TailLamp);
   SetTelltalePos("FrontFog",              FrontFog);
   SetTelltalePos("RearFog",                RearFog);
   SetTelltalePos("ParkingBreak",      ParkingBreak);
   SetTelltalePos("OverSpeed",            OverSpeed);
   SetTelltalePos("ABS",                        ABS);
   if (IsHaveDBC()) {
        SetTelltalePos("DBC Green",        DBCGreen);
        SetTelltalePos("DBC Yellow",       DBCYellow);
    }
   SetTelltalePos("LedLampFail",        LedLampFail);
   SetTelltalePos("SeatBelt",              SeatBelt);
   SetTelltalePos("ECALL",                    Ecall);
   SetTelltalePos("InteriorLamp",      InteriorLamp);
   SetTelltalePos("Tpms",                      Tpms);
   SetTelltalePos("Mdps",                      Mdps);
   SetTelltalePos("Immobilizer",        Immobilizer);
   SetTelltalePos("MasterSymbol",      MasterSymbol);
   SetTelltalePos("Glow",                      Glow);
   SetTelltalePos("CheckEngine",        CheckEngine);
   SetTelltalePos("BatteryCharge",    BatteryCharge);
   SetTelltalePos("AirBag",                  AirBag);
   SetTelltalePos("OilPressure",        OilPressure);
   SetTelltalePos("DpfGpf",                  DpfGpf);
   SetTelltalePos("ESC",                        ESC);
   SetTelltalePos("EscOff",                  EscOff);
   if (JudgePartNum() ==  PartNum_KY_23MY){
       SetTelltalePos("SCR",                        SCR);
   }
   SetTelltalePos("Water Saperator", WaterSaperator);
   SetTelltalePos("AllLedOpen",          AllLedOpen);
   SetTelltalePos("LowFuel",     DMS_RestoreDefault); 
#endif
}


