#include "common_include.h"

#if (CAN_2ND)
void Can_Clear(uint8_t *data, uint8_t DataLen)
{
    uint8_t i;
    for(i = 0;i < DataLen;i++)
    {
        data[i] = 0;
    }
}

void SetCan1Mode(uint8_t n)
{
    if (n) {
        Port_SetPortPinLevel(1, 2, PortGpioLow);   //stb
    } else {
        Port_SetPortPinLevel(1, 2, PortGpioHigh); //stb
    }
    /*if (n) {
        Port_SetPortPinLevel(1, 5, 1); //stb PortGpioHigh
    } else {
        Port_SetPortPinLevel(1, 5, 0); //stbPortGpioHigh
    }*/
}

void SetCan0Mode(uint8_t n)
{
  if (n) {
    Port_SetPortPinLevel(0, 29, PortGpioLow);
  } else {
    Port_SetPortPinLevel(0, 29, PortGpioHigh);
  }
}

//void CANInit(void)
//{
//    InitCanRecvModule();
//    memset(&CanFDDataStruct, 0, sizeof (CanFDDataStruct));
//    memset(&MMCanDataStruct, 0, sizeof (MMCanDataStruct));
//    bsp_CAN0_Init();
//    bsp_CAN1_Init();
//#if (HARD_WARE_VERSION_2_1_7)
//    SetCan0Mode(1);   
//    SetCan1Mode(0);
//#endif
//#if (HARD_WARE_VERSION_2_2_0)
//    SetCan0Mode(0);   
//    SetCan1Mode(0);
//#endif
//}
uint8_t UDSSend;
uint8_t UDSSend_check;


extern void DearCheck (uint8_t Dear);
extern uint8_t GearDisp;


void TimeoutMessagePro(void)
{
    if (CAN_2P5) {
        CanSendCan0Msg(0x421,  SCC11, 8,1);
        CanSendCan0Msg(0x38d,  FCA11_FS, 8,1);
        CanSendCan0Msg(0x364,  FR_CMR_01_1_20ms, 8,1);
        CanSendCan0Msg(0x340, ADAS_CMD_30_1_10ms, 8,1);   
        CanSendCan0Msg(0x443,  RR_C_RDR_01_1_50ms, 8,1);
        CanSendCan0Msg(0x447,  ADAS_CMD_10_2_200ms, 8,1);
        CanSendCan0Msg(0x53E, FR_CMR_02_1_100ms, 8,1);   
        CanSendCan0Msg(0x485, ADAS_CMD_31_1_50ms, 8,1);//50ms  
        CanSendCan0Msg(0x48A,  RR_C_RDR_02_2_50ms, 8,1);
    }
    else {
        CanSendCan0Msg(0x420,  SCC11, 8,1);
        CanSendCan0Msg(0x421,  SCC12, 8,1);
        CanSendCan0Msg(0x38d,  FCA11, 8,1);
        CanSendCan0Msg(0x340,  LKA11, 8,1);
        CanSendCan0Msg(0x53E,  LKA12, 8,1);//50ms
        CanSendCan0Msg(0x485,  HDA11, 8,1);//50ms
        CanSendCan0Msg(0x48A,  BCA11, 8,1);
    }
}


void SendCan0Message(void)
{
    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) {        
        //10ms 
        SendCanMessage10msTimer = Timer10msCnts;   
        InitBuf();
        // CanSendCan0Msg(0x46D,  BMS_6, 8,1);
        // CanSendCan0Msg(0x151,  VCU_3_GearBrakePostion, 8,1);
        // CanSendCan0Msg(0x2E9,  ESP_ABS_FailSts, 8,1);
        // CanSendCan0Msg(0x410,  MCU_MotorSpd, 8,1);
        // CanSendCan0Msg(0x46C,  BMS_HVBatSOC, 8,1);
        // CanSendCan0Msg(0x101,  ECU_101, 8,1);
        CanSendCan0Msg(0x0A30FFE8,  ABS_TCS , 8,1);       
        CanSendCan0Msg(0x0A31FFE8,  Speed_E8 , 8,1);
        // CanSendCan0Msg(0x12B,  ABS_12B , 8,1);
        // CanSendCan0Msg(0x402,  DP_402 , 8,1);
        // CanSendCan0Msg(0x111,  ISG_111 , 8,1); 
    }
    
    if ((Timer10msCnts > SendCanMessage20msTimer) && ((Timer10msCnts - SendCanMessage20msTimer) >= 20)) {
        //20ms
        SendCanMessage20msTimer = Timer10msCnts;
        InitBuf();
        // CanSendCan0Msg(0x391,  BCM_1_Door_Light, 8,1);
        // CanSendCan0Msg(0x176,  OBC_CC_ConnectSts, 8,1);
        // CanSendCan0Msg(0x177,  BMS_ChargeStatus, 8,1);
        
    }
    if ((Timer10msCnts > SendCanMessage50msTimer) && ((Timer10msCnts - SendCanMessage50msTimer) >= 50)) {
      // 50ms
        SendCanMessage50msTimer = Timer10msCnts;
        InitBuf();

        //TimeoutMessagePro();

        // CanSendCan0Msg(0x480,  PEPS_1,  8,1);

    }
    if ((Timer10msCnts > SendCanMessage100msTimer) && ((Timer10msCnts - SendCanMessage100msTimer) >= 98)) {
        //100 ms
        SendCanMessage100msTimer = Timer10msCnts;
        InitBuf();
        // CanSendCan0Msg(0x315,  VCU_4_ICMDisp,  8,1);
        // CanSendCan0Msg(0x449,  AVAS_SwitchFb,  8,1 );
        // CanSendCan0Msg(0x3A5,  VCU_RegenerationLevelSts  ,8,1);
        // CanSendCan0Msg(0x505,  EPS_SteeringAngleCalibrationSts  ,8,1);
        // CanSendCan0Msg(0x412,  IMMO_AuthFailWarn  ,8,1);
        // CanSendCan0Msg(0x3A3,  VCU_PercentgPwrUsage  ,8,1);
        // CanSendCan0Msg(0x535,  AC_ExternalTemperature_C  ,8,1);
        // CanSendCan0Msg(0x402,  ECU_402  ,8,1);
        // if((g_Stage == STAGE_Other) && ((HJ_OtherKeyCurrent.count == 2) || (HJ_OtherKeyCurrent.count >= 3))) {
        //     CanSendCan0Msg(0x401,  ECU_401  ,8,1);
        // }
        
        
        
    }
    if ((Timer10msCnts > SendCanMessage200msTimer) && ((Timer10msCnts - SendCanMessage200msTimer) >= 190)) {
       // 200ms
       SendCanMessage200msTimer = Timer10msCnts;
       InitBuf();
    //    CanSendCan0Msg(0x50E,  CGW6, 8,1);
    }
    if ((Timer10msCnts > SendCanMessage500msTimer) && ((Timer10msCnts - SendCanMessage500msTimer) >= 500)) {
      // 500ms
      SendCanMessage500msTimer = Timer10msCnts;
      InitBuf();
    //   CanSendCan0Msg(0x5D1,  MCU_MotorTempWarning, 8,1);   
    //   CanSendCan0Msg(0x51B,  TPMS_TirePressureSystemFailSts, 8,1);  
    //   CanSendCan0Msg(0x31C,  ABM_AirBagFailSts, 8,1); 
      
      
    }
    if ((Timer10msCnts > SendCanMessage1000msTimer) && ((Timer10msCnts - SendCanMessage1000msTimer) >= 1000)) {
      // 1000ms
      SendCanMessage1000msTimer = Timer10msCnts;
      InitBuf();
    }
}
#endif