#ifndef __TAS2505_H__
    #define __TAS2505_H__
/** SWDG *********************************************************************/
#include "base_types.h"

typedef struct msm_camera_i2c_reg_conf
{
    uint8_t addr;                    /*!<   */
    uint8_t RegVal;                  /*!<  */
} msm_camera_i2c_reg_conf_t;

static msm_camera_i2c_reg_conf_t TAS2505_DAC_Int[] = {
    /* # Playback Class-D
    # Page switch to Page 0
    W 30 00 00 */
    {0x00, 0x00,},    
    /*# Assert Software reset
    W 30 01 01 */
    {0x01, 0x01,},    
    /*# Dac Instruction programming PRB #1 
    W 30 3c 01*/
    {0x3c, 0x01,},    
    /*# CODEC_CLKIN=PLL_CLK.BCLK should be 1.536MHz
    W 30 04 07*/
    {0x04, 0x07,},    
    /*# PLL ON.PLL_P = 1.PLL_R=1
    W 30 05 91 */
    {0x05, 0x91,},    
    /*# PLL_J = 56
    W 30 06 38 */
    {0x06, 0x38,},    
    /*# PLL_D = 0
    W 30 07 00 00*/
    {0x07, 0x00,},    
    /*# Codec Interface control Word length = 16bits.BCLK&WCLK inputs.I2S mode.
    W 30 1b 00*/
    {0x1b, 0x80,},    
    /* # Data slot offset 00
    W 30 1c 00 */
    {0x1c, 0x00,},    
    /*# DAC NDAC Powered up, NDAC=7
    W 30 0b 87 */
    {0x0b, 0x87,},    
    /*# DAC MDAC Powered up, MDAC=2
    W 30 0c 82 */
    {0x0c, 0x82,},    
    /*# DAC OSR(9:0)-> DOSR=128
    W 30 0d 00 */
    {0x0d, 0x00,},    
    /*# DAC OSR(9:0)-> DOSR=128
    W 30 0e 80*/
    {0x0e, 0x80,},    
    /*# Only LDAC powered up.Dac path setup LDAC data Mono of LDAC and RDAC. RDAC data disabled.Soft step 1 per Fs.
    W 30 3f B0 */
    {0x3f, 0xB0,},    
    /*# DAC volume for Left channel not muted.Right DAC muted.
    W 30 40 04 */
    {0x40, 0x04,},
    /*# LDAC digital gain 0dB
    W 30 41 00*/
    {0x41, 0x30,},
    /*# Page Switch to Page 1
    W 30 00 01*/
    {0x00, 0x01,},
    /*# LDO output programmed as 1.8V and Level shifters powered up.
    W 30 02 00*/
    {0x02, 0x00,},
    /* # Master Reference Powered on
    W 30 01 10 */
    {0x01, 0x10,},
    /* # Output common mode for DAC set to 0.9V (default)
    W 30 0a 00 */
    {0x0a, 0x00,},
    /* # LDAC AFIR is 6th order FIR filter and Powered up.
    W 30 03 00 */
    {0x03, 0x00,},
    /*# SPKL attn. Gain =0dB
    W 30 2E 00 */
    {0x2e, 0x00,},
    /*# SPKL driver PGA Gain=6.0dB 
    W 30 30 10 */
    {0x30, 0x10,},
    /* # SPK OSCP enabled , OCP Degltich=4, OTP enabled , OTP Deglitch=5
    W 30 52 00 */
    {0x52, 0x00,},
    /*# SPK powered up
    W 30 2D 02  */
    {0x2d, 0x02,},
}; 


extern void InitTAS2505(void);
extern void Init6749(void);

#endif /* __TAS2505_H__ */