#ifndef _CAN_APP_H_
#define _CAN_APP_H_

#include "RSCAN.h"
#include "Display_Info.h"

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                   :8;
        uint64_t                   :8;
        uint64_t                Vspeeed :8;
        uint64_t                   :8;
        uint64_t                   :8;
        uint64_t                   :8;
        uint64_t                   :8;
        uint64_t                   :8;

    } Sig;
} CANMsg220Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                Year    :8;
        uint64_t                Month   :8;
        uint64_t                Day     :8;
        uint64_t                Hour    :8;
        uint64_t                Minute  :8;
        uint64_t                Second  :8;
        uint64_t                   :8;
        uint64_t                   :8;

    } Sig;
} CANMsg481Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                Eletricity_H:8;
        uint64_t                Eletricity_L:8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg020Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                TCS:4;
        uint64_t                :2;
        uint64_t                Tcs_mode:1;
        uint64_t                Tcs_Control:1;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg042Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                Signal_4g:8;
        uint64_t                Signal_Gps:8;
        uint64_t                :6;
        uint64_t                Blooth_phone:1;
        uint64_t                Blooth_led:1;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg480Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;

        uint64_t                :8;
        uint64_t                :8;

        uint64_t                :1;
        uint64_t                :3;
        uint64_t                Tcs_Status:1;
        uint64_t                :2;
        uint64_t                :1;

        uint64_t                Energy_status:1;
        uint64_t                :2;
        uint64_t                Side_bracket280:1;
        uint64_t                :1;
        uint64_t                Energy_recovery:2;
        

        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg280Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :2;
        uint64_t                Gear:2;
        uint64_t                :3;
        uint64_t                Side_bracket202:1;

        uint64_t                :2;
        uint64_t                Hill_Descent_control:1;
        uint64_t                :1;
        
        uint64_t                Ready:2;
        uint64_t                Cruiste:1;
        uint64_t                :1;
        
        uint64_t                :2;
        uint64_t                Fault:1;
        uint64_t                :5;

        uint64_t                Range:8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg202Union;
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;
    
        uint64_t                :4;
        uint64_t                Motor_hert:1;
        uint64_t                :3;

        //uint64_t                :8;/*2byte*/
        uint64_t                :3;
        uint64_t                Msg_0x001_2b3t:1;
        uint64_t                :4;

        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg001Union;



typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

        uint64_t                :7;
        uint64_t                Battery_temp:1;

        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg021Union;

typedef union
{
    uint8_t Msg[8];
    struct
    {
        uint64_t                NFC_C_card:8;
        //uint64_t              NFC_C_card:1; 

        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

        uint64_t                :8;
        uint64_t                :8;
        

        
    } Sig;
} CANMsg284Union;

//诊断发送
typedef union
{
    uint8_t Msg[8];
    struct
    {
        uint64_t                diagnosis0:8;
        uint64_t                diagnosis1:8;
        uint64_t                diagnosis2:8;
        uint64_t                diagnosis3:8;
        uint64_t                diagnosis4:8;
        uint64_t                diagnosis5:8;
        uint64_t                diagnosis6:8;
        uint64_t                diagnosis7:8;
        

        
    } Sig;
} CANMsg786Union;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint64_t                :8;
        uint64_t                :8;

        uint64_t                TCS:4;
        uint64_t                :2;
        uint64_t                Tcs_mode:1;
        uint64_t                Tcs_Control:1;
        
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;
        uint64_t                :8;

    } Sig;
} CANMsg207Union;
extern uint8_t UIDNumber[17];
void CAN_MSG_COUNTER_PLUS(void);

uint8_t CrcCheckSum(uint8_t *data, uint8_t len);
void Student_Card_Triggers(void); 

void  Can_Set_Buff_200(uint8_t CopyData []);
void  Can_Set_Buff_481(uint8_t CopyData []);
void  Can_Set_Buff_020(uint8_t CopyData []);
void  Can_Set_Buff_042(uint8_t CopyData []);
void  Can_Set_Buff_480(uint8_t CopyData []);
void  Can_Set_Buff_280(uint8_t CopyData []);
void  Can_Set_Buff_202(uint8_t CopyData []);
void  Can_Set_Buff_001(uint8_t CopyData []);
void  Can_Set_Buff_021(uint8_t CopyData []);
void  Can_Set_Buff_284(uint8_t CopyData []);
void  Can_Set_Buff_786(uint8_t CopyData []);
void  Can_Set_Buff_207(uint8_t CopyData []);

void CAN_Msg_Steps_100ms();
extern uint8_t uidWrite;
extern uint8_t UIDGetstep;
extern uint8_t VSpeed;
extern uint8_t Student_Card;
extern uint8_t UIDStep;
// uint8_t Student_Card_Last;
#endif
