#include  "CAN_CH0_CAN_Communication_Matrix.h"
/* 2023/09/21 14:57:31 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF4117ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEAE17ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF1017ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEC1EEul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HCSPS_LampFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF4117_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_BackUPSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_Seatbeltsts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HandBrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_2_Air_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEAE17_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_1_Air_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEAE17_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HeatedMirrorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RearFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_FrontFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LowBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HighBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_Total_Vehicle_Distance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEC1EE_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEC1EE_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEC1EE_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_Send18FEC1EE_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_Send10FF4117_Msg:
        u8Result = CAN_CH0_ID_Send10FF4117_Msg_Count;
        break;
    case CAN_CH0_ID_Send18FEAE17_Msg:
        u8Result = CAN_CH0_ID_Send18FEAE17_Msg_Count;
        break;
    case CAN_CH0_ID_Send10FF1017_Msg:
        u8Result = CAN_CH0_ID_Send10FF1017_Msg_Count;
        break;
    case CAN_CH0_ID_Send18FEC1EE_Msg:
        u8Result = CAN_CH0_ID_Send18FEC1EE_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

