#ifndef _MM_CAN_TP_H
#define _MM_CAN_TP_H

#define NAVI_FONT_MAX_CHAR 32

#define MM_CAN_TP_DATA_DISPLAY_ON 0
#define MM_CAN_TP_DATA_DISPLAY_OFF_NEW_DATA 1
#define MM_CAN_TP_DATA_DISPLAY_OFF_RENDERING 2
#define MM_CAN_TP_DATA_DISPLAY_RECV_NEW 3

#define MM_CAN_TP_DATA_DISPLAY_OFF_CHANGE_POINT 3
#define MM_CAN_TP_DATA_DISPLAY_OFF_RENDERING_CHANGE_POINT 4

enum {
    TP_DEST_NONE,
    TP_DEST_FM,
    TP_DEST_DMB,
    TP_DEST_SXM,
    TP_DEST_DAB,
    TP_DEST_CD,
    TP_DEST_DVD,
    TP_DEST_iPod,
    TP_DEST_USB,
    TP_DEST_MyMusic,
    TP_DEST_BTSong,
    TP_DEST_AndroidAuto,
    TP_DEST_CarPlay,
    TP_DEST_QQMusic,
    TP_DEST_TingBan,
    TP_DEST_BaiduMusic,
    TP_DEST_Carlife,
    TP_DEST_hfname,
    TP_DEST_hfno,
    TP_DEST_iBox,    
};

#define MM_CAN_DATA_LEN_MAX 128

extern uint8_t MCanMiniTpData_Fm[MM_CAN_DATA_LEN_MAX]; //fm
extern uint8_t MCanMiniTpData_DMB[MM_CAN_DATA_LEN_MAX]; //DMB
extern uint8_t MCanMiniTpData_SXM[MM_CAN_DATA_LEN_MAX]; //SXM/XM
extern uint8_t MCanMiniTpData_DAB[MM_CAN_DATA_LEN_MAX]; //DAB
extern uint8_t MCanMiniTpData_CD[MM_CAN_DATA_LEN_MAX]; //CD
extern uint8_t MCanMiniTpData_DVD[MM_CAN_DATA_LEN_MAX]; //DVD
extern uint8_t MCanMiniTpData_iPod[MM_CAN_DATA_LEN_MAX]; //iPod
extern uint8_t MCanMiniTpData_USB[MM_CAN_DATA_LEN_MAX]; //USB
extern uint8_t MCanMiniTpData_Juke[MM_CAN_DATA_LEN_MAX]; //Juke Box/My Music
extern uint8_t MCanMiniTpData_BTSong[MM_CAN_DATA_LEN_MAX]; //BT Song
extern uint8_t MCanMiniTpData_AndroidAuto[MM_CAN_DATA_LEN_MAX]; //Android Auto
extern uint8_t MCanMiniTpData_CarPlay[MM_CAN_DATA_LEN_MAX]; //Car Play
extern uint8_t MCanMiniTpData_QQMusic[MM_CAN_DATA_LEN_MAX]; //QQ Music
extern uint8_t MCanMiniTpData_TingBan[MM_CAN_DATA_LEN_MAX]; //Ting Ban
extern uint8_t MCanMiniTpData_BaiduMusic[MM_CAN_DATA_LEN_MAX]; //Baidu Music
extern uint8_t MCanMiniTpData_CarLife[MM_CAN_DATA_LEN_MAX]; //Car life
extern uint8_t MCanMiniTpData_hfname[MM_CAN_DATA_LEN_MAX]; //hfname
extern uint8_t MCanMiniTpData_hfno[MM_CAN_DATA_LEN_MAX]; //hfno
extern uint8_t MCanMiniTpData_iBox[MM_CAN_DATA_LEN_MAX]; //iBox

extern uint8_t MCanNaviTpDataRoad[MM_CAN_DATA_LEN_MAX];
extern uint8_t MCanNaviTpDataDest[5][MM_CAN_DATA_LEN_MAX];;

extern uint32_t CurDisplayAvId;
extern uint32_t DestDisplayAvId;
extern uint32_t LastAvTpId;
extern uint8_t MCanTpData[MM_CAN_DATA_LEN_MAX];
extern uint8_t MCanMiniTpData[MM_CAN_DATA_LEN_MAX];
extern uint8_t MCanTpDataNewValid;
extern uint16_t MiniDisplayChars[NAVI_FONT_MAX_CHAR];

extern void AnalysisCanTp(void);
extern uint16_t GetFontDisplayMaxLen(uint16_t *DisplayChar, uint16_t MaxWidth);
extern uint32_t TpGetRespId(uint32_t ReqId);
extern void TpRecvNewDataNavi(uint8_t *data, uint16_t len);
extern void TpRecvNewDataAv(uint8_t *data, uint16_t len);
extern void UpdateTpData(void);
extern void SetMiniPopupDisplayTp(uint8_t n);

#endif