#ifndef BU91R65_ACCESS_H__
#define BU91R65_ACCESS_H__

#include "BU91R65_Porting.h"

#define   BU91R65_BUFFER_SIZE                (80U)      /**< Buffer size = 90 (90 * 2 = 180 SEGs) */

/** @struct BU98R10_Reg_Val_st_t
  * @brief BU98R10寄存器数据存储结构 \n
  * 存储BU98R10配置相关的寄存器数值
  */
// typedef struct
// {
//     uint8_t u8Freq;
//     uint8_t u8SegR;
//     uint8_t u8SegG;
//     uint8_t u8SegB;
//     uint8_t u8LRS;
//     uint8_t u8LGS;
//     uint8_t u8LBS;
//     uint8_t u8LRW;
//     uint8_t u8LGW;
//     uint8_t u8LBW;
//     uint8_t u8Rsvd[2];
// }BU98R10_Reg_Val_st_t;

typedef struct stBU98R10Handler
{
    uint8_t                 u8Step;/*目前只有一步，应该可以不要了*/
    uint8_t                 u8Counter;
    uint8_t                 u8Freq;
    BU91R65_Pin_Map_st_t    stPinMap;
    uint8_t                 u8BkupBuffer[BU91R65_BUFFER_SIZE];
    uint8_t                *pu8UserBuffer;
    // BU98R10_Reg_Val_st_t    stRegVal;   /**< 寄存器设置值 */
    struct stBU98R10Handler *pstNext;
}BU91R65_Handler_st_t;

/** @struct BU98R10_Color_Setting_st_t
  * @brief  BU98R10 color setting parameters,please refer to the data sheet for details
  */
// typedef struct
// {
//     uint8_t u8SRR;
//     uint8_t u8SRF;
//     uint8_t u8SGR;
//     uint8_t u8SGF;
//     uint8_t u8SBR;
//     uint8_t u8SBF;
    
//     uint8_t u8LRS;
//     uint8_t u8LRW;
//     uint8_t u8LGS;
//     uint8_t u8LGW;
//     uint8_t u8LBS;
//     uint8_t u8LBW;
// }BU98R10_Color_Setting_st_t;

// typedef void (*pfunBU91R65_Set_nCS)(uint8_t u8Level);
// typedef void (*pfunBU91R65_Set_SCLK)(uint8_t u8Level);
// typedef void (*pfunBU91R65_Set_SD)(uint8_t u8Level);
typedef struct 
{
    uint8_t   u8DefaultVal;                                  /**< Default value 0 ~ 7 */
    uint8_t   u8FrameFreq;                                   /**< Frame frequency */
    pfunBU91R65_Set_nCS  u16PinCS;                                      /**< Number of CSB pin */
    pfunBU91R65_Set_SCLK  u16PinSCLK;                                    /**< Number of SCL pin */
    pfunBU91R65_Set_SD  u16PinSD;                                      /**< Number of SD pin */
    // BU98R10_Color_Setting_st_t stColorSetting;               /**< Color setting */
    uint8_t   u16Rsvd[3];                                            
    uint8_t  *pu8Buffer;                                     /**< Data buffer */
}BU91R65_Config_st_t;



#define   BU98R10_FRAME_FREQ_50_0_Hz        (0x00U)     /**< Frame frequency =  50.0Hz */
#define   BU98R10_FRAME_FREQ_60_0_Hz        (0x01U)     /**< Frame frequency =  60.0Hz */
#define   BU98R10_FRAME_FREQ_69_3_Hz        (0x02U)     /**< Frame frequency =  69.3Hz */
#define   BU98R10_FRAME_FREQ_75_0_Hz        (0x03U)     /**< Frame frequency =  75.0Hz */
#define   BU98R10_FRAME_FREQ_81_8_Hz        (0x04U)     /**< Frame frequency =  81.8Hz */
#define   BU98R10_FRAME_FREQ_90_0_Hz        (0x05U)     /**< Frame frequency =  90.0Hz */
#define   BU98R10_FRAME_FREQ_100_0_Hz       (0x06U)     /**< Frame frequency = 100.0Hz */
#define   BU98R10_FRAME_FREQ_112_5_Hz       (0x07U)     /**< Frame frequency = 112.5Hz */
#define   BU98R10_FRAME_FREQ_120_0_Hz       (0x08U)     /**< Frame frequency = 120.0Hz */
#define   BU98R10_FRAME_FREQ_128_6_Hz       (0x09U)     /**< Frame frequency = 128.6Hz */
#define   BU98R10_FRAME_FREQ_138_5_Hz       (0x0AU)     /**< Frame frequency = 138.5Hz */
#define   BU98R10_FRAME_FREQ_150_0_Hz       (0x0BU)     /**< Frame frequency = 150.0Hz */
#define   BU98R10_FRAME_FREQ_163_6_Hz       (0x0CU)     /**< Frame frequency = 163.6Hz */
#define   BU98R10_FRAME_FREQ_180_0_Hz       (0x0EU)     /**< Frame frequency = 180.0Hz */
#define   BU98R10_FRAME_FREQ_200_0_Hz       (0x0FU)     /**< Frame frequency = 200.0Hz */

#define   BU98R10_STATUS_RUN                (0x01U)     /**< Running flag */


/******************************************************************************
                               STARTUP PROCEDURE
1. Call BU91R65_Init() to create a runtime environment.
2. Use BU91R65_Add() to register chips,
   all chips on the segment screen need to be registered one by one.
3. When the chip is registered, its bus will be idle. 
   Delay a few ms to wait for the chip to be ready to work. 
   (During this time, initialization for other devices can be performed)
4. Call BU98R10_Setup() to initialize all chips.
   If Open/Short detection is enabled, go to step 5,
   otherwise go to step 6 directly.
5. Open/Short detection takes some time, 
   please delay for a while to wait for the detection to complete.
   Typically, waiting 600 ms is reliable. Or at least 
   (1000*u8ShortChkPulse)+(2*u8OpenChkPulse) when startup timing is tight.
   (During this time, initialization for other devices can be performed)
6. Call BU98R10_Display_On(), all chips start to display.
******************************************************************************/

/******************************************************************************
                               SHUTDOWN PROCEDURE
1. Remove all chips from the registration list by calling BU91R65_Del().
2. Call BU91R65_DeInit() to clear runtime environment.
******************************************************************************/

extern void    BU91R65_Init(uint32_t u32SpeedTrim);
extern void    BU91R65_DeInit(void);

extern int32_t BU91R65_Add(BU91R65_Handler_st_t *pHandler, BU91R65_Config_st_t *pstCfg);
extern int32_t BU91R65_Del(BU91R65_Handler_st_t *pHandler);

extern void    BU91R65_Refresh_Service(void);
extern void    BU91R65_Communication_Service(void);

extern int32_t BU91R65_Write_Buffer(BU91R65_Handler_st_t *pHandler, uint8_t u8Index, uint8_t u8Val);
extern int32_t BU91R65_Write_SEG(BU91R65_Handler_st_t *pHandler, uint8_t u8Index, uint8_t u8Val);

#endif /* BU98R10_ACCESS_H__ */
